/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.containers.participant;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractUpdateBaseElementFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class UpdateParticipantFeature
extends AbstractUpdateBaseElementFeature<Participant> {
    public UpdateParticipantFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public IReason updateNeeded(IUpdateContext context) {
        return super.updateNeeded(context);
    }

    public boolean update(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof ContainerShape) {
            ContainerShape containerShape = (ContainerShape)pe;
            DIUtils.updateDIShape((PictogramElement)containerShape);
            Diagram diagram = Graphiti.getPeService().getDiagramForShape((Shape)containerShape);
            Participant businessObject = BusinessObjectUtil.getFirstElementOfType((PictogramElement)containerShape, Participant.class);
            GraphicsAlgorithm rect = containerShape.getGraphicsAlgorithm();
            boolean isPushed = FeatureSupport.hasBpmnDiagram((BaseElement)businessObject);
            boolean isReference = FeatureSupport.isParticipantReference(diagram, businessObject);
            if (isReference) {
                rect.setLineWidth(Integer.valueOf(3));
                rect.setLineStyle(LineStyle.DASH);
                rect.setTransparency(Double.valueOf(0.4));
            } else if (isPushed) {
                rect.setLineWidth(Integer.valueOf(3));
                rect.setLineStyle(LineStyle.SOLID);
                rect.setTransparency(Double.valueOf(0.0));
            } else {
                rect.setLineWidth(Integer.valueOf(1));
                rect.setLineStyle(LineStyle.SOLID);
                rect.setTransparency(Double.valueOf(0.0));
            }
            return true;
        }
        return false;
    }
}

