/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.builder;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

public class BPMN2Nature
implements IProjectNature {
    public static final String NATURE_ID = "org.eclipse.bpmn2.modeler.core.bpmn2Nature";
    public static final String WST_VALIDATION_BUILDER_ID = "org.eclipse.wst.validation.validationbuilder";
    private IProject project;

    public void configure() throws CoreException {
        if (!this.project.hasNature(NATURE_ID)) {
            IProjectDescription description = this.project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = NATURE_ID;
            description.setNatureIds(newNatures);
            this.project.setDescription(description, null);
        }
        this.configureBuilder("org.eclipse.bpmn2.modeler.core.bpmn2Builder");
        this.configureBuilder(WST_VALIDATION_BUILDER_ID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasBuilder(IProject project, String builderId) {
        try {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            int i = 0;
            while (true) {
                if (i >= commands.length) {
                    return false;
                }
                if (commands[i].getBuilderName().equals(builderId)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private void configureBuilder(String builderId) throws CoreException {
        if (!BPMN2Nature.hasBuilder(this.project, builderId)) {
            IProjectDescription desc = this.project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 0, commands.length);
            ICommand command = desc.newCommand();
            command.setBuilderName(builderId);
            newCommands[newCommands.length - 1] = command;
            desc.setBuildSpec(newCommands);
            this.project.setDescription(desc, null);
            this.project.refreshLocal(2, null);
        }
    }

    public void deconfigure() throws CoreException {
        if (this.project.hasNature(NATURE_ID)) {
            IProjectDescription description = this.project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if (NATURE_ID.equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    this.project.setDescription(description, null);
                    return;
                }
                ++i;
            }
        }
        this.deconfigureBuilder("org.eclipse.bpmn2.modeler.core.bpmn2Builder");
    }

    private void deconfigureBuilder(String builderId) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void setBPMN2Nature(IProject project, boolean enable) {
        try {
            BPMN2Nature nature = new BPMN2Nature();
            nature.setProject(project);
            if (enable) {
                nature.configure();
            } else {
                nature.deconfigure();
            }
        }
        catch (CoreException coreException) {}
    }
}

