/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.api.tools.internal.CoreMessages;
import org.eclipse.pde.api.tools.internal.IApiXmlConstants;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FilterStore
implements IApiFilterStore {
    public static final String GLOBAL = "!global!";
    public static IApiProblemFilter[] NO_FILTERS = new IApiProblemFilter[0];
    public static final int CURRENT_STORE_VERSION = 2;
    static final String SETTINGS_FOLDER = ".settings";
    protected HashMap<String, Set<IApiProblemFilter>> fFilterMap = null;
    private BundleComponent fComponent = null;

    public FilterStore() {
    }

    public FilterStore(BundleComponent component) {
        this.fComponent = component;
    }

    @Override
    public void addFilters(IApiProblemFilter[] filters) {
        if (filters != null && filters.length > 0) {
            this.initializeApiFilters();
            Set<IApiProblemFilter> globalFilters = this.fFilterMap.get(GLOBAL);
            if (globalFilters == null) {
                globalFilters = new HashSet<IApiProblemFilter>();
                this.fFilterMap.put(GLOBAL, globalFilters);
            }
            Collections.addAll(globalFilters, filters);
        }
    }

    @Override
    public void addFiltersFor(IApiProblem[] problems) {
        if (problems != null && problems.length > 0) {
            this.initializeApiFilters();
            this.internalAddFilters(problems, null);
        }
    }

    @Override
    public IApiProblemFilter[] getFilters(IResource resource) {
        return null;
    }

    @Override
    public IResource[] getResources() {
        return null;
    }

    @Override
    public boolean removeFilters(IApiProblemFilter[] filters) {
        if (filters != null && filters.length > 0) {
            this.initializeApiFilters();
            boolean removed = true;
            Set<IApiProblemFilter> globalFilters = this.fFilterMap.get(GLOBAL);
            if (globalFilters != null && globalFilters.size() > 0) {
                IApiProblemFilter[] iApiProblemFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    IApiProblemFilter filter = iApiProblemFilterArray[n2];
                    removed &= globalFilters.remove(filter);
                    ++n2;
                }
                return removed;
            }
        }
        return false;
    }

    protected synchronized void initializeApiFilters() {
        if (this.fFilterMap == null) {
            InputStream filterstream;
            ZipFile jarFile;
            block12: {
                this.fFilterMap = new HashMap(5);
                jarFile = null;
                filterstream = null;
                File loc = new File(this.fComponent.getLocation());
                String extension = new Path(loc.getName()).getFileExtension();
                if (extension != null && extension.equals("jar") && loc.isFile()) {
                    jarFile = new ZipFile(loc, 1);
                    ZipEntry filterfile = jarFile.getEntry(".api_filters");
                    if (filterfile != null) {
                        if (ApiPlugin.DEBUG_FILTER_STORE) {
                            System.out.println("found api filter file: [" + this.fComponent.getName() + "] inside jar file " + loc);
                        }
                        filterstream = jarFile.getInputStream(filterfile);
                    }
                } else {
                    File file = new File(loc, SETTINGS_FOLDER + File.separator + ".api_filters");
                    if (file.exists()) {
                        if (ApiPlugin.DEBUG_FILTER_STORE) {
                            System.out.println("found api filter file: [" + this.fComponent.getName() + "] at " + file);
                        }
                        filterstream = new FileInputStream(file);
                    }
                }
                if (filterstream != null) break block12;
                BundleComponent.closingZipFileAndStream(filterstream, jarFile);
                return;
            }
            try {
                try {
                    this.readFilterFile(filterstream);
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                    BundleComponent.closingZipFileAndStream(filterstream, jarFile);
                }
            }
            catch (Throwable throwable) {
                BundleComponent.closingZipFileAndStream(filterstream, jarFile);
                throw throwable;
            }
            BundleComponent.closingZipFileAndStream(filterstream, jarFile);
        }
    }

    @Override
    public boolean isFiltered(IApiProblem problem) {
        this.initializeApiFilters();
        if (this.fFilterMap == null || this.fFilterMap.isEmpty()) {
            return false;
        }
        Set<IApiProblemFilter> globalFilters = this.fFilterMap.get(GLOBAL);
        if (globalFilters == null) {
            return false;
        }
        for (IApiProblemFilter filter : globalFilters) {
            if (!this.problemsMatch(filter.getUnderlyingProblem(), problem)) continue;
            if (ApiPlugin.DEBUG_FILTER_STORE) {
                System.out.println("filter used: [" + filter.toString() + "]");
            }
            return true;
        }
        return false;
    }

    protected boolean problemsMatch(IApiProblem filterProblem, IApiProblem problem) {
        if (problem.getId() == filterProblem.getId()) {
            String problemPath = problem.getResourcePath();
            String filterProblemPath = filterProblem.getResourcePath();
            if (problemPath != null && filterProblemPath != null && !new Path(problemPath).equals((Object)new Path(filterProblemPath))) {
                return false;
            }
            String problemTypeName = problem.getTypeName();
            String filterProblemTypeName = filterProblem.getTypeName();
            if (problemTypeName == null) {
                if (filterProblemTypeName != null) {
                    return false;
                }
            } else {
                if (filterProblemTypeName == null) {
                    return false;
                }
                if (!problemTypeName.equals(filterProblemTypeName)) {
                    return false;
                }
            }
            return this.argumentsEquals(problem.getMessageArguments(), filterProblem.getMessageArguments());
        }
        return false;
    }

    private boolean argumentsEquals(String[] problemMessageArguments, String[] filterProblemMessageArguments) {
        int length = problemMessageArguments.length;
        if (length == filterProblemMessageArguments.length) {
            int i = 0;
            while (i < length) {
                String problemMessageArgument = problemMessageArguments[i];
                String filterProblemMessageArgument = filterProblemMessageArguments[i];
                if (!problemMessageArgument.equals(filterProblemMessageArgument)) {
                    int index = problemMessageArgument.lastIndexOf(46);
                    int filterProblemIndex = filterProblemMessageArgument.lastIndexOf(46);
                    if (index == -1) {
                        if (filterProblemIndex == -1) {
                            return false;
                        }
                        if (!filterProblemMessageArgument.substring(filterProblemIndex + 1).equals(problemMessageArgument)) {
                            return false;
                        }
                    } else {
                        if (filterProblemIndex != -1) {
                            return false;
                        }
                        if (!problemMessageArgument.substring(index + 1).equals(filterProblemMessageArgument)) {
                            return false;
                        }
                    }
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        if (this.fFilterMap != null) {
            this.fFilterMap.clear();
            this.fFilterMap = null;
        }
    }

    protected void readFilterFile(InputStream contents) throws IOException {
        if (contents == null) {
            throw new IOException(CoreMessages.FilterStore_0);
        }
        String xml = new String(Util.getInputStreamAsCharArray(contents, StandardCharsets.UTF_8));
        Element root = null;
        try {
            root = Util.parseDocument(xml);
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce);
        }
        if (root == null) {
            return;
        }
        if (!root.getNodeName().equals("component")) {
            return;
        }
        String component = root.getAttribute("id");
        if (component.length() == 0) {
            return;
        }
        String versionValue = root.getAttribute("version");
        int currentVersion = Integer.parseInt(IApiXmlConstants.API_FILTER_STORE_CURRENT_VERSION);
        int version = 0;
        if (versionValue.length() != 0) {
            try {
                version = Integer.parseInt(versionValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (version != currentVersion) {
            return;
        }
        NodeList resources = root.getElementsByTagName("resource");
        ArrayList<IApiProblem> newfilters = new ArrayList<IApiProblem>();
        ArrayList<String> comments = new ArrayList<String>();
        int i = 0;
        while (i < resources.getLength()) {
            String path;
            Element element = (Element)resources.item(i);
            String typeName = element.getAttribute("type");
            if (typeName.length() == 0) {
                typeName = null;
            }
            if ((path = element.getAttribute("path")).trim().length() == 0) {
                path = null;
            }
            NodeList filters = element.getElementsByTagName("filter");
            int j = 0;
            while (j < filters.getLength()) {
                element = (Element)filters.item(j);
                int id = this.loadIntegerAttribute(element, "id");
                if (id > 0) {
                    String comment;
                    String[] messageargs = null;
                    NodeList elements = element.getElementsByTagName("message_arguments");
                    if (elements.getLength() == 1) {
                        Element messageArguments = (Element)elements.item(0);
                        NodeList arguments = messageArguments.getElementsByTagName("message_argument");
                        int length = arguments.getLength();
                        messageargs = new String[length];
                        int k = 0;
                        while (k < length) {
                            Element messageArgument = (Element)arguments.item(k);
                            messageargs[k] = messageArgument.getAttribute("value");
                            ++k;
                        }
                    }
                    comments.add((comment = element.getAttribute("comment")).length() < 1 ? null : comment);
                    newfilters.add(ApiProblemFactory.newApiProblem(path, typeName, messageargs, null, null, -1, -1, -1, id));
                }
                ++j;
            }
            ++i;
        }
        if (ApiPlugin.DEBUG_FILTER_STORE) {
            System.out.println(String.valueOf(newfilters.size()) + " filters found and added for: [" + component + "]");
        }
        this.internalAddFilters(newfilters.toArray(new IApiProblem[newfilters.size()]), comments.toArray(new String[comments.size()]));
        newfilters.clear();
    }

    protected void internalAddFilters(IApiProblem[] problems, String[] comments) {
        if (problems == null || problems.length == 0) {
            return;
        }
        Set<IApiProblemFilter> globalFilters = this.fFilterMap.get(GLOBAL);
        if (globalFilters == null) {
            globalFilters = new HashSet<IApiProblemFilter>();
            this.fFilterMap.put(GLOBAL, globalFilters);
        }
        int i = 0;
        while (i < problems.length) {
            IApiProblem problem = problems[i];
            String comment = comments != null ? comments[i] : null;
            ApiProblemFilter filter = new ApiProblemFilter(this.fComponent.getSymbolicName(), problem, comment);
            globalFilters.add(filter);
            ++i;
        }
    }

    protected int loadIntegerAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if (value.length() == 0) {
            return -1;
        }
        try {
            int number = Integer.parseInt(value);
            return number;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

