/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptorList;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AndNoShortCircuitNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.MatchingClauseNode;
import org.apache.derby.impl.sql.compile.OperatorNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TestConstraintNode;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;

abstract class DMLModStatementNode
extends DMLStatementNode {
    protected FromVTI targetVTI;
    protected TableName targetTableName;
    protected ResultColumnList resultColumnList;
    protected int lockMode;
    protected FKInfo[] fkInfo;
    protected TriggerInfo triggerInfo;
    TableDescriptor targetTableDescriptor;
    public IndexRowGenerator[] indicesToMaintain;
    public long[] indexConglomerateNumbers;
    public String[] indexNames;
    protected ConstraintDescriptorList relevantCdl;
    protected TriggerDescriptorList relevantTriggers;
    private boolean requiresDeferredProcessing;
    private int statementType;
    private boolean bound;
    private ValueNode checkConstraints;
    protected String[] fkTableNames;
    protected int[] fkRefActions;
    protected ColumnDescriptorList[] fkColDescriptors;
    protected long[] fkIndexConglomNumbers;
    protected boolean isDependentTable;
    protected int[][] fkColArrays;
    protected TableName synonymTableName;
    protected MatchingClauseNode matchingClause;
    Set<String> dependentTables;

    DMLModStatementNode(ResultSetNode resultSetNode, MatchingClauseNode matchingClauseNode, ContextManager contextManager) {
        super(resultSetNode, contextManager);
        this.matchingClause = matchingClauseNode;
        this.statementType = this.getStatementType();
    }

    DMLModStatementNode(ResultSetNode resultSetNode, MatchingClauseNode matchingClauseNode, int n, ContextManager contextManager) {
        super(resultSetNode, contextManager);
        this.matchingClause = matchingClauseNode;
        this.statementType = n;
    }

    public boolean inMatchingClause() {
        return this.matchingClause != null;
    }

    void setTarget(QueryTreeNode queryTreeNode) {
        if (queryTreeNode instanceof TableName) {
            this.targetTableName = (TableName)queryTreeNode;
        } else {
            this.targetVTI = (FromVTI)queryTreeNode;
            this.targetVTI.setTarget();
        }
    }

    protected void generateCodeForTemporaryTable(ActivationClassBuilder activationClassBuilder) throws StandardException {
        if (this.targetTableDescriptor != null && this.targetTableDescriptor.getTableType() == 3 && this.targetTableDescriptor.isOnRollbackDeleteRows()) {
            MethodBuilder methodBuilder = activationClassBuilder.getExecuteMethod();
            methodBuilder.pushThis();
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Activation", "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
            methodBuilder.push(this.targetTableDescriptor.getName());
            methodBuilder.callMethod((short)185, null, "markTempTableAsModifiedInUnitOfWork", "void", 1);
            methodBuilder.endStatement();
        }
    }

    void verifyTargetTable() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.targetTableName != null) {
            SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.targetTableName.getSchemaName());
            this.targetTableDescriptor = this.getTableDescriptor(this.targetTableName.getTableName(), schemaDescriptor);
            if (this.targetTableDescriptor == null) {
                TableName tableName = this.resolveTableToSynonym(this.targetTableName);
                if (tableName == null) {
                    throw StandardException.newException("42X05", this.targetTableName);
                }
                this.synonymTableName = this.targetTableName;
                this.targetTableName = tableName;
                schemaDescriptor = this.getSchemaDescriptor(this.targetTableName.getSchemaName());
                this.targetTableDescriptor = this.getTableDescriptor(tableName.getTableName(), schemaDescriptor);
                if (this.targetTableDescriptor == null) {
                    throw StandardException.newException("42X05", this.targetTableName);
                }
            }
            this.targetTableName.setSchemaName(schemaDescriptor.getSchemaName());
            switch (this.targetTableDescriptor.getTableType()) {
                case 2: {
                    throw StandardException.newException("42Y24", this.targetTableName);
                }
                case 1: 
                case 5: {
                    throw StandardException.newException("42Y25", this.targetTableName);
                }
            }
            this.targetTableDescriptor = this.lockTableForCompilation(this.targetTableDescriptor);
            this.getCompilerContext().createDependency(this.targetTableDescriptor);
        } else {
            FromList fromList = new FromList(this.getContextManager());
            this.targetVTI = (FromVTI)this.targetVTI.bindNonVTITables(dataDictionary, fromList);
            this.targetVTI = (FromVTI)this.targetVTI.bindVTITables(fromList);
        }
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    SchemaDescriptor getSchemaDescriptor() throws StandardException {
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.targetTableName.getSchemaName());
        return schemaDescriptor;
    }

    static int[] getReadColMap(int n, FormatableBitSet formatableBitSet) {
        if (formatableBitSet == null) {
            return null;
        }
        int n2 = 0;
        int[] nArray = new int[n];
        int n3 = formatableBitSet.size();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n3 > i && formatableBitSet.get(i + 1) ? n2++ : -1;
        }
        return nArray;
    }

    protected void getResultColumnList() throws StandardException {
        if (this.targetVTI == null) {
            this.getResultColumnList(null);
        } else {
            this.resultColumnList = this.targetVTI.getResultColumns();
        }
    }

    protected FromBaseTable getResultColumnList(ResultColumnList resultColumnList) throws StandardException {
        FromBaseTable fromBaseTable = new FromBaseTable(this.synonymTableName != null ? this.synonymTableName : this.targetTableName, null, null, null, this.getContextManager());
        if (this.inMatchingClause()) {
            fromBaseTable.setMergeTableID(2);
        }
        fromBaseTable.bindNonVTITables(this.getDataDictionary(), new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()));
        this.getResultColumnList(fromBaseTable, resultColumnList);
        return fromBaseTable;
    }

    private void getResultColumnList(FromBaseTable fromBaseTable, ResultColumnList resultColumnList) throws StandardException {
        if (resultColumnList == null) {
            this.resultColumnList = fromBaseTable.getAllResultColumns(null);
            this.resultColumnList.bindResultColumnsByPosition(this.targetTableDescriptor);
        } else {
            this.resultColumnList = fromBaseTable.getResultColumnsForList(null, resultColumnList, fromBaseTable.getTableNameField());
            this.resultColumnList.bindResultColumnsByName(this.targetTableDescriptor, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseAndBindGenerationClauses(DataDictionary dataDictionary, TableDescriptor tableDescriptor, ResultColumnList resultColumnList, ResultColumnList resultColumnList2, boolean bl, ResultSetNode resultSetNode) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        int n = resultColumnList2.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList2.elementAt(i);
            if (bl && !resultColumn.updated() || !resultColumn.hasGenerationClause()) continue;
            ColumnDescriptor columnDescriptor = resultColumn.getTableColumnDescriptor();
            DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
            DefaultInfo defaultInfo = columnDescriptor.getDefaultInfo();
            ValueNode valueNode = this.parseGenerationClause(defaultInfo.getDefaultText(), tableDescriptor);
            valueNode = new CastNode(valueNode, dataTypeDescriptor, this.getContextManager());
            ((CastNode)valueNode).setAssignmentSemantics();
            compilerContext.pushCompilationSchema(this.getSchemaDescriptor(defaultInfo.getOriginalCurrentSchema(), false));
            try {
                DMLModStatementNode.bindRowScopedExpression(this.getOptimizerFactory(), this.getContextManager(), tableDescriptor, resultColumnList, valueNode);
            }
            finally {
                compilerContext.popCompilationSchema();
            }
            ResultColumn resultColumn2 = new ResultColumn(valueNode.getTypeServices(), valueNode, this.getContextManager());
            resultColumn2.setVirtualColumnId(i + 1);
            resultColumn2.setColumnDescriptor(tableDescriptor, columnDescriptor);
            resultColumnList2.setElementAt(resultColumn2, i);
            if (!bl) continue;
            for (int j = 0; j < resultColumnList.size(); ++j) {
                if (resultColumn != resultColumnList.elementAt(j)) continue;
                resultColumn2.setName(resultColumn.getName());
                resultColumn2.setResultSetNumber(resultSetNode.getResultSetNumber());
                resultColumnList.setElementAt(resultColumn2, j);
            }
        }
    }

    public ValueNode parseGenerationClause(String string, TableDescriptor tableDescriptor) throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        String string2 = "SELECT " + string + " FROM " + tableDescriptor.getQualifiedName();
        CompilerContext compilerContext = languageConnectionContext.pushCompilerContext();
        Parser parser = compilerContext.getParser();
        Visitable visitable = parser.parseStatement(string2);
        ValueNode valueNode = ((ResultColumn)((CursorNode)visitable).getResultSetNode().getResultColumns().elementAt(0)).getExpression();
        languageConnectionContext.popCompilerContext(compilerContext);
        return valueNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ValueNode bindConstraints(DataDictionary dataDictionary, OptimizerFactory optimizerFactory, TableDescriptor tableDescriptor, Dependent dependent, ResultColumnList resultColumnList, int[] nArray, FormatableBitSet formatableBitSet, boolean bl, boolean[] blArray) throws StandardException {
        block7: {
            this.bound = true;
            if (this.targetVTI != null) {
                return null;
            }
            CompilerContext compilerContext = this.getCompilerContext();
            compilerContext.pushCurrentPrivType(-1);
            try {
                this.getAllRelevantConstraints(dataDictionary, tableDescriptor, nArray);
                this.createConstraintDependencies(dataDictionary, this.relevantCdl, dependent);
                this.generateFKInfo(this.relevantCdl, dataDictionary, tableDescriptor, formatableBitSet);
                this.getAllRelevantTriggers(dataDictionary, tableDescriptor, nArray, bl);
                this.createTriggerDependencies(this.relevantTriggers, dependent);
                this.generateTriggerInfo(this.relevantTriggers);
                this.checkConstraints = this.generateCheckTree(this.relevantCdl, tableDescriptor, blArray);
                if (this.checkConstraints == null) break block7;
                SchemaDescriptor schemaDescriptor = tableDescriptor.getSchemaDescriptor();
                compilerContext.pushCompilationSchema(schemaDescriptor);
                try {
                    DMLModStatementNode.bindRowScopedExpression(optimizerFactory, this.getContextManager(), tableDescriptor, resultColumnList, this.checkConstraints);
                }
                finally {
                    compilerContext.popCompilationSchema();
                }
            }
            finally {
                compilerContext.popCurrentPrivType();
            }
        }
        return this.checkConstraints;
    }

    static void bindRowScopedExpression(OptimizerFactory optimizerFactory, ContextManager contextManager, TableDescriptor tableDescriptor, ResultColumnList resultColumnList, ValueNode valueNode) throws StandardException {
        TableName tableName = DMLModStatementNode.makeTableName(contextManager, tableDescriptor.getSchemaName(), tableDescriptor.getName());
        FromList fromList = new FromList(optimizerFactory.doJoinOrderOptimization(), contextManager);
        FromBaseTable fromBaseTable = new FromBaseTable(tableName, null, resultColumnList, null, contextManager);
        fromBaseTable.setTableNumber(0);
        fromList.addFromTable(fromBaseTable);
        valueNode.bindExpression(fromList, null, null);
    }

    protected boolean hasCheckConstraints(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
        if (constraintDescriptorList == null) {
            return false;
        }
        ConstraintDescriptorList constraintDescriptorList2 = constraintDescriptorList.getSubList(4);
        return constraintDescriptorList2.size() > 0;
    }

    protected boolean hasGenerationClauses(TableDescriptor tableDescriptor) throws StandardException {
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getGeneratedColumns();
        return columnDescriptorList.size() > 0;
    }

    private ValueNode generateCheckTree(ConstraintDescriptorList constraintDescriptorList, TableDescriptor tableDescriptor, boolean[] blArray) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList2 = constraintDescriptorList.getSubList(4);
        int n = constraintDescriptorList2.size();
        OperatorNode operatorNode = null;
        for (ConstraintDescriptor constraintDescriptor : constraintDescriptorList2) {
            if (!constraintDescriptor.deferrable()) continue;
            blArray[0] = true;
            break;
        }
        for (int i = 0; i < n; ++i) {
            ConstraintDescriptor constraintDescriptor;
            constraintDescriptor = constraintDescriptorList2.elementAt(i);
            String string = constraintDescriptor.getConstraintText();
            ValueNode valueNode = this.parseCheckConstraint(string, tableDescriptor);
            TestConstraintNode testConstraintNode = new TestConstraintNode(valueNode, "23513", tableDescriptor.getQualifiedName(), constraintDescriptor, this.getContextManager());
            operatorNode = operatorNode == null ? testConstraintNode : (blArray[0] ? new AndNoShortCircuitNode(testConstraintNode, operatorNode, this.getContextManager()) : new AndNode(testConstraintNode, operatorNode, this.getContextManager()));
        }
        return operatorNode;
    }

    private void generateFKInfo(ConstraintDescriptorList constraintDescriptorList, DataDictionary dataDictionary, TableDescriptor tableDescriptor, FormatableBitSet formatableBitSet) throws StandardException {
        int n;
        ArrayList<FKInfo> arrayList = new ArrayList<FKInfo>();
        ConstraintDescriptorList constraintDescriptorList2 = dataDictionary.getActiveConstraintDescriptors(constraintDescriptorList);
        int[] nArray = this.getRowMap(formatableBitSet, tableDescriptor);
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        ArrayList<Long> arrayList3 = new ArrayList<Long>(1);
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>(1);
        ArrayList<ColumnDescriptorList> arrayList5 = new ArrayList<ColumnDescriptorList>(1);
        ArrayList<int[]> arrayList6 = new ArrayList<int[]>(1);
        int n2 = constraintDescriptorList2.size();
        for (n = 0; n < n2; ++n) {
            Object object;
            Object object2;
            Object object3;
            int[] nArray2;
            boolean[] blArray;
            String[] stringArray;
            long[] lArray;
            UUID[] uUIDArray;
            boolean[] blArray2;
            UUID[] uUIDArray2;
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor;
            int n3;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList2.elementAt(n);
            if (constraintDescriptor instanceof ForeignKeyConstraintDescriptor) {
                n3 = 1;
                referencedKeyConstraintDescriptor = ((ForeignKeyConstraintDescriptor)constraintDescriptor).getReferencedConstraint();
                uUIDArray2 = new UUID[1];
                blArray2 = new boolean[1];
                uUIDArray = new UUID[1];
                lArray = new long[1];
                stringArray = new String[1];
                blArray = new boolean[1];
                nArray2 = new int[1];
                this.fkSetupArrays(dataDictionary, (ForeignKeyConstraintDescriptor)constraintDescriptor, 0, uUIDArray2, lArray, stringArray, blArray, nArray2, blArray2, uUIDArray);
                stringArray[0] = constraintDescriptor.getConstraintName();
            } else {
                if (!(constraintDescriptor instanceof ReferencedKeyConstraintDescriptor)) continue;
                referencedKeyConstraintDescriptor = (ReferencedKeyConstraintDescriptor)constraintDescriptor;
                n3 = 2;
                ConstraintDescriptorList constraintDescriptorList3 = dataDictionary.getActiveConstraintDescriptors(((ReferencedKeyConstraintDescriptor)constraintDescriptor).getForeignKeyConstraints(1));
                int n4 = constraintDescriptorList3.size();
                if (n4 == 0) continue;
                uUIDArray2 = new UUID[n4];
                blArray2 = new boolean[n4];
                uUIDArray = new UUID[n4];
                stringArray = new String[n4];
                lArray = new long[n4];
                blArray = new boolean[n4];
                nArray2 = new int[n4];
                int[] nArray3 = this.remapReferencedColumns(constraintDescriptor, nArray);
                for (int i = 0; i < n4; ++i) {
                    ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptorList3.elementAt(i);
                    this.fkSetupArrays(dataDictionary, foreignKeyConstraintDescriptor, i, uUIDArray2, lArray, stringArray, blArray, nArray2, blArray2, uUIDArray);
                    if (nArray2[i] != 0 && nArray2[i] != 3) continue;
                    object3 = foreignKeyConstraintDescriptor.getTableDescriptor();
                    arrayList2.add(((TableDescriptor)object3).getSchemaName() + "." + ((TableDescriptor)object3).getName());
                    arrayList4.add(nArray2[i]);
                    object2 = foreignKeyConstraintDescriptor.getReferencedColumns();
                    object = ((TableDescriptor)object3).getColumnDescriptorList();
                    ColumnDescriptorList columnDescriptorList = new ColumnDescriptorList();
                    for (int j = 0; j < ((Object)object2).length; ++j) {
                        ColumnDescriptor columnDescriptor = ((ColumnDescriptorList)object).elementAt((int)(object2[j] - true));
                        columnDescriptorList.add(columnDescriptor);
                    }
                    arrayList5.add(columnDescriptorList);
                    arrayList3.add(lArray[i]);
                    arrayList6.add(nArray3);
                }
            }
            TableDescriptor tableDescriptor2 = referencedKeyConstraintDescriptor.getTableDescriptor();
            object3 = referencedKeyConstraintDescriptor.getIndexId();
            object = tableDescriptor2.getConglomerateDescriptor((UUID)object3);
            object2 = constraintDescriptor.getTableDescriptor();
            arrayList.add(new FKInfo(stringArray, constraintDescriptor.getSchemaDescriptor().getSchemaName(), ((TableDescriptor)object2).getName(), this.statementType, n3, (UUID)object3, ((ConglomerateDescriptor)object).getConglomerateNumber(), referencedKeyConstraintDescriptor.getUUID(), referencedKeyConstraintDescriptor.deferrable(), uUIDArray2, lArray, blArray, this.remapReferencedColumns(constraintDescriptor, nArray), dataDictionary.getRowLocationTemplate(this.getLanguageConnectionContext(), (TableDescriptor)object2), nArray2, blArray2, uUIDArray));
        }
        if (!arrayList.isEmpty()) {
            this.fkInfo = arrayList.toArray(new FKInfo[arrayList.size()]);
        }
        if ((n = arrayList4.size()) > 0) {
            this.fkTableNames = new String[n];
            this.fkRefActions = new int[n];
            this.fkColDescriptors = new ColumnDescriptorList[n];
            this.fkIndexConglomNumbers = new long[n];
            this.fkColArrays = new int[n][];
            for (int i = 0; i < n; ++i) {
                this.fkTableNames[i] = (String)arrayList2.get(i);
                this.fkRefActions[i] = (Integer)arrayList4.get(i);
                this.fkColDescriptors[i] = (ColumnDescriptorList)arrayList5.get(i);
                this.fkIndexConglomNumbers[i] = (Long)arrayList3.get(i);
                this.fkColArrays[i] = (int[])arrayList6.get(i);
            }
        }
    }

    private void fkSetupArrays(DataDictionary dataDictionary, ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor, int n, UUID[] uUIDArray, long[] lArray, String[] stringArray, boolean[] blArray, int[] nArray, boolean[] blArray2, UUID[] uUIDArray2) throws StandardException {
        stringArray[n] = foreignKeyConstraintDescriptor.getConstraintName();
        uUIDArray[n] = foreignKeyConstraintDescriptor.getIndexId();
        blArray2[n] = foreignKeyConstraintDescriptor.deferrable();
        uUIDArray2[n] = foreignKeyConstraintDescriptor.getUUID();
        lArray[n] = foreignKeyConstraintDescriptor.getIndexConglomerateDescriptor(dataDictionary).getConglomerateNumber();
        blArray[n] = foreignKeyConstraintDescriptor.isSelfReferencingFK();
        if (this.statementType == 4) {
            nArray[n] = foreignKeyConstraintDescriptor.getRaDeleteRule();
        } else if (this.statementType == 3) {
            nArray[n] = foreignKeyConstraintDescriptor.getRaUpdateRule();
        }
    }

    private void generateTriggerInfo(TriggerDescriptorList triggerDescriptorList) {
        if (triggerDescriptorList != null && !triggerDescriptorList.isEmpty()) {
            this.triggerInfo = new TriggerInfo(triggerDescriptorList);
        }
    }

    FKInfo[] getFKInfo() {
        return this.fkInfo;
    }

    TriggerInfo getTriggerInfo() {
        return this.triggerInfo;
    }

    ValueNode getCheckConstraints() {
        return this.checkConstraints;
    }

    private void createTriggerDependencies(TriggerDescriptorList triggerDescriptorList, Dependent dependent) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        for (TriggerDescriptor triggerDescriptor : triggerDescriptorList) {
            if (dependent == null) {
                compilerContext.createDependency(triggerDescriptor);
                continue;
            }
            compilerContext.createDependency(dependent, triggerDescriptor);
        }
    }

    protected TriggerDescriptorList getAllRelevantTriggers(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int[] nArray, boolean bl) throws StandardException {
        if (this.relevantTriggers != null) {
            return this.relevantTriggers;
        }
        this.relevantTriggers = new TriggerDescriptorList();
        if (!bl) {
            return this.relevantTriggers;
        }
        tableDescriptor.getAllRelevantTriggers(this.statementType, nArray, this.relevantTriggers);
        this.adjustDeferredFlag(this.relevantTriggers.size() > 0);
        return this.relevantTriggers;
    }

    protected void adjustDeferredFlag(boolean bl) {
        if (!this.requiresDeferredProcessing) {
            this.requiresDeferredProcessing = bl;
        }
    }

    private void createConstraintDependencies(DataDictionary dataDictionary, ConstraintDescriptorList constraintDescriptorList, Dependent dependent) throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        int n = constraintDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (dependent == null) {
                compilerContext.createDependency(constraintDescriptor);
            } else {
                compilerContext.createDependency(dependent, constraintDescriptor);
            }
            if (constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) {
                object = dataDictionary.getActiveConstraintDescriptors(((ReferencedKeyConstraintDescriptor)constraintDescriptor).getForeignKeyConstraints(1));
                int n2 = ((ArrayList)object).size();
                for (int j = 0; j < n2; ++j) {
                    ConstraintDescriptor constraintDescriptor2 = ((ConstraintDescriptorList)object).elementAt(j);
                    if (dependent == null) {
                        compilerContext.createDependency(constraintDescriptor2);
                        compilerContext.createDependency(constraintDescriptor2.getTableDescriptor());
                        continue;
                    }
                    compilerContext.createDependency(dependent, constraintDescriptor2);
                    compilerContext.createDependency(dependent, constraintDescriptor2.getTableDescriptor());
                }
                continue;
            }
            if (!(constraintDescriptor instanceof ForeignKeyConstraintDescriptor)) continue;
            object = (ForeignKeyConstraintDescriptor)constraintDescriptor;
            if (dependent == null) {
                compilerContext.createDependency(((ForeignKeyConstraintDescriptor)object).getReferencedConstraint().getTableDescriptor());
                continue;
            }
            compilerContext.createDependency(dependent, ((ForeignKeyConstraintDescriptor)object).getReferencedConstraint().getTableDescriptor());
        }
    }

    protected ConstraintDescriptorList getAllRelevantConstraints(DataDictionary dataDictionary, TableDescriptor tableDescriptor, int[] nArray) throws StandardException {
        if (this.relevantCdl != null) {
            return this.relevantCdl;
        }
        boolean[] blArray = new boolean[1];
        this.relevantCdl = new ConstraintDescriptorList();
        blArray[0] = this.requiresDeferredProcessing;
        tableDescriptor.getAllRelevantConstraints(this.statementType, nArray, blArray, this.relevantCdl);
        this.adjustDeferredFlag(blArray[0]);
        return this.relevantCdl;
    }

    boolean requiresDeferredProcessing() {
        return this.requiresDeferredProcessing;
    }

    public ValueNode parseCheckConstraint(String string, TableDescriptor tableDescriptor) throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        String string2 = "SELECT * FROM " + tableDescriptor.getQualifiedName() + " WHERE " + string;
        CompilerContext compilerContext = languageConnectionContext.pushCompilerContext();
        Parser parser = compilerContext.getParser();
        Visitable visitable = parser.parseStatement(string2);
        ValueNode valueNode = ((SelectNode)((CursorNode)visitable).getResultSetNode()).getWhereClause();
        languageConnectionContext.popCompilerContext(compilerContext);
        return valueNode;
    }

    public void generateCheckConstraints(ValueNode valueNode, ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (valueNode == null) {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder methodBuilder2 = this.generateCheckConstraints(valueNode, expressionClassBuilder);
            expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        }
    }

    public MethodBuilder generateCheckConstraints(ValueNode valueNode, ExpressionClassBuilder expressionClassBuilder) throws StandardException {
        MethodBuilder methodBuilder = expressionClassBuilder.newUserExprFun();
        valueNode.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.methodReturn();
        methodBuilder.complete();
        return methodBuilder;
    }

    public void generateGenerationClauses(ResultColumnList resultColumnList, int n, boolean bl, ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        boolean bl2 = false;
        for (ResultColumn resultColumn : resultColumnList) {
            if (!resultColumn.hasGenerationClause()) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            methodBuilder.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder methodBuilder2 = this.generateGenerationClauses(resultColumnList, n, bl, expressionClassBuilder);
            expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        }
    }

    private MethodBuilder generateGenerationClauses(ResultColumnList resultColumnList, int n, boolean bl, ExpressionClassBuilder expressionClassBuilder) throws StandardException {
        MethodBuilder methodBuilder = expressionClassBuilder.newUserExprFun();
        methodBuilder.pushThis();
        methodBuilder.push(n);
        methodBuilder.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getCurrentRow", "org.apache.derby.iapi.sql.Row", 1);
        int n2 = resultColumnList.size();
        int n3 = 0;
        if (bl) {
            n3 = n2 - 1;
            n3 /= 2;
        }
        for (int i = n3; i < n2; ++i) {
            ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(i);
            if (!resultColumn.hasGenerationClause()) continue;
            methodBuilder.dup();
            methodBuilder.push(i + 1);
            if (this.inMatchingClause()) {
                CollectNodesVisitor<ColumnReference> collectNodesVisitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
                resultColumn.accept(collectNodesVisitor);
                for (ColumnReference columnReference : collectNodesVisitor.getList()) {
                    columnReference.getSource().setResultSetNumber(n);
                }
            }
            resultColumn.generateExpression(expressionClassBuilder, methodBuilder);
            methodBuilder.cast("org.apache.derby.iapi.types.DataValueDescriptor");
            methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
        }
        methodBuilder.methodReturn();
        methodBuilder.complete();
        return methodBuilder;
    }

    @Override
    public void optimizeStatement() throws StandardException {
        if (!this.inMatchingClause()) {
            super.optimizeStatement();
        } else if (this instanceof UpdateNode) {
            this.resultSet = this.resultSet.preprocess(this.getCompilerContext().getNumTables(), null, null);
        }
        this.lockMode = 6;
    }

    protected void getAffectedIndexes(TableDescriptor tableDescriptor, ResultColumnList resultColumnList, FormatableBitSet formatableBitSet) throws StandardException {
        ArrayList<ConglomerateDescriptor> arrayList = new ArrayList<ConglomerateDescriptor>();
        DMLModStatementNode.getXAffectedIndexes(tableDescriptor, resultColumnList, formatableBitSet, arrayList);
        this.markAffectedIndexes(arrayList);
    }

    static void getXAffectedIndexes(TableDescriptor tableDescriptor, ResultColumnList resultColumnList, FormatableBitSet formatableBitSet, List<ConglomerateDescriptor> list) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        long[] lArray = new long[conglomerateDescriptorArray.length - 1];
        int n = 0;
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i];
            if (!conglomerateDescriptor.isIndex() || resultColumnList != null && !resultColumnList.updateOverlaps(conglomerateDescriptor.getIndexDescriptor().baseColumnPositions())) continue;
            if (list != null) {
                int n2;
                for (n2 = 0; n2 < n && lArray[n2] != conglomerateDescriptor.getConglomerateNumber(); ++n2) {
                }
                if (n2 == n) {
                    lArray[n++] = conglomerateDescriptor.getConglomerateNumber();
                    list.add(conglomerateDescriptor);
                }
            }
            IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
            int[] nArray = indexRowGenerator.baseColumnPositions();
            if (formatableBitSet == null) continue;
            for (int j = 0; j < nArray.length; ++j) {
                formatableBitSet.set(nArray[j]);
            }
        }
    }

    protected void markAffectedIndexes(List<ConglomerateDescriptor> list) throws StandardException {
        int n = list.size();
        CompilerContext compilerContext = this.getCompilerContext();
        this.indicesToMaintain = new IndexRowGenerator[n];
        this.indexConglomerateNumbers = new long[n];
        this.indexNames = new String[n];
        for (int i = 0; i < n; ++i) {
            ConglomerateDescriptor conglomerateDescriptor = list.get(i);
            this.indicesToMaintain[i] = conglomerateDescriptor.getIndexDescriptor();
            this.indexConglomerateNumbers[i] = conglomerateDescriptor.getConglomerateNumber();
            this.indexNames[i] = conglomerateDescriptor.isConstraint() ? null : conglomerateDescriptor.getConglomerateName();
            compilerContext.createDependency(conglomerateDescriptor);
        }
    }

    @Override
    String statementToString() {
        return "DML MOD";
    }

    private int[] remapReferencedColumns(ConstraintDescriptor constraintDescriptor, int[] nArray) {
        int[] nArray2 = constraintDescriptor.getReferencedColumns();
        if (nArray == null) {
            return nArray2;
        }
        int[] nArray3 = new int[nArray2.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray3[i] = nArray[nArray2[i]];
        }
        return nArray3;
    }

    private int[] getRowMap(FormatableBitSet formatableBitSet, TableDescriptor tableDescriptor) throws StandardException {
        if (formatableBitSet == null) {
            return null;
        }
        int n = tableDescriptor.getMaxColumnID();
        int[] nArray = new int[n + 1];
        int n2 = 1;
        for (int i = 1; i <= n; ++i) {
            if (!formatableBitSet.get(i)) continue;
            nArray[i] = n2++;
        }
        return nArray;
    }

    @Override
    void setRefActionInfo(long l, int[] nArray, String string, boolean bl) {
        this.resultSet.setRefActionInfo(l, nArray, string, bl);
    }

    void normalizeSynonymColumns(ResultColumnList resultColumnList, TableName tableName) throws StandardException {
        if (this.synonymTableName == null) {
            return;
        }
        String string = this.synonymTableName.getTableName();
        for (ResultColumn resultColumn : resultColumnList) {
            String string2;
            ColumnReference columnReference = resultColumn.getReference();
            if (columnReference == null || (string2 = columnReference.getTableName()) == null) continue;
            if (string.equals(string2)) {
                columnReference.setQualifiedTableName(tableName);
                continue;
            }
            throw StandardException.newException("42X55", string, string2);
        }
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.targetTableName != null) {
            this.targetTableName = (TableName)this.targetTableName.accept(visitor);
        }
        if (this.synonymTableName != null) {
            this.synonymTableName = (TableName)this.synonymTableName.accept(visitor);
        }
    }
}

