/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SpatialHash<T> {
    private static final int INITIAL_BUCKET_SIZE = 10;
    private final int cellSize;
    private final int gridSize;
    private final Entry<T>[][] table;
    private int size;

    public SpatialHash(int cellSize, int gridSize) {
        this.cellSize = cellSize;
        this.gridSize = gridSize;
        this.table = this.newTable(gridSize * gridSize);
    }

    public Set<T> get(int x1, int y1, int x2, int y2) {
        int x1Index = Math.floorDiv(x1, this.cellSize);
        int y1Index = Math.floorDiv(y1, this.cellSize);
        int x2Index = Math.floorDiv(x2, this.cellSize);
        int y2Index = Math.floorDiv(y2, this.cellSize);
        HashSet result = new HashSet();
        int x = x1Index;
        while (x <= x2Index) {
            int y = y1Index;
            while (y <= y2Index) {
                this.getEntries(this.tableIndex(x, y), x1, y1, x2, y2, result);
                ++y;
            }
            ++x;
        }
        return result;
    }

    protected void getEntries(int tableIndex, int x1, int y1, int x2, int y2, Set<T> result) {
        Entry<T>[] bucket = this.table[tableIndex];
        if (bucket != null) {
            Entry<T>[] entryArray = bucket;
            int n = bucket.length;
            int n2 = 0;
            while (n2 < n) {
                Entry<T> entry = entryArray[n2];
                if (entry == null) break;
                if (entry.intersects(x1, y1, x2, y2)) {
                    result.add(entry.value);
                }
                ++n2;
            }
        }
    }

    public Set<T> put(int x1, int y1, int x2, int y2, T value) {
        int x1Index = Math.floorDiv(x1, this.cellSize);
        int y1Index = Math.floorDiv(y1, this.cellSize);
        int x2Index = Math.floorDiv(x2, this.cellSize);
        int y2Index = Math.floorDiv(y2, this.cellSize);
        HashSet result = new HashSet();
        Entry<T> newEntry = new Entry<T>(x1, y1, x2, y2, value);
        int x = x1Index;
        while (x <= x2Index) {
            int y = y1Index;
            while (y <= y2Index) {
                this.putEntry(this.tableIndex(x, y), newEntry, result);
                ++y;
            }
            ++x;
        }
        ++this.size;
        return result;
    }

    protected void putEntry(int tableIndex, Entry<T> newEntry, Set<T> result) {
        Entry<T>[] bucket = this.table[tableIndex];
        if (bucket != null) {
            int i = 0;
            while (i < bucket.length) {
                Entry<T> entry = bucket[i];
                if (entry == newEntry) {
                    return;
                }
                if (entry == null) {
                    bucket[i] = newEntry;
                    return;
                }
                if (entry.intersects(newEntry)) {
                    result.add(entry.value);
                }
                ++i;
            }
            Entry<T>[] newBucket = this.newBucket(bucket.length << 1);
            System.arraycopy(bucket, 0, newBucket, 0, bucket.length);
            newBucket[bucket.length] = newEntry;
            this.table[tableIndex] = newBucket;
        } else {
            Entry<T>[] newBucket = this.newBucket(10);
            newBucket[0] = newEntry;
            this.table[tableIndex] = newBucket;
        }
    }

    public Set<T> put(Entry<T> entry) {
        return this.put(entry.x1, entry.y1, entry.x2, entry.y2, entry.value);
    }

    protected int tableIndex(int x, int y) {
        return Math.floorMod(x, this.gridSize) + Math.floorMod(y, this.gridSize) * this.gridSize;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    protected Entry<T>[][] newTable(int length) {
        return new Entry[length][];
    }

    protected Entry<T>[] newBucket(int length) {
        return new Entry[length];
    }

    public static class Entry<T> {
        private final int x1;
        private final int y1;
        private final int x2;
        private final int y2;
        private final T value;

        public Entry(int x1, int y1, int x2, int y2, T value) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.value = value;
        }

        public boolean intersects(Entry<?> other) {
            return this.x1 < other.x2 && other.x1 < this.x2 && this.y1 < other.y2 && other.y1 < this.y2;
        }

        public boolean intersects(int x1, int y1, int x2, int y2) {
            return x1 < this.x2 && this.x1 < x2 && y1 < this.y2 && this.y1 < y2;
        }

        public int getX1() {
            return this.x1;
        }

        public int getY1() {
            return this.y1;
        }

        public int getX2() {
            return this.x2;
        }

        public int getY2() {
            return this.y2;
        }

        public T getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x1;
            result = 31 * result + this.y1;
            result = 31 * result + this.x2;
            result = 31 * result + this.y2;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            return this.x1 == other.x1 && this.x2 == other.x2 && this.y1 == other.y1 && this.y2 == other.y2 && Objects.equals(this.value, other.value);
        }
    }
}

