/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.figures.AbstractShadowBorder;
import org.eclipse.swt.graphics.Color;

public class RoundedRectangleShadowBorder
extends AbstractShadowBorder {
    Dimension cornerRadius = new Dimension(8, 8);

    public void paintBackground(IFigure figure, Graphics graphics, Insets insets) {
        Color backgroundColor = graphics.getBackgroundColor();
        int alpha = graphics.getAlpha();
        graphics.setBackgroundColor(figure.getForegroundColor());
        if (figure instanceof RoundedRectangle) {
            RoundedRectangle roundRect = (RoundedRectangle)figure;
            this.cornerRadius.setSize(roundRect.getCornerDimensions());
            this.cornerRadius.expand(2, 2);
        }
        Rectangle shadowRect = RoundedRectangleShadowBorder.getPaintRectangle((IFigure)figure, (Insets)SHADOW_INSETS).expand(2, 2);
        this.drawShadowHalo(graphics, shadowRect);
        this.drawDropShadow(graphics, shadowRect);
        graphics.setBackgroundColor(backgroundColor);
        graphics.setAlpha(alpha);
    }

    private void drawShadowHalo(Graphics graphics, Rectangle shadowRect) {
        graphics.setAlpha(30);
        this.drawShadowFigure(graphics, shadowRect);
        shadowRect.shrink(1, 1);
        graphics.setAlpha(60);
        this.drawShadowFigure(graphics, shadowRect);
    }

    private void drawDropShadow(Graphics graphics, Rectangle shadowRect) {
        graphics.setAlpha(30);
        double horInc = 0.7;
        double horI = 0.0;
        int i = 0;
        while (i < 4) {
            shadowRect.translate((int)(horI += 0.7), 1);
            this.drawShadowFigure(graphics, shadowRect);
            if (horI >= 1.0) {
                horI -= 1.0;
            }
            ++i;
        }
    }

    private void drawShadowFigure(Graphics graphics, Rectangle shadowRect) {
        graphics.fillRoundRectangle(shadowRect, this.cornerRadius.width, this.cornerRadius.height);
    }
}

