/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fmu.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.deployment.AbstractFileManagementHandler;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.IDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.util.DeploymentHelper;
import org.eclipse.fordiac.ide.fmu.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public final class FMUDeviceManagementCommunicationHandler
extends AbstractFileManagementHandler {
    private static final String BINARIES_FOLDER_NAME = "binaries";
    private static final String RESOURCES_FOLDER_NAME = "resources";
    private static final int ZIP_BUFFER = 1024;
    private static final int TOTAL_MONITOR = 100;
    private final List<FMUInputOutput> inputsAndOutputs = new ArrayList<FMUInputOutput>();
    private final Device device;

    public static void createFMU(Device device, List<Resource> resources, List<String> librariesToAdd, String directory, Shell shell, IProgressMonitor monitor) {
        if (directory != null) {
            if (!librariesToAdd.isEmpty()) {
                monitor.beginTask(MessageFormat.format(Messages.FMUDeviceManagementCommunicationHandler_GeneratingFMUsForDevice, device.getName()), 100);
                String outputName = device.getAutomationSystem().getName() + "_" + device.getName();
                FMUDeviceManagementCommunicationHandler fmuFileHandler = new FMUDeviceManagementCommunicationHandler(device);
                DeploymentCoordinator.performDeployment((Object[])resources.toArray(), (IDeviceManagementCommunicationHandler)fmuFileHandler, null);
                monitor.worked(50);
                File destZipFile = FMUDeviceManagementCommunicationHandler.createZipFile(directory, outputName, shell);
                if (destZipFile != null) {
                    FMUDeviceManagementCommunicationHandler.createZip(fmuFileHandler, outputName, librariesToAdd, shell, destZipFile);
                    monitor.worked(100);
                }
            } else {
                IDeviceManagementCommunicationHandler.showErrorMessage((String)Messages.FMUDeviceManagementCommunicationHandler_NoSelectedLibrariesWereFound, (Shell)shell);
            }
        } else {
            IDeviceManagementCommunicationHandler.showErrorMessage((String)Messages.FMUDeviceManagementCommunicationHandler_TheDirectoryIsInvalid, (Shell)shell);
        }
    }

    private static void createZip(FMUDeviceManagementCommunicationHandler fmuFileHandler, String outputName, List<String> librariesToAdd, Shell shell, File destZipFile) {
        String tempFolder = FMUDeviceManagementCommunicationHandler.createTempFolderWithFMUStructure(outputName, librariesToAdd, shell);
        if (tempFolder != null) {
            if (FMUDeviceManagementCommunicationHandler.writeAllFiles(fmuFileHandler, tempFolder, outputName, shell)) {
                int res = 1024;
                while (true) {
                    try {
                        Throwable throwable = null;
                        Object var8_10 = null;
                        try (FileOutputStream fos = new FileOutputStream(destZipFile);){
                            ZipOutputStream zos = new ZipOutputStream(fos);
                            FMUDeviceManagementCommunicationHandler.zipFolder(tempFolder, tempFolder, zos);
                            zos.flush();
                            zos.close();
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        MessageBox msgBox = new MessageBox(shell, 1281);
                        msgBox.setMessage(MessageFormat.format(Messages.FMUDeviceManagementCommunicationHandler_DoYouWantToRetry, e.getLocalizedMessage()));
                        if (1024 == (res = msgBox.open())) continue;
                    }
                    break;
                }
            }
            FMUDeviceManagementCommunicationHandler.deleteFolder(tempFolder);
        }
    }

    private static File createZipFile(String directoryPath, String outputName, Shell shell) {
        File direc = new File(directoryPath);
        if (!direc.exists() && !direc.mkdir()) {
            IDeviceManagementCommunicationHandler.showErrorMessage((String)MessageFormat.format(Messages.FMUDeviceManagementCommunicationHandler_OutputFolderDoesNotExistAndCouldNotBeCreated, directoryPath), (Shell)shell);
        } else {
            File destZipFile = new File(directoryPath + File.separatorChar + outputName + ".fmu");
            int res = 64;
            if (destZipFile.exists()) {
                MessageBox msgBox = new MessageBox(shell, 196);
                msgBox.setMessage(MessageFormat.format(Messages.FMUDeviceManagementCommunicationHandler_OutputFMUFileExistsOverwriteIt, outputName));
                res = msgBox.open();
            }
            if (64 == res) {
                return destZipFile;
            }
        }
        return null;
    }

    private static String createTempFolderWithFMUStructure(String outputName, List<String> librariesToAdd, Shell shell) {
        try {
            String tempFolder = Files.createTempDirectory("temp", new FileAttribute[0]).toString();
            ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.fordiac.ide.fmu");
            File binariesDirectory = new File(store.getString("pathPreference"));
            if (binariesDirectory.exists() && binariesDirectory.isDirectory()) {
                if (FMUDeviceManagementCommunicationHandler.createTempFoldersAndFiles(tempFolder, outputName, librariesToAdd, shell)) {
                    return tempFolder;
                }
                IDeviceManagementCommunicationHandler.showErrorMessage((String)MessageFormat.format(Messages.FMUDeviceManagementCommunicationHandler_CouldNotCreateTheComponentsInsideTheTemporaryFolder, tempFolder), (Shell)shell);
            } else {
                IDeviceManagementCommunicationHandler.showErrorMessage((String)MessageFormat.format(Messages.FMUDeviceManagementCommunicationHandler_BinaryDirectoryDoesNotExist, binariesDirectory.toPath()), (Shell)shell);
            }
        }
        catch (IOException e) {
            IDeviceManagementCommunicationHandler.showErrorMessage((String)Messages.FMUDeviceManagementCommunicationHandler_CouldNotCreateTheTemporaryFolder, (Shell)shell);
        }
        return null;
    }

    private static boolean writeAllFiles(FMUDeviceManagementCommunicationHandler fmuFileHandler, String tempFolder, String outputName, Shell shell) {
        return fmuFileHandler.writeToBootFile(new File(tempFolder + File.separatorChar + RESOURCES_FOLDER_NAME + File.separatorChar + "forte.fboot").getAbsolutePath(), true, shell) && FMUDeviceManagementCommunicationHandler.writeToAnyFile((String)new File(tempFolder + File.separatorChar + "modelDescription.xml").getAbsolutePath(), (String)fmuFileHandler.createModelDescription(outputName).toString(), (boolean)true, (Shell)shell);
    }

    private static boolean deleteFolder(String pathToDelete) {
        File path = new File(pathToDelete);
        File[] files = path.listFiles();
        if (path.exists() && files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!FMUDeviceManagementCommunicationHandler.deleteFileOrFolder(file)) {
                    return false;
                }
                ++n2;
            }
        }
        try {
            Files.delete(Paths.get(path.getAbsolutePath(), new String[0]));
        }
        catch (IOException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean deleteFileOrFolder(File file) {
        if (file.isDirectory()) {
            return FMUDeviceManagementCommunicationHandler.deleteFolder(file.getAbsolutePath());
        }
        try {
            Files.delete(Paths.get(file.getAbsolutePath(), new String[0]));
        }
        catch (IOException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean createTempFoldersAndFiles(String root, String outputName, List<String> librariesToAdd, Shell shell) {
        HashMap<String, String> librariesToNames = new HashMap<String, String>();
        librariesToNames.put("win32", "win32Forte.dll");
        librariesToNames.put("win64", "win64Forte.dll");
        librariesToNames.put("linux32", "linux32Forte.so");
        librariesToNames.put("linux64", "linux32Forte.so");
        if (!FMUDeviceManagementCommunicationHandler.createNotBinaryFiles(root, shell)) {
            return false;
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.fordiac.ide.fmu");
        for (String name : librariesToAdd) {
            String libraryName = (String)librariesToNames.get(name);
            if (FMUDeviceManagementCommunicationHandler.copyLibraries(root + File.separatorChar + BINARIES_FOLDER_NAME + File.separatorChar + name, outputName, store.getString("pathPreference") + File.separatorChar + libraryName, libraryName.substring(libraryName.indexOf(46)), shell)) continue;
            return false;
        }
        return true;
    }

    private static boolean createNotBinaryFiles(String root, Shell shell) {
        File[] folders;
        File[] fileArray = folders = new File[]{new File(root + File.separatorChar + BINARIES_FOLDER_NAME), new File(root + File.separatorChar + RESOURCES_FOLDER_NAME)};
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            if (!folder.mkdir()) {
                IDeviceManagementCommunicationHandler.showErrorMessage((String)MessageFormat.format(Messages.FMUDeviceManagementCommunicationHandler_CouldNotCreateFolderInTheTemporaryFolder, folder.getAbsolutePath()), (Shell)shell);
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean copyLibraries(String outputFolder, String outputName, String sourceBinary, String extension, Shell shell) {
        File tempFile = new File(outputFolder);
        if (tempFile.mkdir()) {
            tempFile = new File(outputFolder + File.separatorChar + outputName + extension);
            File sourceFile = new File(sourceBinary);
            if (sourceFile.exists()) {
                try {
                    Files.copy(sourceFile.toPath(), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    return true;
                }
                catch (IOException e) {
                    IDeviceManagementCommunicationHandler.showErrorMessage((String)MessageFormat.format(Messages.FMUDeviceManagementCommunicationHandler_InternalCopyingError, sourceFile.getAbsolutePath(), tempFile.getAbsolutePath(), e.getMessage()), (Shell)shell);
                }
            } else {
                IDeviceManagementCommunicationHandler.showErrorMessage((String)MessageFormat.format(Messages.FMUDeviceManagementCommunicationHandler_LibraryCouldNotBeFound, sourceFile.getAbsolutePath()), (Shell)shell);
            }
        } else {
            IDeviceManagementCommunicationHandler.showErrorMessage((String)MessageFormat.format(Messages.FMUDeviceManagementCommunicationHandler_UnableToCreateFolder, outputFolder), (Shell)shell);
        }
        return false;
    }

    private static void zipFolder(String root, String directoryPath, ZipOutputStream zos) {
        String[] listOfDirectories = new File(directoryPath).list();
        if (listOfDirectories != null) {
            String[] stringArray = listOfDirectories;
            int n = listOfDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                String dirElement = stringArray[n2];
                FMUDeviceManagementCommunicationHandler.zipFoderCore(root, directoryPath, dirElement, zos);
                ++n2;
            }
        }
    }

    private static void zipFoderCore(String root, String directoryPath, String dirElement, ZipOutputStream zos) {
        String dirElementPath = directoryPath + "/" + dirElement;
        if (new File(dirElementPath).isDirectory()) {
            FMUDeviceManagementCommunicationHandler.zipFolder(root, dirElementPath, zos);
        } else {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream fis = new FileInputStream(dirElementPath);){
                    int bytesNum;
                    ZipEntry ze = new ZipEntry(dirElementPath.substring(root.length() + 1));
                    zos.putNextEntry(ze);
                    byte[] bytesRead = new byte[1024];
                    while ((bytesNum = fis.read(bytesRead)) > 0) {
                        zos.write(bytesRead, 0, bytesNum);
                    }
                    zos.closeEntry();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | PatternSyntaxException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }
    }

    private FMUDeviceManagementCommunicationHandler(Device device) {
        this.device = device;
    }

    public String sendREQ(String destination, String request) throws IOException {
        if (!request.contains("Action=\"START\"")) {
            if (request.contains("Action=\"CREATE\"><FB ") && !destination.equals("")) {
                String type = FMUDeviceManagementCommunicationHandler.getSubstringAfterMatch(request, "Type=\"");
                type = type.substring(0, type.indexOf(34));
                String fbName = FMUDeviceManagementCommunicationHandler.getSubstringAfterMatch(request, "Name=\"");
                fbName = fbName.substring(0, fbName.indexOf(34));
                this.populateInputsAndOutputs(fbName, type, this.device.getResourceNamed(destination).getFBNetwork(), destination + ".");
            }
            return super.sendREQ(destination, request);
        }
        return "";
    }

    private void handlePubSubVars(FBNetwork fbNetwork, String fbName, String previousNames, EList<VarDeclaration> vars, boolean isInput) {
        int i = 2;
        while (i < vars.size()) {
            for (DataConnection con : fbNetwork.getDataConnections()) {
                if (!FMUDeviceManagementCommunicationHandler.isItsConnection(isInput, con, fbName, (IInterfaceElement)vars.get(i))) continue;
                IInterfaceElement otherEndpoint = isInput ? con.getSource() : con.getDestination();
                FMUInputOutput.variableType varType = FMUInputOutput.getTypeFromString(otherEndpoint.getType().getName());
                if (FMUInputOutput.variableType.UNKNOWN == varType) break;
                this.inputsAndOutputs.add(new FMUInputOutput(previousNames + fbName + "@" + otherEndpoint.getBlockFBNetworkElement().getName() + "." + otherEndpoint.getName(), !isInput, FMUInputOutput.variableScope.IO, varType, ""));
                break;
            }
            ++i;
        }
    }

    private void handleIO(IOInfo info, String previousNames, String fbName, FBNetwork fbNetwork) {
        if (info.isPubSub()) {
            FB commFB = fbNetwork.getFBNamed(fbName);
            this.handlePubSubVars(fbNetwork, fbName, previousNames, (EList<VarDeclaration>)commFB.getInterface().getInputVars(), true);
            this.handlePubSubVars(fbNetwork, fbName, previousNames, (EList<VarDeclaration>)commFB.getInterface().getOutputVars(), false);
        } else {
            this.inputsAndOutputs.add(new FMUInputOutput(previousNames + fbName, info.isInput(), FMUInputOutput.variableScope.IO, info.getVarType(), ""));
        }
    }

    private static IOInfo getInfoFromIOAndComm(String fbName, String fbType, FBNetwork fbNetwork) {
        IOInfo returnValue = fbType.matches("IX|QX|IW|QW") ? FMUDeviceManagementCommunicationHandler.getInfoFromIO(fbType) : (fbType.indexOf("PUBLISH_") == 0 || fbType.indexOf("SUBSCRIBE_") == 0 || fbType.indexOf("CLIENT_") == 0 || fbType.indexOf("SERVER_") == 0 ? FMUDeviceManagementCommunicationHandler.getInfoFromComm(fbName, fbNetwork) : new IOInfo());
        return returnValue;
    }

    private static IOInfo getInfoFromIO(String fbType) {
        IOInfo returnValue = new IOInfo();
        returnValue.setIo(true);
        returnValue.setPubSub(false);
        if (fbType.equals("IX")) {
            returnValue.setInput(true);
            returnValue.setVarType(FMUInputOutput.variableType.BOOLEAN);
        } else if (fbType.equals("QX")) {
            returnValue.setVarType(FMUInputOutput.variableType.BOOLEAN);
        } else if (fbType.equals("IW")) {
            returnValue.setInput(true);
            returnValue.setVarType(FMUInputOutput.variableType.INTEGER);
        } else if (fbType.equals("QW")) {
            returnValue.setVarType(FMUInputOutput.variableType.INTEGER);
        }
        return returnValue;
    }

    private static IOInfo getInfoFromComm(String fbName, FBNetwork fbNetwork) {
        IOInfo returnValue = new IOInfo();
        returnValue.setIo(true);
        returnValue.setPubSub(true);
        Value value = fbNetwork.getFBNamed(fbName).getInterface().getVariable("ID").getValue();
        if (value != null && value.getValue() != null && "fmu[]".equals(value.getValue())) {
            returnValue.setPubSub(true);
            returnValue.setIo(true);
        }
        return returnValue;
    }

    private void populateInputsAndOutputs(String fbName, String fbType, FBNetwork fbNetwork, String previousNames) {
        IOInfo info = FMUDeviceManagementCommunicationHandler.getInfoFromIOAndComm(fbName, fbType, fbNetwork);
        if (info.isIo()) {
            this.handleIO(info, previousNames, fbName, fbNetwork);
        }
        this.getAllVariablesFromInterface(fbName, fbNetwork, previousNames);
        FBType typeFB = fbNetwork.getFBNamed(fbName).getType();
        if (typeFB instanceof BasicFBType) {
            BasicFBType basicFBType = (BasicFBType)typeFB;
            this.handleBasicFB(basicFBType, previousNames, fbName);
        } else if (typeFB instanceof CompositeFBType) {
            CompositeFBType cfb = (CompositeFBType)typeFB;
            this.handleCompositeFB(cfb, previousNames, fbName);
        }
    }

    private void handleBasicFB(BasicFBType basic, String previousNames, String fbName) {
        FMUInputOutput.variableType varType;
        if (basic.getName().matches("E_CTU|E_D_FF|E_DEMUX|E_MERGE|E_PERMIT|E_REND|E_RS|E_SELECT|E_SPLIT|E_SR|E_SWITCH")) {
            return;
        }
        for (VarDeclaration varInternal : basic.getInternalVars()) {
            varType = FMUInputOutput.getTypeFromString(varInternal.getTypeName());
            if (FMUInputOutput.variableType.UNKNOWN == varType) continue;
            this.inputsAndOutputs.add(new FMUInputOutput(previousNames + fbName + "." + varInternal.getName(), false, FMUInputOutput.variableScope.INTERNAL, varType, varInternal.getValue() != null ? varInternal.getValue().getValue() : null));
        }
        for (VarDeclaration varInternal : basic.getInternalConstVars()) {
            varType = FMUInputOutput.getTypeFromString(varInternal.getTypeName());
            if (FMUInputOutput.variableType.UNKNOWN == varType) continue;
            this.inputsAndOutputs.add(new FMUInputOutput(previousNames + fbName + "." + varInternal.getName(), false, FMUInputOutput.variableScope.INTERNAL, varType, varInternal.getValue() != null ? varInternal.getValue().getValue() : null));
        }
        this.inputsAndOutputs.add(new FMUInputOutput(previousNames + fbName + ".$ECC", false, FMUInputOutput.variableScope.INTERNAL, FMUInputOutput.variableType.INTEGER, "0"));
    }

    private void handleCompositeFB(CompositeFBType composite, String previousNames, String fbName) {
        if (composite.getName().matches("E_CYCLE|E_F_TRIG|E_R_TRIG|E_TimeOut")) {
            return;
        }
        for (FBNetworkElement elem : composite.getFBNetwork().getNetworkElements()) {
            if (!(elem instanceof FB)) continue;
            FB fb = (FB)elem;
            if (elem instanceof AdapterFB) continue;
            this.populateInputsAndOutputs(fb.getName(), fb.getTypeName(), composite.getFBNetwork(), previousNames + fbName + ".");
        }
    }

    private void getAllVariablesFromInterface(String fbName, FBNetwork paFBNetwork, String previousNames) {
        InterfaceList fbInterface = paFBNetwork.getFBNamed(fbName).getInterface();
        ArrayList<EList> interfaceLists = new ArrayList<EList>();
        interfaceLists.add(fbInterface.getInputVars());
        interfaceLists.add(fbInterface.getOutputVars());
        interfaceLists.add(fbInterface.getEventInputs());
        interfaceLists.add(fbInterface.getEventOutputs());
        for (EList list : interfaceLists) {
            for (IInterfaceElement variable : list) {
                VarDeclaration varDecl;
                FMUInputOutput varInfo = new FMUInputOutput();
                if (variable instanceof VarDeclaration && FMUInputOutput.variableType.UNKNOWN == (varInfo = FMUDeviceManagementCommunicationHandler.getInfoFromVar(paFBNetwork, fbName, varDecl = (VarDeclaration)variable)).getVarType()) continue;
                this.inputsAndOutputs.add(new FMUInputOutput(previousNames + fbName + "." + variable.getName(), false, varInfo.getScope(), varInfo.getVarType(), varInfo.getInitialValue()));
            }
        }
    }

    private static FMUInputOutput getInfoFromVar(FBNetwork paFBNetwork, String fbName, VarDeclaration variable) {
        FMUInputOutput returnValue = new FMUInputOutput();
        FB commFB = paFBNetwork.getFBNamed(fbName);
        Value value = variable.getValue();
        String initialValue = "";
        FMUInputOutput.variableType type = FMUInputOutput.getTypeFromString(commFB.getInterface().getVariable(variable.getName()).getTypeName());
        if (FMUInputOutput.variableType.UNKNOWN == type) {
            returnValue.setType(FMUDeviceManagementCommunicationHandler.getInfoFromConnectedFB(commFB, paFBNetwork, fbName, (IInterfaceElement)variable));
        }
        if (value != null && !value.getValue().isEmpty()) {
            try {
                initialValue = DeploymentHelper.getVariableValue((VarDeclaration)variable);
            }
            catch (DeploymentException e) {
                FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
            }
            if (-1 != initialValue.indexOf(35)) {
                if (FMUInputOutput.variableType.UNKNOWN == type) {
                    type = FMUInputOutput.getTypeFromString(initialValue.substring(0, initialValue.indexOf(35)));
                }
                initialValue = initialValue.substring(initialValue.indexOf(35) + 1);
            }
            returnValue = new FMUInputOutput("", false, FMUInputOutput.variableScope.PARAM, type, initialValue);
        }
        return returnValue;
    }

    private static FMUInputOutput.variableType getInfoFromConnectedFB(FB commFB, FBNetwork paFBNetwork, String fbName, IInterfaceElement variable) {
        FMUInputOutput.variableType returnValue = FMUInputOutput.variableType.UNKNOWN;
        boolean isInput = commFB.getInterface().getVariable(variable.getName()).isIsInput();
        for (DataConnection con : paFBNetwork.getDataConnections()) {
            String destinationType;
            if (!FMUDeviceManagementCommunicationHandler.isItsConnection(isInput, con, fbName, variable)) continue;
            String string = destinationType = isInput ? con.getSource().getTypeName() : con.getDestination().getTypeName();
            if (destinationType == null) break;
            returnValue = FMUInputOutput.getTypeFromString(destinationType);
            break;
        }
        return returnValue;
    }

    private static boolean isItsConnection(boolean isInput, DataConnection con, String fbName, IInterfaceElement variable) {
        if (isInput) {
            return con.getDestinationElement().getName().equals(fbName) && con.getDestination().getName().equals(variable.getName());
        }
        return con.getSourceElement().getName().equals(fbName) && con.getSource().getName().equals(variable.getName());
    }

    public StringBuilder createModelDescription(String outputName) {
        StringBuilder modelDescription = new StringBuilder();
        modelDescription.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<fmiModelDescription\n  fmiVersion=\"2.0\"\n  modelName=\"" + outputName + "\"\n  guid=\"" + outputName + "\">\n\n<CoSimulation\n  modelIdentifier=\"" + outputName + "\"\n  canHandleVariableCommunicationStepSize=\"true\"/>\n\n<LogCategories>\n  <Category name=\"logAll\"/>\n  <Category name=\"logError\"/>\n  <Category name=\"logCalls\"/>\n</LogCategories>");
        modelDescription.append("\n\n<ModelVariables>\n");
        int outputIndex = 0;
        int noOfOutputs = 0;
        ArrayList<List<FMUInputOutput>> allToWrite = new ArrayList<List<FMUInputOutput>>();
        allToWrite.add(this.inputsAndOutputs);
        for (List list : allToWrite) {
            for (FMUInputOutput element : list) {
                FMUDeviceManagementCommunicationHandler.writeVariableToBuffer(modelDescription, outputIndex, element);
                if (!element.getInput() && element.getScope() == FMUInputOutput.variableScope.IO) {
                    ++noOfOutputs;
                }
                ++outputIndex;
            }
        }
        modelDescription.append("</ModelVariables>\n\n<ModelStructure>\n");
        if (noOfOutputs != 0) {
            modelDescription.append("  <Outputs>\n");
            outputIndex = 0;
            for (FMUInputOutput fMUInputOutput : this.inputsAndOutputs) {
                ++outputIndex;
                if (fMUInputOutput.getInput() || fMUInputOutput.getScope() != FMUInputOutput.variableScope.IO) continue;
                modelDescription.append("    <Unknown index=\"");
                modelDescription.append(outputIndex);
                modelDescription.append("\" dependencies=\"\"/>\n");
            }
            modelDescription.append("  </Outputs>\n");
        }
        modelDescription.append("</ModelStructure>\n\n</fmiModelDescription>");
        return modelDescription;
    }

    private static void writeVariableToBuffer(StringBuilder modelDescription, int outputIndex, FMUInputOutput element) {
        String causality = FMUDeviceManagementCommunicationHandler.getCausality(element);
        String variability = FMUDeviceManagementCommunicationHandler.getVariability(element);
        modelDescription.append("  <ScalarVariable name=\"" + element.getName() + "\" valueReference=\"" + outputIndex + "\" description=\"\" causality=\"" + causality + "\" variability=\"" + variability + "\"" + (!element.getInput() || element.getScope() == FMUInputOutput.variableScope.PARAM ? " initial=\"exact\">" : ">") + "\n    <");
        switch (element.getVarType()) {
            case BOOLEAN: {
                modelDescription.append("Boolean ");
                break;
            }
            case INTEGER: {
                modelDescription.append("Integer ");
                break;
            }
            case REAL: {
                modelDescription.append("Real ");
                break;
            }
            case STRING: {
                modelDescription.append("String ");
                break;
            }
        }
        modelDescription.append("start=\"" + element.getInitialValue() + "\"/>\n  </ScalarVariable>\n");
    }

    private static String getCausality(FMUInputOutput element) {
        return switch (element.getScope()) {
            case FMUInputOutput.variableScope.PARAM -> "parameter";
            case FMUInputOutput.variableScope.INTERNAL -> "local";
            case FMUInputOutput.variableScope.IO -> {
                if (element.getInput()) {
                    yield "input";
                }
                yield "output";
            }
            default -> "";
        };
    }

    private static String getVariability(FMUInputOutput element) {
        if (FMUInputOutput.variableScope.PARAM == element.getScope()) {
            return "fixed";
        }
        return FMUInputOutput.variableType.REAL == element.getVarType() ? "continuous" : "discrete";
    }

    private static String getSubstringAfterMatch(String source, String toLook) {
        return source.substring(source.indexOf(toLook) + toLook.length());
    }

    public static class FMUInputOutput {
        private final String mName;
        private final boolean mIsInput;
        private final variableScope mScope;
        private variableType mVarType;
        private String mInitialValue;

        public FMUInputOutput() {
            this.mName = "";
            this.mIsInput = false;
            this.mVarType = variableType.INTEGER;
            this.mScope = variableScope.INTERNAL;
            this.mInitialValue = "";
        }

        public FMUInputOutput(String name, boolean input, variableScope variable, variableType varType, String initialValue) {
            this.mName = name;
            this.mIsInput = input;
            this.mVarType = varType;
            this.mScope = variable;
            this.mInitialValue = initialValue;
            if (this.mVarType == variableType.BOOLEAN) {
                this.setBooleanInitValue();
            }
            if (this.mInitialValue == null || this.mInitialValue.equals("")) {
                switch (varType) {
                    case BOOLEAN: {
                        this.mInitialValue = "false";
                        break;
                    }
                    case INTEGER: {
                        this.mInitialValue = "0";
                        break;
                    }
                    case REAL: {
                        this.mInitialValue = "0.0";
                        break;
                    }
                    case STRING: {
                        this.mInitialValue = "";
                        break;
                    }
                }
            }
        }

        private void setBooleanInitValue() {
            this.mInitialValue = this.mInitialValue == null || this.mInitialValue.equals("0") || this.mInitialValue.equals("") ? "false" : "true";
        }

        public void setType(variableType type) {
            this.mVarType = type;
        }

        public String getName() {
            return this.mName;
        }

        public boolean getInput() {
            return this.mIsInput;
        }

        public variableScope getScope() {
            return this.mScope;
        }

        public variableType getVarType() {
            return this.mVarType;
        }

        public String getInitialValue() {
            return this.mInitialValue;
        }

        private static String orString(String ... strings) {
            return String.join((CharSequence)"|", strings);
        }

        static variableType getTypeFromString(String text) {
            variableType varType = text.equals("BOOL") ? variableType.BOOLEAN : (text.matches(FMUInputOutput.orString("BYTE", "WORD", "DWORD", "LWORD", "INT", "DINT", "LINT", "SINT", "USINT", "UINT", "UDINT", "ULINT", "ANY_INT")) ? variableType.INTEGER : (text.matches(FMUInputOutput.orString("STRING", "WSTRING", "ANY_STRING", "DATE", "DATE_AND_TIME", "TIME_OF_DAY", "ANY_DATE", "TIME")) ? variableType.STRING : (text.matches(FMUInputOutput.orString("REAL", "LREAL", "ANY_REAL")) ? variableType.REAL : variableType.UNKNOWN)));
            return varType;
        }

        public static enum variableScope {
            IO,
            INTERNAL,
            PARAM;

        }

        public static enum variableType {
            BOOLEAN,
            INTEGER,
            REAL,
            STRING,
            UNKNOWN;

        }
    }

    private static class IOInfo {
        private boolean io = false;
        private boolean input = false;
        private boolean pubSub = false;
        private FMUInputOutput.variableType varType = FMUInputOutput.variableType.UNKNOWN;

        public boolean isIo() {
            return this.io;
        }

        public void setIo(boolean io) {
            this.io = io;
        }

        public boolean isInput() {
            return this.input;
        }

        public void setInput(boolean input) {
            this.input = input;
        }

        public boolean isPubSub() {
            return this.pubSub;
        }

        public void setPubSub(boolean pubSub) {
            this.pubSub = pubSub;
        }

        public FMUInputOutput.variableType getVarType() {
            return this.varType;
        }

        public void setVarType(FMUInputOutput.variableType varType) {
            this.varType = varType;
        }
    }
}

