/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.comgeneration.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.fordiac.ide.comgeneration.implementation.ChannelEnd;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationChannel;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationChannelDestination;
import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationModel;
import org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators.MediaSpecificGenerator;
import org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators.MediaSpecificGeneratorFactory;
import org.eclipse.fordiac.ide.comgeneration.plugin.Messages;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.FBCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class CommFBGenerator {
    private static final String GENERATED_ANNOTATION = "generatedComm";
    private static final String GENERATED_SOURCE_FB_ANNOTATION = "generatedSrcFB";
    private static final String GENERATED_DESTINATION_FB_ANNOTATION = "generatedDestFB";
    private static final String GENERATED_FOR_CONNECTION_ANNOTATION = "generatedForConnection";
    private static final int COLD = 0;
    private static final int WARM = 1;
    private Set<GeneratedFBInfo> generatedFBs;
    private TransferedData transferedData;
    private final MediaSpecificGeneratorFactory specificGeneratorFactory;
    private int generatedFBIndex;

    public CommFBGenerator(MediaSpecificGeneratorFactory specificGeneratorFactory) {
        this.specificGeneratorFactory = specificGeneratorFactory;
        this.transferedData = TransferedData.ALL;
    }

    public TransferedData getTransferedData() {
        return this.transferedData;
    }

    public void setTransferedData(TransferedData transferedData) {
        this.transferedData = transferedData;
    }

    public void generate(CommunicationModel communicationModel) {
        this.generatedFBs = new HashSet<GeneratedFBInfo>();
        this.generatedFBIndex = 0;
        for (CommunicationChannel channel : communicationModel.getChannels().values()) {
            this.generate(channel);
        }
    }

    public static void removeGeneratedElements(Application application) {
        HashSet<FBNetwork> usedResources = new HashSet<FBNetwork>();
        for (FBNetworkElement fb : application.getFBNetwork().getNetworkElements()) {
            if (fb.getResource() == null) continue;
            usedResources.add(fb.getResource().getFBNetwork());
        }
        for (FBNetwork resourceFBNetwork : usedResources) {
            CommFBGenerator.removeGeneratedElements(resourceFBNetwork);
        }
    }

    public static void removeGeneratedElements(FBNetwork network) {
        HashSet<FBNetworkElement> fbsToRemove = new HashSet<FBNetworkElement>();
        for (FBNetworkElement fb : network.getNetworkElements()) {
            if (fb.getComment() == null || !fb.getComment().contains(GENERATED_ANNOTATION)) continue;
            fbsToRemove.add(fb);
        }
        for (FBNetworkElement fb : fbsToRemove) {
            DeleteFBNetworkElementCommand deleteFBCommand = new DeleteFBNetworkElementCommand(fb);
            deleteFBCommand.execute();
        }
    }

    private void generate(CommunicationChannel channel) {
        for (CommunicationChannelDestination destination : channel.getDestinations()) {
            this.generateFBs(destination);
        }
    }

    private void generateFBs(CommunicationChannelDestination destination) {
        if (destination.getSelectedMedia() == null || destination.getSelectedProtocolId() == null) {
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.CommFBGenerator_NoSelectionFor, destination));
            return;
        }
        int numberDataPorts = 0;
        Set<Integer> withPorts = null;
        switch (this.transferedData) {
            case ALL: {
                numberDataPorts = destination.getCommunicationChannel().getNumberOfDataPorts();
                HashSet<Integer> allWithPorts = new HashSet<Integer>();
                int i = 0;
                while (i < destination.getCommunicationChannel().getSourceEvent().getWith().size()) {
                    allWithPorts.add(i);
                    ++i;
                }
                withPorts = allWithPorts;
                break;
            }
            case EXACT: {
                numberDataPorts = destination.getDestinationPorts().keySet().size();
                if (destination.getDestinationPorts().keySet().contains(-1)) {
                    --numberDataPorts;
                }
                withPorts = destination.getDestinationPorts().keySet();
            }
        }
        MediaSpecificGenerator specificGenerator = this.specificGeneratorFactory.getForProtocolId(destination.getSelectedProtocolId());
        if (specificGenerator == null) {
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.CommFBGenerator_NoGeneratorForProtocol, destination.getSelectedProtocolId()));
        } else {
            GeneratedFBInfo sourceGeneratedFBInfo = this.generateFB(ChannelEnd.SOURCE, numberDataPorts, withPorts, destination, specificGenerator);
            GeneratedFBInfo destinationGeneratedFBInfo = this.generateFB(ChannelEnd.DESTINATION, numberDataPorts, withPorts, destination, specificGenerator);
            specificGenerator.configureFBs(sourceGeneratedFBInfo.getFb(), destinationGeneratedFBInfo.getFb(), destination.getSelectedMedia());
        }
    }

    private GeneratedFBInfo generateFB(ChannelEnd end, int numberOfDataPorts, Set<Integer> withPorts, CommunicationChannelDestination destination, MediaSpecificGenerator specificGenerator) {
        GeneratedFBInfo generatedFBInfo = null;
        if (end == ChannelEnd.SOURCE && !destination.isSeparated() && !specificGenerator.isSeparatedSource()) {
            generatedFBInfo = this.findExistingGeneratedFBInfo(end, destination.getCommunicationChannel(), withPorts, destination.getSelectedMedia().getSegment());
        }
        if (generatedFBInfo != null) {
            generatedFBInfo.getDestinations().add(destination);
        } else {
            FBTypeEntry typeEntry = specificGenerator.getPaletteType(end, numberOfDataPorts, destination.getCommunicationChannel().isLocal());
            Resource resource = end == ChannelEnd.SOURCE ? destination.getCommunicationChannel().getSourceResource() : destination.getDestinationResource();
            FBCreateCommand command = new FBCreateCommand(typeEntry, resource.getFBNetwork(), 10, 10);
            command.execute();
            FB generatedFB = command.getFB();
            this.addGenAnnotation(generatedFB, end, destination);
            generatedFBInfo = new GeneratedFBInfo(end, destination, generatedFB, withPorts);
            this.generatedFBs.add(generatedFBInfo);
            ++this.generatedFBIndex;
            if (end == ChannelEnd.SOURCE) {
                CommFBGenerator.generateSourceConnections(generatedFBInfo, specificGenerator);
            } else {
                CommFBGenerator.generateDestinationConnections(generatedFBInfo, specificGenerator);
            }
            this.generateInitConnection(generatedFBInfo);
        }
        return generatedFBInfo;
    }

    private void addGenAnnotation(FB generatedFB, ChannelEnd end, CommunicationChannelDestination destination) {
        generatedFB.setName(NameRepository.createUniqueName((INamedElement)generatedFB, (String)("GENERATED_" + this.generatedFBIndex)));
        StringBuilder newFBComment = new StringBuilder();
        newFBComment.append(GENERATED_ANNOTATION);
        newFBComment.append("; ");
        for (Connection connection : destination.getConnection()) {
            newFBComment.append(GENERATED_FOR_CONNECTION_ANNOTATION);
            newFBComment.append("=");
            newFBComment.append("; ");
            StringBuilder newConnectionComment = new StringBuilder();
            if (connection.getComment() != null) {
                newConnectionComment.append(connection.getComment());
            }
            newConnectionComment.append(end == ChannelEnd.SOURCE ? GENERATED_SOURCE_FB_ANNOTATION : GENERATED_DESTINATION_FB_ANNOTATION);
            newConnectionComment.append("=");
            newConnectionComment.append("; ");
            connection.setComment(newConnectionComment.toString());
        }
        generatedFB.setComment(newFBComment.toString());
    }

    private static void generateSourceConnections(GeneratedFBInfo generatedFBInfo, MediaSpecificGenerator specificGenerator) {
        CommunicationChannel channel = generatedFBInfo.getDestinations().iterator().next().getCommunicationChannel();
        EventConnectionCreateCommand eventCreateCommand = new EventConnectionCreateCommand(generatedFBInfo.getResource().getFBNetwork());
        Event targetEvent = (Event)generatedFBInfo.getFb().getInterface().getEventInputs().get(1);
        CommFBGenerator.executeCreateConnCmd((AbstractConnectionCreateCommand)eventCreateCommand, (IInterfaceElement)targetEvent, (IInterfaceElement)channel.getSourceEvent());
        int targetDataIndex = 0;
        int i = 0;
        while (i < channel.getSourceEvent().getWith().size()) {
            if (generatedFBInfo.getWithPorts() == null || generatedFBInfo.getWithPorts().contains(i)) {
                With with = (With)channel.getSourceEvent().getWith().get(i);
                DataConnectionCreateCommand dataCreateCommand = new DataConnectionCreateCommand(generatedFBInfo.getResource().getFBNetwork());
                VarDeclaration targetData = specificGenerator.getTargetInputData(targetDataIndex, generatedFBInfo.getFb());
                CommFBGenerator.executeCreateConnCmd((AbstractConnectionCreateCommand)dataCreateCommand, (IInterfaceElement)targetData, (IInterfaceElement)with.getVariables());
                ++targetDataIndex;
            }
            ++i;
        }
    }

    private static void generateDestinationConnections(GeneratedFBInfo generatedFBInfo, MediaSpecificGenerator specificGenerator) {
        CommunicationChannelDestination destination = generatedFBInfo.getDestinations().iterator().next();
        for (Integer withIndex : destination.getDestinationPorts().keySet()) {
            if (withIndex == -1) {
                for (IInterfaceElement interfaceElement : destination.getDestinationPorts().get(withIndex)) {
                    EventConnectionCreateCommand eventCreateCommand = new EventConnectionCreateCommand(generatedFBInfo.getResource().getFBNetwork());
                    Event sourceEvent = (Event)generatedFBInfo.getFb().getInterface().getEventOutputs().get(1);
                    CommFBGenerator.executeCreateConnCmd((AbstractConnectionCreateCommand)eventCreateCommand, interfaceElement, (IInterfaceElement)sourceEvent);
                }
                continue;
            }
            if (withIndex < 0) continue;
            int generatedPortIndex = CommFBGenerator.getPortIndex(generatedFBInfo, withIndex);
            for (IInterfaceElement interfaceElement : destination.getDestinationPorts().get(withIndex)) {
                DataConnectionCreateCommand dataCreateCommand = new DataConnectionCreateCommand(generatedFBInfo.getResource().getFBNetwork());
                VarDeclaration targetData = specificGenerator.getTargetOutputData(generatedPortIndex, generatedFBInfo.getFb());
                CommFBGenerator.executeCreateConnCmd((AbstractConnectionCreateCommand)dataCreateCommand, interfaceElement, (IInterfaceElement)targetData);
            }
        }
    }

    private static int getPortIndex(GeneratedFBInfo generatedFBInfo, Integer withIndex) {
        int generatedPortIndex = 0;
        for (Integer generatedWithPort : generatedFBInfo.getWithPorts()) {
            if (generatedWithPort < 0 || generatedWithPort >= withIndex) continue;
            ++generatedPortIndex;
        }
        return generatedPortIndex;
    }

    private static void executeCreateConnCmd(AbstractConnectionCreateCommand createCommand, IInterfaceElement destination, IInterfaceElement source) {
        createCommand.setDestination(destination);
        createCommand.setSource(source);
        createCommand.execute();
    }

    private void generateInitConnection(GeneratedFBInfo generatedFBInfo) {
        ArrayList<Event> sourceEvents = new ArrayList<Event>();
        Resource resource = generatedFBInfo.getResource();
        for (GeneratedFBInfo existingInfo : this.generatedFBs) {
            if (!resource.equals(existingInfo.getResource()) || generatedFBInfo.getFb().equals(existingInfo.getFb())) continue;
            sourceEvents.add((Event)existingInfo.getFb().getInterface().getEventOutputs().get(0));
            break;
        }
        if (sourceEvents.isEmpty()) {
            FB startFB = resource.getFBNetwork().getFBNamed("START");
            if (startFB == null) {
                FordiacLogHelper.logError((String)MessageFormat.format(Messages.CommFBGenerator_NoStartFBInResource, resource.getName()));
                return;
            }
            sourceEvents.add((Event)startFB.getInterface().getEventOutputs().get(0));
            sourceEvents.add((Event)startFB.getInterface().getEventOutputs().get(1));
        }
        Event targetEvent = (Event)generatedFBInfo.getFb().getInterface().getEventInputs().get(0);
        for (Event sourceEvent : sourceEvents) {
            EventConnectionCreateCommand eventCreateCommand = new EventConnectionCreateCommand(resource.getFBNetwork());
            CommFBGenerator.executeCreateConnCmd((AbstractConnectionCreateCommand)eventCreateCommand, (IInterfaceElement)targetEvent, (IInterfaceElement)sourceEvent);
        }
    }

    private GeneratedFBInfo findExistingGeneratedFBInfo(ChannelEnd end, CommunicationChannel channel, Set<Integer> withPorts, Segment segment) {
        for (GeneratedFBInfo generatedFBInfo : this.generatedFBs) {
            if (generatedFBInfo.getEnd() != end || !generatedFBInfo.getChannel().equals(channel) || (generatedFBInfo.getWithPorts() != null || withPorts != null) && !generatedFBInfo.getWithPorts().equals(withPorts) || !generatedFBInfo.getSegment().equals(segment)) continue;
            return generatedFBInfo;
        }
        return null;
    }

    private static class GeneratedFBInfo {
        private final FB fb;
        private final Set<CommunicationChannelDestination> destinations;
        private final Set<Integer> withPorts;
        private final Segment segment;
        private final ChannelEnd end;

        public GeneratedFBInfo(ChannelEnd end, CommunicationChannelDestination destination, FB generatedFB, Set<Integer> withPorts) {
            this.end = end;
            this.destinations = new HashSet<CommunicationChannelDestination>();
            this.segment = destination.getSelectedMedia().getSegment();
            this.destinations.add(destination);
            this.fb = generatedFB;
            this.withPorts = withPorts;
        }

        public FB getFb() {
            return this.fb;
        }

        public Set<Integer> getWithPorts() {
            return this.withPorts;
        }

        public Set<CommunicationChannelDestination> getDestinations() {
            return this.destinations;
        }

        public ChannelEnd getEnd() {
            return this.end;
        }

        public Segment getSegment() {
            return this.segment;
        }

        public Resource getResource() {
            return this.end == ChannelEnd.SOURCE ? this.destinations.iterator().next().getCommunicationChannel().getSourceResource() : this.destinations.iterator().next().getDestinationResource();
        }

        public CommunicationChannel getChannel() {
            return this.destinations.iterator().next().getCommunicationChannel();
        }
    }

    public static enum TransferedData {
        ALL,
        EXACT;

    }
}

