/*
 * Decompiled with CFR 0.152.
 */
package com.gsamokovarov.skiptrace;

import com.gsamokovarov.skiptrace.RubyBindingsCollector;
import com.gsamokovarov.skiptrace.SetExceptionBindingsEventHook;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.EventHook;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;

public class JRubyIntegration {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setup(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Skiptrace");
        rubyModule.defineAnnotatedMethods(SkiptraceMethods.class);
        RubyClass rubyClass = ruby.getException();
        rubyClass.defineAnnotatedMethods(ExceptionExtensionMethods.class);
        IRubyObject iRubyObject = ruby.getVerbose();
        try {
            ruby.setVerbose(ruby.getNil());
            ruby.addEventHook((EventHook)new SetExceptionBindingsEventHook());
        }
        finally {
            ruby.setVerbose(iRubyObject);
        }
    }

    public static class ExceptionExtensionMethods {
        @JRubyMethod
        public static IRubyObject bindings(ThreadContext threadContext, IRubyObject iRubyObject) {
            InstanceVariables instanceVariables = iRubyObject.getInstanceVariables();
            IRubyObject iRubyObject2 = instanceVariables.getInstanceVariable("@bindings");
            if (iRubyObject2 != null && !iRubyObject2.isNil()) {
                return iRubyObject2;
            }
            return RubyArray.newArray((Ruby)threadContext.getRuntime());
        }
    }

    public static class SkiptraceMethods {
        @JRubyMethod(name={"current_bindings"}, meta=true)
        public static IRubyObject currentBindings(ThreadContext threadContext, IRubyObject iRubyObject) {
            return RubyBindingsCollector.collectCurrentFor(threadContext);
        }
    }
}

