/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* DAG Instruction Selector for the WebAssembly target                        *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

// *** NOTE: This file is #included into the middle of the target
// *** instruction selector class.  These functions are really methods.

// If GET_DAGISEL_DECL is #defined with any value, only function
// declarations will be included when this file is included.
// If GET_DAGISEL_BODY is #defined, its value should be the name of
// the instruction selector class. Function bodies will be emitted
// and each function's name will be qualified with the name of the
// class.
//
// When neither of the GET_DAGISEL* macros is defined, the functions
// are emitted inline.

#if defined(GET_DAGISEL_DECL) && defined(GET_DAGISEL_BODY)
#error GET_DAGISEL_DECL and GET_DAGISEL_BODY cannot be both defined, undef both for inline definitions
#endif

#ifdef GET_DAGISEL_BODY
#define LOCAL_DAGISEL_STRINGIZE(X) LOCAL_DAGISEL_STRINGIZE_(X)
#define LOCAL_DAGISEL_STRINGIZE_(X) #X
static_assert(sizeof(LOCAL_DAGISEL_STRINGIZE(GET_DAGISEL_BODY)) > 1,
   "GET_DAGISEL_BODY is empty: it should be defined with the class name");
#undef LOCAL_DAGISEL_STRINGIZE_
#undef LOCAL_DAGISEL_STRINGIZE
#endif

#if !defined(GET_DAGISEL_DECL) && !defined(GET_DAGISEL_BODY)
#define DAGISEL_INLINE 1
#else
#define DAGISEL_INLINE 0
#endif

#if !DAGISEL_INLINE
#define DAGISEL_CLASS_COLONCOLON GET_DAGISEL_BODY ::
#else
#define DAGISEL_CLASS_COLONCOLON
#endif

#ifdef GET_DAGISEL_DECL
void SelectCode(SDNode *N);
#endif
#if defined(GET_DAGISEL_BODY) || DAGISEL_INLINE
void DAGISEL_CLASS_COLONCOLON SelectCode(SDNode *N)
{
  // Some target values are emitted as 2 bytes, TARGET_VAL handles
  // this.
  #define TARGET_VAL(X) X & 255, unsigned(X) >> 8
  static const unsigned char MatcherTable[] = {
/*     0*/  OPC_SwitchOpcode /*85 cases */, 59|128,2|128,1/*16699*/, TARGET_VAL(ISD::AND),// ->16705
/*     6*/    OPC_Scope, 61, /*->69*/ // 305 children in Scope
/*     8*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*    11*/      OPC_MoveChild0,
/*    12*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*    15*/      OPC_MoveChild0,
/*    16*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*    19*/      OPC_RecordMemRef,
/*    20*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*    21*/      OPC_CheckFoldableChainNode,
/*    22*/      OPC_MoveChild1,
/*    23*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*    26*/      OPC_RecordChild0, // #1 = $addr
/*    27*/      OPC_MoveChild1,
/*    28*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*    31*/      OPC_RecordChild0, // #2 = $off
/*    32*/      OPC_MoveChild0,
/*    33*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*    36*/      OPC_MoveParent,
/*    37*/      OPC_MoveParent,
/*    38*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*    40*/      OPC_CheckType, MVT::i32,
/*    42*/      OPC_MoveParent,
/*    43*/      OPC_MoveChild2,
/*    44*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*    47*/      OPC_RecordChild0, // #3 = $val
/*    48*/      OPC_MoveParent,
/*    49*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/*    51*/      OPC_MoveParent,
/*    52*/      OPC_MoveParent,
/*    53*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*    55*/      OPC_EmitMergeInputChains1_0,
/*    56*/      OPC_EmitInteger, MVT::i32, 0, 
/*    59*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>), 255:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*    69*/    /*Scope*/ 62, /*->132*/
/*    70*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*    74*/      OPC_MoveChild0,
/*    75*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*    78*/      OPC_MoveChild0,
/*    79*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*    82*/      OPC_RecordMemRef,
/*    83*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*    84*/      OPC_CheckFoldableChainNode,
/*    85*/      OPC_MoveChild1,
/*    86*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*    89*/      OPC_RecordChild0, // #1 = $addr
/*    90*/      OPC_MoveChild1,
/*    91*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*    94*/      OPC_RecordChild0, // #2 = $off
/*    95*/      OPC_MoveChild0,
/*    96*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*    99*/      OPC_MoveParent,
/*   100*/      OPC_MoveParent,
/*   101*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   103*/      OPC_CheckType, MVT::i32,
/*   105*/      OPC_MoveParent,
/*   106*/      OPC_MoveChild2,
/*   107*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   110*/      OPC_RecordChild0, // #3 = $val
/*   111*/      OPC_MoveParent,
/*   112*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/*   114*/      OPC_MoveParent,
/*   115*/      OPC_MoveParent,
/*   116*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   118*/      OPC_EmitMergeInputChains1_0,
/*   119*/      OPC_EmitInteger, MVT::i32, 0, 
/*   122*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>), 65535:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   132*/    /*Scope*/ 61, /*->194*/
/*   133*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*   136*/      OPC_MoveChild0,
/*   137*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   140*/      OPC_MoveChild0,
/*   141*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*   144*/      OPC_RecordMemRef,
/*   145*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*   146*/      OPC_CheckFoldableChainNode,
/*   147*/      OPC_MoveChild1,
/*   148*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   151*/      OPC_RecordChild0, // #1 = $addr
/*   152*/      OPC_MoveChild1,
/*   153*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   156*/      OPC_RecordChild0, // #2 = $off
/*   157*/      OPC_MoveChild0,
/*   158*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   161*/      OPC_MoveParent,
/*   162*/      OPC_MoveParent,
/*   163*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   165*/      OPC_CheckType, MVT::i32,
/*   167*/      OPC_MoveParent,
/*   168*/      OPC_MoveChild2,
/*   169*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   172*/      OPC_RecordChild0, // #3 = $val
/*   173*/      OPC_MoveParent,
/*   174*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/*   176*/      OPC_MoveParent,
/*   177*/      OPC_MoveParent,
/*   178*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   180*/      OPC_EmitMergeInputChains1_0,
/*   181*/      OPC_EmitInteger, MVT::i32, 0, 
/*   184*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>), 255:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   194*/    /*Scope*/ 62, /*->257*/
/*   195*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*   199*/      OPC_MoveChild0,
/*   200*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   203*/      OPC_MoveChild0,
/*   204*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*   207*/      OPC_RecordMemRef,
/*   208*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*   209*/      OPC_CheckFoldableChainNode,
/*   210*/      OPC_MoveChild1,
/*   211*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   214*/      OPC_RecordChild0, // #1 = $addr
/*   215*/      OPC_MoveChild1,
/*   216*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   219*/      OPC_RecordChild0, // #2 = $off
/*   220*/      OPC_MoveChild0,
/*   221*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   224*/      OPC_MoveParent,
/*   225*/      OPC_MoveParent,
/*   226*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   228*/      OPC_CheckType, MVT::i32,
/*   230*/      OPC_MoveParent,
/*   231*/      OPC_MoveChild2,
/*   232*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   235*/      OPC_RecordChild0, // #3 = $val
/*   236*/      OPC_MoveParent,
/*   237*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/*   239*/      OPC_MoveParent,
/*   240*/      OPC_MoveParent,
/*   241*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   243*/      OPC_EmitMergeInputChains1_0,
/*   244*/      OPC_EmitInteger, MVT::i32, 0, 
/*   247*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>), 65535:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   257*/    /*Scope*/ 61, /*->319*/
/*   258*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*   261*/      OPC_MoveChild0,
/*   262*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   265*/      OPC_MoveChild0,
/*   266*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*   269*/      OPC_RecordMemRef,
/*   270*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*   271*/      OPC_CheckFoldableChainNode,
/*   272*/      OPC_MoveChild1,
/*   273*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   276*/      OPC_RecordChild0, // #1 = $addr
/*   277*/      OPC_MoveChild1,
/*   278*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   281*/      OPC_RecordChild0, // #2 = $off
/*   282*/      OPC_MoveChild0,
/*   283*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   286*/      OPC_MoveParent,
/*   287*/      OPC_MoveParent,
/*   288*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   290*/      OPC_CheckType, MVT::i32,
/*   292*/      OPC_MoveParent,
/*   293*/      OPC_MoveChild2,
/*   294*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   297*/      OPC_RecordChild0, // #3 = $val
/*   298*/      OPC_MoveParent,
/*   299*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/*   301*/      OPC_MoveParent,
/*   302*/      OPC_MoveParent,
/*   303*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   305*/      OPC_EmitMergeInputChains1_0,
/*   306*/      OPC_EmitInteger, MVT::i32, 0, 
/*   309*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>), 255:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   319*/    /*Scope*/ 62, /*->382*/
/*   320*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*   324*/      OPC_MoveChild0,
/*   325*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   328*/      OPC_MoveChild0,
/*   329*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*   332*/      OPC_RecordMemRef,
/*   333*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*   334*/      OPC_CheckFoldableChainNode,
/*   335*/      OPC_MoveChild1,
/*   336*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   339*/      OPC_RecordChild0, // #1 = $addr
/*   340*/      OPC_MoveChild1,
/*   341*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   344*/      OPC_RecordChild0, // #2 = $off
/*   345*/      OPC_MoveChild0,
/*   346*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   349*/      OPC_MoveParent,
/*   350*/      OPC_MoveParent,
/*   351*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   353*/      OPC_CheckType, MVT::i32,
/*   355*/      OPC_MoveParent,
/*   356*/      OPC_MoveChild2,
/*   357*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   360*/      OPC_RecordChild0, // #3 = $val
/*   361*/      OPC_MoveParent,
/*   362*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/*   364*/      OPC_MoveParent,
/*   365*/      OPC_MoveParent,
/*   366*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   368*/      OPC_EmitMergeInputChains1_0,
/*   369*/      OPC_EmitInteger, MVT::i32, 0, 
/*   372*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>), 65535:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   382*/    /*Scope*/ 61, /*->444*/
/*   383*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*   386*/      OPC_MoveChild0,
/*   387*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   390*/      OPC_MoveChild0,
/*   391*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*   394*/      OPC_RecordMemRef,
/*   395*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*   396*/      OPC_CheckFoldableChainNode,
/*   397*/      OPC_MoveChild1,
/*   398*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   401*/      OPC_RecordChild0, // #1 = $addr
/*   402*/      OPC_MoveChild1,
/*   403*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   406*/      OPC_RecordChild0, // #2 = $off
/*   407*/      OPC_MoveChild0,
/*   408*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   411*/      OPC_MoveParent,
/*   412*/      OPC_MoveParent,
/*   413*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   415*/      OPC_CheckType, MVT::i32,
/*   417*/      OPC_MoveParent,
/*   418*/      OPC_MoveChild2,
/*   419*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   422*/      OPC_RecordChild0, // #3 = $val
/*   423*/      OPC_MoveParent,
/*   424*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/*   426*/      OPC_MoveParent,
/*   427*/      OPC_MoveParent,
/*   428*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   430*/      OPC_EmitMergeInputChains1_0,
/*   431*/      OPC_EmitInteger, MVT::i32, 0, 
/*   434*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>), 255:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   444*/    /*Scope*/ 62, /*->507*/
/*   445*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*   449*/      OPC_MoveChild0,
/*   450*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   453*/      OPC_MoveChild0,
/*   454*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*   457*/      OPC_RecordMemRef,
/*   458*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*   459*/      OPC_CheckFoldableChainNode,
/*   460*/      OPC_MoveChild1,
/*   461*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   464*/      OPC_RecordChild0, // #1 = $addr
/*   465*/      OPC_MoveChild1,
/*   466*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   469*/      OPC_RecordChild0, // #2 = $off
/*   470*/      OPC_MoveChild0,
/*   471*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   474*/      OPC_MoveParent,
/*   475*/      OPC_MoveParent,
/*   476*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   478*/      OPC_CheckType, MVT::i32,
/*   480*/      OPC_MoveParent,
/*   481*/      OPC_MoveChild2,
/*   482*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   485*/      OPC_RecordChild0, // #3 = $val
/*   486*/      OPC_MoveParent,
/*   487*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/*   489*/      OPC_MoveParent,
/*   490*/      OPC_MoveParent,
/*   491*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   493*/      OPC_EmitMergeInputChains1_0,
/*   494*/      OPC_EmitInteger, MVT::i32, 0, 
/*   497*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>), 65535:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   507*/    /*Scope*/ 61, /*->569*/
/*   508*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*   511*/      OPC_MoveChild0,
/*   512*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   515*/      OPC_MoveChild0,
/*   516*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*   519*/      OPC_RecordMemRef,
/*   520*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*   521*/      OPC_CheckFoldableChainNode,
/*   522*/      OPC_MoveChild1,
/*   523*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   526*/      OPC_RecordChild0, // #1 = $addr
/*   527*/      OPC_MoveChild1,
/*   528*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   531*/      OPC_RecordChild0, // #2 = $off
/*   532*/      OPC_MoveChild0,
/*   533*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   536*/      OPC_MoveParent,
/*   537*/      OPC_MoveParent,
/*   538*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   540*/      OPC_CheckType, MVT::i32,
/*   542*/      OPC_MoveParent,
/*   543*/      OPC_MoveChild2,
/*   544*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   547*/      OPC_RecordChild0, // #3 = $val
/*   548*/      OPC_MoveParent,
/*   549*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/*   551*/      OPC_MoveParent,
/*   552*/      OPC_MoveParent,
/*   553*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   555*/      OPC_EmitMergeInputChains1_0,
/*   556*/      OPC_EmitInteger, MVT::i32, 0, 
/*   559*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>), 255:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   569*/    /*Scope*/ 62, /*->632*/
/*   570*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*   574*/      OPC_MoveChild0,
/*   575*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   578*/      OPC_MoveChild0,
/*   579*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*   582*/      OPC_RecordMemRef,
/*   583*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*   584*/      OPC_CheckFoldableChainNode,
/*   585*/      OPC_MoveChild1,
/*   586*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   589*/      OPC_RecordChild0, // #1 = $addr
/*   590*/      OPC_MoveChild1,
/*   591*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   594*/      OPC_RecordChild0, // #2 = $off
/*   595*/      OPC_MoveChild0,
/*   596*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   599*/      OPC_MoveParent,
/*   600*/      OPC_MoveParent,
/*   601*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   603*/      OPC_CheckType, MVT::i32,
/*   605*/      OPC_MoveParent,
/*   606*/      OPC_MoveChild2,
/*   607*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   610*/      OPC_RecordChild0, // #3 = $val
/*   611*/      OPC_MoveParent,
/*   612*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/*   614*/      OPC_MoveParent,
/*   615*/      OPC_MoveParent,
/*   616*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   618*/      OPC_EmitMergeInputChains1_0,
/*   619*/      OPC_EmitInteger, MVT::i32, 0, 
/*   622*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>), 65535:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   632*/    /*Scope*/ 61, /*->694*/
/*   633*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*   636*/      OPC_MoveChild0,
/*   637*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   640*/      OPC_MoveChild0,
/*   641*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*   644*/      OPC_RecordMemRef,
/*   645*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*   646*/      OPC_CheckFoldableChainNode,
/*   647*/      OPC_MoveChild1,
/*   648*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   651*/      OPC_RecordChild0, // #1 = $addr
/*   652*/      OPC_MoveChild1,
/*   653*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   656*/      OPC_RecordChild0, // #2 = $off
/*   657*/      OPC_MoveChild0,
/*   658*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   661*/      OPC_MoveParent,
/*   662*/      OPC_MoveParent,
/*   663*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   665*/      OPC_CheckType, MVT::i32,
/*   667*/      OPC_MoveParent,
/*   668*/      OPC_MoveChild2,
/*   669*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   672*/      OPC_RecordChild0, // #3 = $val
/*   673*/      OPC_MoveParent,
/*   674*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/*   676*/      OPC_MoveParent,
/*   677*/      OPC_MoveParent,
/*   678*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   680*/      OPC_EmitMergeInputChains1_0,
/*   681*/      OPC_EmitInteger, MVT::i32, 0, 
/*   684*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>), 255:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   694*/    /*Scope*/ 62, /*->757*/
/*   695*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*   699*/      OPC_MoveChild0,
/*   700*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   703*/      OPC_MoveChild0,
/*   704*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*   707*/      OPC_RecordMemRef,
/*   708*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*   709*/      OPC_CheckFoldableChainNode,
/*   710*/      OPC_MoveChild1,
/*   711*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   714*/      OPC_RecordChild0, // #1 = $addr
/*   715*/      OPC_MoveChild1,
/*   716*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   719*/      OPC_RecordChild0, // #2 = $off
/*   720*/      OPC_MoveChild0,
/*   721*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   724*/      OPC_MoveParent,
/*   725*/      OPC_MoveParent,
/*   726*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   728*/      OPC_CheckType, MVT::i32,
/*   730*/      OPC_MoveParent,
/*   731*/      OPC_MoveChild2,
/*   732*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   735*/      OPC_RecordChild0, // #3 = $val
/*   736*/      OPC_MoveParent,
/*   737*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/*   739*/      OPC_MoveParent,
/*   740*/      OPC_MoveParent,
/*   741*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   743*/      OPC_EmitMergeInputChains1_0,
/*   744*/      OPC_EmitInteger, MVT::i32, 0, 
/*   747*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>), 65535:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   757*/    /*Scope*/ 61, /*->819*/
/*   758*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*   761*/      OPC_MoveChild0,
/*   762*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   765*/      OPC_MoveChild0,
/*   766*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*   769*/      OPC_RecordMemRef,
/*   770*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*   771*/      OPC_CheckFoldableChainNode,
/*   772*/      OPC_MoveChild1,
/*   773*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   776*/      OPC_MoveChild0,
/*   777*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   780*/      OPC_RecordChild0, // #1 = $off
/*   781*/      OPC_MoveChild0,
/*   782*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   785*/      OPC_MoveParent,
/*   786*/      OPC_MoveParent,
/*   787*/      OPC_RecordChild1, // #2 = $addr
/*   788*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   790*/      OPC_CheckType, MVT::i32,
/*   792*/      OPC_MoveParent,
/*   793*/      OPC_MoveChild2,
/*   794*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   797*/      OPC_RecordChild0, // #3 = $val
/*   798*/      OPC_MoveParent,
/*   799*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/*   801*/      OPC_MoveParent,
/*   802*/      OPC_MoveParent,
/*   803*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   805*/      OPC_EmitMergeInputChains1_0,
/*   806*/      OPC_EmitInteger, MVT::i32, 0, 
/*   809*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>), 255:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   819*/    /*Scope*/ 62, /*->882*/
/*   820*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*   824*/      OPC_MoveChild0,
/*   825*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   828*/      OPC_MoveChild0,
/*   829*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*   832*/      OPC_RecordMemRef,
/*   833*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*   834*/      OPC_CheckFoldableChainNode,
/*   835*/      OPC_MoveChild1,
/*   836*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   839*/      OPC_MoveChild0,
/*   840*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   843*/      OPC_RecordChild0, // #1 = $off
/*   844*/      OPC_MoveChild0,
/*   845*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   848*/      OPC_MoveParent,
/*   849*/      OPC_MoveParent,
/*   850*/      OPC_RecordChild1, // #2 = $addr
/*   851*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   853*/      OPC_CheckType, MVT::i32,
/*   855*/      OPC_MoveParent,
/*   856*/      OPC_MoveChild2,
/*   857*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   860*/      OPC_RecordChild0, // #3 = $val
/*   861*/      OPC_MoveParent,
/*   862*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/*   864*/      OPC_MoveParent,
/*   865*/      OPC_MoveParent,
/*   866*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   868*/      OPC_EmitMergeInputChains1_0,
/*   869*/      OPC_EmitInteger, MVT::i32, 0, 
/*   872*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>), 65535:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   882*/    /*Scope*/ 61, /*->944*/
/*   883*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*   886*/      OPC_MoveChild0,
/*   887*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   890*/      OPC_MoveChild0,
/*   891*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*   894*/      OPC_RecordMemRef,
/*   895*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*   896*/      OPC_CheckFoldableChainNode,
/*   897*/      OPC_MoveChild1,
/*   898*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   901*/      OPC_MoveChild0,
/*   902*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   905*/      OPC_RecordChild0, // #1 = $off
/*   906*/      OPC_MoveChild0,
/*   907*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   910*/      OPC_MoveParent,
/*   911*/      OPC_MoveParent,
/*   912*/      OPC_RecordChild1, // #2 = $addr
/*   913*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   915*/      OPC_CheckType, MVT::i32,
/*   917*/      OPC_MoveParent,
/*   918*/      OPC_MoveChild2,
/*   919*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   922*/      OPC_RecordChild0, // #3 = $val
/*   923*/      OPC_MoveParent,
/*   924*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/*   926*/      OPC_MoveParent,
/*   927*/      OPC_MoveParent,
/*   928*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   930*/      OPC_EmitMergeInputChains1_0,
/*   931*/      OPC_EmitInteger, MVT::i32, 0, 
/*   934*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>), 255:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*   944*/    /*Scope*/ 62, /*->1007*/
/*   945*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*   949*/      OPC_MoveChild0,
/*   950*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*   953*/      OPC_MoveChild0,
/*   954*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*   957*/      OPC_RecordMemRef,
/*   958*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*   959*/      OPC_CheckFoldableChainNode,
/*   960*/      OPC_MoveChild1,
/*   961*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*   964*/      OPC_MoveChild0,
/*   965*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*   968*/      OPC_RecordChild0, // #1 = $off
/*   969*/      OPC_MoveChild0,
/*   970*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*   973*/      OPC_MoveParent,
/*   974*/      OPC_MoveParent,
/*   975*/      OPC_RecordChild1, // #2 = $addr
/*   976*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*   978*/      OPC_CheckType, MVT::i32,
/*   980*/      OPC_MoveParent,
/*   981*/      OPC_MoveChild2,
/*   982*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*   985*/      OPC_RecordChild0, // #3 = $val
/*   986*/      OPC_MoveParent,
/*   987*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/*   989*/      OPC_MoveParent,
/*   990*/      OPC_MoveParent,
/*   991*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*   993*/      OPC_EmitMergeInputChains1_0,
/*   994*/      OPC_EmitInteger, MVT::i32, 0, 
/*   997*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>), 65535:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1007*/    /*Scope*/ 61, /*->1069*/
/*  1008*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  1011*/      OPC_MoveChild0,
/*  1012*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1015*/      OPC_MoveChild0,
/*  1016*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  1019*/      OPC_RecordMemRef,
/*  1020*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  1021*/      OPC_CheckFoldableChainNode,
/*  1022*/      OPC_MoveChild1,
/*  1023*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1026*/      OPC_MoveChild0,
/*  1027*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1030*/      OPC_RecordChild0, // #1 = $off
/*  1031*/      OPC_MoveChild0,
/*  1032*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  1035*/      OPC_MoveParent,
/*  1036*/      OPC_MoveParent,
/*  1037*/      OPC_RecordChild1, // #2 = $addr
/*  1038*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  1040*/      OPC_CheckType, MVT::i32,
/*  1042*/      OPC_MoveParent,
/*  1043*/      OPC_MoveChild2,
/*  1044*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1047*/      OPC_RecordChild0, // #3 = $val
/*  1048*/      OPC_MoveParent,
/*  1049*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/*  1051*/      OPC_MoveParent,
/*  1052*/      OPC_MoveParent,
/*  1053*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1055*/      OPC_EmitMergeInputChains1_0,
/*  1056*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1059*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>), 255:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1069*/    /*Scope*/ 62, /*->1132*/
/*  1070*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  1074*/      OPC_MoveChild0,
/*  1075*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1078*/      OPC_MoveChild0,
/*  1079*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  1082*/      OPC_RecordMemRef,
/*  1083*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  1084*/      OPC_CheckFoldableChainNode,
/*  1085*/      OPC_MoveChild1,
/*  1086*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1089*/      OPC_MoveChild0,
/*  1090*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1093*/      OPC_RecordChild0, // #1 = $off
/*  1094*/      OPC_MoveChild0,
/*  1095*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  1098*/      OPC_MoveParent,
/*  1099*/      OPC_MoveParent,
/*  1100*/      OPC_RecordChild1, // #2 = $addr
/*  1101*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  1103*/      OPC_CheckType, MVT::i32,
/*  1105*/      OPC_MoveParent,
/*  1106*/      OPC_MoveChild2,
/*  1107*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1110*/      OPC_RecordChild0, // #3 = $val
/*  1111*/      OPC_MoveParent,
/*  1112*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/*  1114*/      OPC_MoveParent,
/*  1115*/      OPC_MoveParent,
/*  1116*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1118*/      OPC_EmitMergeInputChains1_0,
/*  1119*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1122*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>), 65535:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1132*/    /*Scope*/ 61, /*->1194*/
/*  1133*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  1136*/      OPC_MoveChild0,
/*  1137*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1140*/      OPC_MoveChild0,
/*  1141*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  1144*/      OPC_RecordMemRef,
/*  1145*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  1146*/      OPC_CheckFoldableChainNode,
/*  1147*/      OPC_MoveChild1,
/*  1148*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1151*/      OPC_MoveChild0,
/*  1152*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1155*/      OPC_RecordChild0, // #1 = $off
/*  1156*/      OPC_MoveChild0,
/*  1157*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  1160*/      OPC_MoveParent,
/*  1161*/      OPC_MoveParent,
/*  1162*/      OPC_RecordChild1, // #2 = $addr
/*  1163*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  1165*/      OPC_CheckType, MVT::i32,
/*  1167*/      OPC_MoveParent,
/*  1168*/      OPC_MoveChild2,
/*  1169*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1172*/      OPC_RecordChild0, // #3 = $val
/*  1173*/      OPC_MoveParent,
/*  1174*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/*  1176*/      OPC_MoveParent,
/*  1177*/      OPC_MoveParent,
/*  1178*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1180*/      OPC_EmitMergeInputChains1_0,
/*  1181*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1184*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>), 255:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1194*/    /*Scope*/ 62, /*->1257*/
/*  1195*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  1199*/      OPC_MoveChild0,
/*  1200*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1203*/      OPC_MoveChild0,
/*  1204*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  1207*/      OPC_RecordMemRef,
/*  1208*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  1209*/      OPC_CheckFoldableChainNode,
/*  1210*/      OPC_MoveChild1,
/*  1211*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1214*/      OPC_MoveChild0,
/*  1215*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1218*/      OPC_RecordChild0, // #1 = $off
/*  1219*/      OPC_MoveChild0,
/*  1220*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  1223*/      OPC_MoveParent,
/*  1224*/      OPC_MoveParent,
/*  1225*/      OPC_RecordChild1, // #2 = $addr
/*  1226*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  1228*/      OPC_CheckType, MVT::i32,
/*  1230*/      OPC_MoveParent,
/*  1231*/      OPC_MoveChild2,
/*  1232*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1235*/      OPC_RecordChild0, // #3 = $val
/*  1236*/      OPC_MoveParent,
/*  1237*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/*  1239*/      OPC_MoveParent,
/*  1240*/      OPC_MoveParent,
/*  1241*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1243*/      OPC_EmitMergeInputChains1_0,
/*  1244*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1247*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>), 65535:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1257*/    /*Scope*/ 61, /*->1319*/
/*  1258*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  1261*/      OPC_MoveChild0,
/*  1262*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1265*/      OPC_MoveChild0,
/*  1266*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  1269*/      OPC_RecordMemRef,
/*  1270*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  1271*/      OPC_CheckFoldableChainNode,
/*  1272*/      OPC_MoveChild1,
/*  1273*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1276*/      OPC_MoveChild0,
/*  1277*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1280*/      OPC_RecordChild0, // #1 = $off
/*  1281*/      OPC_MoveChild0,
/*  1282*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  1285*/      OPC_MoveParent,
/*  1286*/      OPC_MoveParent,
/*  1287*/      OPC_RecordChild1, // #2 = $addr
/*  1288*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  1290*/      OPC_CheckType, MVT::i32,
/*  1292*/      OPC_MoveParent,
/*  1293*/      OPC_MoveChild2,
/*  1294*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1297*/      OPC_RecordChild0, // #3 = $val
/*  1298*/      OPC_MoveParent,
/*  1299*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/*  1301*/      OPC_MoveParent,
/*  1302*/      OPC_MoveParent,
/*  1303*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1305*/      OPC_EmitMergeInputChains1_0,
/*  1306*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1309*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>), 255:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1319*/    /*Scope*/ 62, /*->1382*/
/*  1320*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  1324*/      OPC_MoveChild0,
/*  1325*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1328*/      OPC_MoveChild0,
/*  1329*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  1332*/      OPC_RecordMemRef,
/*  1333*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  1334*/      OPC_CheckFoldableChainNode,
/*  1335*/      OPC_MoveChild1,
/*  1336*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1339*/      OPC_MoveChild0,
/*  1340*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1343*/      OPC_RecordChild0, // #1 = $off
/*  1344*/      OPC_MoveChild0,
/*  1345*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  1348*/      OPC_MoveParent,
/*  1349*/      OPC_MoveParent,
/*  1350*/      OPC_RecordChild1, // #2 = $addr
/*  1351*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  1353*/      OPC_CheckType, MVT::i32,
/*  1355*/      OPC_MoveParent,
/*  1356*/      OPC_MoveChild2,
/*  1357*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1360*/      OPC_RecordChild0, // #3 = $val
/*  1361*/      OPC_MoveParent,
/*  1362*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/*  1364*/      OPC_MoveParent,
/*  1365*/      OPC_MoveParent,
/*  1366*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1368*/      OPC_EmitMergeInputChains1_0,
/*  1369*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1372*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>), 65535:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1382*/    /*Scope*/ 61, /*->1444*/
/*  1383*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  1386*/      OPC_MoveChild0,
/*  1387*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1390*/      OPC_MoveChild0,
/*  1391*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  1394*/      OPC_RecordMemRef,
/*  1395*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  1396*/      OPC_CheckFoldableChainNode,
/*  1397*/      OPC_MoveChild1,
/*  1398*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1401*/      OPC_MoveChild0,
/*  1402*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1405*/      OPC_RecordChild0, // #1 = $off
/*  1406*/      OPC_MoveChild0,
/*  1407*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  1410*/      OPC_MoveParent,
/*  1411*/      OPC_MoveParent,
/*  1412*/      OPC_RecordChild1, // #2 = $addr
/*  1413*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  1415*/      OPC_CheckType, MVT::i32,
/*  1417*/      OPC_MoveParent,
/*  1418*/      OPC_MoveChild2,
/*  1419*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1422*/      OPC_RecordChild0, // #3 = $val
/*  1423*/      OPC_MoveParent,
/*  1424*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/*  1426*/      OPC_MoveParent,
/*  1427*/      OPC_MoveParent,
/*  1428*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1430*/      OPC_EmitMergeInputChains1_0,
/*  1431*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1434*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>), 255:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1444*/    /*Scope*/ 62, /*->1507*/
/*  1445*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  1449*/      OPC_MoveChild0,
/*  1450*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1453*/      OPC_MoveChild0,
/*  1454*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  1457*/      OPC_RecordMemRef,
/*  1458*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  1459*/      OPC_CheckFoldableChainNode,
/*  1460*/      OPC_MoveChild1,
/*  1461*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1464*/      OPC_MoveChild0,
/*  1465*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1468*/      OPC_RecordChild0, // #1 = $off
/*  1469*/      OPC_MoveChild0,
/*  1470*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  1473*/      OPC_MoveParent,
/*  1474*/      OPC_MoveParent,
/*  1475*/      OPC_RecordChild1, // #2 = $addr
/*  1476*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  1478*/      OPC_CheckType, MVT::i32,
/*  1480*/      OPC_MoveParent,
/*  1481*/      OPC_MoveChild2,
/*  1482*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1485*/      OPC_RecordChild0, // #3 = $val
/*  1486*/      OPC_MoveParent,
/*  1487*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/*  1489*/      OPC_MoveParent,
/*  1490*/      OPC_MoveParent,
/*  1491*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1493*/      OPC_EmitMergeInputChains1_0,
/*  1494*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1497*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>), 65535:{ *:[i64] }) - Complexity = 28
                // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1507*/    /*Scope*/ 59, /*->1567*/
/*  1508*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  1511*/      OPC_MoveChild0,
/*  1512*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1515*/      OPC_MoveChild0,
/*  1516*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  1519*/      OPC_RecordMemRef,
/*  1520*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  1521*/      OPC_CheckFoldableChainNode,
/*  1522*/      OPC_MoveChild1,
/*  1523*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1526*/      OPC_RecordChild0, // #1 = $addr
/*  1527*/      OPC_MoveChild1,
/*  1528*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1531*/      OPC_RecordChild0, // #2 = $off
/*  1532*/      OPC_MoveChild0,
/*  1533*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  1536*/      OPC_MoveParent,
/*  1537*/      OPC_MoveParent,
/*  1538*/      OPC_CheckType, MVT::i32,
/*  1540*/      OPC_MoveParent,
/*  1541*/      OPC_MoveChild2,
/*  1542*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1545*/      OPC_RecordChild0, // #3 = $val
/*  1546*/      OPC_MoveParent,
/*  1547*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/*  1549*/      OPC_MoveParent,
/*  1550*/      OPC_MoveParent,
/*  1551*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1553*/      OPC_EmitMergeInputChains1_0,
/*  1554*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1557*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>), 255:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1567*/    /*Scope*/ 60, /*->1628*/
/*  1568*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  1572*/      OPC_MoveChild0,
/*  1573*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1576*/      OPC_MoveChild0,
/*  1577*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  1580*/      OPC_RecordMemRef,
/*  1581*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  1582*/      OPC_CheckFoldableChainNode,
/*  1583*/      OPC_MoveChild1,
/*  1584*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1587*/      OPC_RecordChild0, // #1 = $addr
/*  1588*/      OPC_MoveChild1,
/*  1589*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1592*/      OPC_RecordChild0, // #2 = $off
/*  1593*/      OPC_MoveChild0,
/*  1594*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  1597*/      OPC_MoveParent,
/*  1598*/      OPC_MoveParent,
/*  1599*/      OPC_CheckType, MVT::i32,
/*  1601*/      OPC_MoveParent,
/*  1602*/      OPC_MoveChild2,
/*  1603*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1606*/      OPC_RecordChild0, // #3 = $val
/*  1607*/      OPC_MoveParent,
/*  1608*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/*  1610*/      OPC_MoveParent,
/*  1611*/      OPC_MoveParent,
/*  1612*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1614*/      OPC_EmitMergeInputChains1_0,
/*  1615*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1618*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>), 65535:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1628*/    /*Scope*/ 59, /*->1688*/
/*  1629*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  1632*/      OPC_MoveChild0,
/*  1633*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1636*/      OPC_MoveChild0,
/*  1637*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  1640*/      OPC_RecordMemRef,
/*  1641*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  1642*/      OPC_CheckFoldableChainNode,
/*  1643*/      OPC_MoveChild1,
/*  1644*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1647*/      OPC_RecordChild0, // #1 = $addr
/*  1648*/      OPC_MoveChild1,
/*  1649*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1652*/      OPC_RecordChild0, // #2 = $off
/*  1653*/      OPC_MoveChild0,
/*  1654*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  1657*/      OPC_MoveParent,
/*  1658*/      OPC_MoveParent,
/*  1659*/      OPC_CheckType, MVT::i32,
/*  1661*/      OPC_MoveParent,
/*  1662*/      OPC_MoveChild2,
/*  1663*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1666*/      OPC_RecordChild0, // #3 = $val
/*  1667*/      OPC_MoveParent,
/*  1668*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/*  1670*/      OPC_MoveParent,
/*  1671*/      OPC_MoveParent,
/*  1672*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1674*/      OPC_EmitMergeInputChains1_0,
/*  1675*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1678*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>), 255:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1688*/    /*Scope*/ 60, /*->1749*/
/*  1689*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  1693*/      OPC_MoveChild0,
/*  1694*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1697*/      OPC_MoveChild0,
/*  1698*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  1701*/      OPC_RecordMemRef,
/*  1702*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  1703*/      OPC_CheckFoldableChainNode,
/*  1704*/      OPC_MoveChild1,
/*  1705*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1708*/      OPC_RecordChild0, // #1 = $addr
/*  1709*/      OPC_MoveChild1,
/*  1710*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1713*/      OPC_RecordChild0, // #2 = $off
/*  1714*/      OPC_MoveChild0,
/*  1715*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  1718*/      OPC_MoveParent,
/*  1719*/      OPC_MoveParent,
/*  1720*/      OPC_CheckType, MVT::i32,
/*  1722*/      OPC_MoveParent,
/*  1723*/      OPC_MoveChild2,
/*  1724*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1727*/      OPC_RecordChild0, // #3 = $val
/*  1728*/      OPC_MoveParent,
/*  1729*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/*  1731*/      OPC_MoveParent,
/*  1732*/      OPC_MoveParent,
/*  1733*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1735*/      OPC_EmitMergeInputChains1_0,
/*  1736*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1739*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>), 65535:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1749*/    /*Scope*/ 59, /*->1809*/
/*  1750*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  1753*/      OPC_MoveChild0,
/*  1754*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1757*/      OPC_MoveChild0,
/*  1758*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  1761*/      OPC_RecordMemRef,
/*  1762*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  1763*/      OPC_CheckFoldableChainNode,
/*  1764*/      OPC_MoveChild1,
/*  1765*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1768*/      OPC_RecordChild0, // #1 = $addr
/*  1769*/      OPC_MoveChild1,
/*  1770*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1773*/      OPC_RecordChild0, // #2 = $off
/*  1774*/      OPC_MoveChild0,
/*  1775*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  1778*/      OPC_MoveParent,
/*  1779*/      OPC_MoveParent,
/*  1780*/      OPC_CheckType, MVT::i32,
/*  1782*/      OPC_MoveParent,
/*  1783*/      OPC_MoveChild2,
/*  1784*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1787*/      OPC_RecordChild0, // #3 = $val
/*  1788*/      OPC_MoveParent,
/*  1789*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/*  1791*/      OPC_MoveParent,
/*  1792*/      OPC_MoveParent,
/*  1793*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1795*/      OPC_EmitMergeInputChains1_0,
/*  1796*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1799*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>), 255:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1809*/    /*Scope*/ 60, /*->1870*/
/*  1810*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  1814*/      OPC_MoveChild0,
/*  1815*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1818*/      OPC_MoveChild0,
/*  1819*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  1822*/      OPC_RecordMemRef,
/*  1823*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  1824*/      OPC_CheckFoldableChainNode,
/*  1825*/      OPC_MoveChild1,
/*  1826*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1829*/      OPC_RecordChild0, // #1 = $addr
/*  1830*/      OPC_MoveChild1,
/*  1831*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1834*/      OPC_RecordChild0, // #2 = $off
/*  1835*/      OPC_MoveChild0,
/*  1836*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  1839*/      OPC_MoveParent,
/*  1840*/      OPC_MoveParent,
/*  1841*/      OPC_CheckType, MVT::i32,
/*  1843*/      OPC_MoveParent,
/*  1844*/      OPC_MoveChild2,
/*  1845*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1848*/      OPC_RecordChild0, // #3 = $val
/*  1849*/      OPC_MoveParent,
/*  1850*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/*  1852*/      OPC_MoveParent,
/*  1853*/      OPC_MoveParent,
/*  1854*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1856*/      OPC_EmitMergeInputChains1_0,
/*  1857*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1860*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>), 65535:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1870*/    /*Scope*/ 59, /*->1930*/
/*  1871*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  1874*/      OPC_MoveChild0,
/*  1875*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1878*/      OPC_MoveChild0,
/*  1879*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  1882*/      OPC_RecordMemRef,
/*  1883*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  1884*/      OPC_CheckFoldableChainNode,
/*  1885*/      OPC_MoveChild1,
/*  1886*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1889*/      OPC_RecordChild0, // #1 = $addr
/*  1890*/      OPC_MoveChild1,
/*  1891*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1894*/      OPC_RecordChild0, // #2 = $off
/*  1895*/      OPC_MoveChild0,
/*  1896*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  1899*/      OPC_MoveParent,
/*  1900*/      OPC_MoveParent,
/*  1901*/      OPC_CheckType, MVT::i32,
/*  1903*/      OPC_MoveParent,
/*  1904*/      OPC_MoveChild2,
/*  1905*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1908*/      OPC_RecordChild0, // #3 = $val
/*  1909*/      OPC_MoveParent,
/*  1910*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/*  1912*/      OPC_MoveParent,
/*  1913*/      OPC_MoveParent,
/*  1914*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1916*/      OPC_EmitMergeInputChains1_0,
/*  1917*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1920*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>), 255:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1930*/    /*Scope*/ 60, /*->1991*/
/*  1931*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  1935*/      OPC_MoveChild0,
/*  1936*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1939*/      OPC_MoveChild0,
/*  1940*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  1943*/      OPC_RecordMemRef,
/*  1944*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  1945*/      OPC_CheckFoldableChainNode,
/*  1946*/      OPC_MoveChild1,
/*  1947*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  1950*/      OPC_RecordChild0, // #1 = $addr
/*  1951*/      OPC_MoveChild1,
/*  1952*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  1955*/      OPC_RecordChild0, // #2 = $off
/*  1956*/      OPC_MoveChild0,
/*  1957*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  1960*/      OPC_MoveParent,
/*  1961*/      OPC_MoveParent,
/*  1962*/      OPC_CheckType, MVT::i32,
/*  1964*/      OPC_MoveParent,
/*  1965*/      OPC_MoveChild2,
/*  1966*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  1969*/      OPC_RecordChild0, // #3 = $val
/*  1970*/      OPC_MoveParent,
/*  1971*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/*  1973*/      OPC_MoveParent,
/*  1974*/      OPC_MoveParent,
/*  1975*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  1977*/      OPC_EmitMergeInputChains1_0,
/*  1978*/      OPC_EmitInteger, MVT::i32, 0, 
/*  1981*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>), 65535:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  1991*/    /*Scope*/ 59, /*->2051*/
/*  1992*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  1995*/      OPC_MoveChild0,
/*  1996*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  1999*/      OPC_MoveChild0,
/*  2000*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  2003*/      OPC_RecordMemRef,
/*  2004*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  2005*/      OPC_CheckFoldableChainNode,
/*  2006*/      OPC_MoveChild1,
/*  2007*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2010*/      OPC_RecordChild0, // #1 = $addr
/*  2011*/      OPC_MoveChild1,
/*  2012*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2015*/      OPC_RecordChild0, // #2 = $off
/*  2016*/      OPC_MoveChild0,
/*  2017*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2020*/      OPC_MoveParent,
/*  2021*/      OPC_MoveParent,
/*  2022*/      OPC_CheckType, MVT::i32,
/*  2024*/      OPC_MoveParent,
/*  2025*/      OPC_MoveChild2,
/*  2026*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2029*/      OPC_RecordChild0, // #3 = $val
/*  2030*/      OPC_MoveParent,
/*  2031*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/*  2033*/      OPC_MoveParent,
/*  2034*/      OPC_MoveParent,
/*  2035*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2037*/      OPC_EmitMergeInputChains1_0,
/*  2038*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2041*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>), 255:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2051*/    /*Scope*/ 60, /*->2112*/
/*  2052*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  2056*/      OPC_MoveChild0,
/*  2057*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2060*/      OPC_MoveChild0,
/*  2061*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  2064*/      OPC_RecordMemRef,
/*  2065*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  2066*/      OPC_CheckFoldableChainNode,
/*  2067*/      OPC_MoveChild1,
/*  2068*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2071*/      OPC_RecordChild0, // #1 = $addr
/*  2072*/      OPC_MoveChild1,
/*  2073*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2076*/      OPC_RecordChild0, // #2 = $off
/*  2077*/      OPC_MoveChild0,
/*  2078*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2081*/      OPC_MoveParent,
/*  2082*/      OPC_MoveParent,
/*  2083*/      OPC_CheckType, MVT::i32,
/*  2085*/      OPC_MoveParent,
/*  2086*/      OPC_MoveChild2,
/*  2087*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2090*/      OPC_RecordChild0, // #3 = $val
/*  2091*/      OPC_MoveParent,
/*  2092*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/*  2094*/      OPC_MoveParent,
/*  2095*/      OPC_MoveParent,
/*  2096*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2098*/      OPC_EmitMergeInputChains1_0,
/*  2099*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2102*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>), 65535:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2112*/    /*Scope*/ 59, /*->2172*/
/*  2113*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  2116*/      OPC_MoveChild0,
/*  2117*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2120*/      OPC_MoveChild0,
/*  2121*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  2124*/      OPC_RecordMemRef,
/*  2125*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  2126*/      OPC_CheckFoldableChainNode,
/*  2127*/      OPC_MoveChild1,
/*  2128*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2131*/      OPC_RecordChild0, // #1 = $addr
/*  2132*/      OPC_MoveChild1,
/*  2133*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2136*/      OPC_RecordChild0, // #2 = $off
/*  2137*/      OPC_MoveChild0,
/*  2138*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2141*/      OPC_MoveParent,
/*  2142*/      OPC_MoveParent,
/*  2143*/      OPC_CheckType, MVT::i32,
/*  2145*/      OPC_MoveParent,
/*  2146*/      OPC_MoveChild2,
/*  2147*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2150*/      OPC_RecordChild0, // #3 = $val
/*  2151*/      OPC_MoveParent,
/*  2152*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/*  2154*/      OPC_MoveParent,
/*  2155*/      OPC_MoveParent,
/*  2156*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2158*/      OPC_EmitMergeInputChains1_0,
/*  2159*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2162*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>), 255:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2172*/    /*Scope*/ 60, /*->2233*/
/*  2173*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  2177*/      OPC_MoveChild0,
/*  2178*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2181*/      OPC_MoveChild0,
/*  2182*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  2185*/      OPC_RecordMemRef,
/*  2186*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  2187*/      OPC_CheckFoldableChainNode,
/*  2188*/      OPC_MoveChild1,
/*  2189*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2192*/      OPC_RecordChild0, // #1 = $addr
/*  2193*/      OPC_MoveChild1,
/*  2194*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2197*/      OPC_RecordChild0, // #2 = $off
/*  2198*/      OPC_MoveChild0,
/*  2199*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2202*/      OPC_MoveParent,
/*  2203*/      OPC_MoveParent,
/*  2204*/      OPC_CheckType, MVT::i32,
/*  2206*/      OPC_MoveParent,
/*  2207*/      OPC_MoveChild2,
/*  2208*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2211*/      OPC_RecordChild0, // #3 = $val
/*  2212*/      OPC_MoveParent,
/*  2213*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/*  2215*/      OPC_MoveParent,
/*  2216*/      OPC_MoveParent,
/*  2217*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2219*/      OPC_EmitMergeInputChains1_0,
/*  2220*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2223*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>), 65535:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2233*/    /*Scope*/ 59, /*->2293*/
/*  2234*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  2237*/      OPC_MoveChild0,
/*  2238*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2241*/      OPC_MoveChild0,
/*  2242*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  2245*/      OPC_RecordMemRef,
/*  2246*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  2247*/      OPC_CheckFoldableChainNode,
/*  2248*/      OPC_MoveChild1,
/*  2249*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2252*/      OPC_MoveChild0,
/*  2253*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2256*/      OPC_RecordChild0, // #1 = $off
/*  2257*/      OPC_MoveChild0,
/*  2258*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2261*/      OPC_MoveParent,
/*  2262*/      OPC_MoveParent,
/*  2263*/      OPC_RecordChild1, // #2 = $addr
/*  2264*/      OPC_CheckType, MVT::i32,
/*  2266*/      OPC_MoveParent,
/*  2267*/      OPC_MoveChild2,
/*  2268*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2271*/      OPC_RecordChild0, // #3 = $val
/*  2272*/      OPC_MoveParent,
/*  2273*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/*  2275*/      OPC_MoveParent,
/*  2276*/      OPC_MoveParent,
/*  2277*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2279*/      OPC_EmitMergeInputChains1_0,
/*  2280*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2283*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>), 255:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2293*/    /*Scope*/ 60, /*->2354*/
/*  2294*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  2298*/      OPC_MoveChild0,
/*  2299*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2302*/      OPC_MoveChild0,
/*  2303*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  2306*/      OPC_RecordMemRef,
/*  2307*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  2308*/      OPC_CheckFoldableChainNode,
/*  2309*/      OPC_MoveChild1,
/*  2310*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2313*/      OPC_MoveChild0,
/*  2314*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2317*/      OPC_RecordChild0, // #1 = $off
/*  2318*/      OPC_MoveChild0,
/*  2319*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2322*/      OPC_MoveParent,
/*  2323*/      OPC_MoveParent,
/*  2324*/      OPC_RecordChild1, // #2 = $addr
/*  2325*/      OPC_CheckType, MVT::i32,
/*  2327*/      OPC_MoveParent,
/*  2328*/      OPC_MoveChild2,
/*  2329*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2332*/      OPC_RecordChild0, // #3 = $val
/*  2333*/      OPC_MoveParent,
/*  2334*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/*  2336*/      OPC_MoveParent,
/*  2337*/      OPC_MoveParent,
/*  2338*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2340*/      OPC_EmitMergeInputChains1_0,
/*  2341*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2344*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>), 65535:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2354*/    /*Scope*/ 59, /*->2414*/
/*  2355*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  2358*/      OPC_MoveChild0,
/*  2359*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2362*/      OPC_MoveChild0,
/*  2363*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  2366*/      OPC_RecordMemRef,
/*  2367*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  2368*/      OPC_CheckFoldableChainNode,
/*  2369*/      OPC_MoveChild1,
/*  2370*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2373*/      OPC_MoveChild0,
/*  2374*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2377*/      OPC_RecordChild0, // #1 = $off
/*  2378*/      OPC_MoveChild0,
/*  2379*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2382*/      OPC_MoveParent,
/*  2383*/      OPC_MoveParent,
/*  2384*/      OPC_RecordChild1, // #2 = $addr
/*  2385*/      OPC_CheckType, MVT::i32,
/*  2387*/      OPC_MoveParent,
/*  2388*/      OPC_MoveChild2,
/*  2389*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2392*/      OPC_RecordChild0, // #3 = $val
/*  2393*/      OPC_MoveParent,
/*  2394*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/*  2396*/      OPC_MoveParent,
/*  2397*/      OPC_MoveParent,
/*  2398*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2400*/      OPC_EmitMergeInputChains1_0,
/*  2401*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2404*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>), 255:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2414*/    /*Scope*/ 60, /*->2475*/
/*  2415*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  2419*/      OPC_MoveChild0,
/*  2420*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2423*/      OPC_MoveChild0,
/*  2424*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  2427*/      OPC_RecordMemRef,
/*  2428*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  2429*/      OPC_CheckFoldableChainNode,
/*  2430*/      OPC_MoveChild1,
/*  2431*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2434*/      OPC_MoveChild0,
/*  2435*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2438*/      OPC_RecordChild0, // #1 = $off
/*  2439*/      OPC_MoveChild0,
/*  2440*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2443*/      OPC_MoveParent,
/*  2444*/      OPC_MoveParent,
/*  2445*/      OPC_RecordChild1, // #2 = $addr
/*  2446*/      OPC_CheckType, MVT::i32,
/*  2448*/      OPC_MoveParent,
/*  2449*/      OPC_MoveChild2,
/*  2450*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2453*/      OPC_RecordChild0, // #3 = $val
/*  2454*/      OPC_MoveParent,
/*  2455*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/*  2457*/      OPC_MoveParent,
/*  2458*/      OPC_MoveParent,
/*  2459*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2461*/      OPC_EmitMergeInputChains1_0,
/*  2462*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2465*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>), 65535:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2475*/    /*Scope*/ 59, /*->2535*/
/*  2476*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  2479*/      OPC_MoveChild0,
/*  2480*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2483*/      OPC_MoveChild0,
/*  2484*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  2487*/      OPC_RecordMemRef,
/*  2488*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  2489*/      OPC_CheckFoldableChainNode,
/*  2490*/      OPC_MoveChild1,
/*  2491*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2494*/      OPC_MoveChild0,
/*  2495*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2498*/      OPC_RecordChild0, // #1 = $off
/*  2499*/      OPC_MoveChild0,
/*  2500*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2503*/      OPC_MoveParent,
/*  2504*/      OPC_MoveParent,
/*  2505*/      OPC_RecordChild1, // #2 = $addr
/*  2506*/      OPC_CheckType, MVT::i32,
/*  2508*/      OPC_MoveParent,
/*  2509*/      OPC_MoveChild2,
/*  2510*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2513*/      OPC_RecordChild0, // #3 = $val
/*  2514*/      OPC_MoveParent,
/*  2515*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/*  2517*/      OPC_MoveParent,
/*  2518*/      OPC_MoveParent,
/*  2519*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2521*/      OPC_EmitMergeInputChains1_0,
/*  2522*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2525*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>), 255:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2535*/    /*Scope*/ 60, /*->2596*/
/*  2536*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  2540*/      OPC_MoveChild0,
/*  2541*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2544*/      OPC_MoveChild0,
/*  2545*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  2548*/      OPC_RecordMemRef,
/*  2549*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  2550*/      OPC_CheckFoldableChainNode,
/*  2551*/      OPC_MoveChild1,
/*  2552*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2555*/      OPC_MoveChild0,
/*  2556*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2559*/      OPC_RecordChild0, // #1 = $off
/*  2560*/      OPC_MoveChild0,
/*  2561*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2564*/      OPC_MoveParent,
/*  2565*/      OPC_MoveParent,
/*  2566*/      OPC_RecordChild1, // #2 = $addr
/*  2567*/      OPC_CheckType, MVT::i32,
/*  2569*/      OPC_MoveParent,
/*  2570*/      OPC_MoveChild2,
/*  2571*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2574*/      OPC_RecordChild0, // #3 = $val
/*  2575*/      OPC_MoveParent,
/*  2576*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/*  2578*/      OPC_MoveParent,
/*  2579*/      OPC_MoveParent,
/*  2580*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2582*/      OPC_EmitMergeInputChains1_0,
/*  2583*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2586*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>), 65535:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2596*/    /*Scope*/ 59, /*->2656*/
/*  2597*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  2600*/      OPC_MoveChild0,
/*  2601*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2604*/      OPC_MoveChild0,
/*  2605*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  2608*/      OPC_RecordMemRef,
/*  2609*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  2610*/      OPC_CheckFoldableChainNode,
/*  2611*/      OPC_MoveChild1,
/*  2612*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2615*/      OPC_MoveChild0,
/*  2616*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2619*/      OPC_RecordChild0, // #1 = $off
/*  2620*/      OPC_MoveChild0,
/*  2621*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2624*/      OPC_MoveParent,
/*  2625*/      OPC_MoveParent,
/*  2626*/      OPC_RecordChild1, // #2 = $addr
/*  2627*/      OPC_CheckType, MVT::i32,
/*  2629*/      OPC_MoveParent,
/*  2630*/      OPC_MoveChild2,
/*  2631*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2634*/      OPC_RecordChild0, // #3 = $val
/*  2635*/      OPC_MoveParent,
/*  2636*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/*  2638*/      OPC_MoveParent,
/*  2639*/      OPC_MoveParent,
/*  2640*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2642*/      OPC_EmitMergeInputChains1_0,
/*  2643*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2646*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>), 255:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2656*/    /*Scope*/ 60, /*->2717*/
/*  2657*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  2661*/      OPC_MoveChild0,
/*  2662*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2665*/      OPC_MoveChild0,
/*  2666*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  2669*/      OPC_RecordMemRef,
/*  2670*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  2671*/      OPC_CheckFoldableChainNode,
/*  2672*/      OPC_MoveChild1,
/*  2673*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2676*/      OPC_MoveChild0,
/*  2677*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2680*/      OPC_RecordChild0, // #1 = $off
/*  2681*/      OPC_MoveChild0,
/*  2682*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2685*/      OPC_MoveParent,
/*  2686*/      OPC_MoveParent,
/*  2687*/      OPC_RecordChild1, // #2 = $addr
/*  2688*/      OPC_CheckType, MVT::i32,
/*  2690*/      OPC_MoveParent,
/*  2691*/      OPC_MoveChild2,
/*  2692*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2695*/      OPC_RecordChild0, // #3 = $val
/*  2696*/      OPC_MoveParent,
/*  2697*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/*  2699*/      OPC_MoveParent,
/*  2700*/      OPC_MoveParent,
/*  2701*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2703*/      OPC_EmitMergeInputChains1_0,
/*  2704*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2707*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>), 65535:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2717*/    /*Scope*/ 59, /*->2777*/
/*  2718*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  2721*/      OPC_MoveChild0,
/*  2722*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2725*/      OPC_MoveChild0,
/*  2726*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  2729*/      OPC_RecordMemRef,
/*  2730*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  2731*/      OPC_CheckFoldableChainNode,
/*  2732*/      OPC_MoveChild1,
/*  2733*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2736*/      OPC_MoveChild0,
/*  2737*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2740*/      OPC_RecordChild0, // #1 = $off
/*  2741*/      OPC_MoveChild0,
/*  2742*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2745*/      OPC_MoveParent,
/*  2746*/      OPC_MoveParent,
/*  2747*/      OPC_RecordChild1, // #2 = $addr
/*  2748*/      OPC_CheckType, MVT::i32,
/*  2750*/      OPC_MoveParent,
/*  2751*/      OPC_MoveChild2,
/*  2752*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2755*/      OPC_RecordChild0, // #3 = $val
/*  2756*/      OPC_MoveParent,
/*  2757*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/*  2759*/      OPC_MoveParent,
/*  2760*/      OPC_MoveParent,
/*  2761*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2763*/      OPC_EmitMergeInputChains1_0,
/*  2764*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2767*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>), 255:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2777*/    /*Scope*/ 60, /*->2838*/
/*  2778*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  2782*/      OPC_MoveChild0,
/*  2783*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2786*/      OPC_MoveChild0,
/*  2787*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  2790*/      OPC_RecordMemRef,
/*  2791*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  2792*/      OPC_CheckFoldableChainNode,
/*  2793*/      OPC_MoveChild1,
/*  2794*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2797*/      OPC_MoveChild0,
/*  2798*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2801*/      OPC_RecordChild0, // #1 = $off
/*  2802*/      OPC_MoveChild0,
/*  2803*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2806*/      OPC_MoveParent,
/*  2807*/      OPC_MoveParent,
/*  2808*/      OPC_RecordChild1, // #2 = $addr
/*  2809*/      OPC_CheckType, MVT::i32,
/*  2811*/      OPC_MoveParent,
/*  2812*/      OPC_MoveChild2,
/*  2813*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2816*/      OPC_RecordChild0, // #3 = $val
/*  2817*/      OPC_MoveParent,
/*  2818*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/*  2820*/      OPC_MoveParent,
/*  2821*/      OPC_MoveParent,
/*  2822*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2824*/      OPC_EmitMergeInputChains1_0,
/*  2825*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2828*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>), 65535:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2838*/    /*Scope*/ 59, /*->2898*/
/*  2839*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  2842*/      OPC_MoveChild0,
/*  2843*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2846*/      OPC_MoveChild0,
/*  2847*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  2850*/      OPC_RecordMemRef,
/*  2851*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  2852*/      OPC_CheckFoldableChainNode,
/*  2853*/      OPC_MoveChild1,
/*  2854*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2857*/      OPC_MoveChild0,
/*  2858*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2861*/      OPC_RecordChild0, // #1 = $off
/*  2862*/      OPC_MoveChild0,
/*  2863*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2866*/      OPC_MoveParent,
/*  2867*/      OPC_MoveParent,
/*  2868*/      OPC_RecordChild1, // #2 = $addr
/*  2869*/      OPC_CheckType, MVT::i32,
/*  2871*/      OPC_MoveParent,
/*  2872*/      OPC_MoveChild2,
/*  2873*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2876*/      OPC_RecordChild0, // #3 = $val
/*  2877*/      OPC_MoveParent,
/*  2878*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/*  2880*/      OPC_MoveParent,
/*  2881*/      OPC_MoveParent,
/*  2882*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2884*/      OPC_EmitMergeInputChains1_0,
/*  2885*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2888*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>), 255:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2898*/    /*Scope*/ 60, /*->2959*/
/*  2899*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  2903*/      OPC_MoveChild0,
/*  2904*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2907*/      OPC_MoveChild0,
/*  2908*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  2911*/      OPC_RecordMemRef,
/*  2912*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  2913*/      OPC_CheckFoldableChainNode,
/*  2914*/      OPC_MoveChild1,
/*  2915*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2918*/      OPC_MoveChild0,
/*  2919*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2922*/      OPC_RecordChild0, // #1 = $off
/*  2923*/      OPC_MoveChild0,
/*  2924*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  2927*/      OPC_MoveParent,
/*  2928*/      OPC_MoveParent,
/*  2929*/      OPC_RecordChild1, // #2 = $addr
/*  2930*/      OPC_CheckType, MVT::i32,
/*  2932*/      OPC_MoveParent,
/*  2933*/      OPC_MoveChild2,
/*  2934*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  2937*/      OPC_RecordChild0, // #3 = $val
/*  2938*/      OPC_MoveParent,
/*  2939*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/*  2941*/      OPC_MoveParent,
/*  2942*/      OPC_MoveParent,
/*  2943*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  2945*/      OPC_EmitMergeInputChains1_0,
/*  2946*/      OPC_EmitInteger, MVT::i32, 0, 
/*  2949*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>), 65535:{ *:[i64] }) - Complexity = 27
                // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  2959*/    /*Scope*/ 54, /*->3014*/
/*  2960*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  2963*/      OPC_MoveChild0,
/*  2964*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  2967*/      OPC_MoveChild0,
/*  2968*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  2971*/      OPC_RecordMemRef,
/*  2972*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  2973*/      OPC_CheckFoldableChainNode,
/*  2974*/      OPC_MoveChild1,
/*  2975*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  2978*/      OPC_RecordChild0, // #1 = $addr
/*  2979*/      OPC_MoveChild1,
/*  2980*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  2983*/      OPC_RecordChild0, // #2 = $off
/*  2984*/      OPC_MoveChild0,
/*  2985*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  2988*/      OPC_MoveParent,
/*  2989*/      OPC_MoveParent,
/*  2990*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  2992*/      OPC_CheckType, MVT::i32,
/*  2994*/      OPC_MoveParent,
/*  2995*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/*  2997*/      OPC_MoveParent,
/*  2998*/      OPC_MoveParent,
/*  2999*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3001*/      OPC_EmitMergeInputChains1_0,
/*  3002*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3005*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 3, 2, 1, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>)<<P:Predicate_atomic_load_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  3014*/    /*Scope*/ 55, /*->3070*/
/*  3015*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  3019*/      OPC_MoveChild0,
/*  3020*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3023*/      OPC_MoveChild0,
/*  3024*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  3027*/      OPC_RecordMemRef,
/*  3028*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  3029*/      OPC_CheckFoldableChainNode,
/*  3030*/      OPC_MoveChild1,
/*  3031*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  3034*/      OPC_RecordChild0, // #1 = $addr
/*  3035*/      OPC_MoveChild1,
/*  3036*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  3039*/      OPC_RecordChild0, // #2 = $off
/*  3040*/      OPC_MoveChild0,
/*  3041*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  3044*/      OPC_MoveParent,
/*  3045*/      OPC_MoveParent,
/*  3046*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  3048*/      OPC_CheckType, MVT::i32,
/*  3050*/      OPC_MoveParent,
/*  3051*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/*  3053*/      OPC_MoveParent,
/*  3054*/      OPC_MoveParent,
/*  3055*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3057*/      OPC_EmitMergeInputChains1_0,
/*  3058*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3061*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 3, 2, 1, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>)<<P:Predicate_atomic_load_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  3070*/    /*Scope*/ 58, /*->3129*/
/*  3071*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  3074*/      OPC_MoveChild0,
/*  3075*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3078*/      OPC_MoveChild0,
/*  3079*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  3082*/      OPC_RecordMemRef,
/*  3083*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  3084*/      OPC_CheckFoldableChainNode,
/*  3085*/      OPC_MoveChild1,
/*  3086*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  3089*/      OPC_RecordChild0, // #1 = $addr
/*  3090*/      OPC_RecordChild1, // #2 = $off
/*  3091*/      OPC_MoveChild1,
/*  3092*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3095*/      OPC_MoveParent,
/*  3096*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  3098*/      OPC_CheckType, MVT::i32,
/*  3100*/      OPC_MoveParent,
/*  3101*/      OPC_MoveChild2,
/*  3102*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3105*/      OPC_RecordChild0, // #3 = $val
/*  3106*/      OPC_MoveParent,
/*  3107*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/*  3109*/      OPC_MoveParent,
/*  3110*/      OPC_MoveParent,
/*  3111*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3113*/      OPC_EmitMergeInputChains1_0,
/*  3114*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3117*/      OPC_EmitConvertToTarget, 2,
/*  3119*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3129*/    /*Scope*/ 59, /*->3189*/
/*  3130*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  3134*/      OPC_MoveChild0,
/*  3135*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3138*/      OPC_MoveChild0,
/*  3139*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  3142*/      OPC_RecordMemRef,
/*  3143*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  3144*/      OPC_CheckFoldableChainNode,
/*  3145*/      OPC_MoveChild1,
/*  3146*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  3149*/      OPC_RecordChild0, // #1 = $addr
/*  3150*/      OPC_RecordChild1, // #2 = $off
/*  3151*/      OPC_MoveChild1,
/*  3152*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3155*/      OPC_MoveParent,
/*  3156*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  3158*/      OPC_CheckType, MVT::i32,
/*  3160*/      OPC_MoveParent,
/*  3161*/      OPC_MoveChild2,
/*  3162*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3165*/      OPC_RecordChild0, // #3 = $val
/*  3166*/      OPC_MoveParent,
/*  3167*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/*  3169*/      OPC_MoveParent,
/*  3170*/      OPC_MoveParent,
/*  3171*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3173*/      OPC_EmitMergeInputChains1_0,
/*  3174*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3177*/      OPC_EmitConvertToTarget, 2,
/*  3179*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3189*/    /*Scope*/ 58, /*->3248*/
/*  3190*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  3193*/      OPC_MoveChild0,
/*  3194*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3197*/      OPC_MoveChild0,
/*  3198*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  3201*/      OPC_RecordMemRef,
/*  3202*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  3203*/      OPC_CheckFoldableChainNode,
/*  3204*/      OPC_MoveChild1,
/*  3205*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  3208*/      OPC_RecordChild0, // #1 = $addr
/*  3209*/      OPC_RecordChild1, // #2 = $off
/*  3210*/      OPC_MoveChild1,
/*  3211*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3214*/      OPC_MoveParent,
/*  3215*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  3217*/      OPC_CheckType, MVT::i32,
/*  3219*/      OPC_MoveParent,
/*  3220*/      OPC_MoveChild2,
/*  3221*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3224*/      OPC_RecordChild0, // #3 = $val
/*  3225*/      OPC_MoveParent,
/*  3226*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/*  3228*/      OPC_MoveParent,
/*  3229*/      OPC_MoveParent,
/*  3230*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3232*/      OPC_EmitMergeInputChains1_0,
/*  3233*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3236*/      OPC_EmitConvertToTarget, 2,
/*  3238*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3248*/    /*Scope*/ 59, /*->3308*/
/*  3249*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  3253*/      OPC_MoveChild0,
/*  3254*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3257*/      OPC_MoveChild0,
/*  3258*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  3261*/      OPC_RecordMemRef,
/*  3262*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  3263*/      OPC_CheckFoldableChainNode,
/*  3264*/      OPC_MoveChild1,
/*  3265*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  3268*/      OPC_RecordChild0, // #1 = $addr
/*  3269*/      OPC_RecordChild1, // #2 = $off
/*  3270*/      OPC_MoveChild1,
/*  3271*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3274*/      OPC_MoveParent,
/*  3275*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  3277*/      OPC_CheckType, MVT::i32,
/*  3279*/      OPC_MoveParent,
/*  3280*/      OPC_MoveChild2,
/*  3281*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3284*/      OPC_RecordChild0, // #3 = $val
/*  3285*/      OPC_MoveParent,
/*  3286*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/*  3288*/      OPC_MoveParent,
/*  3289*/      OPC_MoveParent,
/*  3290*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3292*/      OPC_EmitMergeInputChains1_0,
/*  3293*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3296*/      OPC_EmitConvertToTarget, 2,
/*  3298*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3308*/    /*Scope*/ 58, /*->3367*/
/*  3309*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  3312*/      OPC_MoveChild0,
/*  3313*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3316*/      OPC_MoveChild0,
/*  3317*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  3320*/      OPC_RecordMemRef,
/*  3321*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  3322*/      OPC_CheckFoldableChainNode,
/*  3323*/      OPC_MoveChild1,
/*  3324*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  3327*/      OPC_RecordChild0, // #1 = $addr
/*  3328*/      OPC_RecordChild1, // #2 = $off
/*  3329*/      OPC_MoveChild1,
/*  3330*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3333*/      OPC_MoveParent,
/*  3334*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  3336*/      OPC_CheckType, MVT::i32,
/*  3338*/      OPC_MoveParent,
/*  3339*/      OPC_MoveChild2,
/*  3340*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3343*/      OPC_RecordChild0, // #3 = $val
/*  3344*/      OPC_MoveParent,
/*  3345*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/*  3347*/      OPC_MoveParent,
/*  3348*/      OPC_MoveParent,
/*  3349*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3351*/      OPC_EmitMergeInputChains1_0,
/*  3352*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3355*/      OPC_EmitConvertToTarget, 2,
/*  3357*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3367*/    /*Scope*/ 59, /*->3427*/
/*  3368*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  3372*/      OPC_MoveChild0,
/*  3373*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3376*/      OPC_MoveChild0,
/*  3377*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  3380*/      OPC_RecordMemRef,
/*  3381*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  3382*/      OPC_CheckFoldableChainNode,
/*  3383*/      OPC_MoveChild1,
/*  3384*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  3387*/      OPC_RecordChild0, // #1 = $addr
/*  3388*/      OPC_RecordChild1, // #2 = $off
/*  3389*/      OPC_MoveChild1,
/*  3390*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3393*/      OPC_MoveParent,
/*  3394*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  3396*/      OPC_CheckType, MVT::i32,
/*  3398*/      OPC_MoveParent,
/*  3399*/      OPC_MoveChild2,
/*  3400*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3403*/      OPC_RecordChild0, // #3 = $val
/*  3404*/      OPC_MoveParent,
/*  3405*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/*  3407*/      OPC_MoveParent,
/*  3408*/      OPC_MoveParent,
/*  3409*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3411*/      OPC_EmitMergeInputChains1_0,
/*  3412*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3415*/      OPC_EmitConvertToTarget, 2,
/*  3417*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3427*/    /*Scope*/ 58, /*->3486*/
/*  3428*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  3431*/      OPC_MoveChild0,
/*  3432*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3435*/      OPC_MoveChild0,
/*  3436*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  3439*/      OPC_RecordMemRef,
/*  3440*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  3441*/      OPC_CheckFoldableChainNode,
/*  3442*/      OPC_MoveChild1,
/*  3443*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  3446*/      OPC_RecordChild0, // #1 = $addr
/*  3447*/      OPC_RecordChild1, // #2 = $off
/*  3448*/      OPC_MoveChild1,
/*  3449*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3452*/      OPC_MoveParent,
/*  3453*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  3455*/      OPC_CheckType, MVT::i32,
/*  3457*/      OPC_MoveParent,
/*  3458*/      OPC_MoveChild2,
/*  3459*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3462*/      OPC_RecordChild0, // #3 = $val
/*  3463*/      OPC_MoveParent,
/*  3464*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/*  3466*/      OPC_MoveParent,
/*  3467*/      OPC_MoveParent,
/*  3468*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3470*/      OPC_EmitMergeInputChains1_0,
/*  3471*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3474*/      OPC_EmitConvertToTarget, 2,
/*  3476*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3486*/    /*Scope*/ 59, /*->3546*/
/*  3487*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  3491*/      OPC_MoveChild0,
/*  3492*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3495*/      OPC_MoveChild0,
/*  3496*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  3499*/      OPC_RecordMemRef,
/*  3500*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  3501*/      OPC_CheckFoldableChainNode,
/*  3502*/      OPC_MoveChild1,
/*  3503*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  3506*/      OPC_RecordChild0, // #1 = $addr
/*  3507*/      OPC_RecordChild1, // #2 = $off
/*  3508*/      OPC_MoveChild1,
/*  3509*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3512*/      OPC_MoveParent,
/*  3513*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  3515*/      OPC_CheckType, MVT::i32,
/*  3517*/      OPC_MoveParent,
/*  3518*/      OPC_MoveChild2,
/*  3519*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3522*/      OPC_RecordChild0, // #3 = $val
/*  3523*/      OPC_MoveParent,
/*  3524*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/*  3526*/      OPC_MoveParent,
/*  3527*/      OPC_MoveParent,
/*  3528*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3530*/      OPC_EmitMergeInputChains1_0,
/*  3531*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3534*/      OPC_EmitConvertToTarget, 2,
/*  3536*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3546*/    /*Scope*/ 58, /*->3605*/
/*  3547*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  3550*/      OPC_MoveChild0,
/*  3551*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3554*/      OPC_MoveChild0,
/*  3555*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  3558*/      OPC_RecordMemRef,
/*  3559*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  3560*/      OPC_CheckFoldableChainNode,
/*  3561*/      OPC_MoveChild1,
/*  3562*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  3565*/      OPC_RecordChild0, // #1 = $addr
/*  3566*/      OPC_RecordChild1, // #2 = $off
/*  3567*/      OPC_MoveChild1,
/*  3568*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3571*/      OPC_MoveParent,
/*  3572*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  3574*/      OPC_CheckType, MVT::i32,
/*  3576*/      OPC_MoveParent,
/*  3577*/      OPC_MoveChild2,
/*  3578*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3581*/      OPC_RecordChild0, // #3 = $val
/*  3582*/      OPC_MoveParent,
/*  3583*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/*  3585*/      OPC_MoveParent,
/*  3586*/      OPC_MoveParent,
/*  3587*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3589*/      OPC_EmitMergeInputChains1_0,
/*  3590*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3593*/      OPC_EmitConvertToTarget, 2,
/*  3595*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3605*/    /*Scope*/ 59, /*->3665*/
/*  3606*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  3610*/      OPC_MoveChild0,
/*  3611*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3614*/      OPC_MoveChild0,
/*  3615*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  3618*/      OPC_RecordMemRef,
/*  3619*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  3620*/      OPC_CheckFoldableChainNode,
/*  3621*/      OPC_MoveChild1,
/*  3622*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  3625*/      OPC_RecordChild0, // #1 = $addr
/*  3626*/      OPC_RecordChild1, // #2 = $off
/*  3627*/      OPC_MoveChild1,
/*  3628*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3631*/      OPC_MoveParent,
/*  3632*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  3634*/      OPC_CheckType, MVT::i32,
/*  3636*/      OPC_MoveParent,
/*  3637*/      OPC_MoveChild2,
/*  3638*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3641*/      OPC_RecordChild0, // #3 = $val
/*  3642*/      OPC_MoveParent,
/*  3643*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/*  3645*/      OPC_MoveParent,
/*  3646*/      OPC_MoveParent,
/*  3647*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3649*/      OPC_EmitMergeInputChains1_0,
/*  3650*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3653*/      OPC_EmitConvertToTarget, 2,
/*  3655*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3665*/    /*Scope*/ 58, /*->3724*/
/*  3666*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  3669*/      OPC_MoveChild0,
/*  3670*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3673*/      OPC_MoveChild0,
/*  3674*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  3677*/      OPC_RecordMemRef,
/*  3678*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  3679*/      OPC_CheckFoldableChainNode,
/*  3680*/      OPC_MoveChild1,
/*  3681*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  3684*/      OPC_RecordChild0, // #1 = $addr
/*  3685*/      OPC_RecordChild1, // #2 = $off
/*  3686*/      OPC_MoveChild1,
/*  3687*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3690*/      OPC_MoveParent,
/*  3691*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  3693*/      OPC_CheckType, MVT::i32,
/*  3695*/      OPC_MoveParent,
/*  3696*/      OPC_MoveChild2,
/*  3697*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3700*/      OPC_RecordChild0, // #3 = $val
/*  3701*/      OPC_MoveParent,
/*  3702*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/*  3704*/      OPC_MoveParent,
/*  3705*/      OPC_MoveParent,
/*  3706*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3708*/      OPC_EmitMergeInputChains1_0,
/*  3709*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3712*/      OPC_EmitConvertToTarget, 2,
/*  3714*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3724*/    /*Scope*/ 59, /*->3784*/
/*  3725*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  3729*/      OPC_MoveChild0,
/*  3730*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3733*/      OPC_MoveChild0,
/*  3734*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  3737*/      OPC_RecordMemRef,
/*  3738*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  3739*/      OPC_CheckFoldableChainNode,
/*  3740*/      OPC_MoveChild1,
/*  3741*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  3744*/      OPC_RecordChild0, // #1 = $addr
/*  3745*/      OPC_RecordChild1, // #2 = $off
/*  3746*/      OPC_MoveChild1,
/*  3747*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3750*/      OPC_MoveParent,
/*  3751*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  3753*/      OPC_CheckType, MVT::i32,
/*  3755*/      OPC_MoveParent,
/*  3756*/      OPC_MoveChild2,
/*  3757*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3760*/      OPC_RecordChild0, // #3 = $val
/*  3761*/      OPC_MoveParent,
/*  3762*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/*  3764*/      OPC_MoveParent,
/*  3765*/      OPC_MoveParent,
/*  3766*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3768*/      OPC_EmitMergeInputChains1_0,
/*  3769*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3772*/      OPC_EmitConvertToTarget, 2,
/*  3774*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3784*/    /*Scope*/ 58, /*->3843*/
/*  3785*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  3788*/      OPC_MoveChild0,
/*  3789*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3792*/      OPC_MoveChild0,
/*  3793*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  3796*/      OPC_RecordMemRef,
/*  3797*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  3798*/      OPC_CheckFoldableChainNode,
/*  3799*/      OPC_MoveChild1,
/*  3800*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  3803*/      OPC_RecordChild0, // #1 = $addr
/*  3804*/      OPC_RecordChild1, // #2 = $off
/*  3805*/      OPC_MoveChild1,
/*  3806*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3809*/      OPC_MoveParent,
/*  3810*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  3812*/      OPC_CheckType, MVT::i32,
/*  3814*/      OPC_MoveParent,
/*  3815*/      OPC_MoveChild2,
/*  3816*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3819*/      OPC_RecordChild0, // #3 = $val
/*  3820*/      OPC_MoveParent,
/*  3821*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/*  3823*/      OPC_MoveParent,
/*  3824*/      OPC_MoveParent,
/*  3825*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3827*/      OPC_EmitMergeInputChains1_0,
/*  3828*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3831*/      OPC_EmitConvertToTarget, 2,
/*  3833*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3843*/    /*Scope*/ 59, /*->3903*/
/*  3844*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  3848*/      OPC_MoveChild0,
/*  3849*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3852*/      OPC_MoveChild0,
/*  3853*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  3856*/      OPC_RecordMemRef,
/*  3857*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  3858*/      OPC_CheckFoldableChainNode,
/*  3859*/      OPC_MoveChild1,
/*  3860*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  3863*/      OPC_RecordChild0, // #1 = $addr
/*  3864*/      OPC_RecordChild1, // #2 = $off
/*  3865*/      OPC_MoveChild1,
/*  3866*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3869*/      OPC_MoveParent,
/*  3870*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  3872*/      OPC_CheckType, MVT::i32,
/*  3874*/      OPC_MoveParent,
/*  3875*/      OPC_MoveChild2,
/*  3876*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3879*/      OPC_RecordChild0, // #3 = $val
/*  3880*/      OPC_MoveParent,
/*  3881*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/*  3883*/      OPC_MoveParent,
/*  3884*/      OPC_MoveParent,
/*  3885*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3887*/      OPC_EmitMergeInputChains1_0,
/*  3888*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3891*/      OPC_EmitConvertToTarget, 2,
/*  3893*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3903*/    /*Scope*/ 58, /*->3962*/
/*  3904*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  3907*/      OPC_MoveChild0,
/*  3908*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3911*/      OPC_MoveChild0,
/*  3912*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  3915*/      OPC_RecordMemRef,
/*  3916*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  3917*/      OPC_CheckFoldableChainNode,
/*  3918*/      OPC_MoveChild1,
/*  3919*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  3922*/      OPC_RecordChild0, // #1 = $addr
/*  3923*/      OPC_RecordChild1, // #2 = $off
/*  3924*/      OPC_MoveChild1,
/*  3925*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3928*/      OPC_MoveParent,
/*  3929*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  3931*/      OPC_CheckType, MVT::i32,
/*  3933*/      OPC_MoveParent,
/*  3934*/      OPC_MoveChild2,
/*  3935*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3938*/      OPC_RecordChild0, // #3 = $val
/*  3939*/      OPC_MoveParent,
/*  3940*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/*  3942*/      OPC_MoveParent,
/*  3943*/      OPC_MoveParent,
/*  3944*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  3946*/      OPC_EmitMergeInputChains1_0,
/*  3947*/      OPC_EmitInteger, MVT::i32, 0, 
/*  3950*/      OPC_EmitConvertToTarget, 2,
/*  3952*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  3962*/    /*Scope*/ 59, /*->4022*/
/*  3963*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  3967*/      OPC_MoveChild0,
/*  3968*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  3971*/      OPC_MoveChild0,
/*  3972*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  3975*/      OPC_RecordMemRef,
/*  3976*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  3977*/      OPC_CheckFoldableChainNode,
/*  3978*/      OPC_MoveChild1,
/*  3979*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  3982*/      OPC_RecordChild0, // #1 = $addr
/*  3983*/      OPC_RecordChild1, // #2 = $off
/*  3984*/      OPC_MoveChild1,
/*  3985*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  3988*/      OPC_MoveParent,
/*  3989*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  3991*/      OPC_CheckType, MVT::i32,
/*  3993*/      OPC_MoveParent,
/*  3994*/      OPC_MoveChild2,
/*  3995*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  3998*/      OPC_RecordChild0, // #3 = $val
/*  3999*/      OPC_MoveParent,
/*  4000*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/*  4002*/      OPC_MoveParent,
/*  4003*/      OPC_MoveParent,
/*  4004*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4006*/      OPC_EmitMergeInputChains1_0,
/*  4007*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4010*/      OPC_EmitConvertToTarget, 2,
/*  4012*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  4022*/    /*Scope*/ 58, /*->4081*/
/*  4023*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  4026*/      OPC_MoveChild0,
/*  4027*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4030*/      OPC_MoveChild0,
/*  4031*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  4034*/      OPC_RecordMemRef,
/*  4035*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  4036*/      OPC_CheckFoldableChainNode,
/*  4037*/      OPC_MoveChild1,
/*  4038*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  4041*/      OPC_RecordChild0, // #1 = $addr
/*  4042*/      OPC_RecordChild1, // #2 = $off
/*  4043*/      OPC_MoveChild1,
/*  4044*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  4047*/      OPC_MoveParent,
/*  4048*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  4050*/      OPC_CheckType, MVT::i32,
/*  4052*/      OPC_MoveParent,
/*  4053*/      OPC_MoveChild2,
/*  4054*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  4057*/      OPC_RecordChild0, // #3 = $val
/*  4058*/      OPC_MoveParent,
/*  4059*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/*  4061*/      OPC_MoveParent,
/*  4062*/      OPC_MoveParent,
/*  4063*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4065*/      OPC_EmitMergeInputChains1_0,
/*  4066*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4069*/      OPC_EmitConvertToTarget, 2,
/*  4071*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  4081*/    /*Scope*/ 59, /*->4141*/
/*  4082*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  4086*/      OPC_MoveChild0,
/*  4087*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4090*/      OPC_MoveChild0,
/*  4091*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  4094*/      OPC_RecordMemRef,
/*  4095*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  4096*/      OPC_CheckFoldableChainNode,
/*  4097*/      OPC_MoveChild1,
/*  4098*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  4101*/      OPC_RecordChild0, // #1 = $addr
/*  4102*/      OPC_RecordChild1, // #2 = $off
/*  4103*/      OPC_MoveChild1,
/*  4104*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  4107*/      OPC_MoveParent,
/*  4108*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  4110*/      OPC_CheckType, MVT::i32,
/*  4112*/      OPC_MoveParent,
/*  4113*/      OPC_MoveChild2,
/*  4114*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  4117*/      OPC_RecordChild0, // #3 = $val
/*  4118*/      OPC_MoveParent,
/*  4119*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/*  4121*/      OPC_MoveParent,
/*  4122*/      OPC_MoveParent,
/*  4123*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4125*/      OPC_EmitMergeInputChains1_0,
/*  4126*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4129*/      OPC_EmitConvertToTarget, 2,
/*  4131*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  4141*/    /*Scope*/ 58, /*->4200*/
/*  4142*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  4145*/      OPC_MoveChild0,
/*  4146*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4149*/      OPC_MoveChild0,
/*  4150*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  4153*/      OPC_RecordMemRef,
/*  4154*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  4155*/      OPC_CheckFoldableChainNode,
/*  4156*/      OPC_MoveChild1,
/*  4157*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  4160*/      OPC_RecordChild0, // #1 = $addr
/*  4161*/      OPC_RecordChild1, // #2 = $off
/*  4162*/      OPC_MoveChild1,
/*  4163*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  4166*/      OPC_MoveParent,
/*  4167*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  4169*/      OPC_CheckType, MVT::i32,
/*  4171*/      OPC_MoveParent,
/*  4172*/      OPC_MoveChild2,
/*  4173*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  4176*/      OPC_RecordChild0, // #3 = $val
/*  4177*/      OPC_MoveParent,
/*  4178*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/*  4180*/      OPC_MoveParent,
/*  4181*/      OPC_MoveParent,
/*  4182*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4184*/      OPC_EmitMergeInputChains1_0,
/*  4185*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4188*/      OPC_EmitConvertToTarget, 2,
/*  4190*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  4200*/    /*Scope*/ 59, /*->4260*/
/*  4201*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  4205*/      OPC_MoveChild0,
/*  4206*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4209*/      OPC_MoveChild0,
/*  4210*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  4213*/      OPC_RecordMemRef,
/*  4214*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  4215*/      OPC_CheckFoldableChainNode,
/*  4216*/      OPC_MoveChild1,
/*  4217*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  4220*/      OPC_RecordChild0, // #1 = $addr
/*  4221*/      OPC_RecordChild1, // #2 = $off
/*  4222*/      OPC_MoveChild1,
/*  4223*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  4226*/      OPC_MoveParent,
/*  4227*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  4229*/      OPC_CheckType, MVT::i32,
/*  4231*/      OPC_MoveParent,
/*  4232*/      OPC_MoveChild2,
/*  4233*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  4236*/      OPC_RecordChild0, // #3 = $val
/*  4237*/      OPC_MoveParent,
/*  4238*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/*  4240*/      OPC_MoveParent,
/*  4241*/      OPC_MoveParent,
/*  4242*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4244*/      OPC_EmitMergeInputChains1_0,
/*  4245*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4248*/      OPC_EmitConvertToTarget, 2,
/*  4250*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  4260*/    /*Scope*/ 58, /*->4319*/
/*  4261*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  4264*/      OPC_MoveChild0,
/*  4265*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4268*/      OPC_MoveChild0,
/*  4269*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  4272*/      OPC_RecordMemRef,
/*  4273*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  4274*/      OPC_CheckFoldableChainNode,
/*  4275*/      OPC_MoveChild1,
/*  4276*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  4279*/      OPC_RecordChild0, // #1 = $addr
/*  4280*/      OPC_RecordChild1, // #2 = $off
/*  4281*/      OPC_MoveChild1,
/*  4282*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  4285*/      OPC_MoveParent,
/*  4286*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  4288*/      OPC_CheckType, MVT::i32,
/*  4290*/      OPC_MoveParent,
/*  4291*/      OPC_MoveChild2,
/*  4292*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  4295*/      OPC_RecordChild0, // #3 = $val
/*  4296*/      OPC_MoveParent,
/*  4297*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/*  4299*/      OPC_MoveParent,
/*  4300*/      OPC_MoveParent,
/*  4301*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4303*/      OPC_EmitMergeInputChains1_0,
/*  4304*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4307*/      OPC_EmitConvertToTarget, 2,
/*  4309*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  4319*/    /*Scope*/ 59, /*->4379*/
/*  4320*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  4324*/      OPC_MoveChild0,
/*  4325*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4328*/      OPC_MoveChild0,
/*  4329*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  4332*/      OPC_RecordMemRef,
/*  4333*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  4334*/      OPC_CheckFoldableChainNode,
/*  4335*/      OPC_MoveChild1,
/*  4336*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  4339*/      OPC_RecordChild0, // #1 = $addr
/*  4340*/      OPC_RecordChild1, // #2 = $off
/*  4341*/      OPC_MoveChild1,
/*  4342*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  4345*/      OPC_MoveParent,
/*  4346*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  4348*/      OPC_CheckType, MVT::i32,
/*  4350*/      OPC_MoveParent,
/*  4351*/      OPC_MoveChild2,
/*  4352*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  4355*/      OPC_RecordChild0, // #3 = $val
/*  4356*/      OPC_MoveParent,
/*  4357*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/*  4359*/      OPC_MoveParent,
/*  4360*/      OPC_MoveParent,
/*  4361*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4363*/      OPC_EmitMergeInputChains1_0,
/*  4364*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4367*/      OPC_EmitConvertToTarget, 2,
/*  4369*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  4379*/    /*Scope*/ 58, /*->4438*/
/*  4380*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  4383*/      OPC_MoveChild0,
/*  4384*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4387*/      OPC_MoveChild0,
/*  4388*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  4391*/      OPC_RecordMemRef,
/*  4392*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  4393*/      OPC_CheckFoldableChainNode,
/*  4394*/      OPC_MoveChild1,
/*  4395*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  4398*/      OPC_RecordChild0, // #1 = $addr
/*  4399*/      OPC_RecordChild1, // #2 = $off
/*  4400*/      OPC_MoveChild1,
/*  4401*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  4404*/      OPC_MoveParent,
/*  4405*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  4407*/      OPC_CheckType, MVT::i32,
/*  4409*/      OPC_MoveParent,
/*  4410*/      OPC_MoveChild2,
/*  4411*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  4414*/      OPC_RecordChild0, // #3 = $val
/*  4415*/      OPC_MoveParent,
/*  4416*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/*  4418*/      OPC_MoveParent,
/*  4419*/      OPC_MoveParent,
/*  4420*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4422*/      OPC_EmitMergeInputChains1_0,
/*  4423*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4426*/      OPC_EmitConvertToTarget, 2,
/*  4428*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  4438*/    /*Scope*/ 59, /*->4498*/
/*  4439*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  4443*/      OPC_MoveChild0,
/*  4444*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4447*/      OPC_MoveChild0,
/*  4448*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  4451*/      OPC_RecordMemRef,
/*  4452*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  4453*/      OPC_CheckFoldableChainNode,
/*  4454*/      OPC_MoveChild1,
/*  4455*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  4458*/      OPC_RecordChild0, // #1 = $addr
/*  4459*/      OPC_RecordChild1, // #2 = $off
/*  4460*/      OPC_MoveChild1,
/*  4461*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  4464*/      OPC_MoveParent,
/*  4465*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  4467*/      OPC_CheckType, MVT::i32,
/*  4469*/      OPC_MoveParent,
/*  4470*/      OPC_MoveChild2,
/*  4471*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  4474*/      OPC_RecordChild0, // #3 = $val
/*  4475*/      OPC_MoveParent,
/*  4476*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/*  4478*/      OPC_MoveParent,
/*  4479*/      OPC_MoveParent,
/*  4480*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4482*/      OPC_EmitMergeInputChains1_0,
/*  4483*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4486*/      OPC_EmitConvertToTarget, 2,
/*  4488*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/*  4498*/    /*Scope*/ 54, /*->4553*/
/*  4499*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  4502*/      OPC_MoveChild0,
/*  4503*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4506*/      OPC_MoveChild0,
/*  4507*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  4510*/      OPC_RecordMemRef,
/*  4511*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  4512*/      OPC_CheckFoldableChainNode,
/*  4513*/      OPC_MoveChild1,
/*  4514*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  4517*/      OPC_MoveChild0,
/*  4518*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  4521*/      OPC_RecordChild0, // #1 = $off
/*  4522*/      OPC_MoveChild0,
/*  4523*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  4526*/      OPC_MoveParent,
/*  4527*/      OPC_MoveParent,
/*  4528*/      OPC_RecordChild1, // #2 = $addr
/*  4529*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  4531*/      OPC_CheckType, MVT::i32,
/*  4533*/      OPC_MoveParent,
/*  4534*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/*  4536*/      OPC_MoveParent,
/*  4537*/      OPC_MoveParent,
/*  4538*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4540*/      OPC_EmitMergeInputChains1_0,
/*  4541*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4544*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 3, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>)<<P:Predicate_atomic_load_8>>), 255:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  4553*/    /*Scope*/ 55, /*->4609*/
/*  4554*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  4558*/      OPC_MoveChild0,
/*  4559*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4562*/      OPC_MoveChild0,
/*  4563*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  4566*/      OPC_RecordMemRef,
/*  4567*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  4568*/      OPC_CheckFoldableChainNode,
/*  4569*/      OPC_MoveChild1,
/*  4570*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  4573*/      OPC_MoveChild0,
/*  4574*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  4577*/      OPC_RecordChild0, // #1 = $off
/*  4578*/      OPC_MoveChild0,
/*  4579*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  4582*/      OPC_MoveParent,
/*  4583*/      OPC_MoveParent,
/*  4584*/      OPC_RecordChild1, // #2 = $addr
/*  4585*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  4587*/      OPC_CheckType, MVT::i32,
/*  4589*/      OPC_MoveParent,
/*  4590*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/*  4592*/      OPC_MoveParent,
/*  4593*/      OPC_MoveParent,
/*  4594*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4596*/      OPC_EmitMergeInputChains1_0,
/*  4597*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4600*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 3, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>)<<P:Predicate_atomic_load_16>>), 65535:{ *:[i64] }) - Complexity = 25
                // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  4609*/    /*Scope*/ 52, /*->4662*/
/*  4610*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  4613*/      OPC_MoveChild0,
/*  4614*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4617*/      OPC_MoveChild0,
/*  4618*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  4621*/      OPC_RecordMemRef,
/*  4622*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  4623*/      OPC_CheckFoldableChainNode,
/*  4624*/      OPC_MoveChild1,
/*  4625*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  4628*/      OPC_RecordChild0, // #1 = $addr
/*  4629*/      OPC_MoveChild1,
/*  4630*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  4633*/      OPC_RecordChild0, // #2 = $off
/*  4634*/      OPC_MoveChild0,
/*  4635*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  4638*/      OPC_MoveParent,
/*  4639*/      OPC_MoveParent,
/*  4640*/      OPC_CheckType, MVT::i32,
/*  4642*/      OPC_MoveParent,
/*  4643*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/*  4645*/      OPC_MoveParent,
/*  4646*/      OPC_MoveParent,
/*  4647*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4649*/      OPC_EmitMergeInputChains1_0,
/*  4650*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4653*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 3, 2, 1, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)))<<P:Predicate_atomic_load_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  4662*/    /*Scope*/ 53, /*->4716*/
/*  4663*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  4667*/      OPC_MoveChild0,
/*  4668*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4671*/      OPC_MoveChild0,
/*  4672*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  4675*/      OPC_RecordMemRef,
/*  4676*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  4677*/      OPC_CheckFoldableChainNode,
/*  4678*/      OPC_MoveChild1,
/*  4679*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  4682*/      OPC_RecordChild0, // #1 = $addr
/*  4683*/      OPC_MoveChild1,
/*  4684*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  4687*/      OPC_RecordChild0, // #2 = $off
/*  4688*/      OPC_MoveChild0,
/*  4689*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  4692*/      OPC_MoveParent,
/*  4693*/      OPC_MoveParent,
/*  4694*/      OPC_CheckType, MVT::i32,
/*  4696*/      OPC_MoveParent,
/*  4697*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/*  4699*/      OPC_MoveParent,
/*  4700*/      OPC_MoveParent,
/*  4701*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4703*/      OPC_EmitMergeInputChains1_0,
/*  4704*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4707*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 3, 2, 1, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)))<<P:Predicate_atomic_load_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  4716*/    /*Scope*/ 52, /*->4769*/
/*  4717*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  4720*/      OPC_MoveChild0,
/*  4721*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4724*/      OPC_MoveChild0,
/*  4725*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  4728*/      OPC_RecordMemRef,
/*  4729*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  4730*/      OPC_CheckFoldableChainNode,
/*  4731*/      OPC_MoveChild1,
/*  4732*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  4735*/      OPC_MoveChild0,
/*  4736*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  4739*/      OPC_RecordChild0, // #1 = $off
/*  4740*/      OPC_MoveChild0,
/*  4741*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  4744*/      OPC_MoveParent,
/*  4745*/      OPC_MoveParent,
/*  4746*/      OPC_RecordChild1, // #2 = $addr
/*  4747*/      OPC_CheckType, MVT::i32,
/*  4749*/      OPC_MoveParent,
/*  4750*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/*  4752*/      OPC_MoveParent,
/*  4753*/      OPC_MoveParent,
/*  4754*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4756*/      OPC_EmitMergeInputChains1_0,
/*  4757*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4760*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 3, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr))<<P:Predicate_atomic_load_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  4769*/    /*Scope*/ 53, /*->4823*/
/*  4770*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  4774*/      OPC_MoveChild0,
/*  4775*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4778*/      OPC_MoveChild0,
/*  4779*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  4782*/      OPC_RecordMemRef,
/*  4783*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  4784*/      OPC_CheckFoldableChainNode,
/*  4785*/      OPC_MoveChild1,
/*  4786*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  4789*/      OPC_MoveChild0,
/*  4790*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  4793*/      OPC_RecordChild0, // #1 = $off
/*  4794*/      OPC_MoveChild0,
/*  4795*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  4798*/      OPC_MoveParent,
/*  4799*/      OPC_MoveParent,
/*  4800*/      OPC_RecordChild1, // #2 = $addr
/*  4801*/      OPC_CheckType, MVT::i32,
/*  4803*/      OPC_MoveParent,
/*  4804*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/*  4806*/      OPC_MoveParent,
/*  4807*/      OPC_MoveParent,
/*  4808*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4810*/      OPC_EmitMergeInputChains1_0,
/*  4811*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4814*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 3, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr))<<P:Predicate_atomic_load_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  4823*/    /*Scope*/ 61, /*->4885*/
/*  4824*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  4827*/      OPC_MoveChild0,
/*  4828*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4831*/      OPC_MoveChild0,
/*  4832*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  4835*/      OPC_RecordMemRef,
/*  4836*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  4837*/      OPC_CheckFoldableChainNode,
/*  4838*/      OPC_MoveChild1,
/*  4839*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  4842*/      OPC_RecordChild0, // #1 = $off
/*  4843*/      OPC_MoveChild0,
/*  4844*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  4847*/      OPC_MoveParent,
/*  4848*/      OPC_MoveParent,
/*  4849*/      OPC_MoveChild2,
/*  4850*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  4853*/      OPC_RecordChild0, // #2 = $val
/*  4854*/      OPC_MoveParent,
/*  4855*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/*  4857*/      OPC_MoveParent,
/*  4858*/      OPC_MoveParent,
/*  4859*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4861*/      OPC_EmitMergeInputChains1_0,
/*  4862*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4865*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4868*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  4875*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  4885*/    /*Scope*/ 62, /*->4948*/
/*  4886*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  4890*/      OPC_MoveChild0,
/*  4891*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4894*/      OPC_MoveChild0,
/*  4895*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  4898*/      OPC_RecordMemRef,
/*  4899*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  4900*/      OPC_CheckFoldableChainNode,
/*  4901*/      OPC_MoveChild1,
/*  4902*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  4905*/      OPC_RecordChild0, // #1 = $off
/*  4906*/      OPC_MoveChild0,
/*  4907*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  4910*/      OPC_MoveParent,
/*  4911*/      OPC_MoveParent,
/*  4912*/      OPC_MoveChild2,
/*  4913*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  4916*/      OPC_RecordChild0, // #2 = $val
/*  4917*/      OPC_MoveParent,
/*  4918*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/*  4920*/      OPC_MoveParent,
/*  4921*/      OPC_MoveParent,
/*  4922*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4924*/      OPC_EmitMergeInputChains1_0,
/*  4925*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4928*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4931*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  4938*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  4948*/    /*Scope*/ 61, /*->5010*/
/*  4949*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  4952*/      OPC_MoveChild0,
/*  4953*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  4956*/      OPC_MoveChild0,
/*  4957*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  4960*/      OPC_RecordMemRef,
/*  4961*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  4962*/      OPC_CheckFoldableChainNode,
/*  4963*/      OPC_MoveChild1,
/*  4964*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  4967*/      OPC_RecordChild0, // #1 = $off
/*  4968*/      OPC_MoveChild0,
/*  4969*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  4972*/      OPC_MoveParent,
/*  4973*/      OPC_MoveParent,
/*  4974*/      OPC_MoveChild2,
/*  4975*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  4978*/      OPC_RecordChild0, // #2 = $val
/*  4979*/      OPC_MoveParent,
/*  4980*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/*  4982*/      OPC_MoveParent,
/*  4983*/      OPC_MoveParent,
/*  4984*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  4986*/      OPC_EmitMergeInputChains1_0,
/*  4987*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4990*/      OPC_EmitInteger, MVT::i32, 0, 
/*  4993*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5000*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5010*/    /*Scope*/ 62, /*->5073*/
/*  5011*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  5015*/      OPC_MoveChild0,
/*  5016*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5019*/      OPC_MoveChild0,
/*  5020*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  5023*/      OPC_RecordMemRef,
/*  5024*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  5025*/      OPC_CheckFoldableChainNode,
/*  5026*/      OPC_MoveChild1,
/*  5027*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5030*/      OPC_RecordChild0, // #1 = $off
/*  5031*/      OPC_MoveChild0,
/*  5032*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  5035*/      OPC_MoveParent,
/*  5036*/      OPC_MoveParent,
/*  5037*/      OPC_MoveChild2,
/*  5038*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5041*/      OPC_RecordChild0, // #2 = $val
/*  5042*/      OPC_MoveParent,
/*  5043*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/*  5045*/      OPC_MoveParent,
/*  5046*/      OPC_MoveParent,
/*  5047*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5049*/      OPC_EmitMergeInputChains1_0,
/*  5050*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5053*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5056*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5063*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5073*/    /*Scope*/ 61, /*->5135*/
/*  5074*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  5077*/      OPC_MoveChild0,
/*  5078*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5081*/      OPC_MoveChild0,
/*  5082*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  5085*/      OPC_RecordMemRef,
/*  5086*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  5087*/      OPC_CheckFoldableChainNode,
/*  5088*/      OPC_MoveChild1,
/*  5089*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5092*/      OPC_RecordChild0, // #1 = $off
/*  5093*/      OPC_MoveChild0,
/*  5094*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  5097*/      OPC_MoveParent,
/*  5098*/      OPC_MoveParent,
/*  5099*/      OPC_MoveChild2,
/*  5100*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5103*/      OPC_RecordChild0, // #2 = $val
/*  5104*/      OPC_MoveParent,
/*  5105*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/*  5107*/      OPC_MoveParent,
/*  5108*/      OPC_MoveParent,
/*  5109*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5111*/      OPC_EmitMergeInputChains1_0,
/*  5112*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5115*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5118*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5125*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5135*/    /*Scope*/ 62, /*->5198*/
/*  5136*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  5140*/      OPC_MoveChild0,
/*  5141*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5144*/      OPC_MoveChild0,
/*  5145*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  5148*/      OPC_RecordMemRef,
/*  5149*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  5150*/      OPC_CheckFoldableChainNode,
/*  5151*/      OPC_MoveChild1,
/*  5152*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5155*/      OPC_RecordChild0, // #1 = $off
/*  5156*/      OPC_MoveChild0,
/*  5157*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  5160*/      OPC_MoveParent,
/*  5161*/      OPC_MoveParent,
/*  5162*/      OPC_MoveChild2,
/*  5163*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5166*/      OPC_RecordChild0, // #2 = $val
/*  5167*/      OPC_MoveParent,
/*  5168*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/*  5170*/      OPC_MoveParent,
/*  5171*/      OPC_MoveParent,
/*  5172*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5174*/      OPC_EmitMergeInputChains1_0,
/*  5175*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5178*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5181*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5188*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5198*/    /*Scope*/ 61, /*->5260*/
/*  5199*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  5202*/      OPC_MoveChild0,
/*  5203*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5206*/      OPC_MoveChild0,
/*  5207*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  5210*/      OPC_RecordMemRef,
/*  5211*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  5212*/      OPC_CheckFoldableChainNode,
/*  5213*/      OPC_MoveChild1,
/*  5214*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5217*/      OPC_RecordChild0, // #1 = $off
/*  5218*/      OPC_MoveChild0,
/*  5219*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  5222*/      OPC_MoveParent,
/*  5223*/      OPC_MoveParent,
/*  5224*/      OPC_MoveChild2,
/*  5225*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5228*/      OPC_RecordChild0, // #2 = $val
/*  5229*/      OPC_MoveParent,
/*  5230*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/*  5232*/      OPC_MoveParent,
/*  5233*/      OPC_MoveParent,
/*  5234*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5236*/      OPC_EmitMergeInputChains1_0,
/*  5237*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5240*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5243*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5250*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5260*/    /*Scope*/ 62, /*->5323*/
/*  5261*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  5265*/      OPC_MoveChild0,
/*  5266*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5269*/      OPC_MoveChild0,
/*  5270*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  5273*/      OPC_RecordMemRef,
/*  5274*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  5275*/      OPC_CheckFoldableChainNode,
/*  5276*/      OPC_MoveChild1,
/*  5277*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5280*/      OPC_RecordChild0, // #1 = $off
/*  5281*/      OPC_MoveChild0,
/*  5282*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  5285*/      OPC_MoveParent,
/*  5286*/      OPC_MoveParent,
/*  5287*/      OPC_MoveChild2,
/*  5288*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5291*/      OPC_RecordChild0, // #2 = $val
/*  5292*/      OPC_MoveParent,
/*  5293*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/*  5295*/      OPC_MoveParent,
/*  5296*/      OPC_MoveParent,
/*  5297*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5299*/      OPC_EmitMergeInputChains1_0,
/*  5300*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5303*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5306*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5313*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5323*/    /*Scope*/ 61, /*->5385*/
/*  5324*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  5327*/      OPC_MoveChild0,
/*  5328*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5331*/      OPC_MoveChild0,
/*  5332*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  5335*/      OPC_RecordMemRef,
/*  5336*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  5337*/      OPC_CheckFoldableChainNode,
/*  5338*/      OPC_MoveChild1,
/*  5339*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5342*/      OPC_RecordChild0, // #1 = $off
/*  5343*/      OPC_MoveChild0,
/*  5344*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  5347*/      OPC_MoveParent,
/*  5348*/      OPC_MoveParent,
/*  5349*/      OPC_MoveChild2,
/*  5350*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5353*/      OPC_RecordChild0, // #2 = $val
/*  5354*/      OPC_MoveParent,
/*  5355*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/*  5357*/      OPC_MoveParent,
/*  5358*/      OPC_MoveParent,
/*  5359*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5361*/      OPC_EmitMergeInputChains1_0,
/*  5362*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5365*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5368*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5375*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5385*/    /*Scope*/ 62, /*->5448*/
/*  5386*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  5390*/      OPC_MoveChild0,
/*  5391*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5394*/      OPC_MoveChild0,
/*  5395*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  5398*/      OPC_RecordMemRef,
/*  5399*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  5400*/      OPC_CheckFoldableChainNode,
/*  5401*/      OPC_MoveChild1,
/*  5402*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5405*/      OPC_RecordChild0, // #1 = $off
/*  5406*/      OPC_MoveChild0,
/*  5407*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  5410*/      OPC_MoveParent,
/*  5411*/      OPC_MoveParent,
/*  5412*/      OPC_MoveChild2,
/*  5413*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5416*/      OPC_RecordChild0, // #2 = $val
/*  5417*/      OPC_MoveParent,
/*  5418*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/*  5420*/      OPC_MoveParent,
/*  5421*/      OPC_MoveParent,
/*  5422*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5424*/      OPC_EmitMergeInputChains1_0,
/*  5425*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5428*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5431*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5438*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5448*/    /*Scope*/ 61, /*->5510*/
/*  5449*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  5452*/      OPC_MoveChild0,
/*  5453*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5456*/      OPC_MoveChild0,
/*  5457*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  5460*/      OPC_RecordMemRef,
/*  5461*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  5462*/      OPC_CheckFoldableChainNode,
/*  5463*/      OPC_MoveChild1,
/*  5464*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5467*/      OPC_RecordChild0, // #1 = $off
/*  5468*/      OPC_MoveChild0,
/*  5469*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  5472*/      OPC_MoveParent,
/*  5473*/      OPC_MoveParent,
/*  5474*/      OPC_MoveChild2,
/*  5475*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5478*/      OPC_RecordChild0, // #2 = $val
/*  5479*/      OPC_MoveParent,
/*  5480*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/*  5482*/      OPC_MoveParent,
/*  5483*/      OPC_MoveParent,
/*  5484*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5486*/      OPC_EmitMergeInputChains1_0,
/*  5487*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5490*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5493*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5500*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5510*/    /*Scope*/ 62, /*->5573*/
/*  5511*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  5515*/      OPC_MoveChild0,
/*  5516*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5519*/      OPC_MoveChild0,
/*  5520*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  5523*/      OPC_RecordMemRef,
/*  5524*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  5525*/      OPC_CheckFoldableChainNode,
/*  5526*/      OPC_MoveChild1,
/*  5527*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5530*/      OPC_RecordChild0, // #1 = $off
/*  5531*/      OPC_MoveChild0,
/*  5532*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  5535*/      OPC_MoveParent,
/*  5536*/      OPC_MoveParent,
/*  5537*/      OPC_MoveChild2,
/*  5538*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5541*/      OPC_RecordChild0, // #2 = $val
/*  5542*/      OPC_MoveParent,
/*  5543*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/*  5545*/      OPC_MoveParent,
/*  5546*/      OPC_MoveParent,
/*  5547*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5549*/      OPC_EmitMergeInputChains1_0,
/*  5550*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5553*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5556*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5563*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5573*/    /*Scope*/ 61, /*->5635*/
/*  5574*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  5577*/      OPC_MoveChild0,
/*  5578*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5581*/      OPC_MoveChild0,
/*  5582*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  5585*/      OPC_RecordMemRef,
/*  5586*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  5587*/      OPC_CheckFoldableChainNode,
/*  5588*/      OPC_MoveChild1,
/*  5589*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5592*/      OPC_RecordChild0, // #1 = $off
/*  5593*/      OPC_MoveChild0,
/*  5594*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  5597*/      OPC_MoveParent,
/*  5598*/      OPC_MoveParent,
/*  5599*/      OPC_MoveChild2,
/*  5600*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5603*/      OPC_RecordChild0, // #2 = $val
/*  5604*/      OPC_MoveParent,
/*  5605*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/*  5607*/      OPC_MoveParent,
/*  5608*/      OPC_MoveParent,
/*  5609*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5611*/      OPC_EmitMergeInputChains1_0,
/*  5612*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5615*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5618*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5625*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5635*/    /*Scope*/ 62, /*->5698*/
/*  5636*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  5640*/      OPC_MoveChild0,
/*  5641*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5644*/      OPC_MoveChild0,
/*  5645*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  5648*/      OPC_RecordMemRef,
/*  5649*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  5650*/      OPC_CheckFoldableChainNode,
/*  5651*/      OPC_MoveChild1,
/*  5652*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5655*/      OPC_RecordChild0, // #1 = $off
/*  5656*/      OPC_MoveChild0,
/*  5657*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  5660*/      OPC_MoveParent,
/*  5661*/      OPC_MoveParent,
/*  5662*/      OPC_MoveChild2,
/*  5663*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5666*/      OPC_RecordChild0, // #2 = $val
/*  5667*/      OPC_MoveParent,
/*  5668*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/*  5670*/      OPC_MoveParent,
/*  5671*/      OPC_MoveParent,
/*  5672*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5674*/      OPC_EmitMergeInputChains1_0,
/*  5675*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5678*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5681*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5688*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5698*/    /*Scope*/ 61, /*->5760*/
/*  5699*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  5702*/      OPC_MoveChild0,
/*  5703*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5706*/      OPC_MoveChild0,
/*  5707*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  5710*/      OPC_RecordMemRef,
/*  5711*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  5712*/      OPC_CheckFoldableChainNode,
/*  5713*/      OPC_MoveChild1,
/*  5714*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5717*/      OPC_RecordChild0, // #1 = $off
/*  5718*/      OPC_MoveChild0,
/*  5719*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  5722*/      OPC_MoveParent,
/*  5723*/      OPC_MoveParent,
/*  5724*/      OPC_MoveChild2,
/*  5725*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5728*/      OPC_RecordChild0, // #2 = $val
/*  5729*/      OPC_MoveParent,
/*  5730*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/*  5732*/      OPC_MoveParent,
/*  5733*/      OPC_MoveParent,
/*  5734*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5736*/      OPC_EmitMergeInputChains1_0,
/*  5737*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5740*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5743*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5750*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5760*/    /*Scope*/ 62, /*->5823*/
/*  5761*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  5765*/      OPC_MoveChild0,
/*  5766*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5769*/      OPC_MoveChild0,
/*  5770*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  5773*/      OPC_RecordMemRef,
/*  5774*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  5775*/      OPC_CheckFoldableChainNode,
/*  5776*/      OPC_MoveChild1,
/*  5777*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5780*/      OPC_RecordChild0, // #1 = $off
/*  5781*/      OPC_MoveChild0,
/*  5782*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  5785*/      OPC_MoveParent,
/*  5786*/      OPC_MoveParent,
/*  5787*/      OPC_MoveChild2,
/*  5788*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5791*/      OPC_RecordChild0, // #2 = $val
/*  5792*/      OPC_MoveParent,
/*  5793*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/*  5795*/      OPC_MoveParent,
/*  5796*/      OPC_MoveParent,
/*  5797*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5799*/      OPC_EmitMergeInputChains1_0,
/*  5800*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5803*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5806*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5813*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5823*/    /*Scope*/ 61, /*->5885*/
/*  5824*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  5827*/      OPC_MoveChild0,
/*  5828*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5831*/      OPC_MoveChild0,
/*  5832*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  5835*/      OPC_RecordMemRef,
/*  5836*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  5837*/      OPC_CheckFoldableChainNode,
/*  5838*/      OPC_MoveChild1,
/*  5839*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5842*/      OPC_RecordChild0, // #1 = $off
/*  5843*/      OPC_MoveChild0,
/*  5844*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  5847*/      OPC_MoveParent,
/*  5848*/      OPC_MoveParent,
/*  5849*/      OPC_MoveChild2,
/*  5850*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5853*/      OPC_RecordChild0, // #2 = $val
/*  5854*/      OPC_MoveParent,
/*  5855*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/*  5857*/      OPC_MoveParent,
/*  5858*/      OPC_MoveParent,
/*  5859*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5861*/      OPC_EmitMergeInputChains1_0,
/*  5862*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5865*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5868*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5875*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5885*/    /*Scope*/ 62, /*->5948*/
/*  5886*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  5890*/      OPC_MoveChild0,
/*  5891*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5894*/      OPC_MoveChild0,
/*  5895*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  5898*/      OPC_RecordMemRef,
/*  5899*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  5900*/      OPC_CheckFoldableChainNode,
/*  5901*/      OPC_MoveChild1,
/*  5902*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5905*/      OPC_RecordChild0, // #1 = $off
/*  5906*/      OPC_MoveChild0,
/*  5907*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  5910*/      OPC_MoveParent,
/*  5911*/      OPC_MoveParent,
/*  5912*/      OPC_MoveChild2,
/*  5913*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5916*/      OPC_RecordChild0, // #2 = $val
/*  5917*/      OPC_MoveParent,
/*  5918*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/*  5920*/      OPC_MoveParent,
/*  5921*/      OPC_MoveParent,
/*  5922*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5924*/      OPC_EmitMergeInputChains1_0,
/*  5925*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5928*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5931*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  5938*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  5948*/    /*Scope*/ 61, /*->6010*/
/*  5949*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  5952*/      OPC_MoveChild0,
/*  5953*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  5956*/      OPC_MoveChild0,
/*  5957*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  5960*/      OPC_RecordMemRef,
/*  5961*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  5962*/      OPC_CheckFoldableChainNode,
/*  5963*/      OPC_MoveChild1,
/*  5964*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  5967*/      OPC_RecordChild0, // #1 = $off
/*  5968*/      OPC_MoveChild0,
/*  5969*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  5972*/      OPC_MoveParent,
/*  5973*/      OPC_MoveParent,
/*  5974*/      OPC_MoveChild2,
/*  5975*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  5978*/      OPC_RecordChild0, // #2 = $val
/*  5979*/      OPC_MoveParent,
/*  5980*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/*  5982*/      OPC_MoveParent,
/*  5983*/      OPC_MoveParent,
/*  5984*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  5986*/      OPC_EmitMergeInputChains1_0,
/*  5987*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5990*/      OPC_EmitInteger, MVT::i32, 0, 
/*  5993*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  6000*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  6010*/    /*Scope*/ 62, /*->6073*/
/*  6011*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  6015*/      OPC_MoveChild0,
/*  6016*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  6019*/      OPC_MoveChild0,
/*  6020*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  6023*/      OPC_RecordMemRef,
/*  6024*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  6025*/      OPC_CheckFoldableChainNode,
/*  6026*/      OPC_MoveChild1,
/*  6027*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6030*/      OPC_RecordChild0, // #1 = $off
/*  6031*/      OPC_MoveChild0,
/*  6032*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  6035*/      OPC_MoveParent,
/*  6036*/      OPC_MoveParent,
/*  6037*/      OPC_MoveChild2,
/*  6038*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  6041*/      OPC_RecordChild0, // #2 = $val
/*  6042*/      OPC_MoveParent,
/*  6043*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/*  6045*/      OPC_MoveParent,
/*  6046*/      OPC_MoveParent,
/*  6047*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6049*/      OPC_EmitMergeInputChains1_0,
/*  6050*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6053*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6056*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  6063*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  6073*/    /*Scope*/ 61, /*->6135*/
/*  6074*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  6077*/      OPC_MoveChild0,
/*  6078*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  6081*/      OPC_MoveChild0,
/*  6082*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  6085*/      OPC_RecordMemRef,
/*  6086*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  6087*/      OPC_CheckFoldableChainNode,
/*  6088*/      OPC_MoveChild1,
/*  6089*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6092*/      OPC_RecordChild0, // #1 = $off
/*  6093*/      OPC_MoveChild0,
/*  6094*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  6097*/      OPC_MoveParent,
/*  6098*/      OPC_MoveParent,
/*  6099*/      OPC_MoveChild2,
/*  6100*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  6103*/      OPC_RecordChild0, // #2 = $val
/*  6104*/      OPC_MoveParent,
/*  6105*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/*  6107*/      OPC_MoveParent,
/*  6108*/      OPC_MoveParent,
/*  6109*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6111*/      OPC_EmitMergeInputChains1_0,
/*  6112*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6115*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6118*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  6125*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  6135*/    /*Scope*/ 62, /*->6198*/
/*  6136*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  6140*/      OPC_MoveChild0,
/*  6141*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  6144*/      OPC_MoveChild0,
/*  6145*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  6148*/      OPC_RecordMemRef,
/*  6149*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  6150*/      OPC_CheckFoldableChainNode,
/*  6151*/      OPC_MoveChild1,
/*  6152*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6155*/      OPC_RecordChild0, // #1 = $off
/*  6156*/      OPC_MoveChild0,
/*  6157*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  6160*/      OPC_MoveParent,
/*  6161*/      OPC_MoveParent,
/*  6162*/      OPC_MoveChild2,
/*  6163*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  6166*/      OPC_RecordChild0, // #2 = $val
/*  6167*/      OPC_MoveParent,
/*  6168*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/*  6170*/      OPC_MoveParent,
/*  6171*/      OPC_MoveParent,
/*  6172*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6174*/      OPC_EmitMergeInputChains1_0,
/*  6175*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6178*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6181*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  6188*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  6198*/    /*Scope*/ 61, /*->6260*/
/*  6199*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  6202*/      OPC_MoveChild0,
/*  6203*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  6206*/      OPC_MoveChild0,
/*  6207*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  6210*/      OPC_RecordMemRef,
/*  6211*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  6212*/      OPC_CheckFoldableChainNode,
/*  6213*/      OPC_MoveChild1,
/*  6214*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6217*/      OPC_RecordChild0, // #1 = $off
/*  6218*/      OPC_MoveChild0,
/*  6219*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  6222*/      OPC_MoveParent,
/*  6223*/      OPC_MoveParent,
/*  6224*/      OPC_MoveChild2,
/*  6225*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  6228*/      OPC_RecordChild0, // #2 = $val
/*  6229*/      OPC_MoveParent,
/*  6230*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/*  6232*/      OPC_MoveParent,
/*  6233*/      OPC_MoveParent,
/*  6234*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6236*/      OPC_EmitMergeInputChains1_0,
/*  6237*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6240*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6243*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  6250*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>), 255:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  6260*/    /*Scope*/ 62, /*->6323*/
/*  6261*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  6265*/      OPC_MoveChild0,
/*  6266*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  6269*/      OPC_MoveChild0,
/*  6270*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  6273*/      OPC_RecordMemRef,
/*  6274*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  6275*/      OPC_CheckFoldableChainNode,
/*  6276*/      OPC_MoveChild1,
/*  6277*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6280*/      OPC_RecordChild0, // #1 = $off
/*  6281*/      OPC_MoveChild0,
/*  6282*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  6285*/      OPC_MoveParent,
/*  6286*/      OPC_MoveParent,
/*  6287*/      OPC_MoveChild2,
/*  6288*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/*  6291*/      OPC_RecordChild0, // #2 = $val
/*  6292*/      OPC_MoveParent,
/*  6293*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/*  6295*/      OPC_MoveParent,
/*  6296*/      OPC_MoveParent,
/*  6297*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6299*/      OPC_EmitMergeInputChains1_0,
/*  6300*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6303*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6306*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/*  6313*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>), 65535:{ *:[i64] }) - Complexity = 24
                // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/*  6323*/    /*Scope*/ 51, /*->6375*/
/*  6324*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  6327*/      OPC_MoveChild0,
/*  6328*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  6331*/      OPC_MoveChild0,
/*  6332*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  6335*/      OPC_RecordMemRef,
/*  6336*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  6337*/      OPC_CheckFoldableChainNode,
/*  6338*/      OPC_MoveChild1,
/*  6339*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  6342*/      OPC_RecordChild0, // #1 = $addr
/*  6343*/      OPC_RecordChild1, // #2 = $off
/*  6344*/      OPC_MoveChild1,
/*  6345*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  6348*/      OPC_MoveParent,
/*  6349*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  6351*/      OPC_CheckType, MVT::i32,
/*  6353*/      OPC_MoveParent,
/*  6354*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/*  6356*/      OPC_MoveParent,
/*  6357*/      OPC_MoveParent,
/*  6358*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6360*/      OPC_EmitMergeInputChains1_0,
/*  6361*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6364*/      OPC_EmitConvertToTarget, 2,
/*  6366*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 3, 4, 1, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>)<<P:Predicate_atomic_load_8>>), 255:{ *:[i64] }) - Complexity = 22
                // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  6375*/    /*Scope*/ 52, /*->6428*/
/*  6376*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  6380*/      OPC_MoveChild0,
/*  6381*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  6384*/      OPC_MoveChild0,
/*  6385*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  6388*/      OPC_RecordMemRef,
/*  6389*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  6390*/      OPC_CheckFoldableChainNode,
/*  6391*/      OPC_MoveChild1,
/*  6392*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  6395*/      OPC_RecordChild0, // #1 = $addr
/*  6396*/      OPC_RecordChild1, // #2 = $off
/*  6397*/      OPC_MoveChild1,
/*  6398*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  6401*/      OPC_MoveParent,
/*  6402*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/*  6404*/      OPC_CheckType, MVT::i32,
/*  6406*/      OPC_MoveParent,
/*  6407*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/*  6409*/      OPC_MoveParent,
/*  6410*/      OPC_MoveParent,
/*  6411*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6413*/      OPC_EmitMergeInputChains1_0,
/*  6414*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6417*/      OPC_EmitConvertToTarget, 2,
/*  6419*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 3, 4, 1, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>)<<P:Predicate_atomic_load_16>>), 65535:{ *:[i64] }) - Complexity = 22
                // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  6428*/    /*Scope*/ 51, /*->6480*/
/*  6429*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  6432*/      OPC_MoveChild0,
/*  6433*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  6436*/      OPC_MoveChild0,
/*  6437*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  6440*/      OPC_RecordMemRef,
/*  6441*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  6442*/      OPC_CheckFoldableChainNode,
/*  6443*/      OPC_MoveChild1,
/*  6444*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  6447*/      OPC_RecordChild0, // #1 = $addr
/*  6448*/      OPC_RecordChild1, // #2 = $off
/*  6449*/      OPC_MoveChild1,
/*  6450*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  6453*/      OPC_MoveParent,
/*  6454*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  6456*/      OPC_CheckType, MVT::i32,
/*  6458*/      OPC_MoveParent,
/*  6459*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/*  6461*/      OPC_MoveParent,
/*  6462*/      OPC_MoveParent,
/*  6463*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6465*/      OPC_EmitMergeInputChains1_0,
/*  6466*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6469*/      OPC_EmitConvertToTarget, 2,
/*  6471*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 3, 4, 1, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>)<<P:Predicate_atomic_load_8>>), 255:{ *:[i64] }) - Complexity = 22
                // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  6480*/    /*Scope*/ 52, /*->6533*/
/*  6481*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  6485*/      OPC_MoveChild0,
/*  6486*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  6489*/      OPC_MoveChild0,
/*  6490*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  6493*/      OPC_RecordMemRef,
/*  6494*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  6495*/      OPC_CheckFoldableChainNode,
/*  6496*/      OPC_MoveChild1,
/*  6497*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/*  6500*/      OPC_RecordChild0, // #1 = $addr
/*  6501*/      OPC_RecordChild1, // #2 = $off
/*  6502*/      OPC_MoveChild1,
/*  6503*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/*  6506*/      OPC_MoveParent,
/*  6507*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/*  6509*/      OPC_CheckType, MVT::i32,
/*  6511*/      OPC_MoveParent,
/*  6512*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/*  6514*/      OPC_MoveParent,
/*  6515*/      OPC_MoveParent,
/*  6516*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6518*/      OPC_EmitMergeInputChains1_0,
/*  6519*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6522*/      OPC_EmitConvertToTarget, 2,
/*  6524*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 3, 4, 1, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>)<<P:Predicate_atomic_load_16>>), 65535:{ *:[i64] }) - Complexity = 22
                // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  6533*/    /*Scope*/ 51, /*->6585*/
/*  6534*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  6537*/      OPC_MoveChild0,
/*  6538*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  6541*/      OPC_RecordMemRef,
/*  6542*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  6543*/      OPC_CheckFoldableChainNode,
/*  6544*/      OPC_MoveChild1,
/*  6545*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  6548*/      OPC_RecordChild0, // #1 = $addr
/*  6549*/      OPC_MoveChild1,
/*  6550*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6553*/      OPC_RecordChild0, // #2 = $off
/*  6554*/      OPC_MoveChild0,
/*  6555*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  6558*/      OPC_MoveParent,
/*  6559*/      OPC_MoveParent,
/*  6560*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  6562*/      OPC_CheckType, MVT::i32,
/*  6564*/      OPC_MoveParent,
/*  6565*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/*  6567*/      OPC_MoveParent,
/*  6568*/      OPC_CheckType, MVT::i32,
/*  6570*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6572*/      OPC_EmitMergeInputChains1_0,
/*  6573*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6576*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 3, 2, 1, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>)<<P:Predicate_atomic_load_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_LOAD8_U_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  6585*/    /*Scope*/ 52, /*->6638*/
/*  6586*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  6590*/      OPC_MoveChild0,
/*  6591*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  6594*/      OPC_RecordMemRef,
/*  6595*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  6596*/      OPC_CheckFoldableChainNode,
/*  6597*/      OPC_MoveChild1,
/*  6598*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  6601*/      OPC_RecordChild0, // #1 = $addr
/*  6602*/      OPC_MoveChild1,
/*  6603*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6606*/      OPC_RecordChild0, // #2 = $off
/*  6607*/      OPC_MoveChild0,
/*  6608*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  6611*/      OPC_MoveParent,
/*  6612*/      OPC_MoveParent,
/*  6613*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  6615*/      OPC_CheckType, MVT::i32,
/*  6617*/      OPC_MoveParent,
/*  6618*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/*  6620*/      OPC_MoveParent,
/*  6621*/      OPC_CheckType, MVT::i32,
/*  6623*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6625*/      OPC_EmitMergeInputChains1_0,
/*  6626*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6629*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 3, 2, 1, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>)<<P:Predicate_atomic_load_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_LOAD16_U_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  6638*/    /*Scope*/ 53, /*->6692*/
/*  6639*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  6642*/      OPC_MoveChild0,
/*  6643*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  6646*/      OPC_RecordMemRef,
/*  6647*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  6648*/      OPC_CheckFoldableChainNode,
/*  6649*/      OPC_MoveChild1,
/*  6650*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  6653*/      OPC_RecordChild0, // #1 = $addr
/*  6654*/      OPC_MoveChild1,
/*  6655*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6658*/      OPC_RecordChild0, // #2 = $off
/*  6659*/      OPC_MoveChild0,
/*  6660*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  6663*/      OPC_MoveParent,
/*  6664*/      OPC_MoveParent,
/*  6665*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  6667*/      OPC_CheckType, MVT::i32,
/*  6669*/      OPC_MoveParent,
/*  6670*/      OPC_RecordChild2, // #3 = $val
/*  6671*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/*  6673*/      OPC_MoveParent,
/*  6674*/      OPC_CheckType, MVT::i32,
/*  6676*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6678*/      OPC_EmitMergeInputChains1_0,
/*  6679*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6682*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  6692*/    /*Scope*/ 54, /*->6747*/
/*  6693*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  6697*/      OPC_MoveChild0,
/*  6698*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  6701*/      OPC_RecordMemRef,
/*  6702*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  6703*/      OPC_CheckFoldableChainNode,
/*  6704*/      OPC_MoveChild1,
/*  6705*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  6708*/      OPC_RecordChild0, // #1 = $addr
/*  6709*/      OPC_MoveChild1,
/*  6710*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6713*/      OPC_RecordChild0, // #2 = $off
/*  6714*/      OPC_MoveChild0,
/*  6715*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  6718*/      OPC_MoveParent,
/*  6719*/      OPC_MoveParent,
/*  6720*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  6722*/      OPC_CheckType, MVT::i32,
/*  6724*/      OPC_MoveParent,
/*  6725*/      OPC_RecordChild2, // #3 = $val
/*  6726*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/*  6728*/      OPC_MoveParent,
/*  6729*/      OPC_CheckType, MVT::i32,
/*  6731*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6733*/      OPC_EmitMergeInputChains1_0,
/*  6734*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6737*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  6747*/    /*Scope*/ 53, /*->6801*/
/*  6748*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  6751*/      OPC_MoveChild0,
/*  6752*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  6755*/      OPC_RecordMemRef,
/*  6756*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  6757*/      OPC_CheckFoldableChainNode,
/*  6758*/      OPC_MoveChild1,
/*  6759*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  6762*/      OPC_RecordChild0, // #1 = $addr
/*  6763*/      OPC_MoveChild1,
/*  6764*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6767*/      OPC_RecordChild0, // #2 = $off
/*  6768*/      OPC_MoveChild0,
/*  6769*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  6772*/      OPC_MoveParent,
/*  6773*/      OPC_MoveParent,
/*  6774*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  6776*/      OPC_CheckType, MVT::i32,
/*  6778*/      OPC_MoveParent,
/*  6779*/      OPC_RecordChild2, // #3 = $val
/*  6780*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/*  6782*/      OPC_MoveParent,
/*  6783*/      OPC_CheckType, MVT::i32,
/*  6785*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6787*/      OPC_EmitMergeInputChains1_0,
/*  6788*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6791*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  6801*/    /*Scope*/ 54, /*->6856*/
/*  6802*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  6806*/      OPC_MoveChild0,
/*  6807*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  6810*/      OPC_RecordMemRef,
/*  6811*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  6812*/      OPC_CheckFoldableChainNode,
/*  6813*/      OPC_MoveChild1,
/*  6814*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  6817*/      OPC_RecordChild0, // #1 = $addr
/*  6818*/      OPC_MoveChild1,
/*  6819*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6822*/      OPC_RecordChild0, // #2 = $off
/*  6823*/      OPC_MoveChild0,
/*  6824*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  6827*/      OPC_MoveParent,
/*  6828*/      OPC_MoveParent,
/*  6829*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  6831*/      OPC_CheckType, MVT::i32,
/*  6833*/      OPC_MoveParent,
/*  6834*/      OPC_RecordChild2, // #3 = $val
/*  6835*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/*  6837*/      OPC_MoveParent,
/*  6838*/      OPC_CheckType, MVT::i32,
/*  6840*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6842*/      OPC_EmitMergeInputChains1_0,
/*  6843*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6846*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  6856*/    /*Scope*/ 53, /*->6910*/
/*  6857*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  6860*/      OPC_MoveChild0,
/*  6861*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  6864*/      OPC_RecordMemRef,
/*  6865*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  6866*/      OPC_CheckFoldableChainNode,
/*  6867*/      OPC_MoveChild1,
/*  6868*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  6871*/      OPC_RecordChild0, // #1 = $addr
/*  6872*/      OPC_MoveChild1,
/*  6873*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6876*/      OPC_RecordChild0, // #2 = $off
/*  6877*/      OPC_MoveChild0,
/*  6878*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  6881*/      OPC_MoveParent,
/*  6882*/      OPC_MoveParent,
/*  6883*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  6885*/      OPC_CheckType, MVT::i32,
/*  6887*/      OPC_MoveParent,
/*  6888*/      OPC_RecordChild2, // #3 = $val
/*  6889*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/*  6891*/      OPC_MoveParent,
/*  6892*/      OPC_CheckType, MVT::i32,
/*  6894*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6896*/      OPC_EmitMergeInputChains1_0,
/*  6897*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6900*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  6910*/    /*Scope*/ 54, /*->6965*/
/*  6911*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  6915*/      OPC_MoveChild0,
/*  6916*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  6919*/      OPC_RecordMemRef,
/*  6920*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  6921*/      OPC_CheckFoldableChainNode,
/*  6922*/      OPC_MoveChild1,
/*  6923*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  6926*/      OPC_RecordChild0, // #1 = $addr
/*  6927*/      OPC_MoveChild1,
/*  6928*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6931*/      OPC_RecordChild0, // #2 = $off
/*  6932*/      OPC_MoveChild0,
/*  6933*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  6936*/      OPC_MoveParent,
/*  6937*/      OPC_MoveParent,
/*  6938*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  6940*/      OPC_CheckType, MVT::i32,
/*  6942*/      OPC_MoveParent,
/*  6943*/      OPC_RecordChild2, // #3 = $val
/*  6944*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/*  6946*/      OPC_MoveParent,
/*  6947*/      OPC_CheckType, MVT::i32,
/*  6949*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  6951*/      OPC_EmitMergeInputChains1_0,
/*  6952*/      OPC_EmitInteger, MVT::i32, 0, 
/*  6955*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  6965*/    /*Scope*/ 53, /*->7019*/
/*  6966*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  6969*/      OPC_MoveChild0,
/*  6970*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  6973*/      OPC_RecordMemRef,
/*  6974*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  6975*/      OPC_CheckFoldableChainNode,
/*  6976*/      OPC_MoveChild1,
/*  6977*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  6980*/      OPC_RecordChild0, // #1 = $addr
/*  6981*/      OPC_MoveChild1,
/*  6982*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  6985*/      OPC_RecordChild0, // #2 = $off
/*  6986*/      OPC_MoveChild0,
/*  6987*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  6990*/      OPC_MoveParent,
/*  6991*/      OPC_MoveParent,
/*  6992*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  6994*/      OPC_CheckType, MVT::i32,
/*  6996*/      OPC_MoveParent,
/*  6997*/      OPC_RecordChild2, // #3 = $val
/*  6998*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/*  7000*/      OPC_MoveParent,
/*  7001*/      OPC_CheckType, MVT::i32,
/*  7003*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7005*/      OPC_EmitMergeInputChains1_0,
/*  7006*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7009*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7019*/    /*Scope*/ 54, /*->7074*/
/*  7020*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  7024*/      OPC_MoveChild0,
/*  7025*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  7028*/      OPC_RecordMemRef,
/*  7029*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  7030*/      OPC_CheckFoldableChainNode,
/*  7031*/      OPC_MoveChild1,
/*  7032*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7035*/      OPC_RecordChild0, // #1 = $addr
/*  7036*/      OPC_MoveChild1,
/*  7037*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7040*/      OPC_RecordChild0, // #2 = $off
/*  7041*/      OPC_MoveChild0,
/*  7042*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7045*/      OPC_MoveParent,
/*  7046*/      OPC_MoveParent,
/*  7047*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7049*/      OPC_CheckType, MVT::i32,
/*  7051*/      OPC_MoveParent,
/*  7052*/      OPC_RecordChild2, // #3 = $val
/*  7053*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/*  7055*/      OPC_MoveParent,
/*  7056*/      OPC_CheckType, MVT::i32,
/*  7058*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7060*/      OPC_EmitMergeInputChains1_0,
/*  7061*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7064*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7074*/    /*Scope*/ 53, /*->7128*/
/*  7075*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  7078*/      OPC_MoveChild0,
/*  7079*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  7082*/      OPC_RecordMemRef,
/*  7083*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  7084*/      OPC_CheckFoldableChainNode,
/*  7085*/      OPC_MoveChild1,
/*  7086*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7089*/      OPC_RecordChild0, // #1 = $addr
/*  7090*/      OPC_MoveChild1,
/*  7091*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7094*/      OPC_RecordChild0, // #2 = $off
/*  7095*/      OPC_MoveChild0,
/*  7096*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7099*/      OPC_MoveParent,
/*  7100*/      OPC_MoveParent,
/*  7101*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7103*/      OPC_CheckType, MVT::i32,
/*  7105*/      OPC_MoveParent,
/*  7106*/      OPC_RecordChild2, // #3 = $val
/*  7107*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/*  7109*/      OPC_MoveParent,
/*  7110*/      OPC_CheckType, MVT::i32,
/*  7112*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7114*/      OPC_EmitMergeInputChains1_0,
/*  7115*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7118*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7128*/    /*Scope*/ 54, /*->7183*/
/*  7129*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  7133*/      OPC_MoveChild0,
/*  7134*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  7137*/      OPC_RecordMemRef,
/*  7138*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  7139*/      OPC_CheckFoldableChainNode,
/*  7140*/      OPC_MoveChild1,
/*  7141*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7144*/      OPC_RecordChild0, // #1 = $addr
/*  7145*/      OPC_MoveChild1,
/*  7146*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7149*/      OPC_RecordChild0, // #2 = $off
/*  7150*/      OPC_MoveChild0,
/*  7151*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7154*/      OPC_MoveParent,
/*  7155*/      OPC_MoveParent,
/*  7156*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7158*/      OPC_CheckType, MVT::i32,
/*  7160*/      OPC_MoveParent,
/*  7161*/      OPC_RecordChild2, // #3 = $val
/*  7162*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/*  7164*/      OPC_MoveParent,
/*  7165*/      OPC_CheckType, MVT::i32,
/*  7167*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7169*/      OPC_EmitMergeInputChains1_0,
/*  7170*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7173*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7183*/    /*Scope*/ 53, /*->7237*/
/*  7184*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  7187*/      OPC_MoveChild0,
/*  7188*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  7191*/      OPC_RecordMemRef,
/*  7192*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  7193*/      OPC_CheckFoldableChainNode,
/*  7194*/      OPC_MoveChild1,
/*  7195*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7198*/      OPC_RecordChild0, // #1 = $addr
/*  7199*/      OPC_MoveChild1,
/*  7200*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7203*/      OPC_RecordChild0, // #2 = $off
/*  7204*/      OPC_MoveChild0,
/*  7205*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7208*/      OPC_MoveParent,
/*  7209*/      OPC_MoveParent,
/*  7210*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7212*/      OPC_CheckType, MVT::i32,
/*  7214*/      OPC_MoveParent,
/*  7215*/      OPC_RecordChild2, // #3 = $val
/*  7216*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/*  7218*/      OPC_MoveParent,
/*  7219*/      OPC_CheckType, MVT::i32,
/*  7221*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7223*/      OPC_EmitMergeInputChains1_0,
/*  7224*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7227*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7237*/    /*Scope*/ 54, /*->7292*/
/*  7238*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  7242*/      OPC_MoveChild0,
/*  7243*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  7246*/      OPC_RecordMemRef,
/*  7247*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  7248*/      OPC_CheckFoldableChainNode,
/*  7249*/      OPC_MoveChild1,
/*  7250*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7253*/      OPC_RecordChild0, // #1 = $addr
/*  7254*/      OPC_MoveChild1,
/*  7255*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7258*/      OPC_RecordChild0, // #2 = $off
/*  7259*/      OPC_MoveChild0,
/*  7260*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7263*/      OPC_MoveParent,
/*  7264*/      OPC_MoveParent,
/*  7265*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7267*/      OPC_CheckType, MVT::i32,
/*  7269*/      OPC_MoveParent,
/*  7270*/      OPC_RecordChild2, // #3 = $val
/*  7271*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/*  7273*/      OPC_MoveParent,
/*  7274*/      OPC_CheckType, MVT::i32,
/*  7276*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7278*/      OPC_EmitMergeInputChains1_0,
/*  7279*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7282*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7292*/    /*Scope*/ 55, /*->7348*/
/*  7293*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  7296*/      OPC_MoveChild0,
/*  7297*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/*  7300*/      OPC_RecordMemRef,
/*  7301*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/*  7302*/      OPC_CheckFoldableChainNode,
/*  7303*/      OPC_MoveChild1,
/*  7304*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7307*/      OPC_RecordChild0, // #1 = $addr
/*  7308*/      OPC_MoveChild1,
/*  7309*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7312*/      OPC_RecordChild0, // #2 = $off
/*  7313*/      OPC_MoveChild0,
/*  7314*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7317*/      OPC_MoveParent,
/*  7318*/      OPC_MoveParent,
/*  7319*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7321*/      OPC_CheckType, MVT::i32,
/*  7323*/      OPC_MoveParent,
/*  7324*/      OPC_RecordChild2, // #3 = $exp
/*  7325*/      OPC_RecordChild3, // #4 = $new
/*  7326*/      OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/*  7328*/      OPC_MoveParent,
/*  7329*/      OPC_CheckType, MVT::i32,
/*  7331*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7333*/      OPC_EmitMergeInputChains1_0,
/*  7334*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7337*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/*  7348*/    /*Scope*/ 56, /*->7405*/
/*  7349*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  7353*/      OPC_MoveChild0,
/*  7354*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/*  7357*/      OPC_RecordMemRef,
/*  7358*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/*  7359*/      OPC_CheckFoldableChainNode,
/*  7360*/      OPC_MoveChild1,
/*  7361*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7364*/      OPC_RecordChild0, // #1 = $addr
/*  7365*/      OPC_MoveChild1,
/*  7366*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7369*/      OPC_RecordChild0, // #2 = $off
/*  7370*/      OPC_MoveChild0,
/*  7371*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7374*/      OPC_MoveParent,
/*  7375*/      OPC_MoveParent,
/*  7376*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7378*/      OPC_CheckType, MVT::i32,
/*  7380*/      OPC_MoveParent,
/*  7381*/      OPC_RecordChild2, // #3 = $exp
/*  7382*/      OPC_RecordChild3, // #4 = $new
/*  7383*/      OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/*  7385*/      OPC_MoveParent,
/*  7386*/      OPC_CheckType, MVT::i32,
/*  7388*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7390*/      OPC_EmitMergeInputChains1_0,
/*  7391*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7394*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/*  7405*/    /*Scope*/ 51, /*->7457*/
/*  7406*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  7409*/      OPC_MoveChild0,
/*  7410*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  7413*/      OPC_RecordMemRef,
/*  7414*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  7415*/      OPC_CheckFoldableChainNode,
/*  7416*/      OPC_MoveChild1,
/*  7417*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7420*/      OPC_MoveChild0,
/*  7421*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7424*/      OPC_RecordChild0, // #1 = $off
/*  7425*/      OPC_MoveChild0,
/*  7426*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7429*/      OPC_MoveParent,
/*  7430*/      OPC_MoveParent,
/*  7431*/      OPC_RecordChild1, // #2 = $addr
/*  7432*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7434*/      OPC_CheckType, MVT::i32,
/*  7436*/      OPC_MoveParent,
/*  7437*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/*  7439*/      OPC_MoveParent,
/*  7440*/      OPC_CheckType, MVT::i32,
/*  7442*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7444*/      OPC_EmitMergeInputChains1_0,
/*  7445*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7448*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 3, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>)<<P:Predicate_atomic_load_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_LOAD8_U_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  7457*/    /*Scope*/ 52, /*->7510*/
/*  7458*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  7462*/      OPC_MoveChild0,
/*  7463*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  7466*/      OPC_RecordMemRef,
/*  7467*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  7468*/      OPC_CheckFoldableChainNode,
/*  7469*/      OPC_MoveChild1,
/*  7470*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7473*/      OPC_MoveChild0,
/*  7474*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7477*/      OPC_RecordChild0, // #1 = $off
/*  7478*/      OPC_MoveChild0,
/*  7479*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7482*/      OPC_MoveParent,
/*  7483*/      OPC_MoveParent,
/*  7484*/      OPC_RecordChild1, // #2 = $addr
/*  7485*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7487*/      OPC_CheckType, MVT::i32,
/*  7489*/      OPC_MoveParent,
/*  7490*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/*  7492*/      OPC_MoveParent,
/*  7493*/      OPC_CheckType, MVT::i32,
/*  7495*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7497*/      OPC_EmitMergeInputChains1_0,
/*  7498*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7501*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 3, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>)<<P:Predicate_atomic_load_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_LOAD16_U_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  7510*/    /*Scope*/ 53, /*->7564*/
/*  7511*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  7514*/      OPC_MoveChild0,
/*  7515*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  7518*/      OPC_RecordMemRef,
/*  7519*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  7520*/      OPC_CheckFoldableChainNode,
/*  7521*/      OPC_MoveChild1,
/*  7522*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7525*/      OPC_MoveChild0,
/*  7526*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7529*/      OPC_RecordChild0, // #1 = $off
/*  7530*/      OPC_MoveChild0,
/*  7531*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7534*/      OPC_MoveParent,
/*  7535*/      OPC_MoveParent,
/*  7536*/      OPC_RecordChild1, // #2 = $addr
/*  7537*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7539*/      OPC_CheckType, MVT::i32,
/*  7541*/      OPC_MoveParent,
/*  7542*/      OPC_RecordChild2, // #3 = $val
/*  7543*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/*  7545*/      OPC_MoveParent,
/*  7546*/      OPC_CheckType, MVT::i32,
/*  7548*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7550*/      OPC_EmitMergeInputChains1_0,
/*  7551*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7554*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7564*/    /*Scope*/ 54, /*->7619*/
/*  7565*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  7569*/      OPC_MoveChild0,
/*  7570*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  7573*/      OPC_RecordMemRef,
/*  7574*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  7575*/      OPC_CheckFoldableChainNode,
/*  7576*/      OPC_MoveChild1,
/*  7577*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7580*/      OPC_MoveChild0,
/*  7581*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7584*/      OPC_RecordChild0, // #1 = $off
/*  7585*/      OPC_MoveChild0,
/*  7586*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7589*/      OPC_MoveParent,
/*  7590*/      OPC_MoveParent,
/*  7591*/      OPC_RecordChild1, // #2 = $addr
/*  7592*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7594*/      OPC_CheckType, MVT::i32,
/*  7596*/      OPC_MoveParent,
/*  7597*/      OPC_RecordChild2, // #3 = $val
/*  7598*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/*  7600*/      OPC_MoveParent,
/*  7601*/      OPC_CheckType, MVT::i32,
/*  7603*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7605*/      OPC_EmitMergeInputChains1_0,
/*  7606*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7609*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7619*/    /*Scope*/ 53, /*->7673*/
/*  7620*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  7623*/      OPC_MoveChild0,
/*  7624*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  7627*/      OPC_RecordMemRef,
/*  7628*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  7629*/      OPC_CheckFoldableChainNode,
/*  7630*/      OPC_MoveChild1,
/*  7631*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7634*/      OPC_MoveChild0,
/*  7635*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7638*/      OPC_RecordChild0, // #1 = $off
/*  7639*/      OPC_MoveChild0,
/*  7640*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7643*/      OPC_MoveParent,
/*  7644*/      OPC_MoveParent,
/*  7645*/      OPC_RecordChild1, // #2 = $addr
/*  7646*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7648*/      OPC_CheckType, MVT::i32,
/*  7650*/      OPC_MoveParent,
/*  7651*/      OPC_RecordChild2, // #3 = $val
/*  7652*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/*  7654*/      OPC_MoveParent,
/*  7655*/      OPC_CheckType, MVT::i32,
/*  7657*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7659*/      OPC_EmitMergeInputChains1_0,
/*  7660*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7663*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7673*/    /*Scope*/ 54, /*->7728*/
/*  7674*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  7678*/      OPC_MoveChild0,
/*  7679*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  7682*/      OPC_RecordMemRef,
/*  7683*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  7684*/      OPC_CheckFoldableChainNode,
/*  7685*/      OPC_MoveChild1,
/*  7686*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7689*/      OPC_MoveChild0,
/*  7690*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7693*/      OPC_RecordChild0, // #1 = $off
/*  7694*/      OPC_MoveChild0,
/*  7695*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7698*/      OPC_MoveParent,
/*  7699*/      OPC_MoveParent,
/*  7700*/      OPC_RecordChild1, // #2 = $addr
/*  7701*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7703*/      OPC_CheckType, MVT::i32,
/*  7705*/      OPC_MoveParent,
/*  7706*/      OPC_RecordChild2, // #3 = $val
/*  7707*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/*  7709*/      OPC_MoveParent,
/*  7710*/      OPC_CheckType, MVT::i32,
/*  7712*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7714*/      OPC_EmitMergeInputChains1_0,
/*  7715*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7718*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7728*/    /*Scope*/ 53, /*->7782*/
/*  7729*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  7732*/      OPC_MoveChild0,
/*  7733*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  7736*/      OPC_RecordMemRef,
/*  7737*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  7738*/      OPC_CheckFoldableChainNode,
/*  7739*/      OPC_MoveChild1,
/*  7740*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7743*/      OPC_MoveChild0,
/*  7744*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7747*/      OPC_RecordChild0, // #1 = $off
/*  7748*/      OPC_MoveChild0,
/*  7749*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7752*/      OPC_MoveParent,
/*  7753*/      OPC_MoveParent,
/*  7754*/      OPC_RecordChild1, // #2 = $addr
/*  7755*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7757*/      OPC_CheckType, MVT::i32,
/*  7759*/      OPC_MoveParent,
/*  7760*/      OPC_RecordChild2, // #3 = $val
/*  7761*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/*  7763*/      OPC_MoveParent,
/*  7764*/      OPC_CheckType, MVT::i32,
/*  7766*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7768*/      OPC_EmitMergeInputChains1_0,
/*  7769*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7772*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7782*/    /*Scope*/ 54, /*->7837*/
/*  7783*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  7787*/      OPC_MoveChild0,
/*  7788*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  7791*/      OPC_RecordMemRef,
/*  7792*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  7793*/      OPC_CheckFoldableChainNode,
/*  7794*/      OPC_MoveChild1,
/*  7795*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7798*/      OPC_MoveChild0,
/*  7799*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7802*/      OPC_RecordChild0, // #1 = $off
/*  7803*/      OPC_MoveChild0,
/*  7804*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7807*/      OPC_MoveParent,
/*  7808*/      OPC_MoveParent,
/*  7809*/      OPC_RecordChild1, // #2 = $addr
/*  7810*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7812*/      OPC_CheckType, MVT::i32,
/*  7814*/      OPC_MoveParent,
/*  7815*/      OPC_RecordChild2, // #3 = $val
/*  7816*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/*  7818*/      OPC_MoveParent,
/*  7819*/      OPC_CheckType, MVT::i32,
/*  7821*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7823*/      OPC_EmitMergeInputChains1_0,
/*  7824*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7827*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7837*/    /*Scope*/ 53, /*->7891*/
/*  7838*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  7841*/      OPC_MoveChild0,
/*  7842*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  7845*/      OPC_RecordMemRef,
/*  7846*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  7847*/      OPC_CheckFoldableChainNode,
/*  7848*/      OPC_MoveChild1,
/*  7849*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7852*/      OPC_MoveChild0,
/*  7853*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7856*/      OPC_RecordChild0, // #1 = $off
/*  7857*/      OPC_MoveChild0,
/*  7858*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7861*/      OPC_MoveParent,
/*  7862*/      OPC_MoveParent,
/*  7863*/      OPC_RecordChild1, // #2 = $addr
/*  7864*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7866*/      OPC_CheckType, MVT::i32,
/*  7868*/      OPC_MoveParent,
/*  7869*/      OPC_RecordChild2, // #3 = $val
/*  7870*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/*  7872*/      OPC_MoveParent,
/*  7873*/      OPC_CheckType, MVT::i32,
/*  7875*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7877*/      OPC_EmitMergeInputChains1_0,
/*  7878*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7881*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7891*/    /*Scope*/ 54, /*->7946*/
/*  7892*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  7896*/      OPC_MoveChild0,
/*  7897*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  7900*/      OPC_RecordMemRef,
/*  7901*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  7902*/      OPC_CheckFoldableChainNode,
/*  7903*/      OPC_MoveChild1,
/*  7904*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7907*/      OPC_MoveChild0,
/*  7908*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7911*/      OPC_RecordChild0, // #1 = $off
/*  7912*/      OPC_MoveChild0,
/*  7913*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7916*/      OPC_MoveParent,
/*  7917*/      OPC_MoveParent,
/*  7918*/      OPC_RecordChild1, // #2 = $addr
/*  7919*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7921*/      OPC_CheckType, MVT::i32,
/*  7923*/      OPC_MoveParent,
/*  7924*/      OPC_RecordChild2, // #3 = $val
/*  7925*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/*  7927*/      OPC_MoveParent,
/*  7928*/      OPC_CheckType, MVT::i32,
/*  7930*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7932*/      OPC_EmitMergeInputChains1_0,
/*  7933*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7936*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  7946*/    /*Scope*/ 53, /*->8000*/
/*  7947*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  7950*/      OPC_MoveChild0,
/*  7951*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  7954*/      OPC_RecordMemRef,
/*  7955*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  7956*/      OPC_CheckFoldableChainNode,
/*  7957*/      OPC_MoveChild1,
/*  7958*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  7961*/      OPC_MoveChild0,
/*  7962*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  7965*/      OPC_RecordChild0, // #1 = $off
/*  7966*/      OPC_MoveChild0,
/*  7967*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  7970*/      OPC_MoveParent,
/*  7971*/      OPC_MoveParent,
/*  7972*/      OPC_RecordChild1, // #2 = $addr
/*  7973*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  7975*/      OPC_CheckType, MVT::i32,
/*  7977*/      OPC_MoveParent,
/*  7978*/      OPC_RecordChild2, // #3 = $val
/*  7979*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/*  7981*/      OPC_MoveParent,
/*  7982*/      OPC_CheckType, MVT::i32,
/*  7984*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  7986*/      OPC_EmitMergeInputChains1_0,
/*  7987*/      OPC_EmitInteger, MVT::i32, 0, 
/*  7990*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8000*/    /*Scope*/ 54, /*->8055*/
/*  8001*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  8005*/      OPC_MoveChild0,
/*  8006*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  8009*/      OPC_RecordMemRef,
/*  8010*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  8011*/      OPC_CheckFoldableChainNode,
/*  8012*/      OPC_MoveChild1,
/*  8013*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8016*/      OPC_MoveChild0,
/*  8017*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8020*/      OPC_RecordChild0, // #1 = $off
/*  8021*/      OPC_MoveChild0,
/*  8022*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  8025*/      OPC_MoveParent,
/*  8026*/      OPC_MoveParent,
/*  8027*/      OPC_RecordChild1, // #2 = $addr
/*  8028*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  8030*/      OPC_CheckType, MVT::i32,
/*  8032*/      OPC_MoveParent,
/*  8033*/      OPC_RecordChild2, // #3 = $val
/*  8034*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/*  8036*/      OPC_MoveParent,
/*  8037*/      OPC_CheckType, MVT::i32,
/*  8039*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8041*/      OPC_EmitMergeInputChains1_0,
/*  8042*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8045*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8055*/    /*Scope*/ 53, /*->8109*/
/*  8056*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  8059*/      OPC_MoveChild0,
/*  8060*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  8063*/      OPC_RecordMemRef,
/*  8064*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  8065*/      OPC_CheckFoldableChainNode,
/*  8066*/      OPC_MoveChild1,
/*  8067*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8070*/      OPC_MoveChild0,
/*  8071*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8074*/      OPC_RecordChild0, // #1 = $off
/*  8075*/      OPC_MoveChild0,
/*  8076*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  8079*/      OPC_MoveParent,
/*  8080*/      OPC_MoveParent,
/*  8081*/      OPC_RecordChild1, // #2 = $addr
/*  8082*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  8084*/      OPC_CheckType, MVT::i32,
/*  8086*/      OPC_MoveParent,
/*  8087*/      OPC_RecordChild2, // #3 = $val
/*  8088*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/*  8090*/      OPC_MoveParent,
/*  8091*/      OPC_CheckType, MVT::i32,
/*  8093*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8095*/      OPC_EmitMergeInputChains1_0,
/*  8096*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8099*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8109*/    /*Scope*/ 54, /*->8164*/
/*  8110*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  8114*/      OPC_MoveChild0,
/*  8115*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  8118*/      OPC_RecordMemRef,
/*  8119*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  8120*/      OPC_CheckFoldableChainNode,
/*  8121*/      OPC_MoveChild1,
/*  8122*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8125*/      OPC_MoveChild0,
/*  8126*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8129*/      OPC_RecordChild0, // #1 = $off
/*  8130*/      OPC_MoveChild0,
/*  8131*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  8134*/      OPC_MoveParent,
/*  8135*/      OPC_MoveParent,
/*  8136*/      OPC_RecordChild1, // #2 = $addr
/*  8137*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  8139*/      OPC_CheckType, MVT::i32,
/*  8141*/      OPC_MoveParent,
/*  8142*/      OPC_RecordChild2, // #3 = $val
/*  8143*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/*  8145*/      OPC_MoveParent,
/*  8146*/      OPC_CheckType, MVT::i32,
/*  8148*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8150*/      OPC_EmitMergeInputChains1_0,
/*  8151*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8154*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8164*/    /*Scope*/ 55, /*->8220*/
/*  8165*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  8168*/      OPC_MoveChild0,
/*  8169*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/*  8172*/      OPC_RecordMemRef,
/*  8173*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/*  8174*/      OPC_CheckFoldableChainNode,
/*  8175*/      OPC_MoveChild1,
/*  8176*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8179*/      OPC_MoveChild0,
/*  8180*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8183*/      OPC_RecordChild0, // #1 = $off
/*  8184*/      OPC_MoveChild0,
/*  8185*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  8188*/      OPC_MoveParent,
/*  8189*/      OPC_MoveParent,
/*  8190*/      OPC_RecordChild1, // #2 = $addr
/*  8191*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  8193*/      OPC_CheckType, MVT::i32,
/*  8195*/      OPC_MoveParent,
/*  8196*/      OPC_RecordChild2, // #3 = $exp
/*  8197*/      OPC_RecordChild3, // #4 = $new
/*  8198*/      OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/*  8200*/      OPC_MoveParent,
/*  8201*/      OPC_CheckType, MVT::i32,
/*  8203*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8205*/      OPC_EmitMergeInputChains1_0,
/*  8206*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8209*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_8>>, 255:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW8_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/*  8220*/    /*Scope*/ 56, /*->8277*/
/*  8221*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  8225*/      OPC_MoveChild0,
/*  8226*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/*  8229*/      OPC_RecordMemRef,
/*  8230*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/*  8231*/      OPC_CheckFoldableChainNode,
/*  8232*/      OPC_MoveChild1,
/*  8233*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8236*/      OPC_MoveChild0,
/*  8237*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8240*/      OPC_RecordChild0, // #1 = $off
/*  8241*/      OPC_MoveChild0,
/*  8242*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  8245*/      OPC_MoveParent,
/*  8246*/      OPC_MoveParent,
/*  8247*/      OPC_RecordChild1, // #2 = $addr
/*  8248*/      OPC_CheckPredicate, 0, // Predicate_regPlusGA
/*  8250*/      OPC_CheckType, MVT::i32,
/*  8252*/      OPC_MoveParent,
/*  8253*/      OPC_RecordChild2, // #3 = $exp
/*  8254*/      OPC_RecordChild3, // #4 = $new
/*  8255*/      OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/*  8257*/      OPC_MoveParent,
/*  8258*/      OPC_CheckType, MVT::i32,
/*  8260*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8262*/      OPC_EmitMergeInputChains1_0,
/*  8263*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8266*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_16>>, 65535:{ *:[i32] }) - Complexity = 22
                // Dst: (ATOMIC_RMW16_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/*  8277*/    /*Scope*/ 49, /*->8327*/
/*  8278*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  8281*/      OPC_MoveChild0,
/*  8282*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  8285*/      OPC_RecordMemRef,
/*  8286*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  8287*/      OPC_CheckFoldableChainNode,
/*  8288*/      OPC_MoveChild1,
/*  8289*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8292*/      OPC_RecordChild0, // #1 = $addr
/*  8293*/      OPC_MoveChild1,
/*  8294*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8297*/      OPC_RecordChild0, // #2 = $off
/*  8298*/      OPC_MoveChild0,
/*  8299*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8302*/      OPC_MoveParent,
/*  8303*/      OPC_MoveParent,
/*  8304*/      OPC_CheckType, MVT::i32,
/*  8306*/      OPC_MoveParent,
/*  8307*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/*  8309*/      OPC_MoveParent,
/*  8310*/      OPC_CheckType, MVT::i32,
/*  8312*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8314*/      OPC_EmitMergeInputChains1_0,
/*  8315*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8318*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 3, 2, 1, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)))<<P:Predicate_atomic_load_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_LOAD8_U_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  8327*/    /*Scope*/ 50, /*->8378*/
/*  8328*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  8332*/      OPC_MoveChild0,
/*  8333*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  8336*/      OPC_RecordMemRef,
/*  8337*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  8338*/      OPC_CheckFoldableChainNode,
/*  8339*/      OPC_MoveChild1,
/*  8340*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8343*/      OPC_RecordChild0, // #1 = $addr
/*  8344*/      OPC_MoveChild1,
/*  8345*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8348*/      OPC_RecordChild0, // #2 = $off
/*  8349*/      OPC_MoveChild0,
/*  8350*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8353*/      OPC_MoveParent,
/*  8354*/      OPC_MoveParent,
/*  8355*/      OPC_CheckType, MVT::i32,
/*  8357*/      OPC_MoveParent,
/*  8358*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/*  8360*/      OPC_MoveParent,
/*  8361*/      OPC_CheckType, MVT::i32,
/*  8363*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8365*/      OPC_EmitMergeInputChains1_0,
/*  8366*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8369*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 3, 2, 1, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)))<<P:Predicate_atomic_load_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_LOAD16_U_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  8378*/    /*Scope*/ 51, /*->8430*/
/*  8379*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  8382*/      OPC_MoveChild0,
/*  8383*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  8386*/      OPC_RecordMemRef,
/*  8387*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  8388*/      OPC_CheckFoldableChainNode,
/*  8389*/      OPC_MoveChild1,
/*  8390*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8393*/      OPC_RecordChild0, // #1 = $addr
/*  8394*/      OPC_MoveChild1,
/*  8395*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8398*/      OPC_RecordChild0, // #2 = $off
/*  8399*/      OPC_MoveChild0,
/*  8400*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8403*/      OPC_MoveParent,
/*  8404*/      OPC_MoveParent,
/*  8405*/      OPC_CheckType, MVT::i32,
/*  8407*/      OPC_MoveParent,
/*  8408*/      OPC_RecordChild2, // #3 = $val
/*  8409*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/*  8411*/      OPC_MoveParent,
/*  8412*/      OPC_CheckType, MVT::i32,
/*  8414*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8416*/      OPC_EmitMergeInputChains1_0,
/*  8417*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8420*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8430*/    /*Scope*/ 52, /*->8483*/
/*  8431*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  8435*/      OPC_MoveChild0,
/*  8436*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  8439*/      OPC_RecordMemRef,
/*  8440*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  8441*/      OPC_CheckFoldableChainNode,
/*  8442*/      OPC_MoveChild1,
/*  8443*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8446*/      OPC_RecordChild0, // #1 = $addr
/*  8447*/      OPC_MoveChild1,
/*  8448*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8451*/      OPC_RecordChild0, // #2 = $off
/*  8452*/      OPC_MoveChild0,
/*  8453*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8456*/      OPC_MoveParent,
/*  8457*/      OPC_MoveParent,
/*  8458*/      OPC_CheckType, MVT::i32,
/*  8460*/      OPC_MoveParent,
/*  8461*/      OPC_RecordChild2, // #3 = $val
/*  8462*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/*  8464*/      OPC_MoveParent,
/*  8465*/      OPC_CheckType, MVT::i32,
/*  8467*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8469*/      OPC_EmitMergeInputChains1_0,
/*  8470*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8473*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8483*/    /*Scope*/ 51, /*->8535*/
/*  8484*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  8487*/      OPC_MoveChild0,
/*  8488*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  8491*/      OPC_RecordMemRef,
/*  8492*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  8493*/      OPC_CheckFoldableChainNode,
/*  8494*/      OPC_MoveChild1,
/*  8495*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8498*/      OPC_RecordChild0, // #1 = $addr
/*  8499*/      OPC_MoveChild1,
/*  8500*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8503*/      OPC_RecordChild0, // #2 = $off
/*  8504*/      OPC_MoveChild0,
/*  8505*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8508*/      OPC_MoveParent,
/*  8509*/      OPC_MoveParent,
/*  8510*/      OPC_CheckType, MVT::i32,
/*  8512*/      OPC_MoveParent,
/*  8513*/      OPC_RecordChild2, // #3 = $val
/*  8514*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/*  8516*/      OPC_MoveParent,
/*  8517*/      OPC_CheckType, MVT::i32,
/*  8519*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8521*/      OPC_EmitMergeInputChains1_0,
/*  8522*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8525*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8535*/    /*Scope*/ 52, /*->8588*/
/*  8536*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  8540*/      OPC_MoveChild0,
/*  8541*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  8544*/      OPC_RecordMemRef,
/*  8545*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  8546*/      OPC_CheckFoldableChainNode,
/*  8547*/      OPC_MoveChild1,
/*  8548*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8551*/      OPC_RecordChild0, // #1 = $addr
/*  8552*/      OPC_MoveChild1,
/*  8553*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8556*/      OPC_RecordChild0, // #2 = $off
/*  8557*/      OPC_MoveChild0,
/*  8558*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8561*/      OPC_MoveParent,
/*  8562*/      OPC_MoveParent,
/*  8563*/      OPC_CheckType, MVT::i32,
/*  8565*/      OPC_MoveParent,
/*  8566*/      OPC_RecordChild2, // #3 = $val
/*  8567*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/*  8569*/      OPC_MoveParent,
/*  8570*/      OPC_CheckType, MVT::i32,
/*  8572*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8574*/      OPC_EmitMergeInputChains1_0,
/*  8575*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8578*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8588*/    /*Scope*/ 51, /*->8640*/
/*  8589*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  8592*/      OPC_MoveChild0,
/*  8593*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  8596*/      OPC_RecordMemRef,
/*  8597*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  8598*/      OPC_CheckFoldableChainNode,
/*  8599*/      OPC_MoveChild1,
/*  8600*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8603*/      OPC_RecordChild0, // #1 = $addr
/*  8604*/      OPC_MoveChild1,
/*  8605*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8608*/      OPC_RecordChild0, // #2 = $off
/*  8609*/      OPC_MoveChild0,
/*  8610*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8613*/      OPC_MoveParent,
/*  8614*/      OPC_MoveParent,
/*  8615*/      OPC_CheckType, MVT::i32,
/*  8617*/      OPC_MoveParent,
/*  8618*/      OPC_RecordChild2, // #3 = $val
/*  8619*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/*  8621*/      OPC_MoveParent,
/*  8622*/      OPC_CheckType, MVT::i32,
/*  8624*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8626*/      OPC_EmitMergeInputChains1_0,
/*  8627*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8630*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8640*/    /*Scope*/ 52, /*->8693*/
/*  8641*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  8645*/      OPC_MoveChild0,
/*  8646*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  8649*/      OPC_RecordMemRef,
/*  8650*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  8651*/      OPC_CheckFoldableChainNode,
/*  8652*/      OPC_MoveChild1,
/*  8653*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8656*/      OPC_RecordChild0, // #1 = $addr
/*  8657*/      OPC_MoveChild1,
/*  8658*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8661*/      OPC_RecordChild0, // #2 = $off
/*  8662*/      OPC_MoveChild0,
/*  8663*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8666*/      OPC_MoveParent,
/*  8667*/      OPC_MoveParent,
/*  8668*/      OPC_CheckType, MVT::i32,
/*  8670*/      OPC_MoveParent,
/*  8671*/      OPC_RecordChild2, // #3 = $val
/*  8672*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/*  8674*/      OPC_MoveParent,
/*  8675*/      OPC_CheckType, MVT::i32,
/*  8677*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8679*/      OPC_EmitMergeInputChains1_0,
/*  8680*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8683*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8693*/    /*Scope*/ 51, /*->8745*/
/*  8694*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  8697*/      OPC_MoveChild0,
/*  8698*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  8701*/      OPC_RecordMemRef,
/*  8702*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  8703*/      OPC_CheckFoldableChainNode,
/*  8704*/      OPC_MoveChild1,
/*  8705*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8708*/      OPC_RecordChild0, // #1 = $addr
/*  8709*/      OPC_MoveChild1,
/*  8710*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8713*/      OPC_RecordChild0, // #2 = $off
/*  8714*/      OPC_MoveChild0,
/*  8715*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8718*/      OPC_MoveParent,
/*  8719*/      OPC_MoveParent,
/*  8720*/      OPC_CheckType, MVT::i32,
/*  8722*/      OPC_MoveParent,
/*  8723*/      OPC_RecordChild2, // #3 = $val
/*  8724*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/*  8726*/      OPC_MoveParent,
/*  8727*/      OPC_CheckType, MVT::i32,
/*  8729*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8731*/      OPC_EmitMergeInputChains1_0,
/*  8732*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8735*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8745*/    /*Scope*/ 52, /*->8798*/
/*  8746*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  8750*/      OPC_MoveChild0,
/*  8751*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  8754*/      OPC_RecordMemRef,
/*  8755*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  8756*/      OPC_CheckFoldableChainNode,
/*  8757*/      OPC_MoveChild1,
/*  8758*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8761*/      OPC_RecordChild0, // #1 = $addr
/*  8762*/      OPC_MoveChild1,
/*  8763*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8766*/      OPC_RecordChild0, // #2 = $off
/*  8767*/      OPC_MoveChild0,
/*  8768*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8771*/      OPC_MoveParent,
/*  8772*/      OPC_MoveParent,
/*  8773*/      OPC_CheckType, MVT::i32,
/*  8775*/      OPC_MoveParent,
/*  8776*/      OPC_RecordChild2, // #3 = $val
/*  8777*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/*  8779*/      OPC_MoveParent,
/*  8780*/      OPC_CheckType, MVT::i32,
/*  8782*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8784*/      OPC_EmitMergeInputChains1_0,
/*  8785*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8788*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8798*/    /*Scope*/ 51, /*->8850*/
/*  8799*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  8802*/      OPC_MoveChild0,
/*  8803*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  8806*/      OPC_RecordMemRef,
/*  8807*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  8808*/      OPC_CheckFoldableChainNode,
/*  8809*/      OPC_MoveChild1,
/*  8810*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8813*/      OPC_RecordChild0, // #1 = $addr
/*  8814*/      OPC_MoveChild1,
/*  8815*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8818*/      OPC_RecordChild0, // #2 = $off
/*  8819*/      OPC_MoveChild0,
/*  8820*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8823*/      OPC_MoveParent,
/*  8824*/      OPC_MoveParent,
/*  8825*/      OPC_CheckType, MVT::i32,
/*  8827*/      OPC_MoveParent,
/*  8828*/      OPC_RecordChild2, // #3 = $val
/*  8829*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/*  8831*/      OPC_MoveParent,
/*  8832*/      OPC_CheckType, MVT::i32,
/*  8834*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8836*/      OPC_EmitMergeInputChains1_0,
/*  8837*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8840*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8850*/    /*Scope*/ 52, /*->8903*/
/*  8851*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  8855*/      OPC_MoveChild0,
/*  8856*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  8859*/      OPC_RecordMemRef,
/*  8860*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  8861*/      OPC_CheckFoldableChainNode,
/*  8862*/      OPC_MoveChild1,
/*  8863*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8866*/      OPC_RecordChild0, // #1 = $addr
/*  8867*/      OPC_MoveChild1,
/*  8868*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8871*/      OPC_RecordChild0, // #2 = $off
/*  8872*/      OPC_MoveChild0,
/*  8873*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8876*/      OPC_MoveParent,
/*  8877*/      OPC_MoveParent,
/*  8878*/      OPC_CheckType, MVT::i32,
/*  8880*/      OPC_MoveParent,
/*  8881*/      OPC_RecordChild2, // #3 = $val
/*  8882*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/*  8884*/      OPC_MoveParent,
/*  8885*/      OPC_CheckType, MVT::i32,
/*  8887*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8889*/      OPC_EmitMergeInputChains1_0,
/*  8890*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8893*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8903*/    /*Scope*/ 51, /*->8955*/
/*  8904*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  8907*/      OPC_MoveChild0,
/*  8908*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  8911*/      OPC_RecordMemRef,
/*  8912*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  8913*/      OPC_CheckFoldableChainNode,
/*  8914*/      OPC_MoveChild1,
/*  8915*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8918*/      OPC_RecordChild0, // #1 = $addr
/*  8919*/      OPC_MoveChild1,
/*  8920*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8923*/      OPC_RecordChild0, // #2 = $off
/*  8924*/      OPC_MoveChild0,
/*  8925*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8928*/      OPC_MoveParent,
/*  8929*/      OPC_MoveParent,
/*  8930*/      OPC_CheckType, MVT::i32,
/*  8932*/      OPC_MoveParent,
/*  8933*/      OPC_RecordChild2, // #3 = $val
/*  8934*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/*  8936*/      OPC_MoveParent,
/*  8937*/      OPC_CheckType, MVT::i32,
/*  8939*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8941*/      OPC_EmitMergeInputChains1_0,
/*  8942*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8945*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  8955*/    /*Scope*/ 52, /*->9008*/
/*  8956*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  8960*/      OPC_MoveChild0,
/*  8961*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  8964*/      OPC_RecordMemRef,
/*  8965*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  8966*/      OPC_CheckFoldableChainNode,
/*  8967*/      OPC_MoveChild1,
/*  8968*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  8971*/      OPC_RecordChild0, // #1 = $addr
/*  8972*/      OPC_MoveChild1,
/*  8973*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  8976*/      OPC_RecordChild0, // #2 = $off
/*  8977*/      OPC_MoveChild0,
/*  8978*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  8981*/      OPC_MoveParent,
/*  8982*/      OPC_MoveParent,
/*  8983*/      OPC_CheckType, MVT::i32,
/*  8985*/      OPC_MoveParent,
/*  8986*/      OPC_RecordChild2, // #3 = $val
/*  8987*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/*  8989*/      OPC_MoveParent,
/*  8990*/      OPC_CheckType, MVT::i32,
/*  8992*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  8994*/      OPC_EmitMergeInputChains1_0,
/*  8995*/      OPC_EmitInteger, MVT::i32, 0, 
/*  8998*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  9008*/    /*Scope*/ 53, /*->9062*/
/*  9009*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  9012*/      OPC_MoveChild0,
/*  9013*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/*  9016*/      OPC_RecordMemRef,
/*  9017*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/*  9018*/      OPC_CheckFoldableChainNode,
/*  9019*/      OPC_MoveChild1,
/*  9020*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9023*/      OPC_RecordChild0, // #1 = $addr
/*  9024*/      OPC_MoveChild1,
/*  9025*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9028*/      OPC_RecordChild0, // #2 = $off
/*  9029*/      OPC_MoveChild0,
/*  9030*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9033*/      OPC_MoveParent,
/*  9034*/      OPC_MoveParent,
/*  9035*/      OPC_CheckType, MVT::i32,
/*  9037*/      OPC_MoveParent,
/*  9038*/      OPC_RecordChild2, // #3 = $exp
/*  9039*/      OPC_RecordChild3, // #4 = $new
/*  9040*/      OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/*  9042*/      OPC_MoveParent,
/*  9043*/      OPC_CheckType, MVT::i32,
/*  9045*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9047*/      OPC_EmitMergeInputChains1_0,
/*  9048*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9051*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/*  9062*/    /*Scope*/ 54, /*->9117*/
/*  9063*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  9067*/      OPC_MoveChild0,
/*  9068*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/*  9071*/      OPC_RecordMemRef,
/*  9072*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/*  9073*/      OPC_CheckFoldableChainNode,
/*  9074*/      OPC_MoveChild1,
/*  9075*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9078*/      OPC_RecordChild0, // #1 = $addr
/*  9079*/      OPC_MoveChild1,
/*  9080*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9083*/      OPC_RecordChild0, // #2 = $off
/*  9084*/      OPC_MoveChild0,
/*  9085*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9088*/      OPC_MoveParent,
/*  9089*/      OPC_MoveParent,
/*  9090*/      OPC_CheckType, MVT::i32,
/*  9092*/      OPC_MoveParent,
/*  9093*/      OPC_RecordChild2, // #3 = $exp
/*  9094*/      OPC_RecordChild3, // #4 = $new
/*  9095*/      OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/*  9097*/      OPC_MoveParent,
/*  9098*/      OPC_CheckType, MVT::i32,
/*  9100*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9102*/      OPC_EmitMergeInputChains1_0,
/*  9103*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9106*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/*  9117*/    /*Scope*/ 49, /*->9167*/
/*  9118*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  9121*/      OPC_MoveChild0,
/*  9122*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  9125*/      OPC_RecordMemRef,
/*  9126*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  9127*/      OPC_CheckFoldableChainNode,
/*  9128*/      OPC_MoveChild1,
/*  9129*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9132*/      OPC_MoveChild0,
/*  9133*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9136*/      OPC_RecordChild0, // #1 = $off
/*  9137*/      OPC_MoveChild0,
/*  9138*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9141*/      OPC_MoveParent,
/*  9142*/      OPC_MoveParent,
/*  9143*/      OPC_RecordChild1, // #2 = $addr
/*  9144*/      OPC_CheckType, MVT::i32,
/*  9146*/      OPC_MoveParent,
/*  9147*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/*  9149*/      OPC_MoveParent,
/*  9150*/      OPC_CheckType, MVT::i32,
/*  9152*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9154*/      OPC_EmitMergeInputChains1_0,
/*  9155*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9158*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 3, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr))<<P:Predicate_atomic_load_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_LOAD8_U_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  9167*/    /*Scope*/ 50, /*->9218*/
/*  9168*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  9172*/      OPC_MoveChild0,
/*  9173*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  9176*/      OPC_RecordMemRef,
/*  9177*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  9178*/      OPC_CheckFoldableChainNode,
/*  9179*/      OPC_MoveChild1,
/*  9180*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9183*/      OPC_MoveChild0,
/*  9184*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9187*/      OPC_RecordChild0, // #1 = $off
/*  9188*/      OPC_MoveChild0,
/*  9189*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9192*/      OPC_MoveParent,
/*  9193*/      OPC_MoveParent,
/*  9194*/      OPC_RecordChild1, // #2 = $addr
/*  9195*/      OPC_CheckType, MVT::i32,
/*  9197*/      OPC_MoveParent,
/*  9198*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/*  9200*/      OPC_MoveParent,
/*  9201*/      OPC_CheckType, MVT::i32,
/*  9203*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9205*/      OPC_EmitMergeInputChains1_0,
/*  9206*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9209*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 3, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr))<<P:Predicate_atomic_load_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_LOAD16_U_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/*  9218*/    /*Scope*/ 51, /*->9270*/
/*  9219*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  9222*/      OPC_MoveChild0,
/*  9223*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  9226*/      OPC_RecordMemRef,
/*  9227*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  9228*/      OPC_CheckFoldableChainNode,
/*  9229*/      OPC_MoveChild1,
/*  9230*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9233*/      OPC_MoveChild0,
/*  9234*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9237*/      OPC_RecordChild0, // #1 = $off
/*  9238*/      OPC_MoveChild0,
/*  9239*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9242*/      OPC_MoveParent,
/*  9243*/      OPC_MoveParent,
/*  9244*/      OPC_RecordChild1, // #2 = $addr
/*  9245*/      OPC_CheckType, MVT::i32,
/*  9247*/      OPC_MoveParent,
/*  9248*/      OPC_RecordChild2, // #3 = $val
/*  9249*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/*  9251*/      OPC_MoveParent,
/*  9252*/      OPC_CheckType, MVT::i32,
/*  9254*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9256*/      OPC_EmitMergeInputChains1_0,
/*  9257*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9260*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  9270*/    /*Scope*/ 52, /*->9323*/
/*  9271*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  9275*/      OPC_MoveChild0,
/*  9276*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/*  9279*/      OPC_RecordMemRef,
/*  9280*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/*  9281*/      OPC_CheckFoldableChainNode,
/*  9282*/      OPC_MoveChild1,
/*  9283*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9286*/      OPC_MoveChild0,
/*  9287*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9290*/      OPC_RecordChild0, // #1 = $off
/*  9291*/      OPC_MoveChild0,
/*  9292*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9295*/      OPC_MoveParent,
/*  9296*/      OPC_MoveParent,
/*  9297*/      OPC_RecordChild1, // #2 = $addr
/*  9298*/      OPC_CheckType, MVT::i32,
/*  9300*/      OPC_MoveParent,
/*  9301*/      OPC_RecordChild2, // #3 = $val
/*  9302*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/*  9304*/      OPC_MoveParent,
/*  9305*/      OPC_CheckType, MVT::i32,
/*  9307*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9309*/      OPC_EmitMergeInputChains1_0,
/*  9310*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9313*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  9323*/    /*Scope*/ 51, /*->9375*/
/*  9324*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  9327*/      OPC_MoveChild0,
/*  9328*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  9331*/      OPC_RecordMemRef,
/*  9332*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  9333*/      OPC_CheckFoldableChainNode,
/*  9334*/      OPC_MoveChild1,
/*  9335*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9338*/      OPC_MoveChild0,
/*  9339*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9342*/      OPC_RecordChild0, // #1 = $off
/*  9343*/      OPC_MoveChild0,
/*  9344*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9347*/      OPC_MoveParent,
/*  9348*/      OPC_MoveParent,
/*  9349*/      OPC_RecordChild1, // #2 = $addr
/*  9350*/      OPC_CheckType, MVT::i32,
/*  9352*/      OPC_MoveParent,
/*  9353*/      OPC_RecordChild2, // #3 = $val
/*  9354*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/*  9356*/      OPC_MoveParent,
/*  9357*/      OPC_CheckType, MVT::i32,
/*  9359*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9361*/      OPC_EmitMergeInputChains1_0,
/*  9362*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9365*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  9375*/    /*Scope*/ 52, /*->9428*/
/*  9376*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  9380*/      OPC_MoveChild0,
/*  9381*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/*  9384*/      OPC_RecordMemRef,
/*  9385*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/*  9386*/      OPC_CheckFoldableChainNode,
/*  9387*/      OPC_MoveChild1,
/*  9388*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9391*/      OPC_MoveChild0,
/*  9392*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9395*/      OPC_RecordChild0, // #1 = $off
/*  9396*/      OPC_MoveChild0,
/*  9397*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9400*/      OPC_MoveParent,
/*  9401*/      OPC_MoveParent,
/*  9402*/      OPC_RecordChild1, // #2 = $addr
/*  9403*/      OPC_CheckType, MVT::i32,
/*  9405*/      OPC_MoveParent,
/*  9406*/      OPC_RecordChild2, // #3 = $val
/*  9407*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/*  9409*/      OPC_MoveParent,
/*  9410*/      OPC_CheckType, MVT::i32,
/*  9412*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9414*/      OPC_EmitMergeInputChains1_0,
/*  9415*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9418*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  9428*/    /*Scope*/ 51, /*->9480*/
/*  9429*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  9432*/      OPC_MoveChild0,
/*  9433*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  9436*/      OPC_RecordMemRef,
/*  9437*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  9438*/      OPC_CheckFoldableChainNode,
/*  9439*/      OPC_MoveChild1,
/*  9440*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9443*/      OPC_MoveChild0,
/*  9444*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9447*/      OPC_RecordChild0, // #1 = $off
/*  9448*/      OPC_MoveChild0,
/*  9449*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9452*/      OPC_MoveParent,
/*  9453*/      OPC_MoveParent,
/*  9454*/      OPC_RecordChild1, // #2 = $addr
/*  9455*/      OPC_CheckType, MVT::i32,
/*  9457*/      OPC_MoveParent,
/*  9458*/      OPC_RecordChild2, // #3 = $val
/*  9459*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/*  9461*/      OPC_MoveParent,
/*  9462*/      OPC_CheckType, MVT::i32,
/*  9464*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9466*/      OPC_EmitMergeInputChains1_0,
/*  9467*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9470*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  9480*/    /*Scope*/ 52, /*->9533*/
/*  9481*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  9485*/      OPC_MoveChild0,
/*  9486*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/*  9489*/      OPC_RecordMemRef,
/*  9490*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/*  9491*/      OPC_CheckFoldableChainNode,
/*  9492*/      OPC_MoveChild1,
/*  9493*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9496*/      OPC_MoveChild0,
/*  9497*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9500*/      OPC_RecordChild0, // #1 = $off
/*  9501*/      OPC_MoveChild0,
/*  9502*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9505*/      OPC_MoveParent,
/*  9506*/      OPC_MoveParent,
/*  9507*/      OPC_RecordChild1, // #2 = $addr
/*  9508*/      OPC_CheckType, MVT::i32,
/*  9510*/      OPC_MoveParent,
/*  9511*/      OPC_RecordChild2, // #3 = $val
/*  9512*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/*  9514*/      OPC_MoveParent,
/*  9515*/      OPC_CheckType, MVT::i32,
/*  9517*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9519*/      OPC_EmitMergeInputChains1_0,
/*  9520*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9523*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  9533*/    /*Scope*/ 51, /*->9585*/
/*  9534*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  9537*/      OPC_MoveChild0,
/*  9538*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  9541*/      OPC_RecordMemRef,
/*  9542*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  9543*/      OPC_CheckFoldableChainNode,
/*  9544*/      OPC_MoveChild1,
/*  9545*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9548*/      OPC_MoveChild0,
/*  9549*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9552*/      OPC_RecordChild0, // #1 = $off
/*  9553*/      OPC_MoveChild0,
/*  9554*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9557*/      OPC_MoveParent,
/*  9558*/      OPC_MoveParent,
/*  9559*/      OPC_RecordChild1, // #2 = $addr
/*  9560*/      OPC_CheckType, MVT::i32,
/*  9562*/      OPC_MoveParent,
/*  9563*/      OPC_RecordChild2, // #3 = $val
/*  9564*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/*  9566*/      OPC_MoveParent,
/*  9567*/      OPC_CheckType, MVT::i32,
/*  9569*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9571*/      OPC_EmitMergeInputChains1_0,
/*  9572*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9575*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  9585*/    /*Scope*/ 52, /*->9638*/
/*  9586*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  9590*/      OPC_MoveChild0,
/*  9591*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/*  9594*/      OPC_RecordMemRef,
/*  9595*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/*  9596*/      OPC_CheckFoldableChainNode,
/*  9597*/      OPC_MoveChild1,
/*  9598*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9601*/      OPC_MoveChild0,
/*  9602*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9605*/      OPC_RecordChild0, // #1 = $off
/*  9606*/      OPC_MoveChild0,
/*  9607*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9610*/      OPC_MoveParent,
/*  9611*/      OPC_MoveParent,
/*  9612*/      OPC_RecordChild1, // #2 = $addr
/*  9613*/      OPC_CheckType, MVT::i32,
/*  9615*/      OPC_MoveParent,
/*  9616*/      OPC_RecordChild2, // #3 = $val
/*  9617*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/*  9619*/      OPC_MoveParent,
/*  9620*/      OPC_CheckType, MVT::i32,
/*  9622*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9624*/      OPC_EmitMergeInputChains1_0,
/*  9625*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9628*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  9638*/    /*Scope*/ 51, /*->9690*/
/*  9639*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  9642*/      OPC_MoveChild0,
/*  9643*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  9646*/      OPC_RecordMemRef,
/*  9647*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  9648*/      OPC_CheckFoldableChainNode,
/*  9649*/      OPC_MoveChild1,
/*  9650*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9653*/      OPC_MoveChild0,
/*  9654*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9657*/      OPC_RecordChild0, // #1 = $off
/*  9658*/      OPC_MoveChild0,
/*  9659*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9662*/      OPC_MoveParent,
/*  9663*/      OPC_MoveParent,
/*  9664*/      OPC_RecordChild1, // #2 = $addr
/*  9665*/      OPC_CheckType, MVT::i32,
/*  9667*/      OPC_MoveParent,
/*  9668*/      OPC_RecordChild2, // #3 = $val
/*  9669*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/*  9671*/      OPC_MoveParent,
/*  9672*/      OPC_CheckType, MVT::i32,
/*  9674*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9676*/      OPC_EmitMergeInputChains1_0,
/*  9677*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9680*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  9690*/    /*Scope*/ 52, /*->9743*/
/*  9691*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  9695*/      OPC_MoveChild0,
/*  9696*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/*  9699*/      OPC_RecordMemRef,
/*  9700*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/*  9701*/      OPC_CheckFoldableChainNode,
/*  9702*/      OPC_MoveChild1,
/*  9703*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9706*/      OPC_MoveChild0,
/*  9707*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9710*/      OPC_RecordChild0, // #1 = $off
/*  9711*/      OPC_MoveChild0,
/*  9712*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9715*/      OPC_MoveParent,
/*  9716*/      OPC_MoveParent,
/*  9717*/      OPC_RecordChild1, // #2 = $addr
/*  9718*/      OPC_CheckType, MVT::i32,
/*  9720*/      OPC_MoveParent,
/*  9721*/      OPC_RecordChild2, // #3 = $val
/*  9722*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/*  9724*/      OPC_MoveParent,
/*  9725*/      OPC_CheckType, MVT::i32,
/*  9727*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9729*/      OPC_EmitMergeInputChains1_0,
/*  9730*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9733*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  9743*/    /*Scope*/ 51, /*->9795*/
/*  9744*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  9747*/      OPC_MoveChild0,
/*  9748*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  9751*/      OPC_RecordMemRef,
/*  9752*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  9753*/      OPC_CheckFoldableChainNode,
/*  9754*/      OPC_MoveChild1,
/*  9755*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9758*/      OPC_MoveChild0,
/*  9759*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9762*/      OPC_RecordChild0, // #1 = $off
/*  9763*/      OPC_MoveChild0,
/*  9764*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9767*/      OPC_MoveParent,
/*  9768*/      OPC_MoveParent,
/*  9769*/      OPC_RecordChild1, // #2 = $addr
/*  9770*/      OPC_CheckType, MVT::i32,
/*  9772*/      OPC_MoveParent,
/*  9773*/      OPC_RecordChild2, // #3 = $val
/*  9774*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/*  9776*/      OPC_MoveParent,
/*  9777*/      OPC_CheckType, MVT::i32,
/*  9779*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9781*/      OPC_EmitMergeInputChains1_0,
/*  9782*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9785*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  9795*/    /*Scope*/ 52, /*->9848*/
/*  9796*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  9800*/      OPC_MoveChild0,
/*  9801*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/*  9804*/      OPC_RecordMemRef,
/*  9805*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/*  9806*/      OPC_CheckFoldableChainNode,
/*  9807*/      OPC_MoveChild1,
/*  9808*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9811*/      OPC_MoveChild0,
/*  9812*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9815*/      OPC_RecordChild0, // #1 = $off
/*  9816*/      OPC_MoveChild0,
/*  9817*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9820*/      OPC_MoveParent,
/*  9821*/      OPC_MoveParent,
/*  9822*/      OPC_RecordChild1, // #2 = $addr
/*  9823*/      OPC_CheckType, MVT::i32,
/*  9825*/      OPC_MoveParent,
/*  9826*/      OPC_RecordChild2, // #3 = $val
/*  9827*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/*  9829*/      OPC_MoveParent,
/*  9830*/      OPC_CheckType, MVT::i32,
/*  9832*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9834*/      OPC_EmitMergeInputChains1_0,
/*  9835*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9838*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/*  9848*/    /*Scope*/ 53, /*->9902*/
/*  9849*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  9852*/      OPC_MoveChild0,
/*  9853*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/*  9856*/      OPC_RecordMemRef,
/*  9857*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/*  9858*/      OPC_CheckFoldableChainNode,
/*  9859*/      OPC_MoveChild1,
/*  9860*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9863*/      OPC_MoveChild0,
/*  9864*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9867*/      OPC_RecordChild0, // #1 = $off
/*  9868*/      OPC_MoveChild0,
/*  9869*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9872*/      OPC_MoveParent,
/*  9873*/      OPC_MoveParent,
/*  9874*/      OPC_RecordChild1, // #2 = $addr
/*  9875*/      OPC_CheckType, MVT::i32,
/*  9877*/      OPC_MoveParent,
/*  9878*/      OPC_RecordChild2, // #3 = $exp
/*  9879*/      OPC_RecordChild3, // #4 = $new
/*  9880*/      OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/*  9882*/      OPC_MoveParent,
/*  9883*/      OPC_CheckType, MVT::i32,
/*  9885*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9887*/      OPC_EmitMergeInputChains1_0,
/*  9888*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9891*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_8>>, 255:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/*  9902*/    /*Scope*/ 54, /*->9957*/
/*  9903*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/*  9907*/      OPC_MoveChild0,
/*  9908*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/*  9911*/      OPC_RecordMemRef,
/*  9912*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/*  9913*/      OPC_CheckFoldableChainNode,
/*  9914*/      OPC_MoveChild1,
/*  9915*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/*  9918*/      OPC_MoveChild0,
/*  9919*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9922*/      OPC_RecordChild0, // #1 = $off
/*  9923*/      OPC_MoveChild0,
/*  9924*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/*  9927*/      OPC_MoveParent,
/*  9928*/      OPC_MoveParent,
/*  9929*/      OPC_RecordChild1, // #2 = $addr
/*  9930*/      OPC_CheckType, MVT::i32,
/*  9932*/      OPC_MoveParent,
/*  9933*/      OPC_RecordChild2, // #3 = $exp
/*  9934*/      OPC_RecordChild3, // #4 = $new
/*  9935*/      OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/*  9937*/      OPC_MoveParent,
/*  9938*/      OPC_CheckType, MVT::i32,
/*  9940*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9942*/      OPC_EmitMergeInputChains1_0,
/*  9943*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9946*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_16>>, 65535:{ *:[i32] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/*  9957*/    /*Scope*/ 54, /*->10012*/
/*  9958*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/*  9961*/      OPC_MoveChild0,
/*  9962*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/*  9965*/      OPC_MoveChild0,
/*  9966*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/*  9969*/      OPC_RecordMemRef,
/*  9970*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/*  9971*/      OPC_CheckFoldableChainNode,
/*  9972*/      OPC_MoveChild1,
/*  9973*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/*  9976*/      OPC_RecordChild0, // #1 = $off
/*  9977*/      OPC_MoveChild0,
/*  9978*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/*  9981*/      OPC_MoveParent,
/*  9982*/      OPC_MoveParent,
/*  9983*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/*  9985*/      OPC_MoveParent,
/*  9986*/      OPC_MoveParent,
/*  9987*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/*  9989*/      OPC_EmitMergeInputChains1_0,
/*  9990*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9993*/      OPC_EmitInteger, MVT::i32, 0, 
/*  9996*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 10003*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 2, 1, 4, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off))<<P:Predicate_atomic_load_8>>), 255:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 10012*/    /*Scope*/ 55, /*->10068*/
/* 10013*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 10017*/      OPC_MoveChild0,
/* 10018*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10021*/      OPC_MoveChild0,
/* 10022*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 10025*/      OPC_RecordMemRef,
/* 10026*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 10027*/      OPC_CheckFoldableChainNode,
/* 10028*/      OPC_MoveChild1,
/* 10029*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 10032*/      OPC_RecordChild0, // #1 = $off
/* 10033*/      OPC_MoveChild0,
/* 10034*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 10037*/      OPC_MoveParent,
/* 10038*/      OPC_MoveParent,
/* 10039*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 10041*/      OPC_MoveParent,
/* 10042*/      OPC_MoveParent,
/* 10043*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10045*/      OPC_EmitMergeInputChains1_0,
/* 10046*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10049*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10052*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 10059*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 2, 1, 4, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off))<<P:Predicate_atomic_load_16>>), 65535:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 10068*/    /*Scope*/ 54, /*->10123*/
/* 10069*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 10072*/      OPC_MoveChild0,
/* 10073*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10076*/      OPC_MoveChild0,
/* 10077*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 10080*/      OPC_RecordMemRef,
/* 10081*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 10082*/      OPC_CheckFoldableChainNode,
/* 10083*/      OPC_MoveChild1,
/* 10084*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 10087*/      OPC_RecordChild0, // #1 = $off
/* 10088*/      OPC_MoveChild0,
/* 10089*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 10092*/      OPC_MoveParent,
/* 10093*/      OPC_MoveParent,
/* 10094*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 10096*/      OPC_MoveParent,
/* 10097*/      OPC_MoveParent,
/* 10098*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10100*/      OPC_EmitMergeInputChains1_0,
/* 10101*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10104*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10107*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 10114*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 2, 1, 4, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off))<<P:Predicate_atomic_load_8>>), 255:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 10123*/    /*Scope*/ 55, /*->10179*/
/* 10124*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 10128*/      OPC_MoveChild0,
/* 10129*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10132*/      OPC_MoveChild0,
/* 10133*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 10136*/      OPC_RecordMemRef,
/* 10137*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 10138*/      OPC_CheckFoldableChainNode,
/* 10139*/      OPC_MoveChild1,
/* 10140*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 10143*/      OPC_RecordChild0, // #1 = $off
/* 10144*/      OPC_MoveChild0,
/* 10145*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 10148*/      OPC_MoveParent,
/* 10149*/      OPC_MoveParent,
/* 10150*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 10152*/      OPC_MoveParent,
/* 10153*/      OPC_MoveParent,
/* 10154*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10156*/      OPC_EmitMergeInputChains1_0,
/* 10157*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10160*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10163*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 10170*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 2, 1, 4, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off))<<P:Predicate_atomic_load_16>>), 65535:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 10179*/    /*Scope*/ 58, /*->10238*/
/* 10180*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 10183*/      OPC_MoveChild0,
/* 10184*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10187*/      OPC_MoveChild0,
/* 10188*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 10191*/      OPC_RecordMemRef,
/* 10192*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 10193*/      OPC_CheckFoldableChainNode,
/* 10194*/      OPC_RecordChild1, // #1 = $off
/* 10195*/      OPC_MoveChild1,
/* 10196*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10199*/      OPC_MoveParent,
/* 10200*/      OPC_MoveChild2,
/* 10201*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 10204*/      OPC_RecordChild0, // #2 = $val
/* 10205*/      OPC_MoveParent,
/* 10206*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 10208*/      OPC_MoveParent,
/* 10209*/      OPC_MoveParent,
/* 10210*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10212*/      OPC_EmitMergeInputChains1_0,
/* 10213*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10216*/      OPC_EmitConvertToTarget, 1,
/* 10218*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10221*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 10228*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>), 255:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 10238*/    /*Scope*/ 59, /*->10298*/
/* 10239*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 10243*/      OPC_MoveChild0,
/* 10244*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10247*/      OPC_MoveChild0,
/* 10248*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 10251*/      OPC_RecordMemRef,
/* 10252*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 10253*/      OPC_CheckFoldableChainNode,
/* 10254*/      OPC_RecordChild1, // #1 = $off
/* 10255*/      OPC_MoveChild1,
/* 10256*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10259*/      OPC_MoveParent,
/* 10260*/      OPC_MoveChild2,
/* 10261*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 10264*/      OPC_RecordChild0, // #2 = $val
/* 10265*/      OPC_MoveParent,
/* 10266*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 10268*/      OPC_MoveParent,
/* 10269*/      OPC_MoveParent,
/* 10270*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10272*/      OPC_EmitMergeInputChains1_0,
/* 10273*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10276*/      OPC_EmitConvertToTarget, 1,
/* 10278*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10281*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 10288*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>), 65535:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 10298*/    /*Scope*/ 58, /*->10357*/
/* 10299*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 10302*/      OPC_MoveChild0,
/* 10303*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10306*/      OPC_MoveChild0,
/* 10307*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 10310*/      OPC_RecordMemRef,
/* 10311*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 10312*/      OPC_CheckFoldableChainNode,
/* 10313*/      OPC_RecordChild1, // #1 = $off
/* 10314*/      OPC_MoveChild1,
/* 10315*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10318*/      OPC_MoveParent,
/* 10319*/      OPC_MoveChild2,
/* 10320*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 10323*/      OPC_RecordChild0, // #2 = $val
/* 10324*/      OPC_MoveParent,
/* 10325*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 10327*/      OPC_MoveParent,
/* 10328*/      OPC_MoveParent,
/* 10329*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10331*/      OPC_EmitMergeInputChains1_0,
/* 10332*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10335*/      OPC_EmitConvertToTarget, 1,
/* 10337*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10340*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 10347*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>), 255:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 10357*/    /*Scope*/ 59, /*->10417*/
/* 10358*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 10362*/      OPC_MoveChild0,
/* 10363*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10366*/      OPC_MoveChild0,
/* 10367*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 10370*/      OPC_RecordMemRef,
/* 10371*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 10372*/      OPC_CheckFoldableChainNode,
/* 10373*/      OPC_RecordChild1, // #1 = $off
/* 10374*/      OPC_MoveChild1,
/* 10375*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10378*/      OPC_MoveParent,
/* 10379*/      OPC_MoveChild2,
/* 10380*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 10383*/      OPC_RecordChild0, // #2 = $val
/* 10384*/      OPC_MoveParent,
/* 10385*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 10387*/      OPC_MoveParent,
/* 10388*/      OPC_MoveParent,
/* 10389*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10391*/      OPC_EmitMergeInputChains1_0,
/* 10392*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10395*/      OPC_EmitConvertToTarget, 1,
/* 10397*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10400*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 10407*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>), 65535:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 10417*/    /*Scope*/ 58, /*->10476*/
/* 10418*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 10421*/      OPC_MoveChild0,
/* 10422*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10425*/      OPC_MoveChild0,
/* 10426*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 10429*/      OPC_RecordMemRef,
/* 10430*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 10431*/      OPC_CheckFoldableChainNode,
/* 10432*/      OPC_RecordChild1, // #1 = $off
/* 10433*/      OPC_MoveChild1,
/* 10434*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10437*/      OPC_MoveParent,
/* 10438*/      OPC_MoveChild2,
/* 10439*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 10442*/      OPC_RecordChild0, // #2 = $val
/* 10443*/      OPC_MoveParent,
/* 10444*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 10446*/      OPC_MoveParent,
/* 10447*/      OPC_MoveParent,
/* 10448*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10450*/      OPC_EmitMergeInputChains1_0,
/* 10451*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10454*/      OPC_EmitConvertToTarget, 1,
/* 10456*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10459*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 10466*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>), 255:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 10476*/    /*Scope*/ 59, /*->10536*/
/* 10477*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 10481*/      OPC_MoveChild0,
/* 10482*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10485*/      OPC_MoveChild0,
/* 10486*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 10489*/      OPC_RecordMemRef,
/* 10490*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 10491*/      OPC_CheckFoldableChainNode,
/* 10492*/      OPC_RecordChild1, // #1 = $off
/* 10493*/      OPC_MoveChild1,
/* 10494*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10497*/      OPC_MoveParent,
/* 10498*/      OPC_MoveChild2,
/* 10499*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 10502*/      OPC_RecordChild0, // #2 = $val
/* 10503*/      OPC_MoveParent,
/* 10504*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 10506*/      OPC_MoveParent,
/* 10507*/      OPC_MoveParent,
/* 10508*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10510*/      OPC_EmitMergeInputChains1_0,
/* 10511*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10514*/      OPC_EmitConvertToTarget, 1,
/* 10516*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10519*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 10526*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>), 65535:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 10536*/    /*Scope*/ 58, /*->10595*/
/* 10537*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 10540*/      OPC_MoveChild0,
/* 10541*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10544*/      OPC_MoveChild0,
/* 10545*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 10548*/      OPC_RecordMemRef,
/* 10549*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 10550*/      OPC_CheckFoldableChainNode,
/* 10551*/      OPC_RecordChild1, // #1 = $off
/* 10552*/      OPC_MoveChild1,
/* 10553*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10556*/      OPC_MoveParent,
/* 10557*/      OPC_MoveChild2,
/* 10558*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 10561*/      OPC_RecordChild0, // #2 = $val
/* 10562*/      OPC_MoveParent,
/* 10563*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 10565*/      OPC_MoveParent,
/* 10566*/      OPC_MoveParent,
/* 10567*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10569*/      OPC_EmitMergeInputChains1_0,
/* 10570*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10573*/      OPC_EmitConvertToTarget, 1,
/* 10575*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10578*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 10585*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>), 255:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 10595*/    /*Scope*/ 59, /*->10655*/
/* 10596*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 10600*/      OPC_MoveChild0,
/* 10601*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10604*/      OPC_MoveChild0,
/* 10605*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 10608*/      OPC_RecordMemRef,
/* 10609*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 10610*/      OPC_CheckFoldableChainNode,
/* 10611*/      OPC_RecordChild1, // #1 = $off
/* 10612*/      OPC_MoveChild1,
/* 10613*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10616*/      OPC_MoveParent,
/* 10617*/      OPC_MoveChild2,
/* 10618*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 10621*/      OPC_RecordChild0, // #2 = $val
/* 10622*/      OPC_MoveParent,
/* 10623*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 10625*/      OPC_MoveParent,
/* 10626*/      OPC_MoveParent,
/* 10627*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10629*/      OPC_EmitMergeInputChains1_0,
/* 10630*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10633*/      OPC_EmitConvertToTarget, 1,
/* 10635*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10638*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 10645*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>), 65535:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 10655*/    /*Scope*/ 58, /*->10714*/
/* 10656*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 10659*/      OPC_MoveChild0,
/* 10660*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10663*/      OPC_MoveChild0,
/* 10664*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 10667*/      OPC_RecordMemRef,
/* 10668*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 10669*/      OPC_CheckFoldableChainNode,
/* 10670*/      OPC_RecordChild1, // #1 = $off
/* 10671*/      OPC_MoveChild1,
/* 10672*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10675*/      OPC_MoveParent,
/* 10676*/      OPC_MoveChild2,
/* 10677*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 10680*/      OPC_RecordChild0, // #2 = $val
/* 10681*/      OPC_MoveParent,
/* 10682*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 10684*/      OPC_MoveParent,
/* 10685*/      OPC_MoveParent,
/* 10686*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10688*/      OPC_EmitMergeInputChains1_0,
/* 10689*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10692*/      OPC_EmitConvertToTarget, 1,
/* 10694*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10697*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 10704*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>), 255:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 10714*/    /*Scope*/ 59, /*->10774*/
/* 10715*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 10719*/      OPC_MoveChild0,
/* 10720*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10723*/      OPC_MoveChild0,
/* 10724*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 10727*/      OPC_RecordMemRef,
/* 10728*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 10729*/      OPC_CheckFoldableChainNode,
/* 10730*/      OPC_RecordChild1, // #1 = $off
/* 10731*/      OPC_MoveChild1,
/* 10732*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10735*/      OPC_MoveParent,
/* 10736*/      OPC_MoveChild2,
/* 10737*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 10740*/      OPC_RecordChild0, // #2 = $val
/* 10741*/      OPC_MoveParent,
/* 10742*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 10744*/      OPC_MoveParent,
/* 10745*/      OPC_MoveParent,
/* 10746*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10748*/      OPC_EmitMergeInputChains1_0,
/* 10749*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10752*/      OPC_EmitConvertToTarget, 1,
/* 10754*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10757*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 10764*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>), 65535:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 10774*/    /*Scope*/ 58, /*->10833*/
/* 10775*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 10778*/      OPC_MoveChild0,
/* 10779*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10782*/      OPC_MoveChild0,
/* 10783*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 10786*/      OPC_RecordMemRef,
/* 10787*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 10788*/      OPC_CheckFoldableChainNode,
/* 10789*/      OPC_RecordChild1, // #1 = $off
/* 10790*/      OPC_MoveChild1,
/* 10791*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10794*/      OPC_MoveParent,
/* 10795*/      OPC_MoveChild2,
/* 10796*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 10799*/      OPC_RecordChild0, // #2 = $val
/* 10800*/      OPC_MoveParent,
/* 10801*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 10803*/      OPC_MoveParent,
/* 10804*/      OPC_MoveParent,
/* 10805*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10807*/      OPC_EmitMergeInputChains1_0,
/* 10808*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10811*/      OPC_EmitConvertToTarget, 1,
/* 10813*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10816*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 10823*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>), 255:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 10833*/    /*Scope*/ 59, /*->10893*/
/* 10834*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 10838*/      OPC_MoveChild0,
/* 10839*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 10842*/      OPC_MoveChild0,
/* 10843*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 10846*/      OPC_RecordMemRef,
/* 10847*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 10848*/      OPC_CheckFoldableChainNode,
/* 10849*/      OPC_RecordChild1, // #1 = $off
/* 10850*/      OPC_MoveChild1,
/* 10851*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10854*/      OPC_MoveParent,
/* 10855*/      OPC_MoveChild2,
/* 10856*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 10859*/      OPC_RecordChild0, // #2 = $val
/* 10860*/      OPC_MoveParent,
/* 10861*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 10863*/      OPC_MoveParent,
/* 10864*/      OPC_MoveParent,
/* 10865*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10867*/      OPC_EmitMergeInputChains1_0,
/* 10868*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10871*/      OPC_EmitConvertToTarget, 1,
/* 10873*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10876*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 10883*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>), 65535:{ *:[i64] }) - Complexity = 21
                // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 10893*/    /*Scope*/ 48, /*->10942*/
/* 10894*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 10897*/      OPC_MoveChild0,
/* 10898*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 10901*/      OPC_RecordMemRef,
/* 10902*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 10903*/      OPC_CheckFoldableChainNode,
/* 10904*/      OPC_MoveChild1,
/* 10905*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 10908*/      OPC_RecordChild0, // #1 = $addr
/* 10909*/      OPC_RecordChild1, // #2 = $off
/* 10910*/      OPC_MoveChild1,
/* 10911*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10914*/      OPC_MoveParent,
/* 10915*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 10917*/      OPC_CheckType, MVT::i32,
/* 10919*/      OPC_MoveParent,
/* 10920*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 10922*/      OPC_MoveParent,
/* 10923*/      OPC_CheckType, MVT::i32,
/* 10925*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10927*/      OPC_EmitMergeInputChains1_0,
/* 10928*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10931*/      OPC_EmitConvertToTarget, 2,
/* 10933*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 3, 4, 1, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>)<<P:Predicate_atomic_load_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_LOAD8_U_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 10942*/    /*Scope*/ 49, /*->10992*/
/* 10943*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 10947*/      OPC_MoveChild0,
/* 10948*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 10951*/      OPC_RecordMemRef,
/* 10952*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 10953*/      OPC_CheckFoldableChainNode,
/* 10954*/      OPC_MoveChild1,
/* 10955*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 10958*/      OPC_RecordChild0, // #1 = $addr
/* 10959*/      OPC_RecordChild1, // #2 = $off
/* 10960*/      OPC_MoveChild1,
/* 10961*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 10964*/      OPC_MoveParent,
/* 10965*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 10967*/      OPC_CheckType, MVT::i32,
/* 10969*/      OPC_MoveParent,
/* 10970*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 10972*/      OPC_MoveParent,
/* 10973*/      OPC_CheckType, MVT::i32,
/* 10975*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 10977*/      OPC_EmitMergeInputChains1_0,
/* 10978*/      OPC_EmitInteger, MVT::i32, 0, 
/* 10981*/      OPC_EmitConvertToTarget, 2,
/* 10983*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 3, 4, 1, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>)<<P:Predicate_atomic_load_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_LOAD16_U_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 10992*/    /*Scope*/ 48, /*->11041*/
/* 10993*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 10996*/      OPC_MoveChild0,
/* 10997*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 11000*/      OPC_RecordMemRef,
/* 11001*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 11002*/      OPC_CheckFoldableChainNode,
/* 11003*/      OPC_MoveChild1,
/* 11004*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 11007*/      OPC_RecordChild0, // #1 = $addr
/* 11008*/      OPC_RecordChild1, // #2 = $off
/* 11009*/      OPC_MoveChild1,
/* 11010*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11013*/      OPC_MoveParent,
/* 11014*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 11016*/      OPC_CheckType, MVT::i32,
/* 11018*/      OPC_MoveParent,
/* 11019*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 11021*/      OPC_MoveParent,
/* 11022*/      OPC_CheckType, MVT::i32,
/* 11024*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11026*/      OPC_EmitMergeInputChains1_0,
/* 11027*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11030*/      OPC_EmitConvertToTarget, 2,
/* 11032*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 3, 4, 1, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>)<<P:Predicate_atomic_load_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_LOAD8_U_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 11041*/    /*Scope*/ 49, /*->11091*/
/* 11042*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 11046*/      OPC_MoveChild0,
/* 11047*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 11050*/      OPC_RecordMemRef,
/* 11051*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 11052*/      OPC_CheckFoldableChainNode,
/* 11053*/      OPC_MoveChild1,
/* 11054*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 11057*/      OPC_RecordChild0, // #1 = $addr
/* 11058*/      OPC_RecordChild1, // #2 = $off
/* 11059*/      OPC_MoveChild1,
/* 11060*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11063*/      OPC_MoveParent,
/* 11064*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 11066*/      OPC_CheckType, MVT::i32,
/* 11068*/      OPC_MoveParent,
/* 11069*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 11071*/      OPC_MoveParent,
/* 11072*/      OPC_CheckType, MVT::i32,
/* 11074*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11076*/      OPC_EmitMergeInputChains1_0,
/* 11077*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11080*/      OPC_EmitConvertToTarget, 2,
/* 11082*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 3, 4, 1, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>)<<P:Predicate_atomic_load_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_LOAD16_U_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 11091*/    /*Scope*/ 50, /*->11142*/
/* 11092*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 11095*/      OPC_MoveChild0,
/* 11096*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 11099*/      OPC_RecordMemRef,
/* 11100*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 11101*/      OPC_CheckFoldableChainNode,
/* 11102*/      OPC_MoveChild1,
/* 11103*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 11106*/      OPC_RecordChild0, // #1 = $addr
/* 11107*/      OPC_RecordChild1, // #2 = $off
/* 11108*/      OPC_MoveChild1,
/* 11109*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11112*/      OPC_MoveParent,
/* 11113*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 11115*/      OPC_CheckType, MVT::i32,
/* 11117*/      OPC_MoveParent,
/* 11118*/      OPC_RecordChild2, // #3 = $val
/* 11119*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 11121*/      OPC_MoveParent,
/* 11122*/      OPC_CheckType, MVT::i32,
/* 11124*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11126*/      OPC_EmitMergeInputChains1_0,
/* 11127*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11130*/      OPC_EmitConvertToTarget, 2,
/* 11132*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11142*/    /*Scope*/ 51, /*->11194*/
/* 11143*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 11147*/      OPC_MoveChild0,
/* 11148*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 11151*/      OPC_RecordMemRef,
/* 11152*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 11153*/      OPC_CheckFoldableChainNode,
/* 11154*/      OPC_MoveChild1,
/* 11155*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 11158*/      OPC_RecordChild0, // #1 = $addr
/* 11159*/      OPC_RecordChild1, // #2 = $off
/* 11160*/      OPC_MoveChild1,
/* 11161*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11164*/      OPC_MoveParent,
/* 11165*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 11167*/      OPC_CheckType, MVT::i32,
/* 11169*/      OPC_MoveParent,
/* 11170*/      OPC_RecordChild2, // #3 = $val
/* 11171*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 11173*/      OPC_MoveParent,
/* 11174*/      OPC_CheckType, MVT::i32,
/* 11176*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11178*/      OPC_EmitMergeInputChains1_0,
/* 11179*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11182*/      OPC_EmitConvertToTarget, 2,
/* 11184*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11194*/    /*Scope*/ 50, /*->11245*/
/* 11195*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 11198*/      OPC_MoveChild0,
/* 11199*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 11202*/      OPC_RecordMemRef,
/* 11203*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 11204*/      OPC_CheckFoldableChainNode,
/* 11205*/      OPC_MoveChild1,
/* 11206*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 11209*/      OPC_RecordChild0, // #1 = $addr
/* 11210*/      OPC_RecordChild1, // #2 = $off
/* 11211*/      OPC_MoveChild1,
/* 11212*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11215*/      OPC_MoveParent,
/* 11216*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 11218*/      OPC_CheckType, MVT::i32,
/* 11220*/      OPC_MoveParent,
/* 11221*/      OPC_RecordChild2, // #3 = $val
/* 11222*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 11224*/      OPC_MoveParent,
/* 11225*/      OPC_CheckType, MVT::i32,
/* 11227*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11229*/      OPC_EmitMergeInputChains1_0,
/* 11230*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11233*/      OPC_EmitConvertToTarget, 2,
/* 11235*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11245*/    /*Scope*/ 51, /*->11297*/
/* 11246*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 11250*/      OPC_MoveChild0,
/* 11251*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 11254*/      OPC_RecordMemRef,
/* 11255*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 11256*/      OPC_CheckFoldableChainNode,
/* 11257*/      OPC_MoveChild1,
/* 11258*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 11261*/      OPC_RecordChild0, // #1 = $addr
/* 11262*/      OPC_RecordChild1, // #2 = $off
/* 11263*/      OPC_MoveChild1,
/* 11264*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11267*/      OPC_MoveParent,
/* 11268*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 11270*/      OPC_CheckType, MVT::i32,
/* 11272*/      OPC_MoveParent,
/* 11273*/      OPC_RecordChild2, // #3 = $val
/* 11274*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 11276*/      OPC_MoveParent,
/* 11277*/      OPC_CheckType, MVT::i32,
/* 11279*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11281*/      OPC_EmitMergeInputChains1_0,
/* 11282*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11285*/      OPC_EmitConvertToTarget, 2,
/* 11287*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11297*/    /*Scope*/ 50, /*->11348*/
/* 11298*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 11301*/      OPC_MoveChild0,
/* 11302*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 11305*/      OPC_RecordMemRef,
/* 11306*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 11307*/      OPC_CheckFoldableChainNode,
/* 11308*/      OPC_MoveChild1,
/* 11309*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 11312*/      OPC_RecordChild0, // #1 = $addr
/* 11313*/      OPC_RecordChild1, // #2 = $off
/* 11314*/      OPC_MoveChild1,
/* 11315*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11318*/      OPC_MoveParent,
/* 11319*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 11321*/      OPC_CheckType, MVT::i32,
/* 11323*/      OPC_MoveParent,
/* 11324*/      OPC_RecordChild2, // #3 = $val
/* 11325*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 11327*/      OPC_MoveParent,
/* 11328*/      OPC_CheckType, MVT::i32,
/* 11330*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11332*/      OPC_EmitMergeInputChains1_0,
/* 11333*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11336*/      OPC_EmitConvertToTarget, 2,
/* 11338*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11348*/    /*Scope*/ 51, /*->11400*/
/* 11349*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 11353*/      OPC_MoveChild0,
/* 11354*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 11357*/      OPC_RecordMemRef,
/* 11358*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 11359*/      OPC_CheckFoldableChainNode,
/* 11360*/      OPC_MoveChild1,
/* 11361*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 11364*/      OPC_RecordChild0, // #1 = $addr
/* 11365*/      OPC_RecordChild1, // #2 = $off
/* 11366*/      OPC_MoveChild1,
/* 11367*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11370*/      OPC_MoveParent,
/* 11371*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 11373*/      OPC_CheckType, MVT::i32,
/* 11375*/      OPC_MoveParent,
/* 11376*/      OPC_RecordChild2, // #3 = $val
/* 11377*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 11379*/      OPC_MoveParent,
/* 11380*/      OPC_CheckType, MVT::i32,
/* 11382*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11384*/      OPC_EmitMergeInputChains1_0,
/* 11385*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11388*/      OPC_EmitConvertToTarget, 2,
/* 11390*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11400*/    /*Scope*/ 50, /*->11451*/
/* 11401*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 11404*/      OPC_MoveChild0,
/* 11405*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 11408*/      OPC_RecordMemRef,
/* 11409*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 11410*/      OPC_CheckFoldableChainNode,
/* 11411*/      OPC_MoveChild1,
/* 11412*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 11415*/      OPC_RecordChild0, // #1 = $addr
/* 11416*/      OPC_RecordChild1, // #2 = $off
/* 11417*/      OPC_MoveChild1,
/* 11418*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11421*/      OPC_MoveParent,
/* 11422*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 11424*/      OPC_CheckType, MVT::i32,
/* 11426*/      OPC_MoveParent,
/* 11427*/      OPC_RecordChild2, // #3 = $val
/* 11428*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 11430*/      OPC_MoveParent,
/* 11431*/      OPC_CheckType, MVT::i32,
/* 11433*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11435*/      OPC_EmitMergeInputChains1_0,
/* 11436*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11439*/      OPC_EmitConvertToTarget, 2,
/* 11441*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11451*/    /*Scope*/ 51, /*->11503*/
/* 11452*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 11456*/      OPC_MoveChild0,
/* 11457*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 11460*/      OPC_RecordMemRef,
/* 11461*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 11462*/      OPC_CheckFoldableChainNode,
/* 11463*/      OPC_MoveChild1,
/* 11464*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 11467*/      OPC_RecordChild0, // #1 = $addr
/* 11468*/      OPC_RecordChild1, // #2 = $off
/* 11469*/      OPC_MoveChild1,
/* 11470*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11473*/      OPC_MoveParent,
/* 11474*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 11476*/      OPC_CheckType, MVT::i32,
/* 11478*/      OPC_MoveParent,
/* 11479*/      OPC_RecordChild2, // #3 = $val
/* 11480*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 11482*/      OPC_MoveParent,
/* 11483*/      OPC_CheckType, MVT::i32,
/* 11485*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11487*/      OPC_EmitMergeInputChains1_0,
/* 11488*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11491*/      OPC_EmitConvertToTarget, 2,
/* 11493*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11503*/    /*Scope*/ 50, /*->11554*/
/* 11504*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 11507*/      OPC_MoveChild0,
/* 11508*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 11511*/      OPC_RecordMemRef,
/* 11512*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 11513*/      OPC_CheckFoldableChainNode,
/* 11514*/      OPC_MoveChild1,
/* 11515*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 11518*/      OPC_RecordChild0, // #1 = $addr
/* 11519*/      OPC_RecordChild1, // #2 = $off
/* 11520*/      OPC_MoveChild1,
/* 11521*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11524*/      OPC_MoveParent,
/* 11525*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 11527*/      OPC_CheckType, MVT::i32,
/* 11529*/      OPC_MoveParent,
/* 11530*/      OPC_RecordChild2, // #3 = $val
/* 11531*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 11533*/      OPC_MoveParent,
/* 11534*/      OPC_CheckType, MVT::i32,
/* 11536*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11538*/      OPC_EmitMergeInputChains1_0,
/* 11539*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11542*/      OPC_EmitConvertToTarget, 2,
/* 11544*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11554*/    /*Scope*/ 51, /*->11606*/
/* 11555*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 11559*/      OPC_MoveChild0,
/* 11560*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 11563*/      OPC_RecordMemRef,
/* 11564*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 11565*/      OPC_CheckFoldableChainNode,
/* 11566*/      OPC_MoveChild1,
/* 11567*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 11570*/      OPC_RecordChild0, // #1 = $addr
/* 11571*/      OPC_RecordChild1, // #2 = $off
/* 11572*/      OPC_MoveChild1,
/* 11573*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11576*/      OPC_MoveParent,
/* 11577*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 11579*/      OPC_CheckType, MVT::i32,
/* 11581*/      OPC_MoveParent,
/* 11582*/      OPC_RecordChild2, // #3 = $val
/* 11583*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 11585*/      OPC_MoveParent,
/* 11586*/      OPC_CheckType, MVT::i32,
/* 11588*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11590*/      OPC_EmitMergeInputChains1_0,
/* 11591*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11594*/      OPC_EmitConvertToTarget, 2,
/* 11596*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11606*/    /*Scope*/ 50, /*->11657*/
/* 11607*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 11610*/      OPC_MoveChild0,
/* 11611*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 11614*/      OPC_RecordMemRef,
/* 11615*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 11616*/      OPC_CheckFoldableChainNode,
/* 11617*/      OPC_MoveChild1,
/* 11618*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 11621*/      OPC_RecordChild0, // #1 = $addr
/* 11622*/      OPC_RecordChild1, // #2 = $off
/* 11623*/      OPC_MoveChild1,
/* 11624*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11627*/      OPC_MoveParent,
/* 11628*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 11630*/      OPC_CheckType, MVT::i32,
/* 11632*/      OPC_MoveParent,
/* 11633*/      OPC_RecordChild2, // #3 = $val
/* 11634*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 11636*/      OPC_MoveParent,
/* 11637*/      OPC_CheckType, MVT::i32,
/* 11639*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11641*/      OPC_EmitMergeInputChains1_0,
/* 11642*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11645*/      OPC_EmitConvertToTarget, 2,
/* 11647*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11657*/    /*Scope*/ 51, /*->11709*/
/* 11658*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 11662*/      OPC_MoveChild0,
/* 11663*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 11666*/      OPC_RecordMemRef,
/* 11667*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 11668*/      OPC_CheckFoldableChainNode,
/* 11669*/      OPC_MoveChild1,
/* 11670*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 11673*/      OPC_RecordChild0, // #1 = $addr
/* 11674*/      OPC_RecordChild1, // #2 = $off
/* 11675*/      OPC_MoveChild1,
/* 11676*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11679*/      OPC_MoveParent,
/* 11680*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 11682*/      OPC_CheckType, MVT::i32,
/* 11684*/      OPC_MoveParent,
/* 11685*/      OPC_RecordChild2, // #3 = $val
/* 11686*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 11688*/      OPC_MoveParent,
/* 11689*/      OPC_CheckType, MVT::i32,
/* 11691*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11693*/      OPC_EmitMergeInputChains1_0,
/* 11694*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11697*/      OPC_EmitConvertToTarget, 2,
/* 11699*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11709*/    /*Scope*/ 50, /*->11760*/
/* 11710*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 11713*/      OPC_MoveChild0,
/* 11714*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 11717*/      OPC_RecordMemRef,
/* 11718*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 11719*/      OPC_CheckFoldableChainNode,
/* 11720*/      OPC_MoveChild1,
/* 11721*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 11724*/      OPC_RecordChild0, // #1 = $addr
/* 11725*/      OPC_RecordChild1, // #2 = $off
/* 11726*/      OPC_MoveChild1,
/* 11727*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11730*/      OPC_MoveParent,
/* 11731*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 11733*/      OPC_CheckType, MVT::i32,
/* 11735*/      OPC_MoveParent,
/* 11736*/      OPC_RecordChild2, // #3 = $val
/* 11737*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 11739*/      OPC_MoveParent,
/* 11740*/      OPC_CheckType, MVT::i32,
/* 11742*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11744*/      OPC_EmitMergeInputChains1_0,
/* 11745*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11748*/      OPC_EmitConvertToTarget, 2,
/* 11750*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11760*/    /*Scope*/ 51, /*->11812*/
/* 11761*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 11765*/      OPC_MoveChild0,
/* 11766*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 11769*/      OPC_RecordMemRef,
/* 11770*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 11771*/      OPC_CheckFoldableChainNode,
/* 11772*/      OPC_MoveChild1,
/* 11773*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 11776*/      OPC_RecordChild0, // #1 = $addr
/* 11777*/      OPC_RecordChild1, // #2 = $off
/* 11778*/      OPC_MoveChild1,
/* 11779*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11782*/      OPC_MoveParent,
/* 11783*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 11785*/      OPC_CheckType, MVT::i32,
/* 11787*/      OPC_MoveParent,
/* 11788*/      OPC_RecordChild2, // #3 = $val
/* 11789*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 11791*/      OPC_MoveParent,
/* 11792*/      OPC_CheckType, MVT::i32,
/* 11794*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11796*/      OPC_EmitMergeInputChains1_0,
/* 11797*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11800*/      OPC_EmitConvertToTarget, 2,
/* 11802*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11812*/    /*Scope*/ 50, /*->11863*/
/* 11813*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 11816*/      OPC_MoveChild0,
/* 11817*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 11820*/      OPC_RecordMemRef,
/* 11821*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 11822*/      OPC_CheckFoldableChainNode,
/* 11823*/      OPC_MoveChild1,
/* 11824*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 11827*/      OPC_RecordChild0, // #1 = $addr
/* 11828*/      OPC_RecordChild1, // #2 = $off
/* 11829*/      OPC_MoveChild1,
/* 11830*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11833*/      OPC_MoveParent,
/* 11834*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 11836*/      OPC_CheckType, MVT::i32,
/* 11838*/      OPC_MoveParent,
/* 11839*/      OPC_RecordChild2, // #3 = $val
/* 11840*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 11842*/      OPC_MoveParent,
/* 11843*/      OPC_CheckType, MVT::i32,
/* 11845*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11847*/      OPC_EmitMergeInputChains1_0,
/* 11848*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11851*/      OPC_EmitConvertToTarget, 2,
/* 11853*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11863*/    /*Scope*/ 51, /*->11915*/
/* 11864*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 11868*/      OPC_MoveChild0,
/* 11869*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 11872*/      OPC_RecordMemRef,
/* 11873*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 11874*/      OPC_CheckFoldableChainNode,
/* 11875*/      OPC_MoveChild1,
/* 11876*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 11879*/      OPC_RecordChild0, // #1 = $addr
/* 11880*/      OPC_RecordChild1, // #2 = $off
/* 11881*/      OPC_MoveChild1,
/* 11882*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11885*/      OPC_MoveParent,
/* 11886*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 11888*/      OPC_CheckType, MVT::i32,
/* 11890*/      OPC_MoveParent,
/* 11891*/      OPC_RecordChild2, // #3 = $val
/* 11892*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 11894*/      OPC_MoveParent,
/* 11895*/      OPC_CheckType, MVT::i32,
/* 11897*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11899*/      OPC_EmitMergeInputChains1_0,
/* 11900*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11903*/      OPC_EmitConvertToTarget, 2,
/* 11905*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11915*/    /*Scope*/ 50, /*->11966*/
/* 11916*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 11919*/      OPC_MoveChild0,
/* 11920*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 11923*/      OPC_RecordMemRef,
/* 11924*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 11925*/      OPC_CheckFoldableChainNode,
/* 11926*/      OPC_MoveChild1,
/* 11927*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 11930*/      OPC_RecordChild0, // #1 = $addr
/* 11931*/      OPC_RecordChild1, // #2 = $off
/* 11932*/      OPC_MoveChild1,
/* 11933*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11936*/      OPC_MoveParent,
/* 11937*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 11939*/      OPC_CheckType, MVT::i32,
/* 11941*/      OPC_MoveParent,
/* 11942*/      OPC_RecordChild2, // #3 = $val
/* 11943*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 11945*/      OPC_MoveParent,
/* 11946*/      OPC_CheckType, MVT::i32,
/* 11948*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 11950*/      OPC_EmitMergeInputChains1_0,
/* 11951*/      OPC_EmitInteger, MVT::i32, 0, 
/* 11954*/      OPC_EmitConvertToTarget, 2,
/* 11956*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 11966*/    /*Scope*/ 51, /*->12018*/
/* 11967*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 11971*/      OPC_MoveChild0,
/* 11972*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 11975*/      OPC_RecordMemRef,
/* 11976*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 11977*/      OPC_CheckFoldableChainNode,
/* 11978*/      OPC_MoveChild1,
/* 11979*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 11982*/      OPC_RecordChild0, // #1 = $addr
/* 11983*/      OPC_RecordChild1, // #2 = $off
/* 11984*/      OPC_MoveChild1,
/* 11985*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 11988*/      OPC_MoveParent,
/* 11989*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 11991*/      OPC_CheckType, MVT::i32,
/* 11993*/      OPC_MoveParent,
/* 11994*/      OPC_RecordChild2, // #3 = $val
/* 11995*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 11997*/      OPC_MoveParent,
/* 11998*/      OPC_CheckType, MVT::i32,
/* 12000*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12002*/      OPC_EmitMergeInputChains1_0,
/* 12003*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12006*/      OPC_EmitConvertToTarget, 2,
/* 12008*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 12018*/    /*Scope*/ 50, /*->12069*/
/* 12019*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 12022*/      OPC_MoveChild0,
/* 12023*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 12026*/      OPC_RecordMemRef,
/* 12027*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 12028*/      OPC_CheckFoldableChainNode,
/* 12029*/      OPC_MoveChild1,
/* 12030*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 12033*/      OPC_RecordChild0, // #1 = $addr
/* 12034*/      OPC_RecordChild1, // #2 = $off
/* 12035*/      OPC_MoveChild1,
/* 12036*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 12039*/      OPC_MoveParent,
/* 12040*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 12042*/      OPC_CheckType, MVT::i32,
/* 12044*/      OPC_MoveParent,
/* 12045*/      OPC_RecordChild2, // #3 = $val
/* 12046*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 12048*/      OPC_MoveParent,
/* 12049*/      OPC_CheckType, MVT::i32,
/* 12051*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12053*/      OPC_EmitMergeInputChains1_0,
/* 12054*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12057*/      OPC_EmitConvertToTarget, 2,
/* 12059*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 12069*/    /*Scope*/ 51, /*->12121*/
/* 12070*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 12074*/      OPC_MoveChild0,
/* 12075*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 12078*/      OPC_RecordMemRef,
/* 12079*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 12080*/      OPC_CheckFoldableChainNode,
/* 12081*/      OPC_MoveChild1,
/* 12082*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 12085*/      OPC_RecordChild0, // #1 = $addr
/* 12086*/      OPC_RecordChild1, // #2 = $off
/* 12087*/      OPC_MoveChild1,
/* 12088*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 12091*/      OPC_MoveParent,
/* 12092*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 12094*/      OPC_CheckType, MVT::i32,
/* 12096*/      OPC_MoveParent,
/* 12097*/      OPC_RecordChild2, // #3 = $val
/* 12098*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 12100*/      OPC_MoveParent,
/* 12101*/      OPC_CheckType, MVT::i32,
/* 12103*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12105*/      OPC_EmitMergeInputChains1_0,
/* 12106*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12109*/      OPC_EmitConvertToTarget, 2,
/* 12111*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 12121*/    /*Scope*/ 50, /*->12172*/
/* 12122*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 12125*/      OPC_MoveChild0,
/* 12126*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 12129*/      OPC_RecordMemRef,
/* 12130*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 12131*/      OPC_CheckFoldableChainNode,
/* 12132*/      OPC_MoveChild1,
/* 12133*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 12136*/      OPC_RecordChild0, // #1 = $addr
/* 12137*/      OPC_RecordChild1, // #2 = $off
/* 12138*/      OPC_MoveChild1,
/* 12139*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 12142*/      OPC_MoveParent,
/* 12143*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 12145*/      OPC_CheckType, MVT::i32,
/* 12147*/      OPC_MoveParent,
/* 12148*/      OPC_RecordChild2, // #3 = $val
/* 12149*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 12151*/      OPC_MoveParent,
/* 12152*/      OPC_CheckType, MVT::i32,
/* 12154*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12156*/      OPC_EmitMergeInputChains1_0,
/* 12157*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12160*/      OPC_EmitConvertToTarget, 2,
/* 12162*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 12172*/    /*Scope*/ 51, /*->12224*/
/* 12173*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 12177*/      OPC_MoveChild0,
/* 12178*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 12181*/      OPC_RecordMemRef,
/* 12182*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 12183*/      OPC_CheckFoldableChainNode,
/* 12184*/      OPC_MoveChild1,
/* 12185*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 12188*/      OPC_RecordChild0, // #1 = $addr
/* 12189*/      OPC_RecordChild1, // #2 = $off
/* 12190*/      OPC_MoveChild1,
/* 12191*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 12194*/      OPC_MoveParent,
/* 12195*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 12197*/      OPC_CheckType, MVT::i32,
/* 12199*/      OPC_MoveParent,
/* 12200*/      OPC_RecordChild2, // #3 = $val
/* 12201*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 12203*/      OPC_MoveParent,
/* 12204*/      OPC_CheckType, MVT::i32,
/* 12206*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12208*/      OPC_EmitMergeInputChains1_0,
/* 12209*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12212*/      OPC_EmitConvertToTarget, 2,
/* 12214*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 12224*/    /*Scope*/ 50, /*->12275*/
/* 12225*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 12228*/      OPC_MoveChild0,
/* 12229*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 12232*/      OPC_RecordMemRef,
/* 12233*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 12234*/      OPC_CheckFoldableChainNode,
/* 12235*/      OPC_MoveChild1,
/* 12236*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 12239*/      OPC_RecordChild0, // #1 = $addr
/* 12240*/      OPC_RecordChild1, // #2 = $off
/* 12241*/      OPC_MoveChild1,
/* 12242*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 12245*/      OPC_MoveParent,
/* 12246*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 12248*/      OPC_CheckType, MVT::i32,
/* 12250*/      OPC_MoveParent,
/* 12251*/      OPC_RecordChild2, // #3 = $val
/* 12252*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 12254*/      OPC_MoveParent,
/* 12255*/      OPC_CheckType, MVT::i32,
/* 12257*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12259*/      OPC_EmitMergeInputChains1_0,
/* 12260*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12263*/      OPC_EmitConvertToTarget, 2,
/* 12265*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 12275*/    /*Scope*/ 51, /*->12327*/
/* 12276*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 12280*/      OPC_MoveChild0,
/* 12281*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 12284*/      OPC_RecordMemRef,
/* 12285*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 12286*/      OPC_CheckFoldableChainNode,
/* 12287*/      OPC_MoveChild1,
/* 12288*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 12291*/      OPC_RecordChild0, // #1 = $addr
/* 12292*/      OPC_RecordChild1, // #2 = $off
/* 12293*/      OPC_MoveChild1,
/* 12294*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 12297*/      OPC_MoveParent,
/* 12298*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 12300*/      OPC_CheckType, MVT::i32,
/* 12302*/      OPC_MoveParent,
/* 12303*/      OPC_RecordChild2, // #3 = $val
/* 12304*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 12306*/      OPC_MoveParent,
/* 12307*/      OPC_CheckType, MVT::i32,
/* 12309*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12311*/      OPC_EmitMergeInputChains1_0,
/* 12312*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12315*/      OPC_EmitConvertToTarget, 2,
/* 12317*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 12327*/    /*Scope*/ 52, /*->12380*/
/* 12328*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 12331*/      OPC_MoveChild0,
/* 12332*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 12335*/      OPC_RecordMemRef,
/* 12336*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 12337*/      OPC_CheckFoldableChainNode,
/* 12338*/      OPC_MoveChild1,
/* 12339*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 12342*/      OPC_RecordChild0, // #1 = $addr
/* 12343*/      OPC_RecordChild1, // #2 = $off
/* 12344*/      OPC_MoveChild1,
/* 12345*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 12348*/      OPC_MoveParent,
/* 12349*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 12351*/      OPC_CheckType, MVT::i32,
/* 12353*/      OPC_MoveParent,
/* 12354*/      OPC_RecordChild2, // #3 = $exp
/* 12355*/      OPC_RecordChild3, // #4 = $new
/* 12356*/      OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 12358*/      OPC_MoveParent,
/* 12359*/      OPC_CheckType, MVT::i32,
/* 12361*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12363*/      OPC_EmitMergeInputChains1_0,
/* 12364*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12367*/      OPC_EmitConvertToTarget, 2,
/* 12369*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/* 12380*/    /*Scope*/ 53, /*->12434*/
/* 12381*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 12385*/      OPC_MoveChild0,
/* 12386*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 12389*/      OPC_RecordMemRef,
/* 12390*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 12391*/      OPC_CheckFoldableChainNode,
/* 12392*/      OPC_MoveChild1,
/* 12393*/      OPC_CheckOpcode, TARGET_VAL(ISD::ADD),
/* 12396*/      OPC_RecordChild0, // #1 = $addr
/* 12397*/      OPC_RecordChild1, // #2 = $off
/* 12398*/      OPC_MoveChild1,
/* 12399*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 12402*/      OPC_MoveParent,
/* 12403*/      OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 12405*/      OPC_CheckType, MVT::i32,
/* 12407*/      OPC_MoveParent,
/* 12408*/      OPC_RecordChild2, // #3 = $exp
/* 12409*/      OPC_RecordChild3, // #4 = $new
/* 12410*/      OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 12412*/      OPC_MoveParent,
/* 12413*/      OPC_CheckType, MVT::i32,
/* 12415*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12417*/      OPC_EmitMergeInputChains1_0,
/* 12418*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12421*/      OPC_EmitConvertToTarget, 2,
/* 12423*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/* 12434*/    /*Scope*/ 52, /*->12487*/
/* 12435*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 12438*/      OPC_MoveChild0,
/* 12439*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 12442*/      OPC_RecordMemRef,
/* 12443*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 12444*/      OPC_CheckFoldableChainNode,
/* 12445*/      OPC_MoveChild1,
/* 12446*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 12449*/      OPC_RecordChild0, // #1 = $addr
/* 12450*/      OPC_RecordChild1, // #2 = $off
/* 12451*/      OPC_MoveChild1,
/* 12452*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 12455*/      OPC_MoveParent,
/* 12456*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 12458*/      OPC_CheckType, MVT::i32,
/* 12460*/      OPC_MoveParent,
/* 12461*/      OPC_RecordChild2, // #3 = $exp
/* 12462*/      OPC_RecordChild3, // #4 = $new
/* 12463*/      OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 12465*/      OPC_MoveParent,
/* 12466*/      OPC_CheckType, MVT::i32,
/* 12468*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12470*/      OPC_EmitMergeInputChains1_0,
/* 12471*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12474*/      OPC_EmitConvertToTarget, 2,
/* 12476*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_8>>, 255:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW8_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/* 12487*/    /*Scope*/ 53, /*->12541*/
/* 12488*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 12492*/      OPC_MoveChild0,
/* 12493*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 12496*/      OPC_RecordMemRef,
/* 12497*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 12498*/      OPC_CheckFoldableChainNode,
/* 12499*/      OPC_MoveChild1,
/* 12500*/      OPC_CheckOpcode, TARGET_VAL(ISD::OR),
/* 12503*/      OPC_RecordChild0, // #1 = $addr
/* 12504*/      OPC_RecordChild1, // #2 = $off
/* 12505*/      OPC_MoveChild1,
/* 12506*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 12509*/      OPC_MoveParent,
/* 12510*/      OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 12512*/      OPC_CheckType, MVT::i32,
/* 12514*/      OPC_MoveParent,
/* 12515*/      OPC_RecordChild2, // #3 = $exp
/* 12516*/      OPC_RecordChild3, // #4 = $new
/* 12517*/      OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 12519*/      OPC_MoveParent,
/* 12520*/      OPC_CheckType, MVT::i32,
/* 12522*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12524*/      OPC_EmitMergeInputChains1_0,
/* 12525*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12528*/      OPC_EmitConvertToTarget, 2,
/* 12530*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_16>>, 65535:{ *:[i32] }) - Complexity = 19
                // Dst: (ATOMIC_RMW16_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/* 12541*/    /*Scope*/ 46, /*->12588*/
/* 12542*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 12545*/      OPC_MoveChild0,
/* 12546*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 12549*/      OPC_MoveChild0,
/* 12550*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 12553*/      OPC_RecordMemRef,
/* 12554*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 12555*/      OPC_CheckFoldableChainNode,
/* 12556*/      OPC_RecordChild1, // #1 = $addr
/* 12557*/      OPC_CheckChild1Type, MVT::i32,
/* 12559*/      OPC_MoveChild2,
/* 12560*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 12563*/      OPC_RecordChild0, // #2 = $val
/* 12564*/      OPC_MoveParent,
/* 12565*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 12567*/      OPC_MoveParent,
/* 12568*/      OPC_MoveParent,
/* 12569*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12571*/      OPC_EmitMergeInputChains1_0,
/* 12572*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12575*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12578*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>), 255:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 12588*/    /*Scope*/ 47, /*->12636*/
/* 12589*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 12593*/      OPC_MoveChild0,
/* 12594*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 12597*/      OPC_MoveChild0,
/* 12598*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 12601*/      OPC_RecordMemRef,
/* 12602*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 12603*/      OPC_CheckFoldableChainNode,
/* 12604*/      OPC_RecordChild1, // #1 = $addr
/* 12605*/      OPC_CheckChild1Type, MVT::i32,
/* 12607*/      OPC_MoveChild2,
/* 12608*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 12611*/      OPC_RecordChild0, // #2 = $val
/* 12612*/      OPC_MoveParent,
/* 12613*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 12615*/      OPC_MoveParent,
/* 12616*/      OPC_MoveParent,
/* 12617*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12619*/      OPC_EmitMergeInputChains1_0,
/* 12620*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12623*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12626*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>), 65535:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 12636*/    /*Scope*/ 46, /*->12683*/
/* 12637*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 12640*/      OPC_MoveChild0,
/* 12641*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 12644*/      OPC_MoveChild0,
/* 12645*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 12648*/      OPC_RecordMemRef,
/* 12649*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 12650*/      OPC_CheckFoldableChainNode,
/* 12651*/      OPC_RecordChild1, // #1 = $addr
/* 12652*/      OPC_CheckChild1Type, MVT::i32,
/* 12654*/      OPC_MoveChild2,
/* 12655*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 12658*/      OPC_RecordChild0, // #2 = $val
/* 12659*/      OPC_MoveParent,
/* 12660*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 12662*/      OPC_MoveParent,
/* 12663*/      OPC_MoveParent,
/* 12664*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12666*/      OPC_EmitMergeInputChains1_0,
/* 12667*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12670*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12673*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>), 255:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 12683*/    /*Scope*/ 47, /*->12731*/
/* 12684*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 12688*/      OPC_MoveChild0,
/* 12689*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 12692*/      OPC_MoveChild0,
/* 12693*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 12696*/      OPC_RecordMemRef,
/* 12697*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 12698*/      OPC_CheckFoldableChainNode,
/* 12699*/      OPC_RecordChild1, // #1 = $addr
/* 12700*/      OPC_CheckChild1Type, MVT::i32,
/* 12702*/      OPC_MoveChild2,
/* 12703*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 12706*/      OPC_RecordChild0, // #2 = $val
/* 12707*/      OPC_MoveParent,
/* 12708*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 12710*/      OPC_MoveParent,
/* 12711*/      OPC_MoveParent,
/* 12712*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12714*/      OPC_EmitMergeInputChains1_0,
/* 12715*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12718*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12721*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>), 65535:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 12731*/    /*Scope*/ 46, /*->12778*/
/* 12732*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 12735*/      OPC_MoveChild0,
/* 12736*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 12739*/      OPC_MoveChild0,
/* 12740*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 12743*/      OPC_RecordMemRef,
/* 12744*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 12745*/      OPC_CheckFoldableChainNode,
/* 12746*/      OPC_RecordChild1, // #1 = $addr
/* 12747*/      OPC_CheckChild1Type, MVT::i32,
/* 12749*/      OPC_MoveChild2,
/* 12750*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 12753*/      OPC_RecordChild0, // #2 = $val
/* 12754*/      OPC_MoveParent,
/* 12755*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 12757*/      OPC_MoveParent,
/* 12758*/      OPC_MoveParent,
/* 12759*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12761*/      OPC_EmitMergeInputChains1_0,
/* 12762*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12765*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12768*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>), 255:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 12778*/    /*Scope*/ 47, /*->12826*/
/* 12779*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 12783*/      OPC_MoveChild0,
/* 12784*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 12787*/      OPC_MoveChild0,
/* 12788*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 12791*/      OPC_RecordMemRef,
/* 12792*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 12793*/      OPC_CheckFoldableChainNode,
/* 12794*/      OPC_RecordChild1, // #1 = $addr
/* 12795*/      OPC_CheckChild1Type, MVT::i32,
/* 12797*/      OPC_MoveChild2,
/* 12798*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 12801*/      OPC_RecordChild0, // #2 = $val
/* 12802*/      OPC_MoveParent,
/* 12803*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 12805*/      OPC_MoveParent,
/* 12806*/      OPC_MoveParent,
/* 12807*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12809*/      OPC_EmitMergeInputChains1_0,
/* 12810*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12813*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12816*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>), 65535:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 12826*/    /*Scope*/ 46, /*->12873*/
/* 12827*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 12830*/      OPC_MoveChild0,
/* 12831*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 12834*/      OPC_MoveChild0,
/* 12835*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 12838*/      OPC_RecordMemRef,
/* 12839*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 12840*/      OPC_CheckFoldableChainNode,
/* 12841*/      OPC_RecordChild1, // #1 = $addr
/* 12842*/      OPC_CheckChild1Type, MVT::i32,
/* 12844*/      OPC_MoveChild2,
/* 12845*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 12848*/      OPC_RecordChild0, // #2 = $val
/* 12849*/      OPC_MoveParent,
/* 12850*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 12852*/      OPC_MoveParent,
/* 12853*/      OPC_MoveParent,
/* 12854*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12856*/      OPC_EmitMergeInputChains1_0,
/* 12857*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12860*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12863*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>), 255:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 12873*/    /*Scope*/ 47, /*->12921*/
/* 12874*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 12878*/      OPC_MoveChild0,
/* 12879*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 12882*/      OPC_MoveChild0,
/* 12883*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 12886*/      OPC_RecordMemRef,
/* 12887*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 12888*/      OPC_CheckFoldableChainNode,
/* 12889*/      OPC_RecordChild1, // #1 = $addr
/* 12890*/      OPC_CheckChild1Type, MVT::i32,
/* 12892*/      OPC_MoveChild2,
/* 12893*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 12896*/      OPC_RecordChild0, // #2 = $val
/* 12897*/      OPC_MoveParent,
/* 12898*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 12900*/      OPC_MoveParent,
/* 12901*/      OPC_MoveParent,
/* 12902*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12904*/      OPC_EmitMergeInputChains1_0,
/* 12905*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12908*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12911*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>), 65535:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 12921*/    /*Scope*/ 46, /*->12968*/
/* 12922*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 12925*/      OPC_MoveChild0,
/* 12926*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 12929*/      OPC_MoveChild0,
/* 12930*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 12933*/      OPC_RecordMemRef,
/* 12934*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 12935*/      OPC_CheckFoldableChainNode,
/* 12936*/      OPC_RecordChild1, // #1 = $addr
/* 12937*/      OPC_CheckChild1Type, MVT::i32,
/* 12939*/      OPC_MoveChild2,
/* 12940*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 12943*/      OPC_RecordChild0, // #2 = $val
/* 12944*/      OPC_MoveParent,
/* 12945*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 12947*/      OPC_MoveParent,
/* 12948*/      OPC_MoveParent,
/* 12949*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12951*/      OPC_EmitMergeInputChains1_0,
/* 12952*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12955*/      OPC_EmitInteger, MVT::i32, 0, 
/* 12958*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>), 255:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 12968*/    /*Scope*/ 47, /*->13016*/
/* 12969*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 12973*/      OPC_MoveChild0,
/* 12974*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 12977*/      OPC_MoveChild0,
/* 12978*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 12981*/      OPC_RecordMemRef,
/* 12982*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 12983*/      OPC_CheckFoldableChainNode,
/* 12984*/      OPC_RecordChild1, // #1 = $addr
/* 12985*/      OPC_CheckChild1Type, MVT::i32,
/* 12987*/      OPC_MoveChild2,
/* 12988*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 12991*/      OPC_RecordChild0, // #2 = $val
/* 12992*/      OPC_MoveParent,
/* 12993*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 12995*/      OPC_MoveParent,
/* 12996*/      OPC_MoveParent,
/* 12997*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 12999*/      OPC_EmitMergeInputChains1_0,
/* 13000*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13003*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13006*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>), 65535:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 13016*/    /*Scope*/ 46, /*->13063*/
/* 13017*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 13020*/      OPC_MoveChild0,
/* 13021*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 13024*/      OPC_MoveChild0,
/* 13025*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 13028*/      OPC_RecordMemRef,
/* 13029*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 13030*/      OPC_CheckFoldableChainNode,
/* 13031*/      OPC_RecordChild1, // #1 = $addr
/* 13032*/      OPC_CheckChild1Type, MVT::i32,
/* 13034*/      OPC_MoveChild2,
/* 13035*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 13038*/      OPC_RecordChild0, // #2 = $val
/* 13039*/      OPC_MoveParent,
/* 13040*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 13042*/      OPC_MoveParent,
/* 13043*/      OPC_MoveParent,
/* 13044*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13046*/      OPC_EmitMergeInputChains1_0,
/* 13047*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13050*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13053*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>), 255:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 13063*/    /*Scope*/ 47, /*->13111*/
/* 13064*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 13068*/      OPC_MoveChild0,
/* 13069*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 13072*/      OPC_MoveChild0,
/* 13073*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 13076*/      OPC_RecordMemRef,
/* 13077*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 13078*/      OPC_CheckFoldableChainNode,
/* 13079*/      OPC_RecordChild1, // #1 = $addr
/* 13080*/      OPC_CheckChild1Type, MVT::i32,
/* 13082*/      OPC_MoveChild2,
/* 13083*/      OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 13086*/      OPC_RecordChild0, // #2 = $val
/* 13087*/      OPC_MoveParent,
/* 13088*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 13090*/      OPC_MoveParent,
/* 13091*/      OPC_MoveParent,
/* 13092*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13094*/      OPC_EmitMergeInputChains1_0,
/* 13095*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13098*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13101*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>), 65535:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 13111*/    /*Scope*/ 51, /*->13163*/
/* 13112*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 13115*/      OPC_MoveChild0,
/* 13116*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 13119*/      OPC_MoveChild0,
/* 13120*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 13123*/      OPC_RecordMemRef,
/* 13124*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 13125*/      OPC_CheckFoldableChainNode,
/* 13126*/      OPC_RecordChild1, // #1 = $off
/* 13127*/      OPC_MoveChild1,
/* 13128*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 13131*/      OPC_MoveParent,
/* 13132*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 13134*/      OPC_MoveParent,
/* 13135*/      OPC_MoveParent,
/* 13136*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13138*/      OPC_EmitMergeInputChains1_0,
/* 13139*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13142*/      OPC_EmitConvertToTarget, 1,
/* 13144*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13147*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 13154*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 2, 3, 5, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (imm:{ *:[iPTR] }):$off)<<P:Predicate_atomic_load_8>>), 255:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 13163*/    /*Scope*/ 52, /*->13216*/
/* 13164*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 13168*/      OPC_MoveChild0,
/* 13169*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 13172*/      OPC_MoveChild0,
/* 13173*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 13176*/      OPC_RecordMemRef,
/* 13177*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 13178*/      OPC_CheckFoldableChainNode,
/* 13179*/      OPC_RecordChild1, // #1 = $off
/* 13180*/      OPC_MoveChild1,
/* 13181*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 13184*/      OPC_MoveParent,
/* 13185*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 13187*/      OPC_MoveParent,
/* 13188*/      OPC_MoveParent,
/* 13189*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13191*/      OPC_EmitMergeInputChains1_0,
/* 13192*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13195*/      OPC_EmitConvertToTarget, 1,
/* 13197*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13200*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 13207*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 2, 3, 5, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (imm:{ *:[iPTR] }):$off)<<P:Predicate_atomic_load_16>>), 65535:{ *:[i64] }) - Complexity = 18
                // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 13216*/    /*Scope*/ 51, /*->13268*/
/* 13217*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 13220*/      OPC_MoveChild0,
/* 13221*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 13224*/      OPC_RecordMemRef,
/* 13225*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 13226*/      OPC_CheckFoldableChainNode,
/* 13227*/      OPC_MoveChild1,
/* 13228*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13231*/      OPC_RecordChild0, // #1 = $off
/* 13232*/      OPC_MoveChild0,
/* 13233*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 13236*/      OPC_MoveParent,
/* 13237*/      OPC_MoveParent,
/* 13238*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 13240*/      OPC_MoveParent,
/* 13241*/      OPC_CheckType, MVT::i32,
/* 13243*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13245*/      OPC_EmitMergeInputChains1_0,
/* 13246*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13249*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13252*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 13259*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 2, 1, 4, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off))<<P:Predicate_atomic_load_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_LOAD8_U_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 13268*/    /*Scope*/ 52, /*->13321*/
/* 13269*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 13273*/      OPC_MoveChild0,
/* 13274*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 13277*/      OPC_RecordMemRef,
/* 13278*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 13279*/      OPC_CheckFoldableChainNode,
/* 13280*/      OPC_MoveChild1,
/* 13281*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13284*/      OPC_RecordChild0, // #1 = $off
/* 13285*/      OPC_MoveChild0,
/* 13286*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 13289*/      OPC_MoveParent,
/* 13290*/      OPC_MoveParent,
/* 13291*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 13293*/      OPC_MoveParent,
/* 13294*/      OPC_CheckType, MVT::i32,
/* 13296*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13298*/      OPC_EmitMergeInputChains1_0,
/* 13299*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13302*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13305*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 13312*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 2, 1, 4, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off))<<P:Predicate_atomic_load_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_LOAD16_U_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 13321*/    /*Scope*/ 51, /*->13373*/
/* 13322*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 13325*/      OPC_MoveChild0,
/* 13326*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 13329*/      OPC_RecordMemRef,
/* 13330*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 13331*/      OPC_CheckFoldableChainNode,
/* 13332*/      OPC_MoveChild1,
/* 13333*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13336*/      OPC_RecordChild0, // #1 = $off
/* 13337*/      OPC_MoveChild0,
/* 13338*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 13341*/      OPC_MoveParent,
/* 13342*/      OPC_MoveParent,
/* 13343*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 13345*/      OPC_MoveParent,
/* 13346*/      OPC_CheckType, MVT::i32,
/* 13348*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13350*/      OPC_EmitMergeInputChains1_0,
/* 13351*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13354*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13357*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 13364*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 2, 1, 4, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off))<<P:Predicate_atomic_load_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_LOAD8_U_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 13373*/    /*Scope*/ 52, /*->13426*/
/* 13374*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 13378*/      OPC_MoveChild0,
/* 13379*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 13382*/      OPC_RecordMemRef,
/* 13383*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 13384*/      OPC_CheckFoldableChainNode,
/* 13385*/      OPC_MoveChild1,
/* 13386*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13389*/      OPC_RecordChild0, // #1 = $off
/* 13390*/      OPC_MoveChild0,
/* 13391*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 13394*/      OPC_MoveParent,
/* 13395*/      OPC_MoveParent,
/* 13396*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 13398*/      OPC_MoveParent,
/* 13399*/      OPC_CheckType, MVT::i32,
/* 13401*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13403*/      OPC_EmitMergeInputChains1_0,
/* 13404*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13407*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13410*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 13417*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 2, 1, 4, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off))<<P:Predicate_atomic_load_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_LOAD16_U_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 13426*/    /*Scope*/ 53, /*->13480*/
/* 13427*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 13430*/      OPC_MoveChild0,
/* 13431*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 13434*/      OPC_RecordMemRef,
/* 13435*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 13436*/      OPC_CheckFoldableChainNode,
/* 13437*/      OPC_MoveChild1,
/* 13438*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13441*/      OPC_RecordChild0, // #1 = $off
/* 13442*/      OPC_MoveChild0,
/* 13443*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 13446*/      OPC_MoveParent,
/* 13447*/      OPC_MoveParent,
/* 13448*/      OPC_RecordChild2, // #2 = $val
/* 13449*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 13451*/      OPC_MoveParent,
/* 13452*/      OPC_CheckType, MVT::i32,
/* 13454*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13456*/      OPC_EmitMergeInputChains1_0,
/* 13457*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13460*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13463*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 13470*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 13480*/    /*Scope*/ 54, /*->13535*/
/* 13481*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 13485*/      OPC_MoveChild0,
/* 13486*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 13489*/      OPC_RecordMemRef,
/* 13490*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 13491*/      OPC_CheckFoldableChainNode,
/* 13492*/      OPC_MoveChild1,
/* 13493*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13496*/      OPC_RecordChild0, // #1 = $off
/* 13497*/      OPC_MoveChild0,
/* 13498*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 13501*/      OPC_MoveParent,
/* 13502*/      OPC_MoveParent,
/* 13503*/      OPC_RecordChild2, // #2 = $val
/* 13504*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 13506*/      OPC_MoveParent,
/* 13507*/      OPC_CheckType, MVT::i32,
/* 13509*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13511*/      OPC_EmitMergeInputChains1_0,
/* 13512*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13515*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13518*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 13525*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 13535*/    /*Scope*/ 53, /*->13589*/
/* 13536*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 13539*/      OPC_MoveChild0,
/* 13540*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 13543*/      OPC_RecordMemRef,
/* 13544*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 13545*/      OPC_CheckFoldableChainNode,
/* 13546*/      OPC_MoveChild1,
/* 13547*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13550*/      OPC_RecordChild0, // #1 = $off
/* 13551*/      OPC_MoveChild0,
/* 13552*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 13555*/      OPC_MoveParent,
/* 13556*/      OPC_MoveParent,
/* 13557*/      OPC_RecordChild2, // #2 = $val
/* 13558*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 13560*/      OPC_MoveParent,
/* 13561*/      OPC_CheckType, MVT::i32,
/* 13563*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13565*/      OPC_EmitMergeInputChains1_0,
/* 13566*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13569*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13572*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 13579*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 13589*/    /*Scope*/ 54, /*->13644*/
/* 13590*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 13594*/      OPC_MoveChild0,
/* 13595*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 13598*/      OPC_RecordMemRef,
/* 13599*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 13600*/      OPC_CheckFoldableChainNode,
/* 13601*/      OPC_MoveChild1,
/* 13602*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13605*/      OPC_RecordChild0, // #1 = $off
/* 13606*/      OPC_MoveChild0,
/* 13607*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 13610*/      OPC_MoveParent,
/* 13611*/      OPC_MoveParent,
/* 13612*/      OPC_RecordChild2, // #2 = $val
/* 13613*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 13615*/      OPC_MoveParent,
/* 13616*/      OPC_CheckType, MVT::i32,
/* 13618*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13620*/      OPC_EmitMergeInputChains1_0,
/* 13621*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13624*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13627*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 13634*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 13644*/    /*Scope*/ 53, /*->13698*/
/* 13645*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 13648*/      OPC_MoveChild0,
/* 13649*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 13652*/      OPC_RecordMemRef,
/* 13653*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 13654*/      OPC_CheckFoldableChainNode,
/* 13655*/      OPC_MoveChild1,
/* 13656*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13659*/      OPC_RecordChild0, // #1 = $off
/* 13660*/      OPC_MoveChild0,
/* 13661*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 13664*/      OPC_MoveParent,
/* 13665*/      OPC_MoveParent,
/* 13666*/      OPC_RecordChild2, // #2 = $val
/* 13667*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 13669*/      OPC_MoveParent,
/* 13670*/      OPC_CheckType, MVT::i32,
/* 13672*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13674*/      OPC_EmitMergeInputChains1_0,
/* 13675*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13678*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13681*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 13688*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 13698*/    /*Scope*/ 54, /*->13753*/
/* 13699*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 13703*/      OPC_MoveChild0,
/* 13704*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 13707*/      OPC_RecordMemRef,
/* 13708*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 13709*/      OPC_CheckFoldableChainNode,
/* 13710*/      OPC_MoveChild1,
/* 13711*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13714*/      OPC_RecordChild0, // #1 = $off
/* 13715*/      OPC_MoveChild0,
/* 13716*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 13719*/      OPC_MoveParent,
/* 13720*/      OPC_MoveParent,
/* 13721*/      OPC_RecordChild2, // #2 = $val
/* 13722*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 13724*/      OPC_MoveParent,
/* 13725*/      OPC_CheckType, MVT::i32,
/* 13727*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13729*/      OPC_EmitMergeInputChains1_0,
/* 13730*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13733*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13736*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 13743*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 13753*/    /*Scope*/ 53, /*->13807*/
/* 13754*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 13757*/      OPC_MoveChild0,
/* 13758*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 13761*/      OPC_RecordMemRef,
/* 13762*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 13763*/      OPC_CheckFoldableChainNode,
/* 13764*/      OPC_MoveChild1,
/* 13765*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13768*/      OPC_RecordChild0, // #1 = $off
/* 13769*/      OPC_MoveChild0,
/* 13770*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 13773*/      OPC_MoveParent,
/* 13774*/      OPC_MoveParent,
/* 13775*/      OPC_RecordChild2, // #2 = $val
/* 13776*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 13778*/      OPC_MoveParent,
/* 13779*/      OPC_CheckType, MVT::i32,
/* 13781*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13783*/      OPC_EmitMergeInputChains1_0,
/* 13784*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13787*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13790*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 13797*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 13807*/    /*Scope*/ 54, /*->13862*/
/* 13808*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 13812*/      OPC_MoveChild0,
/* 13813*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 13816*/      OPC_RecordMemRef,
/* 13817*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 13818*/      OPC_CheckFoldableChainNode,
/* 13819*/      OPC_MoveChild1,
/* 13820*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13823*/      OPC_RecordChild0, // #1 = $off
/* 13824*/      OPC_MoveChild0,
/* 13825*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 13828*/      OPC_MoveParent,
/* 13829*/      OPC_MoveParent,
/* 13830*/      OPC_RecordChild2, // #2 = $val
/* 13831*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 13833*/      OPC_MoveParent,
/* 13834*/      OPC_CheckType, MVT::i32,
/* 13836*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13838*/      OPC_EmitMergeInputChains1_0,
/* 13839*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13842*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13845*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 13852*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 13862*/    /*Scope*/ 53, /*->13916*/
/* 13863*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 13866*/      OPC_MoveChild0,
/* 13867*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 13870*/      OPC_RecordMemRef,
/* 13871*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 13872*/      OPC_CheckFoldableChainNode,
/* 13873*/      OPC_MoveChild1,
/* 13874*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13877*/      OPC_RecordChild0, // #1 = $off
/* 13878*/      OPC_MoveChild0,
/* 13879*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 13882*/      OPC_MoveParent,
/* 13883*/      OPC_MoveParent,
/* 13884*/      OPC_RecordChild2, // #2 = $val
/* 13885*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 13887*/      OPC_MoveParent,
/* 13888*/      OPC_CheckType, MVT::i32,
/* 13890*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13892*/      OPC_EmitMergeInputChains1_0,
/* 13893*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13896*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13899*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 13906*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 13916*/    /*Scope*/ 54, /*->13971*/
/* 13917*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 13921*/      OPC_MoveChild0,
/* 13922*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 13925*/      OPC_RecordMemRef,
/* 13926*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 13927*/      OPC_CheckFoldableChainNode,
/* 13928*/      OPC_MoveChild1,
/* 13929*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13932*/      OPC_RecordChild0, // #1 = $off
/* 13933*/      OPC_MoveChild0,
/* 13934*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 13937*/      OPC_MoveParent,
/* 13938*/      OPC_MoveParent,
/* 13939*/      OPC_RecordChild2, // #2 = $val
/* 13940*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 13942*/      OPC_MoveParent,
/* 13943*/      OPC_CheckType, MVT::i32,
/* 13945*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 13947*/      OPC_EmitMergeInputChains1_0,
/* 13948*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13951*/      OPC_EmitInteger, MVT::i32, 0, 
/* 13954*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 13961*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 13971*/    /*Scope*/ 53, /*->14025*/
/* 13972*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 13975*/      OPC_MoveChild0,
/* 13976*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 13979*/      OPC_RecordMemRef,
/* 13980*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 13981*/      OPC_CheckFoldableChainNode,
/* 13982*/      OPC_MoveChild1,
/* 13983*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 13986*/      OPC_RecordChild0, // #1 = $off
/* 13987*/      OPC_MoveChild0,
/* 13988*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 13991*/      OPC_MoveParent,
/* 13992*/      OPC_MoveParent,
/* 13993*/      OPC_RecordChild2, // #2 = $val
/* 13994*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 13996*/      OPC_MoveParent,
/* 13997*/      OPC_CheckType, MVT::i32,
/* 13999*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14001*/      OPC_EmitMergeInputChains1_0,
/* 14002*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14005*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14008*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14015*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14025*/    /*Scope*/ 54, /*->14080*/
/* 14026*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 14030*/      OPC_MoveChild0,
/* 14031*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 14034*/      OPC_RecordMemRef,
/* 14035*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 14036*/      OPC_CheckFoldableChainNode,
/* 14037*/      OPC_MoveChild1,
/* 14038*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14041*/      OPC_RecordChild0, // #1 = $off
/* 14042*/      OPC_MoveChild0,
/* 14043*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 14046*/      OPC_MoveParent,
/* 14047*/      OPC_MoveParent,
/* 14048*/      OPC_RecordChild2, // #2 = $val
/* 14049*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 14051*/      OPC_MoveParent,
/* 14052*/      OPC_CheckType, MVT::i32,
/* 14054*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14056*/      OPC_EmitMergeInputChains1_0,
/* 14057*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14060*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14063*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14070*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14080*/    /*Scope*/ 53, /*->14134*/
/* 14081*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 14084*/      OPC_MoveChild0,
/* 14085*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 14088*/      OPC_RecordMemRef,
/* 14089*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 14090*/      OPC_CheckFoldableChainNode,
/* 14091*/      OPC_MoveChild1,
/* 14092*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14095*/      OPC_RecordChild0, // #1 = $off
/* 14096*/      OPC_MoveChild0,
/* 14097*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 14100*/      OPC_MoveParent,
/* 14101*/      OPC_MoveParent,
/* 14102*/      OPC_RecordChild2, // #2 = $val
/* 14103*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 14105*/      OPC_MoveParent,
/* 14106*/      OPC_CheckType, MVT::i32,
/* 14108*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14110*/      OPC_EmitMergeInputChains1_0,
/* 14111*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14114*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14117*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14124*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14134*/    /*Scope*/ 54, /*->14189*/
/* 14135*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 14139*/      OPC_MoveChild0,
/* 14140*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 14143*/      OPC_RecordMemRef,
/* 14144*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 14145*/      OPC_CheckFoldableChainNode,
/* 14146*/      OPC_MoveChild1,
/* 14147*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14150*/      OPC_RecordChild0, // #1 = $off
/* 14151*/      OPC_MoveChild0,
/* 14152*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 14155*/      OPC_MoveParent,
/* 14156*/      OPC_MoveParent,
/* 14157*/      OPC_RecordChild2, // #2 = $val
/* 14158*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 14160*/      OPC_MoveParent,
/* 14161*/      OPC_CheckType, MVT::i32,
/* 14163*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14165*/      OPC_EmitMergeInputChains1_0,
/* 14166*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14169*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14172*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14179*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14189*/    /*Scope*/ 53, /*->14243*/
/* 14190*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 14193*/      OPC_MoveChild0,
/* 14194*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 14197*/      OPC_RecordMemRef,
/* 14198*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 14199*/      OPC_CheckFoldableChainNode,
/* 14200*/      OPC_MoveChild1,
/* 14201*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14204*/      OPC_RecordChild0, // #1 = $off
/* 14205*/      OPC_MoveChild0,
/* 14206*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 14209*/      OPC_MoveParent,
/* 14210*/      OPC_MoveParent,
/* 14211*/      OPC_RecordChild2, // #2 = $val
/* 14212*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 14214*/      OPC_MoveParent,
/* 14215*/      OPC_CheckType, MVT::i32,
/* 14217*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14219*/      OPC_EmitMergeInputChains1_0,
/* 14220*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14223*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14226*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14233*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14243*/    /*Scope*/ 54, /*->14298*/
/* 14244*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 14248*/      OPC_MoveChild0,
/* 14249*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 14252*/      OPC_RecordMemRef,
/* 14253*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 14254*/      OPC_CheckFoldableChainNode,
/* 14255*/      OPC_MoveChild1,
/* 14256*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14259*/      OPC_RecordChild0, // #1 = $off
/* 14260*/      OPC_MoveChild0,
/* 14261*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 14264*/      OPC_MoveParent,
/* 14265*/      OPC_MoveParent,
/* 14266*/      OPC_RecordChild2, // #2 = $val
/* 14267*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 14269*/      OPC_MoveParent,
/* 14270*/      OPC_CheckType, MVT::i32,
/* 14272*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14274*/      OPC_EmitMergeInputChains1_0,
/* 14275*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14278*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14281*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14288*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14298*/    /*Scope*/ 53, /*->14352*/
/* 14299*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 14302*/      OPC_MoveChild0,
/* 14303*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 14306*/      OPC_RecordMemRef,
/* 14307*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 14308*/      OPC_CheckFoldableChainNode,
/* 14309*/      OPC_MoveChild1,
/* 14310*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14313*/      OPC_RecordChild0, // #1 = $off
/* 14314*/      OPC_MoveChild0,
/* 14315*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 14318*/      OPC_MoveParent,
/* 14319*/      OPC_MoveParent,
/* 14320*/      OPC_RecordChild2, // #2 = $val
/* 14321*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 14323*/      OPC_MoveParent,
/* 14324*/      OPC_CheckType, MVT::i32,
/* 14326*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14328*/      OPC_EmitMergeInputChains1_0,
/* 14329*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14332*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14335*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14342*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14352*/    /*Scope*/ 54, /*->14407*/
/* 14353*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 14357*/      OPC_MoveChild0,
/* 14358*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 14361*/      OPC_RecordMemRef,
/* 14362*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 14363*/      OPC_CheckFoldableChainNode,
/* 14364*/      OPC_MoveChild1,
/* 14365*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14368*/      OPC_RecordChild0, // #1 = $off
/* 14369*/      OPC_MoveChild0,
/* 14370*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 14373*/      OPC_MoveParent,
/* 14374*/      OPC_MoveParent,
/* 14375*/      OPC_RecordChild2, // #2 = $val
/* 14376*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 14378*/      OPC_MoveParent,
/* 14379*/      OPC_CheckType, MVT::i32,
/* 14381*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14383*/      OPC_EmitMergeInputChains1_0,
/* 14384*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14387*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14390*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14397*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14407*/    /*Scope*/ 53, /*->14461*/
/* 14408*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 14411*/      OPC_MoveChild0,
/* 14412*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 14415*/      OPC_RecordMemRef,
/* 14416*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 14417*/      OPC_CheckFoldableChainNode,
/* 14418*/      OPC_MoveChild1,
/* 14419*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14422*/      OPC_RecordChild0, // #1 = $off
/* 14423*/      OPC_MoveChild0,
/* 14424*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 14427*/      OPC_MoveParent,
/* 14428*/      OPC_MoveParent,
/* 14429*/      OPC_RecordChild2, // #2 = $val
/* 14430*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 14432*/      OPC_MoveParent,
/* 14433*/      OPC_CheckType, MVT::i32,
/* 14435*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14437*/      OPC_EmitMergeInputChains1_0,
/* 14438*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14441*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14444*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14451*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14461*/    /*Scope*/ 54, /*->14516*/
/* 14462*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 14466*/      OPC_MoveChild0,
/* 14467*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 14470*/      OPC_RecordMemRef,
/* 14471*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 14472*/      OPC_CheckFoldableChainNode,
/* 14473*/      OPC_MoveChild1,
/* 14474*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14477*/      OPC_RecordChild0, // #1 = $off
/* 14478*/      OPC_MoveChild0,
/* 14479*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 14482*/      OPC_MoveParent,
/* 14483*/      OPC_MoveParent,
/* 14484*/      OPC_RecordChild2, // #2 = $val
/* 14485*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 14487*/      OPC_MoveParent,
/* 14488*/      OPC_CheckType, MVT::i32,
/* 14490*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14492*/      OPC_EmitMergeInputChains1_0,
/* 14493*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14496*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14499*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14506*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14516*/    /*Scope*/ 53, /*->14570*/
/* 14517*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 14520*/      OPC_MoveChild0,
/* 14521*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 14524*/      OPC_RecordMemRef,
/* 14525*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 14526*/      OPC_CheckFoldableChainNode,
/* 14527*/      OPC_MoveChild1,
/* 14528*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14531*/      OPC_RecordChild0, // #1 = $off
/* 14532*/      OPC_MoveChild0,
/* 14533*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 14536*/      OPC_MoveParent,
/* 14537*/      OPC_MoveParent,
/* 14538*/      OPC_RecordChild2, // #2 = $val
/* 14539*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 14541*/      OPC_MoveParent,
/* 14542*/      OPC_CheckType, MVT::i32,
/* 14544*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14546*/      OPC_EmitMergeInputChains1_0,
/* 14547*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14550*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14553*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14560*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14570*/    /*Scope*/ 54, /*->14625*/
/* 14571*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 14575*/      OPC_MoveChild0,
/* 14576*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 14579*/      OPC_RecordMemRef,
/* 14580*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 14581*/      OPC_CheckFoldableChainNode,
/* 14582*/      OPC_MoveChild1,
/* 14583*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14586*/      OPC_RecordChild0, // #1 = $off
/* 14587*/      OPC_MoveChild0,
/* 14588*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 14591*/      OPC_MoveParent,
/* 14592*/      OPC_MoveParent,
/* 14593*/      OPC_RecordChild2, // #2 = $val
/* 14594*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 14596*/      OPC_MoveParent,
/* 14597*/      OPC_CheckType, MVT::i32,
/* 14599*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14601*/      OPC_EmitMergeInputChains1_0,
/* 14602*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14605*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14608*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14615*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14625*/    /*Scope*/ 53, /*->14679*/
/* 14626*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 14629*/      OPC_MoveChild0,
/* 14630*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 14633*/      OPC_RecordMemRef,
/* 14634*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 14635*/      OPC_CheckFoldableChainNode,
/* 14636*/      OPC_MoveChild1,
/* 14637*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14640*/      OPC_RecordChild0, // #1 = $off
/* 14641*/      OPC_MoveChild0,
/* 14642*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 14645*/      OPC_MoveParent,
/* 14646*/      OPC_MoveParent,
/* 14647*/      OPC_RecordChild2, // #2 = $val
/* 14648*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 14650*/      OPC_MoveParent,
/* 14651*/      OPC_CheckType, MVT::i32,
/* 14653*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14655*/      OPC_EmitMergeInputChains1_0,
/* 14656*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14659*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14662*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14669*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14679*/    /*Scope*/ 54, /*->14734*/
/* 14680*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 14684*/      OPC_MoveChild0,
/* 14685*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 14688*/      OPC_RecordMemRef,
/* 14689*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 14690*/      OPC_CheckFoldableChainNode,
/* 14691*/      OPC_MoveChild1,
/* 14692*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14695*/      OPC_RecordChild0, // #1 = $off
/* 14696*/      OPC_MoveChild0,
/* 14697*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 14700*/      OPC_MoveParent,
/* 14701*/      OPC_MoveParent,
/* 14702*/      OPC_RecordChild2, // #2 = $val
/* 14703*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 14705*/      OPC_MoveParent,
/* 14706*/      OPC_CheckType, MVT::i32,
/* 14708*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14710*/      OPC_EmitMergeInputChains1_0,
/* 14711*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14714*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14717*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 14724*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 14734*/    /*Scope*/ 55, /*->14790*/
/* 14735*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 14738*/      OPC_MoveChild0,
/* 14739*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 14742*/      OPC_RecordMemRef,
/* 14743*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 14744*/      OPC_CheckFoldableChainNode,
/* 14745*/      OPC_MoveChild1,
/* 14746*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14749*/      OPC_RecordChild0, // #1 = $off
/* 14750*/      OPC_MoveChild0,
/* 14751*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 14754*/      OPC_MoveParent,
/* 14755*/      OPC_MoveParent,
/* 14756*/      OPC_RecordChild2, // #2 = $exp
/* 14757*/      OPC_RecordChild3, // #3 = $new
/* 14758*/      OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 14760*/      OPC_MoveParent,
/* 14761*/      OPC_CheckType, MVT::i32,
/* 14763*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14765*/      OPC_EmitMergeInputChains1_0,
/* 14766*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14769*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14772*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 14779*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/* 14790*/    /*Scope*/ 56, /*->14847*/
/* 14791*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 14795*/      OPC_MoveChild0,
/* 14796*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 14799*/      OPC_RecordMemRef,
/* 14800*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 14801*/      OPC_CheckFoldableChainNode,
/* 14802*/      OPC_MoveChild1,
/* 14803*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14806*/      OPC_RecordChild0, // #1 = $off
/* 14807*/      OPC_MoveChild0,
/* 14808*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 14811*/      OPC_MoveParent,
/* 14812*/      OPC_MoveParent,
/* 14813*/      OPC_RecordChild2, // #2 = $exp
/* 14814*/      OPC_RecordChild3, // #3 = $new
/* 14815*/      OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 14817*/      OPC_MoveParent,
/* 14818*/      OPC_CheckType, MVT::i32,
/* 14820*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14822*/      OPC_EmitMergeInputChains1_0,
/* 14823*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14826*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14829*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 14836*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/* 14847*/    /*Scope*/ 55, /*->14903*/
/* 14848*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 14851*/      OPC_MoveChild0,
/* 14852*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 14855*/      OPC_RecordMemRef,
/* 14856*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 14857*/      OPC_CheckFoldableChainNode,
/* 14858*/      OPC_MoveChild1,
/* 14859*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14862*/      OPC_RecordChild0, // #1 = $off
/* 14863*/      OPC_MoveChild0,
/* 14864*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 14867*/      OPC_MoveParent,
/* 14868*/      OPC_MoveParent,
/* 14869*/      OPC_RecordChild2, // #2 = $exp
/* 14870*/      OPC_RecordChild3, // #3 = $new
/* 14871*/      OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 14873*/      OPC_MoveParent,
/* 14874*/      OPC_CheckType, MVT::i32,
/* 14876*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14878*/      OPC_EmitMergeInputChains1_0,
/* 14879*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14882*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14885*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 14892*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_8>>, 255:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW8_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/* 14903*/    /*Scope*/ 56, /*->14960*/
/* 14904*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 14908*/      OPC_MoveChild0,
/* 14909*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 14912*/      OPC_RecordMemRef,
/* 14913*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 14914*/      OPC_CheckFoldableChainNode,
/* 14915*/      OPC_MoveChild1,
/* 14916*/      OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 14919*/      OPC_RecordChild0, // #1 = $off
/* 14920*/      OPC_MoveChild0,
/* 14921*/      OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 14924*/      OPC_MoveParent,
/* 14925*/      OPC_MoveParent,
/* 14926*/      OPC_RecordChild2, // #2 = $exp
/* 14927*/      OPC_RecordChild3, // #3 = $new
/* 14928*/      OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 14930*/      OPC_MoveParent,
/* 14931*/      OPC_CheckType, MVT::i32,
/* 14933*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14935*/      OPC_EmitMergeInputChains1_0,
/* 14936*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14939*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14942*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 14949*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_16>>, 65535:{ *:[i32] }) - Complexity = 18
                // Dst: (ATOMIC_RMW16_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/* 14960*/    /*Scope*/ 39, /*->15000*/
/* 14961*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 14964*/      OPC_MoveChild0,
/* 14965*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 14968*/      OPC_MoveChild0,
/* 14969*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 14972*/      OPC_RecordMemRef,
/* 14973*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 14974*/      OPC_CheckFoldableChainNode,
/* 14975*/      OPC_RecordChild1, // #1 = $addr
/* 14976*/      OPC_CheckChild1Type, MVT::i32,
/* 14978*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 14980*/      OPC_MoveParent,
/* 14981*/      OPC_MoveParent,
/* 14982*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 14984*/      OPC_EmitMergeInputChains1_0,
/* 14985*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14988*/      OPC_EmitInteger, MVT::i32, 0, 
/* 14991*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 2, 3, 1, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } I32:{ *:[i32] }:$addr)<<P:Predicate_atomic_load_8>>), 255:{ *:[i64] }) - Complexity = 15
                // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr)
/* 15000*/    /*Scope*/ 40, /*->15041*/
/* 15001*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 15005*/      OPC_MoveChild0,
/* 15006*/      OPC_CheckOpcode, TARGET_VAL(ISD::ANY_EXTEND),
/* 15009*/      OPC_MoveChild0,
/* 15010*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 15013*/      OPC_RecordMemRef,
/* 15014*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 15015*/      OPC_CheckFoldableChainNode,
/* 15016*/      OPC_RecordChild1, // #1 = $addr
/* 15017*/      OPC_CheckChild1Type, MVT::i32,
/* 15019*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 15021*/      OPC_MoveParent,
/* 15022*/      OPC_MoveParent,
/* 15023*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15025*/      OPC_EmitMergeInputChains1_0,
/* 15026*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15029*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15032*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i64, 3/*#Ops*/, 2, 3, 1, 
                // Src: (and:{ *:[i64] } (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } I32:{ *:[i32] }:$addr)<<P:Predicate_atomic_load_16>>), 65535:{ *:[i64] }) - Complexity = 15
                // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr)
/* 15041*/    /*Scope*/ 35, /*->15077*/
/* 15042*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 15045*/      OPC_MoveChild0,
/* 15046*/      OPC_CheckOpcode, TARGET_VAL(ISD::EXTRACT_VECTOR_ELT),
/* 15049*/      OPC_RecordChild0, // #0 = $vec
/* 15050*/      OPC_CheckChild0Type, MVT::v16i8,
/* 15052*/      OPC_RecordChild1, // #1 = $idx
/* 15053*/      OPC_MoveChild1,
/* 15054*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15057*/      OPC_CheckPredicate, 5, // Predicate_LaneIdx16
/* 15059*/      OPC_CheckType, MVT::i32,
/* 15061*/      OPC_MoveParent,
/* 15062*/      OPC_MoveParent,
/* 15063*/      OPC_CheckType, MVT::i32,
/* 15065*/      OPC_CheckPatternPredicate, 1, // (Subtarget->hasSIMD128()) && (Subtarget->hasUnimplementedSIMD128())
/* 15067*/      OPC_EmitConvertToTarget, 1,
/* 15069*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::EXTRACT_LANE_v16i8_u), 0,
                    MVT::i32, 2/*#Ops*/, 0, 2, 
                // Src: (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v16i8] }:$vec, (imm:{ *:[i32] })<<P:Predicate_LaneIdx16>>:$idx), 255:{ *:[i32] }) - Complexity = 15
                // Dst: (EXTRACT_LANE_v16i8_u:{ *:[i32] } V128:{ *:[v16i8] }:$vec, (imm:{ *:[i32] }):$idx)
/* 15077*/    /*Scope*/ 36, /*->15114*/
/* 15078*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 15082*/      OPC_MoveChild0,
/* 15083*/      OPC_CheckOpcode, TARGET_VAL(ISD::EXTRACT_VECTOR_ELT),
/* 15086*/      OPC_RecordChild0, // #0 = $vec
/* 15087*/      OPC_CheckChild0Type, MVT::v8i16,
/* 15089*/      OPC_RecordChild1, // #1 = $idx
/* 15090*/      OPC_MoveChild1,
/* 15091*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15094*/      OPC_CheckPredicate, 6, // Predicate_LaneIdx8
/* 15096*/      OPC_CheckType, MVT::i32,
/* 15098*/      OPC_MoveParent,
/* 15099*/      OPC_MoveParent,
/* 15100*/      OPC_CheckType, MVT::i32,
/* 15102*/      OPC_CheckPatternPredicate, 1, // (Subtarget->hasSIMD128()) && (Subtarget->hasUnimplementedSIMD128())
/* 15104*/      OPC_EmitConvertToTarget, 1,
/* 15106*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::EXTRACT_LANE_v8i16_u), 0,
                    MVT::i32, 2/*#Ops*/, 0, 2, 
                // Src: (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v8i16] }:$vec, (imm:{ *:[i32] })<<P:Predicate_LaneIdx8>>:$idx), 65535:{ *:[i32] }) - Complexity = 15
                // Dst: (EXTRACT_LANE_v8i16_u:{ *:[i32] } V128:{ *:[v8i16] }:$vec, (imm:{ *:[i32] }):$idx)
/* 15114*/    /*Scope*/ 48, /*->15163*/
/* 15115*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 15118*/      OPC_MoveChild0,
/* 15119*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 15122*/      OPC_RecordMemRef,
/* 15123*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 15124*/      OPC_CheckFoldableChainNode,
/* 15125*/      OPC_RecordChild1, // #1 = $off
/* 15126*/      OPC_MoveChild1,
/* 15127*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15130*/      OPC_MoveParent,
/* 15131*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 15133*/      OPC_MoveParent,
/* 15134*/      OPC_CheckType, MVT::i32,
/* 15136*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15138*/      OPC_EmitMergeInputChains1_0,
/* 15139*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15142*/      OPC_EmitConvertToTarget, 1,
/* 15144*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15147*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 15154*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 2, 3, 5, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (imm:{ *:[iPTR] }):$off)<<P:Predicate_atomic_load_8>>, 255:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_LOAD8_U_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 15163*/    /*Scope*/ 49, /*->15213*/
/* 15164*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 15168*/      OPC_MoveChild0,
/* 15169*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 15172*/      OPC_RecordMemRef,
/* 15173*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 15174*/      OPC_CheckFoldableChainNode,
/* 15175*/      OPC_RecordChild1, // #1 = $off
/* 15176*/      OPC_MoveChild1,
/* 15177*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15180*/      OPC_MoveParent,
/* 15181*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 15183*/      OPC_MoveParent,
/* 15184*/      OPC_CheckType, MVT::i32,
/* 15186*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15188*/      OPC_EmitMergeInputChains1_0,
/* 15189*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15192*/      OPC_EmitConvertToTarget, 1,
/* 15194*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15197*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 15204*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 2, 3, 5, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } (imm:{ *:[iPTR] }):$off)<<P:Predicate_atomic_load_16>>, 65535:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_LOAD16_U_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 15213*/    /*Scope*/ 50, /*->15264*/
/* 15214*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 15217*/      OPC_MoveChild0,
/* 15218*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 15221*/      OPC_RecordMemRef,
/* 15222*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 15223*/      OPC_CheckFoldableChainNode,
/* 15224*/      OPC_RecordChild1, // #1 = $off
/* 15225*/      OPC_MoveChild1,
/* 15226*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15229*/      OPC_MoveParent,
/* 15230*/      OPC_RecordChild2, // #2 = $val
/* 15231*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 15233*/      OPC_MoveParent,
/* 15234*/      OPC_CheckType, MVT::i32,
/* 15236*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15238*/      OPC_EmitMergeInputChains1_0,
/* 15239*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15242*/      OPC_EmitConvertToTarget, 1,
/* 15244*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15247*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 15254*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_8>>, 255:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW8_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 15264*/    /*Scope*/ 51, /*->15316*/
/* 15265*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 15269*/      OPC_MoveChild0,
/* 15270*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 15273*/      OPC_RecordMemRef,
/* 15274*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 15275*/      OPC_CheckFoldableChainNode,
/* 15276*/      OPC_RecordChild1, // #1 = $off
/* 15277*/      OPC_MoveChild1,
/* 15278*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15281*/      OPC_MoveParent,
/* 15282*/      OPC_RecordChild2, // #2 = $val
/* 15283*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 15285*/      OPC_MoveParent,
/* 15286*/      OPC_CheckType, MVT::i32,
/* 15288*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15290*/      OPC_EmitMergeInputChains1_0,
/* 15291*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15294*/      OPC_EmitConvertToTarget, 1,
/* 15296*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15299*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 15306*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_16>>, 65535:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW16_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 15316*/    /*Scope*/ 50, /*->15367*/
/* 15317*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 15320*/      OPC_MoveChild0,
/* 15321*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 15324*/      OPC_RecordMemRef,
/* 15325*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 15326*/      OPC_CheckFoldableChainNode,
/* 15327*/      OPC_RecordChild1, // #1 = $off
/* 15328*/      OPC_MoveChild1,
/* 15329*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15332*/      OPC_MoveParent,
/* 15333*/      OPC_RecordChild2, // #2 = $val
/* 15334*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 15336*/      OPC_MoveParent,
/* 15337*/      OPC_CheckType, MVT::i32,
/* 15339*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15341*/      OPC_EmitMergeInputChains1_0,
/* 15342*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15345*/      OPC_EmitConvertToTarget, 1,
/* 15347*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15350*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 15357*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_8>>, 255:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW8_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 15367*/    /*Scope*/ 51, /*->15419*/
/* 15368*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 15372*/      OPC_MoveChild0,
/* 15373*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 15376*/      OPC_RecordMemRef,
/* 15377*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 15378*/      OPC_CheckFoldableChainNode,
/* 15379*/      OPC_RecordChild1, // #1 = $off
/* 15380*/      OPC_MoveChild1,
/* 15381*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15384*/      OPC_MoveParent,
/* 15385*/      OPC_RecordChild2, // #2 = $val
/* 15386*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 15388*/      OPC_MoveParent,
/* 15389*/      OPC_CheckType, MVT::i32,
/* 15391*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15393*/      OPC_EmitMergeInputChains1_0,
/* 15394*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15397*/      OPC_EmitConvertToTarget, 1,
/* 15399*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15402*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 15409*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_16>>, 65535:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW16_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 15419*/    /*Scope*/ 50, /*->15470*/
/* 15420*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 15423*/      OPC_MoveChild0,
/* 15424*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 15427*/      OPC_RecordMemRef,
/* 15428*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 15429*/      OPC_CheckFoldableChainNode,
/* 15430*/      OPC_RecordChild1, // #1 = $off
/* 15431*/      OPC_MoveChild1,
/* 15432*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15435*/      OPC_MoveParent,
/* 15436*/      OPC_RecordChild2, // #2 = $val
/* 15437*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 15439*/      OPC_MoveParent,
/* 15440*/      OPC_CheckType, MVT::i32,
/* 15442*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15444*/      OPC_EmitMergeInputChains1_0,
/* 15445*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15448*/      OPC_EmitConvertToTarget, 1,
/* 15450*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15453*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 15460*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_8>>, 255:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW8_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 15470*/    /*Scope*/ 51, /*->15522*/
/* 15471*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 15475*/      OPC_MoveChild0,
/* 15476*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 15479*/      OPC_RecordMemRef,
/* 15480*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 15481*/      OPC_CheckFoldableChainNode,
/* 15482*/      OPC_RecordChild1, // #1 = $off
/* 15483*/      OPC_MoveChild1,
/* 15484*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15487*/      OPC_MoveParent,
/* 15488*/      OPC_RecordChild2, // #2 = $val
/* 15489*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 15491*/      OPC_MoveParent,
/* 15492*/      OPC_CheckType, MVT::i32,
/* 15494*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15496*/      OPC_EmitMergeInputChains1_0,
/* 15497*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15500*/      OPC_EmitConvertToTarget, 1,
/* 15502*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15505*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 15512*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_16>>, 65535:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW16_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 15522*/    /*Scope*/ 50, /*->15573*/
/* 15523*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 15526*/      OPC_MoveChild0,
/* 15527*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 15530*/      OPC_RecordMemRef,
/* 15531*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 15532*/      OPC_CheckFoldableChainNode,
/* 15533*/      OPC_RecordChild1, // #1 = $off
/* 15534*/      OPC_MoveChild1,
/* 15535*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15538*/      OPC_MoveParent,
/* 15539*/      OPC_RecordChild2, // #2 = $val
/* 15540*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 15542*/      OPC_MoveParent,
/* 15543*/      OPC_CheckType, MVT::i32,
/* 15545*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15547*/      OPC_EmitMergeInputChains1_0,
/* 15548*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15551*/      OPC_EmitConvertToTarget, 1,
/* 15553*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15556*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 15563*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_8>>, 255:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW8_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 15573*/    /*Scope*/ 51, /*->15625*/
/* 15574*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 15578*/      OPC_MoveChild0,
/* 15579*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 15582*/      OPC_RecordMemRef,
/* 15583*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 15584*/      OPC_CheckFoldableChainNode,
/* 15585*/      OPC_RecordChild1, // #1 = $off
/* 15586*/      OPC_MoveChild1,
/* 15587*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15590*/      OPC_MoveParent,
/* 15591*/      OPC_RecordChild2, // #2 = $val
/* 15592*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 15594*/      OPC_MoveParent,
/* 15595*/      OPC_CheckType, MVT::i32,
/* 15597*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15599*/      OPC_EmitMergeInputChains1_0,
/* 15600*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15603*/      OPC_EmitConvertToTarget, 1,
/* 15605*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15608*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 15615*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_16>>, 65535:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW16_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 15625*/    /*Scope*/ 50, /*->15676*/
/* 15626*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 15629*/      OPC_MoveChild0,
/* 15630*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 15633*/      OPC_RecordMemRef,
/* 15634*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 15635*/      OPC_CheckFoldableChainNode,
/* 15636*/      OPC_RecordChild1, // #1 = $off
/* 15637*/      OPC_MoveChild1,
/* 15638*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15641*/      OPC_MoveParent,
/* 15642*/      OPC_RecordChild2, // #2 = $val
/* 15643*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 15645*/      OPC_MoveParent,
/* 15646*/      OPC_CheckType, MVT::i32,
/* 15648*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15650*/      OPC_EmitMergeInputChains1_0,
/* 15651*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15654*/      OPC_EmitConvertToTarget, 1,
/* 15656*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15659*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 15666*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_8>>, 255:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW8_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 15676*/    /*Scope*/ 51, /*->15728*/
/* 15677*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 15681*/      OPC_MoveChild0,
/* 15682*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 15685*/      OPC_RecordMemRef,
/* 15686*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 15687*/      OPC_CheckFoldableChainNode,
/* 15688*/      OPC_RecordChild1, // #1 = $off
/* 15689*/      OPC_MoveChild1,
/* 15690*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15693*/      OPC_MoveParent,
/* 15694*/      OPC_RecordChild2, // #2 = $val
/* 15695*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 15697*/      OPC_MoveParent,
/* 15698*/      OPC_CheckType, MVT::i32,
/* 15700*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15702*/      OPC_EmitMergeInputChains1_0,
/* 15703*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15706*/      OPC_EmitConvertToTarget, 1,
/* 15708*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15711*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 15718*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_16>>, 65535:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW16_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 15728*/    /*Scope*/ 50, /*->15779*/
/* 15729*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 15732*/      OPC_MoveChild0,
/* 15733*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 15736*/      OPC_RecordMemRef,
/* 15737*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 15738*/      OPC_CheckFoldableChainNode,
/* 15739*/      OPC_RecordChild1, // #1 = $off
/* 15740*/      OPC_MoveChild1,
/* 15741*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15744*/      OPC_MoveParent,
/* 15745*/      OPC_RecordChild2, // #2 = $val
/* 15746*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 15748*/      OPC_MoveParent,
/* 15749*/      OPC_CheckType, MVT::i32,
/* 15751*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15753*/      OPC_EmitMergeInputChains1_0,
/* 15754*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15757*/      OPC_EmitConvertToTarget, 1,
/* 15759*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15762*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 15769*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_8>>, 255:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW8_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 15779*/    /*Scope*/ 51, /*->15831*/
/* 15780*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 15784*/      OPC_MoveChild0,
/* 15785*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 15788*/      OPC_RecordMemRef,
/* 15789*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 15790*/      OPC_CheckFoldableChainNode,
/* 15791*/      OPC_RecordChild1, // #1 = $off
/* 15792*/      OPC_MoveChild1,
/* 15793*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15796*/      OPC_MoveParent,
/* 15797*/      OPC_RecordChild2, // #2 = $val
/* 15798*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 15800*/      OPC_MoveParent,
/* 15801*/      OPC_CheckType, MVT::i32,
/* 15803*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15805*/      OPC_EmitMergeInputChains1_0,
/* 15806*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15809*/      OPC_EmitConvertToTarget, 1,
/* 15811*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15814*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 15821*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 6, 2, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_16>>, 65535:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW16_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$val)
/* 15831*/    /*Scope*/ 52, /*->15884*/
/* 15832*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 15835*/      OPC_MoveChild0,
/* 15836*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 15839*/      OPC_RecordMemRef,
/* 15840*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 15841*/      OPC_CheckFoldableChainNode,
/* 15842*/      OPC_RecordChild1, // #1 = $off
/* 15843*/      OPC_MoveChild1,
/* 15844*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15847*/      OPC_MoveParent,
/* 15848*/      OPC_RecordChild2, // #2 = $exp
/* 15849*/      OPC_RecordChild3, // #3 = $new
/* 15850*/      OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 15852*/      OPC_MoveParent,
/* 15853*/      OPC_CheckType, MVT::i32,
/* 15855*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15857*/      OPC_EmitMergeInputChains1_0,
/* 15858*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15861*/      OPC_EmitConvertToTarget, 1,
/* 15863*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15866*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 6,  // Results = #7
/* 15873*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 4, 5, 7, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_8>>, 255:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW8_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/* 15884*/    /*Scope*/ 53, /*->15938*/
/* 15885*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 15889*/      OPC_MoveChild0,
/* 15890*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 15893*/      OPC_RecordMemRef,
/* 15894*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 15895*/      OPC_CheckFoldableChainNode,
/* 15896*/      OPC_RecordChild1, // #1 = $off
/* 15897*/      OPC_MoveChild1,
/* 15898*/      OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 15901*/      OPC_MoveParent,
/* 15902*/      OPC_RecordChild2, // #2 = $exp
/* 15903*/      OPC_RecordChild3, // #3 = $new
/* 15904*/      OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 15906*/      OPC_MoveParent,
/* 15907*/      OPC_CheckType, MVT::i32,
/* 15909*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 15911*/      OPC_EmitMergeInputChains1_0,
/* 15912*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15915*/      OPC_EmitConvertToTarget, 1,
/* 15917*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15920*/      OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                    MVT::i32, 1/*#Ops*/, 6,  // Results = #7
/* 15927*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 4, 5, 7, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_16>>, 65535:{ *:[i32] }) - Complexity = 15
                // Dst: (ATOMIC_RMW16_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/* 15938*/    /*Scope*/ 29, /*->15968*/
/* 15939*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 15942*/      OPC_MoveChild0,
/* 15943*/      OPC_CheckOpcode, TARGET_VAL(ISD::EXTRACT_VECTOR_ELT),
/* 15946*/      OPC_RecordChild0, // #0 = $vec
/* 15947*/      OPC_CheckChild0Type, MVT::v16i8,
/* 15949*/      OPC_MoveChild1,
/* 15950*/      OPC_CheckOpcode, TARGET_VAL(ISD::UNDEF),
/* 15953*/      OPC_MoveParent,
/* 15954*/      OPC_MoveParent,
/* 15955*/      OPC_CheckType, MVT::i32,
/* 15957*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15960*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::EXTRACT_LANE_v16i8_u), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v16i8] }:$vec, (undef:{ *:[iPTR] })), 255:{ *:[i32] }) - Complexity = 14
                // Dst: (EXTRACT_LANE_v16i8_u:{ *:[i32] } V128:{ *:[v16i8] }:$vec, 0:{ *:[i32] })
/* 15968*/    /*Scope*/ 30, /*->15999*/
/* 15969*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 15973*/      OPC_MoveChild0,
/* 15974*/      OPC_CheckOpcode, TARGET_VAL(ISD::EXTRACT_VECTOR_ELT),
/* 15977*/      OPC_RecordChild0, // #0 = $vec
/* 15978*/      OPC_CheckChild0Type, MVT::v8i16,
/* 15980*/      OPC_MoveChild1,
/* 15981*/      OPC_CheckOpcode, TARGET_VAL(ISD::UNDEF),
/* 15984*/      OPC_MoveParent,
/* 15985*/      OPC_MoveParent,
/* 15986*/      OPC_CheckType, MVT::i32,
/* 15988*/      OPC_EmitInteger, MVT::i32, 0, 
/* 15991*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::EXTRACT_LANE_v8i16_u), 0,
                    MVT::i32, 2/*#Ops*/, 0, 1, 
                // Src: (and:{ *:[i32] } (vector_extract:{ *:[i32] } V128:{ *:[v8i16] }:$vec, (undef:{ *:[iPTR] })), 65535:{ *:[i32] }) - Complexity = 14
                // Dst: (EXTRACT_LANE_v8i16_u:{ *:[i32] } V128:{ *:[v8i16] }:$vec, 0:{ *:[i32] })
/* 15999*/    /*Scope*/ 36, /*->16036*/
/* 16000*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 16003*/      OPC_MoveChild0,
/* 16004*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 16007*/      OPC_RecordMemRef,
/* 16008*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 16009*/      OPC_CheckFoldableChainNode,
/* 16010*/      OPC_RecordChild1, // #1 = $addr
/* 16011*/      OPC_CheckChild1Type, MVT::i32,
/* 16013*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 16015*/      OPC_MoveParent,
/* 16016*/      OPC_CheckType, MVT::i32,
/* 16018*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16020*/      OPC_EmitMergeInputChains1_0,
/* 16021*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16024*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16027*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 2, 3, 1, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } I32:{ *:[i32] }:$addr)<<P:Predicate_atomic_load_8>>, 255:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_LOAD8_U_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr)
/* 16036*/    /*Scope*/ 37, /*->16074*/
/* 16037*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 16041*/      OPC_MoveChild0,
/* 16042*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD),
/* 16045*/      OPC_RecordMemRef,
/* 16046*/      OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 16047*/      OPC_CheckFoldableChainNode,
/* 16048*/      OPC_RecordChild1, // #1 = $addr
/* 16049*/      OPC_CheckChild1Type, MVT::i32,
/* 16051*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 16053*/      OPC_MoveParent,
/* 16054*/      OPC_CheckType, MVT::i32,
/* 16056*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16058*/      OPC_EmitMergeInputChains1_0,
/* 16059*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16062*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16065*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 3/*#Ops*/, 2, 3, 1, 
                // Src: (and:{ *:[i32] } (atomic_load:{ *:[i32] } I32:{ *:[i32] }:$addr)<<P:Predicate_atomic_load_16>>, 65535:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_LOAD16_U_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr)
/* 16074*/    /*Scope*/ 38, /*->16113*/
/* 16075*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 16078*/      OPC_MoveChild0,
/* 16079*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 16082*/      OPC_RecordMemRef,
/* 16083*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 16084*/      OPC_CheckFoldableChainNode,
/* 16085*/      OPC_RecordChild1, // #1 = $addr
/* 16086*/      OPC_CheckChild1Type, MVT::i32,
/* 16088*/      OPC_RecordChild2, // #2 = $val
/* 16089*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 16091*/      OPC_MoveParent,
/* 16092*/      OPC_CheckType, MVT::i32,
/* 16094*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16096*/      OPC_EmitMergeInputChains1_0,
/* 16097*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16100*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16103*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_8>>, 255:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW8_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 16113*/    /*Scope*/ 39, /*->16153*/
/* 16114*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 16118*/      OPC_MoveChild0,
/* 16119*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),
/* 16122*/      OPC_RecordMemRef,
/* 16123*/      OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 16124*/      OPC_CheckFoldableChainNode,
/* 16125*/      OPC_RecordChild1, // #1 = $addr
/* 16126*/      OPC_CheckChild1Type, MVT::i32,
/* 16128*/      OPC_RecordChild2, // #2 = $val
/* 16129*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 16131*/      OPC_MoveParent,
/* 16132*/      OPC_CheckType, MVT::i32,
/* 16134*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16136*/      OPC_EmitMergeInputChains1_0,
/* 16137*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16140*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16143*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_add:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_add_16>>, 65535:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW16_U_ADD_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 16153*/    /*Scope*/ 38, /*->16192*/
/* 16154*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 16157*/      OPC_MoveChild0,
/* 16158*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 16161*/      OPC_RecordMemRef,
/* 16162*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 16163*/      OPC_CheckFoldableChainNode,
/* 16164*/      OPC_RecordChild1, // #1 = $addr
/* 16165*/      OPC_CheckChild1Type, MVT::i32,
/* 16167*/      OPC_RecordChild2, // #2 = $val
/* 16168*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 16170*/      OPC_MoveParent,
/* 16171*/      OPC_CheckType, MVT::i32,
/* 16173*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16175*/      OPC_EmitMergeInputChains1_0,
/* 16176*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16179*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16182*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_8>>, 255:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW8_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 16192*/    /*Scope*/ 39, /*->16232*/
/* 16193*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 16197*/      OPC_MoveChild0,
/* 16198*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),
/* 16201*/      OPC_RecordMemRef,
/* 16202*/      OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 16203*/      OPC_CheckFoldableChainNode,
/* 16204*/      OPC_RecordChild1, // #1 = $addr
/* 16205*/      OPC_CheckChild1Type, MVT::i32,
/* 16207*/      OPC_RecordChild2, // #2 = $val
/* 16208*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 16210*/      OPC_MoveParent,
/* 16211*/      OPC_CheckType, MVT::i32,
/* 16213*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16215*/      OPC_EmitMergeInputChains1_0,
/* 16216*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16219*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16222*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_sub:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_sub_16>>, 65535:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW16_U_SUB_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 16232*/    /*Scope*/ 38, /*->16271*/
/* 16233*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 16236*/      OPC_MoveChild0,
/* 16237*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 16240*/      OPC_RecordMemRef,
/* 16241*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 16242*/      OPC_CheckFoldableChainNode,
/* 16243*/      OPC_RecordChild1, // #1 = $addr
/* 16244*/      OPC_CheckChild1Type, MVT::i32,
/* 16246*/      OPC_RecordChild2, // #2 = $val
/* 16247*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 16249*/      OPC_MoveParent,
/* 16250*/      OPC_CheckType, MVT::i32,
/* 16252*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16254*/      OPC_EmitMergeInputChains1_0,
/* 16255*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16258*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16261*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_8>>, 255:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW8_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 16271*/    /*Scope*/ 39, /*->16311*/
/* 16272*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 16276*/      OPC_MoveChild0,
/* 16277*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_AND),
/* 16280*/      OPC_RecordMemRef,
/* 16281*/      OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 16282*/      OPC_CheckFoldableChainNode,
/* 16283*/      OPC_RecordChild1, // #1 = $addr
/* 16284*/      OPC_CheckChild1Type, MVT::i32,
/* 16286*/      OPC_RecordChild2, // #2 = $val
/* 16287*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 16289*/      OPC_MoveParent,
/* 16290*/      OPC_CheckType, MVT::i32,
/* 16292*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16294*/      OPC_EmitMergeInputChains1_0,
/* 16295*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16298*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16301*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_and:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_and_16>>, 65535:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW16_U_AND_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 16311*/    /*Scope*/ 38, /*->16350*/
/* 16312*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 16315*/      OPC_MoveChild0,
/* 16316*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 16319*/      OPC_RecordMemRef,
/* 16320*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 16321*/      OPC_CheckFoldableChainNode,
/* 16322*/      OPC_RecordChild1, // #1 = $addr
/* 16323*/      OPC_CheckChild1Type, MVT::i32,
/* 16325*/      OPC_RecordChild2, // #2 = $val
/* 16326*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 16328*/      OPC_MoveParent,
/* 16329*/      OPC_CheckType, MVT::i32,
/* 16331*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16333*/      OPC_EmitMergeInputChains1_0,
/* 16334*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16337*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16340*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_8>>, 255:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW8_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 16350*/    /*Scope*/ 39, /*->16390*/
/* 16351*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 16355*/      OPC_MoveChild0,
/* 16356*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_OR),
/* 16359*/      OPC_RecordMemRef,
/* 16360*/      OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 16361*/      OPC_CheckFoldableChainNode,
/* 16362*/      OPC_RecordChild1, // #1 = $addr
/* 16363*/      OPC_CheckChild1Type, MVT::i32,
/* 16365*/      OPC_RecordChild2, // #2 = $val
/* 16366*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 16368*/      OPC_MoveParent,
/* 16369*/      OPC_CheckType, MVT::i32,
/* 16371*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16373*/      OPC_EmitMergeInputChains1_0,
/* 16374*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16377*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16380*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_or:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_or_16>>, 65535:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW16_U_OR_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 16390*/    /*Scope*/ 38, /*->16429*/
/* 16391*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 16394*/      OPC_MoveChild0,
/* 16395*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 16398*/      OPC_RecordMemRef,
/* 16399*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 16400*/      OPC_CheckFoldableChainNode,
/* 16401*/      OPC_RecordChild1, // #1 = $addr
/* 16402*/      OPC_CheckChild1Type, MVT::i32,
/* 16404*/      OPC_RecordChild2, // #2 = $val
/* 16405*/      OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 16407*/      OPC_MoveParent,
/* 16408*/      OPC_CheckType, MVT::i32,
/* 16410*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16412*/      OPC_EmitMergeInputChains1_0,
/* 16413*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16416*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16419*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_8>>, 255:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW8_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 16429*/    /*Scope*/ 39, /*->16469*/
/* 16430*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 16434*/      OPC_MoveChild0,
/* 16435*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),
/* 16438*/      OPC_RecordMemRef,
/* 16439*/      OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 16440*/      OPC_CheckFoldableChainNode,
/* 16441*/      OPC_RecordChild1, // #1 = $addr
/* 16442*/      OPC_CheckChild1Type, MVT::i32,
/* 16444*/      OPC_RecordChild2, // #2 = $val
/* 16445*/      OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 16447*/      OPC_MoveParent,
/* 16448*/      OPC_CheckType, MVT::i32,
/* 16450*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16452*/      OPC_EmitMergeInputChains1_0,
/* 16453*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16456*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16459*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_load_xor:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_load_xor_16>>, 65535:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW16_U_XOR_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 16469*/    /*Scope*/ 38, /*->16508*/
/* 16470*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 16473*/      OPC_MoveChild0,
/* 16474*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 16477*/      OPC_RecordMemRef,
/* 16478*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 16479*/      OPC_CheckFoldableChainNode,
/* 16480*/      OPC_RecordChild1, // #1 = $addr
/* 16481*/      OPC_CheckChild1Type, MVT::i32,
/* 16483*/      OPC_RecordChild2, // #2 = $val
/* 16484*/      OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 16486*/      OPC_MoveParent,
/* 16487*/      OPC_CheckType, MVT::i32,
/* 16489*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16491*/      OPC_EmitMergeInputChains1_0,
/* 16492*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16495*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16498*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_8>>, 255:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW8_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 16508*/    /*Scope*/ 39, /*->16548*/
/* 16509*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 16513*/      OPC_MoveChild0,
/* 16514*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_SWAP),
/* 16517*/      OPC_RecordMemRef,
/* 16518*/      OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 16519*/      OPC_CheckFoldableChainNode,
/* 16520*/      OPC_RecordChild1, // #1 = $addr
/* 16521*/      OPC_CheckChild1Type, MVT::i32,
/* 16523*/      OPC_RecordChild2, // #2 = $val
/* 16524*/      OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 16526*/      OPC_MoveParent,
/* 16527*/      OPC_CheckType, MVT::i32,
/* 16529*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16531*/      OPC_EmitMergeInputChains1_0,
/* 16532*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16535*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16538*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 4/*#Ops*/, 3, 4, 1, 2, 
                // Src: (and:{ *:[i32] } (atomic_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)<<P:Predicate_atomic_swap_16>>, 65535:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW16_U_XCHG_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$val)
/* 16548*/    /*Scope*/ 40, /*->16589*/
/* 16549*/      OPC_CheckAndImm, 127|128,1/*255*/, 
/* 16552*/      OPC_MoveChild0,
/* 16553*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 16556*/      OPC_RecordMemRef,
/* 16557*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 16558*/      OPC_CheckFoldableChainNode,
/* 16559*/      OPC_RecordChild1, // #1 = $addr
/* 16560*/      OPC_CheckChild1Type, MVT::i32,
/* 16562*/      OPC_RecordChild2, // #2 = $exp
/* 16563*/      OPC_RecordChild3, // #3 = $new
/* 16564*/      OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 16566*/      OPC_MoveParent,
/* 16567*/      OPC_CheckType, MVT::i32,
/* 16569*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16571*/      OPC_EmitMergeInputChains1_0,
/* 16572*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16575*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16578*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 4, 5, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_8>>, 255:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW8_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/* 16589*/    /*Scope*/ 41, /*->16631*/
/* 16590*/      OPC_CheckAndImm, 127|128,127|128,3/*65535*/, 
/* 16594*/      OPC_MoveChild0,
/* 16595*/      OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 16598*/      OPC_RecordMemRef,
/* 16599*/      OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 16600*/      OPC_CheckFoldableChainNode,
/* 16601*/      OPC_RecordChild1, // #1 = $addr
/* 16602*/      OPC_CheckChild1Type, MVT::i32,
/* 16604*/      OPC_RecordChild2, // #2 = $exp
/* 16605*/      OPC_RecordChild3, // #3 = $new
/* 16606*/      OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 16608*/      OPC_MoveParent,
/* 16609*/      OPC_CheckType, MVT::i32,
/* 16611*/      OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16613*/      OPC_EmitMergeInputChains1_0,
/* 16614*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16617*/      OPC_EmitInteger, MVT::i32, 0, 
/* 16620*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I32), 0|OPFL_Chain|OPFL_MemRefs,
                    MVT::i32, 5/*#Ops*/, 4, 5, 1, 2, 3, 
                // Src: (and:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)<<P:Predicate_atomic_cmp_swap_16>>, 65535:{ *:[i32] }) - Complexity = 12
                // Dst: (ATOMIC_RMW16_U_CMPXCHG_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, i32:{ *:[i32] }:$new)
/* 16631*/    /*Scope*/ 72, /*->16704*/
/* 16632*/      OPC_RecordChild0, // #0 = $lhs
/* 16633*/      OPC_RecordChild1, // #1 = $rhs
/* 16634*/      OPC_SwitchType /*6 cases */, 8, MVT::i32,// ->16645
/* 16637*/        OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::AND_I32), 0,
                      MVT::i32, 2/*#Ops*/, 0, 1, 
                  // Src: (and:{ *:[i32] } I32:{ *:[i32] }:$lhs, I32:{ *:[i32] }:$rhs) - Complexity = 3
                  // Dst: (AND_I32:{ *:[i32] } I32:{ *:[i32] }:$lhs, I32:{ *:[i32] }:$rhs)
/* 16645*/      /*SwitchType*/ 8, MVT::i64,// ->16655
/* 16647*/        OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::AND_I64), 0,
                      MVT::i64, 2/*#Ops*/, 0, 1, 
                  // Src: (and:{ *:[i64] } I64:{ *:[i64] }:$lhs, I64:{ *:[i64] }:$rhs) - Complexity = 3
                  // Dst: (AND_I64:{ *:[i64] } I64:{ *:[i64] }:$lhs, I64:{ *:[i64] }:$rhs)
/* 16655*/      /*SwitchType*/ 10, MVT::v16i8,// ->16667
/* 16657*/        OPC_CheckPatternPredicate, 2, // (Subtarget->hasSIMD128())
/* 16659*/        OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::AND_v16i8), 0,
                      MVT::v16i8, 2/*#Ops*/, 0, 1, 
                  // Src: (and:{ *:[v16i8] } V128:{ *:[v16i8] }:$lhs, V128:{ *:[v16i8] }:$rhs) - Complexity = 3
                  // Dst: (AND_v16i8:{ *:[v16i8] } V128:{ *:[v16i8] }:$lhs, V128:{ *:[v16i8] }:$rhs)
/* 16667*/      /*SwitchType*/ 10, MVT::v8i16,// ->16679
/* 16669*/        OPC_CheckPatternPredicate, 2, // (Subtarget->hasSIMD128())
/* 16671*/        OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::AND_v8i16), 0,
                      MVT::v8i16, 2/*#Ops*/, 0, 1, 
                  // Src: (and:{ *:[v8i16] } V128:{ *:[v8i16] }:$lhs, V128:{ *:[v8i16] }:$rhs) - Complexity = 3
                  // Dst: (AND_v8i16:{ *:[v8i16] } V128:{ *:[v8i16] }:$lhs, V128:{ *:[v8i16] }:$rhs)
/* 16679*/      /*SwitchType*/ 10, MVT::v4i32,// ->16691
/* 16681*/        OPC_CheckPatternPredicate, 2, // (Subtarget->hasSIMD128())
/* 16683*/        OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::AND_v4i32), 0,
                      MVT::v4i32, 2/*#Ops*/, 0, 1, 
                  // Src: (and:{ *:[v4i32] } V128:{ *:[v4i32] }:$lhs, V128:{ *:[v4i32] }:$rhs) - Complexity = 3
                  // Dst: (AND_v4i32:{ *:[v4i32] } V128:{ *:[v4i32] }:$lhs, V128:{ *:[v4i32] }:$rhs)
/* 16691*/      /*SwitchType*/ 10, MVT::v2i64,// ->16703
/* 16693*/        OPC_CheckPatternPredicate, 2, // (Subtarget->hasSIMD128())
/* 16695*/        OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::AND_v2i64), 0,
                      MVT::v2i64, 2/*#Ops*/, 0, 1, 
                  // Src: (and:{ *:[v2i64] } V128:{ *:[v2i64] }:$lhs, V128:{ *:[v2i64] }:$rhs) - Complexity = 3
                  // Dst: (AND_v2i64:{ *:[v2i64] } V128:{ *:[v2i64] }:$lhs, V128:{ *:[v2i64] }:$rhs)
/* 16703*/      0, // EndSwitchType
/* 16704*/    0, /*End of Scope*/
/* 16705*/  /*SwitchOpcode*/ 54|128,33/*4278*/, TARGET_VAL(ISD::ZERO_EXTEND),// ->20987
/* 16709*/    OPC_Scope, 41|128,33/*4265*/, /*->20977*/ // 2 children in Scope
/* 16712*/      OPC_MoveChild0,
/* 16713*/      OPC_SwitchOpcode /*9 cases */, 38|128,6/*806*/, TARGET_VAL(ISD::AssertZext),// ->17524
/* 16718*/        OPC_MoveChild0,
/* 16719*/        OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 16722*/        OPC_RecordMemRef,
/* 16723*/        OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 16724*/        OPC_CheckFoldableChainNode,
/* 16725*/        OPC_Scope, 123|128,4/*635*/, /*->17363*/ // 2 children in Scope
/* 16728*/          OPC_MoveChild1,
/* 16729*/          OPC_SwitchOpcode /*3 cases */, 121|128,2/*377*/, TARGET_VAL(ISD::ADD),// ->17111
/* 16734*/            OPC_Scope, 75, /*->16811*/ // 5 children in Scope
/* 16736*/              OPC_RecordChild0, // #1 = $addr
/* 16737*/              OPC_MoveChild1,
/* 16738*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 16741*/              OPC_RecordChild0, // #2 = $off
/* 16742*/              OPC_MoveChild0,
/* 16743*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 16746*/              OPC_MoveParent,
/* 16747*/              OPC_MoveParent,
/* 16748*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 16750*/              OPC_CheckType, MVT::i32,
/* 16752*/              OPC_MoveParent,
/* 16753*/              OPC_MoveChild2,
/* 16754*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 16757*/              OPC_RecordChild0, // #3 = $exp
/* 16758*/              OPC_MoveParent,
/* 16759*/              OPC_MoveChild3,
/* 16760*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 16763*/              OPC_RecordChild0, // #4 = $new
/* 16764*/              OPC_MoveParent,
/* 16765*/              OPC_Scope, 21, /*->16788*/ // 2 children in Scope
/* 16767*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 16769*/                OPC_MoveParent,
/* 16770*/                OPC_MoveParent,
/* 16771*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16773*/                OPC_EmitMergeInputChains1_0,
/* 16774*/                OPC_EmitInteger, MVT::i32, 0, 
/* 16777*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 26
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 16788*/              /*Scope*/ 21, /*->16810*/
/* 16789*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 16791*/                OPC_MoveParent,
/* 16792*/                OPC_MoveParent,
/* 16793*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16795*/                OPC_EmitMergeInputChains1_0,
/* 16796*/                OPC_EmitInteger, MVT::i32, 0, 
/* 16799*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 26
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 16810*/              0, /*End of Scope*/
/* 16811*/            /*Scope*/ 75, /*->16887*/
/* 16812*/              OPC_MoveChild0,
/* 16813*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 16816*/              OPC_RecordChild0, // #1 = $off
/* 16817*/              OPC_MoveChild0,
/* 16818*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 16821*/              OPC_MoveParent,
/* 16822*/              OPC_MoveParent,
/* 16823*/              OPC_RecordChild1, // #2 = $addr
/* 16824*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 16826*/              OPC_CheckType, MVT::i32,
/* 16828*/              OPC_MoveParent,
/* 16829*/              OPC_MoveChild2,
/* 16830*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 16833*/              OPC_RecordChild0, // #3 = $exp
/* 16834*/              OPC_MoveParent,
/* 16835*/              OPC_MoveChild3,
/* 16836*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 16839*/              OPC_RecordChild0, // #4 = $new
/* 16840*/              OPC_MoveParent,
/* 16841*/              OPC_Scope, 21, /*->16864*/ // 2 children in Scope
/* 16843*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 16845*/                OPC_MoveParent,
/* 16846*/                OPC_MoveParent,
/* 16847*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16849*/                OPC_EmitMergeInputChains1_0,
/* 16850*/                OPC_EmitInteger, MVT::i32, 0, 
/* 16853*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 26
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 16864*/              /*Scope*/ 21, /*->16886*/
/* 16865*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 16867*/                OPC_MoveParent,
/* 16868*/                OPC_MoveParent,
/* 16869*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16871*/                OPC_EmitMergeInputChains1_0,
/* 16872*/                OPC_EmitInteger, MVT::i32, 0, 
/* 16875*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 26
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 16886*/              0, /*End of Scope*/
/* 16887*/            /*Scope*/ 73, /*->16961*/
/* 16888*/              OPC_RecordChild0, // #1 = $addr
/* 16889*/              OPC_MoveChild1,
/* 16890*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 16893*/              OPC_RecordChild0, // #2 = $off
/* 16894*/              OPC_MoveChild0,
/* 16895*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 16898*/              OPC_MoveParent,
/* 16899*/              OPC_MoveParent,
/* 16900*/              OPC_CheckType, MVT::i32,
/* 16902*/              OPC_MoveParent,
/* 16903*/              OPC_MoveChild2,
/* 16904*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 16907*/              OPC_RecordChild0, // #3 = $exp
/* 16908*/              OPC_MoveParent,
/* 16909*/              OPC_MoveChild3,
/* 16910*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 16913*/              OPC_RecordChild0, // #4 = $new
/* 16914*/              OPC_MoveParent,
/* 16915*/              OPC_Scope, 21, /*->16938*/ // 2 children in Scope
/* 16917*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 16919*/                OPC_MoveParent,
/* 16920*/                OPC_MoveParent,
/* 16921*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16923*/                OPC_EmitMergeInputChains1_0,
/* 16924*/                OPC_EmitInteger, MVT::i32, 0, 
/* 16927*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 25
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 16938*/              /*Scope*/ 21, /*->16960*/
/* 16939*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 16941*/                OPC_MoveParent,
/* 16942*/                OPC_MoveParent,
/* 16943*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16945*/                OPC_EmitMergeInputChains1_0,
/* 16946*/                OPC_EmitInteger, MVT::i32, 0, 
/* 16949*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 25
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 16960*/              0, /*End of Scope*/
/* 16961*/            /*Scope*/ 73, /*->17035*/
/* 16962*/              OPC_MoveChild0,
/* 16963*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 16966*/              OPC_RecordChild0, // #1 = $off
/* 16967*/              OPC_MoveChild0,
/* 16968*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 16971*/              OPC_MoveParent,
/* 16972*/              OPC_MoveParent,
/* 16973*/              OPC_RecordChild1, // #2 = $addr
/* 16974*/              OPC_CheckType, MVT::i32,
/* 16976*/              OPC_MoveParent,
/* 16977*/              OPC_MoveChild2,
/* 16978*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 16981*/              OPC_RecordChild0, // #3 = $exp
/* 16982*/              OPC_MoveParent,
/* 16983*/              OPC_MoveChild3,
/* 16984*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 16987*/              OPC_RecordChild0, // #4 = $new
/* 16988*/              OPC_MoveParent,
/* 16989*/              OPC_Scope, 21, /*->17012*/ // 2 children in Scope
/* 16991*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 16993*/                OPC_MoveParent,
/* 16994*/                OPC_MoveParent,
/* 16995*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 16997*/                OPC_EmitMergeInputChains1_0,
/* 16998*/                OPC_EmitInteger, MVT::i32, 0, 
/* 17001*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 25
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17012*/              /*Scope*/ 21, /*->17034*/
/* 17013*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 17015*/                OPC_MoveParent,
/* 17016*/                OPC_MoveParent,
/* 17017*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17019*/                OPC_EmitMergeInputChains1_0,
/* 17020*/                OPC_EmitInteger, MVT::i32, 0, 
/* 17023*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 25
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17034*/              0, /*End of Scope*/
/* 17035*/            /*Scope*/ 74, /*->17110*/
/* 17036*/              OPC_RecordChild0, // #1 = $addr
/* 17037*/              OPC_RecordChild1, // #2 = $off
/* 17038*/              OPC_MoveChild1,
/* 17039*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 17042*/              OPC_MoveParent,
/* 17043*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 17045*/              OPC_CheckType, MVT::i32,
/* 17047*/              OPC_MoveParent,
/* 17048*/              OPC_MoveChild2,
/* 17049*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17052*/              OPC_RecordChild0, // #3 = $exp
/* 17053*/              OPC_MoveParent,
/* 17054*/              OPC_MoveChild3,
/* 17055*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17058*/              OPC_RecordChild0, // #4 = $new
/* 17059*/              OPC_MoveParent,
/* 17060*/              OPC_Scope, 23, /*->17085*/ // 2 children in Scope
/* 17062*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 17064*/                OPC_MoveParent,
/* 17065*/                OPC_MoveParent,
/* 17066*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17068*/                OPC_EmitMergeInputChains1_0,
/* 17069*/                OPC_EmitInteger, MVT::i32, 0, 
/* 17072*/                OPC_EmitConvertToTarget, 2,
/* 17074*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 23
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17085*/              /*Scope*/ 23, /*->17109*/
/* 17086*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 17088*/                OPC_MoveParent,
/* 17089*/                OPC_MoveParent,
/* 17090*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17092*/                OPC_EmitMergeInputChains1_0,
/* 17093*/                OPC_EmitInteger, MVT::i32, 0, 
/* 17096*/                OPC_EmitConvertToTarget, 2,
/* 17098*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 23
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17109*/              0, /*End of Scope*/
/* 17110*/            0, /*End of Scope*/
/* 17111*/          /*SwitchOpcode*/ 74, TARGET_VAL(ISD::OR),// ->17188
/* 17114*/            OPC_RecordChild0, // #1 = $addr
/* 17115*/            OPC_RecordChild1, // #2 = $off
/* 17116*/            OPC_MoveChild1,
/* 17117*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 17120*/            OPC_MoveParent,
/* 17121*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 17123*/            OPC_CheckType, MVT::i32,
/* 17125*/            OPC_MoveParent,
/* 17126*/            OPC_MoveChild2,
/* 17127*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17130*/            OPC_RecordChild0, // #3 = $exp
/* 17131*/            OPC_MoveParent,
/* 17132*/            OPC_MoveChild3,
/* 17133*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17136*/            OPC_RecordChild0, // #4 = $new
/* 17137*/            OPC_MoveParent,
/* 17138*/            OPC_Scope, 23, /*->17163*/ // 2 children in Scope
/* 17140*/              OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 17142*/              OPC_MoveParent,
/* 17143*/              OPC_MoveParent,
/* 17144*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17146*/              OPC_EmitMergeInputChains1_0,
/* 17147*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17150*/              OPC_EmitConvertToTarget, 2,
/* 17152*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                        // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 23
                        // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17163*/            /*Scope*/ 23, /*->17187*/
/* 17164*/              OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 17166*/              OPC_MoveParent,
/* 17167*/              OPC_MoveParent,
/* 17168*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17170*/              OPC_EmitMergeInputChains1_0,
/* 17171*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17174*/              OPC_EmitConvertToTarget, 2,
/* 17176*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                        // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 23
                        // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17187*/            0, /*End of Scope*/
/* 17188*/          /*SwitchOpcode*/ 42|128,1/*170*/, TARGET_VAL(WebAssemblyISD::Wrapper),// ->17362
/* 17192*/            OPC_RecordChild0, // #1 = $off
/* 17193*/            OPC_MoveChild0,
/* 17194*/            OPC_SwitchOpcode /*2 cases */, 80, TARGET_VAL(ISD::TargetGlobalAddress),// ->17278
/* 17198*/              OPC_MoveParent,
/* 17199*/              OPC_MoveParent,
/* 17200*/              OPC_MoveChild2,
/* 17201*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17204*/              OPC_RecordChild0, // #2 = $exp
/* 17205*/              OPC_MoveParent,
/* 17206*/              OPC_MoveChild3,
/* 17207*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17210*/              OPC_RecordChild0, // #3 = $new
/* 17211*/              OPC_MoveParent,
/* 17212*/              OPC_Scope, 31, /*->17245*/ // 2 children in Scope
/* 17214*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 17216*/                OPC_MoveParent,
/* 17217*/                OPC_MoveParent,
/* 17218*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17220*/                OPC_EmitMergeInputChains1_0,
/* 17221*/                OPC_EmitInteger, MVT::i32, 0, 
/* 17224*/                OPC_EmitInteger, MVT::i32, 0, 
/* 17227*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 17234*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 22
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17245*/              /*Scope*/ 31, /*->17277*/
/* 17246*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 17248*/                OPC_MoveParent,
/* 17249*/                OPC_MoveParent,
/* 17250*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17252*/                OPC_EmitMergeInputChains1_0,
/* 17253*/                OPC_EmitInteger, MVT::i32, 0, 
/* 17256*/                OPC_EmitInteger, MVT::i32, 0, 
/* 17259*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 17266*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 22
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17277*/              0, /*End of Scope*/
/* 17278*/            /*SwitchOpcode*/ 80, TARGET_VAL(ISD::TargetExternalSymbol),// ->17361
/* 17281*/              OPC_MoveParent,
/* 17282*/              OPC_MoveParent,
/* 17283*/              OPC_MoveChild2,
/* 17284*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17287*/              OPC_RecordChild0, // #2 = $exp
/* 17288*/              OPC_MoveParent,
/* 17289*/              OPC_MoveChild3,
/* 17290*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17293*/              OPC_RecordChild0, // #3 = $new
/* 17294*/              OPC_MoveParent,
/* 17295*/              OPC_Scope, 31, /*->17328*/ // 2 children in Scope
/* 17297*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 17299*/                OPC_MoveParent,
/* 17300*/                OPC_MoveParent,
/* 17301*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17303*/                OPC_EmitMergeInputChains1_0,
/* 17304*/                OPC_EmitInteger, MVT::i32, 0, 
/* 17307*/                OPC_EmitInteger, MVT::i32, 0, 
/* 17310*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 17317*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 22
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17328*/              /*Scope*/ 31, /*->17360*/
/* 17329*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 17331*/                OPC_MoveParent,
/* 17332*/                OPC_MoveParent,
/* 17333*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17335*/                OPC_EmitMergeInputChains1_0,
/* 17336*/                OPC_EmitInteger, MVT::i32, 0, 
/* 17339*/                OPC_EmitInteger, MVT::i32, 0, 
/* 17342*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 17349*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                          // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 22
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17360*/              0, /*End of Scope*/
/* 17361*/            0, // EndSwitchOpcode
/* 17362*/          0, // EndSwitchOpcode
/* 17363*/        /*Scope*/ 30|128,1/*158*/, /*->17523*/
/* 17365*/          OPC_RecordChild1, // #1 = $off
/* 17366*/          OPC_Scope, 87, /*->17455*/ // 2 children in Scope
/* 17368*/            OPC_MoveChild1,
/* 17369*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 17372*/            OPC_MoveParent,
/* 17373*/            OPC_MoveChild2,
/* 17374*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17377*/            OPC_RecordChild0, // #2 = $exp
/* 17378*/            OPC_MoveParent,
/* 17379*/            OPC_MoveChild3,
/* 17380*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17383*/            OPC_RecordChild0, // #3 = $new
/* 17384*/            OPC_MoveParent,
/* 17385*/            OPC_Scope, 33, /*->17420*/ // 2 children in Scope
/* 17387*/              OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 17389*/              OPC_MoveParent,
/* 17390*/              OPC_MoveParent,
/* 17391*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17393*/              OPC_EmitMergeInputChains1_0,
/* 17394*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17397*/              OPC_EmitConvertToTarget, 1,
/* 17399*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17402*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 6,  // Results = #7
/* 17409*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 4, 5, 7, 2, 3, 
                        // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 19
                        // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17420*/            /*Scope*/ 33, /*->17454*/
/* 17421*/              OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 17423*/              OPC_MoveParent,
/* 17424*/              OPC_MoveParent,
/* 17425*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17427*/              OPC_EmitMergeInputChains1_0,
/* 17428*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17431*/              OPC_EmitConvertToTarget, 1,
/* 17433*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17436*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 6,  // Results = #7
/* 17443*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 4, 5, 7, 2, 3, 
                        // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 19
                        // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17454*/            0, /*End of Scope*/
/* 17455*/          /*Scope*/ 66, /*->17522*/
/* 17456*/            OPC_CheckChild1Type, MVT::i32,
/* 17458*/            OPC_MoveChild2,
/* 17459*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17462*/            OPC_RecordChild0, // #2 = $exp
/* 17463*/            OPC_MoveParent,
/* 17464*/            OPC_MoveChild3,
/* 17465*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17468*/            OPC_RecordChild0, // #3 = $new
/* 17469*/            OPC_MoveParent,
/* 17470*/            OPC_Scope, 24, /*->17496*/ // 2 children in Scope
/* 17472*/              OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 17474*/              OPC_MoveParent,
/* 17475*/              OPC_MoveParent,
/* 17476*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17478*/              OPC_EmitMergeInputChains1_0,
/* 17479*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17482*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17485*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 4, 5, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 16
                        // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17496*/            /*Scope*/ 24, /*->17521*/
/* 17497*/              OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 17499*/              OPC_MoveParent,
/* 17500*/              OPC_MoveParent,
/* 17501*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17503*/              OPC_EmitMergeInputChains1_0,
/* 17504*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17507*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17510*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 4, 5, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 16
                        // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17521*/            0, /*End of Scope*/
/* 17522*/          0, /*End of Scope*/
/* 17523*/        0, /*End of Scope*/
/* 17524*/      /*SwitchOpcode*/ 116|128,3/*500*/, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),// ->18028
/* 17528*/        OPC_RecordMemRef,
/* 17529*/        OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 17530*/        OPC_Scope, 18|128,3/*402*/, /*->17935*/ // 2 children in Scope
/* 17533*/          OPC_MoveChild1,
/* 17534*/          OPC_SwitchOpcode /*3 cases */, 117|128,1/*245*/, TARGET_VAL(ISD::ADD),// ->17784
/* 17539*/            OPC_Scope, 49, /*->17590*/ // 5 children in Scope
/* 17541*/              OPC_RecordChild0, // #1 = $addr
/* 17542*/              OPC_MoveChild1,
/* 17543*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 17546*/              OPC_RecordChild0, // #2 = $off
/* 17547*/              OPC_MoveChild0,
/* 17548*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 17551*/              OPC_MoveParent,
/* 17552*/              OPC_MoveParent,
/* 17553*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 17555*/              OPC_CheckType, MVT::i32,
/* 17557*/              OPC_MoveParent,
/* 17558*/              OPC_MoveChild2,
/* 17559*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17562*/              OPC_RecordChild0, // #3 = $exp
/* 17563*/              OPC_MoveParent,
/* 17564*/              OPC_MoveChild3,
/* 17565*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17568*/              OPC_RecordChild0, // #4 = $new
/* 17569*/              OPC_MoveParent,
/* 17570*/              OPC_CheckPredicate, 7, // Predicate_atomic_cmp_swap_32
/* 17572*/              OPC_MoveParent,
/* 17573*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17575*/              OPC_EmitMergeInputChains1_0,
/* 17576*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17579*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                        // Src: (zext:{ *:[i64] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_32>>) - Complexity = 23
                        // Dst: (ATOMIC_RMW32_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17590*/            /*Scope*/ 49, /*->17640*/
/* 17591*/              OPC_MoveChild0,
/* 17592*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 17595*/              OPC_RecordChild0, // #1 = $off
/* 17596*/              OPC_MoveChild0,
/* 17597*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 17600*/              OPC_MoveParent,
/* 17601*/              OPC_MoveParent,
/* 17602*/              OPC_RecordChild1, // #2 = $addr
/* 17603*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 17605*/              OPC_CheckType, MVT::i32,
/* 17607*/              OPC_MoveParent,
/* 17608*/              OPC_MoveChild2,
/* 17609*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17612*/              OPC_RecordChild0, // #3 = $exp
/* 17613*/              OPC_MoveParent,
/* 17614*/              OPC_MoveChild3,
/* 17615*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17618*/              OPC_RecordChild0, // #4 = $new
/* 17619*/              OPC_MoveParent,
/* 17620*/              OPC_CheckPredicate, 7, // Predicate_atomic_cmp_swap_32
/* 17622*/              OPC_MoveParent,
/* 17623*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17625*/              OPC_EmitMergeInputChains1_0,
/* 17626*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17629*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                        // Src: (zext:{ *:[i64] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_32>>) - Complexity = 23
                        // Dst: (ATOMIC_RMW32_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17640*/            /*Scope*/ 47, /*->17688*/
/* 17641*/              OPC_RecordChild0, // #1 = $addr
/* 17642*/              OPC_MoveChild1,
/* 17643*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 17646*/              OPC_RecordChild0, // #2 = $off
/* 17647*/              OPC_MoveChild0,
/* 17648*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 17651*/              OPC_MoveParent,
/* 17652*/              OPC_MoveParent,
/* 17653*/              OPC_CheckType, MVT::i32,
/* 17655*/              OPC_MoveParent,
/* 17656*/              OPC_MoveChild2,
/* 17657*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17660*/              OPC_RecordChild0, // #3 = $exp
/* 17661*/              OPC_MoveParent,
/* 17662*/              OPC_MoveChild3,
/* 17663*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17666*/              OPC_RecordChild0, // #4 = $new
/* 17667*/              OPC_MoveParent,
/* 17668*/              OPC_CheckPredicate, 7, // Predicate_atomic_cmp_swap_32
/* 17670*/              OPC_MoveParent,
/* 17671*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17673*/              OPC_EmitMergeInputChains1_0,
/* 17674*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17677*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                        // Src: (zext:{ *:[i64] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_32>>) - Complexity = 22
                        // Dst: (ATOMIC_RMW32_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17688*/            /*Scope*/ 47, /*->17736*/
/* 17689*/              OPC_MoveChild0,
/* 17690*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 17693*/              OPC_RecordChild0, // #1 = $off
/* 17694*/              OPC_MoveChild0,
/* 17695*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 17698*/              OPC_MoveParent,
/* 17699*/              OPC_MoveParent,
/* 17700*/              OPC_RecordChild1, // #2 = $addr
/* 17701*/              OPC_CheckType, MVT::i32,
/* 17703*/              OPC_MoveParent,
/* 17704*/              OPC_MoveChild2,
/* 17705*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17708*/              OPC_RecordChild0, // #3 = $exp
/* 17709*/              OPC_MoveParent,
/* 17710*/              OPC_MoveChild3,
/* 17711*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17714*/              OPC_RecordChild0, // #4 = $new
/* 17715*/              OPC_MoveParent,
/* 17716*/              OPC_CheckPredicate, 7, // Predicate_atomic_cmp_swap_32
/* 17718*/              OPC_MoveParent,
/* 17719*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17721*/              OPC_EmitMergeInputChains1_0,
/* 17722*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17725*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                        // Src: (zext:{ *:[i64] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_32>>) - Complexity = 22
                        // Dst: (ATOMIC_RMW32_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17736*/            /*Scope*/ 46, /*->17783*/
/* 17737*/              OPC_RecordChild0, // #1 = $addr
/* 17738*/              OPC_RecordChild1, // #2 = $off
/* 17739*/              OPC_MoveChild1,
/* 17740*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 17743*/              OPC_MoveParent,
/* 17744*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 17746*/              OPC_CheckType, MVT::i32,
/* 17748*/              OPC_MoveParent,
/* 17749*/              OPC_MoveChild2,
/* 17750*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17753*/              OPC_RecordChild0, // #3 = $exp
/* 17754*/              OPC_MoveParent,
/* 17755*/              OPC_MoveChild3,
/* 17756*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17759*/              OPC_RecordChild0, // #4 = $new
/* 17760*/              OPC_MoveParent,
/* 17761*/              OPC_CheckPredicate, 7, // Predicate_atomic_cmp_swap_32
/* 17763*/              OPC_MoveParent,
/* 17764*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17766*/              OPC_EmitMergeInputChains1_0,
/* 17767*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17770*/              OPC_EmitConvertToTarget, 2,
/* 17772*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                        // Src: (zext:{ *:[i64] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_32>>) - Complexity = 20
                        // Dst: (ATOMIC_RMW32_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17783*/            0, /*End of Scope*/
/* 17784*/          /*SwitchOpcode*/ 46, TARGET_VAL(ISD::OR),// ->17833
/* 17787*/            OPC_RecordChild0, // #1 = $addr
/* 17788*/            OPC_RecordChild1, // #2 = $off
/* 17789*/            OPC_MoveChild1,
/* 17790*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 17793*/            OPC_MoveParent,
/* 17794*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 17796*/            OPC_CheckType, MVT::i32,
/* 17798*/            OPC_MoveParent,
/* 17799*/            OPC_MoveChild2,
/* 17800*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17803*/            OPC_RecordChild0, // #3 = $exp
/* 17804*/            OPC_MoveParent,
/* 17805*/            OPC_MoveChild3,
/* 17806*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17809*/            OPC_RecordChild0, // #4 = $new
/* 17810*/            OPC_MoveParent,
/* 17811*/            OPC_CheckPredicate, 7, // Predicate_atomic_cmp_swap_32
/* 17813*/            OPC_MoveParent,
/* 17814*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17816*/            OPC_EmitMergeInputChains1_0,
/* 17817*/            OPC_EmitInteger, MVT::i32, 0, 
/* 17820*/            OPC_EmitConvertToTarget, 2,
/* 17822*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                      // Src: (zext:{ *:[i64] } (atomic_cmp_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_32>>) - Complexity = 20
                      // Dst: (ATOMIC_RMW32_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17833*/          /*SwitchOpcode*/ 98, TARGET_VAL(WebAssemblyISD::Wrapper),// ->17934
/* 17836*/            OPC_RecordChild0, // #1 = $off
/* 17837*/            OPC_MoveChild0,
/* 17838*/            OPC_SwitchOpcode /*2 cases */, 44, TARGET_VAL(ISD::TargetGlobalAddress),// ->17886
/* 17842*/              OPC_MoveParent,
/* 17843*/              OPC_MoveParent,
/* 17844*/              OPC_MoveChild2,
/* 17845*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17848*/              OPC_RecordChild0, // #2 = $exp
/* 17849*/              OPC_MoveParent,
/* 17850*/              OPC_MoveChild3,
/* 17851*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17854*/              OPC_RecordChild0, // #3 = $new
/* 17855*/              OPC_MoveParent,
/* 17856*/              OPC_CheckPredicate, 7, // Predicate_atomic_cmp_swap_32
/* 17858*/              OPC_MoveParent,
/* 17859*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17861*/              OPC_EmitMergeInputChains1_0,
/* 17862*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17865*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17868*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 17875*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17886*/            /*SwitchOpcode*/ 44, TARGET_VAL(ISD::TargetExternalSymbol),// ->17933
/* 17889*/              OPC_MoveParent,
/* 17890*/              OPC_MoveParent,
/* 17891*/              OPC_MoveChild2,
/* 17892*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17895*/              OPC_RecordChild0, // #2 = $exp
/* 17896*/              OPC_MoveParent,
/* 17897*/              OPC_MoveChild3,
/* 17898*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17901*/              OPC_RecordChild0, // #3 = $new
/* 17902*/              OPC_MoveParent,
/* 17903*/              OPC_CheckPredicate, 7, // Predicate_atomic_cmp_swap_32
/* 17905*/              OPC_MoveParent,
/* 17906*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17908*/              OPC_EmitMergeInputChains1_0,
/* 17909*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17912*/              OPC_EmitInteger, MVT::i32, 0, 
/* 17915*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 17922*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17933*/            0, // EndSwitchOpcode
/* 17934*/          0, // EndSwitchOpcode
/* 17935*/        /*Scope*/ 91, /*->18027*/
/* 17936*/          OPC_RecordChild1, // #1 = $off
/* 17937*/          OPC_Scope, 49, /*->17988*/ // 2 children in Scope
/* 17939*/            OPC_MoveChild1,
/* 17940*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 17943*/            OPC_MoveParent,
/* 17944*/            OPC_MoveChild2,
/* 17945*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17948*/            OPC_RecordChild0, // #2 = $exp
/* 17949*/            OPC_MoveParent,
/* 17950*/            OPC_MoveChild3,
/* 17951*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17954*/            OPC_RecordChild0, // #3 = $new
/* 17955*/            OPC_MoveParent,
/* 17956*/            OPC_CheckPredicate, 7, // Predicate_atomic_cmp_swap_32
/* 17958*/            OPC_MoveParent,
/* 17959*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 17961*/            OPC_EmitMergeInputChains1_0,
/* 17962*/            OPC_EmitInteger, MVT::i32, 0, 
/* 17965*/            OPC_EmitConvertToTarget, 1,
/* 17967*/            OPC_EmitInteger, MVT::i32, 0, 
/* 17970*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 6,  // Results = #7
/* 17977*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 5/*#Ops*/, 4, 5, 7, 2, 3, 
                      // Src: (zext:{ *:[i64] } (atomic_cmp_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_32>>) - Complexity = 16
                      // Dst: (ATOMIC_RMW32_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 17988*/          /*Scope*/ 37, /*->18026*/
/* 17989*/            OPC_CheckChild1Type, MVT::i32,
/* 17991*/            OPC_MoveChild2,
/* 17992*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 17995*/            OPC_RecordChild0, // #2 = $exp
/* 17996*/            OPC_MoveParent,
/* 17997*/            OPC_MoveChild3,
/* 17998*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18001*/            OPC_RecordChild0, // #3 = $new
/* 18002*/            OPC_MoveParent,
/* 18003*/            OPC_CheckPredicate, 7, // Predicate_atomic_cmp_swap_32
/* 18005*/            OPC_MoveParent,
/* 18006*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18008*/            OPC_EmitMergeInputChains1_0,
/* 18009*/            OPC_EmitInteger, MVT::i32, 0, 
/* 18012*/            OPC_EmitInteger, MVT::i32, 0, 
/* 18015*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 5/*#Ops*/, 4, 5, 1, 2, 3, 
                      // Src: (zext:{ *:[i64] } (atomic_cmp_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_32>>) - Complexity = 13
                      // Dst: (ATOMIC_RMW32_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 18026*/          0, /*End of Scope*/
/* 18027*/        0, /*End of Scope*/
/* 18028*/      /*SwitchOpcode*/ 46|128,3/*430*/, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),// ->18462
/* 18032*/        OPC_RecordMemRef,
/* 18033*/        OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 18034*/        OPC_Scope, 90|128,2/*346*/, /*->18383*/ // 2 children in Scope
/* 18037*/          OPC_MoveChild1,
/* 18038*/          OPC_SwitchOpcode /*3 cases */, 82|128,1/*210*/, TARGET_VAL(ISD::ADD),// ->18253
/* 18043*/            OPC_Scope, 42, /*->18087*/ // 5 children in Scope
/* 18045*/              OPC_RecordChild0, // #1 = $addr
/* 18046*/              OPC_MoveChild1,
/* 18047*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 18050*/              OPC_RecordChild0, // #2 = $off
/* 18051*/              OPC_MoveChild0,
/* 18052*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 18055*/              OPC_MoveParent,
/* 18056*/              OPC_MoveParent,
/* 18057*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 18059*/              OPC_CheckType, MVT::i32,
/* 18061*/              OPC_MoveParent,
/* 18062*/              OPC_MoveChild2,
/* 18063*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18066*/              OPC_RecordChild0, // #3 = $val
/* 18067*/              OPC_MoveParent,
/* 18068*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_add_32
/* 18070*/              OPC_MoveParent,
/* 18071*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18073*/              OPC_EmitMergeInputChains1_0,
/* 18074*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18077*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_32>>) - Complexity = 20
                        // Dst: (ATOMIC_RMW32_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18087*/            /*Scope*/ 42, /*->18130*/
/* 18088*/              OPC_MoveChild0,
/* 18089*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 18092*/              OPC_RecordChild0, // #1 = $off
/* 18093*/              OPC_MoveChild0,
/* 18094*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 18097*/              OPC_MoveParent,
/* 18098*/              OPC_MoveParent,
/* 18099*/              OPC_RecordChild1, // #2 = $addr
/* 18100*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 18102*/              OPC_CheckType, MVT::i32,
/* 18104*/              OPC_MoveParent,
/* 18105*/              OPC_MoveChild2,
/* 18106*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18109*/              OPC_RecordChild0, // #3 = $val
/* 18110*/              OPC_MoveParent,
/* 18111*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_add_32
/* 18113*/              OPC_MoveParent,
/* 18114*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18116*/              OPC_EmitMergeInputChains1_0,
/* 18117*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18120*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_32>>) - Complexity = 20
                        // Dst: (ATOMIC_RMW32_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18130*/            /*Scope*/ 40, /*->18171*/
/* 18131*/              OPC_RecordChild0, // #1 = $addr
/* 18132*/              OPC_MoveChild1,
/* 18133*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 18136*/              OPC_RecordChild0, // #2 = $off
/* 18137*/              OPC_MoveChild0,
/* 18138*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 18141*/              OPC_MoveParent,
/* 18142*/              OPC_MoveParent,
/* 18143*/              OPC_CheckType, MVT::i32,
/* 18145*/              OPC_MoveParent,
/* 18146*/              OPC_MoveChild2,
/* 18147*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18150*/              OPC_RecordChild0, // #3 = $val
/* 18151*/              OPC_MoveParent,
/* 18152*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_add_32
/* 18154*/              OPC_MoveParent,
/* 18155*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18157*/              OPC_EmitMergeInputChains1_0,
/* 18158*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18161*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18171*/            /*Scope*/ 40, /*->18212*/
/* 18172*/              OPC_MoveChild0,
/* 18173*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 18176*/              OPC_RecordChild0, // #1 = $off
/* 18177*/              OPC_MoveChild0,
/* 18178*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 18181*/              OPC_MoveParent,
/* 18182*/              OPC_MoveParent,
/* 18183*/              OPC_RecordChild1, // #2 = $addr
/* 18184*/              OPC_CheckType, MVT::i32,
/* 18186*/              OPC_MoveParent,
/* 18187*/              OPC_MoveChild2,
/* 18188*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18191*/              OPC_RecordChild0, // #3 = $val
/* 18192*/              OPC_MoveParent,
/* 18193*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_add_32
/* 18195*/              OPC_MoveParent,
/* 18196*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18198*/              OPC_EmitMergeInputChains1_0,
/* 18199*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18202*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18212*/            /*Scope*/ 39, /*->18252*/
/* 18213*/              OPC_RecordChild0, // #1 = $addr
/* 18214*/              OPC_RecordChild1, // #2 = $off
/* 18215*/              OPC_MoveChild1,
/* 18216*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 18219*/              OPC_MoveParent,
/* 18220*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 18222*/              OPC_CheckType, MVT::i32,
/* 18224*/              OPC_MoveParent,
/* 18225*/              OPC_MoveChild2,
/* 18226*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18229*/              OPC_RecordChild0, // #3 = $val
/* 18230*/              OPC_MoveParent,
/* 18231*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_add_32
/* 18233*/              OPC_MoveParent,
/* 18234*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18236*/              OPC_EmitMergeInputChains1_0,
/* 18237*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18240*/              OPC_EmitConvertToTarget, 2,
/* 18242*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_32>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW32_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18252*/            0, /*End of Scope*/
/* 18253*/          /*SwitchOpcode*/ 39, TARGET_VAL(ISD::OR),// ->18295
/* 18256*/            OPC_RecordChild0, // #1 = $addr
/* 18257*/            OPC_RecordChild1, // #2 = $off
/* 18258*/            OPC_MoveChild1,
/* 18259*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 18262*/            OPC_MoveParent,
/* 18263*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 18265*/            OPC_CheckType, MVT::i32,
/* 18267*/            OPC_MoveParent,
/* 18268*/            OPC_MoveChild2,
/* 18269*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18272*/            OPC_RecordChild0, // #3 = $val
/* 18273*/            OPC_MoveParent,
/* 18274*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_add_32
/* 18276*/            OPC_MoveParent,
/* 18277*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18279*/            OPC_EmitMergeInputChains1_0,
/* 18280*/            OPC_EmitInteger, MVT::i32, 0, 
/* 18283*/            OPC_EmitConvertToTarget, 2,
/* 18285*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                      // Src: (zext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_32>>) - Complexity = 17
                      // Dst: (ATOMIC_RMW32_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18295*/          /*SwitchOpcode*/ 84, TARGET_VAL(WebAssemblyISD::Wrapper),// ->18382
/* 18298*/            OPC_RecordChild0, // #1 = $off
/* 18299*/            OPC_MoveChild0,
/* 18300*/            OPC_SwitchOpcode /*2 cases */, 37, TARGET_VAL(ISD::TargetGlobalAddress),// ->18341
/* 18304*/              OPC_MoveParent,
/* 18305*/              OPC_MoveParent,
/* 18306*/              OPC_MoveChild2,
/* 18307*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18310*/              OPC_RecordChild0, // #2 = $val
/* 18311*/              OPC_MoveParent,
/* 18312*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_add_32
/* 18314*/              OPC_MoveParent,
/* 18315*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18317*/              OPC_EmitMergeInputChains1_0,
/* 18318*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18321*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18324*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 18331*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_32>>) - Complexity = 16
                        // Dst: (ATOMIC_RMW32_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 18341*/            /*SwitchOpcode*/ 37, TARGET_VAL(ISD::TargetExternalSymbol),// ->18381
/* 18344*/              OPC_MoveParent,
/* 18345*/              OPC_MoveParent,
/* 18346*/              OPC_MoveChild2,
/* 18347*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18350*/              OPC_RecordChild0, // #2 = $val
/* 18351*/              OPC_MoveParent,
/* 18352*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_add_32
/* 18354*/              OPC_MoveParent,
/* 18355*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18357*/              OPC_EmitMergeInputChains1_0,
/* 18358*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18361*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18364*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 18371*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_32>>) - Complexity = 16
                        // Dst: (ATOMIC_RMW32_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 18381*/            0, // EndSwitchOpcode
/* 18382*/          0, // EndSwitchOpcode
/* 18383*/        /*Scope*/ 77, /*->18461*/
/* 18384*/          OPC_RecordChild1, // #1 = $off
/* 18385*/          OPC_Scope, 42, /*->18429*/ // 2 children in Scope
/* 18387*/            OPC_MoveChild1,
/* 18388*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 18391*/            OPC_MoveParent,
/* 18392*/            OPC_MoveChild2,
/* 18393*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18396*/            OPC_RecordChild0, // #2 = $val
/* 18397*/            OPC_MoveParent,
/* 18398*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_add_32
/* 18400*/            OPC_MoveParent,
/* 18401*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18403*/            OPC_EmitMergeInputChains1_0,
/* 18404*/            OPC_EmitInteger, MVT::i32, 0, 
/* 18407*/            OPC_EmitConvertToTarget, 1,
/* 18409*/            OPC_EmitInteger, MVT::i32, 0, 
/* 18412*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 18419*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                      // Src: (zext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_32>>) - Complexity = 13
                      // Dst: (ATOMIC_RMW32_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 18429*/          /*Scope*/ 30, /*->18460*/
/* 18430*/            OPC_CheckChild1Type, MVT::i32,
/* 18432*/            OPC_MoveChild2,
/* 18433*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18436*/            OPC_RecordChild0, // #2 = $val
/* 18437*/            OPC_MoveParent,
/* 18438*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_add_32
/* 18440*/            OPC_MoveParent,
/* 18441*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18443*/            OPC_EmitMergeInputChains1_0,
/* 18444*/            OPC_EmitInteger, MVT::i32, 0, 
/* 18447*/            OPC_EmitInteger, MVT::i32, 0, 
/* 18450*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                      // Src: (zext:{ *:[i64] } (atomic_load_add:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_32>>) - Complexity = 10
                      // Dst: (ATOMIC_RMW32_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18460*/          0, /*End of Scope*/
/* 18461*/        0, /*End of Scope*/
/* 18462*/      /*SwitchOpcode*/ 46|128,3/*430*/, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),// ->18896
/* 18466*/        OPC_RecordMemRef,
/* 18467*/        OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 18468*/        OPC_Scope, 90|128,2/*346*/, /*->18817*/ // 2 children in Scope
/* 18471*/          OPC_MoveChild1,
/* 18472*/          OPC_SwitchOpcode /*3 cases */, 82|128,1/*210*/, TARGET_VAL(ISD::ADD),// ->18687
/* 18477*/            OPC_Scope, 42, /*->18521*/ // 5 children in Scope
/* 18479*/              OPC_RecordChild0, // #1 = $addr
/* 18480*/              OPC_MoveChild1,
/* 18481*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 18484*/              OPC_RecordChild0, // #2 = $off
/* 18485*/              OPC_MoveChild0,
/* 18486*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 18489*/              OPC_MoveParent,
/* 18490*/              OPC_MoveParent,
/* 18491*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 18493*/              OPC_CheckType, MVT::i32,
/* 18495*/              OPC_MoveParent,
/* 18496*/              OPC_MoveChild2,
/* 18497*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18500*/              OPC_RecordChild0, // #3 = $val
/* 18501*/              OPC_MoveParent,
/* 18502*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_sub_32
/* 18504*/              OPC_MoveParent,
/* 18505*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18507*/              OPC_EmitMergeInputChains1_0,
/* 18508*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18511*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_32>>) - Complexity = 20
                        // Dst: (ATOMIC_RMW32_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18521*/            /*Scope*/ 42, /*->18564*/
/* 18522*/              OPC_MoveChild0,
/* 18523*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 18526*/              OPC_RecordChild0, // #1 = $off
/* 18527*/              OPC_MoveChild0,
/* 18528*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 18531*/              OPC_MoveParent,
/* 18532*/              OPC_MoveParent,
/* 18533*/              OPC_RecordChild1, // #2 = $addr
/* 18534*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 18536*/              OPC_CheckType, MVT::i32,
/* 18538*/              OPC_MoveParent,
/* 18539*/              OPC_MoveChild2,
/* 18540*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18543*/              OPC_RecordChild0, // #3 = $val
/* 18544*/              OPC_MoveParent,
/* 18545*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_sub_32
/* 18547*/              OPC_MoveParent,
/* 18548*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18550*/              OPC_EmitMergeInputChains1_0,
/* 18551*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18554*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_32>>) - Complexity = 20
                        // Dst: (ATOMIC_RMW32_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18564*/            /*Scope*/ 40, /*->18605*/
/* 18565*/              OPC_RecordChild0, // #1 = $addr
/* 18566*/              OPC_MoveChild1,
/* 18567*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 18570*/              OPC_RecordChild0, // #2 = $off
/* 18571*/              OPC_MoveChild0,
/* 18572*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 18575*/              OPC_MoveParent,
/* 18576*/              OPC_MoveParent,
/* 18577*/              OPC_CheckType, MVT::i32,
/* 18579*/              OPC_MoveParent,
/* 18580*/              OPC_MoveChild2,
/* 18581*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18584*/              OPC_RecordChild0, // #3 = $val
/* 18585*/              OPC_MoveParent,
/* 18586*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_sub_32
/* 18588*/              OPC_MoveParent,
/* 18589*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18591*/              OPC_EmitMergeInputChains1_0,
/* 18592*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18595*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18605*/            /*Scope*/ 40, /*->18646*/
/* 18606*/              OPC_MoveChild0,
/* 18607*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 18610*/              OPC_RecordChild0, // #1 = $off
/* 18611*/              OPC_MoveChild0,
/* 18612*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 18615*/              OPC_MoveParent,
/* 18616*/              OPC_MoveParent,
/* 18617*/              OPC_RecordChild1, // #2 = $addr
/* 18618*/              OPC_CheckType, MVT::i32,
/* 18620*/              OPC_MoveParent,
/* 18621*/              OPC_MoveChild2,
/* 18622*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18625*/              OPC_RecordChild0, // #3 = $val
/* 18626*/              OPC_MoveParent,
/* 18627*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_sub_32
/* 18629*/              OPC_MoveParent,
/* 18630*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18632*/              OPC_EmitMergeInputChains1_0,
/* 18633*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18636*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18646*/            /*Scope*/ 39, /*->18686*/
/* 18647*/              OPC_RecordChild0, // #1 = $addr
/* 18648*/              OPC_RecordChild1, // #2 = $off
/* 18649*/              OPC_MoveChild1,
/* 18650*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 18653*/              OPC_MoveParent,
/* 18654*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 18656*/              OPC_CheckType, MVT::i32,
/* 18658*/              OPC_MoveParent,
/* 18659*/              OPC_MoveChild2,
/* 18660*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18663*/              OPC_RecordChild0, // #3 = $val
/* 18664*/              OPC_MoveParent,
/* 18665*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_sub_32
/* 18667*/              OPC_MoveParent,
/* 18668*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18670*/              OPC_EmitMergeInputChains1_0,
/* 18671*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18674*/              OPC_EmitConvertToTarget, 2,
/* 18676*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_32>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW32_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18686*/            0, /*End of Scope*/
/* 18687*/          /*SwitchOpcode*/ 39, TARGET_VAL(ISD::OR),// ->18729
/* 18690*/            OPC_RecordChild0, // #1 = $addr
/* 18691*/            OPC_RecordChild1, // #2 = $off
/* 18692*/            OPC_MoveChild1,
/* 18693*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 18696*/            OPC_MoveParent,
/* 18697*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 18699*/            OPC_CheckType, MVT::i32,
/* 18701*/            OPC_MoveParent,
/* 18702*/            OPC_MoveChild2,
/* 18703*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18706*/            OPC_RecordChild0, // #3 = $val
/* 18707*/            OPC_MoveParent,
/* 18708*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_sub_32
/* 18710*/            OPC_MoveParent,
/* 18711*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18713*/            OPC_EmitMergeInputChains1_0,
/* 18714*/            OPC_EmitInteger, MVT::i32, 0, 
/* 18717*/            OPC_EmitConvertToTarget, 2,
/* 18719*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                      // Src: (zext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_32>>) - Complexity = 17
                      // Dst: (ATOMIC_RMW32_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18729*/          /*SwitchOpcode*/ 84, TARGET_VAL(WebAssemblyISD::Wrapper),// ->18816
/* 18732*/            OPC_RecordChild0, // #1 = $off
/* 18733*/            OPC_MoveChild0,
/* 18734*/            OPC_SwitchOpcode /*2 cases */, 37, TARGET_VAL(ISD::TargetGlobalAddress),// ->18775
/* 18738*/              OPC_MoveParent,
/* 18739*/              OPC_MoveParent,
/* 18740*/              OPC_MoveChild2,
/* 18741*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18744*/              OPC_RecordChild0, // #2 = $val
/* 18745*/              OPC_MoveParent,
/* 18746*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_sub_32
/* 18748*/              OPC_MoveParent,
/* 18749*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18751*/              OPC_EmitMergeInputChains1_0,
/* 18752*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18755*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18758*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 18765*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_32>>) - Complexity = 16
                        // Dst: (ATOMIC_RMW32_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 18775*/            /*SwitchOpcode*/ 37, TARGET_VAL(ISD::TargetExternalSymbol),// ->18815
/* 18778*/              OPC_MoveParent,
/* 18779*/              OPC_MoveParent,
/* 18780*/              OPC_MoveChild2,
/* 18781*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18784*/              OPC_RecordChild0, // #2 = $val
/* 18785*/              OPC_MoveParent,
/* 18786*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_sub_32
/* 18788*/              OPC_MoveParent,
/* 18789*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18791*/              OPC_EmitMergeInputChains1_0,
/* 18792*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18795*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18798*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 18805*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_32>>) - Complexity = 16
                        // Dst: (ATOMIC_RMW32_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 18815*/            0, // EndSwitchOpcode
/* 18816*/          0, // EndSwitchOpcode
/* 18817*/        /*Scope*/ 77, /*->18895*/
/* 18818*/          OPC_RecordChild1, // #1 = $off
/* 18819*/          OPC_Scope, 42, /*->18863*/ // 2 children in Scope
/* 18821*/            OPC_MoveChild1,
/* 18822*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 18825*/            OPC_MoveParent,
/* 18826*/            OPC_MoveChild2,
/* 18827*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18830*/            OPC_RecordChild0, // #2 = $val
/* 18831*/            OPC_MoveParent,
/* 18832*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_sub_32
/* 18834*/            OPC_MoveParent,
/* 18835*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18837*/            OPC_EmitMergeInputChains1_0,
/* 18838*/            OPC_EmitInteger, MVT::i32, 0, 
/* 18841*/            OPC_EmitConvertToTarget, 1,
/* 18843*/            OPC_EmitInteger, MVT::i32, 0, 
/* 18846*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 18853*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                      // Src: (zext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_32>>) - Complexity = 13
                      // Dst: (ATOMIC_RMW32_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 18863*/          /*Scope*/ 30, /*->18894*/
/* 18864*/            OPC_CheckChild1Type, MVT::i32,
/* 18866*/            OPC_MoveChild2,
/* 18867*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18870*/            OPC_RecordChild0, // #2 = $val
/* 18871*/            OPC_MoveParent,
/* 18872*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_sub_32
/* 18874*/            OPC_MoveParent,
/* 18875*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18877*/            OPC_EmitMergeInputChains1_0,
/* 18878*/            OPC_EmitInteger, MVT::i32, 0, 
/* 18881*/            OPC_EmitInteger, MVT::i32, 0, 
/* 18884*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                      // Src: (zext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_32>>) - Complexity = 10
                      // Dst: (ATOMIC_RMW32_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18894*/          0, /*End of Scope*/
/* 18895*/        0, /*End of Scope*/
/* 18896*/      /*SwitchOpcode*/ 46|128,3/*430*/, TARGET_VAL(ISD::ATOMIC_LOAD_AND),// ->19330
/* 18900*/        OPC_RecordMemRef,
/* 18901*/        OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 18902*/        OPC_Scope, 90|128,2/*346*/, /*->19251*/ // 2 children in Scope
/* 18905*/          OPC_MoveChild1,
/* 18906*/          OPC_SwitchOpcode /*3 cases */, 82|128,1/*210*/, TARGET_VAL(ISD::ADD),// ->19121
/* 18911*/            OPC_Scope, 42, /*->18955*/ // 5 children in Scope
/* 18913*/              OPC_RecordChild0, // #1 = $addr
/* 18914*/              OPC_MoveChild1,
/* 18915*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 18918*/              OPC_RecordChild0, // #2 = $off
/* 18919*/              OPC_MoveChild0,
/* 18920*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 18923*/              OPC_MoveParent,
/* 18924*/              OPC_MoveParent,
/* 18925*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 18927*/              OPC_CheckType, MVT::i32,
/* 18929*/              OPC_MoveParent,
/* 18930*/              OPC_MoveChild2,
/* 18931*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18934*/              OPC_RecordChild0, // #3 = $val
/* 18935*/              OPC_MoveParent,
/* 18936*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_and_32
/* 18938*/              OPC_MoveParent,
/* 18939*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18941*/              OPC_EmitMergeInputChains1_0,
/* 18942*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18945*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_32>>) - Complexity = 20
                        // Dst: (ATOMIC_RMW32_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18955*/            /*Scope*/ 42, /*->18998*/
/* 18956*/              OPC_MoveChild0,
/* 18957*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 18960*/              OPC_RecordChild0, // #1 = $off
/* 18961*/              OPC_MoveChild0,
/* 18962*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 18965*/              OPC_MoveParent,
/* 18966*/              OPC_MoveParent,
/* 18967*/              OPC_RecordChild1, // #2 = $addr
/* 18968*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 18970*/              OPC_CheckType, MVT::i32,
/* 18972*/              OPC_MoveParent,
/* 18973*/              OPC_MoveChild2,
/* 18974*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 18977*/              OPC_RecordChild0, // #3 = $val
/* 18978*/              OPC_MoveParent,
/* 18979*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_and_32
/* 18981*/              OPC_MoveParent,
/* 18982*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 18984*/              OPC_EmitMergeInputChains1_0,
/* 18985*/              OPC_EmitInteger, MVT::i32, 0, 
/* 18988*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_32>>) - Complexity = 20
                        // Dst: (ATOMIC_RMW32_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 18998*/            /*Scope*/ 40, /*->19039*/
/* 18999*/              OPC_RecordChild0, // #1 = $addr
/* 19000*/              OPC_MoveChild1,
/* 19001*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 19004*/              OPC_RecordChild0, // #2 = $off
/* 19005*/              OPC_MoveChild0,
/* 19006*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 19009*/              OPC_MoveParent,
/* 19010*/              OPC_MoveParent,
/* 19011*/              OPC_CheckType, MVT::i32,
/* 19013*/              OPC_MoveParent,
/* 19014*/              OPC_MoveChild2,
/* 19015*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19018*/              OPC_RecordChild0, // #3 = $val
/* 19019*/              OPC_MoveParent,
/* 19020*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_and_32
/* 19022*/              OPC_MoveParent,
/* 19023*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19025*/              OPC_EmitMergeInputChains1_0,
/* 19026*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19029*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19039*/            /*Scope*/ 40, /*->19080*/
/* 19040*/              OPC_MoveChild0,
/* 19041*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 19044*/              OPC_RecordChild0, // #1 = $off
/* 19045*/              OPC_MoveChild0,
/* 19046*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 19049*/              OPC_MoveParent,
/* 19050*/              OPC_MoveParent,
/* 19051*/              OPC_RecordChild1, // #2 = $addr
/* 19052*/              OPC_CheckType, MVT::i32,
/* 19054*/              OPC_MoveParent,
/* 19055*/              OPC_MoveChild2,
/* 19056*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19059*/              OPC_RecordChild0, // #3 = $val
/* 19060*/              OPC_MoveParent,
/* 19061*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_and_32
/* 19063*/              OPC_MoveParent,
/* 19064*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19066*/              OPC_EmitMergeInputChains1_0,
/* 19067*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19070*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19080*/            /*Scope*/ 39, /*->19120*/
/* 19081*/              OPC_RecordChild0, // #1 = $addr
/* 19082*/              OPC_RecordChild1, // #2 = $off
/* 19083*/              OPC_MoveChild1,
/* 19084*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 19087*/              OPC_MoveParent,
/* 19088*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 19090*/              OPC_CheckType, MVT::i32,
/* 19092*/              OPC_MoveParent,
/* 19093*/              OPC_MoveChild2,
/* 19094*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19097*/              OPC_RecordChild0, // #3 = $val
/* 19098*/              OPC_MoveParent,
/* 19099*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_and_32
/* 19101*/              OPC_MoveParent,
/* 19102*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19104*/              OPC_EmitMergeInputChains1_0,
/* 19105*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19108*/              OPC_EmitConvertToTarget, 2,
/* 19110*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_32>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW32_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19120*/            0, /*End of Scope*/
/* 19121*/          /*SwitchOpcode*/ 39, TARGET_VAL(ISD::OR),// ->19163
/* 19124*/            OPC_RecordChild0, // #1 = $addr
/* 19125*/            OPC_RecordChild1, // #2 = $off
/* 19126*/            OPC_MoveChild1,
/* 19127*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 19130*/            OPC_MoveParent,
/* 19131*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 19133*/            OPC_CheckType, MVT::i32,
/* 19135*/            OPC_MoveParent,
/* 19136*/            OPC_MoveChild2,
/* 19137*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19140*/            OPC_RecordChild0, // #3 = $val
/* 19141*/            OPC_MoveParent,
/* 19142*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_and_32
/* 19144*/            OPC_MoveParent,
/* 19145*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19147*/            OPC_EmitMergeInputChains1_0,
/* 19148*/            OPC_EmitInteger, MVT::i32, 0, 
/* 19151*/            OPC_EmitConvertToTarget, 2,
/* 19153*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                      // Src: (zext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_32>>) - Complexity = 17
                      // Dst: (ATOMIC_RMW32_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19163*/          /*SwitchOpcode*/ 84, TARGET_VAL(WebAssemblyISD::Wrapper),// ->19250
/* 19166*/            OPC_RecordChild0, // #1 = $off
/* 19167*/            OPC_MoveChild0,
/* 19168*/            OPC_SwitchOpcode /*2 cases */, 37, TARGET_VAL(ISD::TargetGlobalAddress),// ->19209
/* 19172*/              OPC_MoveParent,
/* 19173*/              OPC_MoveParent,
/* 19174*/              OPC_MoveChild2,
/* 19175*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19178*/              OPC_RecordChild0, // #2 = $val
/* 19179*/              OPC_MoveParent,
/* 19180*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_and_32
/* 19182*/              OPC_MoveParent,
/* 19183*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19185*/              OPC_EmitMergeInputChains1_0,
/* 19186*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19189*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19192*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 19199*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_32>>) - Complexity = 16
                        // Dst: (ATOMIC_RMW32_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 19209*/            /*SwitchOpcode*/ 37, TARGET_VAL(ISD::TargetExternalSymbol),// ->19249
/* 19212*/              OPC_MoveParent,
/* 19213*/              OPC_MoveParent,
/* 19214*/              OPC_MoveChild2,
/* 19215*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19218*/              OPC_RecordChild0, // #2 = $val
/* 19219*/              OPC_MoveParent,
/* 19220*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_and_32
/* 19222*/              OPC_MoveParent,
/* 19223*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19225*/              OPC_EmitMergeInputChains1_0,
/* 19226*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19229*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19232*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 19239*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_32>>) - Complexity = 16
                        // Dst: (ATOMIC_RMW32_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 19249*/            0, // EndSwitchOpcode
/* 19250*/          0, // EndSwitchOpcode
/* 19251*/        /*Scope*/ 77, /*->19329*/
/* 19252*/          OPC_RecordChild1, // #1 = $off
/* 19253*/          OPC_Scope, 42, /*->19297*/ // 2 children in Scope
/* 19255*/            OPC_MoveChild1,
/* 19256*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 19259*/            OPC_MoveParent,
/* 19260*/            OPC_MoveChild2,
/* 19261*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19264*/            OPC_RecordChild0, // #2 = $val
/* 19265*/            OPC_MoveParent,
/* 19266*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_and_32
/* 19268*/            OPC_MoveParent,
/* 19269*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19271*/            OPC_EmitMergeInputChains1_0,
/* 19272*/            OPC_EmitInteger, MVT::i32, 0, 
/* 19275*/            OPC_EmitConvertToTarget, 1,
/* 19277*/            OPC_EmitInteger, MVT::i32, 0, 
/* 19280*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 19287*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                      // Src: (zext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_32>>) - Complexity = 13
                      // Dst: (ATOMIC_RMW32_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 19297*/          /*Scope*/ 30, /*->19328*/
/* 19298*/            OPC_CheckChild1Type, MVT::i32,
/* 19300*/            OPC_MoveChild2,
/* 19301*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19304*/            OPC_RecordChild0, // #2 = $val
/* 19305*/            OPC_MoveParent,
/* 19306*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_and_32
/* 19308*/            OPC_MoveParent,
/* 19309*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19311*/            OPC_EmitMergeInputChains1_0,
/* 19312*/            OPC_EmitInteger, MVT::i32, 0, 
/* 19315*/            OPC_EmitInteger, MVT::i32, 0, 
/* 19318*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                      // Src: (zext:{ *:[i64] } (atomic_load_and:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_32>>) - Complexity = 10
                      // Dst: (ATOMIC_RMW32_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19328*/          0, /*End of Scope*/
/* 19329*/        0, /*End of Scope*/
/* 19330*/      /*SwitchOpcode*/ 46|128,3/*430*/, TARGET_VAL(ISD::ATOMIC_LOAD_OR),// ->19764
/* 19334*/        OPC_RecordMemRef,
/* 19335*/        OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 19336*/        OPC_Scope, 90|128,2/*346*/, /*->19685*/ // 2 children in Scope
/* 19339*/          OPC_MoveChild1,
/* 19340*/          OPC_SwitchOpcode /*3 cases */, 82|128,1/*210*/, TARGET_VAL(ISD::ADD),// ->19555
/* 19345*/            OPC_Scope, 42, /*->19389*/ // 5 children in Scope
/* 19347*/              OPC_RecordChild0, // #1 = $addr
/* 19348*/              OPC_MoveChild1,
/* 19349*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 19352*/              OPC_RecordChild0, // #2 = $off
/* 19353*/              OPC_MoveChild0,
/* 19354*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 19357*/              OPC_MoveParent,
/* 19358*/              OPC_MoveParent,
/* 19359*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 19361*/              OPC_CheckType, MVT::i32,
/* 19363*/              OPC_MoveParent,
/* 19364*/              OPC_MoveChild2,
/* 19365*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19368*/              OPC_RecordChild0, // #3 = $val
/* 19369*/              OPC_MoveParent,
/* 19370*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_or_32
/* 19372*/              OPC_MoveParent,
/* 19373*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19375*/              OPC_EmitMergeInputChains1_0,
/* 19376*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19379*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_32>>) - Complexity = 20
                        // Dst: (ATOMIC_RMW32_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19389*/            /*Scope*/ 42, /*->19432*/
/* 19390*/              OPC_MoveChild0,
/* 19391*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 19394*/              OPC_RecordChild0, // #1 = $off
/* 19395*/              OPC_MoveChild0,
/* 19396*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 19399*/              OPC_MoveParent,
/* 19400*/              OPC_MoveParent,
/* 19401*/              OPC_RecordChild1, // #2 = $addr
/* 19402*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 19404*/              OPC_CheckType, MVT::i32,
/* 19406*/              OPC_MoveParent,
/* 19407*/              OPC_MoveChild2,
/* 19408*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19411*/              OPC_RecordChild0, // #3 = $val
/* 19412*/              OPC_MoveParent,
/* 19413*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_or_32
/* 19415*/              OPC_MoveParent,
/* 19416*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19418*/              OPC_EmitMergeInputChains1_0,
/* 19419*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19422*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_32>>) - Complexity = 20
                        // Dst: (ATOMIC_RMW32_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19432*/            /*Scope*/ 40, /*->19473*/
/* 19433*/              OPC_RecordChild0, // #1 = $addr
/* 19434*/              OPC_MoveChild1,
/* 19435*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 19438*/              OPC_RecordChild0, // #2 = $off
/* 19439*/              OPC_MoveChild0,
/* 19440*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 19443*/              OPC_MoveParent,
/* 19444*/              OPC_MoveParent,
/* 19445*/              OPC_CheckType, MVT::i32,
/* 19447*/              OPC_MoveParent,
/* 19448*/              OPC_MoveChild2,
/* 19449*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19452*/              OPC_RecordChild0, // #3 = $val
/* 19453*/              OPC_MoveParent,
/* 19454*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_or_32
/* 19456*/              OPC_MoveParent,
/* 19457*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19459*/              OPC_EmitMergeInputChains1_0,
/* 19460*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19463*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19473*/            /*Scope*/ 40, /*->19514*/
/* 19474*/              OPC_MoveChild0,
/* 19475*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 19478*/              OPC_RecordChild0, // #1 = $off
/* 19479*/              OPC_MoveChild0,
/* 19480*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 19483*/              OPC_MoveParent,
/* 19484*/              OPC_MoveParent,
/* 19485*/              OPC_RecordChild1, // #2 = $addr
/* 19486*/              OPC_CheckType, MVT::i32,
/* 19488*/              OPC_MoveParent,
/* 19489*/              OPC_MoveChild2,
/* 19490*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19493*/              OPC_RecordChild0, // #3 = $val
/* 19494*/              OPC_MoveParent,
/* 19495*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_or_32
/* 19497*/              OPC_MoveParent,
/* 19498*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19500*/              OPC_EmitMergeInputChains1_0,
/* 19501*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19504*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19514*/            /*Scope*/ 39, /*->19554*/
/* 19515*/              OPC_RecordChild0, // #1 = $addr
/* 19516*/              OPC_RecordChild1, // #2 = $off
/* 19517*/              OPC_MoveChild1,
/* 19518*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 19521*/              OPC_MoveParent,
/* 19522*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 19524*/              OPC_CheckType, MVT::i32,
/* 19526*/              OPC_MoveParent,
/* 19527*/              OPC_MoveChild2,
/* 19528*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19531*/              OPC_RecordChild0, // #3 = $val
/* 19532*/              OPC_MoveParent,
/* 19533*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_or_32
/* 19535*/              OPC_MoveParent,
/* 19536*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19538*/              OPC_EmitMergeInputChains1_0,
/* 19539*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19542*/              OPC_EmitConvertToTarget, 2,
/* 19544*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_32>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW32_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19554*/            0, /*End of Scope*/
/* 19555*/          /*SwitchOpcode*/ 39, TARGET_VAL(ISD::OR),// ->19597
/* 19558*/            OPC_RecordChild0, // #1 = $addr
/* 19559*/            OPC_RecordChild1, // #2 = $off
/* 19560*/            OPC_MoveChild1,
/* 19561*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 19564*/            OPC_MoveParent,
/* 19565*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 19567*/            OPC_CheckType, MVT::i32,
/* 19569*/            OPC_MoveParent,
/* 19570*/            OPC_MoveChild2,
/* 19571*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19574*/            OPC_RecordChild0, // #3 = $val
/* 19575*/            OPC_MoveParent,
/* 19576*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_or_32
/* 19578*/            OPC_MoveParent,
/* 19579*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19581*/            OPC_EmitMergeInputChains1_0,
/* 19582*/            OPC_EmitInteger, MVT::i32, 0, 
/* 19585*/            OPC_EmitConvertToTarget, 2,
/* 19587*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                      // Src: (zext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_32>>) - Complexity = 17
                      // Dst: (ATOMIC_RMW32_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19597*/          /*SwitchOpcode*/ 84, TARGET_VAL(WebAssemblyISD::Wrapper),// ->19684
/* 19600*/            OPC_RecordChild0, // #1 = $off
/* 19601*/            OPC_MoveChild0,
/* 19602*/            OPC_SwitchOpcode /*2 cases */, 37, TARGET_VAL(ISD::TargetGlobalAddress),// ->19643
/* 19606*/              OPC_MoveParent,
/* 19607*/              OPC_MoveParent,
/* 19608*/              OPC_MoveChild2,
/* 19609*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19612*/              OPC_RecordChild0, // #2 = $val
/* 19613*/              OPC_MoveParent,
/* 19614*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_or_32
/* 19616*/              OPC_MoveParent,
/* 19617*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19619*/              OPC_EmitMergeInputChains1_0,
/* 19620*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19623*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19626*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 19633*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_32>>) - Complexity = 16
                        // Dst: (ATOMIC_RMW32_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 19643*/            /*SwitchOpcode*/ 37, TARGET_VAL(ISD::TargetExternalSymbol),// ->19683
/* 19646*/              OPC_MoveParent,
/* 19647*/              OPC_MoveParent,
/* 19648*/              OPC_MoveChild2,
/* 19649*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19652*/              OPC_RecordChild0, // #2 = $val
/* 19653*/              OPC_MoveParent,
/* 19654*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_or_32
/* 19656*/              OPC_MoveParent,
/* 19657*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19659*/              OPC_EmitMergeInputChains1_0,
/* 19660*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19663*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19666*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 19673*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_32>>) - Complexity = 16
                        // Dst: (ATOMIC_RMW32_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 19683*/            0, // EndSwitchOpcode
/* 19684*/          0, // EndSwitchOpcode
/* 19685*/        /*Scope*/ 77, /*->19763*/
/* 19686*/          OPC_RecordChild1, // #1 = $off
/* 19687*/          OPC_Scope, 42, /*->19731*/ // 2 children in Scope
/* 19689*/            OPC_MoveChild1,
/* 19690*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 19693*/            OPC_MoveParent,
/* 19694*/            OPC_MoveChild2,
/* 19695*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19698*/            OPC_RecordChild0, // #2 = $val
/* 19699*/            OPC_MoveParent,
/* 19700*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_or_32
/* 19702*/            OPC_MoveParent,
/* 19703*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19705*/            OPC_EmitMergeInputChains1_0,
/* 19706*/            OPC_EmitInteger, MVT::i32, 0, 
/* 19709*/            OPC_EmitConvertToTarget, 1,
/* 19711*/            OPC_EmitInteger, MVT::i32, 0, 
/* 19714*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 19721*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                      // Src: (zext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_32>>) - Complexity = 13
                      // Dst: (ATOMIC_RMW32_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 19731*/          /*Scope*/ 30, /*->19762*/
/* 19732*/            OPC_CheckChild1Type, MVT::i32,
/* 19734*/            OPC_MoveChild2,
/* 19735*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19738*/            OPC_RecordChild0, // #2 = $val
/* 19739*/            OPC_MoveParent,
/* 19740*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_or_32
/* 19742*/            OPC_MoveParent,
/* 19743*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19745*/            OPC_EmitMergeInputChains1_0,
/* 19746*/            OPC_EmitInteger, MVT::i32, 0, 
/* 19749*/            OPC_EmitInteger, MVT::i32, 0, 
/* 19752*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                      // Src: (zext:{ *:[i64] } (atomic_load_or:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_32>>) - Complexity = 10
                      // Dst: (ATOMIC_RMW32_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19762*/          0, /*End of Scope*/
/* 19763*/        0, /*End of Scope*/
/* 19764*/      /*SwitchOpcode*/ 46|128,3/*430*/, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),// ->20198
/* 19768*/        OPC_RecordMemRef,
/* 19769*/        OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 19770*/        OPC_Scope, 90|128,2/*346*/, /*->20119*/ // 2 children in Scope
/* 19773*/          OPC_MoveChild1,
/* 19774*/          OPC_SwitchOpcode /*3 cases */, 82|128,1/*210*/, TARGET_VAL(ISD::ADD),// ->19989
/* 19779*/            OPC_Scope, 42, /*->19823*/ // 5 children in Scope
/* 19781*/              OPC_RecordChild0, // #1 = $addr
/* 19782*/              OPC_MoveChild1,
/* 19783*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 19786*/              OPC_RecordChild0, // #2 = $off
/* 19787*/              OPC_MoveChild0,
/* 19788*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 19791*/              OPC_MoveParent,
/* 19792*/              OPC_MoveParent,
/* 19793*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 19795*/              OPC_CheckType, MVT::i32,
/* 19797*/              OPC_MoveParent,
/* 19798*/              OPC_MoveChild2,
/* 19799*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19802*/              OPC_RecordChild0, // #3 = $val
/* 19803*/              OPC_MoveParent,
/* 19804*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_xor_32
/* 19806*/              OPC_MoveParent,
/* 19807*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19809*/              OPC_EmitMergeInputChains1_0,
/* 19810*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19813*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_32>>) - Complexity = 20
                        // Dst: (ATOMIC_RMW32_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19823*/            /*Scope*/ 42, /*->19866*/
/* 19824*/              OPC_MoveChild0,
/* 19825*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 19828*/              OPC_RecordChild0, // #1 = $off
/* 19829*/              OPC_MoveChild0,
/* 19830*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 19833*/              OPC_MoveParent,
/* 19834*/              OPC_MoveParent,
/* 19835*/              OPC_RecordChild1, // #2 = $addr
/* 19836*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 19838*/              OPC_CheckType, MVT::i32,
/* 19840*/              OPC_MoveParent,
/* 19841*/              OPC_MoveChild2,
/* 19842*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19845*/              OPC_RecordChild0, // #3 = $val
/* 19846*/              OPC_MoveParent,
/* 19847*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_xor_32
/* 19849*/              OPC_MoveParent,
/* 19850*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19852*/              OPC_EmitMergeInputChains1_0,
/* 19853*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19856*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_32>>) - Complexity = 20
                        // Dst: (ATOMIC_RMW32_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19866*/            /*Scope*/ 40, /*->19907*/
/* 19867*/              OPC_RecordChild0, // #1 = $addr
/* 19868*/              OPC_MoveChild1,
/* 19869*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 19872*/              OPC_RecordChild0, // #2 = $off
/* 19873*/              OPC_MoveChild0,
/* 19874*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 19877*/              OPC_MoveParent,
/* 19878*/              OPC_MoveParent,
/* 19879*/              OPC_CheckType, MVT::i32,
/* 19881*/              OPC_MoveParent,
/* 19882*/              OPC_MoveChild2,
/* 19883*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19886*/              OPC_RecordChild0, // #3 = $val
/* 19887*/              OPC_MoveParent,
/* 19888*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_xor_32
/* 19890*/              OPC_MoveParent,
/* 19891*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19893*/              OPC_EmitMergeInputChains1_0,
/* 19894*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19897*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19907*/            /*Scope*/ 40, /*->19948*/
/* 19908*/              OPC_MoveChild0,
/* 19909*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 19912*/              OPC_RecordChild0, // #1 = $off
/* 19913*/              OPC_MoveChild0,
/* 19914*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 19917*/              OPC_MoveParent,
/* 19918*/              OPC_MoveParent,
/* 19919*/              OPC_RecordChild1, // #2 = $addr
/* 19920*/              OPC_CheckType, MVT::i32,
/* 19922*/              OPC_MoveParent,
/* 19923*/              OPC_MoveChild2,
/* 19924*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19927*/              OPC_RecordChild0, // #3 = $val
/* 19928*/              OPC_MoveParent,
/* 19929*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_xor_32
/* 19931*/              OPC_MoveParent,
/* 19932*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19934*/              OPC_EmitMergeInputChains1_0,
/* 19935*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19938*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19948*/            /*Scope*/ 39, /*->19988*/
/* 19949*/              OPC_RecordChild0, // #1 = $addr
/* 19950*/              OPC_RecordChild1, // #2 = $off
/* 19951*/              OPC_MoveChild1,
/* 19952*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 19955*/              OPC_MoveParent,
/* 19956*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 19958*/              OPC_CheckType, MVT::i32,
/* 19960*/              OPC_MoveParent,
/* 19961*/              OPC_MoveChild2,
/* 19962*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 19965*/              OPC_RecordChild0, // #3 = $val
/* 19966*/              OPC_MoveParent,
/* 19967*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_xor_32
/* 19969*/              OPC_MoveParent,
/* 19970*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 19972*/              OPC_EmitMergeInputChains1_0,
/* 19973*/              OPC_EmitInteger, MVT::i32, 0, 
/* 19976*/              OPC_EmitConvertToTarget, 2,
/* 19978*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_32>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW32_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 19988*/            0, /*End of Scope*/
/* 19989*/          /*SwitchOpcode*/ 39, TARGET_VAL(ISD::OR),// ->20031
/* 19992*/            OPC_RecordChild0, // #1 = $addr
/* 19993*/            OPC_RecordChild1, // #2 = $off
/* 19994*/            OPC_MoveChild1,
/* 19995*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 19998*/            OPC_MoveParent,
/* 19999*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 20001*/            OPC_CheckType, MVT::i32,
/* 20003*/            OPC_MoveParent,
/* 20004*/            OPC_MoveChild2,
/* 20005*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20008*/            OPC_RecordChild0, // #3 = $val
/* 20009*/            OPC_MoveParent,
/* 20010*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_xor_32
/* 20012*/            OPC_MoveParent,
/* 20013*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20015*/            OPC_EmitMergeInputChains1_0,
/* 20016*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20019*/            OPC_EmitConvertToTarget, 2,
/* 20021*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                      // Src: (zext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_32>>) - Complexity = 17
                      // Dst: (ATOMIC_RMW32_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 20031*/          /*SwitchOpcode*/ 84, TARGET_VAL(WebAssemblyISD::Wrapper),// ->20118
/* 20034*/            OPC_RecordChild0, // #1 = $off
/* 20035*/            OPC_MoveChild0,
/* 20036*/            OPC_SwitchOpcode /*2 cases */, 37, TARGET_VAL(ISD::TargetGlobalAddress),// ->20077
/* 20040*/              OPC_MoveParent,
/* 20041*/              OPC_MoveParent,
/* 20042*/              OPC_MoveChild2,
/* 20043*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20046*/              OPC_RecordChild0, // #2 = $val
/* 20047*/              OPC_MoveParent,
/* 20048*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_xor_32
/* 20050*/              OPC_MoveParent,
/* 20051*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20053*/              OPC_EmitMergeInputChains1_0,
/* 20054*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20057*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20060*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 20067*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_32>>) - Complexity = 16
                        // Dst: (ATOMIC_RMW32_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 20077*/            /*SwitchOpcode*/ 37, TARGET_VAL(ISD::TargetExternalSymbol),// ->20117
/* 20080*/              OPC_MoveParent,
/* 20081*/              OPC_MoveParent,
/* 20082*/              OPC_MoveChild2,
/* 20083*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20086*/              OPC_RecordChild0, // #2 = $val
/* 20087*/              OPC_MoveParent,
/* 20088*/              OPC_CheckPredicate, 7, // Predicate_atomic_load_xor_32
/* 20090*/              OPC_MoveParent,
/* 20091*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20093*/              OPC_EmitMergeInputChains1_0,
/* 20094*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20097*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20100*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 20107*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_32>>) - Complexity = 16
                        // Dst: (ATOMIC_RMW32_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 20117*/            0, // EndSwitchOpcode
/* 20118*/          0, // EndSwitchOpcode
/* 20119*/        /*Scope*/ 77, /*->20197*/
/* 20120*/          OPC_RecordChild1, // #1 = $off
/* 20121*/          OPC_Scope, 42, /*->20165*/ // 2 children in Scope
/* 20123*/            OPC_MoveChild1,
/* 20124*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 20127*/            OPC_MoveParent,
/* 20128*/            OPC_MoveChild2,
/* 20129*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20132*/            OPC_RecordChild0, // #2 = $val
/* 20133*/            OPC_MoveParent,
/* 20134*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_xor_32
/* 20136*/            OPC_MoveParent,
/* 20137*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20139*/            OPC_EmitMergeInputChains1_0,
/* 20140*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20143*/            OPC_EmitConvertToTarget, 1,
/* 20145*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20148*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 20155*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                      // Src: (zext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_32>>) - Complexity = 13
                      // Dst: (ATOMIC_RMW32_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 20165*/          /*Scope*/ 30, /*->20196*/
/* 20166*/            OPC_CheckChild1Type, MVT::i32,
/* 20168*/            OPC_MoveChild2,
/* 20169*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20172*/            OPC_RecordChild0, // #2 = $val
/* 20173*/            OPC_MoveParent,
/* 20174*/            OPC_CheckPredicate, 7, // Predicate_atomic_load_xor_32
/* 20176*/            OPC_MoveParent,
/* 20177*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20179*/            OPC_EmitMergeInputChains1_0,
/* 20180*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20183*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20186*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                      // Src: (zext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_32>>) - Complexity = 10
                      // Dst: (ATOMIC_RMW32_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 20196*/          0, /*End of Scope*/
/* 20197*/        0, /*End of Scope*/
/* 20198*/      /*SwitchOpcode*/ 46|128,3/*430*/, TARGET_VAL(ISD::ATOMIC_SWAP),// ->20632
/* 20202*/        OPC_RecordMemRef,
/* 20203*/        OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 20204*/        OPC_Scope, 90|128,2/*346*/, /*->20553*/ // 2 children in Scope
/* 20207*/          OPC_MoveChild1,
/* 20208*/          OPC_SwitchOpcode /*3 cases */, 82|128,1/*210*/, TARGET_VAL(ISD::ADD),// ->20423
/* 20213*/            OPC_Scope, 42, /*->20257*/ // 5 children in Scope
/* 20215*/              OPC_RecordChild0, // #1 = $addr
/* 20216*/              OPC_MoveChild1,
/* 20217*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 20220*/              OPC_RecordChild0, // #2 = $off
/* 20221*/              OPC_MoveChild0,
/* 20222*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 20225*/              OPC_MoveParent,
/* 20226*/              OPC_MoveParent,
/* 20227*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 20229*/              OPC_CheckType, MVT::i32,
/* 20231*/              OPC_MoveParent,
/* 20232*/              OPC_MoveChild2,
/* 20233*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20236*/              OPC_RecordChild0, // #3 = $val
/* 20237*/              OPC_MoveParent,
/* 20238*/              OPC_CheckPredicate, 7, // Predicate_atomic_swap_32
/* 20240*/              OPC_MoveParent,
/* 20241*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20243*/              OPC_EmitMergeInputChains1_0,
/* 20244*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20247*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_32>>) - Complexity = 20
                        // Dst: (ATOMIC_RMW32_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 20257*/            /*Scope*/ 42, /*->20300*/
/* 20258*/              OPC_MoveChild0,
/* 20259*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 20262*/              OPC_RecordChild0, // #1 = $off
/* 20263*/              OPC_MoveChild0,
/* 20264*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 20267*/              OPC_MoveParent,
/* 20268*/              OPC_MoveParent,
/* 20269*/              OPC_RecordChild1, // #2 = $addr
/* 20270*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 20272*/              OPC_CheckType, MVT::i32,
/* 20274*/              OPC_MoveParent,
/* 20275*/              OPC_MoveChild2,
/* 20276*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20279*/              OPC_RecordChild0, // #3 = $val
/* 20280*/              OPC_MoveParent,
/* 20281*/              OPC_CheckPredicate, 7, // Predicate_atomic_swap_32
/* 20283*/              OPC_MoveParent,
/* 20284*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20286*/              OPC_EmitMergeInputChains1_0,
/* 20287*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20290*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_32>>) - Complexity = 20
                        // Dst: (ATOMIC_RMW32_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 20300*/            /*Scope*/ 40, /*->20341*/
/* 20301*/              OPC_RecordChild0, // #1 = $addr
/* 20302*/              OPC_MoveChild1,
/* 20303*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 20306*/              OPC_RecordChild0, // #2 = $off
/* 20307*/              OPC_MoveChild0,
/* 20308*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 20311*/              OPC_MoveParent,
/* 20312*/              OPC_MoveParent,
/* 20313*/              OPC_CheckType, MVT::i32,
/* 20315*/              OPC_MoveParent,
/* 20316*/              OPC_MoveChild2,
/* 20317*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20320*/              OPC_RecordChild0, // #3 = $val
/* 20321*/              OPC_MoveParent,
/* 20322*/              OPC_CheckPredicate, 7, // Predicate_atomic_swap_32
/* 20324*/              OPC_MoveParent,
/* 20325*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20327*/              OPC_EmitMergeInputChains1_0,
/* 20328*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20331*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 20341*/            /*Scope*/ 40, /*->20382*/
/* 20342*/              OPC_MoveChild0,
/* 20343*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 20346*/              OPC_RecordChild0, // #1 = $off
/* 20347*/              OPC_MoveChild0,
/* 20348*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 20351*/              OPC_MoveParent,
/* 20352*/              OPC_MoveParent,
/* 20353*/              OPC_RecordChild1, // #2 = $addr
/* 20354*/              OPC_CheckType, MVT::i32,
/* 20356*/              OPC_MoveParent,
/* 20357*/              OPC_MoveChild2,
/* 20358*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20361*/              OPC_RecordChild0, // #3 = $val
/* 20362*/              OPC_MoveParent,
/* 20363*/              OPC_CheckPredicate, 7, // Predicate_atomic_swap_32
/* 20365*/              OPC_MoveParent,
/* 20366*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20368*/              OPC_EmitMergeInputChains1_0,
/* 20369*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20372*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_32>>) - Complexity = 19
                        // Dst: (ATOMIC_RMW32_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 20382*/            /*Scope*/ 39, /*->20422*/
/* 20383*/              OPC_RecordChild0, // #1 = $addr
/* 20384*/              OPC_RecordChild1, // #2 = $off
/* 20385*/              OPC_MoveChild1,
/* 20386*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 20389*/              OPC_MoveParent,
/* 20390*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 20392*/              OPC_CheckType, MVT::i32,
/* 20394*/              OPC_MoveParent,
/* 20395*/              OPC_MoveChild2,
/* 20396*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20399*/              OPC_RecordChild0, // #3 = $val
/* 20400*/              OPC_MoveParent,
/* 20401*/              OPC_CheckPredicate, 7, // Predicate_atomic_swap_32
/* 20403*/              OPC_MoveParent,
/* 20404*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20406*/              OPC_EmitMergeInputChains1_0,
/* 20407*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20410*/              OPC_EmitConvertToTarget, 2,
/* 20412*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (zext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_32>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW32_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 20422*/            0, /*End of Scope*/
/* 20423*/          /*SwitchOpcode*/ 39, TARGET_VAL(ISD::OR),// ->20465
/* 20426*/            OPC_RecordChild0, // #1 = $addr
/* 20427*/            OPC_RecordChild1, // #2 = $off
/* 20428*/            OPC_MoveChild1,
/* 20429*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 20432*/            OPC_MoveParent,
/* 20433*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 20435*/            OPC_CheckType, MVT::i32,
/* 20437*/            OPC_MoveParent,
/* 20438*/            OPC_MoveChild2,
/* 20439*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20442*/            OPC_RecordChild0, // #3 = $val
/* 20443*/            OPC_MoveParent,
/* 20444*/            OPC_CheckPredicate, 7, // Predicate_atomic_swap_32
/* 20446*/            OPC_MoveParent,
/* 20447*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20449*/            OPC_EmitMergeInputChains1_0,
/* 20450*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20453*/            OPC_EmitConvertToTarget, 2,
/* 20455*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                      // Src: (zext:{ *:[i64] } (atomic_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_32>>) - Complexity = 17
                      // Dst: (ATOMIC_RMW32_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 20465*/          /*SwitchOpcode*/ 84, TARGET_VAL(WebAssemblyISD::Wrapper),// ->20552
/* 20468*/            OPC_RecordChild0, // #1 = $off
/* 20469*/            OPC_MoveChild0,
/* 20470*/            OPC_SwitchOpcode /*2 cases */, 37, TARGET_VAL(ISD::TargetGlobalAddress),// ->20511
/* 20474*/              OPC_MoveParent,
/* 20475*/              OPC_MoveParent,
/* 20476*/              OPC_MoveChild2,
/* 20477*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20480*/              OPC_RecordChild0, // #2 = $val
/* 20481*/              OPC_MoveParent,
/* 20482*/              OPC_CheckPredicate, 7, // Predicate_atomic_swap_32
/* 20484*/              OPC_MoveParent,
/* 20485*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20487*/              OPC_EmitMergeInputChains1_0,
/* 20488*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20491*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20494*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 20501*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_32>>) - Complexity = 16
                        // Dst: (ATOMIC_RMW32_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 20511*/            /*SwitchOpcode*/ 37, TARGET_VAL(ISD::TargetExternalSymbol),// ->20551
/* 20514*/              OPC_MoveParent,
/* 20515*/              OPC_MoveParent,
/* 20516*/              OPC_MoveChild2,
/* 20517*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20520*/              OPC_RecordChild0, // #2 = $val
/* 20521*/              OPC_MoveParent,
/* 20522*/              OPC_CheckPredicate, 7, // Predicate_atomic_swap_32
/* 20524*/              OPC_MoveParent,
/* 20525*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20527*/              OPC_EmitMergeInputChains1_0,
/* 20528*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20531*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20534*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 20541*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_32>>) - Complexity = 16
                        // Dst: (ATOMIC_RMW32_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 20551*/            0, // EndSwitchOpcode
/* 20552*/          0, // EndSwitchOpcode
/* 20553*/        /*Scope*/ 77, /*->20631*/
/* 20554*/          OPC_RecordChild1, // #1 = $off
/* 20555*/          OPC_Scope, 42, /*->20599*/ // 2 children in Scope
/* 20557*/            OPC_MoveChild1,
/* 20558*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 20561*/            OPC_MoveParent,
/* 20562*/            OPC_MoveChild2,
/* 20563*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20566*/            OPC_RecordChild0, // #2 = $val
/* 20567*/            OPC_MoveParent,
/* 20568*/            OPC_CheckPredicate, 7, // Predicate_atomic_swap_32
/* 20570*/            OPC_MoveParent,
/* 20571*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20573*/            OPC_EmitMergeInputChains1_0,
/* 20574*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20577*/            OPC_EmitConvertToTarget, 1,
/* 20579*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20582*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 20589*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                      // Src: (zext:{ *:[i64] } (atomic_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_32>>) - Complexity = 13
                      // Dst: (ATOMIC_RMW32_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 20599*/          /*Scope*/ 30, /*->20630*/
/* 20600*/            OPC_CheckChild1Type, MVT::i32,
/* 20602*/            OPC_MoveChild2,
/* 20603*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 20606*/            OPC_RecordChild0, // #2 = $val
/* 20607*/            OPC_MoveParent,
/* 20608*/            OPC_CheckPredicate, 7, // Predicate_atomic_swap_32
/* 20610*/            OPC_MoveParent,
/* 20611*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20613*/            OPC_EmitMergeInputChains1_0,
/* 20614*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20617*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20620*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW32_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                      // Src: (zext:{ *:[i64] } (atomic_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_32>>) - Complexity = 10
                      // Dst: (ATOMIC_RMW32_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 20630*/          0, /*End of Scope*/
/* 20631*/        0, /*End of Scope*/
/* 20632*/      /*SwitchOpcode*/ 84|128,2/*340*/, TARGET_VAL(ISD::ATOMIC_LOAD),// ->20976
/* 20636*/        OPC_RecordMemRef,
/* 20637*/        OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 20638*/        OPC_Scope, 18|128,2/*274*/, /*->20915*/ // 2 children in Scope
/* 20641*/          OPC_MoveChild1,
/* 20642*/          OPC_SwitchOpcode /*3 cases */, 37|128,1/*165*/, TARGET_VAL(ISD::ADD),// ->20812
/* 20647*/            OPC_Scope, 33, /*->20682*/ // 5 children in Scope
/* 20649*/              OPC_RecordChild0, // #1 = $addr
/* 20650*/              OPC_MoveChild1,
/* 20651*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 20654*/              OPC_RecordChild0, // #2 = $off
/* 20655*/              OPC_MoveChild0,
/* 20656*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 20659*/              OPC_MoveParent,
/* 20660*/              OPC_MoveParent,
/* 20661*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 20663*/              OPC_CheckType, MVT::i32,
/* 20665*/              OPC_MoveParent,
/* 20666*/              OPC_MoveParent,
/* 20667*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20669*/              OPC_EmitMergeInputChains1_0,
/* 20670*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20673*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD32_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 3, 2, 1, 
                        // Src: (zext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>)) - Complexity = 16
                        // Dst: (ATOMIC_LOAD32_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 20682*/            /*Scope*/ 33, /*->20716*/
/* 20683*/              OPC_MoveChild0,
/* 20684*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 20687*/              OPC_RecordChild0, // #1 = $off
/* 20688*/              OPC_MoveChild0,
/* 20689*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 20692*/              OPC_MoveParent,
/* 20693*/              OPC_MoveParent,
/* 20694*/              OPC_RecordChild1, // #2 = $addr
/* 20695*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 20697*/              OPC_CheckType, MVT::i32,
/* 20699*/              OPC_MoveParent,
/* 20700*/              OPC_MoveParent,
/* 20701*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20703*/              OPC_EmitMergeInputChains1_0,
/* 20704*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20707*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD32_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 3, 1, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>)) - Complexity = 16
                        // Dst: (ATOMIC_LOAD32_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 20716*/            /*Scope*/ 31, /*->20748*/
/* 20717*/              OPC_RecordChild0, // #1 = $addr
/* 20718*/              OPC_MoveChild1,
/* 20719*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 20722*/              OPC_RecordChild0, // #2 = $off
/* 20723*/              OPC_MoveChild0,
/* 20724*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 20727*/              OPC_MoveParent,
/* 20728*/              OPC_MoveParent,
/* 20729*/              OPC_CheckType, MVT::i32,
/* 20731*/              OPC_MoveParent,
/* 20732*/              OPC_MoveParent,
/* 20733*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20735*/              OPC_EmitMergeInputChains1_0,
/* 20736*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20739*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD32_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 3, 2, 1, 
                        // Src: (zext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)))) - Complexity = 15
                        // Dst: (ATOMIC_LOAD32_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 20748*/            /*Scope*/ 31, /*->20780*/
/* 20749*/              OPC_MoveChild0,
/* 20750*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 20753*/              OPC_RecordChild0, // #1 = $off
/* 20754*/              OPC_MoveChild0,
/* 20755*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 20758*/              OPC_MoveParent,
/* 20759*/              OPC_MoveParent,
/* 20760*/              OPC_RecordChild1, // #2 = $addr
/* 20761*/              OPC_CheckType, MVT::i32,
/* 20763*/              OPC_MoveParent,
/* 20764*/              OPC_MoveParent,
/* 20765*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20767*/              OPC_EmitMergeInputChains1_0,
/* 20768*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20771*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD32_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 3, 1, 2, 
                        // Src: (zext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr))) - Complexity = 15
                        // Dst: (ATOMIC_LOAD32_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 20780*/            /*Scope*/ 30, /*->20811*/
/* 20781*/              OPC_RecordChild0, // #1 = $addr
/* 20782*/              OPC_RecordChild1, // #2 = $off
/* 20783*/              OPC_MoveChild1,
/* 20784*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 20787*/              OPC_MoveParent,
/* 20788*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 20790*/              OPC_CheckType, MVT::i32,
/* 20792*/              OPC_MoveParent,
/* 20793*/              OPC_MoveParent,
/* 20794*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20796*/              OPC_EmitMergeInputChains1_0,
/* 20797*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20800*/              OPC_EmitConvertToTarget, 2,
/* 20802*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD32_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 3, 4, 1, 
                        // Src: (zext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>)) - Complexity = 13
                        // Dst: (ATOMIC_LOAD32_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 20811*/            0, /*End of Scope*/
/* 20812*/          /*SwitchOpcode*/ 30, TARGET_VAL(ISD::OR),// ->20845
/* 20815*/            OPC_RecordChild0, // #1 = $addr
/* 20816*/            OPC_RecordChild1, // #2 = $off
/* 20817*/            OPC_MoveChild1,
/* 20818*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 20821*/            OPC_MoveParent,
/* 20822*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 20824*/            OPC_CheckType, MVT::i32,
/* 20826*/            OPC_MoveParent,
/* 20827*/            OPC_MoveParent,
/* 20828*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20830*/            OPC_EmitMergeInputChains1_0,
/* 20831*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20834*/            OPC_EmitConvertToTarget, 2,
/* 20836*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD32_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 3/*#Ops*/, 3, 4, 1, 
                      // Src: (zext:{ *:[i64] } (atomic_load:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>)) - Complexity = 13
                      // Dst: (ATOMIC_LOAD32_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 20845*/          /*SwitchOpcode*/ 66, TARGET_VAL(WebAssemblyISD::Wrapper),// ->20914
/* 20848*/            OPC_RecordChild0, // #1 = $off
/* 20849*/            OPC_MoveChild0,
/* 20850*/            OPC_SwitchOpcode /*2 cases */, 28, TARGET_VAL(ISD::TargetGlobalAddress),// ->20882
/* 20854*/              OPC_MoveParent,
/* 20855*/              OPC_MoveParent,
/* 20856*/              OPC_MoveParent,
/* 20857*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20859*/              OPC_EmitMergeInputChains1_0,
/* 20860*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20863*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20866*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 20873*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD32_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 2, 1, 4, 
                        // Src: (zext:{ *:[i64] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off))) - Complexity = 12
                        // Dst: (ATOMIC_LOAD32_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 20882*/            /*SwitchOpcode*/ 28, TARGET_VAL(ISD::TargetExternalSymbol),// ->20913
/* 20885*/              OPC_MoveParent,
/* 20886*/              OPC_MoveParent,
/* 20887*/              OPC_MoveParent,
/* 20888*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20890*/              OPC_EmitMergeInputChains1_0,
/* 20891*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20894*/              OPC_EmitInteger, MVT::i32, 0, 
/* 20897*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 20904*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD32_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 2, 1, 4, 
                        // Src: (zext:{ *:[i64] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off))) - Complexity = 12
                        // Dst: (ATOMIC_LOAD32_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 20913*/            0, // EndSwitchOpcode
/* 20914*/          0, // EndSwitchOpcode
/* 20915*/        /*Scope*/ 59, /*->20975*/
/* 20916*/          OPC_RecordChild1, // #1 = $off
/* 20917*/          OPC_Scope, 33, /*->20952*/ // 2 children in Scope
/* 20919*/            OPC_MoveChild1,
/* 20920*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 20923*/            OPC_MoveParent,
/* 20924*/            OPC_MoveParent,
/* 20925*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20927*/            OPC_EmitMergeInputChains1_0,
/* 20928*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20931*/            OPC_EmitConvertToTarget, 1,
/* 20933*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20936*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 20943*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD32_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 3/*#Ops*/, 2, 3, 5, 
                      // Src: (zext:{ *:[i64] } (atomic_load:{ *:[i32] } (imm:{ *:[iPTR] }):$off)) - Complexity = 9
                      // Dst: (ATOMIC_LOAD32_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 20952*/          /*Scope*/ 21, /*->20974*/
/* 20953*/            OPC_CheckChild1Type, MVT::i32,
/* 20955*/            OPC_MoveParent,
/* 20956*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 20958*/            OPC_EmitMergeInputChains1_0,
/* 20959*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20962*/            OPC_EmitInteger, MVT::i32, 0, 
/* 20965*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD32_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i64, 3/*#Ops*/, 2, 3, 1, 
                      // Src: (zext:{ *:[i64] } (atomic_load:{ *:[i32] } I32:{ *:[i32] }:$addr)) - Complexity = 6
                      // Dst: (ATOMIC_LOAD32_U_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr)
/* 20974*/          0, /*End of Scope*/
/* 20975*/        0, /*End of Scope*/
/* 20976*/      0, // EndSwitchOpcode
/* 20977*/    /*Scope*/ 8, /*->20986*/
/* 20978*/      OPC_RecordChild0, // #0 = $src
/* 20979*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::I64_EXTEND_U_I32), 0,
                    MVT::i64, 1/*#Ops*/, 0, 
                // Src: (zext:{ *:[i64] } I32:{ *:[i32] }:$src) - Complexity = 3
                // Dst: (I64_EXTEND_U_I32:{ *:[i64] } I32:{ *:[i32] }:$src)
/* 20986*/    0, /*End of Scope*/
/* 20987*/  /*SwitchOpcode*/ 48|128,44/*5680*/, TARGET_VAL(ISD::ANY_EXTEND),// ->26671
/* 20991*/    OPC_Scope, 35|128,44/*5667*/, /*->26661*/ // 2 children in Scope
/* 20994*/      OPC_MoveChild0,
/* 20995*/      OPC_SwitchOpcode /*8 cases */, 38|128,6/*806*/, TARGET_VAL(ISD::AssertZext),// ->21806
/* 21000*/        OPC_MoveChild0,
/* 21001*/        OPC_CheckOpcode, TARGET_VAL(ISD::ATOMIC_CMP_SWAP),
/* 21004*/        OPC_RecordMemRef,
/* 21005*/        OPC_RecordNode, // #0 = 'atomic_cmp_swap' chained node
/* 21006*/        OPC_CheckFoldableChainNode,
/* 21007*/        OPC_Scope, 123|128,4/*635*/, /*->21645*/ // 2 children in Scope
/* 21010*/          OPC_MoveChild1,
/* 21011*/          OPC_SwitchOpcode /*3 cases */, 121|128,2/*377*/, TARGET_VAL(ISD::ADD),// ->21393
/* 21016*/            OPC_Scope, 75, /*->21093*/ // 5 children in Scope
/* 21018*/              OPC_RecordChild0, // #1 = $addr
/* 21019*/              OPC_MoveChild1,
/* 21020*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 21023*/              OPC_RecordChild0, // #2 = $off
/* 21024*/              OPC_MoveChild0,
/* 21025*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 21028*/              OPC_MoveParent,
/* 21029*/              OPC_MoveParent,
/* 21030*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 21032*/              OPC_CheckType, MVT::i32,
/* 21034*/              OPC_MoveParent,
/* 21035*/              OPC_MoveChild2,
/* 21036*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21039*/              OPC_RecordChild0, // #3 = $exp
/* 21040*/              OPC_MoveParent,
/* 21041*/              OPC_MoveChild3,
/* 21042*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21045*/              OPC_RecordChild0, // #4 = $new
/* 21046*/              OPC_MoveParent,
/* 21047*/              OPC_Scope, 21, /*->21070*/ // 2 children in Scope
/* 21049*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 21051*/                OPC_MoveParent,
/* 21052*/                OPC_MoveParent,
/* 21053*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21055*/                OPC_EmitMergeInputChains1_0,
/* 21056*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21059*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 26
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21070*/              /*Scope*/ 21, /*->21092*/
/* 21071*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 21073*/                OPC_MoveParent,
/* 21074*/                OPC_MoveParent,
/* 21075*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21077*/                OPC_EmitMergeInputChains1_0,
/* 21078*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21081*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 26
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21092*/              0, /*End of Scope*/
/* 21093*/            /*Scope*/ 75, /*->21169*/
/* 21094*/              OPC_MoveChild0,
/* 21095*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 21098*/              OPC_RecordChild0, // #1 = $off
/* 21099*/              OPC_MoveChild0,
/* 21100*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 21103*/              OPC_MoveParent,
/* 21104*/              OPC_MoveParent,
/* 21105*/              OPC_RecordChild1, // #2 = $addr
/* 21106*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 21108*/              OPC_CheckType, MVT::i32,
/* 21110*/              OPC_MoveParent,
/* 21111*/              OPC_MoveChild2,
/* 21112*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21115*/              OPC_RecordChild0, // #3 = $exp
/* 21116*/              OPC_MoveParent,
/* 21117*/              OPC_MoveChild3,
/* 21118*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21121*/              OPC_RecordChild0, // #4 = $new
/* 21122*/              OPC_MoveParent,
/* 21123*/              OPC_Scope, 21, /*->21146*/ // 2 children in Scope
/* 21125*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 21127*/                OPC_MoveParent,
/* 21128*/                OPC_MoveParent,
/* 21129*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21131*/                OPC_EmitMergeInputChains1_0,
/* 21132*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21135*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 26
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21146*/              /*Scope*/ 21, /*->21168*/
/* 21147*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 21149*/                OPC_MoveParent,
/* 21150*/                OPC_MoveParent,
/* 21151*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21153*/                OPC_EmitMergeInputChains1_0,
/* 21154*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21157*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 26
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21168*/              0, /*End of Scope*/
/* 21169*/            /*Scope*/ 73, /*->21243*/
/* 21170*/              OPC_RecordChild0, // #1 = $addr
/* 21171*/              OPC_MoveChild1,
/* 21172*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 21175*/              OPC_RecordChild0, // #2 = $off
/* 21176*/              OPC_MoveChild0,
/* 21177*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 21180*/              OPC_MoveParent,
/* 21181*/              OPC_MoveParent,
/* 21182*/              OPC_CheckType, MVT::i32,
/* 21184*/              OPC_MoveParent,
/* 21185*/              OPC_MoveChild2,
/* 21186*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21189*/              OPC_RecordChild0, // #3 = $exp
/* 21190*/              OPC_MoveParent,
/* 21191*/              OPC_MoveChild3,
/* 21192*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21195*/              OPC_RecordChild0, // #4 = $new
/* 21196*/              OPC_MoveParent,
/* 21197*/              OPC_Scope, 21, /*->21220*/ // 2 children in Scope
/* 21199*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 21201*/                OPC_MoveParent,
/* 21202*/                OPC_MoveParent,
/* 21203*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21205*/                OPC_EmitMergeInputChains1_0,
/* 21206*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21209*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 25
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21220*/              /*Scope*/ 21, /*->21242*/
/* 21221*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 21223*/                OPC_MoveParent,
/* 21224*/                OPC_MoveParent,
/* 21225*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21227*/                OPC_EmitMergeInputChains1_0,
/* 21228*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21231*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 25
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21242*/              0, /*End of Scope*/
/* 21243*/            /*Scope*/ 73, /*->21317*/
/* 21244*/              OPC_MoveChild0,
/* 21245*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 21248*/              OPC_RecordChild0, // #1 = $off
/* 21249*/              OPC_MoveChild0,
/* 21250*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 21253*/              OPC_MoveParent,
/* 21254*/              OPC_MoveParent,
/* 21255*/              OPC_RecordChild1, // #2 = $addr
/* 21256*/              OPC_CheckType, MVT::i32,
/* 21258*/              OPC_MoveParent,
/* 21259*/              OPC_MoveChild2,
/* 21260*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21263*/              OPC_RecordChild0, // #3 = $exp
/* 21264*/              OPC_MoveParent,
/* 21265*/              OPC_MoveChild3,
/* 21266*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21269*/              OPC_RecordChild0, // #4 = $new
/* 21270*/              OPC_MoveParent,
/* 21271*/              OPC_Scope, 21, /*->21294*/ // 2 children in Scope
/* 21273*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 21275*/                OPC_MoveParent,
/* 21276*/                OPC_MoveParent,
/* 21277*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21279*/                OPC_EmitMergeInputChains1_0,
/* 21280*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21283*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 25
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21294*/              /*Scope*/ 21, /*->21316*/
/* 21295*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 21297*/                OPC_MoveParent,
/* 21298*/                OPC_MoveParent,
/* 21299*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21301*/                OPC_EmitMergeInputChains1_0,
/* 21302*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21305*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 25
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21316*/              0, /*End of Scope*/
/* 21317*/            /*Scope*/ 74, /*->21392*/
/* 21318*/              OPC_RecordChild0, // #1 = $addr
/* 21319*/              OPC_RecordChild1, // #2 = $off
/* 21320*/              OPC_MoveChild1,
/* 21321*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 21324*/              OPC_MoveParent,
/* 21325*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 21327*/              OPC_CheckType, MVT::i32,
/* 21329*/              OPC_MoveParent,
/* 21330*/              OPC_MoveChild2,
/* 21331*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21334*/              OPC_RecordChild0, // #3 = $exp
/* 21335*/              OPC_MoveParent,
/* 21336*/              OPC_MoveChild3,
/* 21337*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21340*/              OPC_RecordChild0, // #4 = $new
/* 21341*/              OPC_MoveParent,
/* 21342*/              OPC_Scope, 23, /*->21367*/ // 2 children in Scope
/* 21344*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 21346*/                OPC_MoveParent,
/* 21347*/                OPC_MoveParent,
/* 21348*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21350*/                OPC_EmitMergeInputChains1_0,
/* 21351*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21354*/                OPC_EmitConvertToTarget, 2,
/* 21356*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 23
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21367*/              /*Scope*/ 23, /*->21391*/
/* 21368*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 21370*/                OPC_MoveParent,
/* 21371*/                OPC_MoveParent,
/* 21372*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21374*/                OPC_EmitMergeInputChains1_0,
/* 21375*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21378*/                OPC_EmitConvertToTarget, 2,
/* 21380*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 23
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21391*/              0, /*End of Scope*/
/* 21392*/            0, /*End of Scope*/
/* 21393*/          /*SwitchOpcode*/ 74, TARGET_VAL(ISD::OR),// ->21470
/* 21396*/            OPC_RecordChild0, // #1 = $addr
/* 21397*/            OPC_RecordChild1, // #2 = $off
/* 21398*/            OPC_MoveChild1,
/* 21399*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 21402*/            OPC_MoveParent,
/* 21403*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 21405*/            OPC_CheckType, MVT::i32,
/* 21407*/            OPC_MoveParent,
/* 21408*/            OPC_MoveChild2,
/* 21409*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21412*/            OPC_RecordChild0, // #3 = $exp
/* 21413*/            OPC_MoveParent,
/* 21414*/            OPC_MoveChild3,
/* 21415*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21418*/            OPC_RecordChild0, // #4 = $new
/* 21419*/            OPC_MoveParent,
/* 21420*/            OPC_Scope, 23, /*->21445*/ // 2 children in Scope
/* 21422*/              OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 21424*/              OPC_MoveParent,
/* 21425*/              OPC_MoveParent,
/* 21426*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21428*/              OPC_EmitMergeInputChains1_0,
/* 21429*/              OPC_EmitInteger, MVT::i32, 0, 
/* 21432*/              OPC_EmitConvertToTarget, 2,
/* 21434*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                        // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 23
                        // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21445*/            /*Scope*/ 23, /*->21469*/
/* 21446*/              OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 21448*/              OPC_MoveParent,
/* 21449*/              OPC_MoveParent,
/* 21450*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21452*/              OPC_EmitMergeInputChains1_0,
/* 21453*/              OPC_EmitInteger, MVT::i32, 0, 
/* 21456*/              OPC_EmitConvertToTarget, 2,
/* 21458*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                        // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 23
                        // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21469*/            0, /*End of Scope*/
/* 21470*/          /*SwitchOpcode*/ 42|128,1/*170*/, TARGET_VAL(WebAssemblyISD::Wrapper),// ->21644
/* 21474*/            OPC_RecordChild0, // #1 = $off
/* 21475*/            OPC_MoveChild0,
/* 21476*/            OPC_SwitchOpcode /*2 cases */, 80, TARGET_VAL(ISD::TargetGlobalAddress),// ->21560
/* 21480*/              OPC_MoveParent,
/* 21481*/              OPC_MoveParent,
/* 21482*/              OPC_MoveChild2,
/* 21483*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21486*/              OPC_RecordChild0, // #2 = $exp
/* 21487*/              OPC_MoveParent,
/* 21488*/              OPC_MoveChild3,
/* 21489*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21492*/              OPC_RecordChild0, // #3 = $new
/* 21493*/              OPC_MoveParent,
/* 21494*/              OPC_Scope, 31, /*->21527*/ // 2 children in Scope
/* 21496*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 21498*/                OPC_MoveParent,
/* 21499*/                OPC_MoveParent,
/* 21500*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21502*/                OPC_EmitMergeInputChains1_0,
/* 21503*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21506*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21509*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 21516*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 22
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21527*/              /*Scope*/ 31, /*->21559*/
/* 21528*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 21530*/                OPC_MoveParent,
/* 21531*/                OPC_MoveParent,
/* 21532*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21534*/                OPC_EmitMergeInputChains1_0,
/* 21535*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21538*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21541*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 21548*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 22
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21559*/              0, /*End of Scope*/
/* 21560*/            /*SwitchOpcode*/ 80, TARGET_VAL(ISD::TargetExternalSymbol),// ->21643
/* 21563*/              OPC_MoveParent,
/* 21564*/              OPC_MoveParent,
/* 21565*/              OPC_MoveChild2,
/* 21566*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21569*/              OPC_RecordChild0, // #2 = $exp
/* 21570*/              OPC_MoveParent,
/* 21571*/              OPC_MoveChild3,
/* 21572*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21575*/              OPC_RecordChild0, // #3 = $new
/* 21576*/              OPC_MoveParent,
/* 21577*/              OPC_Scope, 31, /*->21610*/ // 2 children in Scope
/* 21579*/                OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 21581*/                OPC_MoveParent,
/* 21582*/                OPC_MoveParent,
/* 21583*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21585*/                OPC_EmitMergeInputChains1_0,
/* 21586*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21589*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21592*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 21599*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 22
                          // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21610*/              /*Scope*/ 31, /*->21642*/
/* 21611*/                OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 21613*/                OPC_MoveParent,
/* 21614*/                OPC_MoveParent,
/* 21615*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21617*/                OPC_EmitMergeInputChains1_0,
/* 21618*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21621*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21624*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 21631*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 22
                          // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21642*/              0, /*End of Scope*/
/* 21643*/            0, // EndSwitchOpcode
/* 21644*/          0, // EndSwitchOpcode
/* 21645*/        /*Scope*/ 30|128,1/*158*/, /*->21805*/
/* 21647*/          OPC_RecordChild1, // #1 = $off
/* 21648*/          OPC_Scope, 87, /*->21737*/ // 2 children in Scope
/* 21650*/            OPC_MoveChild1,
/* 21651*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 21654*/            OPC_MoveParent,
/* 21655*/            OPC_MoveChild2,
/* 21656*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21659*/            OPC_RecordChild0, // #2 = $exp
/* 21660*/            OPC_MoveParent,
/* 21661*/            OPC_MoveChild3,
/* 21662*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21665*/            OPC_RecordChild0, // #3 = $new
/* 21666*/            OPC_MoveParent,
/* 21667*/            OPC_Scope, 33, /*->21702*/ // 2 children in Scope
/* 21669*/              OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 21671*/              OPC_MoveParent,
/* 21672*/              OPC_MoveParent,
/* 21673*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21675*/              OPC_EmitMergeInputChains1_0,
/* 21676*/              OPC_EmitInteger, MVT::i32, 0, 
/* 21679*/              OPC_EmitConvertToTarget, 1,
/* 21681*/              OPC_EmitInteger, MVT::i32, 0, 
/* 21684*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 6,  // Results = #7
/* 21691*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 4, 5, 7, 2, 3, 
                        // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 19
                        // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21702*/            /*Scope*/ 33, /*->21736*/
/* 21703*/              OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 21705*/              OPC_MoveParent,
/* 21706*/              OPC_MoveParent,
/* 21707*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21709*/              OPC_EmitMergeInputChains1_0,
/* 21710*/              OPC_EmitInteger, MVT::i32, 0, 
/* 21713*/              OPC_EmitConvertToTarget, 1,
/* 21715*/              OPC_EmitInteger, MVT::i32, 0, 
/* 21718*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 6,  // Results = #7
/* 21725*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 4, 5, 7, 2, 3, 
                        // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 19
                        // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21736*/            0, /*End of Scope*/
/* 21737*/          /*Scope*/ 66, /*->21804*/
/* 21738*/            OPC_CheckChild1Type, MVT::i32,
/* 21740*/            OPC_MoveChild2,
/* 21741*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21744*/            OPC_RecordChild0, // #2 = $exp
/* 21745*/            OPC_MoveParent,
/* 21746*/            OPC_MoveChild3,
/* 21747*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21750*/            OPC_RecordChild0, // #3 = $new
/* 21751*/            OPC_MoveParent,
/* 21752*/            OPC_Scope, 24, /*->21778*/ // 2 children in Scope
/* 21754*/              OPC_CheckPredicate, 1, // Predicate_atomic_cmp_swap_8
/* 21756*/              OPC_MoveParent,
/* 21757*/              OPC_MoveParent,
/* 21758*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21760*/              OPC_EmitMergeInputChains1_0,
/* 21761*/              OPC_EmitInteger, MVT::i32, 0, 
/* 21764*/              OPC_EmitInteger, MVT::i32, 0, 
/* 21767*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 4, 5, 1, 2, 3, 
                        // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_8>>)) - Complexity = 16
                        // Dst: (ATOMIC_RMW8_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21778*/            /*Scope*/ 24, /*->21803*/
/* 21779*/              OPC_CheckPredicate, 2, // Predicate_atomic_cmp_swap_16
/* 21781*/              OPC_MoveParent,
/* 21782*/              OPC_MoveParent,
/* 21783*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21785*/              OPC_EmitMergeInputChains1_0,
/* 21786*/              OPC_EmitInteger, MVT::i32, 0, 
/* 21789*/              OPC_EmitInteger, MVT::i32, 0, 
/* 21792*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_CMPXCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 5/*#Ops*/, 4, 5, 1, 2, 3, 
                        // Src: (anyext:{ *:[i64] } (assertzext:{ *:[i32] } (atomic_cmp_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$exp), (trunc:{ *:[i32] } i64:{ *:[i64] }:$new))<<P:Predicate_atomic_cmp_swap_16>>)) - Complexity = 16
                        // Dst: (ATOMIC_RMW16_U_CMPXCHG_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, i64:{ *:[i64] }:$new)
/* 21803*/            0, /*End of Scope*/
/* 21804*/          0, /*End of Scope*/
/* 21805*/        0, /*End of Scope*/
/* 21806*/      /*SwitchOpcode*/ 61|128,5/*701*/, TARGET_VAL(ISD::ATOMIC_LOAD_ADD),// ->22511
/* 21810*/        OPC_RecordMemRef,
/* 21811*/        OPC_RecordNode, // #0 = 'atomic_load_add' chained node
/* 21812*/        OPC_Scope, 43|128,4/*555*/, /*->22370*/ // 2 children in Scope
/* 21815*/          OPC_MoveChild1,
/* 21816*/          OPC_SwitchOpcode /*3 cases */, 71|128,2/*327*/, TARGET_VAL(ISD::ADD),// ->22148
/* 21821*/            OPC_Scope, 65, /*->21888*/ // 5 children in Scope
/* 21823*/              OPC_RecordChild0, // #1 = $addr
/* 21824*/              OPC_MoveChild1,
/* 21825*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 21828*/              OPC_RecordChild0, // #2 = $off
/* 21829*/              OPC_MoveChild0,
/* 21830*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 21833*/              OPC_MoveParent,
/* 21834*/              OPC_MoveParent,
/* 21835*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 21837*/              OPC_CheckType, MVT::i32,
/* 21839*/              OPC_MoveParent,
/* 21840*/              OPC_MoveChild2,
/* 21841*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21844*/              OPC_RecordChild0, // #3 = $val
/* 21845*/              OPC_MoveParent,
/* 21846*/              OPC_Scope, 19, /*->21867*/ // 2 children in Scope
/* 21848*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 21850*/                OPC_MoveParent,
/* 21851*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21853*/                OPC_EmitMergeInputChains1_0,
/* 21854*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21857*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 21867*/              /*Scope*/ 19, /*->21887*/
/* 21868*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 21870*/                OPC_MoveParent,
/* 21871*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21873*/                OPC_EmitMergeInputChains1_0,
/* 21874*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21877*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 21887*/              0, /*End of Scope*/
/* 21888*/            /*Scope*/ 65, /*->21954*/
/* 21889*/              OPC_MoveChild0,
/* 21890*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 21893*/              OPC_RecordChild0, // #1 = $off
/* 21894*/              OPC_MoveChild0,
/* 21895*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 21898*/              OPC_MoveParent,
/* 21899*/              OPC_MoveParent,
/* 21900*/              OPC_RecordChild1, // #2 = $addr
/* 21901*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 21903*/              OPC_CheckType, MVT::i32,
/* 21905*/              OPC_MoveParent,
/* 21906*/              OPC_MoveChild2,
/* 21907*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21910*/              OPC_RecordChild0, // #3 = $val
/* 21911*/              OPC_MoveParent,
/* 21912*/              OPC_Scope, 19, /*->21933*/ // 2 children in Scope
/* 21914*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 21916*/                OPC_MoveParent,
/* 21917*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21919*/                OPC_EmitMergeInputChains1_0,
/* 21920*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21923*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 21933*/              /*Scope*/ 19, /*->21953*/
/* 21934*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 21936*/                OPC_MoveParent,
/* 21937*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21939*/                OPC_EmitMergeInputChains1_0,
/* 21940*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21943*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 21953*/              0, /*End of Scope*/
/* 21954*/            /*Scope*/ 63, /*->22018*/
/* 21955*/              OPC_RecordChild0, // #1 = $addr
/* 21956*/              OPC_MoveChild1,
/* 21957*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 21960*/              OPC_RecordChild0, // #2 = $off
/* 21961*/              OPC_MoveChild0,
/* 21962*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 21965*/              OPC_MoveParent,
/* 21966*/              OPC_MoveParent,
/* 21967*/              OPC_CheckType, MVT::i32,
/* 21969*/              OPC_MoveParent,
/* 21970*/              OPC_MoveChild2,
/* 21971*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 21974*/              OPC_RecordChild0, // #3 = $val
/* 21975*/              OPC_MoveParent,
/* 21976*/              OPC_Scope, 19, /*->21997*/ // 2 children in Scope
/* 21978*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 21980*/                OPC_MoveParent,
/* 21981*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 21983*/                OPC_EmitMergeInputChains1_0,
/* 21984*/                OPC_EmitInteger, MVT::i32, 0, 
/* 21987*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 21997*/              /*Scope*/ 19, /*->22017*/
/* 21998*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 22000*/                OPC_MoveParent,
/* 22001*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22003*/                OPC_EmitMergeInputChains1_0,
/* 22004*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22007*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22017*/              0, /*End of Scope*/
/* 22018*/            /*Scope*/ 63, /*->22082*/
/* 22019*/              OPC_MoveChild0,
/* 22020*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 22023*/              OPC_RecordChild0, // #1 = $off
/* 22024*/              OPC_MoveChild0,
/* 22025*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 22028*/              OPC_MoveParent,
/* 22029*/              OPC_MoveParent,
/* 22030*/              OPC_RecordChild1, // #2 = $addr
/* 22031*/              OPC_CheckType, MVT::i32,
/* 22033*/              OPC_MoveParent,
/* 22034*/              OPC_MoveChild2,
/* 22035*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22038*/              OPC_RecordChild0, // #3 = $val
/* 22039*/              OPC_MoveParent,
/* 22040*/              OPC_Scope, 19, /*->22061*/ // 2 children in Scope
/* 22042*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 22044*/                OPC_MoveParent,
/* 22045*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22047*/                OPC_EmitMergeInputChains1_0,
/* 22048*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22051*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22061*/              /*Scope*/ 19, /*->22081*/
/* 22062*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 22064*/                OPC_MoveParent,
/* 22065*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22067*/                OPC_EmitMergeInputChains1_0,
/* 22068*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22071*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22081*/              0, /*End of Scope*/
/* 22082*/            /*Scope*/ 64, /*->22147*/
/* 22083*/              OPC_RecordChild0, // #1 = $addr
/* 22084*/              OPC_RecordChild1, // #2 = $off
/* 22085*/              OPC_MoveChild1,
/* 22086*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 22089*/              OPC_MoveParent,
/* 22090*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 22092*/              OPC_CheckType, MVT::i32,
/* 22094*/              OPC_MoveParent,
/* 22095*/              OPC_MoveChild2,
/* 22096*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22099*/              OPC_RecordChild0, // #3 = $val
/* 22100*/              OPC_MoveParent,
/* 22101*/              OPC_Scope, 21, /*->22124*/ // 2 children in Scope
/* 22103*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 22105*/                OPC_MoveParent,
/* 22106*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22108*/                OPC_EmitMergeInputChains1_0,
/* 22109*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22112*/                OPC_EmitConvertToTarget, 2,
/* 22114*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>) - Complexity = 17
                          // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22124*/              /*Scope*/ 21, /*->22146*/
/* 22125*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 22127*/                OPC_MoveParent,
/* 22128*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22130*/                OPC_EmitMergeInputChains1_0,
/* 22131*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22134*/                OPC_EmitConvertToTarget, 2,
/* 22136*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>) - Complexity = 17
                          // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22146*/              0, /*End of Scope*/
/* 22147*/            0, /*End of Scope*/
/* 22148*/          /*SwitchOpcode*/ 64, TARGET_VAL(ISD::OR),// ->22215
/* 22151*/            OPC_RecordChild0, // #1 = $addr
/* 22152*/            OPC_RecordChild1, // #2 = $off
/* 22153*/            OPC_MoveChild1,
/* 22154*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 22157*/            OPC_MoveParent,
/* 22158*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 22160*/            OPC_CheckType, MVT::i32,
/* 22162*/            OPC_MoveParent,
/* 22163*/            OPC_MoveChild2,
/* 22164*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22167*/            OPC_RecordChild0, // #3 = $val
/* 22168*/            OPC_MoveParent,
/* 22169*/            OPC_Scope, 21, /*->22192*/ // 2 children in Scope
/* 22171*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 22173*/              OPC_MoveParent,
/* 22174*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22176*/              OPC_EmitMergeInputChains1_0,
/* 22177*/              OPC_EmitInteger, MVT::i32, 0, 
/* 22180*/              OPC_EmitConvertToTarget, 2,
/* 22182*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22192*/            /*Scope*/ 21, /*->22214*/
/* 22193*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 22195*/              OPC_MoveParent,
/* 22196*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22198*/              OPC_EmitMergeInputChains1_0,
/* 22199*/              OPC_EmitInteger, MVT::i32, 0, 
/* 22202*/              OPC_EmitConvertToTarget, 2,
/* 22204*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22214*/            0, /*End of Scope*/
/* 22215*/          /*SwitchOpcode*/ 22|128,1/*150*/, TARGET_VAL(WebAssemblyISD::Wrapper),// ->22369
/* 22219*/            OPC_RecordChild0, // #1 = $off
/* 22220*/            OPC_MoveChild0,
/* 22221*/            OPC_SwitchOpcode /*2 cases */, 70, TARGET_VAL(ISD::TargetGlobalAddress),// ->22295
/* 22225*/              OPC_MoveParent,
/* 22226*/              OPC_MoveParent,
/* 22227*/              OPC_MoveChild2,
/* 22228*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22231*/              OPC_RecordChild0, // #2 = $val
/* 22232*/              OPC_MoveParent,
/* 22233*/              OPC_Scope, 29, /*->22264*/ // 2 children in Scope
/* 22235*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 22237*/                OPC_MoveParent,
/* 22238*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22240*/                OPC_EmitMergeInputChains1_0,
/* 22241*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22244*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22247*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 22254*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 22264*/              /*Scope*/ 29, /*->22294*/
/* 22265*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 22267*/                OPC_MoveParent,
/* 22268*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22270*/                OPC_EmitMergeInputChains1_0,
/* 22271*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22274*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22277*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 22284*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 22294*/              0, /*End of Scope*/
/* 22295*/            /*SwitchOpcode*/ 70, TARGET_VAL(ISD::TargetExternalSymbol),// ->22368
/* 22298*/              OPC_MoveParent,
/* 22299*/              OPC_MoveParent,
/* 22300*/              OPC_MoveChild2,
/* 22301*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22304*/              OPC_RecordChild0, // #2 = $val
/* 22305*/              OPC_MoveParent,
/* 22306*/              OPC_Scope, 29, /*->22337*/ // 2 children in Scope
/* 22308*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 22310*/                OPC_MoveParent,
/* 22311*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22313*/                OPC_EmitMergeInputChains1_0,
/* 22314*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22317*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22320*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 22327*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 22337*/              /*Scope*/ 29, /*->22367*/
/* 22338*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 22340*/                OPC_MoveParent,
/* 22341*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22343*/                OPC_EmitMergeInputChains1_0,
/* 22344*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22347*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22350*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 22357*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 22367*/              0, /*End of Scope*/
/* 22368*/            0, // EndSwitchOpcode
/* 22369*/          0, // EndSwitchOpcode
/* 22370*/        /*Scope*/ 10|128,1/*138*/, /*->22510*/
/* 22372*/          OPC_RecordChild1, // #1 = $off
/* 22373*/          OPC_Scope, 77, /*->22452*/ // 2 children in Scope
/* 22375*/            OPC_MoveChild1,
/* 22376*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 22379*/            OPC_MoveParent,
/* 22380*/            OPC_MoveChild2,
/* 22381*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22384*/            OPC_RecordChild0, // #2 = $val
/* 22385*/            OPC_MoveParent,
/* 22386*/            OPC_Scope, 31, /*->22419*/ // 2 children in Scope
/* 22388*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 22390*/              OPC_MoveParent,
/* 22391*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22393*/              OPC_EmitMergeInputChains1_0,
/* 22394*/              OPC_EmitInteger, MVT::i32, 0, 
/* 22397*/              OPC_EmitConvertToTarget, 1,
/* 22399*/              OPC_EmitInteger, MVT::i32, 0, 
/* 22402*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 22409*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>) - Complexity = 13
                        // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 22419*/            /*Scope*/ 31, /*->22451*/
/* 22420*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 22422*/              OPC_MoveParent,
/* 22423*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22425*/              OPC_EmitMergeInputChains1_0,
/* 22426*/              OPC_EmitInteger, MVT::i32, 0, 
/* 22429*/              OPC_EmitConvertToTarget, 1,
/* 22431*/              OPC_EmitInteger, MVT::i32, 0, 
/* 22434*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 22441*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>) - Complexity = 13
                        // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 22451*/            0, /*End of Scope*/
/* 22452*/          /*Scope*/ 56, /*->22509*/
/* 22453*/            OPC_CheckChild1Type, MVT::i32,
/* 22455*/            OPC_MoveChild2,
/* 22456*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22459*/            OPC_RecordChild0, // #2 = $val
/* 22460*/            OPC_MoveParent,
/* 22461*/            OPC_Scope, 22, /*->22485*/ // 2 children in Scope
/* 22463*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_add_8
/* 22465*/              OPC_MoveParent,
/* 22466*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22468*/              OPC_EmitMergeInputChains1_0,
/* 22469*/              OPC_EmitInteger, MVT::i32, 0, 
/* 22472*/              OPC_EmitInteger, MVT::i32, 0, 
/* 22475*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_8>>) - Complexity = 10
                        // Dst: (ATOMIC_RMW8_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22485*/            /*Scope*/ 22, /*->22508*/
/* 22486*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_add_16
/* 22488*/              OPC_MoveParent,
/* 22489*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22491*/              OPC_EmitMergeInputChains1_0,
/* 22492*/              OPC_EmitInteger, MVT::i32, 0, 
/* 22495*/              OPC_EmitInteger, MVT::i32, 0, 
/* 22498*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_ADD_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_add:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_add_16>>) - Complexity = 10
                        // Dst: (ATOMIC_RMW16_U_ADD_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22508*/            0, /*End of Scope*/
/* 22509*/          0, /*End of Scope*/
/* 22510*/        0, /*End of Scope*/
/* 22511*/      /*SwitchOpcode*/ 61|128,5/*701*/, TARGET_VAL(ISD::ATOMIC_LOAD_SUB),// ->23216
/* 22515*/        OPC_RecordMemRef,
/* 22516*/        OPC_RecordNode, // #0 = 'atomic_load_sub' chained node
/* 22517*/        OPC_Scope, 43|128,4/*555*/, /*->23075*/ // 2 children in Scope
/* 22520*/          OPC_MoveChild1,
/* 22521*/          OPC_SwitchOpcode /*3 cases */, 71|128,2/*327*/, TARGET_VAL(ISD::ADD),// ->22853
/* 22526*/            OPC_Scope, 65, /*->22593*/ // 5 children in Scope
/* 22528*/              OPC_RecordChild0, // #1 = $addr
/* 22529*/              OPC_MoveChild1,
/* 22530*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 22533*/              OPC_RecordChild0, // #2 = $off
/* 22534*/              OPC_MoveChild0,
/* 22535*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 22538*/              OPC_MoveParent,
/* 22539*/              OPC_MoveParent,
/* 22540*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 22542*/              OPC_CheckType, MVT::i32,
/* 22544*/              OPC_MoveParent,
/* 22545*/              OPC_MoveChild2,
/* 22546*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22549*/              OPC_RecordChild0, // #3 = $val
/* 22550*/              OPC_MoveParent,
/* 22551*/              OPC_Scope, 19, /*->22572*/ // 2 children in Scope
/* 22553*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 22555*/                OPC_MoveParent,
/* 22556*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22558*/                OPC_EmitMergeInputChains1_0,
/* 22559*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22562*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22572*/              /*Scope*/ 19, /*->22592*/
/* 22573*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 22575*/                OPC_MoveParent,
/* 22576*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22578*/                OPC_EmitMergeInputChains1_0,
/* 22579*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22582*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22592*/              0, /*End of Scope*/
/* 22593*/            /*Scope*/ 65, /*->22659*/
/* 22594*/              OPC_MoveChild0,
/* 22595*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 22598*/              OPC_RecordChild0, // #1 = $off
/* 22599*/              OPC_MoveChild0,
/* 22600*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 22603*/              OPC_MoveParent,
/* 22604*/              OPC_MoveParent,
/* 22605*/              OPC_RecordChild1, // #2 = $addr
/* 22606*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 22608*/              OPC_CheckType, MVT::i32,
/* 22610*/              OPC_MoveParent,
/* 22611*/              OPC_MoveChild2,
/* 22612*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22615*/              OPC_RecordChild0, // #3 = $val
/* 22616*/              OPC_MoveParent,
/* 22617*/              OPC_Scope, 19, /*->22638*/ // 2 children in Scope
/* 22619*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 22621*/                OPC_MoveParent,
/* 22622*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22624*/                OPC_EmitMergeInputChains1_0,
/* 22625*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22628*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22638*/              /*Scope*/ 19, /*->22658*/
/* 22639*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 22641*/                OPC_MoveParent,
/* 22642*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22644*/                OPC_EmitMergeInputChains1_0,
/* 22645*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22648*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22658*/              0, /*End of Scope*/
/* 22659*/            /*Scope*/ 63, /*->22723*/
/* 22660*/              OPC_RecordChild0, // #1 = $addr
/* 22661*/              OPC_MoveChild1,
/* 22662*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 22665*/              OPC_RecordChild0, // #2 = $off
/* 22666*/              OPC_MoveChild0,
/* 22667*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 22670*/              OPC_MoveParent,
/* 22671*/              OPC_MoveParent,
/* 22672*/              OPC_CheckType, MVT::i32,
/* 22674*/              OPC_MoveParent,
/* 22675*/              OPC_MoveChild2,
/* 22676*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22679*/              OPC_RecordChild0, // #3 = $val
/* 22680*/              OPC_MoveParent,
/* 22681*/              OPC_Scope, 19, /*->22702*/ // 2 children in Scope
/* 22683*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 22685*/                OPC_MoveParent,
/* 22686*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22688*/                OPC_EmitMergeInputChains1_0,
/* 22689*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22692*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22702*/              /*Scope*/ 19, /*->22722*/
/* 22703*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 22705*/                OPC_MoveParent,
/* 22706*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22708*/                OPC_EmitMergeInputChains1_0,
/* 22709*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22712*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22722*/              0, /*End of Scope*/
/* 22723*/            /*Scope*/ 63, /*->22787*/
/* 22724*/              OPC_MoveChild0,
/* 22725*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 22728*/              OPC_RecordChild0, // #1 = $off
/* 22729*/              OPC_MoveChild0,
/* 22730*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 22733*/              OPC_MoveParent,
/* 22734*/              OPC_MoveParent,
/* 22735*/              OPC_RecordChild1, // #2 = $addr
/* 22736*/              OPC_CheckType, MVT::i32,
/* 22738*/              OPC_MoveParent,
/* 22739*/              OPC_MoveChild2,
/* 22740*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22743*/              OPC_RecordChild0, // #3 = $val
/* 22744*/              OPC_MoveParent,
/* 22745*/              OPC_Scope, 19, /*->22766*/ // 2 children in Scope
/* 22747*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 22749*/                OPC_MoveParent,
/* 22750*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22752*/                OPC_EmitMergeInputChains1_0,
/* 22753*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22756*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22766*/              /*Scope*/ 19, /*->22786*/
/* 22767*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 22769*/                OPC_MoveParent,
/* 22770*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22772*/                OPC_EmitMergeInputChains1_0,
/* 22773*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22776*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22786*/              0, /*End of Scope*/
/* 22787*/            /*Scope*/ 64, /*->22852*/
/* 22788*/              OPC_RecordChild0, // #1 = $addr
/* 22789*/              OPC_RecordChild1, // #2 = $off
/* 22790*/              OPC_MoveChild1,
/* 22791*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 22794*/              OPC_MoveParent,
/* 22795*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 22797*/              OPC_CheckType, MVT::i32,
/* 22799*/              OPC_MoveParent,
/* 22800*/              OPC_MoveChild2,
/* 22801*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22804*/              OPC_RecordChild0, // #3 = $val
/* 22805*/              OPC_MoveParent,
/* 22806*/              OPC_Scope, 21, /*->22829*/ // 2 children in Scope
/* 22808*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 22810*/                OPC_MoveParent,
/* 22811*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22813*/                OPC_EmitMergeInputChains1_0,
/* 22814*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22817*/                OPC_EmitConvertToTarget, 2,
/* 22819*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>) - Complexity = 17
                          // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22829*/              /*Scope*/ 21, /*->22851*/
/* 22830*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 22832*/                OPC_MoveParent,
/* 22833*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22835*/                OPC_EmitMergeInputChains1_0,
/* 22836*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22839*/                OPC_EmitConvertToTarget, 2,
/* 22841*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>) - Complexity = 17
                          // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22851*/              0, /*End of Scope*/
/* 22852*/            0, /*End of Scope*/
/* 22853*/          /*SwitchOpcode*/ 64, TARGET_VAL(ISD::OR),// ->22920
/* 22856*/            OPC_RecordChild0, // #1 = $addr
/* 22857*/            OPC_RecordChild1, // #2 = $off
/* 22858*/            OPC_MoveChild1,
/* 22859*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 22862*/            OPC_MoveParent,
/* 22863*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 22865*/            OPC_CheckType, MVT::i32,
/* 22867*/            OPC_MoveParent,
/* 22868*/            OPC_MoveChild2,
/* 22869*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22872*/            OPC_RecordChild0, // #3 = $val
/* 22873*/            OPC_MoveParent,
/* 22874*/            OPC_Scope, 21, /*->22897*/ // 2 children in Scope
/* 22876*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 22878*/              OPC_MoveParent,
/* 22879*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22881*/              OPC_EmitMergeInputChains1_0,
/* 22882*/              OPC_EmitInteger, MVT::i32, 0, 
/* 22885*/              OPC_EmitConvertToTarget, 2,
/* 22887*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22897*/            /*Scope*/ 21, /*->22919*/
/* 22898*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 22900*/              OPC_MoveParent,
/* 22901*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22903*/              OPC_EmitMergeInputChains1_0,
/* 22904*/              OPC_EmitInteger, MVT::i32, 0, 
/* 22907*/              OPC_EmitConvertToTarget, 2,
/* 22909*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 22919*/            0, /*End of Scope*/
/* 22920*/          /*SwitchOpcode*/ 22|128,1/*150*/, TARGET_VAL(WebAssemblyISD::Wrapper),// ->23074
/* 22924*/            OPC_RecordChild0, // #1 = $off
/* 22925*/            OPC_MoveChild0,
/* 22926*/            OPC_SwitchOpcode /*2 cases */, 70, TARGET_VAL(ISD::TargetGlobalAddress),// ->23000
/* 22930*/              OPC_MoveParent,
/* 22931*/              OPC_MoveParent,
/* 22932*/              OPC_MoveChild2,
/* 22933*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 22936*/              OPC_RecordChild0, // #2 = $val
/* 22937*/              OPC_MoveParent,
/* 22938*/              OPC_Scope, 29, /*->22969*/ // 2 children in Scope
/* 22940*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 22942*/                OPC_MoveParent,
/* 22943*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22945*/                OPC_EmitMergeInputChains1_0,
/* 22946*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22949*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22952*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 22959*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 22969*/              /*Scope*/ 29, /*->22999*/
/* 22970*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 22972*/                OPC_MoveParent,
/* 22973*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 22975*/                OPC_EmitMergeInputChains1_0,
/* 22976*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22979*/                OPC_EmitInteger, MVT::i32, 0, 
/* 22982*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 22989*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 22999*/              0, /*End of Scope*/
/* 23000*/            /*SwitchOpcode*/ 70, TARGET_VAL(ISD::TargetExternalSymbol),// ->23073
/* 23003*/              OPC_MoveParent,
/* 23004*/              OPC_MoveParent,
/* 23005*/              OPC_MoveChild2,
/* 23006*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23009*/              OPC_RecordChild0, // #2 = $val
/* 23010*/              OPC_MoveParent,
/* 23011*/              OPC_Scope, 29, /*->23042*/ // 2 children in Scope
/* 23013*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 23015*/                OPC_MoveParent,
/* 23016*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23018*/                OPC_EmitMergeInputChains1_0,
/* 23019*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23022*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23025*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 23032*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 23042*/              /*Scope*/ 29, /*->23072*/
/* 23043*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 23045*/                OPC_MoveParent,
/* 23046*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23048*/                OPC_EmitMergeInputChains1_0,
/* 23049*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23052*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23055*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 23062*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 23072*/              0, /*End of Scope*/
/* 23073*/            0, // EndSwitchOpcode
/* 23074*/          0, // EndSwitchOpcode
/* 23075*/        /*Scope*/ 10|128,1/*138*/, /*->23215*/
/* 23077*/          OPC_RecordChild1, // #1 = $off
/* 23078*/          OPC_Scope, 77, /*->23157*/ // 2 children in Scope
/* 23080*/            OPC_MoveChild1,
/* 23081*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 23084*/            OPC_MoveParent,
/* 23085*/            OPC_MoveChild2,
/* 23086*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23089*/            OPC_RecordChild0, // #2 = $val
/* 23090*/            OPC_MoveParent,
/* 23091*/            OPC_Scope, 31, /*->23124*/ // 2 children in Scope
/* 23093*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 23095*/              OPC_MoveParent,
/* 23096*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23098*/              OPC_EmitMergeInputChains1_0,
/* 23099*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23102*/              OPC_EmitConvertToTarget, 1,
/* 23104*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23107*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 23114*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>) - Complexity = 13
                        // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 23124*/            /*Scope*/ 31, /*->23156*/
/* 23125*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 23127*/              OPC_MoveParent,
/* 23128*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23130*/              OPC_EmitMergeInputChains1_0,
/* 23131*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23134*/              OPC_EmitConvertToTarget, 1,
/* 23136*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23139*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 23146*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>) - Complexity = 13
                        // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 23156*/            0, /*End of Scope*/
/* 23157*/          /*Scope*/ 56, /*->23214*/
/* 23158*/            OPC_CheckChild1Type, MVT::i32,
/* 23160*/            OPC_MoveChild2,
/* 23161*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23164*/            OPC_RecordChild0, // #2 = $val
/* 23165*/            OPC_MoveParent,
/* 23166*/            OPC_Scope, 22, /*->23190*/ // 2 children in Scope
/* 23168*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_sub_8
/* 23170*/              OPC_MoveParent,
/* 23171*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23173*/              OPC_EmitMergeInputChains1_0,
/* 23174*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23177*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23180*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_8>>) - Complexity = 10
                        // Dst: (ATOMIC_RMW8_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23190*/            /*Scope*/ 22, /*->23213*/
/* 23191*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_sub_16
/* 23193*/              OPC_MoveParent,
/* 23194*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23196*/              OPC_EmitMergeInputChains1_0,
/* 23197*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23200*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23203*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_SUB_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_sub:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_sub_16>>) - Complexity = 10
                        // Dst: (ATOMIC_RMW16_U_SUB_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23213*/            0, /*End of Scope*/
/* 23214*/          0, /*End of Scope*/
/* 23215*/        0, /*End of Scope*/
/* 23216*/      /*SwitchOpcode*/ 61|128,5/*701*/, TARGET_VAL(ISD::ATOMIC_LOAD_AND),// ->23921
/* 23220*/        OPC_RecordMemRef,
/* 23221*/        OPC_RecordNode, // #0 = 'atomic_load_and' chained node
/* 23222*/        OPC_Scope, 43|128,4/*555*/, /*->23780*/ // 2 children in Scope
/* 23225*/          OPC_MoveChild1,
/* 23226*/          OPC_SwitchOpcode /*3 cases */, 71|128,2/*327*/, TARGET_VAL(ISD::ADD),// ->23558
/* 23231*/            OPC_Scope, 65, /*->23298*/ // 5 children in Scope
/* 23233*/              OPC_RecordChild0, // #1 = $addr
/* 23234*/              OPC_MoveChild1,
/* 23235*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 23238*/              OPC_RecordChild0, // #2 = $off
/* 23239*/              OPC_MoveChild0,
/* 23240*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 23243*/              OPC_MoveParent,
/* 23244*/              OPC_MoveParent,
/* 23245*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 23247*/              OPC_CheckType, MVT::i32,
/* 23249*/              OPC_MoveParent,
/* 23250*/              OPC_MoveChild2,
/* 23251*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23254*/              OPC_RecordChild0, // #3 = $val
/* 23255*/              OPC_MoveParent,
/* 23256*/              OPC_Scope, 19, /*->23277*/ // 2 children in Scope
/* 23258*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 23260*/                OPC_MoveParent,
/* 23261*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23263*/                OPC_EmitMergeInputChains1_0,
/* 23264*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23267*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23277*/              /*Scope*/ 19, /*->23297*/
/* 23278*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 23280*/                OPC_MoveParent,
/* 23281*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23283*/                OPC_EmitMergeInputChains1_0,
/* 23284*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23287*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23297*/              0, /*End of Scope*/
/* 23298*/            /*Scope*/ 65, /*->23364*/
/* 23299*/              OPC_MoveChild0,
/* 23300*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 23303*/              OPC_RecordChild0, // #1 = $off
/* 23304*/              OPC_MoveChild0,
/* 23305*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 23308*/              OPC_MoveParent,
/* 23309*/              OPC_MoveParent,
/* 23310*/              OPC_RecordChild1, // #2 = $addr
/* 23311*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 23313*/              OPC_CheckType, MVT::i32,
/* 23315*/              OPC_MoveParent,
/* 23316*/              OPC_MoveChild2,
/* 23317*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23320*/              OPC_RecordChild0, // #3 = $val
/* 23321*/              OPC_MoveParent,
/* 23322*/              OPC_Scope, 19, /*->23343*/ // 2 children in Scope
/* 23324*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 23326*/                OPC_MoveParent,
/* 23327*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23329*/                OPC_EmitMergeInputChains1_0,
/* 23330*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23333*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23343*/              /*Scope*/ 19, /*->23363*/
/* 23344*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 23346*/                OPC_MoveParent,
/* 23347*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23349*/                OPC_EmitMergeInputChains1_0,
/* 23350*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23353*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23363*/              0, /*End of Scope*/
/* 23364*/            /*Scope*/ 63, /*->23428*/
/* 23365*/              OPC_RecordChild0, // #1 = $addr
/* 23366*/              OPC_MoveChild1,
/* 23367*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 23370*/              OPC_RecordChild0, // #2 = $off
/* 23371*/              OPC_MoveChild0,
/* 23372*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 23375*/              OPC_MoveParent,
/* 23376*/              OPC_MoveParent,
/* 23377*/              OPC_CheckType, MVT::i32,
/* 23379*/              OPC_MoveParent,
/* 23380*/              OPC_MoveChild2,
/* 23381*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23384*/              OPC_RecordChild0, // #3 = $val
/* 23385*/              OPC_MoveParent,
/* 23386*/              OPC_Scope, 19, /*->23407*/ // 2 children in Scope
/* 23388*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 23390*/                OPC_MoveParent,
/* 23391*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23393*/                OPC_EmitMergeInputChains1_0,
/* 23394*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23397*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23407*/              /*Scope*/ 19, /*->23427*/
/* 23408*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 23410*/                OPC_MoveParent,
/* 23411*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23413*/                OPC_EmitMergeInputChains1_0,
/* 23414*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23417*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23427*/              0, /*End of Scope*/
/* 23428*/            /*Scope*/ 63, /*->23492*/
/* 23429*/              OPC_MoveChild0,
/* 23430*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 23433*/              OPC_RecordChild0, // #1 = $off
/* 23434*/              OPC_MoveChild0,
/* 23435*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 23438*/              OPC_MoveParent,
/* 23439*/              OPC_MoveParent,
/* 23440*/              OPC_RecordChild1, // #2 = $addr
/* 23441*/              OPC_CheckType, MVT::i32,
/* 23443*/              OPC_MoveParent,
/* 23444*/              OPC_MoveChild2,
/* 23445*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23448*/              OPC_RecordChild0, // #3 = $val
/* 23449*/              OPC_MoveParent,
/* 23450*/              OPC_Scope, 19, /*->23471*/ // 2 children in Scope
/* 23452*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 23454*/                OPC_MoveParent,
/* 23455*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23457*/                OPC_EmitMergeInputChains1_0,
/* 23458*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23461*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23471*/              /*Scope*/ 19, /*->23491*/
/* 23472*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 23474*/                OPC_MoveParent,
/* 23475*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23477*/                OPC_EmitMergeInputChains1_0,
/* 23478*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23481*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23491*/              0, /*End of Scope*/
/* 23492*/            /*Scope*/ 64, /*->23557*/
/* 23493*/              OPC_RecordChild0, // #1 = $addr
/* 23494*/              OPC_RecordChild1, // #2 = $off
/* 23495*/              OPC_MoveChild1,
/* 23496*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 23499*/              OPC_MoveParent,
/* 23500*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 23502*/              OPC_CheckType, MVT::i32,
/* 23504*/              OPC_MoveParent,
/* 23505*/              OPC_MoveChild2,
/* 23506*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23509*/              OPC_RecordChild0, // #3 = $val
/* 23510*/              OPC_MoveParent,
/* 23511*/              OPC_Scope, 21, /*->23534*/ // 2 children in Scope
/* 23513*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 23515*/                OPC_MoveParent,
/* 23516*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23518*/                OPC_EmitMergeInputChains1_0,
/* 23519*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23522*/                OPC_EmitConvertToTarget, 2,
/* 23524*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>) - Complexity = 17
                          // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23534*/              /*Scope*/ 21, /*->23556*/
/* 23535*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 23537*/                OPC_MoveParent,
/* 23538*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23540*/                OPC_EmitMergeInputChains1_0,
/* 23541*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23544*/                OPC_EmitConvertToTarget, 2,
/* 23546*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>) - Complexity = 17
                          // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23556*/              0, /*End of Scope*/
/* 23557*/            0, /*End of Scope*/
/* 23558*/          /*SwitchOpcode*/ 64, TARGET_VAL(ISD::OR),// ->23625
/* 23561*/            OPC_RecordChild0, // #1 = $addr
/* 23562*/            OPC_RecordChild1, // #2 = $off
/* 23563*/            OPC_MoveChild1,
/* 23564*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 23567*/            OPC_MoveParent,
/* 23568*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 23570*/            OPC_CheckType, MVT::i32,
/* 23572*/            OPC_MoveParent,
/* 23573*/            OPC_MoveChild2,
/* 23574*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23577*/            OPC_RecordChild0, // #3 = $val
/* 23578*/            OPC_MoveParent,
/* 23579*/            OPC_Scope, 21, /*->23602*/ // 2 children in Scope
/* 23581*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 23583*/              OPC_MoveParent,
/* 23584*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23586*/              OPC_EmitMergeInputChains1_0,
/* 23587*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23590*/              OPC_EmitConvertToTarget, 2,
/* 23592*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23602*/            /*Scope*/ 21, /*->23624*/
/* 23603*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 23605*/              OPC_MoveParent,
/* 23606*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23608*/              OPC_EmitMergeInputChains1_0,
/* 23609*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23612*/              OPC_EmitConvertToTarget, 2,
/* 23614*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23624*/            0, /*End of Scope*/
/* 23625*/          /*SwitchOpcode*/ 22|128,1/*150*/, TARGET_VAL(WebAssemblyISD::Wrapper),// ->23779
/* 23629*/            OPC_RecordChild0, // #1 = $off
/* 23630*/            OPC_MoveChild0,
/* 23631*/            OPC_SwitchOpcode /*2 cases */, 70, TARGET_VAL(ISD::TargetGlobalAddress),// ->23705
/* 23635*/              OPC_MoveParent,
/* 23636*/              OPC_MoveParent,
/* 23637*/              OPC_MoveChild2,
/* 23638*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23641*/              OPC_RecordChild0, // #2 = $val
/* 23642*/              OPC_MoveParent,
/* 23643*/              OPC_Scope, 29, /*->23674*/ // 2 children in Scope
/* 23645*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 23647*/                OPC_MoveParent,
/* 23648*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23650*/                OPC_EmitMergeInputChains1_0,
/* 23651*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23654*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23657*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 23664*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 23674*/              /*Scope*/ 29, /*->23704*/
/* 23675*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 23677*/                OPC_MoveParent,
/* 23678*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23680*/                OPC_EmitMergeInputChains1_0,
/* 23681*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23684*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23687*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 23694*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 23704*/              0, /*End of Scope*/
/* 23705*/            /*SwitchOpcode*/ 70, TARGET_VAL(ISD::TargetExternalSymbol),// ->23778
/* 23708*/              OPC_MoveParent,
/* 23709*/              OPC_MoveParent,
/* 23710*/              OPC_MoveChild2,
/* 23711*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23714*/              OPC_RecordChild0, // #2 = $val
/* 23715*/              OPC_MoveParent,
/* 23716*/              OPC_Scope, 29, /*->23747*/ // 2 children in Scope
/* 23718*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 23720*/                OPC_MoveParent,
/* 23721*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23723*/                OPC_EmitMergeInputChains1_0,
/* 23724*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23727*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23730*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 23737*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 23747*/              /*Scope*/ 29, /*->23777*/
/* 23748*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 23750*/                OPC_MoveParent,
/* 23751*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23753*/                OPC_EmitMergeInputChains1_0,
/* 23754*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23757*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23760*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 23767*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 23777*/              0, /*End of Scope*/
/* 23778*/            0, // EndSwitchOpcode
/* 23779*/          0, // EndSwitchOpcode
/* 23780*/        /*Scope*/ 10|128,1/*138*/, /*->23920*/
/* 23782*/          OPC_RecordChild1, // #1 = $off
/* 23783*/          OPC_Scope, 77, /*->23862*/ // 2 children in Scope
/* 23785*/            OPC_MoveChild1,
/* 23786*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 23789*/            OPC_MoveParent,
/* 23790*/            OPC_MoveChild2,
/* 23791*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23794*/            OPC_RecordChild0, // #2 = $val
/* 23795*/            OPC_MoveParent,
/* 23796*/            OPC_Scope, 31, /*->23829*/ // 2 children in Scope
/* 23798*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 23800*/              OPC_MoveParent,
/* 23801*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23803*/              OPC_EmitMergeInputChains1_0,
/* 23804*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23807*/              OPC_EmitConvertToTarget, 1,
/* 23809*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23812*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 23819*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>) - Complexity = 13
                        // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 23829*/            /*Scope*/ 31, /*->23861*/
/* 23830*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 23832*/              OPC_MoveParent,
/* 23833*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23835*/              OPC_EmitMergeInputChains1_0,
/* 23836*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23839*/              OPC_EmitConvertToTarget, 1,
/* 23841*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23844*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 23851*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>) - Complexity = 13
                        // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 23861*/            0, /*End of Scope*/
/* 23862*/          /*Scope*/ 56, /*->23919*/
/* 23863*/            OPC_CheckChild1Type, MVT::i32,
/* 23865*/            OPC_MoveChild2,
/* 23866*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23869*/            OPC_RecordChild0, // #2 = $val
/* 23870*/            OPC_MoveParent,
/* 23871*/            OPC_Scope, 22, /*->23895*/ // 2 children in Scope
/* 23873*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_and_8
/* 23875*/              OPC_MoveParent,
/* 23876*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23878*/              OPC_EmitMergeInputChains1_0,
/* 23879*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23882*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23885*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_8>>) - Complexity = 10
                        // Dst: (ATOMIC_RMW8_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23895*/            /*Scope*/ 22, /*->23918*/
/* 23896*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_and_16
/* 23898*/              OPC_MoveParent,
/* 23899*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23901*/              OPC_EmitMergeInputChains1_0,
/* 23902*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23905*/              OPC_EmitInteger, MVT::i32, 0, 
/* 23908*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_AND_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_and:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_and_16>>) - Complexity = 10
                        // Dst: (ATOMIC_RMW16_U_AND_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23918*/            0, /*End of Scope*/
/* 23919*/          0, /*End of Scope*/
/* 23920*/        0, /*End of Scope*/
/* 23921*/      /*SwitchOpcode*/ 61|128,5/*701*/, TARGET_VAL(ISD::ATOMIC_LOAD_OR),// ->24626
/* 23925*/        OPC_RecordMemRef,
/* 23926*/        OPC_RecordNode, // #0 = 'atomic_load_or' chained node
/* 23927*/        OPC_Scope, 43|128,4/*555*/, /*->24485*/ // 2 children in Scope
/* 23930*/          OPC_MoveChild1,
/* 23931*/          OPC_SwitchOpcode /*3 cases */, 71|128,2/*327*/, TARGET_VAL(ISD::ADD),// ->24263
/* 23936*/            OPC_Scope, 65, /*->24003*/ // 5 children in Scope
/* 23938*/              OPC_RecordChild0, // #1 = $addr
/* 23939*/              OPC_MoveChild1,
/* 23940*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 23943*/              OPC_RecordChild0, // #2 = $off
/* 23944*/              OPC_MoveChild0,
/* 23945*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 23948*/              OPC_MoveParent,
/* 23949*/              OPC_MoveParent,
/* 23950*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 23952*/              OPC_CheckType, MVT::i32,
/* 23954*/              OPC_MoveParent,
/* 23955*/              OPC_MoveChild2,
/* 23956*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 23959*/              OPC_RecordChild0, // #3 = $val
/* 23960*/              OPC_MoveParent,
/* 23961*/              OPC_Scope, 19, /*->23982*/ // 2 children in Scope
/* 23963*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 23965*/                OPC_MoveParent,
/* 23966*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23968*/                OPC_EmitMergeInputChains1_0,
/* 23969*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23972*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 23982*/              /*Scope*/ 19, /*->24002*/
/* 23983*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 23985*/                OPC_MoveParent,
/* 23986*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 23988*/                OPC_EmitMergeInputChains1_0,
/* 23989*/                OPC_EmitInteger, MVT::i32, 0, 
/* 23992*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24002*/              0, /*End of Scope*/
/* 24003*/            /*Scope*/ 65, /*->24069*/
/* 24004*/              OPC_MoveChild0,
/* 24005*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 24008*/              OPC_RecordChild0, // #1 = $off
/* 24009*/              OPC_MoveChild0,
/* 24010*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 24013*/              OPC_MoveParent,
/* 24014*/              OPC_MoveParent,
/* 24015*/              OPC_RecordChild1, // #2 = $addr
/* 24016*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 24018*/              OPC_CheckType, MVT::i32,
/* 24020*/              OPC_MoveParent,
/* 24021*/              OPC_MoveChild2,
/* 24022*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24025*/              OPC_RecordChild0, // #3 = $val
/* 24026*/              OPC_MoveParent,
/* 24027*/              OPC_Scope, 19, /*->24048*/ // 2 children in Scope
/* 24029*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 24031*/                OPC_MoveParent,
/* 24032*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24034*/                OPC_EmitMergeInputChains1_0,
/* 24035*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24038*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24048*/              /*Scope*/ 19, /*->24068*/
/* 24049*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 24051*/                OPC_MoveParent,
/* 24052*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24054*/                OPC_EmitMergeInputChains1_0,
/* 24055*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24058*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24068*/              0, /*End of Scope*/
/* 24069*/            /*Scope*/ 63, /*->24133*/
/* 24070*/              OPC_RecordChild0, // #1 = $addr
/* 24071*/              OPC_MoveChild1,
/* 24072*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 24075*/              OPC_RecordChild0, // #2 = $off
/* 24076*/              OPC_MoveChild0,
/* 24077*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 24080*/              OPC_MoveParent,
/* 24081*/              OPC_MoveParent,
/* 24082*/              OPC_CheckType, MVT::i32,
/* 24084*/              OPC_MoveParent,
/* 24085*/              OPC_MoveChild2,
/* 24086*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24089*/              OPC_RecordChild0, // #3 = $val
/* 24090*/              OPC_MoveParent,
/* 24091*/              OPC_Scope, 19, /*->24112*/ // 2 children in Scope
/* 24093*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 24095*/                OPC_MoveParent,
/* 24096*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24098*/                OPC_EmitMergeInputChains1_0,
/* 24099*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24102*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24112*/              /*Scope*/ 19, /*->24132*/
/* 24113*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 24115*/                OPC_MoveParent,
/* 24116*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24118*/                OPC_EmitMergeInputChains1_0,
/* 24119*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24122*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24132*/              0, /*End of Scope*/
/* 24133*/            /*Scope*/ 63, /*->24197*/
/* 24134*/              OPC_MoveChild0,
/* 24135*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 24138*/              OPC_RecordChild0, // #1 = $off
/* 24139*/              OPC_MoveChild0,
/* 24140*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 24143*/              OPC_MoveParent,
/* 24144*/              OPC_MoveParent,
/* 24145*/              OPC_RecordChild1, // #2 = $addr
/* 24146*/              OPC_CheckType, MVT::i32,
/* 24148*/              OPC_MoveParent,
/* 24149*/              OPC_MoveChild2,
/* 24150*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24153*/              OPC_RecordChild0, // #3 = $val
/* 24154*/              OPC_MoveParent,
/* 24155*/              OPC_Scope, 19, /*->24176*/ // 2 children in Scope
/* 24157*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 24159*/                OPC_MoveParent,
/* 24160*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24162*/                OPC_EmitMergeInputChains1_0,
/* 24163*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24166*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24176*/              /*Scope*/ 19, /*->24196*/
/* 24177*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 24179*/                OPC_MoveParent,
/* 24180*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24182*/                OPC_EmitMergeInputChains1_0,
/* 24183*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24186*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24196*/              0, /*End of Scope*/
/* 24197*/            /*Scope*/ 64, /*->24262*/
/* 24198*/              OPC_RecordChild0, // #1 = $addr
/* 24199*/              OPC_RecordChild1, // #2 = $off
/* 24200*/              OPC_MoveChild1,
/* 24201*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 24204*/              OPC_MoveParent,
/* 24205*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 24207*/              OPC_CheckType, MVT::i32,
/* 24209*/              OPC_MoveParent,
/* 24210*/              OPC_MoveChild2,
/* 24211*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24214*/              OPC_RecordChild0, // #3 = $val
/* 24215*/              OPC_MoveParent,
/* 24216*/              OPC_Scope, 21, /*->24239*/ // 2 children in Scope
/* 24218*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 24220*/                OPC_MoveParent,
/* 24221*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24223*/                OPC_EmitMergeInputChains1_0,
/* 24224*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24227*/                OPC_EmitConvertToTarget, 2,
/* 24229*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>) - Complexity = 17
                          // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24239*/              /*Scope*/ 21, /*->24261*/
/* 24240*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 24242*/                OPC_MoveParent,
/* 24243*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24245*/                OPC_EmitMergeInputChains1_0,
/* 24246*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24249*/                OPC_EmitConvertToTarget, 2,
/* 24251*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>) - Complexity = 17
                          // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24261*/              0, /*End of Scope*/
/* 24262*/            0, /*End of Scope*/
/* 24263*/          /*SwitchOpcode*/ 64, TARGET_VAL(ISD::OR),// ->24330
/* 24266*/            OPC_RecordChild0, // #1 = $addr
/* 24267*/            OPC_RecordChild1, // #2 = $off
/* 24268*/            OPC_MoveChild1,
/* 24269*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 24272*/            OPC_MoveParent,
/* 24273*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 24275*/            OPC_CheckType, MVT::i32,
/* 24277*/            OPC_MoveParent,
/* 24278*/            OPC_MoveChild2,
/* 24279*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24282*/            OPC_RecordChild0, // #3 = $val
/* 24283*/            OPC_MoveParent,
/* 24284*/            OPC_Scope, 21, /*->24307*/ // 2 children in Scope
/* 24286*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 24288*/              OPC_MoveParent,
/* 24289*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24291*/              OPC_EmitMergeInputChains1_0,
/* 24292*/              OPC_EmitInteger, MVT::i32, 0, 
/* 24295*/              OPC_EmitConvertToTarget, 2,
/* 24297*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24307*/            /*Scope*/ 21, /*->24329*/
/* 24308*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 24310*/              OPC_MoveParent,
/* 24311*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24313*/              OPC_EmitMergeInputChains1_0,
/* 24314*/              OPC_EmitInteger, MVT::i32, 0, 
/* 24317*/              OPC_EmitConvertToTarget, 2,
/* 24319*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24329*/            0, /*End of Scope*/
/* 24330*/          /*SwitchOpcode*/ 22|128,1/*150*/, TARGET_VAL(WebAssemblyISD::Wrapper),// ->24484
/* 24334*/            OPC_RecordChild0, // #1 = $off
/* 24335*/            OPC_MoveChild0,
/* 24336*/            OPC_SwitchOpcode /*2 cases */, 70, TARGET_VAL(ISD::TargetGlobalAddress),// ->24410
/* 24340*/              OPC_MoveParent,
/* 24341*/              OPC_MoveParent,
/* 24342*/              OPC_MoveChild2,
/* 24343*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24346*/              OPC_RecordChild0, // #2 = $val
/* 24347*/              OPC_MoveParent,
/* 24348*/              OPC_Scope, 29, /*->24379*/ // 2 children in Scope
/* 24350*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 24352*/                OPC_MoveParent,
/* 24353*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24355*/                OPC_EmitMergeInputChains1_0,
/* 24356*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24359*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24362*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 24369*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 24379*/              /*Scope*/ 29, /*->24409*/
/* 24380*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 24382*/                OPC_MoveParent,
/* 24383*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24385*/                OPC_EmitMergeInputChains1_0,
/* 24386*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24389*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24392*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 24399*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 24409*/              0, /*End of Scope*/
/* 24410*/            /*SwitchOpcode*/ 70, TARGET_VAL(ISD::TargetExternalSymbol),// ->24483
/* 24413*/              OPC_MoveParent,
/* 24414*/              OPC_MoveParent,
/* 24415*/              OPC_MoveChild2,
/* 24416*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24419*/              OPC_RecordChild0, // #2 = $val
/* 24420*/              OPC_MoveParent,
/* 24421*/              OPC_Scope, 29, /*->24452*/ // 2 children in Scope
/* 24423*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 24425*/                OPC_MoveParent,
/* 24426*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24428*/                OPC_EmitMergeInputChains1_0,
/* 24429*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24432*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24435*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 24442*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 24452*/              /*Scope*/ 29, /*->24482*/
/* 24453*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 24455*/                OPC_MoveParent,
/* 24456*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24458*/                OPC_EmitMergeInputChains1_0,
/* 24459*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24462*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24465*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 24472*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 24482*/              0, /*End of Scope*/
/* 24483*/            0, // EndSwitchOpcode
/* 24484*/          0, // EndSwitchOpcode
/* 24485*/        /*Scope*/ 10|128,1/*138*/, /*->24625*/
/* 24487*/          OPC_RecordChild1, // #1 = $off
/* 24488*/          OPC_Scope, 77, /*->24567*/ // 2 children in Scope
/* 24490*/            OPC_MoveChild1,
/* 24491*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 24494*/            OPC_MoveParent,
/* 24495*/            OPC_MoveChild2,
/* 24496*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24499*/            OPC_RecordChild0, // #2 = $val
/* 24500*/            OPC_MoveParent,
/* 24501*/            OPC_Scope, 31, /*->24534*/ // 2 children in Scope
/* 24503*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 24505*/              OPC_MoveParent,
/* 24506*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24508*/              OPC_EmitMergeInputChains1_0,
/* 24509*/              OPC_EmitInteger, MVT::i32, 0, 
/* 24512*/              OPC_EmitConvertToTarget, 1,
/* 24514*/              OPC_EmitInteger, MVT::i32, 0, 
/* 24517*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 24524*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>) - Complexity = 13
                        // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 24534*/            /*Scope*/ 31, /*->24566*/
/* 24535*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 24537*/              OPC_MoveParent,
/* 24538*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24540*/              OPC_EmitMergeInputChains1_0,
/* 24541*/              OPC_EmitInteger, MVT::i32, 0, 
/* 24544*/              OPC_EmitConvertToTarget, 1,
/* 24546*/              OPC_EmitInteger, MVT::i32, 0, 
/* 24549*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 24556*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>) - Complexity = 13
                        // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 24566*/            0, /*End of Scope*/
/* 24567*/          /*Scope*/ 56, /*->24624*/
/* 24568*/            OPC_CheckChild1Type, MVT::i32,
/* 24570*/            OPC_MoveChild2,
/* 24571*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24574*/            OPC_RecordChild0, // #2 = $val
/* 24575*/            OPC_MoveParent,
/* 24576*/            OPC_Scope, 22, /*->24600*/ // 2 children in Scope
/* 24578*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_or_8
/* 24580*/              OPC_MoveParent,
/* 24581*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24583*/              OPC_EmitMergeInputChains1_0,
/* 24584*/              OPC_EmitInteger, MVT::i32, 0, 
/* 24587*/              OPC_EmitInteger, MVT::i32, 0, 
/* 24590*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_8>>) - Complexity = 10
                        // Dst: (ATOMIC_RMW8_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24600*/            /*Scope*/ 22, /*->24623*/
/* 24601*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_or_16
/* 24603*/              OPC_MoveParent,
/* 24604*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24606*/              OPC_EmitMergeInputChains1_0,
/* 24607*/              OPC_EmitInteger, MVT::i32, 0, 
/* 24610*/              OPC_EmitInteger, MVT::i32, 0, 
/* 24613*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_OR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_or:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_or_16>>) - Complexity = 10
                        // Dst: (ATOMIC_RMW16_U_OR_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24623*/            0, /*End of Scope*/
/* 24624*/          0, /*End of Scope*/
/* 24625*/        0, /*End of Scope*/
/* 24626*/      /*SwitchOpcode*/ 61|128,5/*701*/, TARGET_VAL(ISD::ATOMIC_LOAD_XOR),// ->25331
/* 24630*/        OPC_RecordMemRef,
/* 24631*/        OPC_RecordNode, // #0 = 'atomic_load_xor' chained node
/* 24632*/        OPC_Scope, 43|128,4/*555*/, /*->25190*/ // 2 children in Scope
/* 24635*/          OPC_MoveChild1,
/* 24636*/          OPC_SwitchOpcode /*3 cases */, 71|128,2/*327*/, TARGET_VAL(ISD::ADD),// ->24968
/* 24641*/            OPC_Scope, 65, /*->24708*/ // 5 children in Scope
/* 24643*/              OPC_RecordChild0, // #1 = $addr
/* 24644*/              OPC_MoveChild1,
/* 24645*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 24648*/              OPC_RecordChild0, // #2 = $off
/* 24649*/              OPC_MoveChild0,
/* 24650*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 24653*/              OPC_MoveParent,
/* 24654*/              OPC_MoveParent,
/* 24655*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 24657*/              OPC_CheckType, MVT::i32,
/* 24659*/              OPC_MoveParent,
/* 24660*/              OPC_MoveChild2,
/* 24661*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24664*/              OPC_RecordChild0, // #3 = $val
/* 24665*/              OPC_MoveParent,
/* 24666*/              OPC_Scope, 19, /*->24687*/ // 2 children in Scope
/* 24668*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 24670*/                OPC_MoveParent,
/* 24671*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24673*/                OPC_EmitMergeInputChains1_0,
/* 24674*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24677*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24687*/              /*Scope*/ 19, /*->24707*/
/* 24688*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 24690*/                OPC_MoveParent,
/* 24691*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24693*/                OPC_EmitMergeInputChains1_0,
/* 24694*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24697*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24707*/              0, /*End of Scope*/
/* 24708*/            /*Scope*/ 65, /*->24774*/
/* 24709*/              OPC_MoveChild0,
/* 24710*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 24713*/              OPC_RecordChild0, // #1 = $off
/* 24714*/              OPC_MoveChild0,
/* 24715*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 24718*/              OPC_MoveParent,
/* 24719*/              OPC_MoveParent,
/* 24720*/              OPC_RecordChild1, // #2 = $addr
/* 24721*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 24723*/              OPC_CheckType, MVT::i32,
/* 24725*/              OPC_MoveParent,
/* 24726*/              OPC_MoveChild2,
/* 24727*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24730*/              OPC_RecordChild0, // #3 = $val
/* 24731*/              OPC_MoveParent,
/* 24732*/              OPC_Scope, 19, /*->24753*/ // 2 children in Scope
/* 24734*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 24736*/                OPC_MoveParent,
/* 24737*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24739*/                OPC_EmitMergeInputChains1_0,
/* 24740*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24743*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24753*/              /*Scope*/ 19, /*->24773*/
/* 24754*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 24756*/                OPC_MoveParent,
/* 24757*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24759*/                OPC_EmitMergeInputChains1_0,
/* 24760*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24763*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24773*/              0, /*End of Scope*/
/* 24774*/            /*Scope*/ 63, /*->24838*/
/* 24775*/              OPC_RecordChild0, // #1 = $addr
/* 24776*/              OPC_MoveChild1,
/* 24777*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 24780*/              OPC_RecordChild0, // #2 = $off
/* 24781*/              OPC_MoveChild0,
/* 24782*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 24785*/              OPC_MoveParent,
/* 24786*/              OPC_MoveParent,
/* 24787*/              OPC_CheckType, MVT::i32,
/* 24789*/              OPC_MoveParent,
/* 24790*/              OPC_MoveChild2,
/* 24791*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24794*/              OPC_RecordChild0, // #3 = $val
/* 24795*/              OPC_MoveParent,
/* 24796*/              OPC_Scope, 19, /*->24817*/ // 2 children in Scope
/* 24798*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 24800*/                OPC_MoveParent,
/* 24801*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24803*/                OPC_EmitMergeInputChains1_0,
/* 24804*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24807*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24817*/              /*Scope*/ 19, /*->24837*/
/* 24818*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 24820*/                OPC_MoveParent,
/* 24821*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24823*/                OPC_EmitMergeInputChains1_0,
/* 24824*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24827*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24837*/              0, /*End of Scope*/
/* 24838*/            /*Scope*/ 63, /*->24902*/
/* 24839*/              OPC_MoveChild0,
/* 24840*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 24843*/              OPC_RecordChild0, // #1 = $off
/* 24844*/              OPC_MoveChild0,
/* 24845*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 24848*/              OPC_MoveParent,
/* 24849*/              OPC_MoveParent,
/* 24850*/              OPC_RecordChild1, // #2 = $addr
/* 24851*/              OPC_CheckType, MVT::i32,
/* 24853*/              OPC_MoveParent,
/* 24854*/              OPC_MoveChild2,
/* 24855*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24858*/              OPC_RecordChild0, // #3 = $val
/* 24859*/              OPC_MoveParent,
/* 24860*/              OPC_Scope, 19, /*->24881*/ // 2 children in Scope
/* 24862*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 24864*/                OPC_MoveParent,
/* 24865*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24867*/                OPC_EmitMergeInputChains1_0,
/* 24868*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24871*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24881*/              /*Scope*/ 19, /*->24901*/
/* 24882*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 24884*/                OPC_MoveParent,
/* 24885*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24887*/                OPC_EmitMergeInputChains1_0,
/* 24888*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24891*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24901*/              0, /*End of Scope*/
/* 24902*/            /*Scope*/ 64, /*->24967*/
/* 24903*/              OPC_RecordChild0, // #1 = $addr
/* 24904*/              OPC_RecordChild1, // #2 = $off
/* 24905*/              OPC_MoveChild1,
/* 24906*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 24909*/              OPC_MoveParent,
/* 24910*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 24912*/              OPC_CheckType, MVT::i32,
/* 24914*/              OPC_MoveParent,
/* 24915*/              OPC_MoveChild2,
/* 24916*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24919*/              OPC_RecordChild0, // #3 = $val
/* 24920*/              OPC_MoveParent,
/* 24921*/              OPC_Scope, 21, /*->24944*/ // 2 children in Scope
/* 24923*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 24925*/                OPC_MoveParent,
/* 24926*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24928*/                OPC_EmitMergeInputChains1_0,
/* 24929*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24932*/                OPC_EmitConvertToTarget, 2,
/* 24934*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>) - Complexity = 17
                          // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24944*/              /*Scope*/ 21, /*->24966*/
/* 24945*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 24947*/                OPC_MoveParent,
/* 24948*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24950*/                OPC_EmitMergeInputChains1_0,
/* 24951*/                OPC_EmitInteger, MVT::i32, 0, 
/* 24954*/                OPC_EmitConvertToTarget, 2,
/* 24956*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>) - Complexity = 17
                          // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 24966*/              0, /*End of Scope*/
/* 24967*/            0, /*End of Scope*/
/* 24968*/          /*SwitchOpcode*/ 64, TARGET_VAL(ISD::OR),// ->25035
/* 24971*/            OPC_RecordChild0, // #1 = $addr
/* 24972*/            OPC_RecordChild1, // #2 = $off
/* 24973*/            OPC_MoveChild1,
/* 24974*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 24977*/            OPC_MoveParent,
/* 24978*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 24980*/            OPC_CheckType, MVT::i32,
/* 24982*/            OPC_MoveParent,
/* 24983*/            OPC_MoveChild2,
/* 24984*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 24987*/            OPC_RecordChild0, // #3 = $val
/* 24988*/            OPC_MoveParent,
/* 24989*/            OPC_Scope, 21, /*->25012*/ // 2 children in Scope
/* 24991*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 24993*/              OPC_MoveParent,
/* 24994*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 24996*/              OPC_EmitMergeInputChains1_0,
/* 24997*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25000*/              OPC_EmitConvertToTarget, 2,
/* 25002*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25012*/            /*Scope*/ 21, /*->25034*/
/* 25013*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 25015*/              OPC_MoveParent,
/* 25016*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25018*/              OPC_EmitMergeInputChains1_0,
/* 25019*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25022*/              OPC_EmitConvertToTarget, 2,
/* 25024*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25034*/            0, /*End of Scope*/
/* 25035*/          /*SwitchOpcode*/ 22|128,1/*150*/, TARGET_VAL(WebAssemblyISD::Wrapper),// ->25189
/* 25039*/            OPC_RecordChild0, // #1 = $off
/* 25040*/            OPC_MoveChild0,
/* 25041*/            OPC_SwitchOpcode /*2 cases */, 70, TARGET_VAL(ISD::TargetGlobalAddress),// ->25115
/* 25045*/              OPC_MoveParent,
/* 25046*/              OPC_MoveParent,
/* 25047*/              OPC_MoveChild2,
/* 25048*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25051*/              OPC_RecordChild0, // #2 = $val
/* 25052*/              OPC_MoveParent,
/* 25053*/              OPC_Scope, 29, /*->25084*/ // 2 children in Scope
/* 25055*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 25057*/                OPC_MoveParent,
/* 25058*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25060*/                OPC_EmitMergeInputChains1_0,
/* 25061*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25064*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25067*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 25074*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 25084*/              /*Scope*/ 29, /*->25114*/
/* 25085*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 25087*/                OPC_MoveParent,
/* 25088*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25090*/                OPC_EmitMergeInputChains1_0,
/* 25091*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25094*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25097*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 25104*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 25114*/              0, /*End of Scope*/
/* 25115*/            /*SwitchOpcode*/ 70, TARGET_VAL(ISD::TargetExternalSymbol),// ->25188
/* 25118*/              OPC_MoveParent,
/* 25119*/              OPC_MoveParent,
/* 25120*/              OPC_MoveChild2,
/* 25121*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25124*/              OPC_RecordChild0, // #2 = $val
/* 25125*/              OPC_MoveParent,
/* 25126*/              OPC_Scope, 29, /*->25157*/ // 2 children in Scope
/* 25128*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 25130*/                OPC_MoveParent,
/* 25131*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25133*/                OPC_EmitMergeInputChains1_0,
/* 25134*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25137*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25140*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 25147*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 25157*/              /*Scope*/ 29, /*->25187*/
/* 25158*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 25160*/                OPC_MoveParent,
/* 25161*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25163*/                OPC_EmitMergeInputChains1_0,
/* 25164*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25167*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25170*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 25177*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 25187*/              0, /*End of Scope*/
/* 25188*/            0, // EndSwitchOpcode
/* 25189*/          0, // EndSwitchOpcode
/* 25190*/        /*Scope*/ 10|128,1/*138*/, /*->25330*/
/* 25192*/          OPC_RecordChild1, // #1 = $off
/* 25193*/          OPC_Scope, 77, /*->25272*/ // 2 children in Scope
/* 25195*/            OPC_MoveChild1,
/* 25196*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 25199*/            OPC_MoveParent,
/* 25200*/            OPC_MoveChild2,
/* 25201*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25204*/            OPC_RecordChild0, // #2 = $val
/* 25205*/            OPC_MoveParent,
/* 25206*/            OPC_Scope, 31, /*->25239*/ // 2 children in Scope
/* 25208*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 25210*/              OPC_MoveParent,
/* 25211*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25213*/              OPC_EmitMergeInputChains1_0,
/* 25214*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25217*/              OPC_EmitConvertToTarget, 1,
/* 25219*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25222*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 25229*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>) - Complexity = 13
                        // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 25239*/            /*Scope*/ 31, /*->25271*/
/* 25240*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 25242*/              OPC_MoveParent,
/* 25243*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25245*/              OPC_EmitMergeInputChains1_0,
/* 25246*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25249*/              OPC_EmitConvertToTarget, 1,
/* 25251*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25254*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 25261*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>) - Complexity = 13
                        // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 25271*/            0, /*End of Scope*/
/* 25272*/          /*Scope*/ 56, /*->25329*/
/* 25273*/            OPC_CheckChild1Type, MVT::i32,
/* 25275*/            OPC_MoveChild2,
/* 25276*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25279*/            OPC_RecordChild0, // #2 = $val
/* 25280*/            OPC_MoveParent,
/* 25281*/            OPC_Scope, 22, /*->25305*/ // 2 children in Scope
/* 25283*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_xor_8
/* 25285*/              OPC_MoveParent,
/* 25286*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25288*/              OPC_EmitMergeInputChains1_0,
/* 25289*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25292*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25295*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_8>>) - Complexity = 10
                        // Dst: (ATOMIC_RMW8_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25305*/            /*Scope*/ 22, /*->25328*/
/* 25306*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_xor_16
/* 25308*/              OPC_MoveParent,
/* 25309*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25311*/              OPC_EmitMergeInputChains1_0,
/* 25312*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25315*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25318*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XOR_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_load_xor:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_load_xor_16>>) - Complexity = 10
                        // Dst: (ATOMIC_RMW16_U_XOR_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25328*/            0, /*End of Scope*/
/* 25329*/          0, /*End of Scope*/
/* 25330*/        0, /*End of Scope*/
/* 25331*/      /*SwitchOpcode*/ 61|128,5/*701*/, TARGET_VAL(ISD::ATOMIC_SWAP),// ->26036
/* 25335*/        OPC_RecordMemRef,
/* 25336*/        OPC_RecordNode, // #0 = 'atomic_swap' chained node
/* 25337*/        OPC_Scope, 43|128,4/*555*/, /*->25895*/ // 2 children in Scope
/* 25340*/          OPC_MoveChild1,
/* 25341*/          OPC_SwitchOpcode /*3 cases */, 71|128,2/*327*/, TARGET_VAL(ISD::ADD),// ->25673
/* 25346*/            OPC_Scope, 65, /*->25413*/ // 5 children in Scope
/* 25348*/              OPC_RecordChild0, // #1 = $addr
/* 25349*/              OPC_MoveChild1,
/* 25350*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 25353*/              OPC_RecordChild0, // #2 = $off
/* 25354*/              OPC_MoveChild0,
/* 25355*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 25358*/              OPC_MoveParent,
/* 25359*/              OPC_MoveParent,
/* 25360*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 25362*/              OPC_CheckType, MVT::i32,
/* 25364*/              OPC_MoveParent,
/* 25365*/              OPC_MoveChild2,
/* 25366*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25369*/              OPC_RecordChild0, // #3 = $val
/* 25370*/              OPC_MoveParent,
/* 25371*/              OPC_Scope, 19, /*->25392*/ // 2 children in Scope
/* 25373*/                OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 25375*/                OPC_MoveParent,
/* 25376*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25378*/                OPC_EmitMergeInputChains1_0,
/* 25379*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25382*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25392*/              /*Scope*/ 19, /*->25412*/
/* 25393*/                OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 25395*/                OPC_MoveParent,
/* 25396*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25398*/                OPC_EmitMergeInputChains1_0,
/* 25399*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25402*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25412*/              0, /*End of Scope*/
/* 25413*/            /*Scope*/ 65, /*->25479*/
/* 25414*/              OPC_MoveChild0,
/* 25415*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 25418*/              OPC_RecordChild0, // #1 = $off
/* 25419*/              OPC_MoveChild0,
/* 25420*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 25423*/              OPC_MoveParent,
/* 25424*/              OPC_MoveParent,
/* 25425*/              OPC_RecordChild1, // #2 = $addr
/* 25426*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 25428*/              OPC_CheckType, MVT::i32,
/* 25430*/              OPC_MoveParent,
/* 25431*/              OPC_MoveChild2,
/* 25432*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25435*/              OPC_RecordChild0, // #3 = $val
/* 25436*/              OPC_MoveParent,
/* 25437*/              OPC_Scope, 19, /*->25458*/ // 2 children in Scope
/* 25439*/                OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 25441*/                OPC_MoveParent,
/* 25442*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25444*/                OPC_EmitMergeInputChains1_0,
/* 25445*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25448*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25458*/              /*Scope*/ 19, /*->25478*/
/* 25459*/                OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 25461*/                OPC_MoveParent,
/* 25462*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25464*/                OPC_EmitMergeInputChains1_0,
/* 25465*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25468*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>) - Complexity = 20
                          // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25478*/              0, /*End of Scope*/
/* 25479*/            /*Scope*/ 63, /*->25543*/
/* 25480*/              OPC_RecordChild0, // #1 = $addr
/* 25481*/              OPC_MoveChild1,
/* 25482*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 25485*/              OPC_RecordChild0, // #2 = $off
/* 25486*/              OPC_MoveChild0,
/* 25487*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 25490*/              OPC_MoveParent,
/* 25491*/              OPC_MoveParent,
/* 25492*/              OPC_CheckType, MVT::i32,
/* 25494*/              OPC_MoveParent,
/* 25495*/              OPC_MoveChild2,
/* 25496*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25499*/              OPC_RecordChild0, // #3 = $val
/* 25500*/              OPC_MoveParent,
/* 25501*/              OPC_Scope, 19, /*->25522*/ // 2 children in Scope
/* 25503*/                OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 25505*/                OPC_MoveParent,
/* 25506*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25508*/                OPC_EmitMergeInputChains1_0,
/* 25509*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25512*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25522*/              /*Scope*/ 19, /*->25542*/
/* 25523*/                OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 25525*/                OPC_MoveParent,
/* 25526*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25528*/                OPC_EmitMergeInputChains1_0,
/* 25529*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25532*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 2, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25542*/              0, /*End of Scope*/
/* 25543*/            /*Scope*/ 63, /*->25607*/
/* 25544*/              OPC_MoveChild0,
/* 25545*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 25548*/              OPC_RecordChild0, // #1 = $off
/* 25549*/              OPC_MoveChild0,
/* 25550*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 25553*/              OPC_MoveParent,
/* 25554*/              OPC_MoveParent,
/* 25555*/              OPC_RecordChild1, // #2 = $addr
/* 25556*/              OPC_CheckType, MVT::i32,
/* 25558*/              OPC_MoveParent,
/* 25559*/              OPC_MoveChild2,
/* 25560*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25563*/              OPC_RecordChild0, // #3 = $val
/* 25564*/              OPC_MoveParent,
/* 25565*/              OPC_Scope, 19, /*->25586*/ // 2 children in Scope
/* 25567*/                OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 25569*/                OPC_MoveParent,
/* 25570*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25572*/                OPC_EmitMergeInputChains1_0,
/* 25573*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25576*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25586*/              /*Scope*/ 19, /*->25606*/
/* 25587*/                OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 25589*/                OPC_MoveParent,
/* 25590*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25592*/                OPC_EmitMergeInputChains1_0,
/* 25593*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25596*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 1, 2, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>) - Complexity = 19
                          // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25606*/              0, /*End of Scope*/
/* 25607*/            /*Scope*/ 64, /*->25672*/
/* 25608*/              OPC_RecordChild0, // #1 = $addr
/* 25609*/              OPC_RecordChild1, // #2 = $off
/* 25610*/              OPC_MoveChild1,
/* 25611*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 25614*/              OPC_MoveParent,
/* 25615*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 25617*/              OPC_CheckType, MVT::i32,
/* 25619*/              OPC_MoveParent,
/* 25620*/              OPC_MoveChild2,
/* 25621*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25624*/              OPC_RecordChild0, // #3 = $val
/* 25625*/              OPC_MoveParent,
/* 25626*/              OPC_Scope, 21, /*->25649*/ // 2 children in Scope
/* 25628*/                OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 25630*/                OPC_MoveParent,
/* 25631*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25633*/                OPC_EmitMergeInputChains1_0,
/* 25634*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25637*/                OPC_EmitConvertToTarget, 2,
/* 25639*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>) - Complexity = 17
                          // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25649*/              /*Scope*/ 21, /*->25671*/
/* 25650*/                OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 25652*/                OPC_MoveParent,
/* 25653*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25655*/                OPC_EmitMergeInputChains1_0,
/* 25656*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25659*/                OPC_EmitConvertToTarget, 2,
/* 25661*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>) - Complexity = 17
                          // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25671*/              0, /*End of Scope*/
/* 25672*/            0, /*End of Scope*/
/* 25673*/          /*SwitchOpcode*/ 64, TARGET_VAL(ISD::OR),// ->25740
/* 25676*/            OPC_RecordChild0, // #1 = $addr
/* 25677*/            OPC_RecordChild1, // #2 = $off
/* 25678*/            OPC_MoveChild1,
/* 25679*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 25682*/            OPC_MoveParent,
/* 25683*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 25685*/            OPC_CheckType, MVT::i32,
/* 25687*/            OPC_MoveParent,
/* 25688*/            OPC_MoveChild2,
/* 25689*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25692*/            OPC_RecordChild0, // #3 = $val
/* 25693*/            OPC_MoveParent,
/* 25694*/            OPC_Scope, 21, /*->25717*/ // 2 children in Scope
/* 25696*/              OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 25698*/              OPC_MoveParent,
/* 25699*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25701*/              OPC_EmitMergeInputChains1_0,
/* 25702*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25705*/              OPC_EmitConvertToTarget, 2,
/* 25707*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25717*/            /*Scope*/ 21, /*->25739*/
/* 25718*/              OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 25720*/              OPC_MoveParent,
/* 25721*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25723*/              OPC_EmitMergeInputChains1_0,
/* 25724*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25727*/              OPC_EmitConvertToTarget, 2,
/* 25729*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 4, 5, 1, 3, 
                        // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>) - Complexity = 17
                        // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 25739*/            0, /*End of Scope*/
/* 25740*/          /*SwitchOpcode*/ 22|128,1/*150*/, TARGET_VAL(WebAssemblyISD::Wrapper),// ->25894
/* 25744*/            OPC_RecordChild0, // #1 = $off
/* 25745*/            OPC_MoveChild0,
/* 25746*/            OPC_SwitchOpcode /*2 cases */, 70, TARGET_VAL(ISD::TargetGlobalAddress),// ->25820
/* 25750*/              OPC_MoveParent,
/* 25751*/              OPC_MoveParent,
/* 25752*/              OPC_MoveChild2,
/* 25753*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25756*/              OPC_RecordChild0, // #2 = $val
/* 25757*/              OPC_MoveParent,
/* 25758*/              OPC_Scope, 29, /*->25789*/ // 2 children in Scope
/* 25760*/                OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 25762*/                OPC_MoveParent,
/* 25763*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25765*/                OPC_EmitMergeInputChains1_0,
/* 25766*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25769*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25772*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 25779*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 25789*/              /*Scope*/ 29, /*->25819*/
/* 25790*/                OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 25792*/                OPC_MoveParent,
/* 25793*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25795*/                OPC_EmitMergeInputChains1_0,
/* 25796*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25799*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25802*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 25809*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 25819*/              0, /*End of Scope*/
/* 25820*/            /*SwitchOpcode*/ 70, TARGET_VAL(ISD::TargetExternalSymbol),// ->25893
/* 25823*/              OPC_MoveParent,
/* 25824*/              OPC_MoveParent,
/* 25825*/              OPC_MoveChild2,
/* 25826*/              OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25829*/              OPC_RecordChild0, // #2 = $val
/* 25830*/              OPC_MoveParent,
/* 25831*/              OPC_Scope, 29, /*->25862*/ // 2 children in Scope
/* 25833*/                OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 25835*/                OPC_MoveParent,
/* 25836*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25838*/                OPC_EmitMergeInputChains1_0,
/* 25839*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25842*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25845*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 25852*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 25862*/              /*Scope*/ 29, /*->25892*/
/* 25863*/                OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 25865*/                OPC_MoveParent,
/* 25866*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25868*/                OPC_EmitMergeInputChains1_0,
/* 25869*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25872*/                OPC_EmitInteger, MVT::i32, 0, 
/* 25875*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 25882*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 4/*#Ops*/, 3, 1, 5, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>) - Complexity = 16
                          // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 25892*/              0, /*End of Scope*/
/* 25893*/            0, // EndSwitchOpcode
/* 25894*/          0, // EndSwitchOpcode
/* 25895*/        /*Scope*/ 10|128,1/*138*/, /*->26035*/
/* 25897*/          OPC_RecordChild1, // #1 = $off
/* 25898*/          OPC_Scope, 77, /*->25977*/ // 2 children in Scope
/* 25900*/            OPC_MoveChild1,
/* 25901*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 25904*/            OPC_MoveParent,
/* 25905*/            OPC_MoveChild2,
/* 25906*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25909*/            OPC_RecordChild0, // #2 = $val
/* 25910*/            OPC_MoveParent,
/* 25911*/            OPC_Scope, 31, /*->25944*/ // 2 children in Scope
/* 25913*/              OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 25915*/              OPC_MoveParent,
/* 25916*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25918*/              OPC_EmitMergeInputChains1_0,
/* 25919*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25922*/              OPC_EmitConvertToTarget, 1,
/* 25924*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25927*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 25934*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>) - Complexity = 13
                        // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 25944*/            /*Scope*/ 31, /*->25976*/
/* 25945*/              OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 25947*/              OPC_MoveParent,
/* 25948*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25950*/              OPC_EmitMergeInputChains1_0,
/* 25951*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25954*/              OPC_EmitConvertToTarget, 1,
/* 25956*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25959*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 25966*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 6, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } (imm:{ *:[iPTR] }):$off, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>) - Complexity = 13
                        // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$val)
/* 25976*/            0, /*End of Scope*/
/* 25977*/          /*Scope*/ 56, /*->26034*/
/* 25978*/            OPC_CheckChild1Type, MVT::i32,
/* 25980*/            OPC_MoveChild2,
/* 25981*/            OPC_CheckOpcode, TARGET_VAL(ISD::TRUNCATE),
/* 25984*/            OPC_RecordChild0, // #2 = $val
/* 25985*/            OPC_MoveParent,
/* 25986*/            OPC_Scope, 22, /*->26010*/ // 2 children in Scope
/* 25988*/              OPC_CheckPredicate, 1, // Predicate_atomic_swap_8
/* 25990*/              OPC_MoveParent,
/* 25991*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 25993*/              OPC_EmitMergeInputChains1_0,
/* 25994*/              OPC_EmitInteger, MVT::i32, 0, 
/* 25997*/              OPC_EmitInteger, MVT::i32, 0, 
/* 26000*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW8_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_8>>) - Complexity = 10
                        // Dst: (ATOMIC_RMW8_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 26010*/            /*Scope*/ 22, /*->26033*/
/* 26011*/              OPC_CheckPredicate, 2, // Predicate_atomic_swap_16
/* 26013*/              OPC_MoveParent,
/* 26014*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26016*/              OPC_EmitMergeInputChains1_0,
/* 26017*/              OPC_EmitInteger, MVT::i32, 0, 
/* 26020*/              OPC_EmitInteger, MVT::i32, 0, 
/* 26023*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_RMW16_U_XCHG_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 4/*#Ops*/, 3, 4, 1, 2, 
                        // Src: (anyext:{ *:[i64] } (atomic_swap:{ *:[i32] } I32:{ *:[i32] }:$addr, (trunc:{ *:[i32] } i64:{ *:[i64] }:$val))<<P:Predicate_atomic_swap_16>>) - Complexity = 10
                        // Dst: (ATOMIC_RMW16_U_XCHG_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$val)
/* 26033*/            0, /*End of Scope*/
/* 26034*/          0, /*End of Scope*/
/* 26035*/        0, /*End of Scope*/
/* 26036*/      /*SwitchOpcode*/ 108|128,4/*620*/, TARGET_VAL(ISD::ATOMIC_LOAD),// ->26660
/* 26040*/        OPC_RecordMemRef,
/* 26041*/        OPC_RecordNode, // #0 = 'atomic_load' chained node
/* 26042*/        OPC_Scope, 107|128,3/*491*/, /*->26536*/ // 2 children in Scope
/* 26045*/          OPC_MoveChild1,
/* 26046*/          OPC_SwitchOpcode /*3 cases */, 31|128,2/*287*/, TARGET_VAL(ISD::ADD),// ->26338
/* 26051*/            OPC_Scope, 57, /*->26110*/ // 5 children in Scope
/* 26053*/              OPC_RecordChild0, // #1 = $addr
/* 26054*/              OPC_MoveChild1,
/* 26055*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 26058*/              OPC_RecordChild0, // #2 = $off
/* 26059*/              OPC_MoveChild0,
/* 26060*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 26063*/              OPC_MoveParent,
/* 26064*/              OPC_MoveParent,
/* 26065*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 26067*/              OPC_CheckType, MVT::i32,
/* 26069*/              OPC_MoveParent,
/* 26070*/              OPC_Scope, 18, /*->26090*/ // 2 children in Scope
/* 26072*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 26074*/                OPC_MoveParent,
/* 26075*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26077*/                OPC_EmitMergeInputChains1_0,
/* 26078*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26081*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 3, 2, 1, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>)<<P:Predicate_atomic_load_8>>) - Complexity = 17
                          // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 26090*/              /*Scope*/ 18, /*->26109*/
/* 26091*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 26093*/                OPC_MoveParent,
/* 26094*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26096*/                OPC_EmitMergeInputChains1_0,
/* 26097*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26100*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 3, 2, 1, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>)<<P:Predicate_atomic_load_16>>) - Complexity = 17
                          // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 26109*/              0, /*End of Scope*/
/* 26110*/            /*Scope*/ 57, /*->26168*/
/* 26111*/              OPC_MoveChild0,
/* 26112*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 26115*/              OPC_RecordChild0, // #1 = $off
/* 26116*/              OPC_MoveChild0,
/* 26117*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 26120*/              OPC_MoveParent,
/* 26121*/              OPC_MoveParent,
/* 26122*/              OPC_RecordChild1, // #2 = $addr
/* 26123*/              OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 26125*/              OPC_CheckType, MVT::i32,
/* 26127*/              OPC_MoveParent,
/* 26128*/              OPC_Scope, 18, /*->26148*/ // 2 children in Scope
/* 26130*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 26132*/                OPC_MoveParent,
/* 26133*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26135*/                OPC_EmitMergeInputChains1_0,
/* 26136*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26139*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 3, 1, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>)<<P:Predicate_atomic_load_8>>) - Complexity = 17
                          // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 26148*/              /*Scope*/ 18, /*->26167*/
/* 26149*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 26151*/                OPC_MoveParent,
/* 26152*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26154*/                OPC_EmitMergeInputChains1_0,
/* 26155*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26158*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 3, 1, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>)<<P:Predicate_atomic_load_16>>) - Complexity = 17
                          // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 26167*/              0, /*End of Scope*/
/* 26168*/            /*Scope*/ 55, /*->26224*/
/* 26169*/              OPC_RecordChild0, // #1 = $addr
/* 26170*/              OPC_MoveChild1,
/* 26171*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 26174*/              OPC_RecordChild0, // #2 = $off
/* 26175*/              OPC_MoveChild0,
/* 26176*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 26179*/              OPC_MoveParent,
/* 26180*/              OPC_MoveParent,
/* 26181*/              OPC_CheckType, MVT::i32,
/* 26183*/              OPC_MoveParent,
/* 26184*/              OPC_Scope, 18, /*->26204*/ // 2 children in Scope
/* 26186*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 26188*/                OPC_MoveParent,
/* 26189*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26191*/                OPC_EmitMergeInputChains1_0,
/* 26192*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26195*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 3, 2, 1, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)))<<P:Predicate_atomic_load_8>>) - Complexity = 16
                          // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 26204*/              /*Scope*/ 18, /*->26223*/
/* 26205*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 26207*/                OPC_MoveParent,
/* 26208*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26210*/                OPC_EmitMergeInputChains1_0,
/* 26211*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26214*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 3, 2, 1, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)))<<P:Predicate_atomic_load_16>>) - Complexity = 16
                          // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 26223*/              0, /*End of Scope*/
/* 26224*/            /*Scope*/ 55, /*->26280*/
/* 26225*/              OPC_MoveChild0,
/* 26226*/              OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 26229*/              OPC_RecordChild0, // #1 = $off
/* 26230*/              OPC_MoveChild0,
/* 26231*/              OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 26234*/              OPC_MoveParent,
/* 26235*/              OPC_MoveParent,
/* 26236*/              OPC_RecordChild1, // #2 = $addr
/* 26237*/              OPC_CheckType, MVT::i32,
/* 26239*/              OPC_MoveParent,
/* 26240*/              OPC_Scope, 18, /*->26260*/ // 2 children in Scope
/* 26242*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 26244*/                OPC_MoveParent,
/* 26245*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26247*/                OPC_EmitMergeInputChains1_0,
/* 26248*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26251*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 3, 1, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr))<<P:Predicate_atomic_load_8>>) - Complexity = 16
                          // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 26260*/              /*Scope*/ 18, /*->26279*/
/* 26261*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 26263*/                OPC_MoveParent,
/* 26264*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26266*/                OPC_EmitMergeInputChains1_0,
/* 26267*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26270*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 3, 1, 2, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr))<<P:Predicate_atomic_load_16>>) - Complexity = 16
                          // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 26279*/              0, /*End of Scope*/
/* 26280*/            /*Scope*/ 56, /*->26337*/
/* 26281*/              OPC_RecordChild0, // #1 = $addr
/* 26282*/              OPC_RecordChild1, // #2 = $off
/* 26283*/              OPC_MoveChild1,
/* 26284*/              OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 26287*/              OPC_MoveParent,
/* 26288*/              OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 26290*/              OPC_CheckType, MVT::i32,
/* 26292*/              OPC_MoveParent,
/* 26293*/              OPC_Scope, 20, /*->26315*/ // 2 children in Scope
/* 26295*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 26297*/                OPC_MoveParent,
/* 26298*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26300*/                OPC_EmitMergeInputChains1_0,
/* 26301*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26304*/                OPC_EmitConvertToTarget, 2,
/* 26306*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 3, 4, 1, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>)<<P:Predicate_atomic_load_8>>) - Complexity = 14
                          // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 26315*/              /*Scope*/ 20, /*->26336*/
/* 26316*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 26318*/                OPC_MoveParent,
/* 26319*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26321*/                OPC_EmitMergeInputChains1_0,
/* 26322*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26325*/                OPC_EmitConvertToTarget, 2,
/* 26327*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 3, 4, 1, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>)<<P:Predicate_atomic_load_16>>) - Complexity = 14
                          // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 26336*/              0, /*End of Scope*/
/* 26337*/            0, /*End of Scope*/
/* 26338*/          /*SwitchOpcode*/ 56, TARGET_VAL(ISD::OR),// ->26397
/* 26341*/            OPC_RecordChild0, // #1 = $addr
/* 26342*/            OPC_RecordChild1, // #2 = $off
/* 26343*/            OPC_MoveChild1,
/* 26344*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 26347*/            OPC_MoveParent,
/* 26348*/            OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 26350*/            OPC_CheckType, MVT::i32,
/* 26352*/            OPC_MoveParent,
/* 26353*/            OPC_Scope, 20, /*->26375*/ // 2 children in Scope
/* 26355*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 26357*/              OPC_MoveParent,
/* 26358*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26360*/              OPC_EmitMergeInputChains1_0,
/* 26361*/              OPC_EmitInteger, MVT::i32, 0, 
/* 26364*/              OPC_EmitConvertToTarget, 2,
/* 26366*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 3, 4, 1, 
                        // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>)<<P:Predicate_atomic_load_8>>) - Complexity = 14
                        // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 26375*/            /*Scope*/ 20, /*->26396*/
/* 26376*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 26378*/              OPC_MoveParent,
/* 26379*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26381*/              OPC_EmitMergeInputChains1_0,
/* 26382*/              OPC_EmitInteger, MVT::i32, 0, 
/* 26385*/              OPC_EmitConvertToTarget, 2,
/* 26387*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 3, 4, 1, 
                        // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>)<<P:Predicate_atomic_load_16>>) - Complexity = 14
                        // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr)
/* 26396*/            0, /*End of Scope*/
/* 26397*/          /*SwitchOpcode*/ 6|128,1/*134*/, TARGET_VAL(WebAssemblyISD::Wrapper),// ->26535
/* 26401*/            OPC_RecordChild0, // #1 = $off
/* 26402*/            OPC_MoveChild0,
/* 26403*/            OPC_SwitchOpcode /*2 cases */, 62, TARGET_VAL(ISD::TargetGlobalAddress),// ->26469
/* 26407*/              OPC_MoveParent,
/* 26408*/              OPC_MoveParent,
/* 26409*/              OPC_Scope, 28, /*->26439*/ // 2 children in Scope
/* 26411*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 26413*/                OPC_MoveParent,
/* 26414*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26416*/                OPC_EmitMergeInputChains1_0,
/* 26417*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26420*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26423*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 26430*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 2, 1, 4, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off))<<P:Predicate_atomic_load_8>>) - Complexity = 13
                          // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 26439*/              /*Scope*/ 28, /*->26468*/
/* 26440*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 26442*/                OPC_MoveParent,
/* 26443*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26445*/                OPC_EmitMergeInputChains1_0,
/* 26446*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26449*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26452*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 26459*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 2, 1, 4, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off))<<P:Predicate_atomic_load_16>>) - Complexity = 13
                          // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 26468*/              0, /*End of Scope*/
/* 26469*/            /*SwitchOpcode*/ 62, TARGET_VAL(ISD::TargetExternalSymbol),// ->26534
/* 26472*/              OPC_MoveParent,
/* 26473*/              OPC_MoveParent,
/* 26474*/              OPC_Scope, 28, /*->26504*/ // 2 children in Scope
/* 26476*/                OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 26478*/                OPC_MoveParent,
/* 26479*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26481*/                OPC_EmitMergeInputChains1_0,
/* 26482*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26485*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26488*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 26495*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 2, 1, 4, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off))<<P:Predicate_atomic_load_8>>) - Complexity = 13
                          // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 26504*/              /*Scope*/ 28, /*->26533*/
/* 26505*/                OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 26507*/                OPC_MoveParent,
/* 26508*/                OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26510*/                OPC_EmitMergeInputChains1_0,
/* 26511*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26514*/                OPC_EmitInteger, MVT::i32, 0, 
/* 26517*/                OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                              MVT::i32, 1/*#Ops*/, 3,  // Results = #4
/* 26524*/                OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                              MVT::i64, 3/*#Ops*/, 2, 1, 4, 
                          // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off))<<P:Predicate_atomic_load_16>>) - Complexity = 13
                          // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 26533*/              0, /*End of Scope*/
/* 26534*/            0, // EndSwitchOpcode
/* 26535*/          0, // EndSwitchOpcode
/* 26536*/        /*Scope*/ 122, /*->26659*/
/* 26537*/          OPC_RecordChild1, // #1 = $off
/* 26538*/          OPC_Scope, 69, /*->26609*/ // 2 children in Scope
/* 26540*/            OPC_MoveChild1,
/* 26541*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 26544*/            OPC_MoveParent,
/* 26545*/            OPC_Scope, 30, /*->26577*/ // 2 children in Scope
/* 26547*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 26549*/              OPC_MoveParent,
/* 26550*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26552*/              OPC_EmitMergeInputChains1_0,
/* 26553*/              OPC_EmitInteger, MVT::i32, 0, 
/* 26556*/              OPC_EmitConvertToTarget, 1,
/* 26558*/              OPC_EmitInteger, MVT::i32, 0, 
/* 26561*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 26568*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 2, 3, 5, 
                        // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (imm:{ *:[iPTR] }):$off)<<P:Predicate_atomic_load_8>>) - Complexity = 10
                        // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 26577*/            /*Scope*/ 30, /*->26608*/
/* 26578*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 26580*/              OPC_MoveParent,
/* 26581*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26583*/              OPC_EmitMergeInputChains1_0,
/* 26584*/              OPC_EmitInteger, MVT::i32, 0, 
/* 26587*/              OPC_EmitConvertToTarget, 1,
/* 26589*/              OPC_EmitInteger, MVT::i32, 0, 
/* 26592*/              OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                            MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 26599*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 2, 3, 5, 
                        // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } (imm:{ *:[iPTR] }):$off)<<P:Predicate_atomic_load_16>>) - Complexity = 10
                        // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }))
/* 26608*/            0, /*End of Scope*/
/* 26609*/          /*Scope*/ 48, /*->26658*/
/* 26610*/            OPC_CheckChild1Type, MVT::i32,
/* 26612*/            OPC_Scope, 21, /*->26635*/ // 2 children in Scope
/* 26614*/              OPC_CheckPredicate, 1, // Predicate_atomic_load_8
/* 26616*/              OPC_MoveParent,
/* 26617*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26619*/              OPC_EmitMergeInputChains1_0,
/* 26620*/              OPC_EmitInteger, MVT::i32, 0, 
/* 26623*/              OPC_EmitInteger, MVT::i32, 0, 
/* 26626*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD8_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 2, 3, 1, 
                        // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } I32:{ *:[i32] }:$addr)<<P:Predicate_atomic_load_8>>) - Complexity = 7
                        // Dst: (ATOMIC_LOAD8_U_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr)
/* 26635*/            /*Scope*/ 21, /*->26657*/
/* 26636*/              OPC_CheckPredicate, 2, // Predicate_atomic_load_16
/* 26638*/              OPC_MoveParent,
/* 26639*/              OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26641*/              OPC_EmitMergeInputChains1_0,
/* 26642*/              OPC_EmitInteger, MVT::i32, 0, 
/* 26645*/              OPC_EmitInteger, MVT::i32, 0, 
/* 26648*/              OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_LOAD16_U_I64), 0|OPFL_Chain|OPFL_MemRefs,
                            MVT::i64, 3/*#Ops*/, 2, 3, 1, 
                        // Src: (anyext:{ *:[i64] } (atomic_load:{ *:[i32] } I32:{ *:[i32] }:$addr)<<P:Predicate_atomic_load_16>>) - Complexity = 7
                        // Dst: (ATOMIC_LOAD16_U_I64:{ *:[i64] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr)
/* 26657*/            0, /*End of Scope*/
/* 26658*/          0, /*End of Scope*/
/* 26659*/        0, /*End of Scope*/
/* 26660*/      0, // EndSwitchOpcode
/* 26661*/    /*Scope*/ 8, /*->26670*/
/* 26662*/      OPC_RecordChild0, // #0 = $src
/* 26663*/      OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::I64_EXTEND_U_I32), 0,
                    MVT::i64, 1/*#Ops*/, 0, 
                // Src: (anyext:{ *:[i64] } I32:{ *:[i32] }:$src) - Complexity = 3
                // Dst: (I64_EXTEND_U_I32:{ *:[i64] } I32:{ *:[i32] }:$src)
/* 26670*/    0, /*End of Scope*/
/* 26671*/  /*SwitchOpcode*/ 54|128,9/*1206*/, TARGET_VAL(ISD::INTRINSIC_W_CHAIN),// ->27881
/* 26675*/    OPC_Scope, 1|128,7/*897*/, /*->27575*/ // 3 children in Scope
/* 26678*/      OPC_RecordMemRef,
/* 26679*/      OPC_RecordNode, // #0 = 'intrinsic_w_chain' chained node
/* 26680*/      OPC_Scope, 29|128,2/*285*/, /*->26968*/ // 3 children in Scope
/* 26683*/        OPC_CheckChild1Integer, 28|128,43/*5532*/, 
/* 26686*/        OPC_MoveChild2,
/* 26687*/        OPC_SwitchOpcode /*3 cases */, 42|128,1/*170*/, TARGET_VAL(ISD::ADD),// ->26862
/* 26692*/          OPC_Scope, 34, /*->26728*/ // 5 children in Scope
/* 26694*/            OPC_RecordChild0, // #1 = $addr
/* 26695*/            OPC_MoveChild1,
/* 26696*/            OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 26699*/            OPC_RecordChild0, // #2 = $off
/* 26700*/            OPC_MoveChild0,
/* 26701*/            OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 26704*/            OPC_MoveParent,
/* 26705*/            OPC_MoveParent,
/* 26706*/            OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 26708*/            OPC_CheckType, MVT::i32,
/* 26710*/            OPC_MoveParent,
/* 26711*/            OPC_RecordChild3, // #3 = $count
/* 26712*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26714*/            OPC_EmitMergeInputChains1_0,
/* 26715*/            OPC_EmitInteger, MVT::i32, 0, 
/* 26718*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_NOTIFY), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5532:{ *:[iPTR] }, (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, I32:{ *:[i32] }:$count) - Complexity = 18
                      // Dst: (ATOMIC_NOTIFY:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, I32:{ *:[i32] }:$count)
/* 26728*/          /*Scope*/ 34, /*->26763*/
/* 26729*/            OPC_MoveChild0,
/* 26730*/            OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 26733*/            OPC_RecordChild0, // #1 = $off
/* 26734*/            OPC_MoveChild0,
/* 26735*/            OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 26738*/            OPC_MoveParent,
/* 26739*/            OPC_MoveParent,
/* 26740*/            OPC_RecordChild1, // #2 = $addr
/* 26741*/            OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 26743*/            OPC_CheckType, MVT::i32,
/* 26745*/            OPC_MoveParent,
/* 26746*/            OPC_RecordChild3, // #3 = $count
/* 26747*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26749*/            OPC_EmitMergeInputChains1_0,
/* 26750*/            OPC_EmitInteger, MVT::i32, 0, 
/* 26753*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_NOTIFY), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5532:{ *:[iPTR] }, (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, I32:{ *:[i32] }:$count) - Complexity = 18
                      // Dst: (ATOMIC_NOTIFY:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, I32:{ *:[i32] }:$count)
/* 26763*/          /*Scope*/ 32, /*->26796*/
/* 26764*/            OPC_RecordChild0, // #1 = $addr
/* 26765*/            OPC_MoveChild1,
/* 26766*/            OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 26769*/            OPC_RecordChild0, // #2 = $off
/* 26770*/            OPC_MoveChild0,
/* 26771*/            OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 26774*/            OPC_MoveParent,
/* 26775*/            OPC_MoveParent,
/* 26776*/            OPC_CheckType, MVT::i32,
/* 26778*/            OPC_MoveParent,
/* 26779*/            OPC_RecordChild3, // #3 = $count
/* 26780*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26782*/            OPC_EmitMergeInputChains1_0,
/* 26783*/            OPC_EmitInteger, MVT::i32, 0, 
/* 26786*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_NOTIFY), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 4/*#Ops*/, 4, 2, 1, 3, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5532:{ *:[iPTR] }, (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), I32:{ *:[i32] }:$count) - Complexity = 17
                      // Dst: (ATOMIC_NOTIFY:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, I32:{ *:[i32] }:$count)
/* 26796*/          /*Scope*/ 32, /*->26829*/
/* 26797*/            OPC_MoveChild0,
/* 26798*/            OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 26801*/            OPC_RecordChild0, // #1 = $off
/* 26802*/            OPC_MoveChild0,
/* 26803*/            OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 26806*/            OPC_MoveParent,
/* 26807*/            OPC_MoveParent,
/* 26808*/            OPC_RecordChild1, // #2 = $addr
/* 26809*/            OPC_CheckType, MVT::i32,
/* 26811*/            OPC_MoveParent,
/* 26812*/            OPC_RecordChild3, // #3 = $count
/* 26813*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26815*/            OPC_EmitMergeInputChains1_0,
/* 26816*/            OPC_EmitInteger, MVT::i32, 0, 
/* 26819*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_NOTIFY), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 4/*#Ops*/, 4, 1, 2, 3, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5532:{ *:[iPTR] }, (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), I32:{ *:[i32] }:$count) - Complexity = 17
                      // Dst: (ATOMIC_NOTIFY:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, I32:{ *:[i32] }:$count)
/* 26829*/          /*Scope*/ 31, /*->26861*/
/* 26830*/            OPC_RecordChild0, // #1 = $addr
/* 26831*/            OPC_RecordChild1, // #2 = $off
/* 26832*/            OPC_MoveChild1,
/* 26833*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 26836*/            OPC_MoveParent,
/* 26837*/            OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 26839*/            OPC_CheckType, MVT::i32,
/* 26841*/            OPC_MoveParent,
/* 26842*/            OPC_RecordChild3, // #3 = $count
/* 26843*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26845*/            OPC_EmitMergeInputChains1_0,
/* 26846*/            OPC_EmitInteger, MVT::i32, 0, 
/* 26849*/            OPC_EmitConvertToTarget, 2,
/* 26851*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_NOTIFY), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5532:{ *:[iPTR] }, (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, I32:{ *:[i32] }:$count) - Complexity = 15
                      // Dst: (ATOMIC_NOTIFY:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, I32:{ *:[i32] }:$count)
/* 26861*/          0, /*End of Scope*/
/* 26862*/        /*SwitchOpcode*/ 31, TARGET_VAL(ISD::OR),// ->26896
/* 26865*/          OPC_RecordChild0, // #1 = $addr
/* 26866*/          OPC_RecordChild1, // #2 = $off
/* 26867*/          OPC_MoveChild1,
/* 26868*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 26871*/          OPC_MoveParent,
/* 26872*/          OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 26874*/          OPC_CheckType, MVT::i32,
/* 26876*/          OPC_MoveParent,
/* 26877*/          OPC_RecordChild3, // #3 = $count
/* 26878*/          OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26880*/          OPC_EmitMergeInputChains1_0,
/* 26881*/          OPC_EmitInteger, MVT::i32, 0, 
/* 26884*/          OPC_EmitConvertToTarget, 2,
/* 26886*/          OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_NOTIFY), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 4/*#Ops*/, 4, 5, 1, 3, 
                    // Src: (intrinsic_w_chain:{ *:[i32] } 5532:{ *:[iPTR] }, (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, I32:{ *:[i32] }:$count) - Complexity = 15
                    // Dst: (ATOMIC_NOTIFY:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, I32:{ *:[i32] }:$count)
/* 26896*/        /*SwitchOpcode*/ 68, TARGET_VAL(WebAssemblyISD::Wrapper),// ->26967
/* 26899*/          OPC_RecordChild0, // #1 = $off
/* 26900*/          OPC_MoveChild0,
/* 26901*/          OPC_SwitchOpcode /*2 cases */, 29, TARGET_VAL(ISD::TargetGlobalAddress),// ->26934
/* 26905*/            OPC_MoveParent,
/* 26906*/            OPC_MoveParent,
/* 26907*/            OPC_RecordChild3, // #2 = $count
/* 26908*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26910*/            OPC_EmitMergeInputChains1_0,
/* 26911*/            OPC_EmitInteger, MVT::i32, 0, 
/* 26914*/            OPC_EmitInteger, MVT::i32, 0, 
/* 26917*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 26924*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_NOTIFY), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5532:{ *:[iPTR] }, (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), I32:{ *:[i32] }:$count) - Complexity = 14
                      // Dst: (ATOMIC_NOTIFY:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), I32:{ *:[i32] }:$count)
/* 26934*/          /*SwitchOpcode*/ 29, TARGET_VAL(ISD::TargetExternalSymbol),// ->26966
/* 26937*/            OPC_MoveParent,
/* 26938*/            OPC_MoveParent,
/* 26939*/            OPC_RecordChild3, // #2 = $count
/* 26940*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 26942*/            OPC_EmitMergeInputChains1_0,
/* 26943*/            OPC_EmitInteger, MVT::i32, 0, 
/* 26946*/            OPC_EmitInteger, MVT::i32, 0, 
/* 26949*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 4,  // Results = #5
/* 26956*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_NOTIFY), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 4/*#Ops*/, 3, 1, 5, 2, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5532:{ *:[iPTR] }, (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), I32:{ *:[i32] }:$count) - Complexity = 14
                      // Dst: (ATOMIC_NOTIFY:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), I32:{ *:[i32] }:$count)
/* 26966*/          0, // EndSwitchOpcode
/* 26967*/        0, // EndSwitchOpcode
/* 26968*/      /*Scope*/ 45|128,2/*301*/, /*->27271*/
/* 26970*/        OPC_CheckChild1Integer, 29|128,43/*5533*/, 
/* 26973*/        OPC_MoveChild2,
/* 26974*/        OPC_SwitchOpcode /*3 cases */, 52|128,1/*180*/, TARGET_VAL(ISD::ADD),// ->27159
/* 26979*/          OPC_Scope, 36, /*->27017*/ // 5 children in Scope
/* 26981*/            OPC_RecordChild0, // #1 = $addr
/* 26982*/            OPC_MoveChild1,
/* 26983*/            OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 26986*/            OPC_RecordChild0, // #2 = $off
/* 26987*/            OPC_MoveChild0,
/* 26988*/            OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 26991*/            OPC_MoveParent,
/* 26992*/            OPC_MoveParent,
/* 26993*/            OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 26995*/            OPC_CheckType, MVT::i32,
/* 26997*/            OPC_MoveParent,
/* 26998*/            OPC_RecordChild3, // #3 = $exp
/* 26999*/            OPC_RecordChild4, // #4 = $timeout
/* 27000*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27002*/            OPC_EmitMergeInputChains1_0,
/* 27003*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27006*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I32), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5533:{ *:[iPTR] }, (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 18
                      // Dst: (ATOMIC_WAIT_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27017*/          /*Scope*/ 36, /*->27054*/
/* 27018*/            OPC_MoveChild0,
/* 27019*/            OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 27022*/            OPC_RecordChild0, // #1 = $off
/* 27023*/            OPC_MoveChild0,
/* 27024*/            OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 27027*/            OPC_MoveParent,
/* 27028*/            OPC_MoveParent,
/* 27029*/            OPC_RecordChild1, // #2 = $addr
/* 27030*/            OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 27032*/            OPC_CheckType, MVT::i32,
/* 27034*/            OPC_MoveParent,
/* 27035*/            OPC_RecordChild3, // #3 = $exp
/* 27036*/            OPC_RecordChild4, // #4 = $timeout
/* 27037*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27039*/            OPC_EmitMergeInputChains1_0,
/* 27040*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27043*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I32), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5533:{ *:[iPTR] }, (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 18
                      // Dst: (ATOMIC_WAIT_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27054*/          /*Scope*/ 34, /*->27089*/
/* 27055*/            OPC_RecordChild0, // #1 = $addr
/* 27056*/            OPC_MoveChild1,
/* 27057*/            OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 27060*/            OPC_RecordChild0, // #2 = $off
/* 27061*/            OPC_MoveChild0,
/* 27062*/            OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 27065*/            OPC_MoveParent,
/* 27066*/            OPC_MoveParent,
/* 27067*/            OPC_CheckType, MVT::i32,
/* 27069*/            OPC_MoveParent,
/* 27070*/            OPC_RecordChild3, // #3 = $exp
/* 27071*/            OPC_RecordChild4, // #4 = $timeout
/* 27072*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27074*/            OPC_EmitMergeInputChains1_0,
/* 27075*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27078*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I32), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5533:{ *:[iPTR] }, (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 17
                      // Dst: (ATOMIC_WAIT_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27089*/          /*Scope*/ 34, /*->27124*/
/* 27090*/            OPC_MoveChild0,
/* 27091*/            OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 27094*/            OPC_RecordChild0, // #1 = $off
/* 27095*/            OPC_MoveChild0,
/* 27096*/            OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 27099*/            OPC_MoveParent,
/* 27100*/            OPC_MoveParent,
/* 27101*/            OPC_RecordChild1, // #2 = $addr
/* 27102*/            OPC_CheckType, MVT::i32,
/* 27104*/            OPC_MoveParent,
/* 27105*/            OPC_RecordChild3, // #3 = $exp
/* 27106*/            OPC_RecordChild4, // #4 = $timeout
/* 27107*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27109*/            OPC_EmitMergeInputChains1_0,
/* 27110*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27113*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I32), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5533:{ *:[iPTR] }, (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 17
                      // Dst: (ATOMIC_WAIT_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27124*/          /*Scope*/ 33, /*->27158*/
/* 27125*/            OPC_RecordChild0, // #1 = $addr
/* 27126*/            OPC_RecordChild1, // #2 = $off
/* 27127*/            OPC_MoveChild1,
/* 27128*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 27131*/            OPC_MoveParent,
/* 27132*/            OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 27134*/            OPC_CheckType, MVT::i32,
/* 27136*/            OPC_MoveParent,
/* 27137*/            OPC_RecordChild3, // #3 = $exp
/* 27138*/            OPC_RecordChild4, // #4 = $timeout
/* 27139*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27141*/            OPC_EmitMergeInputChains1_0,
/* 27142*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27145*/            OPC_EmitConvertToTarget, 2,
/* 27147*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I32), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5533:{ *:[iPTR] }, (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 15
                      // Dst: (ATOMIC_WAIT_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27158*/          0, /*End of Scope*/
/* 27159*/        /*SwitchOpcode*/ 33, TARGET_VAL(ISD::OR),// ->27195
/* 27162*/          OPC_RecordChild0, // #1 = $addr
/* 27163*/          OPC_RecordChild1, // #2 = $off
/* 27164*/          OPC_MoveChild1,
/* 27165*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 27168*/          OPC_MoveParent,
/* 27169*/          OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 27171*/          OPC_CheckType, MVT::i32,
/* 27173*/          OPC_MoveParent,
/* 27174*/          OPC_RecordChild3, // #3 = $exp
/* 27175*/          OPC_RecordChild4, // #4 = $timeout
/* 27176*/          OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27178*/          OPC_EmitMergeInputChains1_0,
/* 27179*/          OPC_EmitInteger, MVT::i32, 0, 
/* 27182*/          OPC_EmitConvertToTarget, 2,
/* 27184*/          OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I32), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                    // Src: (intrinsic_w_chain:{ *:[i32] } 5533:{ *:[iPTR] }, (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 15
                    // Dst: (ATOMIC_WAIT_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27195*/        /*SwitchOpcode*/ 72, TARGET_VAL(WebAssemblyISD::Wrapper),// ->27270
/* 27198*/          OPC_RecordChild0, // #1 = $off
/* 27199*/          OPC_MoveChild0,
/* 27200*/          OPC_SwitchOpcode /*2 cases */, 31, TARGET_VAL(ISD::TargetGlobalAddress),// ->27235
/* 27204*/            OPC_MoveParent,
/* 27205*/            OPC_MoveParent,
/* 27206*/            OPC_RecordChild3, // #2 = $exp
/* 27207*/            OPC_RecordChild4, // #3 = $timeout
/* 27208*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27210*/            OPC_EmitMergeInputChains1_0,
/* 27211*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27214*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27217*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 27224*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I32), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5533:{ *:[iPTR] }, (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 14
                      // Dst: (ATOMIC_WAIT_I32:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27235*/          /*SwitchOpcode*/ 31, TARGET_VAL(ISD::TargetExternalSymbol),// ->27269
/* 27238*/            OPC_MoveParent,
/* 27239*/            OPC_MoveParent,
/* 27240*/            OPC_RecordChild3, // #2 = $exp
/* 27241*/            OPC_RecordChild4, // #3 = $timeout
/* 27242*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27244*/            OPC_EmitMergeInputChains1_0,
/* 27245*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27248*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27251*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 27258*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I32), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5533:{ *:[iPTR] }, (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 14
                      // Dst: (ATOMIC_WAIT_I32:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27269*/          0, // EndSwitchOpcode
/* 27270*/        0, // EndSwitchOpcode
/* 27271*/      /*Scope*/ 45|128,2/*301*/, /*->27574*/
/* 27273*/        OPC_CheckChild1Integer, 30|128,43/*5534*/, 
/* 27276*/        OPC_MoveChild2,
/* 27277*/        OPC_SwitchOpcode /*3 cases */, 52|128,1/*180*/, TARGET_VAL(ISD::ADD),// ->27462
/* 27282*/          OPC_Scope, 36, /*->27320*/ // 5 children in Scope
/* 27284*/            OPC_RecordChild0, // #1 = $addr
/* 27285*/            OPC_MoveChild1,
/* 27286*/            OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 27289*/            OPC_RecordChild0, // #2 = $off
/* 27290*/            OPC_MoveChild0,
/* 27291*/            OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 27294*/            OPC_MoveParent,
/* 27295*/            OPC_MoveParent,
/* 27296*/            OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 27298*/            OPC_CheckType, MVT::i32,
/* 27300*/            OPC_MoveParent,
/* 27301*/            OPC_RecordChild3, // #3 = $exp
/* 27302*/            OPC_RecordChild4, // #4 = $timeout
/* 27303*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27305*/            OPC_EmitMergeInputChains1_0,
/* 27306*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27309*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5534:{ *:[iPTR] }, (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off))<<P:Predicate_regPlusGA>>, i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 18
                      // Dst: (ATOMIC_WAIT_I64:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27320*/          /*Scope*/ 36, /*->27357*/
/* 27321*/            OPC_MoveChild0,
/* 27322*/            OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 27325*/            OPC_RecordChild0, // #1 = $off
/* 27326*/            OPC_MoveChild0,
/* 27327*/            OPC_CheckOpcode, TARGET_VAL(ISD::TargetGlobalAddress),
/* 27330*/            OPC_MoveParent,
/* 27331*/            OPC_MoveParent,
/* 27332*/            OPC_RecordChild1, // #2 = $addr
/* 27333*/            OPC_CheckPredicate, 0, // Predicate_regPlusGA
/* 27335*/            OPC_CheckType, MVT::i32,
/* 27337*/            OPC_MoveParent,
/* 27338*/            OPC_RecordChild3, // #3 = $exp
/* 27339*/            OPC_RecordChild4, // #4 = $timeout
/* 27340*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27342*/            OPC_EmitMergeInputChains1_0,
/* 27343*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27346*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5534:{ *:[iPTR] }, (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (tglobaladdr:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr)<<P:Predicate_regPlusGA>>, i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 18
                      // Dst: (ATOMIC_WAIT_I64:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27357*/          /*Scope*/ 34, /*->27392*/
/* 27358*/            OPC_RecordChild0, // #1 = $addr
/* 27359*/            OPC_MoveChild1,
/* 27360*/            OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 27363*/            OPC_RecordChild0, // #2 = $off
/* 27364*/            OPC_MoveChild0,
/* 27365*/            OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 27368*/            OPC_MoveParent,
/* 27369*/            OPC_MoveParent,
/* 27370*/            OPC_CheckType, MVT::i32,
/* 27372*/            OPC_MoveParent,
/* 27373*/            OPC_RecordChild3, // #3 = $exp
/* 27374*/            OPC_RecordChild4, // #4 = $timeout
/* 27375*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27377*/            OPC_EmitMergeInputChains1_0,
/* 27378*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27381*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 5, 2, 1, 3, 4, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5534:{ *:[iPTR] }, (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off)), i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 17
                      // Dst: (ATOMIC_WAIT_I64:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27392*/          /*Scope*/ 34, /*->27427*/
/* 27393*/            OPC_MoveChild0,
/* 27394*/            OPC_CheckOpcode, TARGET_VAL(WebAssemblyISD::Wrapper),
/* 27397*/            OPC_RecordChild0, // #1 = $off
/* 27398*/            OPC_MoveChild0,
/* 27399*/            OPC_CheckOpcode, TARGET_VAL(ISD::TargetExternalSymbol),
/* 27402*/            OPC_MoveParent,
/* 27403*/            OPC_MoveParent,
/* 27404*/            OPC_RecordChild1, // #2 = $addr
/* 27405*/            OPC_CheckType, MVT::i32,
/* 27407*/            OPC_MoveParent,
/* 27408*/            OPC_RecordChild3, // #3 = $exp
/* 27409*/            OPC_RecordChild4, // #4 = $timeout
/* 27410*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27412*/            OPC_EmitMergeInputChains1_0,
/* 27413*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27416*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 5, 1, 2, 3, 4, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5534:{ *:[iPTR] }, (add:{ *:[i32] } (WebAssemblywrapper:{ *:[i32] } (texternalsym:{ *:[i32] }):$off), I32:{ *:[i32] }:$addr), i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 17
                      // Dst: (ATOMIC_WAIT_I64:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27427*/          /*Scope*/ 33, /*->27461*/
/* 27428*/            OPC_RecordChild0, // #1 = $addr
/* 27429*/            OPC_RecordChild1, // #2 = $off
/* 27430*/            OPC_MoveChild1,
/* 27431*/            OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 27434*/            OPC_MoveParent,
/* 27435*/            OPC_CheckPredicate, 3, // Predicate_regPlusImm
/* 27437*/            OPC_CheckType, MVT::i32,
/* 27439*/            OPC_MoveParent,
/* 27440*/            OPC_RecordChild3, // #3 = $exp
/* 27441*/            OPC_RecordChild4, // #4 = $timeout
/* 27442*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27444*/            OPC_EmitMergeInputChains1_0,
/* 27445*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27448*/            OPC_EmitConvertToTarget, 2,
/* 27450*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5534:{ *:[iPTR] }, (add:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_regPlusImm>>, i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 15
                      // Dst: (ATOMIC_WAIT_I64:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27461*/          0, /*End of Scope*/
/* 27462*/        /*SwitchOpcode*/ 33, TARGET_VAL(ISD::OR),// ->27498
/* 27465*/          OPC_RecordChild0, // #1 = $addr
/* 27466*/          OPC_RecordChild1, // #2 = $off
/* 27467*/          OPC_MoveChild1,
/* 27468*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 27471*/          OPC_MoveParent,
/* 27472*/          OPC_CheckPredicate, 4, // Predicate_or_is_add
/* 27474*/          OPC_CheckType, MVT::i32,
/* 27476*/          OPC_MoveParent,
/* 27477*/          OPC_RecordChild3, // #3 = $exp
/* 27478*/          OPC_RecordChild4, // #4 = $timeout
/* 27479*/          OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27481*/          OPC_EmitMergeInputChains1_0,
/* 27482*/          OPC_EmitInteger, MVT::i32, 0, 
/* 27485*/          OPC_EmitConvertToTarget, 2,
/* 27487*/          OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I64), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 5/*#Ops*/, 5, 6, 1, 3, 4, 
                    // Src: (intrinsic_w_chain:{ *:[i32] } 5534:{ *:[iPTR] }, (or:{ *:[i32] } I32:{ *:[i32] }:$addr, (imm:{ *:[i32] }):$off)<<P:Predicate_or_is_add>>, i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 15
                    // Dst: (ATOMIC_WAIT_I64:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, I32:{ *:[i32] }:$addr, i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27498*/        /*SwitchOpcode*/ 72, TARGET_VAL(WebAssemblyISD::Wrapper),// ->27573
/* 27501*/          OPC_RecordChild0, // #1 = $off
/* 27502*/          OPC_MoveChild0,
/* 27503*/          OPC_SwitchOpcode /*2 cases */, 31, TARGET_VAL(ISD::TargetGlobalAddress),// ->27538
/* 27507*/            OPC_MoveParent,
/* 27508*/            OPC_MoveParent,
/* 27509*/            OPC_RecordChild3, // #2 = $exp
/* 27510*/            OPC_RecordChild4, // #3 = $timeout
/* 27511*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27513*/            OPC_EmitMergeInputChains1_0,
/* 27514*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27517*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27520*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 27527*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5534:{ *:[iPTR] }, (WebAssemblywrapper:{ *:[iPTR] } (tglobaladdr:{ *:[iPTR] }):$off), i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 14
                      // Dst: (ATOMIC_WAIT_I64:{ *:[i32] } 0:{ *:[i32] }, (tglobaladdr:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27538*/          /*SwitchOpcode*/ 31, TARGET_VAL(ISD::TargetExternalSymbol),// ->27572
/* 27541*/            OPC_MoveParent,
/* 27542*/            OPC_MoveParent,
/* 27543*/            OPC_RecordChild3, // #2 = $exp
/* 27544*/            OPC_RecordChild4, // #3 = $timeout
/* 27545*/            OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27547*/            OPC_EmitMergeInputChains1_0,
/* 27548*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27551*/            OPC_EmitInteger, MVT::i32, 0, 
/* 27554*/            OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                          MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 27561*/            OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I64), 0|OPFL_Chain|OPFL_MemRefs,
                          MVT::i32, 5/*#Ops*/, 4, 1, 6, 2, 3, 
                      // Src: (intrinsic_w_chain:{ *:[i32] } 5534:{ *:[iPTR] }, (WebAssemblywrapper:{ *:[iPTR] } (texternalsym:{ *:[iPTR] }):$off), i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 14
                      // Dst: (ATOMIC_WAIT_I64:{ *:[i32] } 0:{ *:[i32] }, (texternalsym:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i64:{ *:[i64] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27572*/          0, // EndSwitchOpcode
/* 27573*/        0, // EndSwitchOpcode
/* 27574*/      0, /*End of Scope*/
/* 27575*/    /*Scope*/ 95, /*->27671*/
/* 27576*/      OPC_RecordNode, // #0 = 'intrinsic_w_chain' chained node
/* 27577*/      OPC_Scope, 23, /*->27602*/ // 3 children in Scope
/* 27579*/        OPC_CheckChild1Integer, 38|128,43/*5542*/, 
/* 27582*/        OPC_RecordChild2, // #1 = $flags
/* 27583*/        OPC_MoveChild2,
/* 27584*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 27587*/        OPC_MoveParent,
/* 27588*/        OPC_CheckType, MVT::i32,
/* 27590*/        OPC_CheckPatternPredicate, 3, // (!Subtarget->hasAddr64())
/* 27592*/        OPC_EmitMergeInputChains1_0,
/* 27593*/        OPC_EmitConvertToTarget, 1,
/* 27595*/        OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::MEMORY_SIZE_I32), 0|OPFL_Chain,
                      MVT::i32, 1/*#Ops*/, 2, 
                  // Src: (intrinsic_w_chain:{ *:[i32] } 5542:{ *:[iPTR] }, (imm:{ *:[i32] }):$flags) - Complexity = 11
                  // Dst: (MEMORY_SIZE_I32:{ *:[i32] } (imm:{ *:[i32] }):$flags)
/* 27602*/      /*Scope*/ 27, /*->27630*/
/* 27603*/        OPC_CheckChild1Integer, 37|128,43/*5541*/, 
/* 27606*/        OPC_RecordChild2, // #1 = $flags
/* 27607*/        OPC_MoveChild2,
/* 27608*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 27611*/        OPC_MoveParent,
/* 27612*/        OPC_RecordChild3, // #2 = $delta
/* 27613*/        OPC_CheckChild3Type, MVT::i32,
/* 27615*/        OPC_CheckType, MVT::i32,
/* 27617*/        OPC_CheckPatternPredicate, 3, // (!Subtarget->hasAddr64())
/* 27619*/        OPC_EmitMergeInputChains1_0,
/* 27620*/        OPC_EmitConvertToTarget, 1,
/* 27622*/        OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::MEMORY_GROW_I32), 0|OPFL_Chain,
                      MVT::i32, 2/*#Ops*/, 3, 2, 
                  // Src: (intrinsic_w_chain:{ *:[i32] } 5541:{ *:[iPTR] }, (imm:{ *:[i32] }):$flags, I32:{ *:[i32] }:$delta) - Complexity = 11
                  // Dst: (MEMORY_GROW_I32:{ *:[i32] } (imm:{ *:[i32] }):$flags, I32:{ *:[i32] }:$delta)
/* 27630*/      /*Scope*/ 39, /*->27670*/
/* 27631*/        OPC_CheckChild1Integer, 32|128,43/*5536*/, 
/* 27634*/        OPC_RecordChild2, // #1 = $tag
/* 27635*/        OPC_MoveChild2,
/* 27636*/        OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 27639*/        OPC_MoveParent,
/* 27640*/        OPC_SwitchType /*2 cases */, 12, MVT::i32,// ->27655
/* 27643*/          OPC_CheckPatternPredicate, 4, // (Subtarget->hasExceptionHandling())
/* 27645*/          OPC_EmitMergeInputChains1_0,
/* 27646*/          OPC_EmitConvertToTarget, 1,
/* 27648*/          OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::CATCH_I32), 0|OPFL_Chain,
                        MVT::i32, 1/*#Ops*/, 2, 
                    // Src: (intrinsic_w_chain:{ *:[i32] } 5536:{ *:[iPTR] }, (imm:{ *:[i32] }):$tag) - Complexity = 11
                    // Dst: (CATCH_I32:{ *:[i32] } (imm:{ *:[i32] }):$tag)
/* 27655*/        /*SwitchType*/ 12, MVT::i64,// ->27669
/* 27657*/          OPC_CheckPatternPredicate, 4, // (Subtarget->hasExceptionHandling())
/* 27659*/          OPC_EmitMergeInputChains1_0,
/* 27660*/          OPC_EmitConvertToTarget, 1,
/* 27662*/          OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::CATCH_I64), 0|OPFL_Chain,
                        MVT::i64, 1/*#Ops*/, 2, 
                    // Src: (intrinsic_w_chain:{ *:[i64] } 5536:{ *:[iPTR] }, (imm:{ *:[i32] }):$tag) - Complexity = 11
                    // Dst: (CATCH_I64:{ *:[i64] } (imm:{ *:[i32] }):$tag)
/* 27669*/        0, // EndSwitchType
/* 27670*/      0, /*End of Scope*/
/* 27671*/    /*Scope*/ 79|128,1/*207*/, /*->27880*/
/* 27673*/      OPC_RecordMemRef,
/* 27674*/      OPC_RecordNode, // #0 = 'intrinsic_w_chain' chained node
/* 27675*/      OPC_Scope, 64, /*->27741*/ // 3 children in Scope
/* 27677*/        OPC_CheckChild1Integer, 28|128,43/*5532*/, 
/* 27680*/        OPC_RecordChild2, // #1 = $off
/* 27681*/        OPC_Scope, 34, /*->27717*/ // 2 children in Scope
/* 27683*/          OPC_MoveChild2,
/* 27684*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 27687*/          OPC_MoveParent,
/* 27688*/          OPC_RecordChild3, // #2 = $count
/* 27689*/          OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27691*/          OPC_EmitMergeInputChains1_0,
/* 27692*/          OPC_EmitInteger, MVT::i32, 0, 
/* 27695*/          OPC_EmitConvertToTarget, 1,
/* 27697*/          OPC_EmitInteger, MVT::i32, 0, 
/* 27700*/          OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                        MVT::i32, 1/*#Ops*/, 5,  // Results = #6
/* 27707*/          OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_NOTIFY), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 4/*#Ops*/, 3, 4, 6, 2, 
                    // Src: (intrinsic_w_chain:{ *:[i32] } 5532:{ *:[iPTR] }, (imm:{ *:[iPTR] }):$off, I32:{ *:[i32] }:$count) - Complexity = 11
                    // Dst: (ATOMIC_NOTIFY:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), I32:{ *:[i32] }:$count)
/* 27717*/        /*Scope*/ 22, /*->27740*/
/* 27718*/          OPC_CheckChild2Type, MVT::i32,
/* 27720*/          OPC_RecordChild3, // #2 = $count
/* 27721*/          OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27723*/          OPC_EmitMergeInputChains1_0,
/* 27724*/          OPC_EmitInteger, MVT::i32, 0, 
/* 27727*/          OPC_EmitInteger, MVT::i32, 0, 
/* 27730*/          OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_NOTIFY), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 4/*#Ops*/, 3, 4, 1, 2, 
                    // Src: (intrinsic_w_chain:{ *:[i32] } 5532:{ *:[iPTR] }, I32:{ *:[i32] }:$addr, I32:{ *:[i32] }:$count) - Complexity = 8
                    // Dst: (ATOMIC_NOTIFY:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, I32:{ *:[i32] }:$count)
/* 27740*/        0, /*End of Scope*/
/* 27741*/      /*Scope*/ 68, /*->27810*/
/* 27742*/        OPC_CheckChild1Integer, 29|128,43/*5533*/, 
/* 27745*/        OPC_RecordChild2, // #1 = $off
/* 27746*/        OPC_Scope, 36, /*->27784*/ // 2 children in Scope
/* 27748*/          OPC_MoveChild2,
/* 27749*/          OPC_CheckOpcode, TARGET_VAL(ISD::Constant),
/* 27752*/          OPC_MoveParent,
/* 27753*/          OPC_RecordChild3, // #2 = $exp
/* 27754*/          OPC_RecordChild4, // #3 = $timeout
/* 27755*/          OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27757*/          OPC_EmitMergeInputChains1_0,
/* 27758*/          OPC_EmitInteger, MVT::i32, 0, 
/* 27761*/          OPC_EmitConvertToTarget, 1,
/* 27763*/          OPC_EmitInteger, MVT::i32, 0, 
/* 27766*/          OPC_EmitNode1, TARGET_VAL(WebAssembly::CONST_I32), 0,
                        MVT::i32, 1/*#Ops*/, 6,  // Results = #7
/* 27773*/          OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I32), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 5/*#Ops*/, 4, 5, 7, 2, 3, 
                    // Src: (intrinsic_w_chain:{ *:[i32] } 5533:{ *:[iPTR] }, (imm:{ *:[iPTR] }):$off, i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 11
                    // Dst: (ATOMIC_WAIT_I32:{ *:[i32] } 0:{ *:[i32] }, (imm:{ *:[i32] }):$off, (CONST_I32:{ *:[i32] } 0:{ *:[i32] }), i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout)
/* 27784*/        /*Scope*/ 24, /*->27809*/
/* 27785*/          OPC_CheckChild2Type, MVT::i32,
/* 27787*/          OPC_RecordChild3, // #2 = $exp
/* 27788*/          OPC_RecordChild4, // #3 = $timeout
/* 27789*/          OPC_CheckPatternPredicate, 0, // (Subtarget->hasAtomics())
/* 27791*/          OPC_EmitMergeInputChains1_0,
/* 27792*/          OPC_EmitInteger, MVT::i32, 0, 
/* 27795*/          OPC_EmitInteger, MVT::i32, 0, 
/* 27798*/          OPC_MorphNodeTo1, TARGET_VAL(WebAssembly::ATOMIC_WAIT_I32), 0|OPFL_Chain|OPFL_MemRefs,
                        MVT::i32, 5/*#Ops*/, 4, 5, 1, 2, 3, 
                    // Src: (intrinsic_w_chain:{ *:[i32] } 5533:{ *:[iPTR] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, I64:{ *:[i64] }:$timeout) - Complexity = 8
                    // Dst: (ATOMIC_WAIT_I32:{ *:[i32] } 0:{ *:[i32] }, 0:{ *:[i32] }, I32:{ *:[i32] }:$addr, i32:{ *:[i32] }:$exp, I64:{