/* TweetUtils.c generated by valac 0.34.6, the Vala compiler
 * generated from TweetUtils.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "CbTweet.h"
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <rest/rest-proxy.h>
#include <gtk/gtk.h>
#include <json-glib/json-glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libsoup/soup.h>
#include "CbTypes.h"

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _Block52Data Block52Data;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TweetUtilsDeleteTweetData TweetUtilsDeleteTweetData;
typedef struct _Block53Data Block53Data;
typedef struct _TweetUtilsSetFavoriteStatusData TweetUtilsSetFavoriteStatusData;
typedef struct _Block54Data Block54Data;
typedef struct _TweetUtilsSetRetweetStatusData TweetUtilsSetRetweetStatusData;
typedef struct _Block55Data Block55Data;
typedef struct _TweetUtilsDownloadAvatarData TweetUtilsDownloadAvatarData;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_MEDIA_DIALOG (media_dialog_get_type ())
#define MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_DIALOG, MediaDialog))
#define MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_DIALOG, MediaDialogClass))
#define IS_MEDIA_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_DIALOG))
#define IS_MEDIA_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_DIALOG))
#define MEDIA_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_DIALOG, MediaDialogClass))

typedef struct _MediaDialog MediaDialog;
typedef struct _MediaDialogClass MediaDialogClass;

#define TYPE_SNIPPET_MANAGER (snippet_manager_get_type ())
#define SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNIPPET_MANAGER, SnippetManager))
#define SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNIPPET_MANAGER, SnippetManagerClass))
#define IS_SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNIPPET_MANAGER))
#define IS_SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNIPPET_MANAGER))
#define SNIPPET_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNIPPET_MANAGER, SnippetManagerClass))

typedef struct _SnippetManager SnippetManager;
typedef struct _SnippetManagerClass SnippetManagerClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _Block56Data Block56Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _TweetUtilsLoadThreadedData TweetUtilsLoadThreadedData;

struct _Block52Data {
	int _ref_count_;
	RestProxyCall* call;
	gpointer _async_data_;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _TweetUtilsDeleteTweetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	CbTweet* tweet;
	Block52Data* _data52_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	CbTweet* _tmp3_;
	gint64 _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	CbTweet* _tmp11_;
	gint64 _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
};

struct _Block53Data {
	int _ref_count_;
	RestProxyCall* call;
	CbTweet* tweet;
	gboolean status;
	gpointer _async_data_;
};

struct _TweetUtilsSetFavoriteStatusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	CbTweet* tweet;
	gboolean status;
	Block53Data* _data53_;
	CbTweet* _tmp0_;
	gboolean _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	gboolean _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	RestProxyCall* _tmp8_;
	RestProxyCall* _tmp9_;
	CbTweet* _tmp10_;
	gint64 _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
};

struct _Block54Data {
	int _ref_count_;
	RestProxyCall* call;
	CbTweet* tweet;
	gboolean status;
	gpointer _async_data_;
};

struct _TweetUtilsSetRetweetStatusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* account;
	CbTweet* tweet;
	gboolean status;
	Block54Data* _data54_;
	CbTweet* _tmp0_;
	gboolean _tmp1_;
	Account* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	gboolean _tmp6_;
	RestProxyCall* _tmp7_;
	CbTweet* _tmp8_;
	gint64 _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
	CbTweet* _tmp15_;
	gint64 _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	RestProxyCall* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	RestProxyCall* _tmp24_;
};

struct _Block55Data {
	int _ref_count_;
	GdkPixbuf* avatar;
	GError* err;
	gint size;
	gpointer _async_data_;
};

struct _TweetUtilsDownloadAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* avatar_url;
	gint size;
	GdkPixbuf* result;
	Block55Data* _data55_;
	gint _tmp0_;
	SoupMessage* msg;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	SoupSession* _tmp3_;
	SoupMessage* _tmp4_;
	SoupMessage* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	GError * _inner_error_;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _Block56Data {
	int _ref_count_;
	JsonNode* _result_;
	GError* err;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	RestProxyCall* call;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _TweetUtilsLoadThreadedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RestProxyCall* call;
	GCancellable* cancellable;
	JsonNode* result;
	Block56Data* _data56_;
	RestProxyCall* _tmp0_;
	GCancellable* _tmp1_;
	RestProxyCall* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GThread* _tmp5_;
	GThread* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	JsonNode* _tmp10_;
	JsonNode* _tmp11_;
	GError * _inner_error_;
};


extern SoupSession* SOUP_SESSION;
extern SnippetManager* corebird_snippet_manager;

#define TWEET_UTILS_NO_SPELL_CHECK "gtksourceview:context-classes:no-spell-check"
static void tweet_utils_delete_tweet_data_free (gpointer _data);
GType account_get_type (void) G_GNUC_CONST;
void tweet_utils_delete_tweet (Account* account, CbTweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_delete_tweet_finish (GAsyncResult* _res_);
static gboolean tweet_utils_delete_tweet_co (TweetUtilsDeleteTweetData* _data_);
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void __lambda57_ (Block52Data* _data52_, GObject* obj, GAsyncResult* res);
static void ___lambda57__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_set_favorite_status_data_free (gpointer _data);
void tweet_utils_set_favorite_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_favorite_status_finish (GAsyncResult* _res_);
static gboolean tweet_utils_set_favorite_status_co (TweetUtilsSetFavoriteStatusData* _data_);
static Block53Data* block53_data_ref (Block53Data* _data53_);
static void block53_data_unref (void * _userdata_);
static void __lambda55_ (Block53Data* _data53_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda55__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_set_retweet_status_data_free (gpointer _data);
void tweet_utils_set_retweet_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_retweet_status_finish (GAsyncResult* _res_);
static gboolean tweet_utils_set_retweet_status_co (TweetUtilsSetRetweetStatusData* _data_);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
gchar* rest_call_to_string (RestProxyCall* call);
static void __lambda72_ (Block54Data* _data54_, GObject* obj, GAsyncResult* res);
static void ___lambda72__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void tweet_utils_download_avatar_data_free (gpointer _data);
void tweet_utils_download_avatar (const gchar* avatar_url, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error);
static gboolean tweet_utils_download_avatar_co (TweetUtilsDownloadAvatarData* _data_);
static Block55Data* block55_data_ref (Block55Data* _data55_);
static void block55_data_unref (void * _userdata_);
static void __lambda66_ (Block55Data* _data55_, SoupSession* s, SoupMessage* _msg);
static guint8* _vala_array_dup6 (guint8* self, int length);
static void ___lambda66__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
gint tweet_utils_calc_tweet_length (const gchar* text, gint media_count);
gint tweet_utils_get_word_length (const gchar* s);
#define TWITTER_short_url_length 23
#define TWITTER_short_url_length_https 23
GType main_window_get_type (void) G_GNUC_CONST;
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
GType bundle_get_type (void) G_GNUC_CONST;
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
void bundle_put_int (Bundle* self, const gchar* key, gint value);
#define TWEET_INFO_PAGE_BY_ID 2
GType tweet_list_box_get_type (void) G_GNUC_CONST;
void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, Account* account);
gboolean account_filter_matches (Account* self, CbTweet* t);
GType delta_updater_get_type (void) G_GNUC_CONST;
GType tweet_model_get_type (void) G_GNUC_CONST;
void tweet_model_add (TweetModel* self, CbTweet* tweet);
void tweet_utils_handle_media_click (CbTweet* t, MainWindow* window, gint index);
GType media_dialog_get_type (void) G_GNUC_CONST;
MediaDialog* media_dialog_new (CbTweet* tweet, gint start_media_index);
MediaDialog* media_dialog_construct (GType object_type, CbTweet* tweet, gint start_media_index);
gboolean tweet_utils_is_link (const gchar* word);
gboolean tweet_utils_is_mention (const gchar* word, gint* at_pos);
static gboolean _vala_unichar_array_contains (gunichar* stack, int stack_length, gunichar needle);
gboolean tweet_utils_is_hashtag (const gchar* word);
void tweet_utils_highlight_link (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self);
void tweet_utils_highlight_mention (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
void tweet_utils_highlight_hashtag (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
void tweet_utils_maybe_highlight_snippet (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end);
GType snippet_manager_get_type (void) G_GNUC_CONST;
gchar* snippet_manager_get_snippet (SnippetManager* self, const gchar* key);
void tweet_utils_annotate_text (GtkTextBuffer* buffer);
static void _vala_JsonNode_free (JsonNode* self);
static void tweet_utils_load_threaded_data_free (gpointer _data);
void tweet_utils_load_threaded (RestProxyCall* call, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static gboolean tweet_utils_load_threaded_co (TweetUtilsLoadThreadedData* _data_);
static Block56Data* block56_data_ref (Block56Data* _data56_);
static void block56_data_unref (void * _userdata_);
static gboolean _tweet_utils_load_threaded_co_gsource_func (gpointer self);
static void* __lambda16_ (Block56Data* _data56_);
static gboolean ___lambda17_ (Block56Data* _data56_);
static gboolean ____lambda17__gsource_func (gpointer self);
static gboolean ___lambda18_ (Block56Data* _data56_);
static gboolean ____lambda18__gsource_func (gpointer self);
static gboolean ___lambda19_ (Block56Data* _data56_);
static gboolean ____lambda19__gsource_func (gpointer self);
static gboolean ___lambda20_ (Block56Data* _data56_);
static gboolean ____lambda20__gsource_func (gpointer self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static gboolean __lambda21_ (Block56Data* _data56_);
static gboolean ___lambda21__gsource_func (gpointer self);
static gpointer ___lambda16__gthread_func (gpointer self);
void tweet_utils_sort_entities (CbTextEntity** entities, int* entities_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const gchar* TWEET_UTILS_DOMAINS[24] = {".com", ".net", ".org", ".xxx", ".sexy", ".pro", ".biz", ".name", ".info", ".arpa", ".gov", ".aero", ".asia", ".cat", ".coop", ".edu", ".int", ".jobs", ".mil", ".mobi", ".museum", ".post", ".tel", ".travel"};
const gunichar TWEET_UTILS_non_mention_chars[15] = {8220U, (gunichar) '"', (gunichar) '-', (gunichar) '`', (gunichar) ',', (gunichar) '.', (gunichar) '^', (gunichar) '(', (gunichar) ')', (gunichar) '[', (gunichar) ']', (gunichar) '{', (gunichar) '}', (gunichar) '+', (gunichar) '='};

static void tweet_utils_delete_tweet_data_free (gpointer _data) {
	TweetUtilsDeleteTweetData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->tweet);
	g_slice_free (TweetUtilsDeleteTweetData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void tweet_utils_delete_tweet (Account* account, CbTweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsDeleteTweetData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	CbTweet* _tmp3_ = NULL;
	_data_ = g_slice_new0 (TweetUtilsDeleteTweetData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_delete_tweet);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_delete_tweet_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	tweet_utils_delete_tweet_co (_data_);
}


void tweet_utils_delete_tweet_finish (GAsyncResult* _res_) {
	TweetUtilsDeleteTweetData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Deletes the given tweet.
   *
   * @param account The account to delete the tweet from
   * @param tweet the tweet to delete
   */
static Block52Data* block52_data_ref (Block52Data* _data52_) {
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}


static void block52_data_unref (void * _userdata_) {
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		_g_object_unref0 (_data52_->call);
		g_slice_free (Block52Data, _data52_);
	}
}


static void __lambda57_ (Block52Data* _data52_, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data52_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch57_g_error;
		}
	}
	goto __finally57;
	__catch57_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("TweetUtils.vala:39: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally57:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_delete_tweet_co (_data52_->_async_data_);
}


static void ___lambda57__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda57_ (self, source_object, res);
	block52_data_unref (self);
}


static gboolean tweet_utils_delete_tweet_co (TweetUtilsDeleteTweetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data52_ = g_slice_new0 (Block52Data);
	_data_->_data52_->_ref_count_ = 1;
	_data_->_data52_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_->proxy;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->_data52_->call = _data_->_tmp2_;
	rest_proxy_call_set_method (_data_->_data52_->call, "POST");
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->tweet;
	_data_->_tmp4_ = 0LL;
	_data_->_tmp4_ = _data_->_tmp3_->id;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp4_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_strconcat ("1.1/statuses/destroy/", _data_->_tmp6_, NULL);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = g_strconcat (_data_->_tmp8_, ".json", NULL);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_tmp9_;
	rest_proxy_call_set_function (_data_->_data52_->call, _data_->_tmp10_);
	_g_free0 (_data_->_tmp10_);
	_g_free0 (_data_->_tmp8_);
	_g_free0 (_data_->_tmp6_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->tweet;
	_data_->_tmp12_ = 0LL;
	_data_->_tmp12_ = _data_->_tmp11_->id;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp12_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->_tmp13_;
	rest_proxy_call_add_param (_data_->_data52_->call, "id", _data_->_tmp14_);
	_g_free0 (_data_->_tmp14_);
	rest_proxy_call_invoke_async (_data_->_data52_->call, NULL, ___lambda57__gasync_ready_callback, block52_data_ref (_data_->_data52_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block52_data_unref (_data_->_data52_);
	_data_->_data52_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_set_favorite_status_data_free (gpointer _data) {
	TweetUtilsSetFavoriteStatusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	g_slice_free (TweetUtilsSetFavoriteStatusData, _data_);
}


void tweet_utils_set_favorite_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsSetFavoriteStatusData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	CbTweet* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	_data_ = g_slice_new0 (TweetUtilsSetFavoriteStatusData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_set_favorite_status);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_set_favorite_status_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	_tmp4_ = status;
	_data_->status = _tmp4_;
	tweet_utils_set_favorite_status_co (_data_);
}


void tweet_utils_set_favorite_status_finish (GAsyncResult* _res_) {
	TweetUtilsSetFavoriteStatusData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * (Un)favorites the given tweet.
   *
   * @param account The account to (un)favorite from
   * @param tweet The tweet to (un)favorite
   * @param status %true to favorite the tweet, %false to unfavorite it.
   */
static Block53Data* block53_data_ref (Block53Data* _data53_) {
	g_atomic_int_inc (&_data53_->_ref_count_);
	return _data53_;
}


static void block53_data_unref (void * _userdata_) {
	Block53Data* _data53_;
	_data53_ = (Block53Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data53_->_ref_count_)) {
		_g_object_unref0 (_data53_->call);
		_g_object_unref0 (_data53_->tweet);
		g_slice_free (Block53Data, _data53_);
	}
}


static void __lambda55_ (Block53Data* _data53_, GObject* obj, GAsyncResult* res) {
	gboolean _tmp6_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data53_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch58_g_error;
		}
	}
	goto __finally58;
	__catch58_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data53_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 66, "TweetUtils.vala", NULL);
		_g_error_free0 (e);
	}
	__finally58:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = _data53_->status;
	if (_tmp6_) {
		CbTweet* _tmp7_ = NULL;
		_tmp7_ = _data53_->tweet;
		cb_tweet_set_flag (_tmp7_, (guint) CB_TWEET_STATE_FAVORITED);
	} else {
		CbTweet* _tmp8_ = NULL;
		_tmp8_ = _data53_->tweet;
		cb_tweet_unset_flag (_tmp8_, (guint) CB_TWEET_STATE_FAVORITED);
	}
	tweet_utils_set_favorite_status_co (_data53_->_async_data_);
}


static void ___lambda55__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda55_ (self, source_object, res);
	block53_data_unref (self);
}


static gboolean tweet_utils_set_favorite_status_co (TweetUtilsSetFavoriteStatusData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data53_ = g_slice_new0 (Block53Data);
	_data_->_data53_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->tweet;
	_g_object_unref0 (_data_->_data53_->tweet);
	_data_->_data53_->tweet = _data_->_tmp0_;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->status;
	_data_->_data53_->status = _data_->_tmp1_;
	_data_->_data53_->_async_data_ = _data_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->account;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_->proxy;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, rest_proxy_get_type (), RestProxy));
	_data_->_data53_->call = _data_->_tmp4_;
	_data_->_tmp5_ = FALSE;
	_data_->_tmp5_ = _data_->_data53_->status;
	if (_data_->_tmp5_) {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_data53_->call;
		rest_proxy_call_set_function (_data_->_tmp6_, "1.1/favorites/create.json");
	} else {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_data53_->call;
		rest_proxy_call_set_function (_data_->_tmp7_, "1.1/favorites/destroy.json");
	}
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_data53_->call;
	rest_proxy_call_set_method (_data_->_tmp8_, "POST");
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_data53_->call;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_data53_->tweet;
	_data_->_tmp11_ = 0LL;
	_data_->_tmp11_ = _data_->_tmp10_->id;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp11_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->_tmp12_;
	rest_proxy_call_add_param (_data_->_tmp9_, "id", _data_->_tmp13_);
	_g_free0 (_data_->_tmp13_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->_data53_->call;
	rest_proxy_call_invoke_async (_data_->_tmp14_, NULL, ___lambda55__gasync_ready_callback, block53_data_ref (_data_->_data53_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block53_data_unref (_data_->_data53_);
	_data_->_data53_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_set_retweet_status_data_free (gpointer _data) {
	TweetUtilsSetRetweetStatusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->account);
	g_slice_free (TweetUtilsSetRetweetStatusData, _data_);
}


void tweet_utils_set_retweet_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsSetRetweetStatusData* _data_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	CbTweet* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	_data_ = g_slice_new0 (TweetUtilsSetRetweetStatusData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_set_retweet_status);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_set_retweet_status_data_free);
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->account);
	_data_->account = _tmp1_;
	_tmp2_ = tweet;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->tweet);
	_data_->tweet = _tmp3_;
	_tmp4_ = status;
	_data_->status = _tmp4_;
	tweet_utils_set_retweet_status_co (_data_);
}


void tweet_utils_set_retweet_status_finish (GAsyncResult* _res_) {
	TweetUtilsSetRetweetStatusData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * (Un)retweets the given tweet.
   *
   * @param account The account to (un)retweet from
   * @param tweet The tweet to (un)retweet
   * @param status %true to retweet it, false to unretweet it.
   */
static Block54Data* block54_data_ref (Block54Data* _data54_) {
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}


static void block54_data_unref (void * _userdata_) {
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		_g_object_unref0 (_data54_->call);
		_g_object_unref0 (_data54_->tweet);
		g_slice_free (Block54Data, _data54_);
	}
}


static void __lambda72_ (Block54Data* _data54_, GObject* obj, GAsyncResult* res) {
	const gchar* back = NULL;
	RestProxyCall* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data54_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch59_g_error;
		}
	}
	goto __finally59;
	__catch59_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data54_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		utils_show_error_object (_tmp3_, _tmp5_, 99, "TweetUtils.vala", NULL);
		_g_error_free0 (e);
	}
	__finally59:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = _data54_->call;
	_tmp7_ = rest_proxy_call_get_payload (_tmp6_);
	back = _tmp7_;
	_tmp8_ = json_parser_new ();
	parser = _tmp8_;
	{
		gboolean _tmp9_ = FALSE;
		gboolean _tmp16_ = FALSE;
		json_parser_load_from_data (parser, back, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch60_g_error;
		}
		_tmp9_ = _data54_->status;
		if (_tmp9_) {
			gint64 new_id = 0LL;
			JsonNode* _tmp10_ = NULL;
			JsonObject* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			CbTweet* _tmp13_ = NULL;
			gint64 _tmp14_ = 0LL;
			_tmp10_ = json_parser_get_root (parser);
			_tmp11_ = json_node_get_object (_tmp10_);
			_tmp12_ = json_object_get_int_member (_tmp11_, "id");
			new_id = _tmp12_;
			_tmp13_ = _data54_->tweet;
			_tmp14_ = new_id;
			_tmp13_->my_retweet = _tmp14_;
		} else {
			CbTweet* _tmp15_ = NULL;
			_tmp15_ = _data54_->tweet;
			_tmp15_->my_retweet = (gint64) 0;
		}
		_tmp16_ = _data54_->status;
		if (_tmp16_) {
			CbTweet* _tmp17_ = NULL;
			_tmp17_ = _data54_->tweet;
			cb_tweet_set_flag (_tmp17_, (guint) CB_TWEET_STATE_RETWEETED);
		} else {
			CbTweet* _tmp18_ = NULL;
			_tmp18_ = _data54_->tweet;
			cb_tweet_unset_flag (_tmp18_, (guint) CB_TWEET_STATE_RETWEETED);
		}
	}
	goto __finally60;
	__catch60_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_critical ("TweetUtils.vala:116: %s", _tmp20_);
		g_critical ("TweetUtils.vala:117: %s", back);
		_g_error_free0 (e);
	}
	__finally60:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_set_retweet_status_co (_data54_->_async_data_);
	_g_object_unref0 (parser);
}


static void ___lambda72__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda72_ (self, source_object, res);
	block54_data_unref (self);
}


static gboolean tweet_utils_set_retweet_status_co (TweetUtilsSetRetweetStatusData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data54_ = g_slice_new0 (Block54Data);
	_data_->_data54_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->tweet;
	_g_object_unref0 (_data_->_data54_->tweet);
	_data_->_data54_->tweet = _data_->_tmp0_;
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->status;
	_data_->_data54_->status = _data_->_tmp1_;
	_data_->_data54_->_async_data_ = _data_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->account;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_->proxy;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, rest_proxy_get_type (), RestProxy));
	_data_->_data54_->call = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_data54_->call;
	rest_proxy_call_set_method (_data_->_tmp5_, "POST");
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = _data_->_data54_->status;
	if (_data_->_tmp6_) {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_data54_->call;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_data54_->tweet;
		_data_->_tmp9_ = 0LL;
		_data_->_tmp9_ = _data_->_tmp8_->id;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp9_);
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_strconcat ("1.1/statuses/retweet/", _data_->_tmp11_, ".json", NULL);
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->_tmp12_;
		rest_proxy_call_set_function (_data_->_tmp7_, _data_->_tmp13_);
		_g_free0 (_data_->_tmp13_);
		_g_free0 (_data_->_tmp11_);
	} else {
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_data54_->call;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_data54_->tweet;
		_data_->_tmp16_ = 0LL;
		_data_->_tmp16_ = _data_->_tmp15_->my_retweet;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp16_);
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = g_strconcat ("1.1/statuses/destroy/", _data_->_tmp18_, ".json", NULL);
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_tmp19_;
		rest_proxy_call_set_function (_data_->_tmp14_, _data_->_tmp20_);
		_g_free0 (_data_->_tmp20_);
		_g_free0 (_data_->_tmp18_);
	}
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->_data54_->call;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = rest_call_to_string (_data_->_tmp21_);
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->_tmp22_;
	g_debug ("TweetUtils.vala:93: %s", _data_->_tmp23_);
	_g_free0 (_data_->_tmp23_);
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->_data54_->call;
	rest_proxy_call_invoke_async (_data_->_tmp24_, NULL, ___lambda72__gasync_ready_callback, block54_data_ref (_data_->_data54_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block54_data_unref (_data_->_data54_);
	_data_->_data54_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tweet_utils_download_avatar_data_free (gpointer _data) {
	TweetUtilsDownloadAvatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->avatar_url);
	_g_object_unref0 (_data_->result);
	g_slice_free (TweetUtilsDownloadAvatarData, _data_);
}


void tweet_utils_download_avatar (const gchar* avatar_url, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsDownloadAvatarData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	_data_ = g_slice_new0 (TweetUtilsDownloadAvatarData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_download_avatar);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_download_avatar_data_free);
	_tmp0_ = avatar_url;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->avatar_url);
	_data_->avatar_url = _tmp1_;
	_tmp2_ = size;
	_data_->size = _tmp2_;
	tweet_utils_download_avatar_co (_data_);
}


GdkPixbuf* tweet_utils_download_avatar_finish (GAsyncResult* _res_, GError** error) {
	GdkPixbuf* result;
	TweetUtilsDownloadAvatarData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Downloads the avatar from the given url.
   *
   * @param avatar_url The avatar url to download
   *
   * @return The loaded avatar.
   */
static Block55Data* block55_data_ref (Block55Data* _data55_) {
	g_atomic_int_inc (&_data55_->_ref_count_);
	return _data55_;
}


static void block55_data_unref (void * _userdata_) {
	Block55Data* _data55_;
	_data55_ = (Block55Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data55_->_ref_count_)) {
		_g_error_free0 (_data55_->err);
		_g_object_unref0 (_data55_->avatar);
		g_slice_free (Block55Data, _data55_);
	}
}


static guint8* _vala_array_dup6 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void __lambda66_ (Block55Data* _data55_, SoupSession* s, SoupMessage* _msg) {
	SoupMessage* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GMemoryInputStream* memory_stream = NULL;
	SoupMessage* _tmp3_ = NULL;
	SoupMessageBody* _tmp4_ = NULL;
	guint8* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guint8* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GDestroyNotify _tmp7_ = NULL;
	GMemoryInputStream* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (SOUP_IS_SESSION (s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _msg;
	g_object_get (_tmp0_, "status-code", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != ((guint) SOUP_STATUS_OK)) {
		_g_object_unref0 (_data55_->avatar);
		_data55_->avatar = NULL;
		tweet_utils_download_avatar_co (_data55_->_async_data_);
		return;
	}
	_tmp3_ = _msg;
	_tmp4_ = _tmp3_->response_body;
	_tmp5_ = _tmp4_->data;
	_tmp5__length1 = (gint) _tmp4_->length;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup6 (_tmp5_, _tmp5__length1) : ((gpointer) _tmp5_);
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = g_free;
	_tmp8_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp6_, _tmp6__length1, _tmp7_);
	memory_stream = _tmp8_;
	{
		GdkPixbuf* _tmp9_ = NULL;
		GMemoryInputStream* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		GdkPixbuf* _tmp13_ = NULL;
		GdkPixbuf* _tmp14_ = NULL;
		_tmp10_ = memory_stream;
		_tmp11_ = _data55_->size;
		_tmp12_ = _data55_->size;
		_tmp13_ = gdk_pixbuf_new_from_stream_at_scale (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_input_stream_get_type (), GInputStream), _tmp11_, _tmp12_, FALSE, NULL, &_inner_error_);
		_tmp9_ = _tmp13_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch61_g_error;
		}
		_tmp14_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (_data55_->avatar);
		_data55_->avatar = _tmp14_;
		_g_object_unref0 (_tmp9_);
	}
	goto __finally61;
	__catch61_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _g_error_copy0 (_tmp15_);
		_g_error_free0 (_data55_->err);
		_data55_->err = _tmp16_;
		_g_error_free0 (e);
	}
	__finally61:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (memory_stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tweet_utils_download_avatar_co (_data55_->_async_data_);
	_g_object_unref0 (memory_stream);
}


static void ___lambda66__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	__lambda66_ (self, session, msg);
	block55_data_unref (self);
}


static gboolean tweet_utils_download_avatar_co (TweetUtilsDownloadAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data55_ = g_slice_new0 (Block55Data);
	_data_->_data55_->_ref_count_ = 1;
	_data_->_tmp0_ = 0;
	_data_->_tmp0_ = _data_->size;
	_data_->_data55_->size = _data_->_tmp0_;
	_data_->_data55_->_async_data_ = _data_;
	_data_->_data55_->avatar = NULL;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->avatar_url;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = soup_message_new ("GET", _data_->_tmp1_);
	_data_->msg = _data_->_tmp2_;
	_data_->_data55_->err = NULL;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = SOUP_SESSION;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->msg;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _g_object_ref0 (_data_->_tmp4_);
	soup_session_queue_message (_data_->_tmp3_, _data_->_tmp5_, ___lambda66__soup_session_callback, block55_data_ref (_data_->_data55_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_data55_->err;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_data55_->err;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _g_error_copy0 (_data_->_tmp7_);
		_data_->_inner_error_ = _data_->_tmp8_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->msg);
		block55_data_unref (_data_->_data55_);
		_data_->_data55_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_data55_->avatar;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
	_data_->result = _data_->_tmp10_;
	_g_object_unref0 (_data_->msg);
	block55_data_unref (_data_->_data55_);
	_data_->_data55_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->msg);
	block55_data_unref (_data_->_data55_);
	_data_->_data55_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Calculates the length of a tweet.
   *
   * @param text The text to calculate the length for
   *
   * @return The length of the tweet, taking Twitter's rules for
   *         tweet length into account.
   */
static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


gint tweet_utils_calc_tweet_length (const gchar* text, gint media_count) {
	gint result = 0;
	gint length = 0;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gunichar c = 0U;
	gint last_word_start = 0;
	gint n_chars = 0;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint cur = 0;
	g_return_val_if_fail (text != NULL, 0);
	length = 0;
	_tmp0_ = text;
	_tmp1_ = string_strip (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == 0;
	_g_free0 (_tmp2_);
	if (_tmp5_) {
		result = 0;
		return result;
	}
	last_word_start = 0;
	_tmp6_ = text;
	_tmp7_ = g_utf8_strlen (_tmp6_, (gssize) -1);
	n_chars = _tmp7_;
	cur = 0;
	{
		gint next = 0;
		gint c_n = 0;
		next = 0;
		c_n = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				const gchar* _tmp10_ = NULL;
				gunichar _tmp11_ = 0U;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				gunichar _tmp20_ = 0U;
				gboolean splits = FALSE;
				gboolean _tmp28_ = FALSE;
				gboolean _tmp29_ = FALSE;
				gint _tmp51_ = 0;
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = c_n;
					c_n = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = text;
				_tmp12_ = string_get_next_char (_tmp10_, &next, &_tmp11_);
				c = _tmp11_;
				if (!_tmp12_) {
					break;
				}
				_tmp20_ = c;
				if (_tmp20_ == ((gunichar) ' ')) {
					_tmp19_ = TRUE;
				} else {
					gunichar _tmp21_ = 0U;
					_tmp21_ = c;
					_tmp19_ = _tmp21_ == ((gunichar) '\n');
				}
				if (_tmp19_) {
					_tmp18_ = TRUE;
				} else {
					gunichar _tmp22_ = 0U;
					_tmp22_ = c;
					_tmp18_ = _tmp22_ == ((gunichar) '(');
				}
				if (_tmp18_) {
					_tmp17_ = TRUE;
				} else {
					gunichar _tmp23_ = 0U;
					_tmp23_ = c;
					_tmp17_ = _tmp23_ == ((gunichar) ')');
				}
				if (_tmp17_) {
					_tmp16_ = TRUE;
				} else {
					gunichar _tmp24_ = 0U;
					_tmp24_ = c;
					_tmp16_ = _tmp24_ == ((gunichar) '[');
				}
				if (_tmp16_) {
					_tmp15_ = TRUE;
				} else {
					gunichar _tmp25_ = 0U;
					_tmp25_ = c;
					_tmp15_ = _tmp25_ == ((gunichar) ']');
				}
				if (_tmp15_) {
					_tmp14_ = TRUE;
				} else {
					gunichar _tmp26_ = 0U;
					_tmp26_ = c;
					_tmp14_ = _tmp26_ == ((gunichar) '{');
				}
				if (_tmp14_) {
					_tmp13_ = TRUE;
				} else {
					gunichar _tmp27_ = 0U;
					_tmp27_ = c;
					_tmp13_ = _tmp27_ == ((gunichar) '}');
				}
				splits = _tmp13_;
				_tmp29_ = splits;
				if (_tmp29_) {
					_tmp28_ = TRUE;
				} else {
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
					_tmp30_ = c_n;
					_tmp31_ = n_chars;
					_tmp28_ = _tmp30_ == (_tmp31_ - 1);
				}
				if (_tmp28_) {
					gboolean _tmp32_ = FALSE;
					gboolean _tmp33_ = FALSE;
					gchar* word = NULL;
					const gchar* _tmp37_ = NULL;
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					gchar* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					gint _tmp44_ = 0;
					gboolean _tmp48_ = FALSE;
					gint _tmp50_ = 0;
					_tmp33_ = splits;
					if (!_tmp33_) {
						gint _tmp34_ = 0;
						gint _tmp35_ = 0;
						_tmp34_ = c_n;
						_tmp35_ = n_chars;
						_tmp32_ = _tmp34_ == (_tmp35_ - 1);
					} else {
						_tmp32_ = FALSE;
					}
					if (_tmp32_) {
						gint _tmp36_ = 0;
						_tmp36_ = next;
						cur = _tmp36_;
					}
					_tmp37_ = text;
					_tmp38_ = last_word_start;
					_tmp39_ = cur;
					_tmp40_ = last_word_start;
					_tmp41_ = string_substring (_tmp37_, (glong) _tmp38_, (glong) (_tmp39_ - _tmp40_));
					word = _tmp41_;
					_tmp42_ = word;
					_tmp43_ = strlen (_tmp42_);
					_tmp44_ = _tmp43_;
					if (_tmp44_ > 0) {
						gint _tmp45_ = 0;
						const gchar* _tmp46_ = NULL;
						gint _tmp47_ = 0;
						_tmp45_ = length;
						_tmp46_ = word;
						_tmp47_ = tweet_utils_get_word_length (_tmp46_);
						length = _tmp45_ + _tmp47_;
					}
					_tmp48_ = splits;
					if (_tmp48_) {
						gint _tmp49_ = 0;
						_tmp49_ = length;
						length = _tmp49_ + 1;
					}
					_tmp50_ = cur;
					last_word_start = _tmp50_ + 1;
					_g_free0 (word);
				}
				_tmp51_ = next;
				cur = _tmp51_;
			}
		}
	}
	result = length;
	return result;
}


gint tweet_utils_get_word_length (const gchar* s) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar** parts = NULL;
	const gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gint parts_length1 = 0;
	gint _parts_size_ = 0;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	g_return_val_if_fail (s != NULL, 0);
	_tmp1_ = s;
	_tmp2_ = g_str_has_prefix (_tmp1_, "www.");
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = s;
		_tmp4_ = g_str_has_prefix (_tmp3_, "http://");
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		result = TWITTER_short_url_length;
		return result;
	}
	_tmp5_ = s;
	_tmp6_ = g_str_has_prefix (_tmp5_, "https://");
	if (_tmp6_) {
		result = TWITTER_short_url_length_https;
		return result;
	}
	_tmp7_ = s;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "/", 0);
	parts = _tmp9_;
	parts_length1 = _vala_array_length (_tmp8_);
	_parts_size_ = parts_length1;
	_tmp10_ = parts;
	_tmp10__length1 = parts_length1;
	if (_tmp10__length1 > 0) {
		{
			const gchar** tld_collection = NULL;
			gint tld_collection_length1 = 0;
			gint _tld_collection_size_ = 0;
			gint tld_it = 0;
			tld_collection = TWEET_UTILS_DOMAINS;
			tld_collection_length1 = G_N_ELEMENTS (TWEET_UTILS_DOMAINS);
			for (tld_it = 0; tld_it < G_N_ELEMENTS (TWEET_UTILS_DOMAINS); tld_it = tld_it + 1) {
				const gchar* tld = NULL;
				tld = tld_collection[tld_it];
				{
					gchar** _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					const gchar* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					_tmp11_ = parts;
					_tmp11__length1 = parts_length1;
					_tmp12_ = _tmp11_[0];
					_tmp13_ = tld;
					_tmp14_ = g_str_has_suffix (_tmp12_, _tmp13_);
					if (_tmp14_) {
						result = TWITTER_short_url_length;
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
				}
			}
		}
	}
	_tmp15_ = s;
	_tmp16_ = g_utf8_strlen (_tmp15_, (gssize) -1);
	result = _tmp16_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* term = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_return_val_if_fail (IS_MAIN_WINDOW (window), FALSE);
	_tmp0_ = uri;
	_tmp1_ = g_strstrip (_tmp0_);
	uri = _tmp1_;
	_tmp2_ = uri;
	_tmp3_ = string_substring (_tmp2_, (glong) 1, (glong) -1);
	term = _tmp3_;
	_tmp4_ = uri;
	_tmp5_ = g_str_has_prefix (_tmp4_, "@");
	if (_tmp5_) {
		gint slash_index = 0;
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		Bundle* bundle = NULL;
		Bundle* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		_tmp6_ = uri;
		_tmp7_ = string_index_of (_tmp6_, "/", 0);
		slash_index = _tmp7_;
		_tmp8_ = bundle_new ();
		bundle = _tmp8_;
		_tmp9_ = slash_index;
		if (_tmp9_ == -1) {
			Bundle* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			MainWindow* _tmp13_ = NULL;
			MainWidget* _tmp14_ = NULL;
			Bundle* _tmp15_ = NULL;
			_tmp10_ = bundle;
			_tmp11_ = term;
			_tmp12_ = int64_parse (_tmp11_);
			bundle_put_int64 (_tmp10_, "user_id", _tmp12_);
			_tmp13_ = window;
			_tmp14_ = _tmp13_->main_widget;
			_tmp15_ = bundle;
			main_widget_switch_page (_tmp14_, (gint) PAGE_PROFILE, _tmp15_);
		} else {
			Bundle* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gint64 _tmp21_ = 0LL;
			Bundle* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			const gchar* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			MainWindow* _tmp31_ = NULL;
			MainWidget* _tmp32_ = NULL;
			Bundle* _tmp33_ = NULL;
			_tmp16_ = bundle;
			_tmp17_ = term;
			_tmp18_ = slash_index;
			_tmp19_ = string_substring (_tmp17_, (glong) 0, (glong) (_tmp18_ - 1));
			_tmp20_ = _tmp19_;
			_tmp21_ = int64_parse (_tmp20_);
			bundle_put_int64 (_tmp16_, "user_id", _tmp21_);
			_g_free0 (_tmp20_);
			_tmp22_ = bundle;
			_tmp23_ = term;
			_tmp24_ = slash_index;
			_tmp25_ = term;
			_tmp26_ = strlen (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = slash_index;
			_tmp29_ = string_substring (_tmp23_, (glong) (_tmp24_ + 1), (glong) ((_tmp27_ - _tmp28_) - 1));
			_tmp30_ = _tmp29_;
			bundle_put_string (_tmp22_, "screen_name", _tmp30_);
			_g_free0 (_tmp30_);
			_tmp31_ = window;
			_tmp32_ = _tmp31_->main_widget;
			_tmp33_ = bundle;
			main_widget_switch_page (_tmp32_, (gint) PAGE_PROFILE, _tmp33_);
		}
		result = TRUE;
		_g_object_unref0 (bundle);
		_g_free0 (term);
		return result;
	} else {
		const gchar* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		_tmp34_ = uri;
		_tmp35_ = g_str_has_prefix (_tmp34_, "#");
		if (_tmp35_) {
			Bundle* bundle = NULL;
			Bundle* _tmp36_ = NULL;
			Bundle* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			MainWindow* _tmp39_ = NULL;
			MainWidget* _tmp40_ = NULL;
			Bundle* _tmp41_ = NULL;
			_tmp36_ = bundle_new ();
			bundle = _tmp36_;
			_tmp37_ = bundle;
			_tmp38_ = uri;
			bundle_put_string (_tmp37_, "query", _tmp38_);
			_tmp39_ = window;
			_tmp40_ = _tmp39_->main_widget;
			_tmp41_ = bundle;
			main_widget_switch_page (_tmp40_, (gint) PAGE_SEARCH, _tmp41_);
			result = TRUE;
			_g_object_unref0 (bundle);
			_g_free0 (term);
			return result;
		} else {
			const gchar* _tmp42_ = NULL;
			gboolean _tmp43_ = FALSE;
			_tmp42_ = uri;
			_tmp43_ = g_str_has_prefix (_tmp42_, "https://twitter.com/");
			if (_tmp43_) {
				gchar** parts = NULL;
				const gchar* _tmp44_ = NULL;
				gchar** _tmp45_ = NULL;
				gchar** _tmp46_ = NULL;
				gint parts_length1 = 0;
				gint _parts_size_ = 0;
				gchar** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				const gchar* _tmp48_ = NULL;
				_tmp44_ = uri;
				_tmp46_ = _tmp45_ = g_strsplit (_tmp44_, "/", 0);
				parts = _tmp46_;
				parts_length1 = _vala_array_length (_tmp45_);
				_parts_size_ = parts_length1;
				_tmp47_ = parts;
				_tmp47__length1 = parts_length1;
				_tmp48_ = _tmp47_[4];
				if (g_strcmp0 (_tmp48_, "status") == 0) {
					gint64 tweet_id = 0LL;
					gchar** _tmp49_ = NULL;
					gint _tmp49__length1 = 0;
					const gchar* _tmp50_ = NULL;
					gint64 _tmp51_ = 0LL;
					Bundle* bundle = NULL;
					Bundle* _tmp52_ = NULL;
					Bundle* _tmp53_ = NULL;
					Bundle* _tmp54_ = NULL;
					gint64 _tmp55_ = 0LL;
					Bundle* _tmp56_ = NULL;
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					const gchar* _tmp58_ = NULL;
					MainWindow* _tmp59_ = NULL;
					MainWidget* _tmp60_ = NULL;
					Bundle* _tmp61_ = NULL;
					_tmp49_ = parts;
					_tmp49__length1 = parts_length1;
					_tmp50_ = _tmp49_[5];
					_tmp51_ = int64_parse (_tmp50_);
					tweet_id = _tmp51_;
					_tmp52_ = bundle_new ();
					bundle = _tmp52_;
					_tmp53_ = bundle;
					bundle_put_int (_tmp53_, "mode", TWEET_INFO_PAGE_BY_ID);
					_tmp54_ = bundle;
					_tmp55_ = tweet_id;
					bundle_put_int64 (_tmp54_, "tweet_id", _tmp55_);
					_tmp56_ = bundle;
					_tmp57_ = parts;
					_tmp57__length1 = parts_length1;
					_tmp58_ = _tmp57_[3];
					bundle_put_string (_tmp56_, "screen_name", _tmp58_);
					_tmp59_ = window;
					_tmp60_ = _tmp59_->main_widget;
					_tmp61_ = bundle;
					main_widget_switch_page (_tmp60_, (gint) PAGE_TWEET_INFO, _tmp61_);
					result = TRUE;
					_g_object_unref0 (bundle);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (term);
					return result;
				}
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	result = FALSE;
	_g_free0 (term);
	return result;
}


void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, Account* account) {
	guint n_tweets = 0U;
	JsonArray* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GDateTime* now = NULL;
	GDateTime* _tmp3_ = NULL;
	g_return_if_fail (json_array != NULL);
	g_return_if_fail (IS_TWEET_LIST_BOX (tweet_list));
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = json_array;
	_tmp1_ = json_array_get_length (_tmp0_);
	n_tweets = _tmp1_;
	_tmp2_ = n_tweets;
	if (_tmp2_ == ((guint) 0)) {
		return;
	}
	_tmp3_ = g_date_time_new_now_local ();
	now = _tmp3_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				guint _tmp6_ = 0U;
				guint _tmp7_ = 0U;
				CbTweet* tweet = NULL;
				CbTweet* _tmp8_ = NULL;
				CbTweet* _tmp9_ = NULL;
				JsonArray* _tmp10_ = NULL;
				guint _tmp11_ = 0U;
				JsonNode* _tmp12_ = NULL;
				Account* _tmp13_ = NULL;
				gint64 _tmp14_ = 0LL;
				GDateTime* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				Account* _tmp18_ = NULL;
				CbUserCounter* _tmp19_ = NULL;
				Account* _tmp23_ = NULL;
				CbUserCounter* _tmp24_ = NULL;
				CbTweet* _tmp25_ = NULL;
				CbTweet* _tmp26_ = NULL;
				CbMiniTweet* _tmp27_ = NULL;
				Account* _tmp32_ = NULL;
				CbTweet* _tmp33_ = NULL;
				gboolean _tmp34_ = FALSE;
				TweetListBox* _tmp36_ = NULL;
				TweetModel* _tmp37_ = NULL;
				CbTweet* _tmp38_ = NULL;
				if (!_tmp4_) {
					guint _tmp5_ = 0U;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = n_tweets;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = cb_tweet_new ();
				tweet = _tmp8_;
				_tmp9_ = tweet;
				_tmp10_ = json_array;
				_tmp11_ = i;
				_tmp12_ = json_array_get_element (_tmp10_, _tmp11_);
				_tmp13_ = account;
				_tmp14_ = _tmp13_->id;
				_tmp15_ = now;
				cb_tweet_load_from_json (_tmp9_, _tmp12_, _tmp14_, _tmp15_);
				_tmp18_ = account;
				_tmp19_ = _tmp18_->user_counter;
				if (_tmp19_ == NULL) {
					_tmp17_ = TRUE;
				} else {
					TweetListBox* _tmp20_ = NULL;
					_tmp20_ = tweet_list;
					_tmp17_ = _tmp20_ == NULL;
				}
				if (_tmp17_) {
					_tmp16_ = TRUE;
				} else {
					TweetListBox* _tmp21_ = NULL;
					GtkWidget* _tmp22_ = NULL;
					_tmp21_ = tweet_list;
					_tmp22_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
					_tmp16_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, gtk_window_get_type ());
				}
				if (_tmp16_) {
					_g_object_unref0 (tweet);
					break;
				}
				_tmp23_ = account;
				_tmp24_ = _tmp23_->user_counter;
				_tmp25_ = tweet;
				cb_user_counter_id_seen (_tmp24_, &_tmp25_->source_tweet.author);
				_tmp26_ = tweet;
				_tmp27_ = _tmp26_->retweeted_tweet;
				if (_tmp27_ != NULL) {
					Account* _tmp28_ = NULL;
					CbUserCounter* _tmp29_ = NULL;
					CbTweet* _tmp30_ = NULL;
					CbMiniTweet* _tmp31_ = NULL;
					_tmp28_ = account;
					_tmp29_ = _tmp28_->user_counter;
					_tmp30_ = tweet;
					_tmp31_ = _tmp30_->retweeted_tweet;
					cb_user_counter_id_seen (_tmp29_, &(*_tmp31_).author);
				}
				_tmp32_ = account;
				_tmp33_ = tweet;
				_tmp34_ = account_filter_matches (_tmp32_, _tmp33_);
				if (_tmp34_) {
					CbTweet* _tmp35_ = NULL;
					_tmp35_ = tweet;
					cb_tweet_set_flag (_tmp35_, (guint) CB_TWEET_STATE_HIDDEN_FILTERED);
				}
				_tmp36_ = tweet_list;
				_tmp37_ = _tmp36_->model;
				_tmp38_ = tweet;
				tweet_model_add (_tmp37_, _tmp38_);
				_g_object_unref0 (tweet);
			}
		}
	}
	_g_date_time_unref0 (now);
}


void tweet_utils_handle_media_click (CbTweet* t, MainWindow* window, gint index) {
	MediaDialog* media_dialog = NULL;
	CbTweet* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	MediaDialog* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	g_return_if_fail (CB_IS_TWEET (t));
	g_return_if_fail (IS_MAIN_WINDOW (window));
	_tmp0_ = t;
	_tmp1_ = index;
	_tmp2_ = media_dialog_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	media_dialog = _tmp2_;
	_tmp3_ = window;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow));
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (media_dialog, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (media_dialog);
}


gboolean tweet_utils_is_link (const gchar* word) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (word != NULL, FALSE);
	_tmp1_ = word;
	_tmp2_ = g_str_has_prefix (_tmp1_, "http://");
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp3_ = word;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ > 7;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp7_ = word;
	_tmp8_ = g_str_has_prefix (_tmp7_, "https://");
	if (_tmp8_) {
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp9_ = word;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp6_ = _tmp11_ > 8;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = TRUE;
		return result;
	}
	{
		const gchar** tld_collection = NULL;
		gint tld_collection_length1 = 0;
		gint _tld_collection_size_ = 0;
		gint tld_it = 0;
		tld_collection = TWEET_UTILS_DOMAINS;
		tld_collection_length1 = G_N_ELEMENTS (TWEET_UTILS_DOMAINS);
		for (tld_it = 0; tld_it < G_N_ELEMENTS (TWEET_UTILS_DOMAINS); tld_it = tld_it + 1) {
			const gchar* tld = NULL;
			tld = tld_collection[tld_it];
			{
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gboolean _tmp14_ = FALSE;
				_tmp12_ = word;
				_tmp13_ = tld;
				_tmp14_ = g_str_has_suffix (_tmp12_, _tmp13_);
				if (_tmp14_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean _vala_unichar_array_contains (gunichar* stack, int stack_length, gunichar needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_ = 0L;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


gboolean tweet_utils_is_mention (const gchar* word, gint* at_pos) {
	gint _vala_at_pos = 0;
	gboolean result = FALSE;
	gint k = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gunichar _tmp11_ = 0U;
	g_return_val_if_fail (word != NULL, FALSE);
	k = 0;
	while (TRUE) {
		const gchar* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gunichar _tmp2_ = 0U;
		gint _tmp3_ = 0;
		_tmp0_ = word;
		_tmp1_ = k;
		_tmp2_ = string_get_char (_tmp0_, (glong) _tmp1_);
		if (!_vala_unichar_array_contains (TWEET_UTILS_non_mention_chars, G_N_ELEMENTS (TWEET_UTILS_non_mention_chars), _tmp2_)) {
			break;
		}
		_tmp3_ = k;
		k = _tmp3_ + 1;
	}
	_tmp4_ = k;
	_vala_at_pos = _tmp4_;
	_tmp7_ = word;
	_tmp8_ = word;
	_tmp9_ = k;
	_tmp10_ = string_index_of_nth_char (_tmp8_, (glong) _tmp9_);
	_tmp11_ = string_get_char (_tmp7_, (glong) _tmp10_);
	if (_tmp11_ == ((gunichar) '@')) {
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp12_ = word;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp6_ = _tmp14_ > 1;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		_tmp15_ = word;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = k;
		_tmp5_ = (_tmp17_ - _tmp18_) > 1;
	} else {
		_tmp5_ = FALSE;
	}
	result = _tmp5_;
	if (at_pos) {
		*at_pos = _vala_at_pos;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gboolean tweet_utils_is_hashtag (const gchar* word) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gchar _tmp2_ = '\0';
	g_return_val_if_fail (word != NULL, FALSE);
	_tmp1_ = word;
	_tmp2_ = string_get (_tmp1_, (glong) 0);
	if (_tmp2_ == '#') {
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp3_ = word;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ > 1;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self) {
	GtkTextIter* dup;
	dup = g_new0 (GtkTextIter, 1);
	memcpy (dup, self, sizeof (GtkTextIter));
	return dup;
}


static gpointer __gtk_text_iter_dup0 (gpointer self) {
	return self ? _gtk_text_iter_dup (self) : NULL;
}


void tweet_utils_highlight_link (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	GtkTextIter* iter1 = NULL;
	GtkTextIter* _tmp0_ = NULL;
	GtkTextIter* _tmp1_ = NULL;
	GtkTextIter* iter2 = NULL;
	GtkTextIter* _tmp2_ = NULL;
	GtkTextIter* _tmp3_ = NULL;
	GtkTextIter* _tmp4_ = NULL;
	GtkTextIter* _tmp5_ = NULL;
	GtkTextBuffer* _tmp23_ = NULL;
	GtkTextIter* _tmp24_ = NULL;
	GtkTextIter* _tmp25_ = NULL;
	GtkTextIter _tmp26_ = {0};
	GtkTextIter _tmp27_ = {0};
	GtkTextBuffer* _tmp28_ = NULL;
	GtkTextIter* _tmp29_ = NULL;
	GtkTextIter* _tmp30_ = NULL;
	GtkTextIter _tmp31_ = {0};
	GtkTextIter _tmp32_ = {0};
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = word_start;
	_tmp1_ = __gtk_text_iter_dup0 (_tmp0_);
	iter1 = _tmp1_;
	_tmp2_ = word_start;
	_tmp3_ = __gtk_text_iter_dup0 (_tmp2_);
	iter2 = _tmp3_;
	_tmp4_ = iter1;
	gtk_text_iter_forward_char (_tmp4_);
	_tmp5_ = iter2;
	gtk_text_iter_forward_chars (_tmp5_, 2);
	while (TRUE) {
		GtkTextIter* _tmp6_ = NULL;
		GtkTextIter* _tmp7_ = NULL;
		GtkTextIter _tmp8_ = {0};
		gint _tmp9_ = 0;
		gchar* t = NULL;
		GtkTextBuffer* _tmp10_ = NULL;
		GtkTextIter* _tmp11_ = NULL;
		GtkTextIter* _tmp12_ = NULL;
		GtkTextIter _tmp13_ = {0};
		GtkTextIter _tmp14_ = {0};
		gchar* _tmp15_ = NULL;
		gunichar c = 0U;
		const gchar* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
		gboolean _tmp18_ = FALSE;
		gunichar _tmp19_ = 0U;
		GtkTextIter* _tmp21_ = NULL;
		GtkTextIter* _tmp22_ = NULL;
		_tmp6_ = iter1;
		_tmp7_ = word_end;
		_tmp8_ = *_tmp7_;
		_tmp9_ = gtk_text_iter_compare (_tmp6_, &_tmp8_);
		if (!(_tmp9_ < 0)) {
			break;
		}
		_tmp10_ = buffer;
		_tmp11_ = iter1;
		_tmp12_ = iter2;
		_tmp13_ = *_tmp11_;
		_tmp14_ = *_tmp12_;
		_tmp15_ = gtk_text_buffer_get_text (_tmp10_, &_tmp13_, &_tmp14_, FALSE);
		t = _tmp15_;
		_tmp16_ = t;
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
		c = _tmp17_;
		_tmp19_ = c;
		if (_tmp19_ == ((gunichar) '"')) {
			_tmp18_ = TRUE;
		} else {
			gunichar _tmp20_ = 0U;
			_tmp20_ = c;
			_tmp18_ = _tmp20_ == 8220U;
		}
		if (_tmp18_) {
			_g_free0 (t);
			break;
		}
		_tmp21_ = iter1;
		gtk_text_iter_forward_char (_tmp21_);
		_tmp22_ = iter2;
		gtk_text_iter_forward_char (_tmp22_);
		_g_free0 (t);
	}
	_tmp23_ = buffer;
	_tmp24_ = word_start;
	_tmp25_ = iter1;
	_tmp26_ = *_tmp24_;
	_tmp27_ = *_tmp25_;
	gtk_text_buffer_apply_tag_by_name (_tmp23_, "link", &_tmp26_, &_tmp27_);
	_tmp28_ = buffer;
	_tmp29_ = word_start;
	_tmp30_ = iter1;
	_tmp31_ = *_tmp29_;
	_tmp32_ = *_tmp30_;
	gtk_text_buffer_apply_tag_by_name (_tmp28_, TWEET_UTILS_NO_SPELL_CHECK, &_tmp31_, &_tmp32_);
	_g_free0 (iter2);
	_g_free0 (iter1);
}


/** Invariant: The word passed to this function starts with a @ */
void tweet_utils_highlight_mention (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	GtkTextIter* iter1 = NULL;
	GtkTextIter* _tmp0_ = NULL;
	GtkTextIter* _tmp1_ = NULL;
	GtkTextIter* iter2 = NULL;
	GtkTextIter* _tmp2_ = NULL;
	GtkTextIter* _tmp3_ = NULL;
	GtkTextIter* _tmp4_ = NULL;
	GtkTextIter* _tmp5_ = NULL;
	GtkTextBuffer* _tmp28_ = NULL;
	GtkTextIter* _tmp29_ = NULL;
	GtkTextIter* _tmp30_ = NULL;
	GtkTextIter _tmp31_ = {0};
	GtkTextIter _tmp32_ = {0};
	GtkTextBuffer* _tmp33_ = NULL;
	GtkTextIter* _tmp34_ = NULL;
	GtkTextIter* _tmp35_ = NULL;
	GtkTextIter _tmp36_ = {0};
	GtkTextIter _tmp37_ = {0};
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = word_start;
	_tmp1_ = __gtk_text_iter_dup0 (_tmp0_);
	iter1 = _tmp1_;
	_tmp2_ = word_start;
	_tmp3_ = __gtk_text_iter_dup0 (_tmp2_);
	iter2 = _tmp3_;
	_tmp4_ = iter1;
	gtk_text_iter_forward_char (_tmp4_);
	_tmp5_ = iter2;
	gtk_text_iter_forward_chars (_tmp5_, 2);
	while (TRUE) {
		GtkTextIter* _tmp6_ = NULL;
		GtkTextIter* _tmp7_ = NULL;
		GtkTextIter _tmp8_ = {0};
		gint _tmp9_ = 0;
		gchar* t = NULL;
		GtkTextBuffer* _tmp10_ = NULL;
		GtkTextIter* _tmp11_ = NULL;
		GtkTextIter* _tmp12_ = NULL;
		GtkTextIter _tmp13_ = {0};
		GtkTextIter _tmp14_ = {0};
		gchar* _tmp15_ = NULL;
		gunichar c = 0U;
		const gchar* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gunichar _tmp21_ = 0U;
		gboolean _tmp22_ = FALSE;
		GtkTextIter* _tmp26_ = NULL;
		GtkTextIter* _tmp27_ = NULL;
		_tmp6_ = iter1;
		_tmp7_ = word_end;
		_tmp8_ = *_tmp7_;
		_tmp9_ = gtk_text_iter_compare (_tmp6_, &_tmp8_);
		if (!(_tmp9_ < 0)) {
			break;
		}
		_tmp10_ = buffer;
		_tmp11_ = iter1;
		_tmp12_ = iter2;
		_tmp13_ = *_tmp11_;
		_tmp14_ = *_tmp12_;
		_tmp15_ = gtk_text_buffer_get_text (_tmp10_, &_tmp13_, &_tmp14_, FALSE);
		t = _tmp15_;
		_tmp16_ = t;
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
		c = _tmp17_;
		_tmp21_ = c;
		_tmp22_ = g_unichar_ispunct (_tmp21_);
		if (_tmp22_) {
			gunichar _tmp23_ = 0U;
			_tmp23_ = c;
			_tmp20_ = _tmp23_ != ((gunichar) '_');
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gunichar _tmp24_ = 0U;
			_tmp24_ = c;
			_tmp19_ = _tmp24_ == ((gunichar) '"');
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gunichar _tmp25_ = 0U;
			_tmp25_ = c;
			_tmp18_ = _tmp25_ == 8220U;
		}
		if (_tmp18_) {
			_g_free0 (t);
			break;
		}
		_tmp26_ = iter1;
		gtk_text_iter_forward_char (_tmp26_);
		_tmp27_ = iter2;
		gtk_text_iter_forward_char (_tmp27_);
		_g_free0 (t);
	}
	_tmp28_ = buffer;
	_tmp29_ = word_start;
	_tmp30_ = iter1;
	_tmp31_ = *_tmp29_;
	_tmp32_ = *_tmp30_;
	gtk_text_buffer_apply_tag_by_name (_tmp28_, "mention", &_tmp31_, &_tmp32_);
	_tmp33_ = buffer;
	_tmp34_ = word_start;
	_tmp35_ = iter1;
	_tmp36_ = *_tmp34_;
	_tmp37_ = *_tmp35_;
	gtk_text_buffer_apply_tag_by_name (_tmp33_, TWEET_UTILS_NO_SPELL_CHECK, &_tmp36_, &_tmp37_);
	_g_free0 (iter2);
	_g_free0 (iter1);
}


/** Invariant: the word passed to this function starts with a # */
void tweet_utils_highlight_hashtag (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	GtkTextIter* iter1 = NULL;
	GtkTextIter* _tmp0_ = NULL;
	GtkTextIter* _tmp1_ = NULL;
	GtkTextIter* iter2 = NULL;
	GtkTextIter* _tmp2_ = NULL;
	GtkTextIter* _tmp3_ = NULL;
	GtkTextIter* _tmp4_ = NULL;
	GtkTextIter* _tmp5_ = NULL;
	GtkTextBuffer* _tmp26_ = NULL;
	GtkTextIter* _tmp27_ = NULL;
	GtkTextIter* _tmp28_ = NULL;
	GtkTextIter _tmp29_ = {0};
	GtkTextIter _tmp30_ = {0};
	GtkTextBuffer* _tmp31_ = NULL;
	GtkTextIter* _tmp32_ = NULL;
	GtkTextIter* _tmp33_ = NULL;
	GtkTextIter _tmp34_ = {0};
	GtkTextIter _tmp35_ = {0};
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = word_start;
	_tmp1_ = __gtk_text_iter_dup0 (_tmp0_);
	iter1 = _tmp1_;
	_tmp2_ = word_start;
	_tmp3_ = __gtk_text_iter_dup0 (_tmp2_);
	iter2 = _tmp3_;
	_tmp4_ = iter1;
	gtk_text_iter_forward_char (_tmp4_);
	_tmp5_ = iter2;
	gtk_text_iter_forward_chars (_tmp5_, 2);
	while (TRUE) {
		GtkTextIter* _tmp6_ = NULL;
		GtkTextIter* _tmp7_ = NULL;
		GtkTextIter _tmp8_ = {0};
		gint _tmp9_ = 0;
		gchar* t = NULL;
		GtkTextBuffer* _tmp10_ = NULL;
		GtkTextIter* _tmp11_ = NULL;
		GtkTextIter* _tmp12_ = NULL;
		GtkTextIter _tmp13_ = {0};
		GtkTextIter _tmp14_ = {0};
		gchar* _tmp15_ = NULL;
		gunichar c = 0U;
		const gchar* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gunichar _tmp20_ = 0U;
		gboolean _tmp21_ = FALSE;
		GtkTextIter* _tmp24_ = NULL;
		GtkTextIter* _tmp25_ = NULL;
		_tmp6_ = iter1;
		_tmp7_ = word_end;
		_tmp8_ = *_tmp7_;
		_tmp9_ = gtk_text_iter_compare (_tmp6_, &_tmp8_);
		if (!(_tmp9_ < 0)) {
			break;
		}
		_tmp10_ = buffer;
		_tmp11_ = iter1;
		_tmp12_ = iter2;
		_tmp13_ = *_tmp11_;
		_tmp14_ = *_tmp12_;
		_tmp15_ = gtk_text_buffer_get_text (_tmp10_, &_tmp13_, &_tmp14_, FALSE);
		t = _tmp15_;
		_tmp16_ = t;
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
		c = _tmp17_;
		_tmp20_ = c;
		_tmp21_ = g_unichar_ispunct (_tmp20_);
		if (_tmp21_) {
			gunichar _tmp22_ = 0U;
			_tmp22_ = c;
			_tmp19_ = _tmp22_ != ((gunichar) '_');
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gunichar _tmp23_ = 0U;
			_tmp23_ = c;
			_tmp18_ = _tmp23_ == 8221U;
		}
		if (_tmp18_) {
			_g_free0 (t);
			break;
		}
		_tmp24_ = iter1;
		gtk_text_iter_forward_char (_tmp24_);
		_tmp25_ = iter2;
		gtk_text_iter_forward_char (_tmp25_);
		_g_free0 (t);
	}
	_tmp26_ = buffer;
	_tmp27_ = word_start;
	_tmp28_ = iter1;
	_tmp29_ = *_tmp27_;
	_tmp30_ = *_tmp28_;
	gtk_text_buffer_apply_tag_by_name (_tmp26_, "hashtag", &_tmp29_, &_tmp30_);
	_tmp31_ = buffer;
	_tmp32_ = word_start;
	_tmp33_ = iter1;
	_tmp34_ = *_tmp32_;
	_tmp35_ = *_tmp33_;
	gtk_text_buffer_apply_tag_by_name (_tmp31_, TWEET_UTILS_NO_SPELL_CHECK, &_tmp34_, &_tmp35_);
	_g_free0 (iter2);
	_g_free0 (iter1);
}


void tweet_utils_maybe_highlight_snippet (GtkTextBuffer* buffer, GtkTextIter* word_start, GtkTextIter* word_end) {
	gchar* word = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextIter* _tmp1_ = NULL;
	GtkTextIter* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gchar* snippet = NULL;
	SnippetManager* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = buffer;
	_tmp1_ = word_start;
	_tmp2_ = word_end;
	_tmp3_ = *_tmp1_;
	_tmp4_ = *_tmp2_;
	_tmp5_ = gtk_text_buffer_get_text (_tmp0_, &_tmp3_, &_tmp4_, FALSE);
	word = _tmp5_;
	_tmp6_ = word;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 0) {
		_g_free0 (word);
		return;
	}
	_tmp9_ = corebird_snippet_manager;
	_tmp10_ = word;
	_tmp11_ = snippet_manager_get_snippet (_tmp9_, _tmp10_);
	_g_free0 (snippet);
	snippet = _tmp11_;
	_tmp12_ = snippet;
	if (_tmp12_ != NULL) {
		GtkTextBuffer* _tmp13_ = NULL;
		GtkTextIter* _tmp14_ = NULL;
		GtkTextIter* _tmp15_ = NULL;
		GtkTextIter _tmp16_ = {0};
		GtkTextIter _tmp17_ = {0};
		GtkTextBuffer* _tmp18_ = NULL;
		GtkTextIter* _tmp19_ = NULL;
		GtkTextIter* _tmp20_ = NULL;
		GtkTextIter _tmp21_ = {0};
		GtkTextIter _tmp22_ = {0};
		_tmp13_ = buffer;
		_tmp14_ = word_start;
		_tmp15_ = word_end;
		_tmp16_ = *_tmp14_;
		_tmp17_ = *_tmp15_;
		gtk_text_buffer_apply_tag_by_name (_tmp13_, "snippet", &_tmp16_, &_tmp17_);
		_tmp18_ = buffer;
		_tmp19_ = word_start;
		_tmp20_ = word_end;
		_tmp21_ = *_tmp19_;
		_tmp22_ = *_tmp20_;
		gtk_text_buffer_apply_tag_by_name (_tmp18_, TWEET_UTILS_NO_SPELL_CHECK, &_tmp21_, &_tmp22_);
	}
	_g_free0 (snippet);
	_g_free0 (word);
}


void tweet_utils_annotate_text (GtkTextBuffer* buffer) {
	GtkTextIter* start_iter = NULL;
	GtkTextIter* cur_iter = NULL;
	GtkTextIter* word_start_iter = NULL;
	GtkTextIter* next_iter = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_ = {0};
	GtkTextIter* _tmp3_ = NULL;
	GtkTextIter* _tmp4_ = NULL;
	GtkTextIter* _tmp5_ = NULL;
	GtkTextIter* _tmp6_ = NULL;
	GtkTextIter* _tmp7_ = NULL;
	g_return_if_fail (GTK_IS_TEXT_BUFFER (buffer));
	_tmp0_ = buffer;
	gtk_text_buffer_get_start_iter (_tmp0_, &_tmp1_);
	_g_free0 (start_iter);
	_tmp2_ = _tmp1_;
	_tmp3_ = __gtk_text_iter_dup0 (&_tmp2_);
	start_iter = _tmp3_;
	_tmp4_ = start_iter;
	_tmp5_ = __gtk_text_iter_dup0 (_tmp4_);
	_g_free0 (cur_iter);
	cur_iter = _tmp5_;
	_tmp6_ = cur_iter;
	_tmp7_ = __gtk_text_iter_dup0 (_tmp6_);
	_g_free0 (word_start_iter);
	word_start_iter = _tmp7_;
	while (TRUE) {
		GtkTextIter* _tmp8_ = NULL;
		gunichar _tmp9_ = 0U;
		gboolean _tmp10_ = FALSE;
		GtkTextIter* _tmp14_ = NULL;
		GtkTextIter* _tmp15_ = NULL;
		gboolean done = FALSE;
		GtkTextIter* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean word_end = FALSE;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp55_ = FALSE;
		GtkTextIter* _tmp56_ = NULL;
		GtkTextIter* _tmp57_ = NULL;
		_tmp8_ = cur_iter;
		_tmp9_ = gtk_text_iter_get_char (_tmp8_);
		_tmp10_ = g_unichar_isspace (_tmp9_);
		if (_tmp10_) {
			GtkTextIter* _tmp11_ = NULL;
			GtkTextIter* _tmp12_ = NULL;
			GtkTextIter* _tmp13_ = NULL;
			_tmp11_ = cur_iter;
			_tmp12_ = __gtk_text_iter_dup0 (_tmp11_);
			_g_free0 (word_start_iter);
			word_start_iter = _tmp12_;
			_tmp13_ = word_start_iter;
			gtk_text_iter_forward_char (_tmp13_);
		}
		_tmp14_ = cur_iter;
		_tmp15_ = __gtk_text_iter_dup0 (_tmp14_);
		_g_free0 (next_iter);
		next_iter = _tmp15_;
		_tmp16_ = next_iter;
		_tmp17_ = gtk_text_iter_forward_char (_tmp16_);
		done = !_tmp17_;
		_tmp19_ = done;
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gboolean _tmp20_ = FALSE;
			GtkTextIter* _tmp21_ = NULL;
			gunichar _tmp22_ = 0U;
			gboolean _tmp23_ = FALSE;
			_tmp21_ = next_iter;
			_tmp22_ = gtk_text_iter_get_char (_tmp21_);
			_tmp23_ = g_unichar_isspace (_tmp22_);
			if (_tmp23_) {
				GtkTextIter* _tmp24_ = NULL;
				gunichar _tmp25_ = 0U;
				gboolean _tmp26_ = FALSE;
				_tmp24_ = cur_iter;
				_tmp25_ = gtk_text_iter_get_char (_tmp24_);
				_tmp26_ = g_unichar_isspace (_tmp25_);
				_tmp20_ = !_tmp26_;
			} else {
				_tmp20_ = FALSE;
			}
			_tmp18_ = _tmp20_;
		}
		word_end = _tmp18_;
		_tmp27_ = word_end;
		if (_tmp27_) {
			gint k = 0;
			gchar* w = NULL;
			GtkTextBuffer* _tmp28_ = NULL;
			GtkTextIter* _tmp29_ = NULL;
			GtkTextIter* _tmp30_ = NULL;
			GtkTextIter _tmp31_ = {0};
			GtkTextIter _tmp32_ = {0};
			gchar* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			gboolean _tmp35_ = FALSE;
			_tmp28_ = buffer;
			_tmp29_ = word_start_iter;
			_tmp30_ = next_iter;
			_tmp31_ = *_tmp29_;
			_tmp32_ = *_tmp30_;
			_tmp33_ = gtk_text_buffer_get_text (_tmp28_, &_tmp31_, &_tmp32_, FALSE);
			w = _tmp33_;
			_tmp34_ = w;
			_tmp35_ = tweet_utils_is_link (_tmp34_);
			if (_tmp35_) {
				GtkTextBuffer* _tmp36_ = NULL;
				GtkTextIter* _tmp37_ = NULL;
				GtkTextIter* _tmp38_ = NULL;
				_tmp36_ = buffer;
				_tmp37_ = word_start_iter;
				_tmp38_ = next_iter;
				tweet_utils_highlight_link (_tmp36_, _tmp37_, _tmp38_);
			} else {
				const gchar* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				gboolean _tmp41_ = FALSE;
				_tmp39_ = w;
				_tmp41_ = tweet_utils_is_mention (_tmp39_, &_tmp40_);
				k = _tmp40_;
				if (_tmp41_) {
					GtkTextIter* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					GtkTextBuffer* _tmp44_ = NULL;
					GtkTextIter* _tmp45_ = NULL;
					GtkTextIter* _tmp46_ = NULL;
					_tmp42_ = word_start_iter;
					_tmp43_ = k;
					gtk_text_iter_forward_chars (_tmp42_, _tmp43_);
					_tmp44_ = buffer;
					_tmp45_ = word_start_iter;
					_tmp46_ = next_iter;
					tweet_utils_highlight_mention (_tmp44_, _tmp45_, _tmp46_);
				} else {
					const gchar* _tmp47_ = NULL;
					gboolean _tmp48_ = FALSE;
					_tmp47_ = w;
					_tmp48_ = tweet_utils_is_hashtag (_tmp47_);
					if (_tmp48_) {
						GtkTextBuffer* _tmp49_ = NULL;
						GtkTextIter* _tmp50_ = NULL;
						GtkTextIter* _tmp51_ = NULL;
						_tmp49_ = buffer;
						_tmp50_ = word_start_iter;
						_tmp51_ = next_iter;
						tweet_utils_highlight_hashtag (_tmp49_, _tmp50_, _tmp51_);
					} else {
						GtkTextBuffer* _tmp52_ = NULL;
						GtkTextIter* _tmp53_ = NULL;
						GtkTextIter* _tmp54_ = NULL;
						_tmp52_ = buffer;
						_tmp53_ = word_start_iter;
						_tmp54_ = next_iter;
						tweet_utils_maybe_highlight_snippet (_tmp52_, _tmp53_, _tmp54_);
					}
				}
			}
			_g_free0 (w);
		}
		_tmp55_ = done;
		if (_tmp55_) {
			break;
		}
		_tmp56_ = next_iter;
		_tmp57_ = __gtk_text_iter_dup0 (_tmp56_);
		_g_free0 (cur_iter);
		cur_iter = _tmp57_;
	}
	_g_free0 (next_iter);
	_g_free0 (word_start_iter);
	_g_free0 (cur_iter);
	_g_free0 (start_iter);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void tweet_utils_load_threaded_data_free (gpointer _data) {
	TweetUtilsLoadThreadedData* _data_;
	_data_ = _data;
	__vala_JsonNode_free0 (_data_->result);
	g_slice_free (TweetUtilsLoadThreadedData, _data_);
}


void tweet_utils_load_threaded (RestProxyCall* call, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TweetUtilsLoadThreadedData* _data_;
	RestProxyCall* _tmp0_ = NULL;
	RestProxyCall* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	_data_ = g_slice_new0 (TweetUtilsLoadThreadedData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, tweet_utils_load_threaded);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tweet_utils_load_threaded_data_free);
	_tmp0_ = call;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->call);
	_data_->call = _tmp1_;
	_tmp2_ = cancellable;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	tweet_utils_load_threaded_co (_data_);
}


JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error) {
	JsonNode* result;
	TweetUtilsLoadThreadedData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block56Data* block56_data_ref (Block56Data* _data56_) {
	g_atomic_int_inc (&_data56_->_ref_count_);
	return _data56_;
}


static void block56_data_unref (void * _userdata_) {
	Block56Data* _data56_;
	_data56_ = (Block56Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data56_->_ref_count_)) {
		(_data56_->callback_target_destroy_notify == NULL) ? NULL : (_data56_->callback_target_destroy_notify (_data56_->callback_target), NULL);
		_data56_->callback = NULL;
		_data56_->callback_target = NULL;
		_data56_->callback_target_destroy_notify = NULL;
		_g_error_free0 (_data56_->err);
		__vala_JsonNode_free0 (_data56_->_result_);
		_g_object_unref0 (_data56_->call);
		_g_object_unref0 (_data56_->cancellable);
		g_slice_free (Block56Data, _data56_);
	}
}


static gboolean _tweet_utils_load_threaded_co_gsource_func (gpointer self) {
	gboolean result;
	result = tweet_utils_load_threaded_co (self);
	return result;
}


static gboolean ___lambda17_ (Block56Data* _data56_) {
	gboolean result = FALSE;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_tmp0_ = _data56_->callback;
	_tmp0__target = _data56_->callback_target;
	_tmp0_ (_tmp0__target);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ____lambda17__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda17_ (self);
	return result;
}


static gboolean ___lambda18_ (Block56Data* _data56_) {
	gboolean result = FALSE;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_tmp0_ = _data56_->callback;
	_tmp0__target = _data56_->callback_target;
	_tmp0_ (_tmp0__target);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ____lambda18__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda18_ (self);
	return result;
}


static gboolean ___lambda19_ (Block56Data* _data56_) {
	gboolean result = FALSE;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_tmp0_ = _data56_->callback;
	_tmp0__target = _data56_->callback_target;
	_tmp0_ (_tmp0__target);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ____lambda19__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda19_ (self);
	return result;
}


static gboolean ___lambda20_ (Block56Data* _data56_) {
	gboolean result = FALSE;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_tmp0_ = _data56_->callback;
	_tmp0__target = _data56_->callback_target;
	_tmp0_ (_tmp0__target);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ____lambda20__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda20_ (self);
	return result;
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static gboolean __lambda21_ (Block56Data* _data56_) {
	gboolean result = FALSE;
	GSourceFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	_tmp0_ = _data56_->callback;
	_tmp0__target = _data56_->callback_target;
	_tmp0_ (_tmp0__target);
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ___lambda21__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda21_ (self);
	return result;
}


static void* __lambda16_ (Block56Data* _data56_) {
	void* result = NULL;
	gboolean _tmp3_ = FALSE;
	GCancellable* _tmp4_ = NULL;
	JsonParser* parser = NULL;
	JsonParser* _tmp7_ = NULL;
	gboolean _tmp13_ = FALSE;
	GCancellable* _tmp14_ = NULL;
	JsonParser* _tmp17_ = NULL;
	JsonNode* _tmp18_ = NULL;
	JsonNode* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
	{
		RestProxyCall* _tmp0_ = NULL;
		_tmp0_ = _data56_->call;
		rest_proxy_call_sync (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch62_g_error;
		}
	}
	goto __finally62;
	__catch62_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_g_error_free0 (_data56_->err);
		_data56_->err = _tmp2_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda17__gsource_func, block56_data_ref (_data56_), block56_data_unref);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally62:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = _data56_->cancellable;
	if (_tmp4_ != NULL) {
		GCancellable* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = _data56_->cancellable;
		_tmp6_ = g_cancellable_is_cancelled (_tmp5_);
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda18__gsource_func, block56_data_ref (_data56_), block56_data_unref);
		result = NULL;
		return result;
	}
	_tmp7_ = json_parser_new ();
	parser = _tmp7_;
	{
		JsonParser* _tmp8_ = NULL;
		RestProxyCall* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp8_ = parser;
		_tmp9_ = _data56_->call;
		_tmp10_ = rest_proxy_call_get_payload (_tmp9_);
		json_parser_load_from_data (_tmp8_, _tmp10_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch63_g_error;
		}
	}
	goto __finally63;
	__catch63_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _g_error_copy0 (_tmp11_);
		_g_error_free0 (_data56_->err);
		_data56_->err = _tmp12_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda19__gsource_func, block56_data_ref (_data56_), block56_data_unref);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return result;
	}
	__finally63:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp14_ = _data56_->cancellable;
	if (_tmp14_ != NULL) {
		GCancellable* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		_tmp15_ = _data56_->cancellable;
		_tmp16_ = g_cancellable_is_cancelled (_tmp15_);
		_tmp13_ = _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda20__gsource_func, block56_data_ref (_data56_), block56_data_unref);
		result = NULL;
		_g_object_unref0 (parser);
		return result;
	}
	_tmp17_ = parser;
	_tmp18_ = json_parser_get_root (_tmp17_);
	_tmp19_ = __vala_JsonNode_copy0 (_tmp18_);
	__vala_JsonNode_free0 (_data56_->_result_);
	_data56_->_result_ = _tmp19_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda21__gsource_func, block56_data_ref (_data56_), block56_data_unref);
	result = NULL;
	_g_object_unref0 (parser);
	return result;
}


static gpointer ___lambda16__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda16_ (self);
	block56_data_unref (self);
	return result;
}


static gboolean tweet_utils_load_threaded_co (TweetUtilsLoadThreadedData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data56_ = g_slice_new0 (Block56Data);
	_data_->_data56_->_ref_count_ = 1;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->call;
	_g_object_unref0 (_data_->_data56_->call);
	_data_->_data56_->call = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->cancellable;
	_g_object_unref0 (_data_->_data56_->cancellable);
	_data_->_data56_->cancellable = _data_->_tmp1_;
	_data_->_data56_->_async_data_ = _data_;
	_data_->_data56_->_result_ = NULL;
	_data_->_data56_->err = NULL;
	_data_->_data56_->callback = _tweet_utils_load_threaded_co_gsource_func;
	_data_->_data56_->callback_target = _data_;
	_data_->_data56_->callback_target_destroy_notify = NULL;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_data56_->call;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rest_call_to_string (_data_->_tmp2_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_;
	g_debug ("TweetUtils.vala:486: REST Call: %s", _data_->_tmp4_);
	_g_free0 (_data_->_tmp4_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_thread_new ("json parser", ___lambda16__gthread_func, block56_data_ref (_data_->_data56_));
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_;
	_g_thread_unref0 (_data_->_tmp6_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_data56_->err;
	if (_data_->_tmp7_ != NULL) {
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_data56_->err;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _g_error_copy0 (_data_->_tmp8_);
		_data_->_inner_error_ = _data_->_tmp9_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		block56_data_unref (_data_->_data56_);
		_data_->_data56_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_data56_->_result_;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = __vala_JsonNode_copy0 (_data_->_tmp10_);
	_data_->result = _data_->_tmp11_;
	block56_data_unref (_data_->_data56_);
	_data_->_data56_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block56_data_unref (_data_->_data56_);
	_data_->_data56_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void tweet_utils_sort_entities (CbTextEntity** entities, int* entities_length1) {
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				CbTextEntity* _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = *entities;
				_tmp3__length1 = *entities_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				{
					gint k = 0;
					k = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_ = 0;
							CbTextEntity* _tmp7_ = NULL;
							gint _tmp7__length1 = 0;
							CbTextEntity* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp9_ = 0;
							CbTextEntity _tmp10_ = {0};
							guint _tmp11_ = 0U;
							CbTextEntity* _tmp12_ = NULL;
							gint _tmp12__length1 = 0;
							gint _tmp13_ = 0;
							CbTextEntity _tmp14_ = {0};
							guint _tmp15_ = 0U;
							if (!_tmp4_) {
								gint _tmp5_ = 0;
								_tmp5_ = k;
								k = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = k;
							_tmp7_ = *entities;
							_tmp7__length1 = *entities_length1;
							if (!(_tmp6_ < _tmp7__length1)) {
								break;
							}
							_tmp8_ = *entities;
							_tmp8__length1 = *entities_length1;
							_tmp9_ = i;
							_tmp10_ = _tmp8_[_tmp9_];
							_tmp11_ = _tmp10_.from;
							_tmp12_ = *entities;
							_tmp12__length1 = *entities_length1;
							_tmp13_ = k;
							_tmp14_ = _tmp12_[_tmp13_];
							_tmp15_ = _tmp14_.from;
							if (_tmp11_ < _tmp15_) {
								CbTextEntity c = {0};
								CbTextEntity* _tmp16_ = NULL;
								gint _tmp16__length1 = 0;
								gint _tmp17_ = 0;
								CbTextEntity _tmp18_ = {0};
								CbTextEntity _tmp19_ = {0};
								CbTextEntity* _tmp20_ = NULL;
								gint _tmp20__length1 = 0;
								gint _tmp21_ = 0;
								CbTextEntity* _tmp22_ = NULL;
								gint _tmp22__length1 = 0;
								gint _tmp23_ = 0;
								CbTextEntity _tmp24_ = {0};
								CbTextEntity _tmp25_ = {0};
								CbTextEntity _tmp26_ = {0};
								CbTextEntity* _tmp27_ = NULL;
								gint _tmp27__length1 = 0;
								gint _tmp28_ = 0;
								CbTextEntity _tmp29_ = {0};
								CbTextEntity _tmp30_ = {0};
								CbTextEntity _tmp31_ = {0};
								_tmp16_ = *entities;
								_tmp16__length1 = *entities_length1;
								_tmp17_ = i;
								_tmp18_ = _tmp16_[_tmp17_];
								cb_text_entity_copy (&_tmp18_, &_tmp19_);
								c = _tmp19_;
								_tmp20_ = *entities;
								_tmp20__length1 = *entities_length1;
								_tmp21_ = i;
								_tmp22_ = *entities;
								_tmp22__length1 = *entities_length1;
								_tmp23_ = k;
								_tmp24_ = _tmp22_[_tmp23_];
								cb_text_entity_copy (&_tmp24_, &_tmp25_);
								cb_text_entity_free (&_tmp20_[_tmp21_]);
								_tmp20_[_tmp21_] = _tmp25_;
								_tmp26_ = _tmp20_[_tmp21_];
								_tmp27_ = *entities;
								_tmp27__length1 = *entities_length1;
								_tmp28_ = k;
								_tmp29_ = c;
								cb_text_entity_copy (&_tmp29_, &_tmp30_);
								cb_text_entity_free (&_tmp27_[_tmp28_]);
								_tmp27_[_tmp28_] = _tmp30_;
								_tmp31_ = _tmp27_[_tmp28_];
								cb_text_entity_free (&c);
							}
						}
					}
				}
			}
		}
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



