; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s
; RUN: opt < %s -passes=instcombine -use-constant-fp-for-fixed-length-splat -S | FileCheck %s

declare float @llvm.ldexp.f32.i32(float, i32)
declare <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float>, <2 x i32>)
declare void @use(float)

define float @fneg_fneg(float %a) {
;
; CHECK-LABEL: @fneg_fneg(
; CHECK-NEXT:    ret float [[A:%.*]]
;
  %f = fneg float %a
  %r = fneg float %f
  ret float %r
}

; -(X * C) --> X * (-C)

define float @fmul_fsub(float %x) {
; CHECK-LABEL: @fmul_fsub(
; CHECK-NEXT:    [[R:%.*]] = fmul float [[X:%.*]], -4.200000e+01
; CHECK-NEXT:    ret float [[R]]
;
  %m = fmul float %x, 42.0
  %r = fsub float -0.0, %m
  ret float %r
}

define float @fmul_fneg(float %x) {
; CHECK-LABEL: @fmul_fneg(
; CHECK-NEXT:    [[R:%.*]] = fmul float [[X:%.*]], -4.200000e+01
; CHECK-NEXT:    ret float [[R]]
;
  %m = fmul float %x, 42.0
  %r = fneg float %m
  ret float %r
}

; Fast math is not required, but it should be propagated.

define float @fmul_fsub_fmf(float %x) {
; CHECK-LABEL: @fmul_fsub_fmf(
; CHECK-NEXT:    [[R:%.*]] = fmul nsz float [[X:%.*]], -4.200000e+01
; CHECK-NEXT:    ret float [[R]]
;
  %m = fmul float %x, 42.0
  %r = fsub reassoc nsz float -0.0, %m
  ret float %r
}

define float @fmul_fneg_fmf(float %x) {
; CHECK-LABEL: @fmul_fneg_fmf(
; CHECK-NEXT:    [[R:%.*]] = fmul nsz float [[X:%.*]], -4.200000e+01
; CHECK-NEXT:    ret float [[R]]
;
  %m = fmul float %x, 42.0
  %r = fneg reassoc nsz float %m
  ret float %r
}

; Extra use prevents the fold. We don't want to replace the fneg with an fmul.

define float @fmul_fsub_extra_use(float %x) {
; CHECK-LABEL: @fmul_fsub_extra_use(
; CHECK-NEXT:    [[M:%.*]] = fmul float [[X:%.*]], 4.200000e+01
; CHECK-NEXT:    [[R:%.*]] = fneg float [[M]]
; CHECK-NEXT:    call void @use(float [[M]])
; CHECK-NEXT:    ret float [[R]]
;
  %m = fmul float %x, 42.0
  %r = fsub float -0.0, %m
  call void @use(float %m)
  ret float %r
}

define float @fmul_fneg_extra_use(float %x) {
; CHECK-LABEL: @fmul_fneg_extra_use(
; CHECK-NEXT:    [[M:%.*]] = fmul float [[X:%.*]], 4.200000e+01
; CHECK-NEXT:    [[R:%.*]] = fneg float [[M]]
; CHECK-NEXT:    call void @use(float [[M]])
; CHECK-NEXT:    ret float [[R]]
;
  %m = fmul float %x, 42.0
  %r = fneg float %m
  call void @use(float %m)
  ret float %r
}

; Try a vector. Use special constants (NaN, INF, poison) because they don't change anything.

define <4 x double> @fmul_fsub_vec(<4 x double> %x) {
; CHECK-LABEL: @fmul_fsub_vec(
; CHECK-NEXT:    [[R:%.*]] = fmul <4 x double> [[X:%.*]], <double -4.200000e+01, double 0xFFF8000000000000, double 0xFFF0000000000000, double poison>
; CHECK-NEXT:    ret <4 x double> [[R]]
;
  %m = fmul <4 x double> %x, <double 42.0, double 0x7FF8000000000000, double 0x7FF0000000000000, double poison>
  %r = fsub <4 x double> <double -0.0, double -0.0, double -0.0, double -0.0>, %m
  ret <4 x double> %r
}

define <4 x double> @fmul_fneg_vec(<4 x double> %x) {
; CHECK-LABEL: @fmul_fneg_vec(
; CHECK-NEXT:    [[R:%.*]] = fmul <4 x double> [[X:%.*]], <double -4.200000e+01, double 0xFFF8000000000000, double 0xFFF0000000000000, double poison>
; CHECK-NEXT:    ret <4 x double> [[R]]
;
  %m = fmul <4 x double> %x, <double 42.0, double 0x7FF8000000000000, double 0x7FF0000000000000, double poison>
  %r = fneg <4 x double> %m
  ret <4 x double> %r
}

; -(X / C) --> X / (-C)

define float @fdiv_op1_constant_fsub(float %x) {
; CHECK-LABEL: @fdiv_op1_constant_fsub(
; CHECK-NEXT:    [[R:%.*]] = fdiv float [[X:%.*]], 4.200000e+01
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float %x, -42.0
  %r = fsub float -0.0, %d
  ret float %r
}

define float @fdiv_op1_constant_fneg(float %x) {
; CHECK-LABEL: @fdiv_op1_constant_fneg(
; CHECK-NEXT:    [[R:%.*]] = fdiv float [[X:%.*]], 4.200000e+01
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float %x, -42.0
  %r = fneg float %d
  ret float %r
}

; Fast math is not required, but it should be propagated.

define float @fdiv_op1_constant_fsub_fmf(float %x) {
; CHECK-LABEL: @fdiv_op1_constant_fsub_fmf(
; CHECK-NEXT:    [[R:%.*]] = fdiv nnan float [[X:%.*]], 4.200000e+01
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float %x, -42.0
  %r = fsub nnan float -0.0, %d
  ret float %r
}

define float @fdiv_op1_constant_fneg_fmf(float %x) {
; CHECK-LABEL: @fdiv_op1_constant_fneg_fmf(
; CHECK-NEXT:    [[R:%.*]] = fdiv nnan float [[X:%.*]], 4.200000e+01
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float %x, -42.0
  %r = fneg nnan float %d
  ret float %r
}

; Extra use prevents the fold. We don't want to replace the fneg with an fdiv.

define float @fdiv_op1_constant_fsub_extra_use(float %x) {
; CHECK-LABEL: @fdiv_op1_constant_fsub_extra_use(
; CHECK-NEXT:    [[D:%.*]] = fdiv float [[X:%.*]], 4.200000e+01
; CHECK-NEXT:    [[R:%.*]] = fneg float [[D]]
; CHECK-NEXT:    call void @use(float [[D]])
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float %x, 42.0
  %r = fsub float -0.0, %d
  call void @use(float %d)
  ret float %r
}

define float @fdiv_op1_constant_fneg_extra_use(float %x) {
; CHECK-LABEL: @fdiv_op1_constant_fneg_extra_use(
; CHECK-NEXT:    [[D:%.*]] = fdiv float [[X:%.*]], 4.200000e+01
; CHECK-NEXT:    [[R:%.*]] = fneg float [[D]]
; CHECK-NEXT:    call void @use(float [[D]])
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float %x, 42.0
  %r = fneg float %d
  call void @use(float %d)
  ret float %r
}

; Try a vector. Use special constants (NaN, INF, poison) because they don't change anything.

define <4 x double> @fdiv_op1_constant_fsub_vec(<4 x double> %x) {
; CHECK-LABEL: @fdiv_op1_constant_fsub_vec(
; CHECK-NEXT:    [[R:%.*]] = fdiv <4 x double> [[X:%.*]], <double 4.200000e+01, double 0x7FF800000ABCD000, double 0x7FF0000000000000, double poison>
; CHECK-NEXT:    ret <4 x double> [[R]]
;
  %d = fdiv <4 x double> %x, <double -42.0, double 0xFFF800000ABCD000, double 0xFFF0000000000000, double poison>
  %r = fsub <4 x double> <double -0.0, double -0.0, double -0.0, double -0.0>, %d
  ret <4 x double> %r
}

define <4 x double> @fdiv_op1_constant_fneg_vec(<4 x double> %x) {
; CHECK-LABEL: @fdiv_op1_constant_fneg_vec(
; CHECK-NEXT:    [[R:%.*]] = fdiv <4 x double> [[X:%.*]], <double 4.200000e+01, double 0x7FF800000ABCD000, double 0x7FF0000000000000, double poison>
; CHECK-NEXT:    ret <4 x double> [[R]]
;
  %d = fdiv <4 x double> %x, <double -42.0, double 0xFFF800000ABCD000, double 0xFFF0000000000000, double poison>
  %r = fneg <4 x double> %d
  ret <4 x double> %r
}

; -(C / X) --> (-C) / X

define float @fdiv_op0_constant_fsub(float %x) {
; CHECK-LABEL: @fdiv_op0_constant_fsub(
; CHECK-NEXT:    [[R:%.*]] = fdiv float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float 42.0, %x
  %r = fsub float -0.0, %d
  ret float %r
}

define float @fdiv_op0_constant_fneg(float %x) {
; CHECK-LABEL: @fdiv_op0_constant_fneg(
; CHECK-NEXT:    [[R:%.*]] = fdiv float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float 42.0, %x
  %r = fneg float %d
  ret float %r
}

; Fast math is not required, but it should be propagated.

define float @fdiv_op0_constant_fneg_fast_fast(float %x) {
; CHECK-LABEL: @fdiv_op0_constant_fneg_fast_fast(
; CHECK-NEXT:    [[R:%.*]] = fdiv fast float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv fast float 42.0, %x
  %r = fneg fast float %d
  ret float %r
}

define float @fdiv_op0_constant_fneg_fast(float %x) {
; CHECK-LABEL: @fdiv_op0_constant_fneg_fast(
; CHECK-NEXT:    [[R:%.*]] = fdiv reassoc nnan arcp contract afn float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float 42.0, %x
  %r = fneg fast float %d
  ret float %r
}

define float @fdiv_op0_constant_fneg_nsz_nsz(float %x) {
; CHECK-LABEL: @fdiv_op0_constant_fneg_nsz_nsz(
; CHECK-NEXT:    [[R:%.*]] = fdiv nsz float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv nsz float 42.0, %x
  %r = fneg nsz float %d
  ret float %r
}

define float @fdiv_op0_constant_fneg_nsz(float %x) {
; CHECK-LABEL: @fdiv_op0_constant_fneg_nsz(
; CHECK-NEXT:    [[R:%.*]] = fdiv float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float 42.0, %x
  %r = fneg nsz float %d
  ret float %r
}

define float @fdiv_op0_constant_fneg_ninf_ninf(float %x) {
; CHECK-LABEL: @fdiv_op0_constant_fneg_ninf_ninf(
; CHECK-NEXT:    [[R:%.*]] = fdiv ninf float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv ninf float 42.0, %x
  %r = fneg ninf float %d
  ret float %r
}

define float @fdiv_op0_constant_fneg_ninf(float %x) {
; CHECK-LABEL: @fdiv_op0_constant_fneg_ninf(
; CHECK-NEXT:    [[R:%.*]] = fdiv float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float 42.0, %x
  %r = fneg ninf float %d
  ret float %r
}

define float @fdiv_op0_constant_fneg_nnan_nnan(float %x) {
; CHECK-LABEL: @fdiv_op0_constant_fneg_nnan_nnan(
; CHECK-NEXT:    [[R:%.*]] = fdiv nnan float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv nnan float 42.0, %x
  %r = fneg nnan float %d
  ret float %r
}

define float @fdiv_op0_constant_fneg_nnan(float %x) {
; CHECK-LABEL: @fdiv_op0_constant_fneg_nnan(
; CHECK-NEXT:    [[R:%.*]] = fdiv nnan float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float 42.0, %x
  %r = fneg nnan float %d
  ret float %r
}

; Extra use prevents the fold. We don't want to replace the fneg with an fdiv.

define float @fdiv_op0_constant_fsub_extra_use(float %x) {
; CHECK-LABEL: @fdiv_op0_constant_fsub_extra_use(
; CHECK-NEXT:    [[D:%.*]] = fdiv float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = fneg float [[D]]
; CHECK-NEXT:    call void @use(float [[D]])
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float -42.0, %x
  %r = fsub float -0.0, %d
  call void @use(float %d)
  ret float %r
}

define float @fdiv_op0_constant_fneg_extra_use(float %x) {
; CHECK-LABEL: @fdiv_op0_constant_fneg_extra_use(
; CHECK-NEXT:    [[D:%.*]] = fdiv float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = fneg float [[D]]
; CHECK-NEXT:    call void @use(float [[D]])
; CHECK-NEXT:    ret float [[R]]
;
  %d = fdiv float -42.0, %x
  %r = fneg float %d
  call void @use(float %d)
  ret float %r
}

; Try a vector. Use special constants (NaN, INF, poison) because they don't change anything.

define <4 x double> @fdiv_op0_constant_fsub_vec(<4 x double> %x) {
; CHECK-LABEL: @fdiv_op0_constant_fsub_vec(
; CHECK-NEXT:    [[R:%.*]] = fdiv <4 x double> <double 4.200000e+01, double 0xFFF8000000000000, double 0x7FF0000000000000, double poison>, [[X:%.*]]
; CHECK-NEXT:    ret <4 x double> [[R]]
;
  %d = fdiv <4 x double> <double -42.0, double 0x7FF8000000000000, double 0xFFF0000000000000, double poison>, %x
  %r = fsub <4 x double> <double -0.0, double -0.0, double -0.0, double -0.0>, %d
  ret <4 x double> %r
}

define <4 x double> @fdiv_op0_constant_fneg_vec(<4 x double> %x) {
; CHECK-LABEL: @fdiv_op0_constant_fneg_vec(
; CHECK-NEXT:    [[R:%.*]] = fdiv <4 x double> <double 4.200000e+01, double 0xFFF8000000000000, double 0x7FF0000000000000, double poison>, [[X:%.*]]
; CHECK-NEXT:    ret <4 x double> [[R]]
;
  %d = fdiv <4 x double> <double -42.0, double 0x7FF8000000000000, double 0xFFF0000000000000, double poison>, %x
  %r = fneg <4 x double> %d
  ret <4 x double> %r
}

; Sink FP negation through a select:
; c ? -x : -y --> -(c ? x : y)

define <2 x double> @fneg_fneg_sel(<2 x double> %x, <2 x double> %y, i1 %cond) {
; CHECK-LABEL: @fneg_fneg_sel(
; CHECK-NEXT:    [[SEL_V:%.*]] = select i1 [[COND:%.*]], <2 x double> [[X:%.*]], <2 x double> [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = fneg <2 x double> [[SEL_V]]
; CHECK-NEXT:    ret <2 x double> [[SEL]]
;
  %n1 = fneg <2 x double> %x
  %n2 = fneg <2 x double> %y
  %sel = select i1 %cond, <2 x double> %n1, <2 x double> %n2
  ret <2 x double> %sel
}

; An extra use is allowed.

define float @fneg_fneg_sel_extra_use1(float %x, float %y, i1 %cond) {
; CHECK-LABEL: @fneg_fneg_sel_extra_use1(
; CHECK-NEXT:    [[N1:%.*]] = fneg float [[X:%.*]]
; CHECK-NEXT:    call void @use(float [[N1]])
; CHECK-NEXT:    [[SEL_V:%.*]] = select i1 [[COND:%.*]], float [[X]], float [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = fneg float [[SEL_V]]
; CHECK-NEXT:    ret float [[SEL]]
;
  %n1 = fneg float %x
  call void @use(float %n1)
  %n2 = fneg float %y
  %sel = select i1 %cond, float %n1, float %n2
  ret float %sel
}

define float @fneg_fneg_sel_extra_use2(float %x, float %y, i1 %cond) {
; CHECK-LABEL: @fneg_fneg_sel_extra_use2(
; CHECK-NEXT:    [[N2:%.*]] = fneg float [[Y:%.*]]
; CHECK-NEXT:    call void @use(float [[N2]])
; CHECK-NEXT:    [[SEL_V:%.*]] = select i1 [[COND:%.*]], float [[X:%.*]], float [[Y]]
; CHECK-NEXT:    [[SEL:%.*]] = fneg float [[SEL_V]]
; CHECK-NEXT:    ret float [[SEL]]
;
  %n1 = fneg float %x
  %n2 = fneg float %y
  call void @use(float %n2)
  %sel = select i1 %cond, float %n1, float %n2
  ret float %sel
}

; Legacy form of fneg should work too.

define float @fsub_fsub_sel_extra_use1(float %x, float %y, i1 %cond) {
; CHECK-LABEL: @fsub_fsub_sel_extra_use1(
; CHECK-NEXT:    [[N1:%.*]] = fneg float [[X:%.*]]
; CHECK-NEXT:    call void @use(float [[N1]])
; CHECK-NEXT:    [[SEL_V:%.*]] = select i1 [[COND:%.*]], float [[X]], float [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = fneg float [[SEL_V]]
; CHECK-NEXT:    ret float [[SEL]]
;
  %n1 = fsub float -0.0, %x
  call void @use(float %n1)
  %n2 = fsub float -0.0, %y
  %sel = select i1 %cond, float %n1, float %n2
  ret float %sel
}

; Negative test: but 2 extra uses would require an extra instruction.

define float @fneg_fneg_sel_extra_use3(float %x, float %y, i1 %cond) {
; CHECK-LABEL: @fneg_fneg_sel_extra_use3(
; CHECK-NEXT:    [[N1:%.*]] = fneg float [[X:%.*]]
; CHECK-NEXT:    call void @use(float [[N1]])
; CHECK-NEXT:    [[N2:%.*]] = fneg float [[Y:%.*]]
; CHECK-NEXT:    call void @use(float [[N2]])
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND:%.*]], float [[N1]], float [[N2]]
; CHECK-NEXT:    ret float [[SEL]]
;
  %n1 = fneg float %x
  call void @use(float %n1)
  %n2 = fneg float %y
  call void @use(float %n2)
  %sel = select i1 %cond, float %n1, float %n2
  ret float %sel
}

define double @fneg_fneg_sel_fmf1(double %x, double %y, i1 %cond) {
; CHECK-LABEL: @fneg_fneg_sel_fmf1(
; CHECK-NEXT:    [[SEL_V:%.*]] = select i1 [[COND:%.*]], double [[X:%.*]], double [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = fneg double [[SEL_V]]
; CHECK-NEXT:    ret double [[SEL]]
;
  %n1 = fneg nnan double %x
  %n2 = fneg ninf double %y
  %sel = select i1 %cond, double %n1, double %n2
  ret double %sel
}

define double @fneg_fneg_sel_fmf2(double %x, double %y, i1 %cond) {
; CHECK-LABEL: @fneg_fneg_sel_fmf2(
; CHECK-NEXT:    [[SEL_V:%.*]] = select ninf i1 [[COND:%.*]], double [[X:%.*]], double [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = fneg ninf double [[SEL_V]]
; CHECK-NEXT:    ret double [[SEL]]
;
  %n1 = fneg nnan ninf double %x
  %n2 = fneg ninf double %y
  %sel = select i1 %cond, double %n1, double %n2
  ret double %sel
}

define double @fneg_fneg_sel_fmf3(double %x, double %y, i1 %cond) {
; CHECK-LABEL: @fneg_fneg_sel_fmf3(
; CHECK-NEXT:    [[SEL_V:%.*]] = select ninf i1 [[COND:%.*]], double [[X:%.*]], double [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = fneg ninf double [[SEL_V]]
; CHECK-NEXT:    ret double [[SEL]]
;
  %n1 = fneg nnan ninf double %x
  %n2 = fneg ninf double %y
  %sel = select ninf i1 %cond, double %n1, double %n2
  ret double %sel
}

define double @fneg_fneg_sel_fmf4(double %x, double %y, i1 %cond) {
; CHECK-LABEL: @fneg_fneg_sel_fmf4(
; CHECK-NEXT:    [[SEL_V:%.*]] = select nnan ninf nsz i1 [[COND:%.*]], double [[X:%.*]], double [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = fneg nnan ninf nsz double [[SEL_V]]
; CHECK-NEXT:    ret double [[SEL]]
;
  %n1 = fneg nnan double %x
  %n2 = fneg ninf double %y
  %sel = select nsz nnan ninf i1 %cond, double %n1, double %n2
  ret double %sel
}

; Negative test

define float @fneg_fadd_constant(float %x) {
; CHECK-LABEL: @fneg_fadd_constant(
; CHECK-NEXT:    [[A:%.*]] = fadd float [[X:%.*]], 4.200000e+01
; CHECK-NEXT:    [[R:%.*]] = fneg float [[A]]
; CHECK-NEXT:    ret float [[R]]
;
  %a = fadd float %x, 42.0
  %r = fneg float %a
  ret float %r
}

; Negative test

define float @fake_nsz_fadd_constant(float %x) {
; CHECK-LABEL: @fake_nsz_fadd_constant(
; CHECK-NEXT:    [[A:%.*]] = fadd float [[X:%.*]], 4.200000e+01
; CHECK-NEXT:    [[R:%.*]] = fneg float [[A]]
; CHECK-NEXT:    ret float [[R]]
;
  %a = fadd float %x, 42.0
  %r = fsub float -0.0, %a
  ret float %r
}

; -(X + C) --> -C - X

define float @fneg_nsz_fadd_constant(float %x) {
; CHECK-LABEL: @fneg_nsz_fadd_constant(
; CHECK-NEXT:    [[R:%.*]] = fsub nsz float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %a = fadd float %x, 42.0
  %r = fneg nsz float %a
  ret float %r
}

; -(X + C) --> -C - X

define float @fake_fneg_nsz_fadd_constant(float %x) {
; CHECK-LABEL: @fake_fneg_nsz_fadd_constant(
; CHECK-NEXT:    [[R:%.*]] = fsub fast float -4.200000e+01, [[X:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %a = fadd float %x, 42.0
  %r = fsub fast float -0.0, %a
  ret float %r
}

; Negative test

define float @fneg_nsz_fadd_constant_extra_use(float %x) {
; CHECK-LABEL: @fneg_nsz_fadd_constant_extra_use(
; CHECK-NEXT:    [[A:%.*]] = fadd float [[X:%.*]], 4.200000e+01
; CHECK-NEXT:    call void @use(float [[A]])
; CHECK-NEXT:    [[R:%.*]] = fneg nsz float [[A]]
; CHECK-NEXT:    ret float [[R]]
;
  %a = fadd float %x, 42.0
  call void @use(float %a)
  %r = fneg nsz float %a
  ret float %r
}

; Negative test

define float @fake_fneg_nsz_fadd_constant_extra_use(float %x) {
; CHECK-LABEL: @fake_fneg_nsz_fadd_constant_extra_use(
; CHECK-NEXT:    [[A:%.*]] = fadd float [[X:%.*]], 4.200000e+01
; CHECK-NEXT:    call void @use(float [[A]])
; CHECK-NEXT:    [[R:%.*]] = fneg fast float [[A]]
; CHECK-NEXT:    ret float [[R]]
;
  %a = fadd float %x, 42.0
  call void @use(float %a)
  %r = fsub fast float -0.0, %a
  ret float %r
}

; -(X + C) --> -C - X

define <2 x float> @fneg_nsz_fadd_constant_vec(<2 x float> %x) {
; CHECK-LABEL: @fneg_nsz_fadd_constant_vec(
; CHECK-NEXT:    [[R:%.*]] = fsub reassoc nnan nsz <2 x float> <float -4.200000e+01, float -4.300000e+01>, [[X:%.*]]
; CHECK-NEXT:    ret <2 x float> [[R]]
;
  %a = fadd <2 x float> %x, <float 42.0, float 43.0>
  %r = fneg nsz nnan reassoc <2 x float> %a
  ret <2 x float> %r
}

; -(X + C) --> -C - X

define <2 x float> @fake_fneg_nsz_fadd_constant_vec(<2 x float> %x) {
; CHECK-LABEL: @fake_fneg_nsz_fadd_constant_vec(
; CHECK-NEXT:    [[R:%.*]] = fsub nsz <2 x float> <float -4.200000e+01, float poison>, [[X:%.*]]
; CHECK-NEXT:    ret <2 x float> [[R]]
;
  %a = fadd <2 x float> %x, <float 42.0, float poison>
  %r = fsub nsz <2 x float> <float poison, float -0.0>, %a
  ret <2 x float> %r
}

@g = external global i16, align 1

define float @fneg_nsz_fadd_constant_expr(float %x) {
; CHECK-LABEL: @fneg_nsz_fadd_constant_expr(
; CHECK-NEXT:    [[A:%.*]] = fadd float [[X:%.*]], bitcast (i32 ptrtoint (ptr @g to i32) to float)
; CHECK-NEXT:    [[R:%.*]] = fneg nsz float [[A]]
; CHECK-NEXT:    ret float [[R]]
;
  %a = fadd float %x, bitcast (i32 ptrtoint (ptr @g to i32) to float)
  %r = fneg nsz float %a
  ret float %r
}

define float @fake_fneg_nsz_fadd_constant_expr(float %x) {
; CHECK-LABEL: @fake_fneg_nsz_fadd_constant_expr(
; CHECK-NEXT:    [[A:%.*]] = fadd float [[X:%.*]], bitcast (i32 ptrtoint (ptr @g to i32) to float)
; CHECK-NEXT:    [[R:%.*]] = fneg nsz float [[A]]
; CHECK-NEXT:    ret float [[R]]
;
  %a = fadd float %x, bitcast (i32 ptrtoint (ptr @g to i32) to float)
  %r = fsub nsz float -0.0, %a
  ret float %r
}

define float @select_fneg_true(float %x, float %y, i1 %b) {
; CHECK-LABEL: @select_fneg_true(
; CHECK-NEXT:    [[Y_NEG:%.*]] = fneg float [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = select i1 [[B:%.*]], float [[X:%.*]], float [[Y_NEG]]
; CHECK-NEXT:    ret float [[R]]
;
  %nx = fneg float %x
  %s = select i1 %b, float %nx, float %y
  %r = fneg float %s
  ret float %r
}

define <2 x float> @select_fneg_false(<2 x float> %x, <2 x float> %y, <2 x i1> %b) {
; CHECK-LABEL: @select_fneg_false(
; CHECK-NEXT:    [[X_NEG:%.*]] = fneg nnan nsz <2 x float> [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = select nnan ninf <2 x i1> [[B:%.*]], <2 x float> [[X_NEG]], <2 x float> [[Y:%.*]]
; CHECK-NEXT:    ret <2 x float> [[R]]
;
  %ny = fneg nnan <2 x float> %y
  %s = select ninf <2 x i1> %b, <2 x float> %x, <2 x float> %ny
  %r = fneg nsz nnan <2 x float> %s
  ret <2 x float> %r
}

define float @select_fneg_false_no_nsz(float %x, float %y, i1 %b) {
; CHECK-LABEL: @select_fneg_false_no_nsz(
; CHECK-NEXT:    [[X_NEG:%.*]] = fneg nnan ninf nsz float [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = select nnan ninf i1 [[B:%.*]], float [[X_NEG]], float [[Y:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %ny = fneg float %y
  %s = select i1 %b, float %x, float %ny
  %r = fneg ninf nnan nsz float %s
  ret float %r
}

; The removal of nsz in this pattern is not needed if the select condition can't be poison.

define float @select_fneg_false_nsz_ok(float %x, float %y, i1 noundef %b) {
; CHECK-LABEL: @select_fneg_false_nsz_ok(
; CHECK-NEXT:    [[X_NEG:%.*]] = fneg nnan ninf nsz float [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = select nnan ninf nsz i1 [[B:%.*]], float [[X_NEG]], float [[Y:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %ny = fneg float %y
  %s = select i1 %b, float %x, float %ny
  %r = fneg nsz ninf nnan float %s
  ret float %r
}

define float @select_fneg_false_nsz(float %x, float %y, i1 %b) {
; CHECK-LABEL: @select_fneg_false_nsz(
; CHECK-NEXT:    [[X_NEG:%.*]] = fneg nnan ninf nsz float [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = select nnan ninf nsz i1 [[B:%.*]], float [[X_NEG]], float [[Y:%.*]]
; CHECK-NEXT:    ret float [[R]]
;
  %ny = fneg float %y
  %s = select nsz i1 %b, float %x, float %ny
  %r = fneg ninf nnan nsz float %s
  ret float %r
}

; Special-case for propagating nsz: it's ok when selecting between an operand and its negation.

define float @select_common_op_fneg_true(float %x, i1 %b) {
; CHECK-LABEL: @select_common_op_fneg_true(
; CHECK-NEXT:    [[X_NEG:%.*]] = fneg nnan ninf nsz float [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = select nnan ninf nsz i1 [[B:%.*]], float [[X_NEG]], float [[X]]
; CHECK-NEXT:    ret float [[R]]
;
  %nx = fneg float %x
  %s = select i1 %b, float %x, float %nx
  %r = fneg nsz ninf nnan float %s
  ret float %r
}

define float @select_common_op_fneg_false(float %x, i1 %b) {
; CHECK-LABEL: @select_common_op_fneg_false(
; CHECK-NEXT:    [[X_NEG:%.*]] = fneg nnan ninf nsz float [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = select nnan ninf nsz i1 [[B:%.*]], float [[X_NEG]], float [[X]]
; CHECK-NEXT:    ret float [[R]]
;
  %nx = fneg float %x
  %s = select i1 %b, float %x, float %nx
  %r = fneg nsz ninf nnan float %s
  ret float %r
}

; The transform above allows follow-on folds to convert to fabs.

define float @fabs(float %a) {
; CHECK-LABEL: @fabs(
; CHECK-NEXT:    [[FNEG1:%.*]] = call float @llvm.fabs.f32(float [[A:%.*]])
; CHECK-NEXT:    ret float [[FNEG1]]
;
  %fneg = fneg float %a
  %cmp = fcmp ogt float %a, %fneg
  %sel = select i1 %cmp, float %fneg, float %a
  %fneg1 = fneg nnan ninf nsz float %sel
  ret float %fneg1
}

define float @fnabs(float %a) {
; CHECK-LABEL: @fnabs(
; CHECK-NEXT:    [[TMP1:%.*]] = call float @llvm.fabs.f32(float [[A:%.*]])
; CHECK-NEXT:    [[FNEG1:%.*]] = fneg fast float [[TMP1]]
; CHECK-NEXT:    ret float [[FNEG1]]
;
  %fneg = fneg float %a
  %cmp = fcmp olt float %a, %fneg
  %sel = select i1 %cmp, float %fneg, float %a
  %fneg1 = fneg fast float %sel
  ret float %fneg1
}

define float @fnabs_1(float %a) {
; CHECK-LABEL: @fnabs_1(
; CHECK-NEXT:    [[TMP1:%.*]] = call float @llvm.fabs.f32(float [[A:%.*]])
; CHECK-NEXT:    [[FNEG1:%.*]] = fneg fast float [[TMP1]]
; CHECK-NEXT:    ret float [[FNEG1]]
;
  %fneg = fneg float %a
  %cmp = fcmp ogt float %a, %fneg
  %sel = select i1 %cmp, float %a, float %fneg
  %fneg1 = fneg fast float %sel
  ret float %fneg1
}

; This is not fabs because that could produce a different signbit for a NAN input.
; PR59279

define float @fnabs_2_nsz(float %a) {
; CHECK-LABEL: @fnabs_2_nsz(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt float [[A:%.*]], 0.000000e+00
; CHECK-NEXT:    [[A_NEG:%.*]] = fneg float [[A]]
; CHECK-NEXT:    [[FNEG1:%.*]] = select nsz i1 [[CMP]], float [[A]], float [[A_NEG]]
; CHECK-NEXT:    ret float [[FNEG1]]
;
  %fneg = fneg float %a
  %cmp = fcmp olt float %a, %fneg
  %sel = select nsz i1 %cmp, float %fneg, float %a
  %fneg1 = fneg float %sel
  ret float %fneg1
}

define float @fnabs_2_nsz_nnan(float %a) {
; CHECK-LABEL: @fnabs_2_nsz_nnan(
; CHECK-NEXT:    [[SEL:%.*]] = call nnan nsz float @llvm.fabs.f32(float [[A:%.*]])
; CHECK-NEXT:    [[FNEG1:%.*]] = fneg float [[SEL]]
; CHECK-NEXT:    ret float [[FNEG1]]
;
  %fneg = fneg float %a
  %cmp = fcmp olt float %a, %fneg
  %sel = select nsz nnan i1 %cmp, float %fneg, float %a
  %fneg1 = fneg float %sel
  ret float %fneg1
}

define float @select_fneg_both(float %x, float %y, i1 %b) {
; CHECK-LABEL: @select_fneg_both(
; CHECK-NEXT:    [[S_V:%.*]] = select i1 [[B:%.*]], float [[X:%.*]], float [[Y:%.*]]
; CHECK-NEXT:    ret float [[S_V]]
;
  %nx = fneg float %x
  %ny = fneg float %y
  %s = select i1 %b, float %nx, float %ny
  %r = fneg float %s
  ret float %r
}

define float @select_fneg_use1(float %x, float %y, i1 %b) {
; CHECK-LABEL: @select_fneg_use1(
; CHECK-NEXT:    [[NX:%.*]] = fneg ninf float [[X:%.*]]
; CHECK-NEXT:    call void @use(float [[NX]])
; CHECK-NEXT:    [[Y_NEG:%.*]] = fneg float [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = select fast i1 [[B:%.*]], float [[X]], float [[Y_NEG]]
; CHECK-NEXT:    ret float [[R]]
;
  %nx = fneg ninf float %x
  call void @use(float %nx)
  %s = select fast i1 %b, float %nx, float %y
  %r = fneg float %s
  ret float %r
}

define float @select_fneg_use2(float %x, float %y, i1 %b) {
; CHECK-LABEL: @select_fneg_use2(
; CHECK-NEXT:    call void @use(float [[Y:%.*]])
; CHECK-NEXT:    [[Y_NEG:%.*]] = fneg fast float [[Y]]
; CHECK-NEXT:    [[R:%.*]] = select reassoc nnan ninf arcp contract afn i1 [[B:%.*]], float [[X:%.*]], float [[Y_NEG]]
; CHECK-NEXT:    ret float [[R]]
;
  call void @use(float %y)
  %nx = fneg nsz float %x
  %s = select ninf i1 %b, float %nx, float %y
  %r = fneg fast float %s
  ret float %r
}

; Negative test

define float @select_fneg_use3(float %x, float %y, i1 %b) {
; CHECK-LABEL: @select_fneg_use3(
; CHECK-NEXT:    [[NX:%.*]] = fneg float [[X:%.*]]
; CHECK-NEXT:    [[S:%.*]] = select i1 [[B:%.*]], float [[NX]], float [[Y:%.*]]
; CHECK-NEXT:    call void @use(float [[S]])
; CHECK-NEXT:    [[R:%.*]] = fneg float [[S]]
; CHECK-NEXT:    ret float [[R]]
;
  %nx = fneg float %x
  %s = select i1 %b, float %nx, float %y
  call void @use(float %s)
  %r = fneg float %s
  ret float %r
}

define float @fneg_ldexp(float %x, i32 %n) {
; CHECK-LABEL: @fneg_ldexp(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = call float @llvm.ldexp.f32.i32(float [[TMP1]], i32 [[N:%.*]])
; CHECK-NEXT:    ret float [[NEG]]
;
  %ldexp = call float @llvm.ldexp.f32.i32(float %x, i32 %n)
  %neg = fneg float %ldexp
  ret float %neg
}

define float @fsub_fneg_ldexp(float %x, i32 %n) {
; CHECK-LABEL: @fsub_fneg_ldexp(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = call float @llvm.ldexp.f32.i32(float [[TMP1]], i32 [[N:%.*]])
; CHECK-NEXT:    ret float [[NEG]]
;
  %ldexp = call float @llvm.ldexp.f32.i32(float %x, i32 %n)
  %neg = fsub float -0.0, %ldexp
  ret float %neg
}

define float @fsub_fneg_ldexp_nsz(float %x, i32 %n) {
; CHECK-LABEL: @fsub_fneg_ldexp_nsz(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg nsz float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = call nsz float @llvm.ldexp.f32.i32(float [[TMP1]], i32 [[N:%.*]])
; CHECK-NEXT:    ret float [[NEG]]
;
  %ldexp = call float @llvm.ldexp.f32.i32(float %x, i32 %n)
  %neg = fsub nsz float -0.0, %ldexp
  ret float %neg
}

define float @fsub_fneg_ldexp_p0_nsz(float %x, i32 %n) {
; CHECK-LABEL: @fsub_fneg_ldexp_p0_nsz(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg nsz float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = call nsz float @llvm.ldexp.f32.i32(float [[TMP1]], i32 [[N:%.*]])
; CHECK-NEXT:    ret float [[NEG]]
;
  %ldexp = call float @llvm.ldexp.f32.i32(float %x, i32 %n)
  %neg = fsub nsz float 0.0, %ldexp
  ret float %neg
}

define float @fsub_fneg_ldexp_p0(float %x, i32 %n) {
; CHECK-LABEL: @fsub_fneg_ldexp_p0(
; CHECK-NEXT:    [[LDEXP:%.*]] = call float @llvm.ldexp.f32.i32(float [[X:%.*]], i32 [[N:%.*]])
; CHECK-NEXT:    [[NEG:%.*]] = fsub float 0.000000e+00, [[LDEXP]]
; CHECK-NEXT:    ret float [[NEG]]
;
  %ldexp = call float @llvm.ldexp.f32.i32(float %x, i32 %n)
  %neg = fsub float 0.0, %ldexp
  ret float %neg
}

define <2 x float> @fneg_ldexp_vector(<2 x float> %x, <2 x i32> %n) {
; CHECK-LABEL: @fneg_ldexp_vector(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg <2 x float> [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = call <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float> [[TMP1]], <2 x i32> [[N:%.*]])
; CHECK-NEXT:    ret <2 x float> [[NEG]]
;
  %ldexp = call <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float> %x, <2 x i32> %n)
  %neg = fneg <2 x float> %ldexp
  ret <2 x float> %neg
}

define float @fneg_ldexp_multiuse(float %x, i32 %n, ptr %ptr) {
; CHECK-LABEL: @fneg_ldexp_multiuse(
; CHECK-NEXT:    [[LDEXP:%.*]] = call float @llvm.ldexp.f32.i32(float [[X:%.*]], i32 [[N:%.*]])
; CHECK-NEXT:    store float [[LDEXP]], ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    [[NEG:%.*]] = fneg float [[LDEXP]]
; CHECK-NEXT:    ret float [[NEG]]
;
  %ldexp = call float @llvm.ldexp.f32.i32(float %x, i32 %n)
  store float %ldexp, ptr %ptr
  %neg = fneg float %ldexp
  ret float %neg
}

define float @fneg_ldexp_fmf_ldexp(float %x, i32 %n) {
; CHECK-LABEL: @fneg_ldexp_fmf_ldexp(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg nnan float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = call nnan float @llvm.ldexp.f32.i32(float [[TMP1]], i32 [[N:%.*]])
; CHECK-NEXT:    ret float [[NEG]]
;
  %ldexp = call nnan float @llvm.ldexp.f32.i32(float %x, i32 %n)
  %neg = fneg float %ldexp
  ret float %neg
}

define float @fneg_ldexp_fmf_neg(float %x, i32 %n) {
; CHECK-LABEL: @fneg_ldexp_fmf_neg(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg nnan float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = call nnan float @llvm.ldexp.f32.i32(float [[TMP1]], i32 [[N:%.*]])
; CHECK-NEXT:    ret float [[NEG]]
;
  %ldexp = call float @llvm.ldexp.f32.i32(float %x, i32 %n)
  %neg = fneg nnan float %ldexp
  ret float %neg
}

define float @fneg_ldexp_fmf(float %x, i32 %n) {
; CHECK-LABEL: @fneg_ldexp_fmf(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg nnan ninf float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = call nnan ninf float @llvm.ldexp.f32.i32(float [[TMP1]], i32 [[N:%.*]])
; CHECK-NEXT:    ret float [[NEG]]
;
  %ldexp = call ninf float @llvm.ldexp.f32.i32(float %x, i32 %n)
  %neg = fneg nnan float %ldexp
  ret float %neg
}

define float @fneg_ldexp_contract0(float %x, i32 %n) {
; CHECK-LABEL: @fneg_ldexp_contract0(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg contract float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = call contract float @llvm.ldexp.f32.i32(float [[TMP1]], i32 [[N:%.*]])
; CHECK-NEXT:    ret float [[NEG]]
;
  %ldexp = call contract float @llvm.ldexp.f32.i32(float %x, i32 %n)
  %neg = fneg float %ldexp
  ret float %neg
}

define float @fneg_ldexp_contract1(float %x, i32 %n) {
; CHECK-LABEL: @fneg_ldexp_contract1(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg contract float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = call contract float @llvm.ldexp.f32.i32(float [[TMP1]], i32 [[N:%.*]])
; CHECK-NEXT:    ret float [[NEG]]
;
  %ldexp = call float @llvm.ldexp.f32.i32(float %x, i32 %n)
  %neg = fneg contract float %ldexp
  ret float %neg
}

define float @fneg_ldexp_contract(float %x, i32 %n) {
; CHECK-LABEL: @fneg_ldexp_contract(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg contract float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = call contract float @llvm.ldexp.f32.i32(float [[TMP1]], i32 [[N:%.*]])
; CHECK-NEXT:    ret float [[NEG]]
;
  %ldexp = call contract float @llvm.ldexp.f32.i32(float %x, i32 %n)
  %neg = fneg contract float %ldexp
  ret float %neg
}

define float @fneg_ldexp_metadata(float %x, i32 %n) {
; CHECK-LABEL: @fneg_ldexp_metadata(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = call float @llvm.ldexp.f32.i32(float [[TMP1]], i32 [[N:%.*]]), !arst [[META0:![0-9]+]]
; CHECK-NEXT:    ret float [[NEG]]
;
  %ldexp = call float @llvm.ldexp.f32.i32(float %x, i32 %n), !arst !0
  %neg = fneg float %ldexp
  ret float %neg
}

define float @test_fneg_select_constants(i1 %cond) {
; CHECK-LABEL: @test_fneg_select_constants(
; CHECK-NEXT:    [[NEG:%.*]] = select i1 [[COND:%.*]], float -0.000000e+00, float 0.000000e+00
; CHECK-NEXT:    ret float [[NEG]]
;
  %sel1 = select i1 %cond, float 0.0, float -0.0
  %neg = fneg float %sel1
  ret float %neg
}

define <2 x float> @test_fneg_vec(<2 x i1> %cond) {
; CHECK-LABEL: @test_fneg_vec(
; CHECK-NEXT:    [[NEG:%.*]] = select <2 x i1> [[COND:%.*]], <2 x float> <float -0.000000e+00, float 0.000000e+00>, <2 x float> <float 0.000000e+00, float -0.000000e+00>
; CHECK-NEXT:    ret <2 x float> [[NEG]]
;
  %sel1 = select <2 x i1> %cond, <2 x float> <float 0.0, float -0.0>, <2 x float> <float -0.0, float 0.0>
  %neg = fneg <2 x float> %sel1
  ret <2 x float> %neg
}

define float @test_fneg_select_var_constant(i1 %cond, float %x) {
; CHECK-LABEL: @test_fneg_select_var_constant(
; CHECK-NEXT:    [[X_NEG:%.*]] = fneg float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = select i1 [[COND:%.*]], float [[X_NEG]], float 0.000000e+00
; CHECK-NEXT:    ret float [[NEG]]
;
  %sel1 = select i1 %cond, float %x, float -0.0
  %neg = fneg float %sel1
  ret float %neg
}

; nsz can be preserved.

define float @test_fneg_select_var_constant_fmf1(i1 %cond, float %x) {
; CHECK-LABEL: @test_fneg_select_var_constant_fmf1(
; CHECK-NEXT:    [[X_NEG:%.*]] = fneg float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = select nnan ninf nsz i1 [[COND:%.*]], float [[X_NEG]], float -1.000000e+00
; CHECK-NEXT:    ret float [[NEG]]
;
  %sel1 = select nnan ninf nsz i1 %cond, float %x, float 1.0
  %neg = fneg float %sel1
  ret float %neg
}

define float @test_fneg_select_var_constant_fmf2(i1 %cond, float %x) {
; CHECK-LABEL: @test_fneg_select_var_constant_fmf2(
; CHECK-NEXT:    [[X_NEG:%.*]] = fneg nnan ninf nsz float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = select nnan ninf nsz i1 [[COND:%.*]], float [[X_NEG]], float -1.000000e+00
; CHECK-NEXT:    ret float [[NEG]]
;
  %sel1 = select i1 %cond, float %x, float 1.0
  %neg = fneg nnan ninf nsz float %sel1
  ret float %neg
}

define float @test_fneg_select_constant_var(i1 %cond, float %x) {
; CHECK-LABEL: @test_fneg_select_constant_var(
; CHECK-NEXT:    [[X_NEG:%.*]] = fneg float [[X:%.*]]
; CHECK-NEXT:    [[NEG:%.*]] = select i1 [[COND:%.*]], float -0.000000e+00, float [[X_NEG]]
; CHECK-NEXT:    ret float [[NEG]]
;
  %sel1 = select i1 %cond, float 0.0, float %x
  %neg = fneg float %sel1
  ret float %neg
}

; Make sure nabs is generated.

define float @test_fneg_select_abs(i1 %cond, float %x) {
; CHECK-LABEL: @test_fneg_select_abs(
; CHECK-NEXT:    [[ABSX:%.*]] = call float @llvm.fabs.f32(float [[X:%.*]])
; CHECK-NEXT:    [[ABSX_NEG:%.*]] = fneg float [[ABSX]]
; CHECK-NEXT:    [[NEG:%.*]] = select i1 [[COND:%.*]], float -0.000000e+00, float [[ABSX_NEG]]
; CHECK-NEXT:    ret float [[NEG]]
;
  %absx = call float @llvm.fabs.f32(float %x)
  %sel1 = select i1 %cond, float 0.0, float %absx
  %neg = fneg float %sel1
  ret float %neg
}

define float @test_fneg_fabs_select(i1 %cond, float %x) {
; CHECK-LABEL: @test_fneg_fabs_select(
; CHECK-NEXT:    [[TMP1:%.*]] = call float @llvm.fabs.f32(float [[X:%.*]])
; CHECK-NEXT:    [[DOTNEG:%.*]] = fneg float [[TMP1]]
; CHECK-NEXT:    [[NEG:%.*]] = select i1 [[COND:%.*]], float -0.000000e+00, float [[DOTNEG]]
; CHECK-NEXT:    ret float [[NEG]]
;
  %sel1 = select i1 %cond, float 0.0, float %x
  %abs = call float @llvm.fabs.f32(float %sel1)
  %neg = fneg float %abs
  ret float %neg
}

define float @test_fneg_select_constant_var_multiuse(i1 %cond, float %x) {
; CHECK-LABEL: @test_fneg_select_constant_var_multiuse(
; CHECK-NEXT:    [[SEL1:%.*]] = select i1 [[COND:%.*]], float 0.000000e+00, float [[X:%.*]]
; CHECK-NEXT:    call void @use(float [[SEL1]])
; CHECK-NEXT:    [[NEG:%.*]] = fneg float [[SEL1]]
; CHECK-NEXT:    ret float [[NEG]]
;
  %sel1 = select i1 %cond, float 0.0, float %x
  call void @use(float %sel1)
  %neg = fneg float %sel1
  ret float %neg
}

; Don't break fmax idioms.

define float @test_fneg_select_maxnum(float %x) {
; CHECK-LABEL: @test_fneg_select_maxnum(
; CHECK-NEXT:    [[SEL1:%.*]] = call nsz float @llvm.maxnum.f32(float [[X:%.*]], float 1.000000e+00)
; CHECK-NEXT:    [[NEG:%.*]] = fneg float [[SEL1]]
; CHECK-NEXT:    ret float [[NEG]]
;
  %cmp1 = fcmp ogt float %x, 1.0
  %sel1 = select nnan nsz i1 %cmp1, float %x, float 1.0
  %neg = fneg float %sel1
  ret float %neg
}

; Check that there's no infinite loop.
define <vscale x 2 x double> @test_fneg_select_svec(<vscale x 2 x i1> %cond, <vscale x 2 x double> %b) {
; CHECK-LABEL: @test_fneg_select_svec(
; CHECK-NEXT:    [[TMP2:%.*]] = fneg fast <vscale x 2 x double> [[TMP1:%.*]]
; CHECK-NEXT:    [[TMP3:%.*]] = select fast <vscale x 2 x i1> [[COND:%.*]], <vscale x 2 x double> splat (double -0.000000e+00), <vscale x 2 x double> [[TMP2]]
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP3]]
;
  %1 = select <vscale x 2 x i1> %cond, <vscale x 2 x double> zeroinitializer, <vscale x 2 x double> %b
  %2 = fneg fast <vscale x 2 x double> %1
  ret <vscale x 2 x double> %2
}

define <vscale x 2 x double> @test_fneg_select_svec_2(<vscale x 2 x i1> %cond, <vscale x 2 x double> %a) {
; CHECK-LABEL: @test_fneg_select_svec_2(
; CHECK-NEXT:    [[A_NEG:%.*]] = fneg fast <vscale x 2 x double> [[A:%.*]]
; CHECK-NEXT:    [[TMP1:%.*]] = select fast <vscale x 2 x i1> [[COND:%.*]], <vscale x 2 x double> [[A_NEG]], <vscale x 2 x double> splat (double -0.000000e+00)
; CHECK-NEXT:    ret <vscale x 2 x double> [[TMP1]]
;
  %1 = select <vscale x 2 x i1> %cond, <vscale x 2 x double> %a, <vscale x 2 x double> zeroinitializer
  %2 = fneg fast <vscale x 2 x double> %1
  ret <vscale x 2 x double> %2
}

define <vscale x 2 x double> @test_fneg_select_svec_3(<vscale x 2 x i1> %cond, <vscale x 2 x double> %b) {
; CHECK-LABEL: @test_fneg_select_svec_3(
; CHECK-NEXT:    ret <vscale x 2 x double> splat (double -0.000000e+00)
;
  %1 = select <vscale x 2 x i1> %cond, <vscale x 2 x double> zeroinitializer, <vscale x 2 x double> zeroinitializer
  %2 = fneg fast <vscale x 2 x double> %1
  ret <vscale x 2 x double> %2
}

define float @test_fneg_ninf_mul_with_anyzero(float %a) {
; CHECK-LABEL: @test_fneg_ninf_mul_with_anyzero(
; CHECK-NEXT:    [[F:%.*]] = fmul float [[A:%.*]], -0.000000e+00
; CHECK-NEXT:    ret float [[F]]
;
  %mul = fmul float %a, 0.0
  %f = fneg ninf float %mul
  ret float %f
}

define float @test_fsub_ninf_mul_with_anyzero(float %a) {
; CHECK-LABEL: @test_fsub_ninf_mul_with_anyzero(
; CHECK-NEXT:    [[F2:%.*]] = fmul nsz float [[A:%.*]], -0.000000e+00
; CHECK-NEXT:    ret float [[F2]]
;
  %f1 = fmul nsz float %a, 0.000000
  %f2 = fsub ninf float -0.000000, %f1
  ret float %f2
}

define float @test_fneg_nnan_mul_with_anyzero(float %a) {
; CHECK-LABEL: @test_fneg_nnan_mul_with_anyzero(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg nnan float [[A:%.*]]
; CHECK-NEXT:    [[F2:%.*]] = call nnan float @llvm.copysign.f32(float 0.000000e+00, float [[TMP1]])
; CHECK-NEXT:    ret float [[F2]]
;
  %f1 = fmul ninf float %a, 0.000000
  %f2 = fneg nnan float %f1
  ret float %f2
}

define float @test_fneg_nsz_mul_with_anyzero(float %a) {
; CHECK-LABEL: @test_fneg_nsz_mul_with_anyzero(
; CHECK-NEXT:    [[F2:%.*]] = fmul nsz float [[A:%.*]], -0.000000e+00
; CHECK-NEXT:    ret float [[F2]]
;
  %f1 = fmul ninf float %a, 0.000000
  %f2 = fneg nsz float %f1
  ret float %f2
}

define float @test_fneg_ninf_mul_nnan_with_const(float %a) {
; CHECK-LABEL: @test_fneg_ninf_mul_nnan_with_const(
; CHECK-NEXT:    [[TMP1:%.*]] = fneg float [[A:%.*]]
; CHECK-NEXT:    [[F2:%.*]] = call float @llvm.copysign.f32(float 0.000000e+00, float [[TMP1]])
; CHECK-NEXT:    ret float [[F2]]
;
  %f1 = fmul nnan float %a, 0.000000
  %f2 = fneg ninf float %f1
  ret float %f2
}

define float @test_fneg_ninf_mul_nsz_with_const(float %a) {
; CHECK-LABEL: @test_fneg_ninf_mul_nsz_with_const(
; CHECK-NEXT:    [[F2:%.*]] = fmul nsz float [[A:%.*]], -0.000000e+00
; CHECK-NEXT:    ret float [[F2]]
;
  %f1 = fmul nsz float %a, 0.000000
  %f2 = fneg ninf float %f1
  ret float %f2
}

define <2 x float> @test_fneg_mul_combine_nnan_ninf_with_vec_const(<2 x float> %a) {
; CHECK-LABEL: @test_fneg_mul_combine_nnan_ninf_with_vec_const(
; CHECK-NEXT:    [[F2:%.*]] = fmul nnan <2 x float> [[A:%.*]], <float -0.000000e+00, float 0.000000e+00>
; CHECK-NEXT:    ret <2 x float> [[F2]]
;
  %f1 = fmul nnan <2 x float> %a, <float 0.000000, float -0.000000>
  %f2 = fneg ninf <2 x float> %f1
  ret <2 x float> %f2
}

define <2 x float> @test_fneg_mul_combine_nsz_ninf_with_vec_const(<2 x float> %a) {
; CHECK-LABEL: @test_fneg_mul_combine_nsz_ninf_with_vec_const(
; CHECK-NEXT:    [[F2:%.*]] = fmul nsz <2 x float> [[A:%.*]], <float -0.000000e+00, float 0.000000e+00>
; CHECK-NEXT:    ret <2 x float> [[F2]]
;
  %f1 = fmul nsz <2 x float> %a, <float 0.000000, float -0.000000>
  %f2 = fneg ninf <2 x float> %f1
  ret <2 x float> %f2
}

define <2 x float> @test_fneg_ninf_nnan_mul_with_vec_const(<2 x float> %a) {
; CHECK-LABEL: @test_fneg_ninf_nnan_mul_with_vec_const(
; CHECK-NEXT:    [[F2:%.*]] = fmul nnan <2 x float> [[A:%.*]], <float -0.000000e+00, float 0.000000e+00>
; CHECK-NEXT:    ret <2 x float> [[F2]]
;
  %f1 = fmul <2 x float> %a, <float 0.000000, float -0.000000>
  %f2 = fneg nnan ninf <2 x float> %f1
  ret <2 x float> %f2
}

define <2 x float> @test_fneg_mul_combine_nnan_ninf_with_vec_const2(<2 x float> %a) {
; CHECK-LABEL: @test_fneg_mul_combine_nnan_ninf_with_vec_const2(
; CHECK-NEXT:    [[F2:%.*]] = fmul nnan ninf <2 x float> [[A:%.*]], <float -0.000000e+00, float 0.000000e+00>
; CHECK-NEXT:    ret <2 x float> [[F2]]
;
  %f1 = fmul ninf <2 x float> %a, <float 0.000000, float -0.000000>
  %f2 = fneg nnan ninf <2 x float> %f1
  ret <2 x float> %f2
}

define <2 x float> @test_fneg_mul_combine_reassoc_ninf_with_vec_const1(<2 x float> %a) {
; CHECK-LABEL: @test_fneg_mul_combine_reassoc_ninf_with_vec_const1(
; CHECK-NEXT:    [[F2:%.*]] = fmul <2 x float> [[A:%.*]], <float -0.000000e+00, float 0.000000e+00>
; CHECK-NEXT:    ret <2 x float> [[F2]]
;
  %f1 = fmul reassoc <2 x float> %a, <float 0.000000, float -0.000000>
  %f2 = fneg ninf <2 x float> %f1
  ret <2 x float> %f2
}

define <2 x float> @test_fneg_mul_combine_reassoc_ninf_with_vec_const2(<2 x float> %a) {
; CHECK-LABEL: @test_fneg_mul_combine_reassoc_ninf_with_vec_const2(
; CHECK-NEXT:    [[F2:%.*]] = fmul ninf <2 x float> [[A:%.*]], <float -0.000000e+00, float 0.000000e+00>
; CHECK-NEXT:    ret <2 x float> [[F2]]
;
  %f1 = fmul ninf <2 x float> %a, <float 0.000000, float -0.000000>
  %f2 = fneg reassoc ninf <2 x float> %f1
  ret <2 x float> %f2
}

define <2 x float> @test_fneg_mul_combine_reassoc_ninf_with_vec_const3(<2 x float> %a) {
; CHECK-LABEL: @test_fneg_mul_combine_reassoc_ninf_with_vec_const3(
; CHECK-NEXT:    [[F2:%.*]] = fmul reassoc <2 x float> [[A:%.*]], <float -0.000000e+00, float 0.000000e+00>
; CHECK-NEXT:    ret <2 x float> [[F2]]
;
  %f1 = fmul reassoc <2 x float> %a, <float 0.000000, float -0.000000>
  %f2 = fneg reassoc ninf <2 x float> %f1
  ret <2 x float> %f2
}

define <2 x float> @test_fneg_mul_combine_contract_ninf_with_vec_const1(<2 x float> %a) {
; CHECK-LABEL: @test_fneg_mul_combine_contract_ninf_with_vec_const1(
; CHECK-NEXT:    [[F2:%.*]] = fmul <2 x float> [[A:%.*]], <float -0.000000e+00, float 0.000000e+00>
; CHECK-NEXT:    ret <2 x float> [[F2]]
;
  %f1 = fmul contract <2 x float> %a, <float 0.000000, float -0.000000>
  %f2 = fneg ninf <2 x float> %f1
  ret <2 x float> %f2
}

define <2 x float> @test_fneg_mul_combine_contract_ninf_with_vec_const2(<2 x float> %a) {
; CHECK-LABEL: @test_fneg_mul_combine_contract_ninf_with_vec_const2(
; CHECK-NEXT:    [[F2:%.*]] = fmul ninf <2 x float> [[A:%.*]], <float -0.000000e+00, float 0.000000e+00>
; CHECK-NEXT:    ret <2 x float> [[F2]]
;
  %f1 = fmul ninf <2 x float> %a, <float 0.000000, float -0.000000>
  %f2 = fneg contract ninf <2 x float> %f1
  ret <2 x float> %f2
}

define <2 x float> @test_fneg_mul_combine_contract_ninf_with_vec_const3(<2 x float> %a) {
; CHECK-LABEL: @test_fneg_mul_combine_contract_ninf_with_vec_const3(
; CHECK-NEXT:    [[F2:%.*]] = fmul contract <2 x float> [[A:%.*]], <float -0.000000e+00, float 0.000000e+00>
; CHECK-NEXT:    ret <2 x float> [[F2]]
;
  %f1 = fmul contract <2 x float> %a, <float 0.000000, float -0.000000>
  %f2 = fneg contract ninf <2 x float> %f1
  ret <2 x float> %f2
}

!0 = !{}
