; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=m68k -O0 %s -o - | FileCheck %s

declare zeroext i1 @get1()
declare i8 @get8()
declare i16 @get16()
declare i32 @get32()

define void @test_edge_detection_conditional_branch() {
; CHECK-LABEL: test_edge_detection_conditional_branch:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0: ; %start
; CHECK-NEXT:    suba.l #12, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -16
; CHECK-NEXT:    movem.l %d2, (8,%sp) ; 8-byte Folded Spill
; CHECK-NEXT:    bra .LBB0_1
; CHECK-NEXT:  .LBB0_1: ; %condition_check
; CHECK-NEXT:    ; =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    jsr get1
; CHECK-NEXT:    move.b (7,%sp), %d2
; CHECK-NEXT:    and.b #1, %d2
; CHECK-NEXT:    move.b %d0, %d1
; CHECK-NEXT:    sub.b %d2, %d1
; CHECK-NEXT:    movem.w %d0, (4,%sp)
; CHECK-NEXT:    bne .LBB0_1
; CHECK-NEXT:    bra .LBB0_2
; CHECK-NEXT:  .LBB0_2: ; %do_something
; CHECK-NEXT:    movem.w (4,%sp), %d0
; CHECK-NEXT:    move.b %d0, (7,%sp)
; CHECK-NEXT:    movem.l (8,%sp), %d2 ; 8-byte Folded Reload
; CHECK-NEXT:    adda.l #12, %sp
; CHECK-NEXT:    rts
start:
  %prev_state = alloca [1 x i8], align 1
  br label %condition_check

condition_check:
  %state = call zeroext i1 @get1()
  %local_prev_state = load i8, ptr %prev_state, align 1
  %local_prev_state_trunc = trunc i8 %local_prev_state to i1
  %result = icmp ne i1 %state, %local_prev_state_trunc
  br i1 %result, label %condition_check, label %do_something

do_something:
  %state_ext = zext i1 %state to i8
  store i8 %state_ext, ptr %prev_state, align 1
  ret void
}

define void @test_force_spill_8() {
; CHECK-LABEL: test_force_spill_8:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0: ; %start
; CHECK-NEXT:    suba.l #108, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -112
; CHECK-NEXT:    movem.l %d2-%d7, (84,%sp) ; 28-byte Folded Spill
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    movem.w %d0, (82,%sp)
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    movem.w %d0, (66,%sp)
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    move.b %d0, %d2
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    move.b %d0, %d3
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    move.b %d0, %d4
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    move.b %d0, %d5
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    move.b %d0, %d6
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    move.b %d0, %d7
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    movem.w %d0, (80,%sp)
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    movem.w %d0, (78,%sp)
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    movem.w %d0, (76,%sp)
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    movem.w %d0, (74,%sp)
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    movem.w %d0, (72,%sp)
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    movem.w %d0, (70,%sp)
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    movem.w %d0, (68,%sp)
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    movem.w (66,%sp), %d1
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    move.l %sp, %a0
; CHECK-NEXT:    move.l %d0, (60,%a0)
; CHECK-NEXT:    movem.w (68,%sp), %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    move.l %d0, (56,%a0)
; CHECK-NEXT:    movem.w (70,%sp), %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    move.l %d0, (52,%a0)
; CHECK-NEXT:    movem.w (72,%sp), %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    move.l %d0, (48,%a0)
; CHECK-NEXT:    movem.w (74,%sp), %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    move.l %d0, (44,%a0)
; CHECK-NEXT:    movem.w (76,%sp), %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    move.l %d0, (40,%a0)
; CHECK-NEXT:    movem.w (78,%sp), %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    move.l %d0, (36,%a0)
; CHECK-NEXT:    movem.w (80,%sp), %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    move.l %d0, (32,%a0)
; CHECK-NEXT:    movem.w (82,%sp), %d0
; CHECK-NEXT:    and.l #255, %d7
; CHECK-NEXT:    move.l %d7, (28,%a0)
; CHECK-NEXT:    and.l #255, %d6
; CHECK-NEXT:    move.l %d6, (24,%a0)
; CHECK-NEXT:    and.l #255, %d5
; CHECK-NEXT:    move.l %d5, (20,%a0)
; CHECK-NEXT:    and.l #255, %d4
; CHECK-NEXT:    move.l %d4, (16,%a0)
; CHECK-NEXT:    and.l #255, %d3
; CHECK-NEXT:    move.l %d3, (12,%a0)
; CHECK-NEXT:    and.l #255, %d2
; CHECK-NEXT:    move.l %d2, (8,%a0)
; CHECK-NEXT:    and.l #255, %d1
; CHECK-NEXT:    move.l %d1, (4,%a0)
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    move.l %d0, (%a0)
; CHECK-NEXT:    jsr test_force_spill_8_consumer
; CHECK-NEXT:    movem.l (84,%sp), %d2-%d7 ; 28-byte Folded Reload
; CHECK-NEXT:    adda.l #108, %sp
; CHECK-NEXT:    rts
  start:
    %r0 = call i8 @get8()
    %r1 = call i8 @get8()
    %r2 = call i8 @get8()
    %r3 = call i8 @get8()
    %r4 = call i8 @get8()
    %r5 = call i8 @get8()
    %r6 = call i8 @get8()
    %r7 = call i8 @get8()
    %r8 = call i8 @get8()
    %r9 = call i8 @get8()
    %ra = call i8 @get8()
    %rb = call i8 @get8()
    %rc = call i8 @get8()
    %rd = call i8 @get8()
    %re = call i8 @get8()
    %rf = call i8 @get8()
    call void @test_force_spill_8_consumer(i8 %r0, i8 %r1, i8 %r2, i8 %r3, i8 %r4, i8 %r5, i8 %r6, i8 %r7, i8 %r8, i8 %r9, i8 %ra, i8 %rb, i8 %rc, i8 %rd, i8 %re, i8 %rf)
    ret void
}

declare void @test_force_spill_8_consumer(i8, i8, i8, i8, i8, i8, i8, i8, i8, i8, i8, i8, i8, i8, i8, i8)

define void @test_force_spill_16() {
; CHECK-LABEL: test_force_spill_16:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0: ; %start
; CHECK-NEXT:    suba.l #116, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -120
; CHECK-NEXT:    movem.l %d2-%d7/%a2-%a6, (72,%sp) ; 48-byte Folded Spill
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    movem.w %d0, (70,%sp)
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    movem.w %d0, (66,%sp)
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    movem.w %d0, (64,%sp)
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %d2
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %d3
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %d4
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %d5
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %d6
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %d7
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %a2
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %a3
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %a4
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %a5
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %a6
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    movem.w %d0, (68,%sp)
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    movem.w (64,%sp), %a1
; CHECK-NEXT:    movem.w (66,%sp), %d1
; CHECK-NEXT:    and.l #65535, %d0
; CHECK-NEXT:    move.l %sp, %a0
; CHECK-NEXT:    move.l %d0, (60,%a0)
; CHECK-NEXT:    movem.w (68,%sp), %d0
; CHECK-NEXT:    and.l #65535, %d0
; CHECK-NEXT:    move.l %d0, (56,%a0)
; CHECK-NEXT:    movem.w (70,%sp), %d0
; CHECK-NEXT:    and.l #65535, %a6
; CHECK-NEXT:    move.l %a6, (52,%a0)
; CHECK-NEXT:    and.l #65535, %a5
; CHECK-NEXT:    move.l %a5, (48,%a0)
; CHECK-NEXT:    and.l #65535, %a4
; CHECK-NEXT:    move.l %a4, (44,%a0)
; CHECK-NEXT:    and.l #65535, %a3
; CHECK-NEXT:    move.l %a3, (40,%a0)
; CHECK-NEXT:    and.l #65535, %a2
; CHECK-NEXT:    move.l %a2, (36,%a0)
; CHECK-NEXT:    and.l #65535, %d7
; CHECK-NEXT:    move.l %d7, (32,%a0)
; CHECK-NEXT:    and.l #65535, %d6
; CHECK-NEXT:    move.l %d6, (28,%a0)
; CHECK-NEXT:    and.l #65535, %d5
; CHECK-NEXT:    move.l %d5, (24,%a0)
; CHECK-NEXT:    and.l #65535, %d4
; CHECK-NEXT:    move.l %d4, (20,%a0)
; CHECK-NEXT:    and.l #65535, %d3
; CHECK-NEXT:    move.l %d3, (16,%a0)
; CHECK-NEXT:    and.l #65535, %d2
; CHECK-NEXT:    move.l %d2, (12,%a0)
; CHECK-NEXT:    and.l #65535, %a1
; CHECK-NEXT:    move.l %a1, (8,%a0)
; CHECK-NEXT:    and.l #65535, %d1
; CHECK-NEXT:    move.l %d1, (4,%a0)
; CHECK-NEXT:    and.l #65535, %d0
; CHECK-NEXT:    move.l %d0, (%a0)
; CHECK-NEXT:    jsr test_force_spill_16_consumer
; CHECK-NEXT:    movem.l (72,%sp), %d2-%d7/%a2-%a6 ; 48-byte Folded Reload
; CHECK-NEXT:    adda.l #116, %sp
; CHECK-NEXT:    rts
  start:
    %r0 = call i16 @get16()
    %r1 = call i16 @get16()
    %r2 = call i16 @get16()
    %r3 = call i16 @get16()
    %r4 = call i16 @get16()
    %r5 = call i16 @get16()
    %r6 = call i16 @get16()
    %r7 = call i16 @get16()
    %r8 = call i16 @get16()
    %r9 = call i16 @get16()
    %ra = call i16 @get16()
    %rb = call i16 @get16()
    %rc = call i16 @get16()
    %rd = call i16 @get16()
    %re = call i16 @get16()
    %rf = call i16 @get16()
    call void @test_force_spill_16_consumer(i16 %r0, i16 %r1, i16 %r2, i16 %r3, i16 %r4, i16 %r5, i16 %r6, i16 %r7, i16 %r8, i16 %r9, i16 %ra, i16 %rb, i16 %rc, i16 %rd, i16 %re, i16 %rf)
    ret void
}

declare void @test_force_spill_16_consumer(i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i16, i16)

define void @test_force_spill_32() {
; CHECK-LABEL: test_force_spill_32:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0: ; %start
; CHECK-NEXT:    suba.l #124, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -128
; CHECK-NEXT:    movem.l %d2-%d7/%a2-%a6, (80,%sp) ; 48-byte Folded Spill
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    movem.l %d0, (76,%sp)
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    movem.l %d0, (68,%sp)
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    movem.l %d0, (64,%sp)
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %d2
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %d3
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %d4
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %d5
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %d6
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %d7
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %a2
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %a3
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %a4
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %a5
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %a6
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    movem.l %d0, (72,%sp)
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    movem.l (64,%sp), %a1
; CHECK-NEXT:    movem.l (68,%sp), %d1
; CHECK-NEXT:    move.l %sp, %a0
; CHECK-NEXT:    move.l %d0, (60,%a0)
; CHECK-NEXT:    movem.l (72,%sp), %d0
; CHECK-NEXT:    move.l %d0, (56,%a0)
; CHECK-NEXT:    movem.l (76,%sp), %d0
; CHECK-NEXT:    move.l %a6, (52,%a0)
; CHECK-NEXT:    move.l %a5, (48,%a0)
; CHECK-NEXT:    move.l %a4, (44,%a0)
; CHECK-NEXT:    move.l %a3, (40,%a0)
; CHECK-NEXT:    move.l %a2, (36,%a0)
; CHECK-NEXT:    move.l %d7, (32,%a0)
; CHECK-NEXT:    move.l %d6, (28,%a0)
; CHECK-NEXT:    move.l %d5, (24,%a0)
; CHECK-NEXT:    move.l %d4, (20,%a0)
; CHECK-NEXT:    move.l %d3, (16,%a0)
; CHECK-NEXT:    move.l %d2, (12,%a0)
; CHECK-NEXT:    move.l %a1, (8,%a0)
; CHECK-NEXT:    move.l %d1, (4,%a0)
; CHECK-NEXT:    move.l %d0, (%a0)
; CHECK-NEXT:    jsr test_force_spill_32_consumer
; CHECK-NEXT:    movem.l (80,%sp), %d2-%d7/%a2-%a6 ; 48-byte Folded Reload
; CHECK-NEXT:    adda.l #124, %sp
; CHECK-NEXT:    rts
  start:
    %r0 = call i32 @get32()
    %r1 = call i32 @get32()
    %r2 = call i32 @get32()
    %r3 = call i32 @get32()
    %r4 = call i32 @get32()
    %r5 = call i32 @get32()
    %r6 = call i32 @get32()
    %r7 = call i32 @get32()
    %r8 = call i32 @get32()
    %r9 = call i32 @get32()
    %ra = call i32 @get32()
    %rb = call i32 @get32()
    %rc = call i32 @get32()
    %rd = call i32 @get32()
    %re = call i32 @get32()
    %rf = call i32 @get32()
    call void @test_force_spill_32_consumer(i32 %r0, i32 %r1, i32 %r2, i32 %r3, i32 %r4, i32 %r5, i32 %r6, i32 %r7, i32 %r8, i32 %r9, i32 %ra, i32 %rb, i32 %rc, i32 %rd, i32 %re, i32 %rf)
    ret void
}

declare void @test_force_spill_32_consumer(i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32)

define void @test_force_spill_mixed() {
; CHECK-LABEL: test_force_spill_mixed:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  ; %bb.0: ; %start
; CHECK-NEXT:    suba.l #148, %sp
; CHECK-NEXT:    .cfi_def_cfa_offset -152
; CHECK-NEXT:    movem.l %d2-%d7/%a2-%a6, (104,%sp) ; 48-byte Folded Spill
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    movem.w %d0, (102,%sp)
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    movem.w %d0, (86,%sp)
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    movem.l %d0, (80,%sp)
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %d2
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    move.b %d0, %d3
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %d4
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %d5
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %d6
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    move.b %d0, %d7
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %a2
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %a3
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %a4
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    movem.w %d0, (100,%sp)
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    move.w %d0, %a5
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    move.l %d0, %a6
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    movem.w %d0, (98,%sp)
; CHECK-NEXT:    jsr get8
; CHECK-NEXT:    movem.w %d0, (96,%sp)
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    movem.w %d0, (94,%sp)
; CHECK-NEXT:    jsr get32
; CHECK-NEXT:    movem.l %d0, (88,%sp)
; CHECK-NEXT:    jsr get16
; CHECK-NEXT:    movem.l (80,%sp), %a1
; CHECK-NEXT:    movem.w (86,%sp), %d1
; CHECK-NEXT:    and.l #65535, %d0
; CHECK-NEXT:    move.l %sp, %a0
; CHECK-NEXT:    move.l %d0, (76,%a0)
; CHECK-NEXT:    movem.l (88,%sp), %d0
; CHECK-NEXT:    move.l %d0, (72,%a0)
; CHECK-NEXT:    movem.w (94,%sp), %d0
; CHECK-NEXT:    and.l #65535, %d0
; CHECK-NEXT:    move.l %d0, (68,%a0)
; CHECK-NEXT:    movem.w (96,%sp), %d0
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    move.l %d0, (64,%a0)
; CHECK-NEXT:    movem.w (98,%sp), %d0
; CHECK-NEXT:    and.l #65535, %d0
; CHECK-NEXT:    move.l %d0, (60,%a0)
; CHECK-NEXT:    movem.w (100,%sp), %d0
; CHECK-NEXT:    move.l %a6, (56,%a0)
; CHECK-NEXT:    and.l #65535, %a5
; CHECK-NEXT:    move.l %a5, (52,%a0)
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    move.l %d0, (48,%a0)
; CHECK-NEXT:    movem.w (102,%sp), %d0
; CHECK-NEXT:    and.l #65535, %a4
; CHECK-NEXT:    move.l %a4, (44,%a0)
; CHECK-NEXT:    move.l %a3, (40,%a0)
; CHECK-NEXT:    and.l #65535, %a2
; CHECK-NEXT:    move.l %a2, (36,%a0)
; CHECK-NEXT:    and.l #255, %d7
; CHECK-NEXT:    move.l %d7, (32,%a0)
; CHECK-NEXT:    and.l #65535, %d6
; CHECK-NEXT:    move.l %d6, (28,%a0)
; CHECK-NEXT:    move.l %d5, (24,%a0)
; CHECK-NEXT:    and.l #65535, %d4
; CHECK-NEXT:    move.l %d4, (20,%a0)
; CHECK-NEXT:    and.l #255, %d3
; CHECK-NEXT:    move.l %d3, (16,%a0)
; CHECK-NEXT:    and.l #65535, %d2
; CHECK-NEXT:    move.l %d2, (12,%a0)
; CHECK-NEXT:    move.l %a1, (8,%a0)
; CHECK-NEXT:    and.l #65535, %d1
; CHECK-NEXT:    move.l %d1, (4,%a0)
; CHECK-NEXT:    and.l #255, %d0
; CHECK-NEXT:    move.l %d0, (%a0)
; CHECK-NEXT:    jsr test_force_spill_mixed_consumer
; CHECK-NEXT:    movem.l (104,%sp), %d2-%d7/%a2-%a6 ; 48-byte Folded Reload
; CHECK-NEXT:    adda.l #148, %sp
; CHECK-NEXT:    rts
  start:
    %r0 = call i8 @get8()
    %r1 = call i16 @get16()
    %r2 = call i32 @get32()
    %r3 = call i16 @get16()
    %r4 = call i8 @get8()
    %r5 = call i16 @get16()
    %r6 = call i32 @get32()
    %r7 = call i16 @get16()
    %r8 = call i8 @get8()
    %r9 = call i16 @get16()
    %ra = call i32 @get32()
    %rb = call i16 @get16()
    %rc = call i8 @get8()
    %rd = call i16 @get16()
    %re = call i32 @get32()
    %rf = call i16 @get16()
    %rg = call i8 @get8()
    %rh = call i16 @get16()
    %ri = call i32 @get32()
    %rj = call i16 @get16()
    call void @test_force_spill_mixed_consumer(i8 %r0, i16 %r1, i32 %r2, i16 %r3, i8 %r4, i16 %r5, i32 %r6, i16 %r7, i8 %r8, i16 %r9, i32 %ra, i16 %rb, i8 %rc, i16 %rd, i32 %re, i16 %rf, i8 %rg, i16 %rh, i32 %ri, i16 %rj)
    ret void
}

declare void @test_force_spill_mixed_consumer(i8, i16, i32, i16, i8, i16, i32, i16, i8, i16, i32, i16, i8, i16, i32, i16, i8, i16, i32, i16)
