/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.validation;

import org.apache.wicket.Component;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.FeedbackCollector;
import org.apache.wicket.feedback.IFeedback;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;

public class FormComponentFeedbackIndicator
extends Panel
implements IFeedback {
    public static final String ERROR_CSS_CLASS_KEY = CssUtils.key(FormComponentFeedbackIndicator.class, "error");
    private static final long serialVersionUID = 1L;
    private IFeedbackMessageFilter filter;

    public FormComponentFeedbackIndicator(String id) {
        super(id);
    }

    public void setIndicatorFor(Component component) {
        this.filter = new ComponentFeedbackMessageFilter(component);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(new WebMarkupContainer("indicator"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("class", this.getString(ERROR_CSS_CLASS_KEY));
            }
        });
    }

    @Override
    public void onConfigure() {
        super.onConfigure();
        this.setVisible(new FeedbackCollector(this.getPage()).collect(this.getFeedbackMessageFilter()).size() > 0);
    }

    protected IFeedbackMessageFilter getFeedbackMessageFilter() {
        return this.filter;
    }
}

