/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.configuration;

import java.net.URL;
import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.tools.URLBuilder;

public class FontInfo {
    private String metricsFile;
    private String embedFile;
    private String name;
    private boolean kerning;
    private List fontTriplets;

    public FontInfo(String name, String metricsFile, boolean kerning, List fontTriplets, String embedFile) {
        this.name = name;
        this.metricsFile = metricsFile;
        this.embedFile = embedFile;
        this.kerning = kerning;
        this.fontTriplets = fontTriplets;
    }

    public URL getEmbedFile() throws FOPException {
        if (this.embedFile == null) {
            return null;
        }
        try {
            return URLBuilder.buildURL(Configuration.getFontBaseURL(), this.embedFile);
        }
        catch (Exception e) {
            throw new FOPException("Invalid font file (embedFile): " + this.embedFile + " (" + e.getMessage() + ")");
        }
    }

    public List getFontTriplets() {
        return this.fontTriplets;
    }

    public boolean getKerning() {
        return this.kerning;
    }

    public URL getMetricsFile() throws FOPException {
        try {
            return URLBuilder.buildURL(Configuration.getFontBaseURL(), this.metricsFile);
        }
        catch (Exception e) {
            throw new FOPException("Invalid font metrics file: " + this.metricsFile + " (" + e.getMessage() + ")");
        }
    }
}

