/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class NoneStep<S, S2>
extends FilterStep<S> {
    private P<S2> predicate;

    public NoneStep(Traversal.Admin traversal, P<S2> predicate) {
        super(traversal);
        if (null == predicate) {
            throw new IllegalArgumentException("Input predicate to none step can't be null.");
        }
        this.predicate = predicate;
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        Object item = traverser.get();
        if (item instanceof Iterable || item instanceof Iterator || item != null && item.getClass().isArray()) {
            Iterator iterator = IteratorUtils.asIterator(item);
            while (iterator.hasNext()) {
                if (!this.predicate.test((S2)iterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.predicate);
    }

    @Override
    public NoneStep<S, S2> clone() {
        NoneStep clone = (NoneStep)super.clone();
        clone.predicate = this.predicate.clone();
        return clone;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return EnumSet.of(TraverserRequirement.OBJECT);
    }
}

