/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.commons.Sample;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.Span;

public class NameSample
implements Sample {
    private static final long serialVersionUID = 1655333056555270688L;
    private final String id;
    private final List<String> sentence;
    private final List<Span> names;
    private final String[][] additionalContext;
    private final boolean isClearAdaptiveData;
    public static final String DEFAULT_TYPE = "default";
    private static final Pattern START_TAG_PATTERN = Pattern.compile("<START(:([^:>\\s]*))?>");

    public NameSample(String id, String[] sentence, Span[] names, String[][] additionalContext, boolean clearAdaptiveData) {
        int i;
        this.id = id;
        Objects.requireNonNull(sentence, "sentence must not be null");
        if (names == null) {
            names = new Span[]{};
        }
        this.sentence = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(sentence)));
        List<Span> namesList = Arrays.asList(names);
        Collections.sort(namesList);
        this.names = Collections.unmodifiableList(namesList);
        if (additionalContext != null) {
            this.additionalContext = new String[additionalContext.length][];
            for (i = 0; i < additionalContext.length; ++i) {
                this.additionalContext[i] = new String[additionalContext[i].length];
                System.arraycopy(additionalContext[i], 0, this.additionalContext[i], 0, additionalContext[i].length);
            }
        } else {
            this.additionalContext = null;
        }
        this.isClearAdaptiveData = clearAdaptiveData;
        if (this.names.size() > 1) {
            for (i = 1; i < this.names.size(); ++i) {
                if (this.names.get(i).getStart() >= this.names.get(i - 1).getEnd()) continue;
                throw new RuntimeException(String.format("name spans %s and %s are overlapped in file: %s, sentence: %s", this.names.get(i - 1), this.names.get(i), id, this.sentence.toString()));
            }
        }
    }

    public NameSample(String[] sentence, Span[] names, String[][] additionalContext, boolean clearAdaptiveData) {
        this(null, sentence, names, additionalContext, clearAdaptiveData);
    }

    public NameSample(String[] sentence, Span[] names, boolean clearAdaptiveData) {
        this(sentence, names, null, clearAdaptiveData);
    }

    public String getId() {
        return this.id;
    }

    public String[] getSentence() {
        return this.sentence.toArray(new String[0]);
    }

    public Span[] getNames() {
        return this.names.toArray(new Span[0]);
    }

    public String[][] getAdditionalContext() {
        return this.additionalContext;
    }

    public boolean isClearAdaptiveDataSet() {
        return this.isClearAdaptiveData;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.getSentence()), Arrays.hashCode(this.getNames()), Arrays.hashCode((Object[])this.getAdditionalContext()), this.isClearAdaptiveDataSet());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NameSample) {
            NameSample a = (NameSample)obj;
            return Arrays.equals(this.getSentence(), a.getSentence()) && Arrays.equals(this.getNames(), a.getNames()) && Arrays.equals((Object[])this.getAdditionalContext(), (Object[])a.getAdditionalContext()) && this.isClearAdaptiveDataSet() == a.isClearAdaptiveDataSet();
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isClearAdaptiveDataSet()) {
            result.append("\n");
        }
        for (int tokenIndex = 0; tokenIndex < this.sentence.size(); ++tokenIndex) {
            for (Span name : this.names) {
                if (name.getStart() == tokenIndex) {
                    if (name.getType() == null) {
                        result.append("<START>").append(' ');
                    } else {
                        result.append("<START:").append(name.getType()).append("> ");
                    }
                }
                if (name.getEnd() != tokenIndex) continue;
                result.append("<END>").append(' ');
            }
            result.append(this.sentence.get(tokenIndex)).append(' ');
        }
        if (this.sentence.size() > 1) {
            result.setLength(result.length() - 1);
        }
        for (Span name : this.names) {
            if (name.getEnd() != this.sentence.size()) continue;
            result.append(' ').append("<END>");
        }
        return result.toString();
    }

    private static String errorTokenWithContext(String[] sentence, int index) {
        StringBuilder errorString = new StringBuilder();
        if (index > 1) {
            errorString.append(sentence[index - 2]).append(" ");
        }
        if (index > 0) {
            errorString.append(sentence[index - 1]).append(" ");
        }
        errorString.append("###");
        errorString.append(sentence[index]);
        errorString.append("###").append(" ");
        if (index + 1 < sentence.length) {
            errorString.append(sentence[index + 1]).append(" ");
        }
        if (index + 2 < sentence.length) {
            errorString.append(sentence[index + 2]);
        }
        return errorString.toString();
    }

    public static NameSample parse(String taggedTokens, boolean clearAdaptiveData) throws IOException {
        return NameSample.parse(taggedTokens, DEFAULT_TYPE, clearAdaptiveData);
    }

    public static NameSample parse(String taggedTokens, String defaultType, boolean clearAdaptiveData) throws IOException {
        String[] parts = WhitespaceTokenizer.INSTANCE.tokenize(taggedTokens);
        ArrayList<String> tokenList = new ArrayList<String>(parts.length);
        ArrayList<Span> nameList = new ArrayList<Span>();
        String nameType = defaultType;
        int startIndex = -1;
        int wordIndex = 0;
        boolean catchingName = false;
        for (int pi = 0; pi < parts.length; ++pi) {
            Matcher startMatcher = START_TAG_PATTERN.matcher(parts[pi]);
            if (startMatcher.matches()) {
                if (catchingName) {
                    throw new IOException("Found unexpected annotation while handling a name sequence: " + NameSample.errorTokenWithContext(parts, pi));
                }
                catchingName = true;
                startIndex = wordIndex;
                String nameTypeFromSample = startMatcher.group(2);
                if (nameTypeFromSample == null) continue;
                if (nameTypeFromSample.length() == 0) {
                    throw new IOException("Missing a name type: " + NameSample.errorTokenWithContext(parts, pi));
                }
                nameType = nameTypeFromSample;
                continue;
            }
            if (parts[pi].equals("<END>")) {
                if (!catchingName) {
                    throw new IOException("Found unexpected annotation: " + NameSample.errorTokenWithContext(parts, pi));
                }
                catchingName = false;
                nameList.add(new Span(startIndex, wordIndex, nameType));
                continue;
            }
            tokenList.add(parts[pi]);
            ++wordIndex;
        }
        String[] sentence = tokenList.toArray(new String[0]);
        Span[] names = nameList.toArray(new Span[0]);
        return new NameSample(sentence, names, clearAdaptiveData);
    }
}

