/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.throttle;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.xml.XmlPrimitiveAssertion;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.wso2.throttle.CallerConfiguration;
import org.wso2.throttle.ConcurrentAccessController;
import org.wso2.throttle.Throttle;
import org.wso2.throttle.ThrottleConfiguration;
import org.wso2.throttle.ThrottleConstants;
import org.wso2.throttle.ThrottleException;
import org.wso2.throttle.ThrottlePolicyProcessor;
import org.wso2.throttle.factory.CallerConfigurationFactory;
import org.wso2.throttle.factory.ThrottleConfigurationFactory;
import org.wso2.throttle.factory.ThrottleContextFactory;

public class ThrottleFactory {
    private static Log log = LogFactory.getLog((Class)ThrottleFactory.class);

    private ThrottleFactory() {
    }

    public static Throttle createModuleThrottle(Policy policy) throws ThrottleException {
        return ThrottleFactory.createThrottle(policy, ThrottleConstants.MODULE_THROTTLE_ASSERTION_QNAME);
    }

    public static Throttle createServiceThrottle(Policy policy) throws ThrottleException {
        return ThrottleFactory.createThrottle(policy, ThrottleConstants.SERVICE_THROTTLE_ASSERTION_QNAME);
    }

    public static Throttle createOperationThrottle(Policy policy) throws ThrottleException {
        return ThrottleFactory.createThrottle(policy, ThrottleConstants.OPERATION_THROTTLE_ASSERTION_QNAME);
    }

    public static Throttle createMediatorThrottle(Policy policy) throws ThrottleException {
        return ThrottleFactory.createThrottle(policy, ThrottleConstants.MEDIATOR_THROTTLE_ASSERTION_QNAME);
    }

    public static Throttle createMediatorThrottle(OMElement elem) throws ThrottleException {
        return ThrottleFactory.createThrottle(elem, ThrottleConstants.MEDIATOR_THROTTLE_ASSERTION_QNAME);
    }

    private static Throttle createThrottle(OMElement elem, QName forceRoot) throws ThrottleException {
        Throttle throttle = new Throttle();
        ThrottleConfiguration throttleConfiguration = null;
        if (elem == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Policy cannot be found");
            }
            return null;
        }
        Iterator throttleAssertionIterator = elem.getChildElements();
        while (throttleAssertionIterator.hasNext()) {
            OMElement throttleAssertion = (OMElement)throttleAssertionIterator.next();
            CallerConfiguration callerConfiguration = null;
            boolean isIPRangeFound = false;
            boolean isExactlyOneFound = false;
            if (throttleAssertion.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "MaximumConcurrentAccess", "throttle")) != null) {
                String maxConcAccess = throttleAssertion.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "MaximumConcurrentAccess", "throttle")).getText();
                if (maxConcAccess == null) continue;
                int maximumConcAccessCount = 0;
                try {
                    maximumConcAccessCount = Integer.parseInt(maxConcAccess.trim());
                }
                catch (NumberFormatException ignored) {
                    log.error((Object)"Error occurred - Invalid number for maximum concurrent access ", (Throwable)ignored);
                }
                if (maximumConcAccessCount <= 0) continue;
                throttle.setConcurrentAccessController(new ConcurrentAccessController(maximumConcAccessCount));
                continue;
            }
            Iterator wspAllIterator = throttleAssertion.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "All", "wsp"));
            while (wspAllIterator.hasNext()) {
                OMElement wspAll = (OMElement)wspAllIterator.next();
                boolean isFoundMaxCount = false;
                boolean isFoundUnitTime = false;
                OMElement idElem = wspAll.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "ID", "throttle"));
                String type = idElem.getAttributeValue(new QName("http://www.wso2.org/products/wso2commons/throttle", "type", "throttle"));
                if (type.equals("IP")) {
                    throttleConfiguration = throttle.getThrottleConfiguration("key_of_ip_based_throttle");
                    if (throttleConfiguration == null) {
                        throttleConfiguration = ThrottleConfigurationFactory.createThrottleConfiguration(0);
                        throttle.addThrottleContext("key_of_ip_based_throttle", ThrottleContextFactory.createThrottleContext(0, throttleConfiguration));
                        throttle.addThrottleConfiguration("key_of_ip_based_throttle", throttleConfiguration);
                    }
                    callerConfiguration = CallerConfigurationFactory.createCallerConfiguration(0);
                } else if (type.equals("DOMAIN")) {
                    throttleConfiguration = throttle.getThrottleConfiguration("key_of_domain_based_throttle");
                    if (throttleConfiguration == null) {
                        throttleConfiguration = ThrottleConfigurationFactory.createThrottleConfiguration(1);
                        throttle.addThrottleContext("key_of_domain_based_throttle", ThrottleContextFactory.createThrottleContext(1, throttleConfiguration));
                        throttle.addThrottleConfiguration("key_of_domain_based_throttle", throttleConfiguration);
                        callerConfiguration = CallerConfigurationFactory.createCallerConfiguration(1);
                    }
                } else {
                    ThrottleFactory.handleException("Unsupported throttle type : " + type);
                }
                if (callerConfiguration != null) {
                    String idValue = idElem.getText();
                    if (idElem.getLocalName() == null || idValue == null) {
                        ThrottleFactory.handleException("Either Value or Name of the policy cannot be null");
                    } else if (idElem.getLocalName().equals("ID")) {
                        if (!idValue.equals("")) {
                            isIPRangeFound = true;
                            callerConfiguration.setID(idValue);
                        } else {
                            ThrottleFactory.handleException("Value of ID cannot find - invalid configuration");
                        }
                    } else {
                        ThrottleFactory.handleException("Undefined pocilcy property for throttle - Expect ID  ");
                    }
                }
                OMElement exactlyOneElem = wspAll.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "ExactlyOne", "wsp"));
                OMElement eoAll = exactlyOneElem.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "All", "wsp"));
                OMElement maxCountElem = eoAll.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "MaximumCount", "throttle"));
                OMElement unitTimeElem = eoAll.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "UnitTime", "throttle"));
                OMElement prohibitedTimeElem = eoAll.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "ProhibitTimePeriod", "throttle"));
                String prohibitedTimeOptional = prohibitedTimeElem.getAttributeValue(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Optional", "wsp"));
                if (maxCountElem != null && maxCountElem.getText() != null && !maxCountElem.getText().equals("")) {
                    isFoundMaxCount = true;
                    callerConfiguration.setMaximumRequestPerUnitTime(Integer.parseInt(maxCountElem.getText()));
                    try {
                        callerConfiguration.setMaximumRequestPerUnitTime(Integer.parseInt(maxCountElem.getText().trim()));
                    }
                    catch (NumberFormatException ignored) {
                        log.error((Object)"Error occurred - Invalid number for maximum request number ", (Throwable)ignored);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Access will be fully allowed");
                        }
                        callerConfiguration.setAccessState(2);
                    }
                }
                if (unitTimeElem != null && unitTimeElem.getText() != null && !unitTimeElem.getText().equals("")) {
                    long timeInMiliSec = 0L;
                    try {
                        timeInMiliSec = Long.parseLong(unitTimeElem.getText().trim());
                    }
                    catch (NumberFormatException ignored) {
                        log.error((Object)"Error occurred - Invalid number for unit time", (Throwable)ignored);
                    }
                    if (timeInMiliSec == 0L) {
                        ThrottleFactory.handleException("Unit Time cannot find - invalid throttle policy configuration");
                    }
                    isFoundUnitTime = true;
                    callerConfiguration.setUnitTime(timeInMiliSec);
                }
                if (prohibitedTimeElem != null && prohibitedTimeElem.getText() != null && !prohibitedTimeElem.getText().equals("")) {
                    try {
                        callerConfiguration.setProhibitTimePeriod(Long.parseLong(prohibitedTimeElem.getText().trim()));
                    }
                    catch (NumberFormatException ignored) {
                        log.error((Object)"Error occurred - Invalid number for prohibit time ", (Throwable)ignored);
                    }
                }
                if (isFoundUnitTime && isFoundMaxCount) {
                    isExactlyOneFound = true;
                } else {
                    ThrottleFactory.handleException("Maximum Count and UnitTime are Mandatory in Throttle Policy ");
                }
                OMElement isAllowElem = exactlyOneElem.getFirstChildWithName(new QName("http://www.wso2.org/products/wso2commons/throttle", "IsAllow", "throttle"));
                if (isAllowElem != null && isAllowElem.getText() != null && !isAllowElem.getText().equals("")) {
                    if (isAllowElem.getText().equals(Boolean.toString(true))) {
                        isExactlyOneFound = true;
                        callerConfiguration.setAccessState(2);
                    } else if (isAllowElem.getText().equals(Boolean.toString(false))) {
                        isExactlyOneFound = true;
                        callerConfiguration.setAccessState(1);
                    } else {
                        ThrottleFactory.handleException("Value for isAllow  component is invalid");
                    }
                }
                if (isIPRangeFound && isExactlyOneFound) {
                    throttleConfiguration.addCallerConfiguration(callerConfiguration);
                    continue;
                }
                ThrottleFactory.handleException("ID and one of Valid Control policy component are Mandatory in Throttle Policy");
            }
        }
        return throttle;
    }

    private static Throttle createThrottle(Policy policy, QName forceRoot) throws ThrottleException {
        if (policy == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Policy cannot be found");
            }
            return null;
        }
        if (forceRoot == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Given root assertion QName is null");
            }
            return null;
        }
        Iterator iterator = policy.getAlternatives();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof List)) continue;
            List list = (List)object;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Object assertObj = it.next();
                if (!(assertObj instanceof XmlPrimitiveAssertion)) continue;
                XmlPrimitiveAssertion primitiveAssertion = (XmlPrimitiveAssertion)assertObj;
                QName qName = primitiveAssertion.getName();
                if (qName == null) {
                    ThrottleFactory.handleException("Invalid Throttle Policy - QName of the assertion cannot be null.");
                }
                Policy throttlePolicy = PolicyEngine.getPolicy((Object)primitiveAssertion.getValue());
                if (ThrottleConstants.THROTTLE_ASSERTION_QNAME.equals(qName)) {
                    return ThrottlePolicyProcessor.processPolicy(throttlePolicy);
                }
                if (forceRoot.equals(qName)) {
                    return ThrottleFactory.buildThrottle(throttlePolicy);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("There is no throttle policy for given QName : " + forceRoot));
            }
        }
        return null;
    }

    private static Throttle buildThrottle(Policy throtlePolicy) throws ThrottleException {
        Throttle throttle = new Throttle();
        ThrottleConfiguration configuration = null;
        List list = throtlePolicy.getPolicyComponents();
        if (list == null || list != null && list.isEmpty()) {
            ThrottleFactory.handleException("Empty the policy components as ThrottleAssertionBuilder's children");
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof Policy) {
                CallerConfiguration callerConfiguration = null;
                Policy policy = null;
                List assertList = ((Policy)object).getAssertions();
                if (assertList != null) {
                    Iterator assertIterator = assertList.iterator();
                    while (assertIterator.hasNext()) {
                        Object ca = assertIterator.next();
                        if (ca instanceof XmlPrimitiveAssertion) {
                            XmlPrimitiveAssertion id = (XmlPrimitiveAssertion)ca;
                            configuration = ThrottleFactory.createThrottleConfiguration(id, throttle);
                            if (configuration == null) {
                                ThrottleFactory.handleException("Invalid throttle - Throttle configuration cannot be created from given policy");
                            }
                            if (configuration.getType() == 0) {
                                callerConfiguration = CallerConfigurationFactory.createCallerConfiguration(0);
                            } else if (configuration.getType() == 1) {
                                callerConfiguration = CallerConfigurationFactory.createCallerConfiguration(1);
                            } else {
                                ThrottleFactory.handleException("Invalid throttle type - Only support IP and DOMAIN as types ");
                            }
                            if (callerConfiguration == null) continue;
                            Element element = id.getValue();
                            String name = element.getLocalName();
                            String value = element.getTextContent();
                            if (name == null || value == null) {
                                ThrottleFactory.handleException("Either Value or Name of the policy cannot be null");
                                continue;
                            }
                            if (name.equals("ID")) {
                                if (!value.equals("")) {
                                    callerConfiguration.setID(value);
                                    continue;
                                }
                                ThrottleFactory.handleException("Value of ID cannot find - invalid configuration");
                                continue;
                            }
                            ThrottleFactory.handleException("Undefined policy property for throttle - Expect ID  ");
                            continue;
                        }
                        if (!(ca instanceof Policy)) continue;
                        policy = (Policy)ca;
                    }
                }
                if (callerConfiguration != null) {
                    if (policy == null) continue;
                    ThrottleFactory.fillCallerConfiguration(policy, callerConfiguration);
                    configuration.addCallerConfiguration(callerConfiguration);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Couldn't find a callerConfiguration for a throttle configuration for an one caller  ");
                continue;
            }
            if (!(object instanceof XmlPrimitiveAssertion)) continue;
            XmlPrimitiveAssertion xmlPrimitiveAssertion = (XmlPrimitiveAssertion)object;
            Element element = xmlPrimitiveAssertion.getValue();
            String name = element.getLocalName();
            String value = element.getTextContent();
            if (name == null || value == null) {
                ThrottleFactory.handleException("Either value or name of the policy cannot be null");
                continue;
            }
            if (name.equals("MaximumConcurrentAccess")) {
                int intValue = 0;
                try {
                    intValue = Integer.parseInt(value.trim());
                }
                catch (NumberFormatException ignored) {
                    log.error((Object)"Error occurred - Invalid number for maximum concurrent access ", (Throwable)ignored);
                }
                if (intValue <= 0) continue;
                throttle.setConcurrentAccessController(new ConcurrentAccessController(intValue));
                continue;
            }
            ThrottleFactory.handleException("Invalid throttle policy configuration : unexpected policy element with name " + name);
        }
        return throttle;
    }

    private static ThrottleConfiguration createThrottleConfiguration(XmlPrimitiveAssertion id, Throttle throttle) throws ThrottleException {
        Element element = id.getValue();
        ThrottleConfiguration configuration = null;
        Attr typeAttr = element.getAttributeNodeNS("http://www.wso2.org/products/wso2commons/throttle", "type");
        String type = typeAttr.getValue();
        if (type == null) {
            ThrottleFactory.handleException("Type of Throttle in the policy cannot be null");
        }
        if ("IP".equals(type)) {
            configuration = throttle.getThrottleConfiguration("key_of_ip_based_throttle");
            if (configuration == null) {
                configuration = ThrottleConfigurationFactory.createThrottleConfiguration(0);
                throttle.addThrottleContext("key_of_ip_based_throttle", ThrottleContextFactory.createThrottleContext(0, configuration));
                throttle.addThrottleConfiguration("key_of_ip_based_throttle", configuration);
            }
        } else if ("DOMAIN".equals(type)) {
            configuration = throttle.getThrottleConfiguration("key_of_domain_based_throttle");
            if (configuration == null) {
                configuration = ThrottleConfigurationFactory.createThrottleConfiguration(1);
                throttle.addThrottleContext("key_of_domain_based_throttle", ThrottleContextFactory.createThrottleContext(1, configuration));
                throttle.addThrottleConfiguration("key_of_domain_based_throttle", configuration);
            }
        } else {
            ThrottleFactory.handleException("Unsupported throttle type : " + type);
        }
        return configuration;
    }

    private static void fillCallerConfiguration(Policy policy, CallerConfiguration callerConfiguration) throws ThrottleException {
        List list = policy.getPolicyComponents();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            XmlPrimitiveAssertion primitiveAssertion = (XmlPrimitiveAssertion)object;
            Element element = primitiveAssertion.getValue();
            String name = element.getLocalName();
            if (name.equals("Allow")) {
                callerConfiguration.setAccessState(2);
                continue;
            }
            if (name.equals("Deny")) {
                callerConfiguration.setAccessState(1);
                continue;
            }
            if (name.equals("Control")) {
                Policy controlPolicy;
                callerConfiguration.setAccessState(0);
                Element controlElement = primitiveAssertion.getValue();
                if (controlElement == null) {
                    ThrottleFactory.handleException("Invalid throttle configuration - Control assertion cannot be empty");
                }
                if ((controlPolicy = PolicyEngine.getPolicy((Object)controlElement)) != null) {
                    ThrottleFactory.fillControlConfiguration(controlPolicy, callerConfiguration);
                    continue;
                }
                ThrottleFactory.handleException("Invalid throttle configuration - Cannot create a policy object(Control Assertion ) form given policy file ");
                continue;
            }
            ThrottleFactory.handleException("Invalid Throttle Policy configuration");
        }
    }

    private static void fillControlConfiguration(Policy policy, CallerConfiguration callerConfiguration) throws ThrottleException {
        boolean isFoundMaxCount = false;
        boolean isFoundUnitTime = false;
        List list = policy.getPolicyComponents();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof Policy) {
                List controlList = ((Policy)obj).getPolicyComponents();
                Iterator controlIterator = controlList.iterator();
                while (controlIterator.hasNext()) {
                    Object object = controlIterator.next();
                    if (!(object instanceof XmlPrimitiveAssertion)) continue;
                    XmlPrimitiveAssertion primitiveAssertion = (XmlPrimitiveAssertion)object;
                    Element element = primitiveAssertion.getValue();
                    String name = element.getLocalName();
                    String value = element.getTextContent();
                    if (name == null || value == null) {
                        ThrottleFactory.handleException("Either Value or Name of the policy cannot be null");
                    }
                    if (!value.equals("")) {
                        if (name.equals("MaximumCount")) {
                            isFoundMaxCount = true;
                            try {
                                callerConfiguration.setMaximumRequestPerUnitTime(Integer.parseInt(value.trim()));
                            }
                            catch (NumberFormatException ignored) {
                                log.error((Object)"Error occurred - Invalid number for maximum request number ", (Throwable)ignored);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Access will be fully allowed");
                                }
                                callerConfiguration.setAccessState(2);
                            }
                            continue;
                        }
                        if (name.equals("UnitTime")) {
                            long timeInMilliSec = 0L;
                            try {
                                timeInMilliSec = Long.parseLong(value.trim());
                            }
                            catch (NumberFormatException ignored) {
                                log.error((Object)"Error occurred - Invalid number for unit time", (Throwable)ignored);
                            }
                            if (timeInMilliSec == 0L) {
                                ThrottleFactory.handleException("Unit Time cannot find - invalid throttle policy configuration");
                            }
                            isFoundUnitTime = true;
                            callerConfiguration.setUnitTime(timeInMilliSec);
                            continue;
                        }
                        if (name.equals("ProhibitTimePeriod")) {
                            try {
                                callerConfiguration.setProhibitTimePeriod(Long.parseLong(value.trim()));
                            }
                            catch (NumberFormatException ignored) {
                                log.error((Object)"Error occurred - Invalid number for prohibit time ", (Throwable)ignored);
                            }
                            continue;
                        }
                        ThrottleFactory.handleException("Undefined Policy property for Throttle Policy");
                        continue;
                    }
                    if (name.equals("ProhibitTimePeriod")) continue;
                    ThrottleFactory.handleException("The policy which have  defined as optional should have value ");
                }
                continue;
            }
            ThrottleFactory.handleException("Invalid policy - Control Assertion must contain a wsp:Policy as child ");
        }
        if (!isFoundUnitTime && !isFoundMaxCount) {
            ThrottleFactory.handleException("Maximum Count and UnitTime are Mandatory in Throttle Policy ");
        }
    }

    private static void handleException(String message) throws ThrottleException {
        String msg = "Error was occurred during throttle policy processing :  " + message;
        log.error((Object)msg);
        throw new ThrottleException(msg);
    }
}

