/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.fix;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.base.AbstractTransportListener;
import org.apache.synapse.transport.fix.FIXApplicationFactory;
import org.apache.synapse.transport.fix.FIXSessionFactory;

public class FIXTransportListener
extends AbstractTransportListener {
    private FIXSessionFactory fixSessionFactory;

    public void init(ConfigurationContext cfgCtx, TransportInDescription trpInDesc) throws AxisFault {
        super.init(cfgCtx, trpInDesc);
        this.fixSessionFactory = FIXSessionFactory.getInstance(new FIXApplicationFactory(cfgCtx));
        this.fixSessionFactory.setListenerThreadPool(this.workerPool);
        this.log.info((Object)"FIX transport listener initialized...");
    }

    public void startListeningForService(AxisService service) {
        try {
            boolean acceptorCreated = this.fixSessionFactory.createFIXAcceptor(service);
            boolean initiatorCreated = this.fixSessionFactory.createFIXInitiator(service);
            if (!acceptorCreated && !initiatorCreated) {
                this.log.warn((Object)("No acceptor or initiator has been configured for the service " + service.getName() + " - Disabling the FIX transport for this service"));
                this.disableTransportForService(service);
            }
        }
        catch (AxisFault axisFault) {
            this.disableTransportForService(service);
        }
    }

    protected void stopListeningForService(AxisService service) {
        this.fixSessionFactory.disposeFIXAcceptor(service);
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        String[] serviceEPRStrings;
        if (serviceName.indexOf(46) != -1) {
            serviceName = serviceName.substring(0, serviceName.indexOf(46));
        }
        if ((serviceEPRStrings = this.fixSessionFactory.getServiceEPRs(serviceName, ip)) != null) {
            EndpointReference[] serviceEPRs = new EndpointReference[serviceEPRStrings.length];
            for (int i = 0; i < serviceEPRStrings.length; ++i) {
                serviceEPRs[i] = new EndpointReference(serviceEPRStrings[i]);
            }
            return serviceEPRs;
        }
        throw new AxisFault("Unable to get EPRs for the service " + serviceName);
    }
}

