/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.config.xml;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.SynapseException;
import org.apache.synapse.libraries.imports.SynapseImport;

public class SynapseImportSerializer {
    private static final Log log = LogFactory.getLog(SynapseImportSerializer.class);
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public OMElement serializeImport(SynapseImport synapseImport) {
        OMElement importElem = fac.createOMElement("import", synNS);
        if (synapseImport.getLibName() != null) {
            importElem.addAttribute(fac.createOMAttribute("name", nullNS, synapseImport.getLibName()));
        } else {
            this.handleException("Invalid Synapse Import. Target Library name is required");
        }
        if (synapseImport.getLibPackage() != null) {
            importElem.addAttribute(fac.createOMAttribute("package", nullNS, synapseImport.getLibPackage()));
        } else {
            this.handleException("Invalid Synapse Import. Target Library package is required");
        }
        return importElem;
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }
}

