/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.tiles;

import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.util.WildcardUtil;
import com.opensymphony.xwork2.util.finder.ResourceFinder;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.tiles.StrutsApplicationResource;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.servlet.ServletApplicationContext;

public class StrutsWildcardServletApplicationContext
extends ServletApplicationContext {
    private static final Logger LOG = LogManager.getLogger(StrutsWildcardServletApplicationContext.class);
    private final ResourceFinder finder;

    public StrutsWildcardServletApplicationContext(ServletContext context) {
        super(context);
        HashSet<URL> urls = new HashSet<URL>();
        for (Object path : context.getResourcePaths("/")) {
            try {
                String realPath = context.getRealPath(String.valueOf(path));
                if (realPath == null) continue;
                URL url = new File(realPath).toURI().toURL();
                urls.add(url);
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("");
            while (resources.hasMoreElements()) {
                urls.add(resources.nextElement());
            }
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
        this.finder = new ResourceFinder(urls.toArray(new URL[0]));
    }

    @Override
    public Collection<ApplicationResource> getResources(String path) {
        HashSet<ApplicationResource> resources = new HashSet<ApplicationResource>();
        if (path.startsWith("/")) {
            LOG.trace("Using ServletContext to load resource {}", (Object)path);
            ApplicationResource resource = this.getResource(path);
            if (resource != null) {
                resources.add(resource);
            }
        }
        try {
            resources.addAll(this.findResources(path));
        }
        catch (IOException e) {
            LOG.error("Cannot find resources for [{}]", (Object)path, (Object)e);
        }
        return resources;
    }

    @Override
    public ApplicationResource getResource(ApplicationResource base, Locale locale) {
        String localePath = base.getLocalePath(locale);
        File localFile = new File(localePath);
        if (localFile.exists()) {
            try {
                return new StrutsApplicationResource(localFile.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOG.warn("Cannot access [{}]", (Object)localePath, (Object)e);
                return null;
            }
        }
        return null;
    }

    protected Set<ApplicationResource> findResources(String path) throws IOException {
        HashSet<ApplicationResource> resources = new HashSet<ApplicationResource>();
        LOG.trace("Using ResourceFinder to find matches for {}", (Object)path);
        Pattern pattern = WildcardUtil.compileWildcardPattern((String)path);
        Map matches = this.finder.getResourcesMap("");
        for (Map.Entry entry : matches.entrySet()) {
            if (!pattern.matcher((CharSequence)entry.getKey()).matches()) continue;
            resources.add(new StrutsApplicationResource((URL)entry.getValue()));
        }
        LOG.trace("Found resources {} for path {}", resources, (Object)path);
        return resources;
    }
}

