/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi.host;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.util.finder.ClassLoaderInterfaceDelegate;
import com.opensymphony.xwork2.util.finder.ResourceFinder;
import com.opensymphony.xwork2.util.fs.DefaultFileManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.shell.ShellService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.StrutsException;
import org.apache.struts2.osgi.OsgiUtil;
import org.apache.struts2.osgi.host.OsgiHost;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class BaseOsgiHost
implements OsgiHost {
    private static final Logger LOG = LogManager.getLogger(BaseOsgiHost.class);
    protected static final Pattern VERSION_PATTERN;
    protected static final String SCANNING_PACKAGE_INCLUDES = "scanning.package.includes";
    protected static final String JRE_JAVA_SPECIFICATION_VERSION = "${jre-${java.specification.version}}";
    protected static final String DETECT_JAVA_VERSION = "${detect.java.version}";
    @Deprecated
    protected static final Pattern versionPattern;
    protected ServletContext servletContext;

    @Override
    public abstract void init(ServletContext var1);

    @Override
    public abstract void destroy() throws Exception;

    @Override
    public abstract Map<String, Bundle> getBundles();

    @Override
    public abstract Map<String, Bundle> getActiveBundles();

    @Override
    public abstract BundleContext getBundleContext();

    protected abstract void addSpringOSGiSupport();

    protected String getServletContextParam(String paramName, String defaultValue) {
        if (this.servletContext == null) {
            throw new IllegalStateException("OSGi Host servlet context is null!");
        }
        return StringUtils.defaultString((String)this.servletContext.getInitParameter(paramName), (String)defaultValue);
    }

    protected void addAutoStartBundles(Properties configProps) {
        ArrayList<String> bundleJarsLevel1 = new ArrayList<String>();
        bundleJarsLevel1.add(this.getJarUrl(ShellService.class));
        bundleJarsLevel1.add(this.getJarUrl(ServiceTracker.class));
        configProps.put("felix.auto.start.1", StringUtils.join(bundleJarsLevel1, (String)" "));
        Map<String, String> runLevels = this.getRunLevelDirs("bundles");
        if (runLevels.isEmpty()) {
            List<String> bundles = this.getBundlesInDir("bundles");
            if (!bundles.isEmpty()) {
                configProps.put("felix.auto.start.2", StringUtils.join(bundles, (String)" "));
            }
        } else {
            runLevels.entrySet().forEach(runLevel -> {
                String runLevelKey = (String)runLevel.getKey();
                if ("1".endsWith(runLevelKey)) {
                    throw new StrutsException("Run level dirs must be greater than 1. Run level 1 is reserved for the Felix bundles");
                }
                List<String> bundles = this.getBundlesInDir((String)runLevel.getValue());
                configProps.put("felix.auto.start." + runLevelKey, StringUtils.join(bundles, (String)" "));
            });
        }
    }

    protected Map<String, String> getRunLevelDirs(String dir) {
        HashMap<String, String> dirs = new HashMap<String, String>();
        try {
            ResourceFinder finder = new ResourceFinder(new URL[0]);
            URL url = finder.find("bundles");
            if (url != null) {
                if ("file".equals(url.getProtocol())) {
                    File bundlesDir = new File(url.toURI());
                    String[] runLevelDirs = bundlesDir.list((file, name) -> {
                        try {
                            return file.isDirectory() && Integer.valueOf(name) > 0;
                        }
                        catch (NumberFormatException ex) {
                            return false;
                        }
                    });
                    if (runLevelDirs != null && runLevelDirs.length > 0) {
                        for (String runLevel : runLevelDirs) {
                            dirs.put(runLevel, StringUtils.removeEnd((String)dir, (String)"/") + "/" + runLevel);
                        }
                    } else {
                        LOG.debug("No run level directories found under the [{}] directory", (Object)dir);
                    }
                } else {
                    LOG.warn("Unable to read [{}] directory.  Protocol [{}] is not supported (try exploded WAR files)", (Object)dir, (Object)url.getProtocol());
                }
            } else {
                LOG.warn("The [{}] directory was not found", (Object)dir);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable load bundles from the [{}] directory", (Object)dir, (Object)e);
        }
        return dirs;
    }

    protected List<String> getBundlesInDir(String dir) {
        ArrayList<String> bundleJars = new ArrayList<String>();
        try {
            ResourceFinder finder = new ResourceFinder(new URL[0]);
            URL url = finder.find(dir);
            if (url != null) {
                if ("file".equals(url.getProtocol())) {
                    File bundlesDir = new File(url.toURI());
                    File[] bundles = bundlesDir.listFiles((file, name) -> StringUtils.endsWith((CharSequence)name, (CharSequence)".jar"));
                    if (bundles != null && bundles.length > 0) {
                        for (File bundle : bundles) {
                            String externalForm = bundle.toURI().toURL().toExternalForm();
                            LOG.debug("Adding bundle [{}]", (Object)externalForm);
                            bundleJars.add(externalForm);
                        }
                    } else {
                        LOG.debug("No bundles found under the [{}] directory", (Object)dir);
                    }
                } else {
                    LOG.warn("Unable to read [{}] directory.  Protocol [{}] is not supported (try exploded WAR files)", (Object)dir, (Object)url.getProtocol());
                }
            } else {
                LOG.warn("The [{}] directory was not found", (Object)dir);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable load bundles from the [{}] directory", (Object)dir, (Object)e);
        }
        return bundleJars;
    }

    protected String getJarUrl(Class clazz) {
        ProtectionDomain protectionDomain = clazz.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL loc = codeSource.getLocation();
        return loc.toString();
    }

    protected void replaceSystemPackages(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Cannot replace system packages using a null properties reference");
        }
        String systemPackages = (String)properties.get("org.osgi.framework.system.packages");
        if (systemPackages != null && !systemPackages.isEmpty()) {
            LOG.debug("OSGi System Packages (before replacement): [{}]", (Object)systemPackages);
            String systemJavaVersion = System.getProperty("java.version");
            if (systemJavaVersion != null && !systemJavaVersion.isEmpty()) {
                String jreJavaSpecificationVersion = "jre-" + OsgiUtil.generateJavaVersionForSystemPackages(systemJavaVersion);
                LOG.debug("  System java.version: [{}], generated Java Specification Version: [{}]", (Object)systemJavaVersion, (Object)jreJavaSpecificationVersion);
                String jreJavaSpecificationVersionSubstitution = (String)properties.get(jreJavaSpecificationVersion);
                if (jreJavaSpecificationVersionSubstitution != null && !jreJavaSpecificationVersionSubstitution.isEmpty()) {
                    jreJavaSpecificationVersionSubstitution = jreJavaSpecificationVersionSubstitution.replace(DETECT_JAVA_VERSION, OsgiUtil.generateJava_SE_SystemPackageVersionString(systemJavaVersion)).trim();
                    systemPackages = systemPackages.replace(JRE_JAVA_SPECIFICATION_VERSION, jreJavaSpecificationVersionSubstitution);
                    properties.put("org.osgi.framework.system.packages", systemPackages);
                } else {
                    LOG.warn("Properties property [{}] is null or empty.  Unable to replace JRE system packages.  JRE system packages will be cleared", (Object)jreJavaSpecificationVersion);
                    systemPackages = systemPackages.replace(JRE_JAVA_SPECIFICATION_VERSION, "");
                    properties.put("org.osgi.framework.system.packages", systemPackages);
                }
            } else {
                LOG.warn("System property [{}] is null or empty.  Unable to replace JRE system packages", (Object)"java.version");
            }
            LOG.debug("OSGi System Packages (after replacement): [{}]", (Object)systemPackages);
        } else {
            LOG.warn("Unable to replace JRE system packages.  Properties required key [{}] is missing or empty", (Object)"org.osgi.framework.system.packages");
        }
    }

    protected void addExportedPackages(Properties strutsConfigProps, Properties configProps) {
        if (strutsConfigProps == null) {
            throw new IllegalArgumentException("Cannot add exported packages using a null struts config properties reference");
        }
        LOG.debug("  scanning.package.includes lookup returns: [{}]", (Object)((String)strutsConfigProps.get(SCANNING_PACKAGE_INCLUDES)));
        String[] rootPackages = StringUtils.split((String)((String)strutsConfigProps.get(SCANNING_PACKAGE_INCLUDES)), (String)",");
        ResourceFinder finder = new ResourceFinder("");
        ArrayList<String> exportedPackages = new ArrayList<String>();
        if (rootPackages == null || rootPackages.length == 0) {
            LOG.warn("Struts config roperties required key [{}] is missing or empty.  No exported packages are available to add", (Object)SCANNING_PACKAGE_INCLUDES);
            return;
        }
        for (String rootPackage : rootPackages) {
            LOG.debug("  Looking for root package: [{}] ", (Object)rootPackage);
            try {
                String version = null;
                if (rootPackage.indexOf(";") > 0) {
                    String[] splitted = rootPackage.split(";");
                    rootPackage = splitted[0];
                    version = splitted[1];
                }
                Map subpackagesMap = finder.findPackagesMap(StringUtils.replace((String)rootPackage.trim(), (String)".", (String)"/"));
                LOG.debug("  Trimmed package map for: [{}] has size: [{}]", (Object)rootPackage.trim(), (Object)subpackagesMap.size());
                for (Map.Entry entry : subpackagesMap.entrySet()) {
                    URL url = (URL)entry.getKey();
                    Set packages = (Set)entry.getValue();
                    if (StringUtils.isBlank((CharSequence)version)) {
                        version = this.getVersion(url);
                        LOG.debug("  Version was null.  Retrieved version: [{}] for [{}]", (Object)version, (Object)(url != null ? url.toString() : null));
                    }
                    if (packages != null) {
                        LOG.debug("  Subpackages size: [{}]", (Object)packages.size());
                        for (String subpackage : packages) {
                            LOG.trace("  Adding subppackage: [{}; version=\"{}\"]", (Object)subpackage, (Object)version);
                            exportedPackages.add(subpackage + "; version=\"" + version + "\"");
                        }
                        continue;
                    }
                    LOG.debug("  Subpackages is null");
                }
            }
            catch (IOException e) {
                LOG.error("Unable to find subpackages of [{}]", (Object)rootPackage, (Object)e);
            }
        }
        if (!exportedPackages.isEmpty() && configProps != null) {
            String systemPackages = (String)configProps.get("org.osgi.framework.system.packages");
            if (systemPackages == null || systemPackages.isEmpty()) {
                LOG.warn("Config properties required key [{}] is missing or empty.  Only the exported packages will be present", (Object)"org.osgi.framework.system.packages");
                systemPackages = StringUtils.join(exportedPackages, (String)",");
            } else {
                systemPackages = StringUtils.removeEnd((String)systemPackages, (String)",") + "," + StringUtils.join(exportedPackages, (String)",");
            }
            configProps.put("org.osgi.framework.system.packages", systemPackages);
            LOG.debug("Adding exported framework packages: [{}]", (Object)systemPackages);
        } else {
            LOG.warn("NOT adding any exported framework packages.  No exported packages or config props is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getVersion(URL url) {
        if (!"jar".equals(url.getProtocol())) return "1.0.0";
        ZipFile jarFile = null;
        try {
            ActionContext actionContext = null;
            FileManagerFactory fileManagerFactory = null;
            FileManager fileManager = null;
            actionContext = ServletActionContext.getContext();
            if (actionContext == null) {
                LOG.warn("ActionContext is null.  Cannot load FileManagerFactory from it");
            }
            if (actionContext != null) {
                fileManagerFactory = (FileManagerFactory)actionContext.getInstance(FileManagerFactory.class);
            }
            if (fileManagerFactory == null) {
                LOG.warn("FileManagerFactory is null in ActionContext.  Cannot load FileManager from it");
            } else {
                fileManager = fileManagerFactory.getFileManager();
            }
            if (fileManager == null) {
                if (fileManagerFactory != null) {
                    LOG.debug("FileManager is null in FileManagerFactory.  Using a DefaultFileManager");
                } else {
                    LOG.debug("Using a DefaultFileManager");
                }
                fileManager = new DefaultFileManager();
            }
            jarFile = new JarFile(new File(fileManager.normalizeToFileProtocol(url).toURI()));
            Manifest manifest = ((JarFile)jarFile).getManifest();
            String jarFileName = jarFile.getName();
            if (jarFileName != null) {
                int lastPathSeparatorIndex;
                int lastExclamationIndex = jarFileName.lastIndexOf("!");
                if (lastExclamationIndex != -1) {
                    jarFileName = jarFileName.substring(0, lastExclamationIndex);
                }
                if (jarFileName.toLowerCase().endsWith(".jar") && (lastPathSeparatorIndex = jarFileName.lastIndexOf(File.separator)) != -1) {
                    jarFileName = jarFileName.substring(lastPathSeparatorIndex + 1);
                }
            }
            if (manifest != null) {
                String version = manifest.getMainAttributes().getValue("Bundle-Version");
                if (StringUtils.isNotBlank((CharSequence)version)) {
                    LOG.debug("Attempting to get bundle version for [{}] via its JAR manifest", (Object)url.toExternalForm());
                    String string = this.getVersionFromString(version);
                    return string;
                }
                LOG.debug("Attempting to get bundle version for [{}] via its filename [{}]", (Object)url.toExternalForm(), (Object)jarFileName);
                String string = this.getVersionFromString(jarFileName);
                return string;
            }
            LOG.debug("Attempting to get bundle version for [{}] via its filename [{}]", (Object)url.toExternalForm(), (Object)jarFileName);
            String string = this.getVersionFromString(jarFileName);
            return string;
        }
        catch (Exception e) {
            LOG.error("Unable to extract version from [{}], defaulting to '1.0.0'", (Object)url.toExternalForm());
            return "1.0.0";
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected String getVersionFromString(String str) {
        String trimmedString = str != null ? str.trim() : str;
        Matcher matcher = VERSION_PATTERN.matcher(trimmedString);
        ArrayList<String> parts = new ArrayList<String>();
        while (matcher.find()) {
            parts.add(matcher.group(1));
        }
        if (parts.isEmpty()) {
            return "1.0.0";
        }
        while (parts.size() < 3) {
            parts.add("0");
        }
        while (parts.size() > 3) {
            parts.remove(0);
        }
        return StringUtils.join(parts, (String)".");
    }

    protected Properties getProperties(String fileName) {
        ResourceFinder finder = new ResourceFinder("");
        try {
            return finder.findProperties(fileName);
        }
        catch (IOException e) {
            LOG.error("Unable to read the property file [{}]", (Object)fileName, (Object)e);
            if (this.searchForPropertiesFilesInRelativePath()) {
                try {
                    LOG.warn("Relative path search is enabled.  Retry attempt to read the property file [{}] from the relative path", (Object)fileName);
                    return this.findPropertiesFileInRelativePath(fileName);
                }
                catch (IOException ioex) {
                    LOG.error("Unable to read the property file [{}] using the relative path", (Object)fileName, (Object)ioex);
                }
            }
            return new Properties();
        }
    }

    protected boolean searchForPropertiesFilesInRelativePath() {
        if (this.servletContext != null) {
            String searchForPropertiesFilesInRelativePath = this.getServletContextParam("struts.osgi.searchForPropertiesFilesInRelativePath", "false");
            return Boolean.parseBoolean(searchForPropertiesFilesInRelativePath);
        }
        return false;
    }

    protected Properties findPropertiesFileInRelativePath(String fileName) throws IOException {
        if (fileName == null || fileName.toLowerCase().endsWith(".class") || fileName.toLowerCase().endsWith(".jar")) {
            throw new IllegalArgumentException("Provided file name cannot be null, nor should it be a class or jar file");
        }
        ClassLoaderInterfaceDelegate classLoaderInterface = new ClassLoaderInterfaceDelegate(Thread.currentThread().getContextClassLoader());
        URL fileUrl = classLoaderInterface.getResource(fileName);
        try (BufferedInputStream reader = new BufferedInputStream(fileUrl.openStream());){
            Properties properties = new Properties();
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
    }

    static {
        versionPattern = VERSION_PATTERN = Pattern.compile("([\\d]+)(?:[\\.-]|$)");
    }
}

