/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.exception;

import java.util.ListIterator;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.context.ConstructorParameterContext;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.MethodEntryContext;
import net.sf.oval.context.MethodParameterContext;
import net.sf.oval.context.MethodReturnValueContext;
import net.sf.oval.context.OValContext;
import net.sf.oval.exception.ConstraintsViolatedException;
import net.sf.oval.exception.ExceptionTranslator;
import net.sf.oval.exception.OValException;
import net.sf.oval.internal.Log;

public class ExceptionTranslatorJDKExceptionsImpl
implements ExceptionTranslator {
    private static final Log LOG = Log.getLog(ExceptionTranslatorJDKExceptionsImpl.class);

    @Override
    public RuntimeException translateException(OValException ex) {
        if (ex instanceof ConstraintsViolatedException) {
            ConstraintsViolatedException cex = (ConstraintsViolatedException)ex;
            ConstraintViolation cv = cex.getConstraintViolations()[0];
            ListIterator<OValContext> listIterator = cv.getContextPath().listIterator(cv.getContextPath().size());
            OValContext ctx = null;
            while (listIterator.hasPrevious()) {
                ctx = listIterator.previous();
                if (ctx instanceof MethodParameterContext || ctx instanceof ConstructorParameterContext || ctx instanceof MethodEntryContext) {
                    IllegalArgumentException iaex = new IllegalArgumentException(cv.getMessage(), ex.getCause());
                    iaex.setStackTrace(ex.getStackTrace());
                    LOG.debug("Translated Exception {1} to {2}", (Object)ex, iaex);
                    return iaex;
                }
                if (!(ctx instanceof FieldContext) && !(ctx instanceof MethodReturnValueContext)) continue;
                IllegalStateException ise = new IllegalStateException(cv.getMessage(), ex.getCause());
                ise.setStackTrace(ex.getStackTrace());
                LOG.debug("Translated Exception {1} to {2}", (Object)ex, ise);
                return ise;
            }
        }
        RuntimeException rex = new RuntimeException(ex.getMessage(), ex.getCause());
        rex.setStackTrace(ex.getStackTrace());
        LOG.debug("Translated Exception {1} to {2}", (Object)ex, rex);
        return rex;
    }
}

