/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.jcr;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.iterator.NodeTypeIteratorAdapter;
import org.apache.sling.testing.mock.jcr.MockNodeTypeManager;
import org.jetbrains.annotations.Nullable;

class MockNodeType
implements NodeType {
    private final NodeTypeDefinition ntd;
    private final String name;
    @Nullable
    private final NodeTypeManager ntMgr;

    public MockNodeType(String name) {
        this(name, null);
    }

    public MockNodeType(String name, @Nullable NodeTypeManager ntMgr) {
        this.ntd = null;
        this.name = name;
        this.ntMgr = ntMgr;
    }

    public MockNodeType(NodeTypeDefinition ntd, @Nullable NodeTypeManager ntMgr) {
        this.ntd = ntd;
        this.name = ntd.getName();
        this.ntMgr = ntMgr;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNodeType(String nodeTypeName) {
        boolean isNt = this.name.equals(nodeTypeName);
        if (this.ntd != null && !isNt) {
            NodeType[] supertypes = this.getSupertypes();
            isNt = Stream.of(supertypes).anyMatch(nt -> nt.getName().equals(nodeTypeName));
        }
        return isNt;
    }

    public boolean hasOrderableChildNodes() {
        if (this.ntd != null) {
            return this.ntd.hasOrderableChildNodes();
        }
        return StringUtils.equals((CharSequence)this.getName(), (CharSequence)"nt:unstructured");
    }

    public boolean canAddChildNode(String childNodeName) {
        throw new UnsupportedOperationException();
    }

    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        throw new UnsupportedOperationException();
    }

    public boolean canRemoveItem(String itemName) {
        throw new UnsupportedOperationException();
    }

    public boolean canSetProperty(String propertyName, Value value) {
        throw new UnsupportedOperationException();
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        throw new UnsupportedOperationException();
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        NodeType[] supertypes;
        LinkedHashMap<String, NodeDefinition> defsMap = new LinkedHashMap<String, NodeDefinition>();
        for (NodeType nodeType : supertypes = this.getSupertypes()) {
            NodeDefinition[] declaredChildNodeDefinitions = nodeType.getDeclaredChildNodeDefinitions();
            if (declaredChildNodeDefinitions == null) continue;
            for (NodeDefinition declaredChildNodeDefinition : declaredChildNodeDefinitions) {
                defsMap.put(declaredChildNodeDefinition.getName(), declaredChildNodeDefinition);
            }
        }
        NodeDefinition[] declaredChildNodeDefinitions = this.getDeclaredChildNodeDefinitions();
        if (declaredChildNodeDefinitions != null) {
            for (NodeDefinition declaredChildNodeDefinition : declaredChildNodeDefinitions) {
                defsMap.put(declaredChildNodeDefinition.getName(), declaredChildNodeDefinition);
            }
        }
        return defsMap.values().toArray(new NodeDefinition[defsMap.size()]);
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        if (this.ntd != null) {
            return this.ntd.getDeclaredChildNodeDefinitions();
        }
        throw new UnsupportedOperationException();
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        if (this.ntd != null) {
            return this.ntd.getDeclaredPropertyDefinitions();
        }
        throw new UnsupportedOperationException();
    }

    public NodeType[] getDeclaredSupertypes() {
        if (this.ntd != null && this.ntMgr != null) {
            String[] supertypeNames = this.ntd.getDeclaredSupertypeNames();
            return (NodeType[])Stream.of(supertypeNames).map(n -> {
                try {
                    return this.ntMgr.getNodeType(n);
                }
                catch (RepositoryException e) {
                    throw new RuntimeException("Getting declared supertype failed.", e);
                }
            }).toArray(NodeType[]::new);
        }
        throw new UnsupportedOperationException();
    }

    public String getPrimaryItemName() {
        if (this.ntd != null) {
            return this.ntd.getPrimaryItemName();
        }
        throw new UnsupportedOperationException();
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        NodeType[] supertypes;
        LinkedHashMap<String, PropertyDefinition> defsMap = new LinkedHashMap<String, PropertyDefinition>();
        for (NodeType nodeType : supertypes = this.getSupertypes()) {
            PropertyDefinition[] declaredPropDefinitions = nodeType.getDeclaredPropertyDefinitions();
            if (declaredPropDefinitions == null) continue;
            for (PropertyDefinition declaredChildNodeDefinition : declaredPropDefinitions) {
                defsMap.put(declaredChildNodeDefinition.getName(), declaredChildNodeDefinition);
            }
        }
        PropertyDefinition[] declaredPropDefinitions = this.getDeclaredPropertyDefinitions();
        if (declaredPropDefinitions != null) {
            for (PropertyDefinition declaredChildNodeDefinition : declaredPropDefinitions) {
                defsMap.put(declaredChildNodeDefinition.getName(), declaredChildNodeDefinition);
            }
        }
        return defsMap.values().toArray(new PropertyDefinition[defsMap.size()]);
    }

    private void loadSupertypes(NodeType nt, Set<NodeType> ntSet) {
        if (!ntSet.contains(nt)) {
            NodeType[] supertypes;
            ntSet.add(nt);
            for (NodeType nodeType : supertypes = nt.getDeclaredSupertypes()) {
                this.loadSupertypes(nodeType, ntSet);
            }
        }
    }

    public NodeType[] getSupertypes() {
        NodeType[] supertypes;
        LinkedHashSet<NodeType> ntSet = new LinkedHashSet<NodeType>();
        for (NodeType nodeType : supertypes = this.getDeclaredSupertypes()) {
            this.loadSupertypes(nodeType, ntSet);
        }
        if (!this.isMixin() && this.ntMgr != null && !"nt:base".equals(this.getName())) {
            try {
                ntSet.add(this.ntMgr.getNodeType("nt:base"));
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Getting supertype failed.", e);
            }
        }
        return ntSet.toArray(new NodeType[ntSet.size()]);
    }

    public boolean isMixin() {
        if (this.ntd != null) {
            return this.ntd.isMixin();
        }
        throw new UnsupportedOperationException();
    }

    public boolean canRemoveNode(String nodeName) {
        throw new UnsupportedOperationException();
    }

    public boolean canRemoveProperty(String propertyName) {
        throw new UnsupportedOperationException();
    }

    public NodeTypeIterator getDeclaredSubtypes() {
        if (this.ntMgr != null && ((MockNodeTypeManager)this.ntMgr).isMode(MockNodeTypeManager.ResolveMode.MOCK_ALL)) {
            throw new UnsupportedOperationException();
        }
        ArrayList<NodeType> subtypes = new ArrayList<NodeType>();
        if (this.ntMgr != null) {
            try {
                NodeTypeIterator allNodeTypes = this.ntMgr.getAllNodeTypes();
                while (allNodeTypes.hasNext()) {
                    NodeType nextNodeType = allNodeTypes.nextNodeType();
                    boolean issubtype = Stream.of(nextNodeType.getDeclaredSupertypes()).anyMatch(nt -> nt.getName().equals(this.getName()));
                    if (!issubtype) continue;
                    subtypes.add(nextNodeType);
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Getting declared subtype failed.", e);
            }
        }
        return new NodeTypeIteratorAdapter(subtypes);
    }

    public NodeTypeIterator getSubtypes() {
        if (this.ntMgr != null && ((MockNodeTypeManager)this.ntMgr).isMode(MockNodeTypeManager.ResolveMode.MOCK_ALL)) {
            throw new UnsupportedOperationException();
        }
        ArrayList<NodeType> subtypes = new ArrayList<NodeType>();
        if (this.ntMgr != null) {
            try {
                NodeTypeIterator allNodeTypes = this.ntMgr.getAllNodeTypes();
                while (allNodeTypes.hasNext()) {
                    NodeType nextNodeType = allNodeTypes.nextNodeType();
                    boolean issubtype = Stream.of(nextNodeType.getSupertypes()).anyMatch(nt -> nt.getName().equals(this.getName()));
                    if (!issubtype) continue;
                    subtypes.add(nextNodeType);
                }
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Getting declared subtype failed.", e);
            }
        }
        return new NodeTypeIteratorAdapter(subtypes);
    }

    public String[] getDeclaredSupertypeNames() {
        if (this.ntd != null) {
            return this.ntd.getDeclaredSupertypeNames();
        }
        throw new UnsupportedOperationException();
    }

    public boolean isAbstract() {
        if (this.ntd != null) {
            return this.ntd.isAbstract();
        }
        throw new UnsupportedOperationException();
    }

    public boolean isQueryable() {
        if (this.ntd != null) {
            return this.ntd.isQueryable();
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MockNodeType [name=");
        builder.append(this.name);
        builder.append("]");
        return builder.toString();
    }
}

