/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentloader;

public class ContentTypeUtil {
    public static final String EXT_JSON = ".json";
    public static final String TYPE_JSON = "application/json";
    public static final String EXT_XML = ".xml";
    public static final String TYPE_XML = "application/xml";
    public static final String EXT_JCR_XML = ".jcr.xml";
    public static final String TYPE_JCR_XML = "application/x-jcr+xml";
    public static final String EXT_ZIP = ".zip";
    public static final String TYPE_ZIP = "application/zip";
    public static final String EXT_JAR = ".jar";
    public static final String TYPE_JAR = "application/java-archive";

    public static String detectContentType(String filename) {
        if (filename != null && !filename.isEmpty()) {
            if (filename.toLowerCase().endsWith(EXT_JSON)) {
                return TYPE_JSON;
            }
            if (filename.toLowerCase().endsWith(EXT_JCR_XML)) {
                return TYPE_JCR_XML;
            }
            if (filename.toLowerCase().endsWith(EXT_XML)) {
                return TYPE_XML;
            }
            if (filename.toLowerCase().endsWith(EXT_ZIP)) {
                return TYPE_ZIP;
            }
            if (filename.toLowerCase().endsWith(EXT_JAR)) {
                return TYPE_JAR;
            }
        }
        return null;
    }

    public static String getDefaultExtension(String contentType) {
        if (contentType != null && !contentType.isEmpty()) {
            if (TYPE_JSON.equalsIgnoreCase(contentType)) {
                return EXT_JSON;
            }
            if (TYPE_JCR_XML.equalsIgnoreCase(contentType)) {
                return EXT_JCR_XML;
            }
            if (TYPE_XML.equalsIgnoreCase(contentType)) {
                return EXT_XML;
            }
            if (TYPE_ZIP.equalsIgnoreCase(contentType)) {
                return EXT_ZIP;
            }
            if (TYPE_JAR.equalsIgnoreCase(contentType)) {
                return EXT_JAR;
            }
        }
        return null;
    }
}

