/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.wizards;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.sling.ide.eclipse.core.ConfigurationHelper;
import org.apache.sling.ide.eclipse.core.progress.ProgressUtils;
import org.apache.sling.ide.eclipse.ui.WhitelabelSupport;
import org.apache.sling.ide.eclipse.ui.wizards.AbstractNewSlingApplicationWizard;
import org.apache.sling.ide.eclipse.ui.wizards.Projects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.wst.server.core.IServer;

public class NewSlingContentProjectWizard
extends AbstractNewSlingApplicationWizard {
    private WizardNewProjectCreationPage page;

    public void addPages() {
        this.page = new WizardNewProjectCreationPage("New Project");
        this.page.setImageDescriptor(WhitelabelSupport.getProjectWizardBanner());
        this.page.setDescription("Please select the coordinates for the new content project");
        this.addPage((IWizardPage)this.page);
        this.addPage((IWizardPage)this.getSetupServerWizardPage());
    }

    @Override
    protected List<IProject> createProjects(IProgressMonitor monitor) throws CoreException {
        IProject existingProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.page.getProjectName());
        if (existingProject != null && existingProject.exists()) {
            throw new IllegalStateException("Project already exists with name " + this.page.getProjectName());
        }
        IProject project = this.page.getProjectHandle();
        ArrayList<Operation> ops = new ArrayList<Operation>();
        ops.add(new CreateProject(project));
        ops.add(new OpenProject(project));
        ops.add(new CreateFolder(project, "jcr_root"));
        ops.add(new CreateFolder(project, "jcr_root/content"));
        ops.add(new CreateFile(project, "jcr_root/content/.content.xml", ((Object)((Object)this)).getClass().getResourceAsStream("res/folder.content.xml")));
        ops.add(new CreateFolder(project, "jcr_root/content/example"));
        ops.add(new CreateFile(project, "jcr_root/content/example/.content.xml", ((Object)((Object)this)).getClass().getResourceAsStream("res/.content.xml")));
        ops.add(new CreateFolder(project, "jcr_root/apps"));
        ops.add(new CreateFolder(project, "jcr_root/apps/example"));
        ops.add(new CreateFolder(project, "jcr_root/apps/example/item"));
        ops.add(new CreateFile(project, "jcr_root/apps/example/item/html.jsp", ((Object)((Object)this)).getClass().getResourceAsStream("res/html.jsp")));
        ops.add(new CreateFolder(project, "META-INF"));
        ops.add(new CreateFolder(project, "META-INF/vault"));
        ops.add(new CreateFile(project, "META-INF/vault/filter.xml", ((Object)((Object)this)).getClass().getResourceAsStream("res/filter.xml")));
        ops.add(new CreateFile(project, "META-INF/vault/config.xml", ((Object)((Object)this)).getClass().getResourceAsStream("res/config.xml")));
        ops.add(new CreateFile(project, "META-INF/vault/settings.xml", ((Object)((Object)this)).getClass().getResourceAsStream("res/settings.xml")));
        monitor.beginTask("Creating project", ops.size());
        try {
            for (Operation op : ops) {
                op.execute(monitor);
                ProgressUtils.advance((IProgressMonitor)monitor, (int)1);
            }
        }
        finally {
            monitor.done();
        }
        return Collections.singletonList(project);
    }

    @Override
    protected Projects configureCreatedProjects(List<IProject> createdProjects, IProgressMonitor monitor) throws CoreException {
        Projects projects = new Projects();
        for (IProject project : createdProjects) {
            ConfigurationHelper.convertToContentPackageProject((IProject)project, (IProgressMonitor)monitor, (IPath)new Path("jcr_root"));
            projects.getContentProjects().add(project);
        }
        IServer server = this.getSetupServerWizardPage().getOrCreateServer(monitor);
        ProgressUtils.advance((IProgressMonitor)monitor, (int)1);
        this.finishConfiguration(createdProjects, server, monitor);
        ProgressUtils.advance((IProgressMonitor)monitor, (int)1);
        return projects;
    }

    @Override
    public String doGetWindowTitle() {
        return "New Content Project";
    }

    public static class CreateFile
    implements Operation {
        private final IProject project;
        private final String fileName;
        private final InputStream input;

        public CreateFile(IProject project, String fileName, InputStream input) {
            this.project = project;
            this.fileName = fileName;
            this.input = input;
        }

        @Override
        public void execute(IProgressMonitor monitor) throws CoreException {
            try {
                this.project.getFile(this.fileName).create(this.input, true, monitor);
            }
            finally {
                IOUtils.closeQuietly((InputStream)this.input);
            }
        }
    }

    public static class CreateFolder
    implements Operation {
        private final IProject project;
        private final String folderName;

        public CreateFolder(IProject project, String folderName) {
            this.project = project;
            this.folderName = folderName;
        }

        @Override
        public void execute(IProgressMonitor monitor) throws CoreException {
            this.project.getFolder(this.folderName).create(true, true, monitor);
        }
    }

    public static class CreateProject
    implements Operation {
        private final IProject project;

        public CreateProject(IProject project) {
            this.project = project;
        }

        @Override
        public void execute(IProgressMonitor monitor) throws CoreException {
            this.project.create(monitor);
        }
    }

    public static class OpenProject
    implements Operation {
        private final IProject project;

        public OpenProject(IProject project) {
            this.project = project;
        }

        @Override
        public void execute(IProgressMonitor monitor) throws CoreException {
            this.project.open(monitor);
        }
    }

    private static interface Operation {
        public void execute(IProgressMonitor var1) throws CoreException;
    }
}

