/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.pagecache.ManyMessageTransfer;
import org.apache.rocketmq.common.KeyBuilder;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.protocol.header.PeekMessageRequestHeader;
import org.apache.rocketmq.common.protocol.header.PopMessageResponseHeader;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.SelectMappedBufferResult;

public class PeekMessageProcessor
implements NettyRequestProcessor {
    private static final InternalLogger LOG = InternalLoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;
    private Random random = new Random(System.currentTimeMillis());

    public PeekMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        return this.processRequest(ctx.channel(), request, true);
    }

    public boolean rejectRequest() {
        return false;
    }

    private RemotingCommand processRequest(final Channel channel, RemotingCommand request, boolean brokerAllowSuspend) throws RemotingCommandException {
        int queueId;
        int i;
        TopicConfig retryTopicConfig;
        RemotingCommand response = RemotingCommand.createResponseCommand(PopMessageResponseHeader.class);
        PopMessageResponseHeader responseHeader = (PopMessageResponseHeader)response.readCustomHeader();
        PeekMessageRequestHeader requestHeader = (PeekMessageRequestHeader)request.decodeCommandCustomHeader(PeekMessageRequestHeader.class);
        response.setOpaque(request.getOpaque());
        if (!PermName.isReadable((int)this.brokerController.getBrokerConfig().getBrokerPermission())) {
            response.setCode(16);
            response.setRemark(String.format("the broker[%s] peeking message is forbidden", this.brokerController.getBrokerConfig().getBrokerIP1()));
            return response;
        }
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (null == topicConfig) {
            LOG.error("The topic {} not exist, consumer: {} ", (Object)requestHeader.getTopic(), (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
            response.setCode(17);
            response.setRemark(String.format("topic[%s] not exist, apply first please! %s", requestHeader.getTopic(), FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/")));
            return response;
        }
        if (!PermName.isReadable((int)topicConfig.getPerm())) {
            response.setCode(16);
            response.setRemark("the topic[" + requestHeader.getTopic() + "] peeking message is forbidden");
            return response;
        }
        if (requestHeader.getQueueId() >= topicConfig.getReadQueueNums()) {
            String errorInfo = String.format("queueId[%d] is illegal, topic:[%s] topicConfig.readQueueNums:[%d] consumer:[%s]", requestHeader.getQueueId(), requestHeader.getTopic(), topicConfig.getReadQueueNums(), channel.remoteAddress());
            LOG.warn(errorInfo);
            response.setCode(1);
            response.setRemark(errorInfo);
            return response;
        }
        SubscriptionGroupConfig subscriptionGroupConfig = this.brokerController.getSubscriptionGroupManager().findSubscriptionGroupConfig(requestHeader.getConsumerGroup());
        if (null == subscriptionGroupConfig) {
            response.setCode(26);
            response.setRemark(String.format("subscription group [%s] does not exist, %s", requestHeader.getConsumerGroup(), FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/")));
            return response;
        }
        if (!subscriptionGroupConfig.isConsumeEnable()) {
            response.setCode(16);
            response.setRemark("subscription group no permission, " + requestHeader.getConsumerGroup());
            return response;
        }
        int randomQ = this.random.nextInt(100);
        int reviveQid = randomQ % this.brokerController.getBrokerConfig().getReviveQueueNum();
        int commercialSizePerMsg = this.brokerController.getBrokerConfig().getCommercialSizePerMsg();
        GetMessageResult getMessageResult = new GetMessageResult(commercialSizePerMsg);
        boolean needRetry = randomQ % 5 == 0;
        long popTime = System.currentTimeMillis();
        long restNum = 0L;
        if (needRetry && (retryTopicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(KeyBuilder.buildPopRetryTopic((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup()))) != null) {
            for (i = 0; i < retryTopicConfig.getReadQueueNums(); ++i) {
                queueId = (randomQ + i) % retryTopicConfig.getReadQueueNums();
                restNum = this.peekMsgFromQueue(true, getMessageResult, requestHeader, queueId, restNum, reviveQid, channel, popTime);
            }
        }
        if (requestHeader.getQueueId() < 0) {
            for (int i2 = 0; i2 < topicConfig.getReadQueueNums(); ++i2) {
                int queueId2 = (randomQ + i2) % topicConfig.getReadQueueNums();
                restNum = this.peekMsgFromQueue(false, getMessageResult, requestHeader, queueId2, restNum, reviveQid, channel, popTime);
            }
        } else {
            int queueId3 = requestHeader.getQueueId();
            restNum = this.peekMsgFromQueue(false, getMessageResult, requestHeader, queueId3, restNum, reviveQid, channel, popTime);
        }
        if (!needRetry && getMessageResult.getMessageMapedList().size() < requestHeader.getMaxMsgNums() && (retryTopicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(KeyBuilder.buildPopRetryTopic((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup()))) != null) {
            for (i = 0; i < retryTopicConfig.getReadQueueNums(); ++i) {
                queueId = (randomQ + i) % retryTopicConfig.getReadQueueNums();
                restNum = this.peekMsgFromQueue(true, getMessageResult, requestHeader, queueId, restNum, reviveQid, channel, popTime);
            }
        }
        if (!getMessageResult.getMessageBufferList().isEmpty()) {
            response.setCode(0);
            getMessageResult.setStatus(GetMessageStatus.FOUND);
        } else {
            response.setCode(19);
            getMessageResult.setStatus(GetMessageStatus.NO_MESSAGE_IN_QUEUE);
        }
        responseHeader.setRestNum(restNum);
        response.setRemark(getMessageResult.getStatus().name());
        switch (response.getCode()) {
            case 0: {
                this.brokerController.getBrokerStatsManager().incGroupGetNums(requestHeader.getConsumerGroup(), requestHeader.getTopic(), getMessageResult.getMessageCount());
                this.brokerController.getBrokerStatsManager().incGroupGetSize(requestHeader.getConsumerGroup(), requestHeader.getTopic(), getMessageResult.getBufferTotalSize());
                this.brokerController.getBrokerStatsManager().incBrokerGetNums(getMessageResult.getMessageCount());
                if (this.brokerController.getBrokerConfig().isTransferMsgByHeap()) {
                    long beginTimeMills = this.brokerController.getMessageStore().now();
                    byte[] r = this.readGetMessageResult(getMessageResult, requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId());
                    this.brokerController.getBrokerStatsManager().incGroupGetLatency(requestHeader.getConsumerGroup(), requestHeader.getTopic(), requestHeader.getQueueId(), (int)(this.brokerController.getMessageStore().now() - beginTimeMills));
                    response.setBody(r);
                    break;
                }
                final GetMessageResult tmpGetMessageResult = getMessageResult;
                try {
                    ManyMessageTransfer fileRegion = new ManyMessageTransfer(response.encodeHeader(getMessageResult.getBufferTotalSize()), getMessageResult);
                    channel.writeAndFlush((Object)fileRegion).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            tmpGetMessageResult.release();
                            if (!future.isSuccess()) {
                                LOG.error("Fail to transfer messages from page cache to {}", (Object)channel.remoteAddress(), (Object)future.cause());
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    LOG.error("Error occurred when transferring messages from page cache", e);
                    getMessageResult.release();
                }
                response = null;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return response;
    }

    private long peekMsgFromQueue(boolean isRetry, GetMessageResult getMessageResult, PeekMessageRequestHeader requestHeader, int queueId, long restNum, int reviveQid, Channel channel, long popTime) {
        String topic = isRetry ? KeyBuilder.buildPopRetryTopic((String)requestHeader.getTopic(), (String)requestHeader.getConsumerGroup()) : requestHeader.getTopic();
        long offset = this.getPopOffset(topic, requestHeader.getConsumerGroup(), queueId);
        restNum = this.brokerController.getMessageStore().getMaxOffsetInQueue(topic, queueId) - offset + restNum;
        if (getMessageResult.getMessageMapedList().size() >= requestHeader.getMaxMsgNums()) {
            return restNum;
        }
        GetMessageResult getMessageTmpResult = this.brokerController.getMessageStore().getMessage(requestHeader.getConsumerGroup(), topic, queueId, offset, requestHeader.getMaxMsgNums() - getMessageResult.getMessageMapedList().size(), null);
        if (GetMessageStatus.OFFSET_TOO_SMALL.equals((Object)getMessageTmpResult.getStatus()) || GetMessageStatus.OFFSET_OVERFLOW_BADLY.equals((Object)getMessageTmpResult.getStatus())) {
            offset = getMessageTmpResult.getNextBeginOffset();
            getMessageTmpResult = this.brokerController.getMessageStore().getMessage(requestHeader.getConsumerGroup(), topic, queueId, offset, requestHeader.getMaxMsgNums() - getMessageResult.getMessageMapedList().size(), null);
        }
        if (getMessageTmpResult != null) {
            for (SelectMappedBufferResult mapedBuffer : getMessageTmpResult.getMessageMapedList()) {
                getMessageResult.addMessage(mapedBuffer);
            }
        }
        return restNum;
    }

    private long getPopOffset(String topic, String cid, int queueId) {
        long bufferOffset;
        long offset = this.brokerController.getConsumerOffsetManager().queryOffset(cid, topic, queueId);
        if (offset < 0L) {
            offset = this.brokerController.getMessageStore().getMinOffsetInQueue(topic, queueId);
        }
        if ((bufferOffset = this.brokerController.getPopMessageProcessor().getPopBufferMergeService().getLatestOffset(topic, cid, queueId)) < 0L) {
            return offset;
        }
        return bufferOffset > offset ? bufferOffset : offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readGetMessageResult(GetMessageResult getMessageResult, String group, String topic, int queueId) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(getMessageResult.getBufferTotalSize());
        long storeTimestamp = 0L;
        try {
            List messageBufferList = getMessageResult.getMessageBufferList();
            for (ByteBuffer bb : messageBufferList) {
                byteBuffer.put(bb);
                storeTimestamp = bb.getLong(56);
            }
        }
        finally {
            getMessageResult.release();
        }
        this.brokerController.getBrokerStatsManager().recordDiskFallBehindTime(group, topic, queueId, this.brokerController.getMessageStore().now() - storeTimestamp);
        return byteBuffer.array();
    }
}

