/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.utils;

import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public abstract class ConcurrentHashMapUtils {
    private static final boolean IS_JDK8 = System.getProperty("java.version").startsWith("1.8.");

    public static <K, V> V computeIfAbsent(ConcurrentMap<K, V> map, K key, Function<? super K, ? extends V> func) {
        if (IS_JDK8) {
            Object v = map.get(key);
            if (null == v) {
                v = map.computeIfAbsent((K)key, func);
            }
            return v;
        }
        return map.computeIfAbsent((K)key, func);
    }
}

