/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaDataType is an enum
type OpcuaDataType string

type IOpcuaDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	VariantType() uint8
}

const (
	OpcuaDataType_NULL           OpcuaDataType = "NULL"
	OpcuaDataType_BOOL           OpcuaDataType = "BOOL"
	OpcuaDataType_BYTE           OpcuaDataType = "BYTE"
	OpcuaDataType_SINT           OpcuaDataType = "SINT"
	OpcuaDataType_INT            OpcuaDataType = "INT"
	OpcuaDataType_DINT           OpcuaDataType = "DINT"
	OpcuaDataType_LINT           OpcuaDataType = "LINT"
	OpcuaDataType_USINT          OpcuaDataType = "USINT"
	OpcuaDataType_UINT           OpcuaDataType = "UINT"
	OpcuaDataType_UDINT          OpcuaDataType = "UDINT"
	OpcuaDataType_ULINT          OpcuaDataType = "ULINT"
	OpcuaDataType_REAL           OpcuaDataType = "REAL"
	OpcuaDataType_LREAL          OpcuaDataType = "LREAL"
	OpcuaDataType_TIME           OpcuaDataType = "TIME"
	OpcuaDataType_LTIME          OpcuaDataType = "LTIME"
	OpcuaDataType_DATE           OpcuaDataType = "DATE"
	OpcuaDataType_LDATE          OpcuaDataType = "LDATE"
	OpcuaDataType_TIME_OF_DAY    OpcuaDataType = "TIME_OF_DAY"
	OpcuaDataType_LTIME_OF_DAY   OpcuaDataType = "LTIME_OF_DAY"
	OpcuaDataType_DATE_AND_TIME  OpcuaDataType = "DATE_AND_TIME"
	OpcuaDataType_LDATE_AND_TIME OpcuaDataType = "LDATE_AND_TIME"
	OpcuaDataType_CHAR           OpcuaDataType = "CHAR"
	OpcuaDataType_WCHAR          OpcuaDataType = "WCHAR"
	OpcuaDataType_STRING         OpcuaDataType = "STRING"
)

var OpcuaDataTypeValues []OpcuaDataType

func init() {
	_ = errors.New
	OpcuaDataTypeValues = []OpcuaDataType{
		OpcuaDataType_NULL,
		OpcuaDataType_BOOL,
		OpcuaDataType_BYTE,
		OpcuaDataType_SINT,
		OpcuaDataType_INT,
		OpcuaDataType_DINT,
		OpcuaDataType_LINT,
		OpcuaDataType_USINT,
		OpcuaDataType_UINT,
		OpcuaDataType_UDINT,
		OpcuaDataType_ULINT,
		OpcuaDataType_REAL,
		OpcuaDataType_LREAL,
		OpcuaDataType_TIME,
		OpcuaDataType_LTIME,
		OpcuaDataType_DATE,
		OpcuaDataType_LDATE,
		OpcuaDataType_TIME_OF_DAY,
		OpcuaDataType_LTIME_OF_DAY,
		OpcuaDataType_DATE_AND_TIME,
		OpcuaDataType_LDATE_AND_TIME,
		OpcuaDataType_CHAR,
		OpcuaDataType_WCHAR,
		OpcuaDataType_STRING,
	}
}

func (e OpcuaDataType) VariantType() uint8 {
	switch e {
	case "BOOL":
		{ /* '"BOOL"' */
			return 1
		}
	case "BYTE":
		{ /* '"BYTE"' */
			return 3
		}
	case "CHAR":
		{ /* '"CHAR"' */
			return 1
		}
	case "DATE":
		{ /* '"DATE"' */
			return 1
		}
	case "DATE_AND_TIME":
		{ /* '"DATE_AND_TIME"' */
			return 13
		}
	case "DINT":
		{ /* '"DINT"' */
			return 6
		}
	case "INT":
		{ /* '"INT"' */
			return 4
		}
	case "LDATE":
		{ /* '"LDATE"' */
			return 1
		}
	case "LDATE_AND_TIME":
		{ /* '"LDATE_AND_TIME"' */
			return 1
		}
	case "LINT":
		{ /* '"LINT"' */
			return 8
		}
	case "LREAL":
		{ /* '"LREAL"' */
			return 11
		}
	case "LTIME":
		{ /* '"LTIME"' */
			return 1
		}
	case "LTIME_OF_DAY":
		{ /* '"LTIME_OF_DAY"' */
			return 1
		}
	case "NULL":
		{ /* '"NULL"' */
			return 0
		}
	case "REAL":
		{ /* '"REAL"' */
			return 10
		}
	case "SINT":
		{ /* '"SINT"' */
			return 2
		}
	case "STRING":
		{ /* '"STRING"' */
			return 12
		}
	case "TIME":
		{ /* '"TIME"' */
			return 1
		}
	case "TIME_OF_DAY":
		{ /* '"TIME_OF_DAY"' */
			return 1
		}
	case "UDINT":
		{ /* '"UDINT"' */
			return 7
		}
	case "UINT":
		{ /* '"UINT"' */
			return 5
		}
	case "ULINT":
		{ /* '"ULINT"' */
			return 9
		}
	case "USINT":
		{ /* '"USINT"' */
			return 3
		}
	case "WCHAR":
		{ /* '"WCHAR"' */
			return 1
		}
	default:
		{
			return 0
		}
	}
}

func OpcuaDataTypeFirstEnumForFieldVariantType(value uint8) (enum OpcuaDataType, ok bool) {
	for _, sizeValue := range OpcuaDataTypeValues {
		if sizeValue.VariantType() == value {
			return sizeValue, true
		}
	}
	return "", false
}
func OpcuaDataTypeByValue(value string) (enum OpcuaDataType, ok bool) {
	switch value {
	case "BOOL":
		return OpcuaDataType_BOOL, true
	case "BYTE":
		return OpcuaDataType_BYTE, true
	case "CHAR":
		return OpcuaDataType_CHAR, true
	case "DATE":
		return OpcuaDataType_DATE, true
	case "DATE_AND_TIME":
		return OpcuaDataType_DATE_AND_TIME, true
	case "DINT":
		return OpcuaDataType_DINT, true
	case "INT":
		return OpcuaDataType_INT, true
	case "LDATE":
		return OpcuaDataType_LDATE, true
	case "LDATE_AND_TIME":
		return OpcuaDataType_LDATE_AND_TIME, true
	case "LINT":
		return OpcuaDataType_LINT, true
	case "LREAL":
		return OpcuaDataType_LREAL, true
	case "LTIME":
		return OpcuaDataType_LTIME, true
	case "LTIME_OF_DAY":
		return OpcuaDataType_LTIME_OF_DAY, true
	case "NULL":
		return OpcuaDataType_NULL, true
	case "REAL":
		return OpcuaDataType_REAL, true
	case "SINT":
		return OpcuaDataType_SINT, true
	case "STRING":
		return OpcuaDataType_STRING, true
	case "TIME":
		return OpcuaDataType_TIME, true
	case "TIME_OF_DAY":
		return OpcuaDataType_TIME_OF_DAY, true
	case "UDINT":
		return OpcuaDataType_UDINT, true
	case "UINT":
		return OpcuaDataType_UINT, true
	case "ULINT":
		return OpcuaDataType_ULINT, true
	case "USINT":
		return OpcuaDataType_USINT, true
	case "WCHAR":
		return OpcuaDataType_WCHAR, true
	}
	return "", false
}

func OpcuaDataTypeByName(value string) (enum OpcuaDataType, ok bool) {
	switch value {
	case "BOOL":
		return OpcuaDataType_BOOL, true
	case "BYTE":
		return OpcuaDataType_BYTE, true
	case "CHAR":
		return OpcuaDataType_CHAR, true
	case "DATE":
		return OpcuaDataType_DATE, true
	case "DATE_AND_TIME":
		return OpcuaDataType_DATE_AND_TIME, true
	case "DINT":
		return OpcuaDataType_DINT, true
	case "INT":
		return OpcuaDataType_INT, true
	case "LDATE":
		return OpcuaDataType_LDATE, true
	case "LDATE_AND_TIME":
		return OpcuaDataType_LDATE_AND_TIME, true
	case "LINT":
		return OpcuaDataType_LINT, true
	case "LREAL":
		return OpcuaDataType_LREAL, true
	case "LTIME":
		return OpcuaDataType_LTIME, true
	case "LTIME_OF_DAY":
		return OpcuaDataType_LTIME_OF_DAY, true
	case "NULL":
		return OpcuaDataType_NULL, true
	case "REAL":
		return OpcuaDataType_REAL, true
	case "SINT":
		return OpcuaDataType_SINT, true
	case "STRING":
		return OpcuaDataType_STRING, true
	case "TIME":
		return OpcuaDataType_TIME, true
	case "TIME_OF_DAY":
		return OpcuaDataType_TIME_OF_DAY, true
	case "UDINT":
		return OpcuaDataType_UDINT, true
	case "UINT":
		return OpcuaDataType_UINT, true
	case "ULINT":
		return OpcuaDataType_ULINT, true
	case "USINT":
		return OpcuaDataType_USINT, true
	case "WCHAR":
		return OpcuaDataType_WCHAR, true
	}
	return "", false
}

func OpcuaDataTypeKnows(value string) bool {
	for _, typeValue := range OpcuaDataTypeValues {
		if string(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaDataType(structType any) OpcuaDataType {
	castFunc := func(typ any) OpcuaDataType {
		if sOpcuaDataType, ok := typ.(OpcuaDataType); ok {
			return sOpcuaDataType
		}
		return ""
	}
	return castFunc(structType)
}

func (m OpcuaDataType) GetLengthInBits(ctx context.Context) uint16 {
	return 0
}

func (m OpcuaDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaDataTypeParse(ctx context.Context, theBytes []byte) (OpcuaDataType, error) {
	return OpcuaDataTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaDataTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaDataType, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadString("OpcuaDataType", uint32(112), utils.WithEncoding("UTF-8"))
	if err != nil {
		return "", errors.Wrap(err, "error reading OpcuaDataType")
	}
	if enum, ok := OpcuaDataTypeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaDataType")
		return OpcuaDataType(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteString("OpcuaDataType", uint32(112), string(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()), utils.WithEncoding("UTF-8)"))
}

func (e OpcuaDataType) GetValue() string {
	return string(e)
}

func (e OpcuaDataType) GetVariantType() uint8 {
	return e.VariantType()
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaDataType) PLC4XEnumName() string {
	switch e {
	case OpcuaDataType_BOOL:
		return "BOOL"
	case OpcuaDataType_BYTE:
		return "BYTE"
	case OpcuaDataType_CHAR:
		return "CHAR"
	case OpcuaDataType_DATE:
		return "DATE"
	case OpcuaDataType_DATE_AND_TIME:
		return "DATE_AND_TIME"
	case OpcuaDataType_DINT:
		return "DINT"
	case OpcuaDataType_INT:
		return "INT"
	case OpcuaDataType_LDATE:
		return "LDATE"
	case OpcuaDataType_LDATE_AND_TIME:
		return "LDATE_AND_TIME"
	case OpcuaDataType_LINT:
		return "LINT"
	case OpcuaDataType_LREAL:
		return "LREAL"
	case OpcuaDataType_LTIME:
		return "LTIME"
	case OpcuaDataType_LTIME_OF_DAY:
		return "LTIME_OF_DAY"
	case OpcuaDataType_NULL:
		return "NULL"
	case OpcuaDataType_REAL:
		return "REAL"
	case OpcuaDataType_SINT:
		return "SINT"
	case OpcuaDataType_STRING:
		return "STRING"
	case OpcuaDataType_TIME:
		return "TIME"
	case OpcuaDataType_TIME_OF_DAY:
		return "TIME_OF_DAY"
	case OpcuaDataType_UDINT:
		return "UDINT"
	case OpcuaDataType_UINT:
		return "UINT"
	case OpcuaDataType_ULINT:
		return "ULINT"
	case OpcuaDataType_USINT:
		return "USINT"
	case OpcuaDataType_WCHAR:
		return "WCHAR"
	}
	return fmt.Sprintf("Unknown(%v)", string(e))
}

func (e OpcuaDataType) String() string {
	return e.PLC4XEnumName()
}
