/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"encoding/binary"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/codegen"
	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ConnectionStateRequest is the corresponding interface of ConnectionStateRequest
type ConnectionStateRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	KnxNetIpMessage
	// GetCommunicationChannelId returns CommunicationChannelId (property field)
	GetCommunicationChannelId() uint8
	// GetHpaiControlEndpoint returns HpaiControlEndpoint (property field)
	GetHpaiControlEndpoint() HPAIControlEndpoint
	// IsConnectionStateRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsConnectionStateRequest()
	// CreateBuilder creates a ConnectionStateRequestBuilder
	CreateConnectionStateRequestBuilder() ConnectionStateRequestBuilder
}

// _ConnectionStateRequest is the data-structure of this message
type _ConnectionStateRequest struct {
	KnxNetIpMessageContract
	CommunicationChannelId uint8
	HpaiControlEndpoint    HPAIControlEndpoint
	// Reserved Fields
	reservedField0 *uint8
}

var _ ConnectionStateRequest = (*_ConnectionStateRequest)(nil)
var _ KnxNetIpMessageRequirements = (*_ConnectionStateRequest)(nil)

// NewConnectionStateRequest factory function for _ConnectionStateRequest
func NewConnectionStateRequest(communicationChannelId uint8, hpaiControlEndpoint HPAIControlEndpoint) *_ConnectionStateRequest {
	if hpaiControlEndpoint == nil {
		panic("hpaiControlEndpoint of type HPAIControlEndpoint for ConnectionStateRequest must not be nil")
	}
	_result := &_ConnectionStateRequest{
		KnxNetIpMessageContract: NewKnxNetIpMessage(),
		CommunicationChannelId:  communicationChannelId,
		HpaiControlEndpoint:     hpaiControlEndpoint,
	}
	_result.KnxNetIpMessageContract.(*_KnxNetIpMessage)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// ConnectionStateRequestBuilder is a builder for ConnectionStateRequest
type ConnectionStateRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(communicationChannelId uint8, hpaiControlEndpoint HPAIControlEndpoint) ConnectionStateRequestBuilder
	// WithCommunicationChannelId adds CommunicationChannelId (property field)
	WithCommunicationChannelId(uint8) ConnectionStateRequestBuilder
	// WithHpaiControlEndpoint adds HpaiControlEndpoint (property field)
	WithHpaiControlEndpoint(HPAIControlEndpoint) ConnectionStateRequestBuilder
	// WithHpaiControlEndpointBuilder adds HpaiControlEndpoint (property field) which is build by the builder
	WithHpaiControlEndpointBuilder(func(HPAIControlEndpointBuilder) HPAIControlEndpointBuilder) ConnectionStateRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() KnxNetIpMessageBuilder
	// Build builds the ConnectionStateRequest or returns an error if something is wrong
	Build() (ConnectionStateRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() ConnectionStateRequest
}

// NewConnectionStateRequestBuilder() creates a ConnectionStateRequestBuilder
func NewConnectionStateRequestBuilder() ConnectionStateRequestBuilder {
	return &_ConnectionStateRequestBuilder{_ConnectionStateRequest: new(_ConnectionStateRequest)}
}

type _ConnectionStateRequestBuilder struct {
	*_ConnectionStateRequest

	parentBuilder *_KnxNetIpMessageBuilder

	collectedErr []error
}

var _ (ConnectionStateRequestBuilder) = (*_ConnectionStateRequestBuilder)(nil)

func (b *_ConnectionStateRequestBuilder) setParent(contract KnxNetIpMessageContract) {
	b.KnxNetIpMessageContract = contract
	contract.(*_KnxNetIpMessage)._SubType = b._ConnectionStateRequest
}

func (b *_ConnectionStateRequestBuilder) WithMandatoryFields(communicationChannelId uint8, hpaiControlEndpoint HPAIControlEndpoint) ConnectionStateRequestBuilder {
	return b.WithCommunicationChannelId(communicationChannelId).WithHpaiControlEndpoint(hpaiControlEndpoint)
}

func (b *_ConnectionStateRequestBuilder) WithCommunicationChannelId(communicationChannelId uint8) ConnectionStateRequestBuilder {
	b.CommunicationChannelId = communicationChannelId
	return b
}

func (b *_ConnectionStateRequestBuilder) WithHpaiControlEndpoint(hpaiControlEndpoint HPAIControlEndpoint) ConnectionStateRequestBuilder {
	b.HpaiControlEndpoint = hpaiControlEndpoint
	return b
}

func (b *_ConnectionStateRequestBuilder) WithHpaiControlEndpointBuilder(builderSupplier func(HPAIControlEndpointBuilder) HPAIControlEndpointBuilder) ConnectionStateRequestBuilder {
	builder := builderSupplier(b.HpaiControlEndpoint.CreateHPAIControlEndpointBuilder())
	var err error
	b.HpaiControlEndpoint, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "HPAIControlEndpointBuilder failed"))
	}
	return b
}

func (b *_ConnectionStateRequestBuilder) Build() (ConnectionStateRequest, error) {
	if b.HpaiControlEndpoint == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'hpaiControlEndpoint' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._ConnectionStateRequest.deepCopy(), nil
}

func (b *_ConnectionStateRequestBuilder) MustBuild() ConnectionStateRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_ConnectionStateRequestBuilder) Done() KnxNetIpMessageBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewKnxNetIpMessageBuilder().(*_KnxNetIpMessageBuilder)
	}
	return b.parentBuilder
}

func (b *_ConnectionStateRequestBuilder) buildForKnxNetIpMessage() (KnxNetIpMessage, error) {
	return b.Build()
}

func (b *_ConnectionStateRequestBuilder) DeepCopy() any {
	_copy := b.CreateConnectionStateRequestBuilder().(*_ConnectionStateRequestBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateConnectionStateRequestBuilder creates a ConnectionStateRequestBuilder
func (b *_ConnectionStateRequest) CreateConnectionStateRequestBuilder() ConnectionStateRequestBuilder {
	if b == nil {
		return NewConnectionStateRequestBuilder()
	}
	return &_ConnectionStateRequestBuilder{_ConnectionStateRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ConnectionStateRequest) GetMsgType() uint16 {
	return 0x0207
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ConnectionStateRequest) GetParent() KnxNetIpMessageContract {
	return m.KnxNetIpMessageContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ConnectionStateRequest) GetCommunicationChannelId() uint8 {
	return m.CommunicationChannelId
}

func (m *_ConnectionStateRequest) GetHpaiControlEndpoint() HPAIControlEndpoint {
	return m.HpaiControlEndpoint
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastConnectionStateRequest(structType any) ConnectionStateRequest {
	if casted, ok := structType.(ConnectionStateRequest); ok {
		return casted
	}
	if casted, ok := structType.(*ConnectionStateRequest); ok {
		return *casted
	}
	return nil
}

func (m *_ConnectionStateRequest) GetTypeName() string {
	return "ConnectionStateRequest"
}

func (m *_ConnectionStateRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.KnxNetIpMessageContract.(*_KnxNetIpMessage).getLengthInBits(ctx))

	// Simple field (communicationChannelId)
	lengthInBits += 8

	// Reserved Field (reserved)
	lengthInBits += 8

	// Simple field (hpaiControlEndpoint)
	lengthInBits += m.HpaiControlEndpoint.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ConnectionStateRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_ConnectionStateRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_KnxNetIpMessage) (__connectionStateRequest ConnectionStateRequest, err error) {
	m.KnxNetIpMessageContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ConnectionStateRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ConnectionStateRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	communicationChannelId, err := ReadSimpleField(ctx, "communicationChannelId", ReadUnsignedByte(readBuffer, uint8(8)), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'communicationChannelId' field"))
	}
	m.CommunicationChannelId = communicationChannelId

	reservedField0, err := ReadReservedField(ctx, "reserved", ReadUnsignedByte(readBuffer, uint8(8)), uint8(0x00), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing reserved field"))
	}
	m.reservedField0 = reservedField0

	hpaiControlEndpoint, err := ReadSimpleField[HPAIControlEndpoint](ctx, "hpaiControlEndpoint", ReadComplex[HPAIControlEndpoint](HPAIControlEndpointParseWithBuffer, readBuffer), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'hpaiControlEndpoint' field"))
	}
	m.HpaiControlEndpoint = hpaiControlEndpoint

	if closeErr := readBuffer.CloseContext("ConnectionStateRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ConnectionStateRequest")
	}

	return m, nil
}

func (m *_ConnectionStateRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))), utils.WithByteOrderForByteBasedBuffer(binary.BigEndian))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ConnectionStateRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ConnectionStateRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ConnectionStateRequest")
		}

		if err := WriteSimpleField[uint8](ctx, "communicationChannelId", m.GetCommunicationChannelId(), WriteUnsignedByte(writeBuffer, 8), codegen.WithByteOrder(binary.BigEndian)); err != nil {
			return errors.Wrap(err, "Error serializing 'communicationChannelId' field")
		}

		if err := WriteReservedField[uint8](ctx, "reserved", uint8(0x00), WriteUnsignedByte(writeBuffer, 8), codegen.WithByteOrder(binary.BigEndian)); err != nil {
			return errors.Wrap(err, "Error serializing 'reserved' field number 1")
		}

		if err := WriteSimpleField[HPAIControlEndpoint](ctx, "hpaiControlEndpoint", m.GetHpaiControlEndpoint(), WriteComplex[HPAIControlEndpoint](writeBuffer), codegen.WithByteOrder(binary.BigEndian)); err != nil {
			return errors.Wrap(err, "Error serializing 'hpaiControlEndpoint' field")
		}

		if popErr := writeBuffer.PopContext("ConnectionStateRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ConnectionStateRequest")
		}
		return nil
	}
	return m.KnxNetIpMessageContract.(*_KnxNetIpMessage).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ConnectionStateRequest) IsConnectionStateRequest() {}

func (m *_ConnectionStateRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_ConnectionStateRequest) deepCopy() *_ConnectionStateRequest {
	if m == nil {
		return nil
	}
	_ConnectionStateRequestCopy := &_ConnectionStateRequest{
		m.KnxNetIpMessageContract.(*_KnxNetIpMessage).deepCopy(),
		m.CommunicationChannelId,
		utils.DeepCopy[HPAIControlEndpoint](m.HpaiControlEndpoint),
		m.reservedField0,
	}
	_ConnectionStateRequestCopy.KnxNetIpMessageContract.(*_KnxNetIpMessage)._SubType = m
	return _ConnectionStateRequestCopy
}

func (m *_ConnectionStateRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
