/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.apache.pdfbox.debugger.ui.MenuBase;
import org.apache.pdfbox.rendering.RenderDestination;

public final class RenderDestinationMenu
extends MenuBase {
    public static final String RENDER_DESTINATION_EXPORT = "Export";
    public static final String RENDER_DESTINATION_PRINT = "Print";
    public static final String RENDER_DESTINATION_VIEW = "View";
    private static RenderDestinationMenu instance;
    private JRadioButtonMenuItem exportItem;
    private JRadioButtonMenuItem printItem;
    private JRadioButtonMenuItem viewItem;

    private RenderDestinationMenu() {
        this.setMenu(this.createMenu());
    }

    public static RenderDestinationMenu getInstance() {
        if (instance == null) {
            instance = new RenderDestinationMenu();
        }
        return instance;
    }

    public void setRenderDestinationSelection(String selection) {
        if (RENDER_DESTINATION_EXPORT.equals(selection)) {
            this.exportItem.setSelected(true);
        } else if (RENDER_DESTINATION_PRINT.equals(selection)) {
            this.printItem.setSelected(true);
        } else if (RENDER_DESTINATION_VIEW.equals(selection)) {
            this.viewItem.setSelected(true);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static boolean isRenderDestinationMenu(String actionCommand) {
        return RENDER_DESTINATION_EXPORT.equals(actionCommand) || RENDER_DESTINATION_PRINT.equals(actionCommand) || RENDER_DESTINATION_VIEW.equals(actionCommand);
    }

    public static RenderDestination getRenderDestination() {
        if (RenderDestinationMenu.instance.printItem.isSelected()) {
            return RenderDestination.PRINT;
        }
        if (RenderDestinationMenu.instance.viewItem.isSelected()) {
            return RenderDestination.VIEW;
        }
        return RenderDestination.EXPORT;
    }

    public static RenderDestination getRenderDestination(String actionCommand) {
        if (RENDER_DESTINATION_EXPORT.equals(actionCommand)) {
            return RenderDestination.EXPORT;
        }
        if (RENDER_DESTINATION_PRINT.equals(actionCommand)) {
            return RenderDestination.PRINT;
        }
        if (RENDER_DESTINATION_VIEW.equals(actionCommand)) {
            return RenderDestination.VIEW;
        }
        throw new IllegalArgumentException();
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu();
        menu.setText("Render destination");
        this.exportItem = new JRadioButtonMenuItem();
        this.printItem = new JRadioButtonMenuItem();
        this.viewItem = new JRadioButtonMenuItem();
        this.exportItem.setSelected(true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.exportItem);
        bg.add(this.printItem);
        bg.add(this.viewItem);
        this.exportItem.setText(RENDER_DESTINATION_EXPORT);
        this.printItem.setText(RENDER_DESTINATION_PRINT);
        this.viewItem.setText(RENDER_DESTINATION_VIEW);
        menu.add(this.exportItem);
        menu.add(this.printItem);
        menu.add(this.viewItem);
        return menu;
    }
}

