/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.service;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.service.ManualImplementationLoaderService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.util.WebBeansUtil;

public class DefaultLoaderService
implements LoaderService {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(DefaultLoaderService.class);
    private static final boolean JAVA_6_AVAILABLE = DefaultLoaderService.isJava6();

    public <T> List<T> load(Class<T> serviceType) {
        return this.load(serviceType, WebBeansUtil.getCurrentClassLoader());
    }

    public <T> List<T> load(Class<T> serviceType, ClassLoader classLoader) {
        if (JAVA_6_AVAILABLE) {
            ArrayList<T> result = new ArrayList<T>();
            try {
                ServiceLoader<T> services = ServiceLoader.load(serviceType, classLoader);
                for (T service : services) {
                    result.add(service);
                }
            }
            catch (Error error) {
                logger.log(Level.SEVERE, "Problem while loading CDI Extensions", error);
                throw new WebBeansConfigurationException("Problem while loading CDI Extensions", error);
            }
            return result;
        }
        return new ManualImplementationLoaderService<T>(serviceType, classLoader).loadServiceImplementations();
    }

    private static boolean isJava6() {
        try {
            ServiceLoader.class.getName();
            return true;
        }
        catch (NoClassDefFoundError error) {
            logger.info("Using Java 5 compatibility mode, because didn't find ServiceLoader: " + error);
            return false;
        }
    }
}

