/****************************************************************************
 * boards/arm64/bcm2711/raspberrypi-4b/include/board.h
 *
 * Author: Matteo Golin <matteo.golin@gmail.com>
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __BOARDS_ARM64_BCM2711_RPI4B_INCLUDE_BOARD_H
#define __BOARDS_ARM64_BCM2711_RPI4B_INCLUDE_BOARD_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* Onboard LEDs */

#define STATUS_LED (42) /* Green LED */
#define POWER_LED (130) /* Red LED */

/* Auto-LED definitions */

#define LED_STARTED              0
#define LED_HEAPALLOCATE         0
#define LED_IRQSENABLED          0
#define LED_STACKCREATED         1
#define LED_INIRQ                2
#define LED_SIGNAL               2
#define LED_ASSERTION            3
#define LED_PANIC                4

/* TODO: define all the GPIO pins properly */

#define BOARD_NGPIOOUT 1
#define BOARD_NGPIOIN 1
#define BOARD_NGPIOINT 0

/* Micro SD card slot number to use */

#define MICROSD_SLOTNO 0

#endif /* __BOARDS_ARM64_BCM2711_RPI4B_INCLUDE_BOARD_H */
