/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.revision.entity;

import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="The revision information for an entity managed through the REST API.")
public class RevisionInfo {
    private String clientId;
    private Long version;
    private String lastModifier;

    public RevisionInfo() {
    }

    public RevisionInfo(String clientId, Long version) {
        this(clientId, version, null);
    }

    public RevisionInfo(String clientId, Long version, String lastModifier) {
        this.clientId = clientId;
        this.version = version;
        this.lastModifier = lastModifier;
    }

    @Schema(description="A client identifier used to make a request. By including a client identifier, the API can allow multiple requests without needing the current revision. Due to the asynchronous nature of requests/responses this was implemented to allow the client to make numerous requests without having to wait for the previous response to come back.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Schema(description="NiFi Registry employs an optimistic locking strategy where the client must include a revision in their request when performing an update. In a response to a mutable flow request, this field represents the updated base version.")
    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    @Schema(description="The user that last modified the entity.", accessMode=Schema.AccessMode.READ_ONLY)
    public String getLastModifier() {
        return this.lastModifier;
    }

    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }
}

