/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.internal.BucketUtils;
import software.amazon.awssdk.services.s3.model.CreateBucketConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;

@SdkInternalApi
public final class CreateBucketInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest sdkRequest = context.request();
        if (sdkRequest instanceof CreateBucketRequest) {
            CreateBucketRequest request = (CreateBucketRequest)sdkRequest;
            this.validateBucketNameIsS3Compatible(request.bucket());
            if (request.createBucketConfiguration() == null) {
                return this.addLocationConstraintToRequest(request, executionAttributes, (CreateBucketConfiguration)CreateBucketConfiguration.builder().build());
            }
            CreateBucketConfiguration bucketConfiguration = request.createBucketConfiguration();
            if (bucketConfiguration.locationConstraint() == null && bucketConfiguration.location() == null) {
                return this.addLocationConstraintToRequest(request, executionAttributes, bucketConfiguration);
            }
        }
        return sdkRequest;
    }

    private SdkRequest addLocationConstraintToRequest(CreateBucketRequest request, ExecutionAttributes executionAttributes, CreateBucketConfiguration configuration) {
        Region region = (Region)executionAttributes.getAttribute(AwsExecutionAttribute.AWS_REGION);
        return (SdkRequest)request.copy(r -> r.createBucketConfiguration(this.setLocationConstraint(region, configuration)));
    }

    private CreateBucketConfiguration setLocationConstraint(Region region, CreateBucketConfiguration configuration) {
        if (region.equals(Region.US_EAST_1)) {
            return null;
        }
        return (CreateBucketConfiguration)configuration.copy(c -> c.locationConstraint(region.id()).build());
    }

    private void validateBucketNameIsS3Compatible(String bucketName) {
        BucketUtils.isValidDnsBucketName(bucketName, true);
    }
}

