/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.text.Document;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.tools.javac.api.ClientCodeWrapper;
import jpt.sun.tools.javac.api.DiagnosticFormatter;
import jpt.sun.tools.javac.api.JavacTaskImpl;
import jpt.sun.tools.javac.util.JCDiagnostic;
import jpt.sun.tools.javac.util.Log;
import jpt30.tools.Diagnostic;
import jpt30.tools.DiagnosticListener;
import jpt30.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.java.source.JavaFileFilterQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.AbstractSourceFileObject;
import org.netbeans.modules.java.source.parsing.DocPositionRegion;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public final class CompilationInfoImpl {
    private JavaSource.Phase phase = JavaSource.Phase.MODIFIED;
    private CompilationUnitTree compilationUnit;
    private JavacTaskImpl javacTask;
    private DiagnosticListener<JavaFileObject> diagnosticListener;
    private final ClasspathInfo cpInfo;
    private Pair<DocPositionRegion, MethodTree> changedMethod;
    private final FileObject file;
    private final FileObject root;
    final AbstractSourceFileObject jfo;
    private Snapshot snapshot;
    private Reference<Snapshot> partialReparseLastGoodSnapshot;
    private final JavacParser parser;
    private final boolean isClassFile;
    private final boolean isDetached;
    JavaSource.Phase parserCrashed = JavaSource.Phase.UP_TO_DATE;
    private final Map<CompilationInfo.CacheClearPolicy, Map<Object, Object>> userCache = new EnumMap<CompilationInfo.CacheClearPolicy, Map<Object, Object>>(CompilationInfo.CacheClearPolicy.class);
    private Map<JavaFileObject, CompilationUnitTree> parsedTrees;
    private Map<FileObject, AbstractSourceFileObject> ide2javacFileObject;
    private Map<FileObject, Snapshot> fileObject2Snapshot;
    private boolean incomplete;

    public CompilationInfoImpl(JavacParser parser, FileObject file, FileObject root, JavacTaskImpl javacTask, DiagnosticListener<JavaFileObject> diagnosticListener, Snapshot snapshot, boolean detached, Map<FileObject, AbstractSourceFileObject> ide2javacFileObject, Map<FileObject, Snapshot> fileObject2Snapshot) throws IOException {
        assert (parser != null);
        this.parser = parser;
        this.cpInfo = parser.getClasspathInfo();
        assert (this.cpInfo != null);
        this.file = file;
        this.root = root;
        this.snapshot = snapshot;
        this.partialReparseLastGoodSnapshot = new SoftReference<Snapshot>(snapshot);
        assert (file == null || snapshot != null);
        this.javacTask = javacTask;
        this.diagnosticListener = diagnosticListener;
        this.isClassFile = false;
        this.isDetached = detached;
        this.ide2javacFileObject = ide2javacFileObject;
        this.fileObject2Snapshot = fileObject2Snapshot;
        this.jfo = file != null ? this.getSourceFileObject(file) : null;
    }

    private AbstractSourceFileObject getSourceFileObject(FileObject file) throws IOException {
        AbstractSourceFileObject result = this.ide2javacFileObject.get(file);
        if (result == null) {
            Snapshot snapshot = this.fileObject2Snapshot.get(file);
            result = snapshot != null ? FileObjects.sourceFileObject(file, this.root, JavaFileFilterQuery.getFilter(file), snapshot.getText()) : FileObjects.sourceFileObject(file, this.root);
            this.ide2javacFileObject.put(file, result);
        }
        return result;
    }

    CompilationInfoImpl(@NonNull ClasspathInfo cpInfo, @NullAllowed FileObject root) {
        assert (cpInfo != null);
        this.parser = null;
        this.file = null;
        this.root = root;
        this.jfo = null;
        this.snapshot = null;
        this.cpInfo = cpInfo;
        this.isClassFile = false;
        this.isDetached = false;
    }

    CompilationInfoImpl(ClasspathInfo cpInfo, FileObject file, FileObject root) throws IOException {
        assert (cpInfo != null);
        assert (file != null);
        assert (root != null);
        this.parser = null;
        this.file = file;
        this.root = root;
        this.jfo = FileObjects.sourceFileObject(file, root);
        this.snapshot = null;
        this.cpInfo = cpInfo;
        this.isClassFile = true;
        this.isDetached = false;
    }

    public void update(Snapshot snapshot) throws IOException {
        assert (snapshot != null);
        this.jfo.update(snapshot.getText());
        this.snapshot = snapshot;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public Snapshot getPartialReparseLastGoodSnapshot() {
        return this.partialReparseLastGoodSnapshot != null ? this.partialReparseLastGoodSnapshot.get() : null;
    }

    public void setPartialReparseLastGoodSnapshot(Snapshot snapshot) {
        this.partialReparseLastGoodSnapshot = new SoftReference<Snapshot>(snapshot);
    }

    public JavaSource.Phase getPhase() {
        return this.phase;
    }

    public Pair<DocPositionRegion, MethodTree> getChangedTree() {
        return this.changedMethod;
    }

    public CompilationUnitTree getCompilationUnit() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        if (this.phase.compareTo(JavaSource.Phase.PARSED) < 0) {
            throw new IllegalStateException("Cannot call getCompilationUnit() if current phase < JavaSource.Phase.PARSED. You must call toPhase(Phase.PARSED) first.");
        }
        return this.compilationUnit;
    }

    public String getText() {
        if (!this.hasSource()) {
            throw new IllegalStateException();
        }
        try {
            return this.jfo.getCharContent(false).toString();
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace(ioe);
            return null;
        }
    }

    public TokenHierarchy<?> getTokenHierarchy() {
        if (!this.hasSource()) {
            throw new IllegalStateException();
        }
        try {
            return this.jfo.getTokenHierarchy();
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace(ioe);
            return null;
        }
    }

    public List<Diagnostic> getDiagnostics() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        DiagnosticListenerImpl.Diagnostics errors = ((DiagnosticListenerImpl)this.diagnosticListener).getErrors(this.jfo);
        List<Diagnostic<? extends JavaFileObject>> partialReparseErrors = ((DiagnosticListenerImpl)this.diagnosticListener).partialReparseErrors;
        List<Diagnostic<? extends JavaFileObject>> affectedErrors = ((DiagnosticListenerImpl)this.diagnosticListener).affectedErrors;
        int errorsSize = 0;
        for (Collection err : errors.values()) {
            errorsSize += err.size();
        }
        ArrayList<Diagnostic> localErrors = new ArrayList<Diagnostic>(errorsSize + (partialReparseErrors == null ? 0 : partialReparseErrors.size()) + (affectedErrors == null ? 0 : affectedErrors.size()));
        DiagnosticFormatter<JCDiagnostic> formatter = Log.instance(this.javacTask.getContext()).getDiagnosticFormatter();
        DiagnosticListenerImpl.DiagNode node = errors.first;
        while (node != null) {
            localErrors.add(RichDiagnostic.wrap(node.diag, formatter));
            node = node.next;
        }
        if (partialReparseErrors != null) {
            for (Diagnostic<? extends JavaFileObject> d : partialReparseErrors) {
                localErrors.add(RichDiagnostic.wrap(d, formatter));
            }
        }
        if (affectedErrors != null) {
            for (Diagnostic<? extends JavaFileObject> d : affectedErrors) {
                localErrors.add(RichDiagnostic.wrap(d, formatter));
            }
        }
        return localErrors;
    }

    public ClasspathInfo getClasspathInfo() {
        return this.cpInfo;
    }

    public JavacParser getParser() {
        return this.parser;
    }

    public FileObject getFileObject() {
        return this.file;
    }

    public FileObject getRoot() {
        return this.root;
    }

    public boolean isClassFile() {
        return this.isClassFile;
    }

    public Document getDocument() {
        Source source;
        if (this.file == null) {
            return null;
        }
        if (!this.file.isValid()) {
            return null;
        }
        Source source2 = source = this.snapshot != null ? this.snapshot.getSource() : null;
        if (source != null) {
            return source.getDocument(false);
        }
        return null;
    }

    public Map<JavaFileObject, CompilationUnitTree> getParsedTrees() {
        return this.parsedTrees;
    }

    public JavaSource.Phase toPhase(JavaSource.Phase phase) throws IOException {
        return this.toPhase(phase, Collections.emptyList());
    }

    public JavaSource.Phase toPhase(JavaSource.Phase phase, List<FileObject> forcedSources) throws IOException {
        if (phase == JavaSource.Phase.MODIFIED) {
            throw new IllegalArgumentException("Invalid phase: " + phase);
        }
        if (!this.hasSource()) {
            JavaSource.Phase currentPhase = this.getPhase();
            if (currentPhase.compareTo(phase) < 0) {
                this.setPhase(phase);
                if (currentPhase == JavaSource.Phase.MODIFIED) {
                    this.getJavacTask().getElements().getTypeElement("java.lang.Object");
                }
            }
            return phase;
        }
        JavaSource.Phase currentPhase = this.parser.moveToPhase(phase, this, forcedSources, false);
        return currentPhase.compareTo(phase) < 0 ? currentPhase : phase;
    }

    public synchronized JavacTaskImpl getJavacTask() {
        try {
            return this.getJavacTask(Collections.emptyList());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public synchronized JavacTaskImpl getJavacTask(List<FileObject> forcedSources) throws IOException {
        if (this.javacTask == null) {
            ArrayList<AbstractSourceFileObject> jfos = new ArrayList<AbstractSourceFileObject>();
            if (this.jfo != null) {
                jfos.add(this.jfo);
                forcedSources.stream().map(fo -> this.runAndThrow(this::getSourceFileObject, fo)).forEach(jfos::add);
            }
            this.diagnosticListener = new DiagnosticListenerImpl(this.root, this.jfo, this.cpInfo);
            this.javacTask = JavacParser.createJavacTask(this.file, jfos, this.root, this.cpInfo, this.parser, this.diagnosticListener, this.isDetached);
        }
        return this.javacTask;
    }

    List<FileObject> getForcedSources() {
        return Collections.emptyList();
    }

    public Object getCachedValue(Object key) {
        for (Map<Object, Object> c : this.userCache.values()) {
            Object res = c.get(key);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void putCachedValue(Object key, Object value, CompilationInfo.CacheClearPolicy clearPolicy) {
        for (Map<Object, Object> c : this.userCache.values()) {
            c.remove(key);
        }
        this.userCache.computeIfAbsent(clearPolicy, k -> new HashMap()).put(key, value);
    }

    public void taskFinished() {
        this.userCache.remove((Object)CompilationInfo.CacheClearPolicy.ON_TASK_END);
    }

    public void dispose() {
        this.userCache.clear();
    }

    public DiagnosticListener<JavaFileObject> getDiagnosticListener() {
        return this.diagnosticListener;
    }

    void setPhase(JavaSource.Phase phase) {
        assert (phase != null);
        this.phase = phase;
    }

    void setChangedMethod(Pair<DocPositionRegion, MethodTree> changedMethod) {
        this.changedMethod = changedMethod;
        this.userCache.remove((Object)CompilationInfo.CacheClearPolicy.ON_TASK_END);
        this.userCache.remove((Object)CompilationInfo.CacheClearPolicy.ON_CHANGE);
    }

    void setCompilationUnit(CompilationUnitTree compilationUnit) {
        assert (compilationUnit != null);
        this.compilationUnit = compilationUnit;
    }

    public void setParsedTrees(Map<JavaFileObject, CompilationUnitTree> parsedTrees) {
        this.parsedTrees = parsedTrees;
    }

    private boolean hasSource() {
        return this.jfo != null && !this.isClassFile;
    }

    List<AbstractSourceFileObject> getFiles(List<FileObject> sourceFiles) throws IOException {
        return sourceFiles.stream().map(fo -> this.runAndThrow(this::getSourceFileObject, fo)).collect(Collectors.toList());
    }

    private <P, R> R runAndThrow(Convert<P, R> run, P p) {
        try {
            return run.run(p);
        }
        catch (Exception ex) {
            throw this.thrw(ex);
        }
    }

    private <T extends Exception> RuntimeException thrw(Exception e) throws T {
        throw e;
    }

    public Map<FileObject, AbstractSourceFileObject> getIde2javacFileObject() {
        return this.ide2javacFileObject;
    }

    public Map<FileObject, Snapshot> getFileObject2Snapshot() {
        return this.fileObject2Snapshot;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void markIncomplete() {
        this.incomplete = true;
    }

    @ClientCodeWrapper.Trusted
    public static class DiagnosticListenerImpl
    implements DiagnosticListener<JavaFileObject> {
        private final Map<JavaFileObject, Diagnostics> source2Errors;
        private final FileObject root;
        private final JavaFileObject jfo;
        private final ClasspathInfo cpInfo;
        private volatile List<Diagnostic<? extends JavaFileObject>> partialReparseErrors;
        private volatile boolean partialReparseRealErrors;
        private volatile List<Diagnostic<? extends JavaFileObject>> affectedErrors;
        private volatile int currentDelta;

        public DiagnosticListenerImpl(@NullAllowed FileObject root, @NullAllowed JavaFileObject jfo, @NonNull ClasspathInfo cpInfo) {
            this.root = root;
            this.jfo = jfo;
            this.cpInfo = cpInfo;
            this.source2Errors = new HashMap<JavaFileObject, Diagnostics>();
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> message) {
            if (this.partialReparseErrors != null) {
                if (this.jfo != null && this.jfo == message.getSource()) {
                    this.partialReparseErrors.add(message);
                    if (message.getKind() == Diagnostic.Kind.ERROR) {
                        this.partialReparseRealErrors = true;
                    }
                }
            } else {
                Diagnostics errors = this.getErrors(message.getSource());
                errors.add((int)message.getPosition(), message);
            }
        }

        private Diagnostics getErrors(JavaFileObject file) {
            Diagnostics errors;
            if (this.isIncompleteClassPath()) {
                if (this.root != null && JavaIndex.hasSourceCache(this.root.toURL(), false)) {
                    errors = this.source2Errors.get(file);
                    if (errors == null) {
                        errors = new Diagnostics();
                        this.source2Errors.put(file, errors);
                        if (this.jfo != null && this.jfo == file) {
                            errors.add(0, new IncompleteClassPath(this.jfo));
                        }
                    }
                } else {
                    errors = new Diagnostics();
                    if (this.jfo != null && this.jfo == file) {
                        errors.add(0, new IncompleteClassPath(this.jfo));
                    }
                }
            } else {
                errors = this.source2Errors.get(file);
                if (errors == null) {
                    errors = new Diagnostics();
                    this.source2Errors.put(file, errors);
                }
            }
            return errors;
        }

        public final boolean hasPartialReparseErrors() {
            return this.partialReparseErrors != null && this.partialReparseRealErrors;
        }

        public final void startPartialReparse(int from, int to) {
            if (this.partialReparseErrors == null) {
                this.partialReparseErrors = new ArrayList<Diagnostic<? extends JavaFileObject>>();
                Diagnostics errors = this.getErrors(this.jfo);
                SortedMap subMap = errors.subMap(from, to);
                subMap.values().forEach(value -> value.forEach(node -> errors.unlink((DiagNode)node)));
                subMap.clear();
                SortedMap tail = errors.tailMap(to);
                this.affectedErrors = new ArrayList<Diagnostic<? extends JavaFileObject>>(tail.size());
                HashSet tailNodes = new HashSet();
                Iterator it = tail.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    tailNodes.addAll((Collection)e.getValue());
                    it.remove();
                }
                DiagNode node = errors.first;
                while (node != null) {
                    if (tailNodes.contains(node)) {
                        errors.unlink(node);
                        JCDiagnostic diagnostic = (JCDiagnostic)node.diag;
                        if (diagnostic == null) {
                            throw new IllegalStateException("#184910: diagnostic == null " + DiagnosticListenerImpl.mapArraysToLists(Thread.getAllStackTraces()));
                        }
                        this.affectedErrors.add(new D(diagnostic));
                    }
                    node = node.next;
                }
            } else {
                this.partialReparseErrors.clear();
            }
            this.partialReparseRealErrors = false;
        }

        public final void endPartialReparse(int delta) {
            this.currentDelta += delta;
        }

        private static <A, B> Map<A, List<B>> mapArraysToLists(Map<? extends A, B[]> map) {
            HashMap<A, List<B>> result = new HashMap<A, List<B>>();
            for (Map.Entry<A, B[]> entry : map.entrySet()) {
                result.put(entry.getKey(), Arrays.asList(entry.getValue()));
            }
            return result;
        }

        private boolean isIncompleteClassPath() {
            return this.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT).getFlags().contains((Object)ClassPath.Flag.INCOMPLETE) || this.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE).getFlags().contains((Object)ClassPath.Flag.INCOMPLETE) || this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).getFlags().contains((Object)ClassPath.Flag.INCOMPLETE);
        }

        private static final class Diagnostics
        extends TreeMap<Integer, Collection<DiagNode>> {
            private DiagNode first;
            private DiagNode last;

            private Diagnostics() {
            }

            public void add(int pos, Diagnostic<? extends JavaFileObject> diag) {
                DiagNode node = new DiagNode(this.last, diag, null);
                this.computeIfAbsent((int)diag.getPosition(), k -> new ArrayList()).add(node);
                if (this.last != null) {
                    this.last.next = node;
                }
                this.last = node;
                if (this.first == null) {
                    this.first = node;
                }
            }

            private void unlink(DiagNode node) {
                if (node.next == null) {
                    this.last = node.prev;
                } else {
                    node.next.prev = node.prev;
                }
                if (node.prev == null) {
                    this.first = node.next;
                } else {
                    node.prev.next = node.next;
                }
            }
        }

        private static final class IncompleteClassPath
        implements Diagnostic<JavaFileObject> {
            private final JavaFileObject file;

            IncompleteClassPath(JavaFileObject file) {
                this.file = file;
            }

            @Override
            public Diagnostic.Kind getKind() {
                return Diagnostic.Kind.WARNING;
            }

            @Override
            public JavaFileObject getSource() {
                return this.file;
            }

            @Override
            public long getPosition() {
                return 0L;
            }

            @Override
            public long getStartPosition() {
                return this.getPosition();
            }

            @Override
            public long getEndPosition() {
                return this.getPosition();
            }

            @Override
            public long getLineNumber() {
                return this.getPosition();
            }

            @Override
            public long getColumnNumber() {
                return this.getPosition();
            }

            @Override
            public String getCode() {
                return "nb.classpath.incomplete";
            }

            @Override
            public String getMessage(Locale locale) {
                return NbBundle.getMessage(CompilationInfoImpl.class, "ERR_IncompleteClassPath");
            }
        }

        private static final class DiagNode {
            private Diagnostic<? extends JavaFileObject> diag;
            private DiagNode next;
            private DiagNode prev;

            private DiagNode(DiagNode prev, Diagnostic<? extends JavaFileObject> diag, DiagNode next) {
                this.diag = diag;
                this.next = next;
                this.prev = prev;
            }
        }

        private final class D
        implements Diagnostic {
            private final JCDiagnostic delegate;

            public D(JCDiagnostic delegate) {
                assert (delegate != null);
                this.delegate = delegate;
            }

            @Override
            public Diagnostic.Kind getKind() {
                return this.delegate.getKind();
            }

            public Object getSource() {
                return this.delegate.getSource();
            }

            @Override
            public long getPosition() {
                long ret = this.delegate.getPosition();
                return ret;
            }

            @Override
            public long getStartPosition() {
                long ret = this.delegate.getStartPosition();
                return ret;
            }

            @Override
            public long getEndPosition() {
                long ret = this.delegate.getEndPosition();
                return ret;
            }

            @Override
            public long getLineNumber() {
                return -1L;
            }

            @Override
            public long getColumnNumber() {
                return -1L;
            }

            @Override
            public String getCode() {
                return this.delegate.getCode();
            }

            @Override
            public String getMessage(Locale locale) {
                return this.delegate.getMessage(locale);
            }
        }
    }

    static final class RichDiagnostic
    implements Diagnostic {
        private final JCDiagnostic delegate;
        private final DiagnosticFormatter<JCDiagnostic> formatter;

        public RichDiagnostic(JCDiagnostic delegate, DiagnosticFormatter<JCDiagnostic> formatter) {
            this.delegate = delegate;
            this.formatter = formatter;
        }

        @Override
        public Diagnostic.Kind getKind() {
            return this.delegate.getKind();
        }

        public Object getSource() {
            return this.delegate.getSource();
        }

        @Override
        public long getPosition() {
            return this.delegate.getPosition();
        }

        @Override
        public long getStartPosition() {
            return this.delegate.getStartPosition();
        }

        @Override
        public long getEndPosition() {
            return this.delegate.getEndPosition();
        }

        @Override
        public long getLineNumber() {
            return this.delegate.getLineNumber();
        }

        @Override
        public long getColumnNumber() {
            return this.delegate.getColumnNumber();
        }

        @Override
        public String getCode() {
            return this.delegate.getCode();
        }

        @Override
        public String getMessage(Locale locale) {
            return this.formatter.format(this.delegate, locale);
        }

        public String toString() {
            return this.delegate.toString();
        }

        JCDiagnostic getDelegate() {
            return this.delegate;
        }

        public static Diagnostic wrap(Diagnostic d, DiagnosticFormatter<JCDiagnostic> df) {
            Diagnostic diagnostic;
            if (d instanceof JCDiagnostic) {
                JCDiagnostic jd = (JCDiagnostic)d;
                diagnostic = new RichDiagnostic(jd, df);
            } else {
                diagnostic = d;
            }
            return diagnostic;
        }
    }

    static interface Convert<P, R> {
        public R run(P var1) throws Exception;
    }
}

