/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.customizer;

import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerApplication;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerCompile;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerJar;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerJavadoc;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerLibraries;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerRun;
import org.netbeans.modules.java.j2seproject.ui.customizer.CustomizerSources;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.spi.project.support.ant.ui.CustomizerUtilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class J2SECompositePanelProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String SOURCES = "Sources";
    static final String LIBRARIES = "Libraries";
    private static final String BUILD = "Build";
    private static final String JAR = "Jar";
    private static final String JAVADOC = "Javadoc";
    public static final String RUN = "Run";
    private static final String APPLICATION = "Application";
    private static final String LICENSE = "License";
    private String name;

    private J2SECompositePanelProvider(String name) {
        this.name = name;
    }

    @Override
    public ProjectCustomizer.Category createCategory(Lookup context) {
        ResourceBundle bundle = NbBundle.getBundle(CustomizerProviderImpl.class);
        ProjectCustomizer.Category toReturn = null;
        if (SOURCES.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create(SOURCES, bundle.getString("LBL_Config_Sources"), null, new ProjectCustomizer.Category[0]);
        } else if (LIBRARIES.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create(LIBRARIES, bundle.getString("LBL_Config_Libraries"), null, new ProjectCustomizer.Category[0]);
        } else if (BUILD.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create(BUILD, bundle.getString("LBL_Config_Build"), null, new ProjectCustomizer.Category[0]);
        } else if (JAR.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create(JAR, bundle.getString("LBL_Config_Jar"), null, new ProjectCustomizer.Category[0]);
        } else if (JAVADOC.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create(JAVADOC, bundle.getString("LBL_Config_Javadoc"), null, new ProjectCustomizer.Category[0]);
        } else if (LICENSE.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create(LICENSE, bundle.getString("LBL_Config_License"), null, new ProjectCustomizer.Category[0]);
        } else if (RUN.equals(this.name)) {
            boolean fxOverride = false;
            Project project = context.lookup(Project.class);
            if (project != null) {
                J2SEProject j2sepe = project.getLookup().lookup(J2SEProject.class);
                fxOverride = J2SEProjectUtil.isTrue(j2sepe.evaluator().getProperty("javafx.enabled"));
            }
            toReturn = fxOverride ? null : ProjectCustomizer.Category.create(RUN, bundle.getString("LBL_Config_Run"), null, new ProjectCustomizer.Category[0]);
        }
        assert (toReturn != null || RUN.equals(this.name)) : "No category for name:" + this.name;
        return toReturn;
    }

    @Override
    public JComponent createComponent(ProjectCustomizer.Category category, final Lookup context) {
        String nm = category.getName();
        final J2SEProjectProperties uiProps = context.lookup(J2SEProjectProperties.class);
        if (SOURCES.equals(nm)) {
            return new CustomizerSources(uiProps);
        }
        if (LIBRARIES.equals(nm)) {
            CustomizerProviderImpl.SubCategoryProvider prov = context.lookup(CustomizerProviderImpl.SubCategoryProvider.class);
            assert (prov != null) : "Assuming CustomizerProviderImpl.SubCategoryProvider in customizer context";
            return new CustomizerLibraries(uiProps, prov, category);
        }
        if (BUILD.equals(nm)) {
            return new CustomizerCompile(uiProps);
        }
        if (JAR.equals(nm)) {
            return new CustomizerJar(uiProps);
        }
        if (JAVADOC.equals(nm)) {
            return new CustomizerJavadoc(uiProps);
        }
        if (RUN.equals(nm)) {
            return new CustomizerRun(uiProps);
        }
        if (APPLICATION.equals(nm)) {
            return new CustomizerApplication(uiProps);
        }
        if (LICENSE.equals(nm)) {
            CustomizerUtilities.LicensePanelContentHandler handler = new CustomizerUtilities.LicensePanelContentHandler(){

                @Override
                public String getProjectLicenseLocation() {
                    return uiProps.LICENSE_PATH_VALUE;
                }

                @Override
                public String getGlobalLicenseName() {
                    return uiProps.LICENSE_NAME_VALUE;
                }

                @Override
                public FileObject resolveProjectLocation(@NonNull String path) {
                    J2SEProject project = context.lookup(J2SEProject.class);
                    String evaluated = uiProps.getEvaluator().evaluate(path);
                    return project.getAntProjectHelper().resolveFileObject(evaluated);
                }

                @Override
                public void setProjectLicenseLocation(@NullAllowed String newLocation) {
                    uiProps.LICENSE_PATH_VALUE = newLocation;
                }

                @Override
                public void setGlobalLicenseName(@NullAllowed String newName) {
                    uiProps.LICENSE_NAME_VALUE = newName;
                }

                @Override
                public String getDefaultProjectLicenseLocation() {
                    return "./nbproject/licenseheader.txt";
                }

                @Override
                public void setProjectLicenseContent(@NullAllowed String text) {
                    uiProps.CHANGED_LICENSE_PATH_CONTENT = text;
                }
            };
            return CustomizerUtilities.createLicenseHeaderCustomizerPanel(category, handler);
        }
        return new JPanel();
    }

    public static J2SECompositePanelProvider createSources() {
        return new J2SECompositePanelProvider(SOURCES);
    }

    public static J2SECompositePanelProvider createLibraries() {
        return new J2SECompositePanelProvider(LIBRARIES);
    }

    public static J2SECompositePanelProvider createBuild() {
        return new J2SECompositePanelProvider(BUILD);
    }

    public static J2SECompositePanelProvider createJar() {
        return new J2SECompositePanelProvider(JAR);
    }

    public static J2SECompositePanelProvider createJavadoc() {
        return new J2SECompositePanelProvider(JAVADOC);
    }

    public static J2SECompositePanelProvider createRun() {
        return new J2SECompositePanelProvider(RUN);
    }

    public static J2SECompositePanelProvider createApplication() {
        return new J2SECompositePanelProvider(APPLICATION);
    }

    public static J2SECompositePanelProvider createLicense() {
        return new J2SECompositePanelProvider(LICENSE);
    }
}

