/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.perf;

import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.NewArrayTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.ParameterizedTypeTree;
import jpt.sun.source.tree.ParenthesizedTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt.sun.source.util.Trees;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.ExecutableType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.Types;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.CreateElementUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.perf.Bundle;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.util.NbBundle;

public class Tiny {
    static final boolean SC_IGNORE_SUBSTRING_DEFAULT = true;
    static final String SC_IGNORE_SUBSTRING = "ignore.substring";
    private static final Set<Tree.Kind> KEEP_PARENTHESIS = EnumSet.of(Tree.Kind.MEMBER_SELECT);
    private static final Map<TypeKind, String[]> PARSE_METHODS = new EnumMap<TypeKind, String[]>(TypeKind.class);

    public static ErrorDescription stringConstructor(HintContext ctx) {
        TreePath original = ctx.getVariables().get("$original");
        if (ctx.getPreferences().getBoolean(SC_IGNORE_SUBSTRING, true) && (MatcherUtilities.matches(ctx, original, "$str1.substring($s)", true) || MatcherUtilities.matches(ctx, original, "$str2.substring($s, $e)", true))) {
            TypeElement te;
            TreePath str;
            TreePath treePath = str = ctx.getVariables().get("$str1") != null ? ctx.getVariables().get("$str1") : ctx.getVariables().get("$str2");
            assert (str != null);
            TypeMirror type = ctx.getInfo().getTrees().getTypeMirror(str);
            if (type != null && type.getKind() == TypeKind.DECLARED && (te = (TypeElement)((DeclaredType)type).asElement()).getQualifiedName().contentEquals("java.lang.String")) {
                return null;
            }
        }
        String fixDisplayName = NbBundle.getMessage(Tiny.class, "FIX_StringConstructor");
        Fix f = JavaFixUtilities.rewriteFix(ctx, fixDisplayName, ctx.getPath(), "$original");
        String displayName = NbBundle.getMessage(Tiny.class, "ERR_StringConstructor");
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), displayName, f);
    }

    public static ErrorDescription stringEqualsEmpty(HintContext ctx) {
        Fix f;
        if (ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_6) >= 0) {
            String fixDisplayName = NbBundle.getMessage(Tiny.class, "FIX_StringEqualsEmpty16");
            f = JavaFixUtilities.rewriteFix(ctx, fixDisplayName, ctx.getPath(), "$string.isEmpty()");
        } else {
            boolean not = ctx.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.LOGICAL_COMPLEMENT;
            String fixDisplayName = NbBundle.getMessage(Tiny.class, not ? "FIX_StringEqualsEmptyNeg" : "FIX_StringEqualsEmpty");
            f = JavaFixUtilities.rewriteFix(ctx, fixDisplayName, not ? ctx.getPath().getParentPath() : ctx.getPath(), not ? "$string.length() != 0" : "$string.length() == 0");
        }
        String displayName = NbBundle.getMessage(Tiny.class, "ERR_StringEqualsEmpty");
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), displayName, f);
    }

    public static ErrorDescription lengthOneStringIndexOf(HintContext ctx) {
        TreePath toSearch = ctx.getVariables().get("$toSearch");
        if (toSearch.getLeaf().getKind() != Tree.Kind.STRING_LITERAL) {
            return null;
        }
        LiteralTree lt = (LiteralTree)toSearch.getLeaf();
        final String data = (String)lt.getValue();
        if (data.length() != 1) {
            return null;
        }
        int start = (int)ctx.getInfo().getTrees().getSourcePositions().getStartPosition(ctx.getInfo().getCompilationUnit(), toSearch.getLeaf());
        int end = (int)ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getInfo().getCompilationUnit(), toSearch.getLeaf());
        final String literal = ctx.getInfo().getText().substring(start, end);
        Fix f = new JavaFix(ctx.getInfo(), toSearch){

            @Override
            protected String getText() {
                return NbBundle.getMessage(Tiny.class, "FIX_LengthOneStringIndexOf");
            }

            @Override
            protected void performRewrite(JavaFix.TransformationContext ctx) {
                String content;
                WorkingCopy wc = ctx.getWorkingCopy();
                TreePath tp = ctx.getPath();
                if ("'".equals(data)) {
                    content = "\\'";
                } else if ("\"".equals(data)) {
                    content = "\"";
                } else {
                    content = literal;
                    if (content.length() > 0 && content.charAt(0) == '\"') {
                        content = content.substring(1);
                    }
                    if (content.length() > 0 && content.charAt(content.length() - 1) == '\"') {
                        content = content.substring(0, content.length() - 1);
                    }
                }
                wc.rewrite(tp.getLeaf(), wc.getTreeMaker().Identifier("'" + content + "'"));
            }
        }.toEditorFix();
        String displayName = NbBundle.getMessage(Tiny.class, "ERR_LengthOneStringIndexOf", literal);
        return ErrorDescriptionFactory.forTree(ctx, toSearch, displayName, f);
    }

    public static ErrorDescription getClassInsteadOfDotClass(HintContext ctx) {
        TreePath O = ctx.getVariables().get("$O");
        if (O.getLeaf().getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
            O = new TreePath(O, ((ParameterizedTypeTree)O.getLeaf()).getType());
        }
        ctx.getVariables().put("$OO", O);
        String fixDisplayName = NbBundle.getMessage(Tiny.class, "FIX_GetClassInsteadOfDotClass");
        Fix f = JavaFixUtilities.rewriteFix(ctx, fixDisplayName, ctx.getPath(), "$OO.class");
        String displayName = NbBundle.getMessage(Tiny.class, "ERR_GetClassInsteadOfDotClass");
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), displayName, f);
    }

    public static ErrorDescription constantIntern(HintContext ctx) {
        String target;
        TreePath str = ctx.getVariables().get("$str");
        TreePath constant = str.getLeaf().getKind() == Tree.Kind.PARENTHESIZED ? new TreePath(str, ((ParenthesizedTree)str.getLeaf()).getExpression()) : str;
        if (!Utilities.isConstantString(ctx.getInfo(), constant)) {
            return null;
        }
        String fixDisplayName = NbBundle.getMessage(Tiny.class, "FIX_ConstantIntern");
        if (constant != str && KEEP_PARENTHESIS.contains((Object)ctx.getPath().getParentPath().getLeaf().getKind())) {
            target = "$str";
        } else {
            target = "$constant";
            ctx.getVariables().put("$constant", constant);
        }
        Fix f = JavaFixUtilities.rewriteFix(ctx, fixDisplayName, ctx.getPath(), target);
        String displayName = NbBundle.getMessage(Tiny.class, "ERR_ConstantIntern");
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), displayName, f);
    }

    public static ErrorDescription enumSet(HintContext ctx) {
        return Tiny.enumHint(ctx, "java.util.Set", null, "ERR_Tiny_enumSet", new Fix[0]);
    }

    public static ErrorDescription enumMap(HintContext ctx) {
        Fix[] fixes;
        Collection<? extends TreePath> mvars = ctx.getMultiVariables().get("$params$");
        if (mvars != null && mvars.isEmpty()) {
            String displayName = NbBundle.getMessage(Tiny.class, "FIX_Tiny_enumMap");
            fixes = new Fix[]{JavaFixUtilities.rewriteFix(ctx, displayName, ctx.getPath(), "new java.util.EnumMap<$param, $to>($param.class)")};
        } else {
            fixes = new Fix[]{};
        }
        return Tiny.enumHint(ctx, "java.util.Map", "java.util.EnumMap", "ERR_Tiny_enumMap", fixes);
    }

    private static ErrorDescription enumHint(HintContext ctx, String baseName, String targetTypeName, String key, Fix ... fixes) {
        Element type = ctx.getInfo().getTrees().getElement(ctx.getVariables().get("$param"));
        if (type == null || type.getKind() != ElementKind.ENUM) {
            return null;
        }
        Element coll = ctx.getInfo().getTrees().getElement(ctx.getVariables().get("$coll"));
        if (coll == null || coll.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement base = ctx.getInfo().getElements().getTypeElement(baseName);
        if (base == null) {
            return null;
        }
        Types t = ctx.getInfo().getTypes();
        if (!t.isSubtype(t.erasure(coll.asType()), t.erasure(base.asType()))) {
            return null;
        }
        if (targetTypeName != null) {
            TypeElement target = ctx.getInfo().getElements().getTypeElement(targetTypeName);
            if (target == null) {
                return null;
            }
            if (t.isSubtype(t.erasure(coll.asType()), t.erasure(target.asType()))) {
                return null;
            }
            List<? extends TypeMirror> assignedTo = CreateElementUtilities.resolveType(EnumSet.noneOf(ElementKind.class), ctx.getInfo(), ctx.getPath().getParentPath(), ctx.getPath().getLeaf(), (int)ctx.getInfo().getTrees().getSourcePositions().getEndPosition(ctx.getPath().getCompilationUnit(), ctx.getPath().getLeaf()), new TypeMirror[1], new int[1]);
            if (assignedTo != null && assignedTo.size() == 1 && t.isSubtype(t.erasure(assignedTo.get(0)), t.erasure(coll.asType()))) {
                return null;
            }
        }
        String displayName = NbBundle.getMessage(Tiny.class, key);
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), displayName, fixes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ErrorDescription collectionsToArray(HintContext ctx) {
        Fix[] fixes;
        boolean pureMemberSelect = true;
        TreePath tp = ctx.getVariables().get("$collection");
        if (tp == null) {
            return null;
        }
        Tree msTest = tp.getLeaf();
        block4: while (true) {
            switch (msTest.getKind()) {
                case IDENTIFIER: {
                    break block4;
                }
                case MEMBER_SELECT: {
                    msTest = ((MemberSelectTree)msTest).getExpression();
                    continue block4;
                }
                default: {
                    pureMemberSelect = false;
                    break block4;
                }
            }
            break;
        }
        if (pureMemberSelect) {
            SourceVersion version = ctx.getInfo().getSourceVersion();
            TreePath type = ctx.getVariables().get("$clazz");
            String typeName = type.getLeaf().toString();
            if (version.compareTo(SourceVersion.RELEASE_11) >= 0) {
                String byRef = NbBundle.getMessage(Tiny.class, "FIX_Tiny_collectionsToArrayByMethodRef", typeName);
                fixes = new Fix[]{JavaFixUtilities.rewriteFix(ctx, byRef, ctx.getPath(), "$collection.toArray($clazz[]::new)")};
            } else {
                if (!Tiny.isNewArrayWithSize(type)) return null;
                String byZero = NbBundle.getMessage(Tiny.class, "FIX_Tiny_collectionsToArrayByZeroArray", typeName);
                fixes = new Fix[]{JavaFixUtilities.rewriteFix(ctx, byZero, ctx.getPath(), "$collection.toArray(new $clazz[0])")};
            }
        } else {
            fixes = new Fix[]{};
        }
        String displayName = NbBundle.getMessage(Tiny.class, "ERR_Tiny_collectionsToArray");
        return ErrorDescriptionFactory.forName(ctx, ctx.getPath(), displayName, fixes);
    }

    private static boolean isNewArrayWithSize(TreePath type) {
        Tree parent = type.getParentPath().getLeaf();
        if (parent instanceof NewArrayTree) {
            NewArrayTree newArrayTree = (NewArrayTree)parent;
            List<? extends ExpressionTree> dim = newArrayTree.getDimensions();
            return dim.isEmpty() ? false : dim.get(0).getKind() == Tree.Kind.METHOD_INVOCATION;
        }
        return false;
    }

    public static ErrorDescription redundantToString(HintContext ctx) {
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), Bundle.TEXT_RedundantToString(), JavaFixUtilities.rewriteFix(ctx, Bundle.FIX_RedundantToString(), ctx.getPath(), "$v"));
    }

    public static ErrorDescription unnecessaryTempFromString(HintContext ctx) {
        String method;
        String type;
        TypeMirror destType = Tiny.getDestinationType(ctx, ctx.getPath());
        TypeMirror srcType = ctx.getInfo().getTrees().getTypeMirror(ctx.getPath());
        if (srcType == null || destType == null) {
            return null;
        }
        if (destType.getKind().isPrimitive() && !srcType.getKind().isPrimitive()) {
            srcType = ctx.getInfo().getTypes().unboxedType(srcType);
            String[] replacement = PARSE_METHODS.get((Object)srcType.getKind());
            type = replacement[0];
            method = replacement[1];
        } else if (!destType.getKind().isPrimitive() && srcType.getKind().isPrimitive()) {
            type = PARSE_METHODS.get((Object)srcType.getKind())[0];
            method = "valueOf";
        } else {
            return null;
        }
        if (srcType.getKind() == TypeKind.BOOLEAN && ctx.getInfo().getSourceVersion().compareTo(SourceVersion.RELEASE_5) < 0) {
            return null;
        }
        Fix fix = JavaFixUtilities.rewriteFix(ctx, Bundle.FIX_UnnecessaryTempFromString1(type, method), ctx.getPath(), type + "." + method + "($v)");
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), Bundle.TEXT_UnnecessaryTempFromString(), fix);
    }

    private static TypeMirror getDestinationType(HintContext ctx, TreePath path) {
        TreePath parent = path.getParentPath();
        Tree parentLeaf = parent.getLeaf();
        Tree leaf = path.getLeaf();
        Trees trees = ctx.getInfo().getTrees();
        if (parentLeaf.getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree met = (MethodInvocationTree)parentLeaf;
            int index = met.getArguments().indexOf(leaf);
            return Tiny.paramTypeOfExecutable(trees.getTypeMirror(new TreePath(path, met.getMethodSelect())), index);
        }
        if (parentLeaf.getKind() == Tree.Kind.NEW_CLASS) {
            NewClassTree nct = (NewClassTree)parentLeaf;
            int index = nct.getArguments().indexOf(leaf);
            return Tiny.paramTypeOfExecutable(trees.getElement(new TreePath(path, nct)).asType(), index);
        }
        int pos = (int)trees.getSourcePositions().getStartPosition(path.getCompilationUnit(), leaf);
        List<? extends TypeMirror> type = CreateElementUtilities.resolveType(EnumSet.noneOf(ElementKind.class), ctx.getInfo(), parent, leaf, pos, new TypeMirror[1], new int[1]);
        if (type != null && !type.isEmpty()) {
            return type.get(0);
        }
        return null;
    }

    private static TypeMirror paramTypeOfExecutable(TypeMirror executable, int index) {
        List<? extends TypeMirror> paramTypes;
        if (index != -1 && executable != null && executable.getKind() == TypeKind.EXECUTABLE && (paramTypes = ((ExecutableType)executable).getParameterTypes()).size() > index) {
            return paramTypes.get(index);
        }
        return null;
    }

    public static ErrorDescription unnecessaryTypeToString(HintContext ctx) {
        TreePath vPath = ctx.getVariables().get("$v");
        TypeMirror resType = ctx.getInfo().getTrees().getTypeMirror(vPath);
        if (resType == null) {
            return null;
        }
        String[] arr = PARSE_METHODS.get((Object)resType.getKind());
        if (arr == null) {
            return null;
        }
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), Bundle.TEXT_UnnecessaryTempFromString(), JavaFixUtilities.rewriteFix(ctx, Bundle.FIX_UnnecessaryTempToString(arr[0]), ctx.getPath(), arr[0] + ".toString($v)"));
    }

    public static ErrorDescription boxedPrimitiveConstruction(HintContext ctx) {
        TypeMirror resType = ctx.getInfo().getTrees().getTypeMirror(ctx.getPath());
        if (resType == null) {
            return null;
        }
        return ErrorDescriptionFactory.forTree(ctx, ctx.getPath(), Bundle.TEXT_BoxedPrimitiveConstruction(), JavaFixUtilities.rewriteFix(ctx, Bundle.FIX_BoxedPrimitiveConstruction(resType), ctx.getPath(), resType + ".valueOf($v)"));
    }

    static {
        PARSE_METHODS.put(TypeKind.BOOLEAN, new String[]{"Boolean", "parseBoolean"});
        PARSE_METHODS.put(TypeKind.BYTE, new String[]{"Byte", "parseByte"});
        PARSE_METHODS.put(TypeKind.DOUBLE, new String[]{"Double", "parseDouble"});
        PARSE_METHODS.put(TypeKind.FLOAT, new String[]{"Float", "parseFloat"});
        PARSE_METHODS.put(TypeKind.INT, new String[]{"Integer", "parseInt"});
        PARSE_METHODS.put(TypeKind.LONG, new String[]{"Long", "parseLong"});
        PARSE_METHODS.put(TypeKind.SHORT, new String[]{"Short", "parseShort"});
    }
}

