/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.TokenSequence;

public final class TreeUtils {
    private static final Set<JavaTokenId> WHITESPACES = EnumSet.of(JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.JAVADOC_COMMENT);

    static boolean isConstructor(CompilationInfo info, TreePath path) {
        Element e = info.getTrees().getElement(path);
        return e != null && e.getKind() == ElementKind.CONSTRUCTOR;
    }

    public static boolean isParentOf(TreePath parent, TreePath path) {
        Tree parentLeaf = parent.getLeaf();
        while (path != null && path.getLeaf() != parentLeaf) {
            path = path.getParentPath();
        }
        return path != null;
    }

    static boolean isParentOf(TreePath parent, List<? extends TreePath> candidates) {
        for (TreePath treePath : candidates) {
            if (TreeUtils.isParentOf(parent, treePath)) continue;
            return false;
        }
        return true;
    }

    public static TreePath findClass(TreePath path) {
        while (path != null) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind())) {
                return path;
            }
            path = path.getParentPath();
        }
        return null;
    }

    static List<TreePath> findConstructors(CompilationInfo info, TreePath method) {
        LinkedList<TreePath> result = new LinkedList<TreePath>();
        TreePath parent = method.getParentPath();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)parent.getLeaf().getKind())) {
            for (Tree tree : ((ClassTree)parent.getLeaf()).getMembers()) {
                TreePath tp = new TreePath(parent, tree);
                if (!TreeUtils.isConstructor(info, tp)) continue;
                result.add(tp);
            }
        }
        return result;
    }

    static boolean isInAnnotationType(CompilationInfo info, TreePath path) {
        Element e = info.getTrees().getElement(path);
        if (e != null) {
            return (e = e.getEnclosingElement()) != null && e.getKind() == ElementKind.ANNOTATION_TYPE;
        }
        return false;
    }

    static int[] ignoreWhitespaces(CompilationInfo ci, int start, int end) {
        TokenSequence<JavaTokenId> ts = ci.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        if (ts == null) {
            return new int[]{start, end};
        }
        ts.move(start);
        if (ts.moveNext()) {
            boolean wasMoveNext = true;
            while (WHITESPACES.contains(ts.token().id()) && (wasMoveNext = ts.moveNext())) {
            }
            if (wasMoveNext && ts.offset() > start) {
                start = ts.offset();
            }
        }
        ts.move(end);
        while (ts.movePrevious() && WHITESPACES.contains(ts.token().id()) && ts.offset() < end) {
            end = ts.offset();
        }
        return new int[]{start, end};
    }

    static boolean isInsideClass(TreePath tp) {
        while (tp != null) {
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind())) {
                return true;
            }
            tp = tp.getParentPath();
        }
        return false;
    }

    static TreePath findStatementInBlock(TreePath statementPath) {
        return TreeUtils.findBlockOrStatement(statementPath, false);
    }

    static TreePath findStatement(TreePath statementPath) {
        return TreeUtils.findBlockOrStatement(statementPath, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    static TreePath findBlockOrStatement(TreePath statementPath, boolean statement) {
        while (statementPath != null) {
            Tree leaf = statementPath.getLeaf();
            if (statement && StatementTree.class.isAssignableFrom(leaf.getKind().asInterface())) {
                return statementPath;
            }
            if (statementPath.getParentPath() != null) {
                switch (statementPath.getParentPath().getLeaf().getKind()) {
                    case BLOCK: 
                    case CASE: 
                    case LAMBDA_EXPRESSION: {
                        return statementPath;
                    }
                }
            }
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)statementPath.getLeaf().getKind())) {
                return null;
            }
            statementPath = statementPath.getParentPath();
        }
        return statementPath;
    }

    static TreePath findMethod(TreePath path) {
        return TreeUtils.findMethod(path, false);
    }

    static TreePath findMethod(TreePath path, boolean methodOnly) {
        while (path != null) {
            Tree leaf = path.getLeaf();
            switch (leaf.getKind()) {
                case BLOCK: {
                    if (path.getParentPath() == null || !TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getParentPath().getLeaf().getKind())) break;
                    return path;
                }
                case LAMBDA_EXPRESSION: {
                    if (methodOnly) break;
                }
                case METHOD: {
                    return path;
                }
            }
            path = path.getParentPath();
        }
        return null;
    }
}

