/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.apache;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.eclipse.aether.spi.connector.transport.http.RFC9457.RFC9457Reporter;

public class ApacheRFC9457Reporter
extends RFC9457Reporter<CloseableHttpResponse, HttpResponseException> {
    public static final ApacheRFC9457Reporter INSTANCE = new ApacheRFC9457Reporter();

    private ApacheRFC9457Reporter() {
    }

    protected boolean isRFC9457Message(CloseableHttpResponse response) {
        Header[] headers = response.getHeaders("Content-Type");
        if (headers.length > 0) {
            String contentType = headers[0].getValue();
            return this.hasRFC9457ContentType(contentType);
        }
        return false;
    }

    protected int getStatusCode(CloseableHttpResponse response) {
        return response.getStatusLine().getStatusCode();
    }

    protected String getReasonPhrase(CloseableHttpResponse response) {
        String reasonPhrase = response.getStatusLine().getReasonPhrase();
        if (reasonPhrase == null || reasonPhrase.isEmpty()) {
            return "";
        }
        int statusCode = this.getStatusCode(response);
        return reasonPhrase + " (" + statusCode + ")";
    }

    protected String getBody(CloseableHttpResponse response) throws IOException {
        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
    }
}

