/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.deploy.impl;

import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterDescriptor;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.dispatch.DefaultDispatch;
import org.apache.knox.gateway.dispatch.GatewayDispatchFilter;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;

public class DispatchDeploymentContributor
extends ProviderDeploymentContributorBase {
    private static final String DISPATCH_IMPL_PARAM = "dispatch-impl";

    public String getRole() {
        return "dispatch";
    }

    public String getName() {
        return "http-client";
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
        FilterDescriptor filter = resource.addFilter().name(this.getName()).role(this.getRole()).impl(GatewayDispatchFilter.class);
        filter.param().name(DISPATCH_IMPL_PARAM).value(DefaultDispatch.class.getName());
        for (Map.Entry serviceParam : service.getParams().entrySet()) {
            filter.param().name((String)serviceParam.getKey()).value((String)serviceParam.getValue());
        }
        if (context.getGatewayConfig().isHadoopKerberosSecured()) {
            filter.param().name("kerberos").value("true");
        }
    }
}

