/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.juneau.collections.Args;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.FileUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.event.ConfigEventListener;
import org.apache.juneau.config.event.ConfigEvents;
import org.apache.juneau.config.store.ClasspathStore;
import org.apache.juneau.config.store.ConfigStore;
import org.apache.juneau.config.store.FileStore;
import org.apache.juneau.config.store.MemoryStore;
import org.apache.juneau.config.vars.ConfigVar;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.microservice.BasicMicroserviceListener;
import org.apache.juneau.microservice.LogConfig;
import org.apache.juneau.microservice.MicroserviceListener;
import org.apache.juneau.microservice.console.ConsoleCommand;
import org.apache.juneau.microservice.resources.LogEntryFormatter;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.svl.Var;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.vars.ManifestFileVar;
import org.apache.juneau.utils.ManifestFile;

public class Microservice
implements ConfigEventListener {
    private static volatile Microservice INSTANCE;
    final Messages messages = Messages.of(Microservice.class);
    private final Builder builder;
    private final Args args;
    private final Config config;
    private final ManifestFile manifest;
    private final VarResolver varResolver;
    private final MicroserviceListener listener;
    private final Map<String, ConsoleCommand> consoleCommandMap = new ConcurrentHashMap<String, ConsoleCommand>();
    private final boolean consoleEnabled;
    private final Scanner consoleReader;
    private final PrintWriter consoleWriter;
    private final Thread consoleThread;
    final File workingDir;
    private final String configName;
    private volatile Logger logger;

    public static Builder create() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Microservice getInstance() {
        Class<Microservice> clazz = Microservice.class;
        synchronized (Microservice.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInstance(Microservice m) {
        Class<Microservice> clazz = Microservice.class;
        synchronized (Microservice.class) {
            INSTANCE = m;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected Microservice(Builder builder) throws IOException, ParseException {
        Microservice.setInstance(this);
        this.builder = builder.copy();
        this.workingDir = builder.workingDir;
        this.configName = builder.configName;
        this.args = Utils.nn(builder.args) ? builder.args : new Args(new String[0]);
        ManifestFile manifest = builder.manifest;
        if (manifest == null) {
            Manifest m;
            block22: {
                m = new Manifest();
                File f = this.resolveFile("META-INF/MANIFEST.MF");
                if (f.exists() && f.canRead()) {
                    try (FileInputStream fis = new FileInputStream(f);){
                        m.read(fis);
                        break block22;
                    }
                    catch (IOException e) {
                        throw ThrowableUtils.ioex(e, "Problem detected in MANIFEST.MF.  Contents below:\n{0}", IoUtils.read(f), e);
                    }
                }
                URL url = this.getClass().getResource("META-INF/MANIFEST.MF");
                if (Utils.nn(url)) {
                    try {
                        m.read(url.openStream());
                    }
                    catch (IOException e) {
                        throw ThrowableUtils.ioex(e, "Problem detected in MANIFEST.MF.  Contents below:\n{0}", IoUtils.read(url.openStream()), e);
                    }
                }
            }
            manifest = new ManifestFile(m);
        }
        ManifestFileVar.init(manifest);
        this.manifest = manifest;
        Config config = builder.config;
        Config.Builder configBuilder = builder.configBuilder.varResolver((VarResolver)builder.varResolver.build()).store(MemoryStore.DEFAULT);
        if (config == null) {
            ConfigStore store = builder.configStore;
            FileStore cfs = this.workingDir == null ? FileStore.DEFAULT : FileStore.create().directory(this.workingDir).build();
            for (String name : this.getCandidateConfigNames()) {
                if (Utils.nn(store)) {
                    if (!store.exists(name)) continue;
                    configBuilder.store(store).name(name);
                    break;
                }
                if (cfs.exists(name)) {
                    configBuilder.store(cfs).name(name);
                    break;
                }
                if (!ClasspathStore.DEFAULT.exists(name)) continue;
                configBuilder.store(ClasspathStore.DEFAULT).name(name);
                break;
            }
            config = configBuilder.build();
        }
        this.config = config;
        Config.setSystemDefault(this.config);
        this.config.addListener(this);
        this.varResolver = (VarResolver)builder.varResolver.bean(Config.class, config).build();
        this.consoleEnabled = Utils.firstNonNull(builder.consoleEnabled, config.get("Console/enabled").asBoolean().orElse(false));
        if (this.consoleEnabled) {
            Console c = System.console();
            this.consoleReader = Utils.firstNonNull(builder.consoleReader, new Scanner(c == null ? new InputStreamReader(System.in) : c.reader()));
            this.consoleWriter = Utils.firstNonNull(builder.consoleWriter, c == null ? new PrintWriter(System.out, true) : c.writer());
            for (ConsoleCommand cc : builder.consoleCommands) {
                this.consoleCommandMap.put(cc.getName(), cc);
            }
            for (String s : config.get("Console/commands").asStringArray().orElse(new String[0])) {
                try {
                    ConsoleCommand cc = (ConsoleCommand)Class.forName(s).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.consoleCommandMap.put(cc.getName(), cc);
                }
                catch (Exception e) {
                    this.getConsoleWriter().println("Could not create console command '" + s + "', " + ThrowableUtils.lm(e));
                }
            }
            this.consoleThread = new Thread("ConsoleThread"){

                @Override
                public void run() {
                    Scanner in = Microservice.this.getConsoleReader();
                    PrintWriter out = Microservice.this.getConsoleWriter();
                    out.println(Microservice.this.messages.getString("ListOfAvailableCommands"));
                    for (ConsoleCommand cc : new TreeMap<String, ConsoleCommand>(Microservice.this.getConsoleCommands()).values()) {
                        out.append("\t").append(cc.getName()).append(" -- ").append(cc.getInfo()).println();
                    }
                    out.println();
                    while (true) {
                        out.append("> ").flush();
                        String line = in.nextLine();
                        Args args = new Args(line);
                        if (args.isEmpty()) continue;
                        Microservice.this.executeCommand(args, in, out);
                    }
                }
            };
            this.consoleThread.setDaemon(true);
        } else {
            this.consoleReader = null;
            this.consoleWriter = null;
            this.consoleThread = null;
        }
        this.listener = Utils.nn(builder.listener) ? builder.listener : new BasicMicroserviceListener();
        this.init();
    }

    public void err(Messages mb, String messageKey, Object ... args) {
        String msg = mb.getString(messageKey, args);
        if (this.consoleEnabled) {
            System.err.println(mb.getString(messageKey, args));
        }
        this.log(Level.SEVERE, msg, new Object[0]);
    }

    public boolean executeCommand(Args args, Scanner in, PrintWriter out) {
        ConsoleCommand cc = this.consoleCommandMap.get(args.getArg(0));
        if (cc == null) {
            out.println(this.messages.getString("UnknownCommand"));
        } else {
            try {
                return cc.execute(in, out, args);
            }
            catch (Exception e) {
                e.printStackTrace(out);
            }
        }
        return false;
    }

    public String executeCommand(String command, String input, Object ... args) {
        StringWriter sw = new StringWriter();
        List<Object> l = CollectionUtils.list(new Object[0]);
        l.add(command);
        for (Object a : args) {
            l.add(Utils.s(a));
        }
        Args args2 = new Args(l.toArray(new String[l.size()]));
        try (Scanner in = new Scanner(input);
             PrintWriter out = new PrintWriter(sw);){
            this.executeCommand(args2, in, out);
        }
        return sw.toString();
    }

    public void exit() throws Exception {
        try {
            this.stopConsole();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public Args getArgs() {
        return this.args;
    }

    public Config getConfig() {
        return this.config;
    }

    public final Map<String, ConsoleCommand> getConsoleCommands() {
        return this.consoleCommandMap;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ManifestFile getManifest() {
        return this.manifest;
    }

    public VarResolver getVarResolver() {
        return this.varResolver;
    }

    public synchronized Microservice init() throws IOException, ParseException {
        LogConfig logConfig;
        Set<String> spKeys = this.config.getKeys("SystemProperties");
        if (Utils.nn(spKeys)) {
            for (String key : spKeys) {
                System.setProperty(key, this.config.get("SystemProperties/" + key).orElse(null));
            }
        }
        this.logger = this.builder.logger;
        LogConfig logConfig2 = logConfig = Utils.nn(this.builder.logConfig) ? this.builder.logConfig : new LogConfig();
        if (this.logger == null) {
            LogManager.getLogManager().reset();
            this.logger = Logger.getLogger("");
            String logFile = Utils.firstNonNull(logConfig.logFile, this.config.get("Logging/logFile").orElse(null));
            if (Utils.ne(logFile)) {
                String logDir = Utils.firstNonNull(logConfig.logDir, this.config.get("Logging/logDir").orElse("."));
                File logDirFile = this.resolveFile(logDir);
                FileUtils.mkdirs(logDirFile, false);
                logDir = logDirFile.getAbsolutePath();
                System.setProperty("juneau.logDir", logDir);
                Boolean append = Utils.firstNonNull(logConfig.append, this.config.get("Logging/append").asBoolean().orElse(false));
                Integer limit = Utils.firstNonNull(logConfig.limit, this.config.get("Logging/limit").asInteger().orElse(0x100000));
                Integer count = Utils.firstNonNull(logConfig.count, this.config.get("Logging/count").asInteger().orElse(1));
                FileHandler fh = new FileHandler(logDir + "/" + logFile, limit, (int)count, (boolean)append);
                Formatter f = logConfig.formatter;
                if (f == null) {
                    String format = this.config.get("Logging/format").orElse("[{date} {level}] {msg}%n");
                    String dateFormat = this.config.get("Logging/dateFormat").orElse("yyyy.MM.dd hh:mm:ss");
                    Boolean useStackTraceHashes = this.config.get("Logging/useStackTraceHashes").asBoolean().orElse(false);
                    f = new LogEntryFormatter(format, dateFormat, useStackTraceHashes);
                }
                fh.setFormatter(f);
                fh.setLevel(Utils.firstNonNull(logConfig.fileLevel, this.config.get("Logging/fileLevel").as(Level.class).orElse(Level.INFO)));
                this.logger.addHandler(fh);
                ConsoleHandler ch = new ConsoleHandler();
                ch.setLevel(Utils.firstNonNull(logConfig.consoleLevel, this.config.get("Logging/consoleLevel").as(Level.class).orElse(Level.WARNING)));
                ch.setFormatter(f);
                this.logger.addHandler(ch);
            }
        }
        JsonMap loggerLevels = this.config.get("Logging/levels").as(JsonMap.class).orElseGet(JsonMap::new);
        for (String l : loggerLevels.keySet()) {
            Logger.getLogger(l).setLevel(loggerLevels.get(l, Level.class));
        }
        for (String l : logConfig.levels.keySet()) {
            Logger.getLogger(l).setLevel(logConfig.levels.get(l));
        }
        return this;
    }

    public Microservice join() throws Exception {
        return this;
    }

    public void kill() {
        System.exit(2);
    }

    @Override
    public void onConfigChange(ConfigEvents events) {
        this.listener.onConfigChange(this, events);
    }

    public void out(Messages mb, String messageKey, Object ... args) {
        String msg = mb.getString(messageKey, args);
        if (this.consoleEnabled) {
            this.getConsoleWriter().println(msg);
        }
        this.log(Level.INFO, msg, new Object[0]);
    }

    public synchronized Microservice start() throws Exception {
        if (this.config.getName() == null) {
            this.err(this.messages, "RunningClassWithoutConfig", this.getClass().getSimpleName());
        } else {
            this.out(this.messages, "RunningClassWithConfig", this.getClass().getSimpleName(), this.config.getName());
        }
        Runtime.getRuntime().addShutdownHook(new Thread("ShutdownHookThread"){

            @Override
            public void run() {
                try {
                    Microservice.this.stop();
                    Microservice.this.stopConsole();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.listener.onStart(this);
        return this;
    }

    public synchronized Microservice startConsole() throws Exception {
        if (Utils.nn(this.consoleThread) && !this.consoleThread.isAlive()) {
            this.consoleThread.start();
        }
        return this;
    }

    public Microservice stop() throws Exception {
        this.listener.onStop(this);
        return this;
    }

    public synchronized Microservice stopConsole() throws Exception {
        if (Utils.nn(this.consoleThread) && this.consoleThread.isAlive()) {
            this.consoleThread.interrupt();
        }
        return this;
    }

    private List<String> getCandidateConfigNames() {
        if (Utils.nn(this.configName)) {
            return Collections.singletonList(this.configName);
        }
        Args args = this.getArgs();
        if (this.getArgs().hasArg("configFile")) {
            return Collections.singletonList(args.getArg("configFile"));
        }
        ManifestFile manifest = this.getManifest();
        if (manifest.containsKey("Main-Config")) {
            return Collections.singletonList(manifest.getString("Main-Config"));
        }
        return Config.getCandidateSystemDefaultConfigNames();
    }

    protected Scanner getConsoleReader() {
        return this.consoleReader;
    }

    protected PrintWriter getConsoleWriter() {
        return this.consoleWriter;
    }

    protected void log(Level level, String message, Object ... args) {
        String msg = args.length == 0 ? message : Utils.f(message, args);
        this.getLogger().log(level, msg);
    }

    protected File resolveFile(String path) {
        if (Paths.get(path, new String[0]).isAbsolute()) {
            return new File(path);
        }
        if (Utils.nn(this.workingDir)) {
            return new File(this.workingDir, path);
        }
        return new File(path);
    }

    public static class Builder {
        Args args;
        ManifestFile manifest;
        Logger logger;
        LogConfig logConfig;
        Config config;
        String configName;
        ConfigStore configStore;
        Config.Builder configBuilder = Config.create();
        Boolean consoleEnabled;
        List<ConsoleCommand> consoleCommands = CollectionUtils.list(new ConsoleCommand[0]);
        VarResolver.Builder varResolver = VarResolver.create().defaultVars().vars(ConfigVar.class);
        Scanner consoleReader;
        PrintWriter consoleWriter;
        MicroserviceListener listener;
        File workingDir = System.getProperty("juneau.workingDir") == null ? null : new File(System.getProperty("juneau.workingDir"));

        protected Builder() {
        }

        protected Builder(Builder copyFrom) {
            this.args = copyFrom.args;
            this.manifest = copyFrom.manifest;
            this.logger = copyFrom.logger;
            this.configName = copyFrom.configName;
            this.logConfig = copyFrom.logConfig == null ? null : copyFrom.logConfig.copy();
            this.consoleEnabled = copyFrom.consoleEnabled;
            this.configBuilder = copyFrom.configBuilder;
            this.varResolver = copyFrom.varResolver;
            this.consoleReader = copyFrom.consoleReader;
            this.consoleWriter = copyFrom.consoleWriter;
            this.workingDir = copyFrom.workingDir;
        }

        public Builder args(Args args) {
            this.args = args;
            return this;
        }

        public Builder args(String ... args) {
            this.args = new Args(args);
            return this;
        }

        public Microservice build() throws Exception {
            return new Microservice(this);
        }

        public Builder config(Config config) {
            this.config = config;
            return this;
        }

        public Builder configName(String configName) {
            this.configName = configName;
            return this;
        }

        public Builder configStore(ConfigStore configStore) {
            this.configStore = configStore;
            return this;
        }

        public Builder console(Scanner consoleReader, PrintWriter consoleWriter) {
            this.consoleReader = consoleReader;
            this.consoleWriter = consoleWriter;
            return this;
        }

        public Builder consoleCommands(Class<? extends ConsoleCommand> ... consoleCommands) throws ExecutableException {
            try {
                for (Class<? extends ConsoleCommand> cc : consoleCommands) {
                    this.consoleCommands.add(cc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
            catch (Exception e) {
                throw new ExecutableException(e);
            }
            return this;
        }

        public Builder consoleCommands(ConsoleCommand ... consoleCommands) {
            CollectionUtils.addAll(this.consoleCommands, consoleCommands);
            return this;
        }

        public Builder consoleEnabled(boolean consoleEnabled) {
            this.consoleEnabled = consoleEnabled;
            return this;
        }

        public Builder copy() {
            return new Builder(this);
        }

        public Builder listener(MicroserviceListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder logConfig(LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder manifest(Object value) throws IOException {
            if (value == null) {
                this.manifest = null;
            } else if (value instanceof ManifestFile) {
                ManifestFile manifestFile;
                this.manifest = manifestFile = (ManifestFile)value;
            } else if (value instanceof Manifest) {
                Manifest manifest = (Manifest)value;
                this.manifest = new ManifestFile(manifest);
            } else if (value instanceof Reader) {
                Reader reader = (Reader)value;
                this.manifest = new ManifestFile(reader);
            } else if (value instanceof InputStream) {
                InputStream inputStream = (InputStream)value;
                this.manifest = new ManifestFile(inputStream);
            } else if (value instanceof File) {
                File file = (File)value;
                this.manifest = new ManifestFile(file);
            } else if (value instanceof Path) {
                Path path = (Path)value;
                this.manifest = new ManifestFile(path);
            } else if (value instanceof String) {
                String string = (String)value;
                this.manifest = new ManifestFile(this.resolveFile(string));
            } else if (value instanceof Class) {
                Class clazz = (Class)value;
                this.manifest = new ManifestFile(clazz);
            } else {
                throw ThrowableUtils.rex("Invalid type passed to Builder.manifest(Object).  Type=[{0}]", Utils.cn(value));
            }
            return this;
        }

        public <T> Builder varBean(Class<T> c, T value) {
            this.varResolver.bean(c, value);
            return this;
        }

        public Builder vars(Class<? extends Var> ... vars) {
            this.varResolver.vars(vars);
            return this;
        }

        public Builder workingDir(File workingDir) {
            this.workingDir = workingDir;
            return this;
        }

        public Builder workingDir(String workingDir) {
            this.workingDir = new File(workingDir);
            return this;
        }

        protected File resolveFile(String path) {
            if (Paths.get(path, new String[0]).isAbsolute()) {
                return new File(path);
            }
            if (Utils.nn(this.workingDir)) {
                return new File(this.workingDir, path);
            }
            return new File(path);
        }
    }
}

