/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.util.function.Consumer;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExtendedClassMeta;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.html.HtmlMetaProvider;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlFormat;

public class HtmlClassMeta
extends ExtendedClassMeta {
    private final boolean noTables;
    private final boolean noTableHeaders;
    private final HtmlFormat format;
    private final HtmlRender<?> render;

    public HtmlClassMeta(ClassMeta<?> cm, HtmlMetaProvider mp) {
        super(cm);
        Value noTables = Value.empty();
        Value noTableHeaders = Value.empty();
        Value format = Value.empty();
        Value render = Value.empty();
        Consumer<Html> c = x -> {
            if (x.noTables()) {
                noTables.set((Object)true);
            }
            if (x.noTableHeaders()) {
                noTableHeaders.set((Object)true);
            }
            if (x.format() != HtmlFormat.HTML) {
                format.set((Object)x.format());
            }
            if (x.render() != HtmlRender.class) {
                try {
                    render.set((Object)x.render().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw ThrowableUtils.toRex((Throwable)e);
                }
            }
        };
        cm.forEachAnnotation(Html.class, x -> true, c);
        this.noTables = (Boolean)noTables.orElse((Object)false);
        this.noTableHeaders = (Boolean)noTableHeaders.orElse((Object)false);
        this.render = (HtmlRender)render.orElse(null);
        this.format = (HtmlFormat)((Object)format.orElse((Object)HtmlFormat.HTML));
    }

    public HtmlRender<?> getRender() {
        return this.render;
    }

    public boolean isNoTableHeaders() {
        return this.noTableHeaders;
    }

    protected HtmlFormat getFormat() {
        return this.format;
    }

    protected boolean isHtml() {
        return this.format == HtmlFormat.HTML;
    }

    protected boolean isHtmlCdc() {
        return this.format == HtmlFormat.HTML_CDC;
    }

    protected boolean isHtmlSdc() {
        return this.format == HtmlFormat.HTML_SDC;
    }

    protected boolean isNoTables() {
        return this.noTables;
    }

    protected boolean isPlainText() {
        return this.format == HtmlFormat.PLAIN_TEXT;
    }

    protected boolean isXml() {
        return this.format == HtmlFormat.XML;
    }
}

