/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ConstructorInfo;
import org.apache.juneau.commons.reflect.ElementInfo;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.reflect.ExecutableInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;

public class BeanCreator<T> {
    private final BeanStore store;
    private ClassInfo type;
    private Object builder;
    private T impl;
    private boolean silent;

    public static <T> BeanCreator<T> of(Class<T> beanType) {
        return BeanStore.INSTANCE.createBean(beanType);
    }

    protected BeanCreator(Class<T> type, BeanStore store) {
        this.type = ReflectionUtils.info(type);
        this.store = BeanStore.of(store, store.outer.orElse(null));
    }

    public <T2> BeanCreator<T> arg(Class<T2> beanType, T2 bean) {
        this.store.add(beanType, bean);
        return this;
    }

    public <B> BeanCreator<T> builder(Class<B> type, B value) {
        this.builder = value;
        Class<?> t = value.getClass();
        do {
            this.store.add(t, value);
        } while (Utils.nn(t = t.getSuperclass()) && !t.equals(type));
        return this;
    }

    public Optional<T> execute() {
        return Utils.opt(this.silent().run());
    }

    public BeanCreator<T> impl(T value) {
        this.impl = value;
        return this;
    }

    public T orElse(T other) {
        return this.execute().orElse(other);
    }

    public T run() {
        Optional<Object> result;
        if (Utils.nn(this.impl)) {
            return this.impl;
        }
        if (this.type == null) {
            return null;
        }
        Value found = Value.empty();
        if (Utils.nn((Object)this.builder) && (result = this.type.getPublicMethod(x -> x.isStatic() && x.isNotDeprecated() && x.hasNumParameters(1) && x.getParameter(0).canAccept(this.builder) && x.hasReturnType(this.type) && !x.hasAnnotation(BeanIgnore.class) && x.hasName("getInstance")).map(m -> m.invoke(null, new Object[]{this.builder}))).isPresent()) {
            return (T)result.get();
        }
        if (this.builder == null && (result = this.type.getPublicMethod(x -> x.isStatic() && x.isNotDeprecated() && x.getParameterCount() == 0 && x.hasReturnType(this.type) && !x.hasAnnotation(BeanIgnore.class) && x.hasName("getInstance")).map(m -> m.invoke(null, new Object[0]))).isPresent()) {
            return (T)result.get();
        }
        if (this.builder == null) {
            Match match = new Match();
            this.type.getPublicMethods().stream().filter(x -> this.isStaticCreateMethod((MethodInfo)x)).forEach(x -> {
                found.set((Object)"STATIC_CREATOR");
                if (this.hasAllParams((ExecutableInfo)x)) {
                    match.add(x);
                }
            });
            if (match.isPresent()) {
                return (T)((MethodInfo)match.get()).invoke(null, this.getParams((ExecutableInfo)match.get()));
            }
        }
        if (this.type.isInterface()) {
            if (this.silent) {
                return null;
            }
            throw new ExecutableException("Could not instantiate class {0}: {1}.", new Object[]{this.type.getName(), "Class is an interface"});
        }
        if (this.type.isAbstract()) {
            if (this.silent) {
                return null;
            }
            throw new ExecutableException("Could not instantiate class {0}: {1}.", new Object[]{this.type.getName(), "Class is abstract"});
        }
        Match constructorMatch = new Match();
        this.type.getPublicConstructors().stream().forEach(x -> {
            found.setIfEmpty((Object)"PUBLIC_CONSTRUCTOR");
            if (this.hasAllParams((ExecutableInfo)x)) {
                constructorMatch.add(x);
            }
        });
        if (!constructorMatch.isPresent()) {
            this.type.getDeclaredConstructors().stream().filter(ElementInfo::isProtected).forEach(x -> {
                found.setIfEmpty((Object)"PROTECTED_CONSTRUCTOR");
                if (this.hasAllParams((ExecutableInfo)x)) {
                    constructorMatch.add(x);
                }
            });
        }
        if (constructorMatch.isPresent()) {
            return (T)((ConstructorInfo)constructorMatch.get()).newInstance(this.getParams((ExecutableInfo)constructorMatch.get()));
        }
        if (this.builder == null) {
            Value value = Value.empty();
            this.type.getDeclaredConstructors().stream().filter(x -> x.hasNumParameters(1) && x.isVisible(Visibility.PROTECTED)).forEach(x -> {
                Class pt = x.getParameter(0).getParameterType().inner();
                this.type.getPublicMethod(y -> BeanCreator.isStaticCreateMethod(y, pt)).ifPresent(m -> {
                    Object b = m.invoke(null, new Object[0]);
                    value.set(x.accessible().newInstance(new Object[]{b}));
                });
            });
            if (value.isPresent()) {
                return (T)value.get();
            }
        }
        if (this.silent) {
            return null;
        }
        Object msg = null;
        msg = found.isEmpty() ? "No public/protected constructors found" : (((String)found.get()).equals("STATIC_CREATOR") ? "Static creator found but could not find prerequisites: " + this.type.getPublicMethods().stream().filter(x -> this.isStaticCreateMethod((MethodInfo)x)).map(x -> this.getMissingParams((ExecutableInfo)x)).sorted().collect(Collectors.joining(" or ")) : (((String)found.get()).equals("PUBLIC_CONSTRUCTOR") ? "Public constructor found but could not find prerequisites: " + this.type.getPublicConstructors().stream().map(x -> this.getMissingParams((ExecutableInfo)x)).sorted().collect(Collectors.joining(" or ")) : "Protected constructor found but could not find prerequisites: " + this.type.getDeclaredConstructors().stream().filter(ElementInfo::isProtected).map(x -> this.getMissingParams((ExecutableInfo)x)).sorted().collect(Collectors.joining(" or "))));
        throw new ExecutableException("Could not instantiate class {0}: {1}.", new Object[]{this.type.getName(), msg});
    }

    public BeanCreator<T> silent() {
        this.silent = true;
        return this;
    }

    public Supplier<T> supplier() {
        return () -> this.run();
    }

    public BeanCreator<T> type(Class<?> value) {
        this.type = Utils.opt(value).map(x -> ReflectionUtils.info((Class)x)).orElse(null);
        return this;
    }

    public BeanCreator<T> type(ClassInfo value) {
        return this.type(value == null ? null : value.inner());
    }

    private String getMissingParams(ExecutableInfo ei) {
        return this.store.getMissingParams(ei);
    }

    private Object[] getParams(ExecutableInfo ei) {
        return this.store.getParams(ei);
    }

    private boolean hasAllParams(ExecutableInfo ei) {
        return this.store.hasAllParams(ei);
    }

    private boolean isStaticCreateMethod(MethodInfo m) {
        return BeanCreator.isStaticCreateMethod(m, this.type.inner());
    }

    private static boolean isStaticCreateMethod(MethodInfo m, Class<?> type) {
        return m.isStatic() && m.isNotDeprecated() && m.hasReturnType(type) && !m.hasAnnotation(BeanIgnore.class) && (m.hasName("create") || m.hasName("builder"));
    }

    static class Match<T extends ExecutableInfo> {
        T executable = null;
        int numMatches = -1;

        Match() {
        }

        void add(T ei) {
            if (ei.getParameterCount() > this.numMatches) {
                this.numMatches = ei.getParameterCount();
                this.executable = ei.accessible();
            }
        }

        T get() {
            return this.executable;
        }

        boolean isPresent() {
            return Utils.nn(this.executable);
        }
    }
}

