/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriContext;
import org.apache.juneau.commons.lang.Flag;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.httppart.HttpPartDataType;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.reflect.Mutaters;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.swap.ObjectSwap;
import org.apache.juneau.uon.ParamFormat;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.uon.UonUtils;
import org.apache.juneau.uon.UonWriter;

public class UonSerializerSession
extends WriterSerializerSession
implements HttpPartSerializerSession {
    private final UonSerializer ctx;
    private final boolean plainTextParams;

    public static Builder create(UonSerializer ctx) {
        return new Builder(AssertionUtils.assertArgNotNull("ctx", ctx));
    }

    public UonSerializerSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
        this.plainTextParams = this.ctx.getParamFormat() == ParamFormat.PLAINTEXT;
    }

    @Override
    public String serialize(HttpPartType type, HttpPartSchema schema, Object value) throws SerializeException, SchemaValidationException {
        try {
            ClassMeta<Object> cm = this.getClassMetaForObject(value);
            if (Utils.nn(cm) && (schema == null || schema.getType() == HttpPartDataType.NO_TYPE)) {
                String s;
                if (cm.isNumber() || cm.isBoolean()) {
                    return Mutaters.toString(value);
                }
                if (cm.isString() && ((s = Mutaters.toString(value)).isEmpty() || !UonUtils.needsQuotes(s))) {
                    return s;
                }
            }
            StringWriter w = new StringWriter();
            this.serializeAnything(this.getUonWriter(w).i(this.getInitialDepth()), value, this.getExpectedRootType(value), "root", null);
            return w.toString();
        }
        catch (Exception e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    private final UonWriter getUonWriter(Writer out) throws Exception {
        return new UonWriter(this, out, this.isUseWhitespace(), this.getMaxIndent(), this.isEncoding(), this.isTrimStrings(), this.plainTextParams, this.getQuoteChar(), this.getUriResolver());
    }

    private SerializerWriter serializeBeanMap(UonWriter out, BeanMap<?> m, String typeName) throws SerializeException {
        if (!this.plainTextParams) {
            out.append('(');
        }
        Flag addComma = Flag.create();
        if (Utils.nn(typeName)) {
            BeanPropertyMeta pm = m.getMeta().getTypeProperty();
            out.cr(this.indent).appendObject(pm.getName(), false).append('=').appendObject(typeName, false);
            addComma.set();
        }
        Predicate<Object> checkNull = x -> this.isKeepNullProperties() || Utils.nn(x);
        m.forEachValue(checkNull, (pMeta, key, value, thrown) -> {
            ClassMeta<?> cMeta = pMeta.getClassMeta();
            if (Utils.nn(thrown)) {
                this.onBeanGetterException((BeanPropertyMeta)pMeta, (Throwable)thrown);
            }
            if (this.canIgnoreValue(cMeta, (String)key, value)) {
                return;
            }
            addComma.ifSet(() -> out.append(',')).set();
            out.cr(this.indent).appendObject(key, false).append('=');
            this.serializeAnything(out, value, cMeta, (String)key, (BeanPropertyMeta)pMeta);
        });
        if (m.size() > 0) {
            out.cre(this.indent - 1);
        }
        if (!this.plainTextParams) {
            out.append(')');
        }
        return out;
    }

    private SerializerWriter serializeCollection(UonWriter out, Collection c, ClassMeta<?> type) throws SerializeException {
        ClassMeta<?> elementType = type.getElementType();
        if (!this.plainTextParams) {
            out.append('@').append('(');
        }
        Flag addComma = Flag.create();
        this.forEachEntry(c, (E x) -> {
            addComma.ifSet(() -> out.append(',')).set();
            out.cr(this.indent);
            this.serializeAnything(out, x, elementType, "<iterator>", null);
        });
        addComma.ifSet(() -> out.cre(this.indent - 1));
        if (!this.plainTextParams) {
            out.append(')');
        }
        return out;
    }

    private SerializerWriter serializeMap(UonWriter out, Map m, ClassMeta<?> type) throws SerializeException {
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        if (!this.plainTextParams) {
            out.append('(');
        }
        Flag addComma = Flag.create();
        this.forEachEntry(m, (Map.Entry<K, V> x) -> {
            addComma.ifSet(() -> out.append(',')).set();
            Object value = x.getValue();
            Object key = this.generalize(x.getKey(), keyType);
            out.cr(this.indent).appendObject(key, false).append('=');
            this.serializeAnything(out, value, valueType, this.toString(key), null);
        });
        addComma.ifSet(() -> out.cre(this.indent - 1));
        if (!this.plainTextParams) {
            out.append(')');
        }
        return out;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        this.serializeAnything(this.getUonWriter(out).i(this.getInitialDepth()), o, this.getExpectedRootType(o), "root", null);
    }

    protected final ParamFormat getParamFormat() {
        return this.ctx.getParamFormat();
    }

    @Override
    protected final char getQuoteChar() {
        return this.ctx.getQuoteChar();
    }

    protected final UonWriter getUonWriter(SerializerPipe out) throws IOException {
        Object output = out.getRawOutput();
        if (output instanceof UonWriter) {
            UonWriter output2 = (UonWriter)output;
            return output2;
        }
        UonWriter w = new UonWriter(this, out.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.isEncoding(), this.isTrimStrings(), this.plainTextParams, this.getQuoteChar(), this.getUriResolver());
        out.setWriter(w);
        return w;
    }

    @Override
    protected final boolean isAddBeanTypes() {
        return this.ctx.isAddBeanTypes();
    }

    protected final boolean isEncoding() {
        return this.ctx.isEncoding();
    }

    protected SerializerWriter serializeAnything(UonWriter out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta) throws SerializeException {
        boolean isRecursion;
        if (o == null) {
            out.appendObject(null, false);
            return out;
        }
        if (eType == null) {
            eType = this.object();
        }
        ClassMeta<Object> aType = null;
        ClassMeta<Object> sType = null;
        aType = this.push2(attrName, o, eType);
        boolean bl = isRecursion = aType == null;
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        if (UonSerializerSession.isOptional(aType)) {
            o = this.getOptionalValue(o);
            eType = this.getOptionalType(eType);
            aType = this.getClassMetaForObject(o, this.object());
        }
        sType = aType;
        String typeName = this.getBeanTypeName(this, eType, aType, pMeta);
        ObjectSwap<Object, ?> swap = aType.getSwap(this);
        if (Utils.nn(swap)) {
            o = this.swap(swap, o);
            sType = swap.getSwapClassMeta(this);
            if (sType.isObject()) {
                sType = this.getClassMetaForObject(o);
            }
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.appendObject(null, false);
        } else if (sType.isBoolean()) {
            out.appendBoolean(o);
        } else if (sType.isNumber()) {
            out.appendNumber(o);
        } else if (sType.isBean()) {
            this.serializeBeanMap(out, this.toBeanMap(o), typeName);
        } else if (sType.isUri() || Utils.nn(pMeta) && pMeta.isUri()) {
            out.appendUri(o);
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(out, (BeanMap)o, typeName);
            } else {
                this.serializeMap(out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(out, (Collection)o, eType);
        } else if (sType.isArray()) {
            this.serializeCollection(out, UonSerializerSession.toList(sType.inner(), o), eType);
        } else if (sType.isReader()) {
            IoUtils.pipe((Reader)o, (Writer)out, x$0 -> SerializerSession.handleThrown(x$0));
        } else if (sType.isInputStream()) {
            IoUtils.pipe((InputStream)o, (Writer)out, x$0 -> SerializerSession.handleThrown(x$0));
        } else {
            out.appendObject(o, false);
        }
        if (!isRecursion) {
            this.pop();
        }
        return out;
    }

    public static class Builder
    extends WriterSerializerSession.Builder {
        private UonSerializer ctx;

        protected Builder(UonSerializer ctx) {
            super(AssertionUtils.assertArgNotNull("ctx", ctx));
            this.ctx = ctx;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public UonSerializerSession build() {
            return new UonSerializerSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder useWhitespace(Boolean value) {
            super.useWhitespace(value);
            return this;
        }
    }
}

