/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.Context;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Visibility;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.html.AnchorText;
import org.apache.juneau.html.AsideFloat;
import org.apache.juneau.html.BasicHtmlDocTemplate;
import org.apache.juneau.html.HtmlDocSerializerSession;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.html.HtmlSchemaDocSerializer;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlStrippedDocSerializer;
import org.apache.juneau.html.HtmlWidget;
import org.apache.juneau.html.HtmlWidgetMap;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.utils.HashKey;
import org.apache.juneau.utils.ThrowingFunction;
import org.apache.juneau.xml.Namespace;

public class HtmlDocSerializer
extends HtmlStrippedDocSerializer {
    private static final String[] EMPTY_ARRAY = new String[0];
    public static final HtmlDocSerializer DEFAULT = new HtmlDocSerializer(HtmlDocSerializer.create());
    final String[] style;
    final String[] stylesheet;
    final String[] script;
    final String[] navlinks;
    final String[] head;
    final String[] header;
    final String[] nav;
    final String[] aside;
    final String[] footer;
    final AsideFloat asideFloat;
    final String noResultsMessage;
    final boolean nowrap;
    final boolean resolveBodyVars;
    final Class<? extends HtmlDocTemplate> template;
    final List<Class<? extends HtmlWidget>> widgets;
    private final HtmlWidgetMap widgetMap;
    private final HtmlWidget[] widgetArray;
    private final HtmlDocTemplate templateBean;
    private volatile HtmlSchemaDocSerializer schemaSerializer;

    public static Builder create() {
        return new Builder();
    }

    public HtmlDocSerializer(Builder builder) {
        super(builder);
        this.style = builder.style != null ? this.toArray(builder.style) : EMPTY_ARRAY;
        this.stylesheet = builder.stylesheet != null ? this.toArray(builder.stylesheet) : EMPTY_ARRAY;
        this.script = builder.script != null ? this.toArray(builder.script) : EMPTY_ARRAY;
        this.head = builder.head != null ? this.toArray(builder.head) : EMPTY_ARRAY;
        this.header = builder.header != null ? this.toArray(builder.header) : EMPTY_ARRAY;
        this.nav = builder.nav != null ? this.toArray(builder.nav) : EMPTY_ARRAY;
        this.aside = builder.aside != null ? this.toArray(builder.aside) : EMPTY_ARRAY;
        this.footer = builder.footer != null ? this.toArray(builder.footer) : EMPTY_ARRAY;
        this.navlinks = builder.navlinks != null ? this.toArray(builder.navlinks) : EMPTY_ARRAY;
        this.asideFloat = builder.asideFloat;
        this.noResultsMessage = builder.noResultsMessage;
        this.nowrap = builder.nowrap;
        this.resolveBodyVars = builder.resolveBodyVars;
        this.template = builder.template;
        this.widgets = builder.widgets == null ? CollectionUtils.emptyList() : CollectionUtils.copyOf(builder.widgets);
        this.templateBean = this.newInstance(this.template);
        this.widgetMap = new HtmlWidgetMap();
        this.widgets.stream().map(this::newInstance).forEach(x -> this.widgetMap.append((HtmlWidget)x));
        this.widgetArray = CollectionUtils.array(this.widgetMap.values(), HtmlWidget.class);
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public HtmlDocSerializerSession.Builder createSession() {
        return HtmlDocSerializerSession.create(this);
    }

    @Override
    public HtmlDocSerializerSession getSession() {
        return this.createSession().build();
    }

    @Override
    public HtmlSerializer getSchemaSerializer() {
        if (this.schemaSerializer == null) {
            this.schemaSerializer = HtmlSchemaDocSerializer.create().beanContext(this.getBeanContext()).build();
        }
        return this.schemaSerializer;
    }

    protected final String[] getAside() {
        return this.aside;
    }

    protected final AsideFloat getAsideFloat() {
        return this.asideFloat;
    }

    protected final String[] getFooter() {
        return this.footer;
    }

    protected final String[] getHead() {
        return this.head;
    }

    protected final String[] getHeader() {
        return this.header;
    }

    protected final String[] getNav() {
        return this.nav;
    }

    protected final String[] getNavlinks() {
        return this.navlinks;
    }

    protected final String getNoResultsMessage() {
        return this.noResultsMessage;
    }

    protected final boolean isNowrap() {
        return this.nowrap;
    }

    protected final String[] getScript() {
        return this.script;
    }

    protected final String[] getStyle() {
        return this.style;
    }

    protected final String[] getStylesheet() {
        return this.stylesheet;
    }

    protected final HtmlDocTemplate getTemplate() {
        return this.templateBean;
    }

    protected final HtmlWidgetMap getWidgets() {
        return this.widgetMap;
    }

    protected final HtmlDocSerializer forEachWidget(Consumer<HtmlWidget> action) {
        for (HtmlWidget w : this.widgetArray) {
            action.accept(w);
        }
        return this;
    }

    private String[] toArray(List<String> x) {
        return x.toArray(new String[x.size()]);
    }

    private <T> T newInstance(Class<T> c) {
        try {
            return c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw ThrowableUtils.asRuntimeException(e);
        }
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap().append("header", this.header).append("nav", this.nav).append("navlinks", this.navlinks).append("aside", this.aside).append("asideFloat", (Object)this.asideFloat).append("footer", this.footer).append("style", this.style).append("head", this.head).append("stylesheet", this.stylesheet).append("nowrap", this.nowrap).append("template", this.template).append("noResultsMessage", this.noResultsMessage).append("widgets", this.widgets);
    }

    @FluentSetters
    public static class Builder
    extends HtmlStrippedDocSerializer.Builder {
        private static final Cache<HashKey, HtmlDocSerializer> CACHE = Cache.of(HashKey.class, HtmlDocSerializer.class).build();
        List<String> aside;
        List<String> footer;
        List<String> head;
        List<String> header;
        List<String> nav;
        List<String> navlinks;
        List<String> script;
        List<String> style;
        List<String> stylesheet;
        AsideFloat asideFloat;
        String noResultsMessage;
        boolean nowrap;
        boolean resolveBodyVars;
        Class<? extends HtmlDocTemplate> template;
        List<Class<? extends HtmlWidget>> widgets;
        private static final Pattern INDEXED_LINK_PATTERN = Pattern.compile("(?s)(\\S*)\\[(\\d+)\\]\\:(.*)");

        protected Builder() {
            this.produces("text/html");
            this.accept("text/html");
            this.asideFloat = AsideFloat.RIGHT;
            this.noResultsMessage = "<p>no results</p>";
            this.template = BasicHtmlDocTemplate.class;
        }

        protected Builder(HtmlDocSerializer copyFrom) {
            super(copyFrom);
            this.aside = Builder.copy(copyFrom.aside);
            this.footer = Builder.copy(copyFrom.footer);
            this.head = Builder.copy(copyFrom.head);
            this.header = Builder.copy(copyFrom.header);
            this.nav = Builder.copy(copyFrom.nav);
            this.navlinks = Builder.copy(copyFrom.navlinks);
            this.script = Builder.copy(copyFrom.script);
            this.style = Builder.copy(copyFrom.style);
            this.stylesheet = Builder.copy(copyFrom.stylesheet);
            this.asideFloat = copyFrom.asideFloat;
            this.noResultsMessage = copyFrom.noResultsMessage;
            this.nowrap = copyFrom.nowrap;
            this.resolveBodyVars = copyFrom.resolveBodyVars;
            this.template = copyFrom.template;
            this.widgets = Builder.copy(copyFrom.widgets);
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.aside = Builder.copy(copyFrom.aside);
            this.footer = Builder.copy(copyFrom.footer);
            this.head = Builder.copy(copyFrom.head);
            this.header = Builder.copy(copyFrom.header);
            this.nav = Builder.copy(copyFrom.nav);
            this.navlinks = Builder.copy(copyFrom.navlinks);
            this.script = Builder.copy(copyFrom.script);
            this.style = Builder.copy(copyFrom.style);
            this.stylesheet = Builder.copy(copyFrom.stylesheet);
            this.asideFloat = copyFrom.asideFloat;
            this.noResultsMessage = copyFrom.noResultsMessage;
            this.nowrap = copyFrom.nowrap;
            this.resolveBodyVars = copyFrom.resolveBodyVars;
            this.template = copyFrom.template;
            this.widgets = Builder.copy(copyFrom.widgets);
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public HtmlDocSerializer build() {
            return this.cache(CACHE).build(HtmlDocSerializer.class);
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of(new Object[]{super.hashKey(), this.aside, this.footer, this.head, this.header, this.nav, this.navlinks, this.script, this.style, this.stylesheet, this.asideFloat, this.noResultsMessage, this.nowrap, this.resolveBodyVars, this.template, this.widgets});
        }

        @FluentSetter
        public Builder aside(String ... value) {
            this.aside = this.merge(this.aside, value);
            return this;
        }

        public List<String> aside() {
            if (this.aside == null) {
                this.aside = CollectionUtils.list(new String[0]);
            }
            return this.aside;
        }

        @FluentSetter
        public Builder asideFloat(AsideFloat value) {
            this.asideFloat = value;
            return this;
        }

        @FluentSetter
        public Builder footer(String ... value) {
            this.footer = this.merge(this.footer, value);
            return this;
        }

        public List<String> footer() {
            if (this.footer == null) {
                this.footer = CollectionUtils.list(new String[0]);
            }
            return this.footer;
        }

        @FluentSetter
        public Builder head(String ... value) {
            this.head = this.merge(this.head, value);
            return this;
        }

        public List<String> head() {
            if (this.head == null) {
                this.head = CollectionUtils.list(new String[0]);
            }
            return this.head;
        }

        @FluentSetter
        public Builder header(String ... value) {
            this.header = this.merge(this.header, value);
            return this;
        }

        public List<String> header() {
            if (this.header == null) {
                this.header = CollectionUtils.list(new String[0]);
            }
            return this.header;
        }

        @FluentSetter
        public Builder nav(String ... value) {
            this.nav = this.merge(this.nav, value);
            return this;
        }

        public List<String> nav() {
            if (this.nav == null) {
                this.nav = CollectionUtils.list(new String[0]);
            }
            return this.nav;
        }

        @FluentSetter
        public Builder navlinks(String ... value) {
            this.navlinks = this.mergeNavLinks(this.navlinks, value);
            return this;
        }

        public List<String> navlinks() {
            if (this.navlinks == null) {
                this.navlinks = CollectionUtils.list(new String[0]);
            }
            return this.navlinks;
        }

        @FluentSetter
        public Builder noResultsMessage(String value) {
            this.noResultsMessage = value;
            return this;
        }

        @FluentSetter
        public Builder nowrap() {
            return this.nowrap(true);
        }

        @FluentSetter
        public Builder nowrap(boolean value) {
            this.nowrap = value;
            return this;
        }

        @FluentSetter
        public Builder resolveBodyVars() {
            return this.resolveBodyVars(true);
        }

        @FluentSetter
        public Builder resolveBodyVars(boolean value) {
            this.resolveBodyVars = value;
            return this;
        }

        @FluentSetter
        public Builder script(String ... value) {
            this.script = this.merge(this.script, value);
            return this;
        }

        public List<String> script() {
            if (this.script == null) {
                this.script = CollectionUtils.list(new String[0]);
            }
            return this.script;
        }

        @FluentSetter
        public Builder style(String ... value) {
            this.style = this.merge(this.style, value);
            return this;
        }

        public List<String> style() {
            if (this.style == null) {
                this.style = CollectionUtils.list(new String[0]);
            }
            return this.style;
        }

        @FluentSetter
        public Builder stylesheet(String ... value) {
            this.stylesheet = this.merge(this.stylesheet, value);
            return this;
        }

        public List<String> stylesheet() {
            if (this.stylesheet == null) {
                this.stylesheet = CollectionUtils.list(new String[0]);
            }
            return this.stylesheet;
        }

        @FluentSetter
        public Builder template(Class<? extends HtmlDocTemplate> value) {
            this.template = value;
            return this;
        }

        @FluentSetter
        public Builder widgets(Class<? extends HtmlWidget> ... values) {
            CollectionUtils.addAll(this.widgets(), values);
            return this;
        }

        public List<Class<? extends HtmlWidget>> widgets() {
            if (this.widgets == null) {
                this.widgets = CollectionUtils.list(new Class[0]);
            }
            return this.widgets;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations((Class[])fromClasses);
            return this;
        }

        @Override
        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        @Override
        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        @Override
        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        @Override
        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        @Override
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        @Override
        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        @Override
        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties((Map)values);
            return this;
        }

        @Override
        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        @Override
        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        @Override
        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn((Class)on, (Class[])values);
            return this;
        }

        @Override
        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        @Override
        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        @Override
        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        @Override
        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @Override
        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example((Class)pojoClass, (Object)o);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example((Class)pojoClass, json);
            return this;
        }

        @Override
        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        @Override
        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters((Class)on);
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        @Override
        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        @Override
        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass((Class)interfaceClass, (Class)implClass);
            return this;
        }

        @Override
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses((Map)values);
            return this;
        }

        @Override
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        @Override
        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        @Override
        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        @Override
        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction, (ThrowingFunction)unswapFunction);
            return this;
        }

        @Override
        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder typeName(Class<?> on, String value) {
            super.typeName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        @Override
        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName((Class)on, value);
            return this;
        }

        @Override
        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        @Override
        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }

        @Override
        public Builder detectRecursions() {
            super.detectRecursions();
            return this;
        }

        @Override
        public Builder detectRecursions(boolean value) {
            super.detectRecursions(value);
            return this;
        }

        @Override
        public Builder ignoreRecursions() {
            super.ignoreRecursions();
            return this;
        }

        @Override
        public Builder ignoreRecursions(boolean value) {
            super.ignoreRecursions(value);
            return this;
        }

        @Override
        public Builder initialDepth(int value) {
            super.initialDepth(value);
            return this;
        }

        @Override
        public Builder maxDepth(int value) {
            super.maxDepth(value);
            return this;
        }

        @Override
        public Builder accept(String value) {
            super.accept(value);
            return this;
        }

        @Override
        public Builder addBeanTypes() {
            super.addBeanTypes();
            return this;
        }

        @Override
        public Builder addBeanTypes(boolean value) {
            super.addBeanTypes(value);
            return this;
        }

        @Override
        public Builder addRootType() {
            super.addRootType();
            return this;
        }

        @Override
        public Builder addRootType(boolean value) {
            super.addRootType(value);
            return this;
        }

        @Override
        public Builder keepNullProperties() {
            super.keepNullProperties();
            return this;
        }

        @Override
        public Builder keepNullProperties(boolean value) {
            super.keepNullProperties(value);
            return this;
        }

        @Override
        public Builder listener(Class<? extends SerializerListener> value) {
            super.listener((Class)value);
            return this;
        }

        @Override
        public Builder produces(String value) {
            super.produces(value);
            return this;
        }

        @Override
        public Builder sortCollections() {
            super.sortCollections();
            return this;
        }

        @Override
        public Builder sortCollections(boolean value) {
            super.sortCollections(value);
            return this;
        }

        @Override
        public Builder sortMaps() {
            super.sortMaps();
            return this;
        }

        @Override
        public Builder sortMaps(boolean value) {
            super.sortMaps(value);
            return this;
        }

        @Override
        public Builder trimEmptyCollections() {
            super.trimEmptyCollections();
            return this;
        }

        @Override
        public Builder trimEmptyCollections(boolean value) {
            super.trimEmptyCollections(value);
            return this;
        }

        @Override
        public Builder trimEmptyMaps() {
            super.trimEmptyMaps();
            return this;
        }

        @Override
        public Builder trimEmptyMaps(boolean value) {
            super.trimEmptyMaps(value);
            return this;
        }

        @Override
        public Builder trimStrings() {
            super.trimStrings();
            return this;
        }

        @Override
        public Builder trimStrings(boolean value) {
            super.trimStrings(value);
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder uriRelativity(UriRelativity value) {
            super.uriRelativity(value);
            return this;
        }

        @Override
        public Builder uriResolution(UriResolution value) {
            super.uriResolution(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder maxIndent(int value) {
            super.maxIndent(value);
            return this;
        }

        @Override
        public Builder quoteChar(char value) {
            super.quoteChar(value);
            return this;
        }

        @Override
        public Builder quoteCharOverride(char value) {
            super.quoteCharOverride(value);
            return this;
        }

        @Override
        public Builder sq() {
            super.sq();
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder useWhitespace() {
            super.useWhitespace();
            return this;
        }

        @Override
        public Builder useWhitespace(boolean value) {
            super.useWhitespace(value);
            return this;
        }

        @Override
        public Builder ws() {
            super.ws();
            return this;
        }

        @Override
        public Builder addBeanTypesXml() {
            super.addBeanTypesXml();
            return this;
        }

        @Override
        public Builder addBeanTypesXml(boolean value) {
            super.addBeanTypesXml(value);
            return this;
        }

        @Override
        public Builder addNamespaceUrisToRoot() {
            super.addNamespaceUrisToRoot();
            return this;
        }

        @Override
        public Builder addNamespaceUrisToRoot(boolean value) {
            super.addNamespaceUrisToRoot(value);
            return this;
        }

        @Override
        public Builder defaultNamespace(Namespace value) {
            super.defaultNamespace(value);
            return this;
        }

        @Override
        public Builder disableAutoDetectNamespaces() {
            super.disableAutoDetectNamespaces();
            return this;
        }

        @Override
        public Builder disableAutoDetectNamespaces(boolean value) {
            super.disableAutoDetectNamespaces(value);
            return this;
        }

        @Override
        public Builder enableNamespaces() {
            super.enableNamespaces();
            return this;
        }

        @Override
        public Builder enableNamespaces(boolean value) {
            super.enableNamespaces(value);
            return this;
        }

        @Override
        public Builder namespaces(Namespace ... values) {
            super.namespaces(values);
            return this;
        }

        @Override
        public Builder ns() {
            super.ns();
            return this;
        }

        @Override
        public Builder addBeanTypesHtml() {
            super.addBeanTypesHtml();
            return this;
        }

        @Override
        public Builder addBeanTypesHtml(boolean value) {
            super.addBeanTypesHtml(value);
            return this;
        }

        @Override
        public Builder addKeyValueTableHeaders() {
            super.addKeyValueTableHeaders();
            return this;
        }

        @Override
        public Builder addKeyValueTableHeaders(boolean value) {
            super.addKeyValueTableHeaders(value);
            return this;
        }

        @Override
        public Builder disableDetectLabelParameters() {
            super.disableDetectLabelParameters();
            return this;
        }

        @Override
        public Builder disableDetectLabelParameters(boolean value) {
            super.disableDetectLabelParameters(value);
            return this;
        }

        @Override
        public Builder disableDetectLinksInStrings() {
            super.disableDetectLinksInStrings();
            return this;
        }

        @Override
        public Builder disableDetectLinksInStrings(boolean value) {
            super.disableDetectLinksInStrings(value);
            return this;
        }

        @Override
        public Builder labelParameter(String value) {
            super.labelParameter(value);
            return this;
        }

        @Override
        public Builder uriAnchorText(AnchorText value) {
            super.uriAnchorText(value);
            return this;
        }

        private static <T> List<T> copy(List<T> s) {
            return s == null || s.isEmpty() ? null : CollectionUtils.copyOf(s);
        }

        private static <T> List<T> copy(T[] s) {
            return s.length == 0 ? null : CollectionUtils.list(s);
        }

        private List<String> merge(List<String> old, String[] newValues) {
            ArrayList<String> x = CollectionUtils.list(newValues.length);
            for (String s : newValues) {
                if ("NONE".equals(s)) {
                    if (old == null) continue;
                    old.clear();
                    continue;
                }
                if ("INHERIT".equals(s)) {
                    if (old == null) continue;
                    x.addAll(old);
                    continue;
                }
                x.add(s);
            }
            return x;
        }

        private List<String> mergeNavLinks(List<String> old, String[] newValues) {
            ArrayList<String> x = CollectionUtils.list(newValues.length);
            for (String s : newValues) {
                if ("NONE".equals(s)) {
                    if (old == null) continue;
                    old.clear();
                    continue;
                }
                if ("INHERIT".equals(s)) {
                    if (old == null) continue;
                    x.addAll(old);
                    continue;
                }
                if (s.indexOf(91) != -1 && INDEXED_LINK_PATTERN.matcher(s).matches()) {
                    Matcher lm = INDEXED_LINK_PATTERN.matcher(s);
                    lm.matches();
                    String key = lm.group(1);
                    int index = Math.min(x.size(), Integer.parseInt(lm.group(2)));
                    String remainder = lm.group(3);
                    x.add(index, (String)(key.isEmpty() ? remainder : key + ":" + remainder));
                    continue;
                }
                x.add(s);
            }
            return x;
        }
    }
}

