/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.json.JsonSerializer;

@FluentSetters
public abstract class OpenApiElement {
    private boolean strict;
    private Map<String, Object> extra;

    OpenApiElement() {
    }

    OpenApiElement(OpenApiElement copyFrom) {
        this.strict = copyFrom.strict;
        this.extra = copyFrom.extra == null ? null : new LinkedHashMap<String, Object>(copyFrom.extra);
    }

    protected boolean isStrict() {
        return this.strict;
    }

    protected OpenApiElement strict() {
        this.strict = true;
        return this;
    }

    protected OpenApiElement strict(Object value) {
        this.strict = value == null ? false : ConverterUtils.toBoolean((Object)value);
        return this;
    }

    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "strict": {
                return (T)ConverterUtils.toType((Object)this.isStrict(), type);
            }
        }
        return (T)ConverterUtils.toType((Object)this.get(property), type);
    }

    @Beanp(value="*")
    public Object get(String property) {
        if (property == null || this.extra == null) {
            return null;
        }
        return this.extra.get(property);
    }

    @Beanp(value="*")
    public OpenApiElement set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "strict": {
                return this.strict(value);
            }
        }
        if (this.extra == null) {
            this.extra = new LinkedHashMap<String, Object>();
        }
        this.extra.put(property, value);
        return this;
    }

    @Beanp(value="*")
    public Set<String> extraKeys() {
        return this.extra == null ? Collections.emptySet() : this.extra.keySet();
    }

    public Set<String> keySet() {
        Set s = CollectionUtils.setBuilder(String.class, (Type[])new Type[0]).addIf(this.strict, (Object)"strict").build();
        s.addAll(this.extraKeys());
        return s;
    }

    public JsonMap asMap() {
        JsonMap m = new JsonMap();
        for (String s : this.keySet()) {
            m.put(s, this.get(s, Object.class));
        }
        return m;
    }

    public String toString() {
        return JsonSerializer.DEFAULT.toString((Object)this);
    }
}

