/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.AsyncParserBuilder;
import org.apache.jena.riot.system.EltStreamRDF;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncParser {
    static final Logger LOG = LoggerFactory.getLogger(AsyncParser.class);
    static final ErrorHandler dftErrorHandler = AsyncParser.createDefaultErrorhandler(LOG);
    static final int dftChunkSize = 100000;
    static final int dftQueueSize = 10;
    static final List<EltStreamRDF> END = List.of();
    private static final StreamRDF alwaysFailingStreamRdf = new StreamToElements(elt -> {
        throw new RuntimeException(new InterruptedException());
    });
    private static final int RUNNING = 0;
    private static final int ABORTING = 1;
    private static final int STOPPED = 2;
    static Function<EltStreamRDF, Triple> elt2Triple = x -> {
        if (x.isException()) {
            AsyncParser.raiseException(x.exception());
        }
        if (x.isQuad()) {
            Quad quad = x.quad();
            Node g = quad.getGraph();
            if (g == Quad.tripleInQuad || Quad.isDefaultGraph(g)) {
                return quad.asTriple();
            }
            return null;
        }
        return x.triple();
    };
    static Function<EltStreamRDF, Quad> elt2Quad = x -> {
        if (x.isException()) {
            AsyncParser.raiseException(x.exception());
        }
        if (x.isTriple()) {
            return Quad.create(Quad.defaultGraphIRI, x.triple());
        }
        return x.quad();
    };

    private AsyncParser() {
    }

    public static void asyncParse(String fileOrURL, StreamRDF output) {
        AsyncParser.of(fileOrURL).asyncParseSources(output);
    }

    public static void asyncParse(List<String> filesOrURLs, StreamRDF output) {
        AsyncParser.ofLocations(filesOrURLs).asyncParseSources(output);
    }

    public static void asyncParse(InputStream input, Lang lang, String baseURI, StreamRDF output) {
        AsyncParser.of(input, lang, baseURI).asyncParseSources(output);
    }

    public static void asyncParseSources(List<RDFParserBuilder> sources, StreamRDF output) {
        AsyncParser.ofSources(sources).asyncParseSources(output);
    }

    public static IteratorCloseable<Triple> asyncParseTriples(String fileOrURL) {
        return AsyncParser.of(fileOrURL).asyncParseTriples();
    }

    public static IteratorCloseable<Triple> asyncParseTriples(List<String> filesOrURLs) {
        return AsyncParser.ofLocations(filesOrURLs).asyncParseTriples();
    }

    public static IteratorCloseable<Triple> asyncParseTriples(InputStream input, Lang lang, String baseURI) {
        return AsyncParser.of(input, lang, baseURI).asyncParseTriples();
    }

    public static IteratorCloseable<Quad> asyncParseQuads(String fileOrURL) {
        return AsyncParser.of(fileOrURL).asyncParseQuads();
    }

    public static IteratorCloseable<Quad> asyncParseQuads(List<String> filesOrURLs) {
        return AsyncParser.ofLocations(filesOrURLs).asyncParseQuads();
    }

    public static IteratorCloseable<Quad> asyncParseQuads(InputStream input, Lang lang, String baseURI) {
        return AsyncParser.of(input, lang, baseURI).asyncParseQuads();
    }

    public static AsyncParserBuilder of(String fileOrURL) {
        Objects.requireNonNull(fileOrURL);
        return AsyncParser.ofLocations(List.of(fileOrURL));
    }

    public static AsyncParserBuilder ofLocations(List<String> filesOrURLs) {
        Objects.requireNonNull(filesOrURLs);
        LOG.debug("Parse: " + String.valueOf(filesOrURLs));
        return new AsyncParserBuilder(AsyncParser.urlsToSource(filesOrURLs));
    }

    public static AsyncParserBuilder of(InputStream input, Lang lang, String baseURI) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(lang);
        return AsyncParser.ofSources(AsyncParser.inputStreamToSource(input, lang, baseURI));
    }

    public static AsyncParserBuilder of(RDFParserBuilder source) {
        Objects.requireNonNull(source);
        return AsyncParser.ofSources(Arrays.asList(source));
    }

    public static AsyncParserBuilder ofSources(List<RDFParserBuilder> sources) {
        Objects.requireNonNull(sources);
        return new AsyncParserBuilder(sources);
    }

    private static List<RDFParserBuilder> urlsToSource(List<String> filesOrURLs) {
        return filesOrURLs.stream().map(uriOrFile -> RDFParser.source(uriOrFile).errorHandler(dftErrorHandler)).toList();
    }

    private static List<RDFParserBuilder> inputStreamToSource(InputStream input, Lang lang, String baseURI) {
        return List.of(RDFParser.source(input).lang(lang).base(baseURI).errorHandler(dftErrorHandler));
    }

    private static void raiseException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            RuntimeException e2 = (RuntimeException)throwable;
            e2.addSuppressed(new RuntimeException("Encountered error element from parse thread"));
            throw e2;
        }
        throw new RuntimeException("Encountered error element from parse thread", throwable);
    }

    static <X> IteratorCloseable<X> blockingIterator(final Runnable closeAction, final BlockingQueue<X> queue, final Predicate<X> endTest) {
        return new IteratorSlotted<X>(){
            boolean ended = false;

            protected X moveToNext() {
                try {
                    Object x = null;
                    if (!this.ended) {
                        x = queue.take();
                    }
                    if (endTest.test(x)) {
                        this.ended = true;
                        return null;
                    }
                    return x;
                }
                catch (InterruptedException e2) {
                    this.ended = true;
                    return null;
                }
            }

            protected boolean hasMore() {
                return !this.ended;
            }

            protected void closeIterator() {
                closeAction.run();
            }
        };
    }

    static ErrorHandler createDefaultErrorhandler(final Logger LOG1) {
        return new ErrorHandler(){

            @Override
            public void warning(String message, long line, long col) {
                LOG1.warn(SysRIOT.fmtMessage(message, line, col));
            }

            @Override
            public void error(String message, long line, long col) {
                throw new RiotException(SysRIOT.fmtMessage(message, line, col));
            }

            @Override
            public void fatal(String message, long line, long col) {
                throw new RiotException(SysRIOT.fmtMessage(message, line, col));
            }
        };
    }

    static Runnable startParserThread(Logger logger, List<RDFParserBuilder> sources, BlockingQueue<List<EltStreamRDF>> queue, int chunkSize, Predicate<EltStreamRDF> prematureDispatch, boolean daemonMode) {
        Task task = new Task(sources, queue, chunkSize, prematureDispatch, logger);
        Thread parserThread = new Thread((Runnable)task, "AsyncParser");
        parserThread.setDaemon(daemonMode);
        parserThread.start();
        return () -> {
            task.abort();
            parserThread.interrupt();
            try {
                parserThread.join();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        };
    }

    private static void dispatch(EltStreamRDF elt, StreamRDF stream) {
        switch (elt.getType()) {
            case TRIPLE: {
                stream.triple(elt.triple());
                break;
            }
            case QUAD: {
                stream.quad(elt.quad());
                break;
            }
            case PREFIX: {
                stream.prefix(elt.prefix(), elt.iri());
                break;
            }
            case BASE: {
                stream.base(elt.iri());
                break;
            }
            case EXCEPTION: {
                AsyncParser.raiseException(elt.exception());
                break;
            }
            default: {
                throw new InternalErrorException("Bad EltStreamRDF");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void receiver(Runnable closeAction, Logger LOG2, BlockingQueue<List<EltStreamRDF>> queue, StreamRDF output) {
        int count = 0;
        try {
            while (true) {
                List<EltStreamRDF> batch;
                if ((batch = queue.take()) == END) {
                    FmtLog.debug((Logger)LOG2, (String)"Receive: END (%,d)", (Object[])new Object[]{count});
                    break;
                }
                count += batch.size();
                if (LOG.isDebugEnabled()) {
                    FmtLog.debug((Logger)LOG2, (String)"Receive: Batch : %,d (%,d)", (Object[])new Object[]{batch.size(), count});
                }
                AsyncParser.dispatch(batch, output);
            }
        }
        catch (InterruptedException e2) {
            FmtLog.error((Logger)LOG2, (Throwable)e2, (String)"Interrupted", (Object[])new Object[0]);
        }
        finally {
            closeAction.run();
        }
    }

    private static void dispatch(List<EltStreamRDF> batch, StreamRDF stream) {
        for (EltStreamRDF elt : batch) {
            AsyncParser.dispatch(elt, stream);
        }
    }

    private static class Task
    implements Runnable {
        private Logger logger;
        private List<RDFParserBuilder> sources;
        private BlockingQueue<List<EltStreamRDF>> queue;
        private int chunkSize;
        private Predicate<EltStreamRDF> prematureDispatch;
        private EltStreamBatcher<EltStreamRDF> batcher;
        private StreamRDF generatorStreamRdf;
        private AtomicInteger destinationState = new AtomicInteger(0);
        private boolean errorEncountered = false;

        public Task(List<RDFParserBuilder> sources, BlockingQueue<List<EltStreamRDF>> queue, int chunkSize, Predicate<EltStreamRDF> prematureDispatch, Logger logger) {
            this.sources = sources;
            this.queue = queue;
            this.chunkSize = chunkSize;
            this.prematureDispatch = prematureDispatch;
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.initDestination();
            try {
                this.start();
                int n = this.sources.size();
                for (int i = 0; i < n; ++i) {
                    RDFParserBuilder parser = this.sources.get(i);
                    this.parse(parser);
                }
            }
            finally {
                this.finish();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Finish parsing");
            }
        }

        public void abort() {
            this.destinationState.compareAndSet(0, 1);
        }

        private void initDestination() {
            Consumer destination = batch -> {
                if (this.destinationState.get() == 0) {
                    try {
                        this.queue.put((List<EltStreamRDF>)batch);
                    }
                    catch (InterruptedException ex) {
                        this.handleAbortingState();
                        throw new RuntimeException(ex);
                    }
                } else {
                    this.handleAbortingState();
                    throw new RuntimeException(new InterruptedException());
                }
            };
            Consumer<EltStreamRDF> eltSink = this.batcher = new EltStreamBatcher<EltStreamRDF>(destination, END, this.chunkSize);
            if (this.prematureDispatch != null) {
                eltSink = elt -> {
                    boolean dispatchImmediately = this.prematureDispatch.test((EltStreamRDF)elt);
                    this.batcher.accept((EltStreamRDF)elt);
                    if (dispatchImmediately) {
                        this.batcher.flush();
                    }
                };
            }
            this.generatorStreamRdf = new StreamToElements(eltSink);
        }

        private void start() {
            this.batcher.startBatching();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Start parsing");
            }
        }

        private void parse(RDFParserBuilder parser) {
            try {
                StreamRDF sink = this.errorEncountered ? alwaysFailingStreamRdf : this.generatorStreamRdf;
                parser.parse(sink);
            }
            catch (RuntimeException ex) {
                Throwable cause = ex.getCause();
                if (this.errorEncountered) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Suppressed exception", (Throwable)ex);
                    }
                } else {
                    if (cause instanceof InterruptedException) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Parsing was interrupted");
                        }
                    } else {
                        EltStreamRDF elt = EltStreamRDF.exception(ex);
                        this.batcher.accept(elt);
                    }
                    this.errorEncountered = true;
                }
            }
            catch (Throwable throwable) {
                if (this.errorEncountered) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Suppressed exception", throwable);
                    }
                }
                EltStreamRDF elt = EltStreamRDF.exception(new RuntimeException(throwable));
                this.batcher.accept(elt);
                this.errorEncountered = true;
            }
        }

        private void finish() {
            block10: {
                try {
                    if (this.destinationState.get() != 2) {
                        this.batcher.finishBatching();
                    }
                }
                catch (Throwable ex) {
                    if (this.errorEncountered) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Suppressed exception", ex);
                        }
                        break block10;
                    }
                    Throwable cause = ex.getCause();
                    if (cause instanceof InterruptedException) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Parsing was interrupted");
                        }
                        break block10;
                    }
                    throw new RuntimeException(ex);
                }
                finally {
                    this.destinationState.set(2);
                }
            }
        }

        private void handleAbortingState() {
            if (this.destinationState.compareAndSet(1, 2)) {
                while (true) {
                    try {
                        this.queue.clear();
                        this.queue.put(END);
                    }
                    catch (InterruptedException e2) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private static class StreamToElements
    implements StreamRDF {
        private final Consumer<EltStreamRDF> destination;

        public StreamToElements(Consumer<EltStreamRDF> destination) {
            this.destination = destination;
        }

        @Override
        public void start() {
        }

        @Override
        public void finish() {
        }

        @Override
        public void triple(Triple triple) {
            EltStreamRDF elt = EltStreamRDF.triple(triple);
            this.deliver(elt);
        }

        @Override
        public void quad(Quad quad) {
            EltStreamRDF elt = EltStreamRDF.quad(quad);
            this.deliver(elt);
        }

        @Override
        public void base(String base) {
            EltStreamRDF elt = EltStreamRDF.base(base);
            this.deliver(elt);
        }

        @Override
        public void prefix(String prefix, String iri) {
            EltStreamRDF elt = EltStreamRDF.prefix(prefix, iri);
            this.deliver(elt);
        }

        @Override
        public void version(String version2) {
        }

        private void deliver(EltStreamRDF elt) {
            this.destination.accept(elt);
        }
    }

    private static class EltStreamBatcher<T>
    implements Consumer<T> {
        private final int batchSize;
        private List<T> elements = null;
        private final Consumer<List<T>> batchDestination;
        private final List<T> endMarker;
        private int count = 0;

        public EltStreamBatcher(Consumer<List<T>> batchDestination, List<T> endMarker, int batchSize) {
            this.batchDestination = batchDestination;
            this.batchSize = batchSize;
            this.endMarker = endMarker;
        }

        public void startBatching() {
        }

        public void flush() {
            if (this.elements != null) {
                this.dispatch(this.elements);
                this.elements = null;
            }
        }

        public void finishBatching() {
            try {
                this.flush();
            }
            finally {
                this.dispatch(this.endMarker);
            }
        }

        private <X> boolean isEmpty(List<X> list) {
            return list == null || list.isEmpty();
        }

        @Override
        public void accept(T elt) {
            if (this.elements == null) {
                this.elements = this.allocChunk();
            }
            this.elements.add(elt);
            this.maybeDispatch();
        }

        private void maybeDispatch() {
            long x = this.elements.size();
            if (x < (long)this.batchSize) {
                return;
            }
            this.dispatch(this.elements);
            this.elements = null;
        }

        private void dispatch(List<T> batch) {
            this.count += batch.size();
            this.batchDestination.accept(batch);
        }

        private List<T> allocChunk() {
            return new ArrayList(this.batchSize);
        }
    }
}

