/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv.gc.io;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.pagememory.mv.HybridTimestamps;
import org.apache.ignite3.internal.storage.pagememory.mv.gc.GcRowVersion;

public interface GcIo {
    public static final int ROW_ID_MSB_OFFSET = 0;
    public static final int ROW_ID_LSB_OFFSET = 8;
    public static final int ROW_TIMESTAMP_OFFSET = 16;
    public static final int ROW_LINK_OFFSET = 24;
    public static final int SIZE_IN_BYTES = 30;

    public int offset(int var1);

    default public void store(long dstPageAddr, int dstIdx, BplusIo<GcRowVersion> srcIo, long srcPageAddr, int srcIdx) {
        int dstOffset = this.offset(dstIdx);
        int srcOffset = srcIo.offset(srcIdx);
        PageUtils.copyMemory(srcPageAddr, (long)srcOffset, dstPageAddr, (long)dstOffset, 30L);
    }

    default public void storeByOffset(long pageAddr, int off, GcRowVersion row) {
        RowId rowId = row.getRowId();
        PageUtils.putLong(pageAddr, off + 0, rowId.mostSignificantBits());
        PageUtils.putLong(pageAddr, off + 8, rowId.leastSignificantBits());
        HybridTimestamps.writeTimestampToMemory(pageAddr, off + 16, row.getTimestamp());
        PartitionlessLinks.writePartitionless(pageAddr + (long)off + 24L, row.getLink());
    }

    default public int compare(long pageAddr, int idx, GcRowVersion rowVersion) {
        int offset = this.offset(idx);
        HybridTimestamp readTimestamp = HybridTimestamps.readTimestamp(pageAddr, offset + 16);
        int cmp = readTimestamp.compareTo(rowVersion.getTimestamp());
        if (cmp != 0) {
            return cmp;
        }
        RowId rowId = rowVersion.getRowId();
        cmp = Long.compare(PageUtils.getLong(pageAddr, offset + 0), rowId.mostSignificantBits());
        if (cmp != 0) {
            return cmp;
        }
        return Long.compare(PageUtils.getLong(pageAddr, offset + 8), rowId.leastSignificantBits());
    }

    default public GcRowVersion getRow(long pageAddr, int idx, int partitionId) {
        int offset = this.offset(idx);
        long rowIdMsb = PageUtils.getLong(pageAddr, offset + 0);
        long rowIdLsb = PageUtils.getLong(pageAddr, offset + 8);
        return new GcRowVersion(new RowId(partitionId, rowIdMsb, rowIdLsb), HybridTimestamps.readTimestamp(pageAddr, offset + 16), PartitionlessLinks.readPartitionless(partitionId, pageAddr, offset + 24));
    }
}

