/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.index;

import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.index.IndexRow;
import org.apache.ignite3.internal.storage.index.IndexStorage;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.worker.ThreadAssertingCursor;
import org.apache.ignite3.internal.worker.ThreadAssertions;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.jetbrains.annotations.Nullable;

abstract class ThreadAssertingIndexStorage
implements IndexStorage,
Wrapper {
    private final IndexStorage indexStorage;

    ThreadAssertingIndexStorage(IndexStorage indexStorage) {
        this.indexStorage = indexStorage;
    }

    @Override
    public Cursor<RowId> get(BinaryTuple key) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingCursor<RowId>(this.indexStorage.get(key));
    }

    @Override
    public void put(IndexRow row) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.indexStorage.put(row);
    }

    @Override
    public void remove(IndexRow row) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.indexStorage.remove(row);
    }

    @Override
    @Nullable
    public RowId getNextRowIdToBuild() throws StorageException {
        return this.indexStorage.getNextRowIdToBuild();
    }

    @Override
    public void setNextRowIdToBuild(@Nullable RowId rowId) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.indexStorage.setNextRowIdToBuild(rowId);
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.indexStorage);
    }
}

